/*
 * Decompiled with CFR 0.152.
 */
package com.versioneye;

import com.versioneye.ProjectMojo;
import com.versioneye.dto.ProjectJsonResponse;
import com.versioneye.utils.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.jackson.map.ObjectMapper;

@Mojo(name="create", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CreateMojo
extends ProjectMojo {
    @Parameter(property="resource", defaultValue="/projects?api_key=")
    private String resource;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.prettyPrintStart();
            ByteArrayOutputStream jsonDirectDependenciesStream = this.getDirectDependenciesJsonStream();
            ProjectJsonResponse response = this.uploadDependencies(jsonDirectDependenciesStream);
            this.writeProperties(response);
            this.prettyPrintEnd(response);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Oh no! Something went wrong :-( Get in touch with the VersionEye guys and give them feedback.You find them on Twitter at https//twitter.com/VersionEye. ", exception);
        }
    }

    private ProjectJsonResponse uploadDependencies(ByteArrayOutputStream outStream) throws Exception {
        String apiKey = this.fetchApiKey();
        String url = this.baseUrl + this.apiPath + this.resource + apiKey;
        Reader reader = HttpUtils.post(url, outStream.toByteArray(), "upload");
        ObjectMapper mapper = new ObjectMapper();
        return (ProjectJsonResponse)mapper.readValue(reader, ProjectJsonResponse.class);
    }

    private void prettyPrintStart() {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)"Starting to upload dependencies. This can take a couple seconds ... ");
        this.getLog().info((CharSequence)".");
    }

    private void prettyPrintEnd(ProjectJsonResponse response) throws Exception {
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)("Dependencies: " + response.getDep_number()));
        this.getLog().info((CharSequence)("Outdated: " + response.getOut_number()));
        this.getLog().info((CharSequence)".");
        this.getLog().info((CharSequence)("You can find your project here: " + this.baseUrl + "/user/projects/" + response.getId()));
        this.getLog().info((CharSequence)".");
    }
}

