/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.control;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.entity.SkipExecutionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="gib.differentFiles")
public class DifferentFiles {
    public static final String UNSUPPORTED_WORKTREE = "JGit unsupported separate worktree checkout detected from current git dir path: ";
    private static final String HEAD = "HEAD";
    private static final String REFS_REMOTES = "refs/remotes/";
    private static final String REFS_HEADS = "refs/heads/";
    private Logger logger = LoggerFactory.getLogger(DifferentFiles.class);
    @Inject
    private MavenSession mavenSession;
    @Inject
    private Configuration.Provider configProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Path> get() throws GitAPIException, IOException {
        HashSet<Path> paths = new HashSet<Path>();
        Configuration configuration = this.configProvider.get();
        Git git = this.setupGit(configuration);
        try {
            Worker worker = new Worker(git, configuration);
            worker.fetch();
            worker.checkout();
            if (!configuration.disableBranchComparison) {
                paths.addAll(worker.getBranchDiff());
            }
            if (configuration.uncommited || configuration.untracked) {
                paths.addAll(worker.getChangesFromStatus());
            }
        }
        finally {
            git.getRepository().close();
            git.close();
        }
        return paths;
    }

    private Git setupGit(Configuration configuration) throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        File pomDir = this.mavenSession.getCurrentProject().getBasedir().toPath().toFile();
        builder.findGitDir(pomDir);
        if (builder.getGitDir() == null) {
            String gitDirNotFoundMessage = "Git repository root directory not found ascending from current working directory:'" + pomDir + "'.";
            this.logger.warn(gitDirNotFoundMessage + " Next step is determined by failOnMissingGitDir property.");
            if (configuration.failOnMissingGitDir) {
                throw new IllegalArgumentException(gitDirNotFoundMessage);
            }
            throw new SkipExecutionException(gitDirNotFoundMessage);
        }
        if (this.isWorktree(builder)) {
            throw new SkipExecutionException(UNSUPPORTED_WORKTREE + builder.getGitDir());
        }
        return Git.wrap((Repository)builder.build());
    }

    private boolean isWorktree(FileRepositoryBuilder builder) {
        Path gitDirParent = builder.getGitDir().toPath().getParent();
        return gitDirParent.getFileName().toString().equals("worktrees") && gitDirParent.getParent().getFileName().toString().equals(".git");
    }

    private class Worker {
        private final Git git;
        private final Path workTree;
        private final Configuration configuration;

        public Worker(Git git, Configuration configuration) {
            this.git = git;
            this.workTree = git.getRepository().getWorkTree().toPath().normalize().toAbsolutePath();
            this.configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Path> getBranchDiff() throws IOException {
            RevCommit base = this.getBranchCommit(this.configuration.baseBranch);
            try (TreeWalk treeWalk = new TreeWalk(this.git.getRepository());){
                treeWalk.addTree((AnyObjectId)base.getTree());
                treeWalk.addTree((AnyObjectId)this.resolveReference(base).getTree());
                treeWalk.setFilter(TreeFilter.ANY_DIFF);
                treeWalk.setRecursive(true);
                Set<Path> set = this.getDiff(treeWalk, this.workTree);
                return set;
            }
        }

        private void checkout() throws IOException, GitAPIException {
            if (!(DifferentFiles.HEAD.equals(this.configuration.baseBranch) || this.configuration.baseBranch.startsWith("worktrees/") || this.git.getRepository().getFullBranch().equals(this.configuration.baseBranch))) {
                DifferentFiles.this.logger.info("Checking out base branch " + this.configuration.baseBranch + "...");
                this.git.checkout().setName(this.configuration.baseBranch).call();
            }
        }

        private void fetch() throws GitAPIException {
            if (!this.configuration.disableBranchComparison && this.configuration.fetchReferenceBranch) {
                this.fetch(this.configuration.referenceBranch);
            }
            if (this.configuration.fetchBaseBranch) {
                this.fetch(this.configuration.baseBranch);
            }
        }

        private void fetch(String branchName) throws GitAPIException {
            DifferentFiles.this.logger.info("Fetching branch " + branchName);
            if (!branchName.startsWith(DifferentFiles.REFS_REMOTES)) {
                throw new IllegalArgumentException("Branch name '" + branchName + "' is not tracking branch name since it does not start " + DifferentFiles.REFS_REMOTES);
            }
            String remoteName = this.extractRemoteName(branchName);
            String shortName = this.extractShortName(remoteName, branchName);
            this.git.fetch().setRemote(remoteName).setRefSpecs(new RefSpec[]{new RefSpec(DifferentFiles.REFS_HEADS + shortName + ":" + branchName)}).call();
        }

        private String extractRemoteName(String branchName) {
            return branchName.split("/")[2];
        }

        private String extractShortName(String remoteName, String branchName) {
            return branchName.replaceFirst(DifferentFiles.REFS_REMOTES + remoteName + "/", "");
        }

        private RevCommit getMergeBase(RevCommit baseCommit, RevCommit referenceHeadCommit) throws IOException {
            RevWalk walk = new RevWalk(this.git.getRepository());
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(walk.lookupCommit((AnyObjectId)baseCommit));
            walk.markStart(walk.lookupCommit((AnyObjectId)referenceHeadCommit));
            RevCommit commit = walk.next();
            walk.close();
            DifferentFiles.this.logger.info("Using merge base of id: " + commit.getId());
            return commit;
        }

        private Set<Path> getDiff(TreeWalk treeWalk, Path gitDir) throws IOException {
            HashSet<Path> paths = new HashSet<Path>();
            while (treeWalk.next()) {
                Path path = gitDir.resolve(treeWalk.getPathString()).normalize();
                if (!this.pathNotExcluded(path)) continue;
                paths.add(path);
            }
            return paths;
        }

        private RevCommit getBranchCommit(String branchName) throws IOException {
            ObjectId objectId = this.git.getRepository().resolve(branchName);
            if (objectId == null) {
                throw new IllegalArgumentException("Git branch of name '" + branchName + "' not found.");
            }
            RevWalk walk = new RevWalk(this.git.getRepository());
            RevCommit commit = walk.parseCommit((AnyObjectId)objectId);
            walk.close();
            DifferentFiles.this.logger.info("Reference commit of branch " + branchName + " is commit of id: " + commit.getId());
            return commit;
        }

        private Set<Path> getChangesFromStatus() throws GitAPIException {
            HashSet changes = new HashSet();
            Status status = this.git.status().call();
            if (this.configuration.uncommited) {
                changes.addAll(status.getUncommittedChanges());
            }
            if (this.configuration.untracked) {
                changes.addAll(status.getUntracked());
            }
            return changes.stream().map(this.workTree::resolve).map(Path::normalize).filter(this::pathNotExcluded).collect(Collectors.toSet());
        }

        private RevCommit resolveReference(RevCommit base) throws IOException {
            RevCommit refHead = this.getBranchCommit(this.configuration.referenceBranch);
            if (this.configuration.compareToMergeBase) {
                return this.getMergeBase(base, refHead);
            }
            return refHead;
        }

        private boolean pathNotExcluded(Path path) {
            return !this.configuration.excludePathRegex.test(path.toString());
        }
    }
}

