/*
 * Decompiled with CFR 0.152.
 */
package com.vackosar.gitflowincrementalbuild.boundary;

import com.vackosar.gitflowincrementalbuild.boundary.Configuration;
import com.vackosar.gitflowincrementalbuild.control.ChangedProjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="gib.unchangedProjectsRemover")
class UnchangedProjectsRemover {
    private static final String MAVEN_TEST_SKIP = "maven.test.skip";
    private static final String MAVEN_TEST_SKIP_EXEC = "skipTests";
    private static final String TEST_JAR_DETECTED = "Dependency with test-jar goal detected. Will compile test sources.";
    private static final String GOAL_TEST_JAR = "test-jar";
    private Logger logger = LoggerFactory.getLogger(UnchangedProjectsRemover.class);
    @Inject
    private ChangedProjects changedProjects;
    @Inject
    private MavenSession mavenSession;
    @Inject
    private Configuration.Provider configProvider;

    UnchangedProjectsRemover() {
    }

    void act() throws GitAPIException, IOException {
        Set impacted;
        Set changed = this.changedProjects.get();
        this.printDelimiter();
        this.logProjects(changed, "Changed Artifacts:");
        Configuration cfg = this.configProvider.get();
        Set set = impacted = cfg.buildAll || cfg.buildDownstream ? (Set)changed.stream().flatMap(this::streamProjectWithDownstreamProjects).collect(Collectors.toCollection(LinkedHashSet::new)) : changed;
        if (!cfg.buildAll) {
            this.modifyProjectList(changed, impacted);
        } else {
            this.mavenSession.getProjects().stream().filter(p -> !impacted.contains(p)).forEach(this::applyUpstreamModuleArgs);
        }
    }

    private void modifyProjectList(Set<MavenProject> changed, Set<MavenProject> impacted) {
        Set<MavenProject> rebuild = this.getRebuildProjects(changed, impacted);
        if (rebuild.isEmpty()) {
            this.logger.info("No changed artifacts to build. Executing validate goal on current project only.");
            this.mavenSession.setProjects(Collections.singletonList(this.mavenSession.getCurrentProject()));
            this.mavenSession.getGoals().clear();
            this.mavenSession.getGoals().add("validate");
        } else if (!this.configProvider.get().forceBuildModules.isEmpty()) {
            Stream<MavenProject> forceBuildModules = this.mavenSession.getProjects().stream().filter(p -> this.matchesAny(p.getArtifactId(), this.configProvider.get().forceBuildModules)).filter(p -> !rebuild.contains(p)).map(this::applyUpstreamModuleArgs);
            this.mavenSession.setProjects(Stream.concat(forceBuildModules, rebuild.stream()).collect(Collectors.toList()));
        } else {
            this.mavenSession.setProjects(new ArrayList<MavenProject>(rebuild));
        }
    }

    private Set<MavenProject> getRebuildProjects(Set<MavenProject> changed, Set<MavenProject> impacted) {
        Set<MavenProject> upstreamRequiringProjects;
        switch (this.configProvider.get().buildUpstreamMode) {
            case NONE: {
                return impacted;
            }
            case CHANGED: {
                upstreamRequiringProjects = changed;
                break;
            }
            case IMPACTED: {
                upstreamRequiringProjects = impacted;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported BuildUpstreamMode: " + (Object)((Object)this.configProvider.get().buildUpstreamMode));
            }
        }
        Stream<MavenProject> upstreamProjects = upstreamRequiringProjects.stream().flatMap(this::streamUpstreamProjects).filter(p -> !changed.contains(p)).map(this::applyUpstreamModuleArgs);
        return Stream.concat(impacted.stream(), upstreamProjects).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private MavenProject applyUpstreamModuleArgs(MavenProject mavenProject) {
        Properties projectProperties = mavenProject.getProperties();
        if (this.configProvider.get().skipTestsForUpstreamModules) {
            if (this.projectDeclaresTestJarGoal(mavenProject)) {
                this.logger.debug("{}: {}", (Object)mavenProject.getArtifactId(), (Object)TEST_JAR_DETECTED);
                projectProperties.setProperty(MAVEN_TEST_SKIP_EXEC, Boolean.TRUE.toString());
            } else {
                projectProperties.setProperty(MAVEN_TEST_SKIP, Boolean.TRUE.toString());
            }
        }
        this.configProvider.get().argsForUpstreamModules.forEach(projectProperties::setProperty);
        return mavenProject;
    }

    private boolean projectDeclaresTestJarGoal(MavenProject project) {
        return project.getBuildPlugins().stream().flatMap(p -> p.getExecutions().stream()).flatMap(e -> e.getGoals().stream()).anyMatch(GOAL_TEST_JAR::equals);
    }

    private void logProjects(Set<MavenProject> projects, String title) {
        this.logger.info(title);
        this.logger.info("");
        projects.stream().map(MavenProject::getArtifactId).forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
        this.logger.info("");
    }

    private void printDelimiter() {
        this.logger.info("------------------------------------------------------------------------");
    }

    private Stream<MavenProject> streamProjectWithDownstreamProjects(MavenProject project) {
        return Stream.concat(Stream.of(project), this.mavenSession.getProjectDependencyGraph().getDownstreamProjects(project, true).stream().filter(p -> !this.configProvider.get().excludeTransitiveModulesPackagedAs.contains(p.getPackaging())));
    }

    private Stream<MavenProject> streamUpstreamProjects(MavenProject project) {
        return this.mavenSession.getProjectDependencyGraph().getUpstreamProjects(project, true).stream();
    }

    private boolean matchesAny(String str, Collection<Pattern> patterns) {
        return patterns.stream().anyMatch(pattern -> pattern.matcher(str).matches());
    }
}

