/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.unit.mocks;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.spring.SpringServlet;
import com.vaadin.testbench.unit.internal.Routes;
import com.vaadin.testbench.unit.mocks.MockRequest;
import com.vaadin.testbench.unit.mocks.MockSpringServletService;
import com.vaadin.testbench.unit.mocks.MockVaadinHelper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.function.UnaryOperator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class MockSpringServlet
extends SpringServlet {
    @NotNull
    public final Routes routes;
    @NotNull
    public final ApplicationContext ctx;
    @NotNull
    public final Function0<UI> uiFactory;

    public MockSpringServlet(@NotNull Routes routes, @NotNull ApplicationContext ctx, @NotNull Function0<UI> uiFactory) {
        super(ctx, false);
        this.ctx = ctx;
        this.routes = routes;
        this.uiFactory = uiFactory;
    }

    protected DeploymentConfiguration createDeploymentConfiguration() throws ServletException {
        MockVaadinHelper.mockFlowBuildInfo((VaadinServlet)this);
        return super.createDeploymentConfiguration();
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        MockSpringServletService service = new MockSpringServletService(this, deploymentConfiguration, this.ctx, this.uiFactory);
        service.init();
        this.routes.register(service.getContext());
        return service;
    }

    protected VaadinServletRequest createVaadinRequest(HttpServletRequest request) {
        return new MockSpringReq(request, this.getService());
    }

    public static void applySpringSecurityIfPresent(MockRequest request) {
        if (SpringSecuritySupport.SPRING_SECURITY_PRESENT) {
            HttpServletRequest wrappedRequest = (HttpServletRequest)SpringSecuritySupport.springSecurityRequestWrapper.apply(request);
            if (wrappedRequest instanceof MockRequest) {
                MockSpringServlet.applySimplifiedSpringSecurity(request);
            } else {
                request.setUserPrincipalInt(wrappedRequest.getUserPrincipal());
                request.setUserInRole((Function2<? super Principal, ? super String, Boolean>)((Function2)(principal, role) -> wrappedRequest.isUserInRole(role)));
            }
        }
    }

    private static void applySimplifiedSpringSecurity(MockRequest request) {
        Authentication authentication = SpringSecuritySupport.authentication();
        if (authentication == null || authentication.getPrincipal() == null) {
            request.setUserPrincipalInt(null);
            request.setUserInRole((Function2<? super Principal, ? super String, Boolean>)((Function2)(principal, role) -> false));
        } else {
            request.setUserPrincipalInt((Principal)authentication);
            request.setUserInRole((Function2<? super Principal, ? super String, Boolean>)((Function2)SpringSecuritySupport::isGranted));
        }
    }

    static class MockSpringReq
    extends VaadinServletRequest {
        public MockSpringReq(HttpServletRequest request, VaadinServletService vaadinService) {
            super((HttpServletRequest)SpringSecuritySupport.springSecurityRequestWrapper.apply(request), vaadinService);
        }
    }

    private static class SpringSecuritySupport {
        private static final String ROLE_PREFIX = "ROLE_";
        private static final boolean SPRING_SECURITY_PRESENT = SpringSecuritySupport.hasSpringSecurity();
        private static final UnaryOperator<HttpServletRequest> springSecurityRequestWrapper = SpringSecuritySupport.springSecurityRequestWrapper();

        private SpringSecuritySupport() {
        }

        private static Authentication authentication() {
            return SecurityContextHolder.getContext().getAuthentication();
        }

        private static boolean hasSpringSecurity() {
            try {
                Class.forName("org.springframework.security.core.context.SecurityContextHolder");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        private static UnaryOperator<HttpServletRequest> springSecurityRequestWrapper() {
            try {
                Constructor<?> constructor = Class.forName("org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper").getConstructor(HttpServletRequest.class, String.class);
                return req -> {
                    try {
                        return (HttpServletRequest)constructor.newInstance(req, ROLE_PREFIX);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                };
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(MockSpringServlet.class).debug("Spring security WEB not found on classpath, principal and roles may not be available during tests");
                return UnaryOperator.identity();
            }
        }

        private static boolean isGranted(Principal principal, String role) {
            if (principal instanceof Authentication) {
                Authentication auth = (Authentication)principal;
                Object prefixedRole = role != null && !role.startsWith(ROLE_PREFIX) ? ROLE_PREFIX + role : role;
                return auth.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(arg_0 -> SpringSecuritySupport.lambda$isGranted$1((String)prefixedRole, arg_0));
            }
            return false;
        }

        private static /* synthetic */ boolean lambda$isGranted$1(String prefixedRole, String granted) {
            return granted.equals(prefixedRole);
        }
    }
}

