/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.notification;

import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import elemental.json.Json;
import java.util.function.Consumer;

@Tests(value={Notification.class})
public class NotificationTester<T extends Notification>
extends ComponentTester<T> {
    public NotificationTester(T component) {
        super(component);
    }

    public String getText() {
        this.ensureComponentIsUsable();
        return ((Notification)this.getComponent()).getElement().getProperty("text");
    }

    public void autoClose() {
        this.ensureComponentIsUsable();
        if (((Notification)this.getComponent()).getDuration() <= 0) {
            throw new IllegalStateException("Auto-close is not enabled");
        }
        ((Notification)this.getComponent()).close();
        this.fireOpenChangedDomEvent();
        this.roundTrip();
    }

    @Override
    public boolean isUsable() {
        Notification component = (Notification)this.getComponent();
        return component.isVisible() && component.isAttached() && component.isOpened();
    }

    @Override
    protected void notUsableReasons(Consumer<String> collector) {
        Notification component = (Notification)this.getComponent();
        if (!component.isAttached()) {
            collector.accept("not attached");
        }
        if (!component.isVisible()) {
            collector.accept("not visible");
        }
        if (component.isOpened()) {
            collector.accept("not opened");
        }
    }

    private void fireOpenChangedDomEvent() {
        Element element = ((Notification)this.getComponent()).getElement();
        ((ElementListenerMap)element.getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(element, "open-changed", Json.createObject()));
    }
}

