/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Function;

public class IPAddress {
    public static String findSiteLocalAddress() {
        return IPAddress.findIPAddress(address -> {
            if (address.isLoopbackAddress()) {
                return false;
            }
            if (address.isSiteLocalAddress()) {
                return true;
            }
            return false;
        }).orElseThrow(() -> new RuntimeException("No compatible (10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) IP address found."));
    }

    public static Optional<String> findIPAddress(Function<InetAddress, Boolean> acceptor) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nwInterface = interfaces.nextElement();
                if (!nwInterface.isUp() || nwInterface.isLoopback() || nwInterface.isVirtual()) continue;
                Enumeration<InetAddress> addresses = nwInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!acceptor.apply(address).booleanValue()) continue;
                    return Optional.of(address.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not enumerate ");
        }
        return Optional.empty();
    }
}

