/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.elements.PanelElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@ServerClass(value="com.vaadin.ui.Window")
public class WindowElement
extends PanelElement {
    private static final String HEADER_CLASS = "v-window-header";
    private static final String RESTORE_BOX_CLASS = "v-window-restorebox";
    private static final String MAXIMIZE_BOX_CLASS = "v-window-maximizebox";
    private static final String CLOSE_BOX_CLASS = "v-window-closebox";

    public void close() {
        this.getCloseButton().click();
    }

    public void restore() {
        if (!this.isMaximized()) {
            throw new IllegalStateException("Window is not maximized, cannot be restored.");
        }
        this.getRestoreButton().click();
    }

    public boolean isMaximized() {
        return this.isElementPresent(By.className((String)RESTORE_BOX_CLASS));
    }

    public void maximize() {
        if (this.isMaximized()) {
            throw new IllegalStateException("Window is already maximized, cannot maximize.");
        }
        this.getMaximizeButton().click();
    }

    private WebElement getRestoreButton() {
        return this.findElement(By.className((String)RESTORE_BOX_CLASS));
    }

    private WebElement getMaximizeButton() {
        return this.findElement(By.className((String)MAXIMIZE_BOX_CLASS));
    }

    private WebElement getCloseButton() {
        return this.findElement(By.className((String)CLOSE_BOX_CLASS));
    }

    @Override
    public String getCaption() {
        return this.findElement(By.className((String)HEADER_CLASS)).getText();
    }

    public void move(int xOffset, int yOffset) {
        Actions action = new Actions(this.getDriver());
        action.moveToElement(this.findElement(By.className((String)"v-window-wrap")), 5, 5);
        action.clickAndHold();
        action.moveByOffset(xOffset, yOffset);
        action.release();
        action.build().perform();
    }
}

