/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.elementsbase.AbstractElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

@ServerClass(value="com.vaadin.ui.Notification")
public class NotificationElement
extends AbstractElement {
    public void close() {
        this.click();
        WebDriverWait wait = new WebDriverWait(this.getDriver(), 10L);
        wait.until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.className((String)"v-Notification"))));
    }

    public String getCaption() {
        WebElement popup = this.findElement(By.className((String)"popupContent"));
        WebElement caption = popup.findElement(By.tagName((String)"h1"));
        return caption.getText();
    }

    public String getDescription() {
        WebElement popup = this.findElement(By.className((String)"popupContent"));
        WebElement caption = popup.findElement(By.tagName((String)"p"));
        return caption.getText();
    }

    public String getType() {
        Map<String, String> styleToTypeMap = this.initStyleToTypeMap();
        for (Map.Entry<String, String> entry : styleToTypeMap.entrySet()) {
            String notifType = entry.getKey();
            if (!this.getAttribute("class").contains(notifType)) continue;
            return entry.getValue();
        }
        return "";
    }

    private Map<String, String> initStyleToTypeMap() {
        HashMap<String, String> styleToType = new HashMap<String, String>();
        styleToType.put("v-Notification-error", "error");
        styleToType.put("v-Notification-warning", "warning");
        styleToType.put("v-Notification-humanized", "humanized");
        styleToType.put("v-Notification-tray", "tray_notification");
        return styleToType;
    }
}

