/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.commands.TestBenchElementCommands;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractFieldElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.CheckBox")
public class CheckBoxElement
extends AbstractFieldElement {
    public String getValue() {
        if (this.isChecked()) {
            return "checked";
        }
        return "unchecked";
    }

    public boolean isChecked() {
        return this.getInputElement().isSelected();
    }

    public void clear() {
        if (this.isChecked()) {
            this.click();
        }
    }

    @Override
    public String getCaption() {
        WebElement elem = this.findElement(By.xpath((String)"..")).findElement(By.tagName((String)"label"));
        return elem.getText();
    }

    public void click() {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException();
        }
        WebElement input = this.getInputElement();
        if (this.isFirefox()) {
            this.getCommandExecutor().executeScript("arguments[0].click()", new Object[]{input});
        } else if (this.isChrome()) {
            ((TestBenchElementCommands)input).click(0, 0, new Keys[0]);
        } else {
            input.click();
        }
    }

    public WebElement getInputElement() {
        return this.findElement(By.tagName((String)"input"));
    }
}

