/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.RadioButtonGroup")
public class RadioButtonGroupElement
extends AbstractSelectElement {
    private static org.openqa.selenium.By bySelectOption = By.className((String)"v-select-option");
    private static org.openqa.selenium.By byLabel = By.tagName((String)"label");
    private static org.openqa.selenium.By byRadioInput = By.tagName((String)"input");

    public List<String> getOptions() {
        ArrayList<String> optionTexts = new ArrayList<String>();
        List options = this.findElements(bySelectOption);
        for (WebElement option : options) {
            optionTexts.add(option.findElement(byLabel).getText());
        }
        return optionTexts;
    }

    public void selectByText(String text) throws AbstractComponentElement.ReadOnlyException {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException(this);
        }
        List options = this.findElements(bySelectOption);
        for (WebElement option : options) {
            if (!text.equals(option.findElement(byLabel).getText())) continue;
            WebElement input = option.findElement(byRadioInput);
            ((TestBenchElement)input).clickHiddenElement();
        }
    }

    public String getValue() {
        List options = this.findElements(bySelectOption);
        for (WebElement option : options) {
            WebElement checkedItem = option.findElement(By.tagName((String)"input"));
            String checked = checkedItem.getAttribute("checked");
            if (checked == null || !checkedItem.getAttribute("checked").equals("true")) continue;
            return option.findElement(By.tagName((String)"label")).getText();
        }
        return null;
    }

    public void setValue(CharSequence chars) throws AbstractComponentElement.ReadOnlyException {
        this.selectByText((String)chars);
    }

    @Override
    public void clear() {
        super.clear();
    }
}

