/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.elements;

import com.vaadin.testbench.By;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elements.AbstractComponentElement;
import com.vaadin.testbench.elements.AbstractSelectElement;
import com.vaadin.testbench.elementsbase.ServerClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ServerClass(value="com.vaadin.ui.ComboBox")
public class ComboBoxElement
extends AbstractSelectElement {
    private static org.openqa.selenium.By bySuggestionPopup = By.vaadin((String)"#popup");
    private static org.openqa.selenium.By byNextPage = By.className((String)"v-filterselect-nextpage");
    private static org.openqa.selenium.By byPrevPage = By.className((String)"v-filterselect-prevpage");

    public void selectByText(String text) {
        if (this.isReadOnly()) {
            throw new AbstractComponentElement.ReadOnlyException(this);
        }
        if (!this.isTextInputAllowed()) {
            this.selectByTextFromPopup(text);
            return;
        }
        this.getInputField().clear();
        this.getInputField().sendKeys(new CharSequence[]{text});
        this.selectSuggestion(text);
    }

    private void selectByTextFromPopup(String text) {
        while (this.openPrevPage()) {
        }
        do {
            if (!this.selectSuggestion(text)) continue;
            return;
        } while (this.openNextPage());
    }

    private boolean selectSuggestion(String text) {
        for (WebElement suggestion : this.getPopupSuggestionElements()) {
            if (!text.equals(suggestion.getText())) continue;
            this.clickElement(suggestion);
            return true;
        }
        return false;
    }

    private boolean isReadOnly(WebElement elem) {
        JavascriptExecutor js = (JavascriptExecutor)this.getDriver();
        return (Boolean)js.executeScript("return arguments[0].readOnly", new Object[]{elem});
    }

    public boolean isTextInputAllowed() {
        return !this.isReadOnly(this.getInputField());
    }

    public boolean isPopupOpen() {
        return this.isElementPresent(bySuggestionPopup);
    }

    public void openPopup() {
        this.findElement(By.vaadin((String)"#button")).click();
    }

    public List<String> getPopupSuggestions() {
        ArrayList<String> suggestionsTexts = new ArrayList<String>();
        List<WebElement> suggestions = this.getPopupSuggestionElements();
        for (WebElement suggestion : suggestions) {
            String text = suggestion.getText();
            if (text.isEmpty()) continue;
            suggestionsTexts.add(text);
        }
        return suggestionsTexts;
    }

    public List<WebElement> getPopupSuggestionElements() {
        List tables = this.getSuggestionPopup().findElements(By.tagName((String)"table"));
        if (tables == null || tables.isEmpty()) {
            return Collections.emptyList();
        }
        WebElement table = (WebElement)tables.get(0);
        return table.findElements(By.tagName((String)"td"));
    }

    public boolean openNextPage() {
        try {
            this.clickElement(this.getSuggestionPopup().findElement(byNextPage));
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public boolean openPrevPage() {
        try {
            this.clickElement(this.getSuggestionPopup().findElement(byPrevPage));
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    public WebElement getSuggestionPopup() {
        this.ensurePopupOpen();
        return this.findElement(bySuggestionPopup);
    }

    public String getValue() {
        return this.getInputField().getAttribute("value");
    }

    public WebElement getInputField() {
        return this.findElement(By.vaadin((String)"#textbox"));
    }

    private void ensurePopupOpen() {
        if (!this.isElementPresent(bySuggestionPopup)) {
            this.openPopup();
        }
    }

    public String getText() {
        return this.getInputField().getAttribute("value");
    }

    @Override
    public void clear() {
        this.getInputField().clear();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.sendKeys(50, keysToSend);
    }

    public void sendKeys(int delay, CharSequence ... keysToSend) {
        WebElement input = this.getInputField();
        for (CharSequence key : keysToSend) {
            input.sendKeys(new CharSequence[]{key});
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void clickElement(WebElement element) {
        if (this.isFirefox()) {
            ((TestBenchElement)element).clickHiddenElement();
        } else {
            element.click();
        }
    }
}

