/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.splitlayout;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.splitlayout.SplitLayoutVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

@Tag(value="vaadin-split-layout")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.7"), @NpmPackage(value="@vaadin/split-layout", version="24.1.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/split-layout/src/vaadin-split-layout.js")})
public class SplitLayout
extends Component
implements ClickNotifier<SplitLayout>,
HasSize,
HasStyle,
HasThemeVariant<SplitLayoutVariant> {
    private Component primaryComponent;
    private Component secondaryComponent;
    private StateTree.ExecutionRegistration updateStylesRegistration;
    private Double splitterPosition;

    public SplitLayout() {
        this.setOrientation(Orientation.HORIZONTAL);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.requestStylesUpdatesForSplitterPosition(e.getUI()));
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent) {
        this();
        this.addToPrimary(primaryComponent);
        this.addToSecondary(secondaryComponent);
    }

    public SplitLayout(Orientation orientation) {
        this.setOrientation(orientation);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.requestStylesUpdatesForSplitterPosition(e.getUI()));
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent, Orientation orientation) {
        this(primaryComponent, secondaryComponent);
        this.setOrientation(orientation);
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation, "Orientation cannot be null");
        this.getElement().setProperty("orientation", orientation.toString().toLowerCase(Locale.ENGLISH));
    }

    public Orientation getOrientation() {
        String orientation = this.getElement().getProperty("orientation");
        return Orientation.valueOf(orientation.toUpperCase());
    }

    public void addToPrimary(Component ... components) {
        if (components.length == 1) {
            this.primaryComponent = components[0];
        } else {
            Div container = new Div();
            container.add(components);
            this.primaryComponent = container;
        }
        this.setComponents();
    }

    public Component getPrimaryComponent() {
        return this.primaryComponent;
    }

    public void addToSecondary(Component ... components) {
        if (components.length == 1) {
            this.secondaryComponent = components[0];
        } else {
            Div container = new Div();
            container.add(components);
            this.secondaryComponent = container;
        }
        this.setComponents();
    }

    public Component getSecondaryComponent() {
        return this.secondaryComponent;
    }

    public void setSplitterPosition(double position) {
        this.splitterPosition = position;
        this.getUI().ifPresent(this::requestStylesUpdatesForSplitterPosition);
    }

    private void requestStylesUpdatesForSplitterPosition(UI ui) {
        if (this.updateStylesRegistration != null) {
            this.updateStylesRegistration.remove();
        }
        this.updateStylesRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            this.updateStylesForSplitterPosition();
            this.updateStylesRegistration = null;
        });
    }

    private void updateStylesForSplitterPosition() {
        if (this.splitterPosition == null) {
            return;
        }
        double primary = Math.min(Math.max(this.splitterPosition, 0.0), 100.0);
        double secondary = 100.0 - primary;
        this.setPrimaryStyle("flex", String.format("1 1 %s%%", primary));
        this.setSecondaryStyle("flex", String.format("1 1 %s%%", secondary));
    }

    public void setPrimaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, true);
    }

    public void setSecondaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, false);
    }

    private void setComponent(Component component, String slot) {
        Component child = component == null ? new Div() : component;
        SlotUtils.addToSlot((HasElement)this, (String)slot, (Component[])new Component[]{child});
    }

    private void setComponents() {
        this.removeAll();
        this.setComponent(this.primaryComponent, "primary");
        this.setComponent(this.secondaryComponent, "secondary");
    }

    public void remove(Component ... components) {
        for (Component component : components) {
            if (!this.getElement().equals((Object)component.getElement().getParent())) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            component.getElement().removeAttribute("slot");
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    public void removeAll() {
        this.getElement().getChildren().forEach(child -> child.removeAttribute("slot"));
        this.getElement().removeAllChildren();
    }

    public Registration addSplitterDragendListener(ComponentEventListener<SplitterDragendEvent> listener) {
        return this.addListener(SplitterDragendEvent.class, listener);
    }

    private void setInnerComponentStyle(String styleName, String value, boolean primary) {
        Component innerComponent;
        Component component = innerComponent = primary ? this.primaryComponent : this.secondaryComponent;
        if (innerComponent != null) {
            innerComponent.getElement().getStyle().set(styleName, value);
        } else {
            this.getElement().executeJs("var element = this.children[$0]; if (element) { element.style[$1]=$2; }", new Serializable[]{Integer.valueOf(primary ? 0 : 1), styleName, value});
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }

    @DomEvent(value="splitter-dragend")
    public static class SplitterDragendEvent
    extends ComponentEvent<SplitLayout> {
        public SplitterDragendEvent(SplitLayout source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

