/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.splitlayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.splitlayout.GeneratedVaadinSplitLayout;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;

@NpmPackage(value="@vaadin/vaadin-split-layout", version="20.0.3")
public class SplitLayout
extends GeneratedVaadinSplitLayout<SplitLayout>
implements HasSize {
    private Component primaryComponent;
    private Component secondaryComponent;
    private StateTree.ExecutionRegistration updateStylesRegistration;
    private Double splitterPosition;

    public SplitLayout() {
        this.setOrientation(Orientation.HORIZONTAL);
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.requestStylesUpdatesForSplitterPosition(e.getUI()));
    }

    public SplitLayout(Component primaryComponent, Component secondaryComponent) {
        this();
        this.addToPrimary(primaryComponent);
        this.addToSecondary(secondaryComponent);
    }

    public void setOrientation(Orientation orientation) {
        Objects.requireNonNull(orientation, "Orientation cannot be null");
        this.setOrientation(orientation.toString().toLowerCase());
    }

    public Orientation getOrientation() {
        return Orientation.valueOf(super.getOrientationString().toUpperCase());
    }

    @Override
    public void addToPrimary(Component ... components) {
        if (components.length == 1) {
            this.primaryComponent = components[0];
        } else {
            Div container = new Div();
            container.add(components);
            this.primaryComponent = container;
        }
        this.setComponents();
    }

    public Component getPrimaryComponent() {
        return this.primaryComponent;
    }

    @Override
    public void addToSecondary(Component ... components) {
        if (components.length == 1) {
            this.secondaryComponent = components[0];
        } else {
            Div container = new Div();
            container.add(components);
            this.secondaryComponent = container;
        }
        this.setComponents();
    }

    public Component getSecondaryComponent() {
        return this.secondaryComponent;
    }

    public void setSplitterPosition(double position) {
        this.splitterPosition = position;
        this.getUI().ifPresent(this::requestStylesUpdatesForSplitterPosition);
    }

    private void requestStylesUpdatesForSplitterPosition(UI ui) {
        if (this.updateStylesRegistration != null) {
            this.updateStylesRegistration.remove();
        }
        this.updateStylesRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            String JS = "for(let i = 0;i < this.children.length;i++)if(this.children[i].slot === 'primary'   || this.children[i].slot === 'secondary')this.children[i].style.flex = ''";
            this.getElement().executeJs("for(let i = 0;i < this.children.length;i++)if(this.children[i].slot === 'primary'   || this.children[i].slot === 'secondary')this.children[i].style.flex = ''", new Serializable[0]);
            this.updateStylesForSplitterPosition();
            this.updateStylesRegistration = null;
        });
    }

    private void updateStylesForSplitterPosition() {
        if (this.splitterPosition == null) {
            return;
        }
        double primary = Math.min(Math.max(this.splitterPosition, 0.0), 100.0);
        double secondary = 100.0 - primary;
        String styleName = this.getOrientation() == Orientation.VERTICAL ? "height" : "width";
        this.setPrimaryStyle(styleName, primary + "%");
        this.setSecondaryStyle(styleName, secondary + "%");
    }

    public void setPrimaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, true);
    }

    public void setSecondaryStyle(String styleName, String value) {
        this.setInnerComponentStyle(styleName, value, false);
    }

    private void setComponents() {
        this.removeAll();
        if (this.primaryComponent == null) {
            super.addToPrimary(new Component[]{new Div()});
        } else {
            super.addToPrimary(this.primaryComponent);
        }
        if (this.secondaryComponent == null) {
            super.addToSecondary(new Component[]{new Div()});
        } else {
            super.addToSecondary(this.secondaryComponent);
        }
    }

    @Override
    public void remove(Component ... components) {
        super.remove(components);
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    @Override
    public Registration addSplitterDragendListener(ComponentEventListener<GeneratedVaadinSplitLayout.SplitterDragendEvent<SplitLayout>> listener) {
        return super.addSplitterDragendListener(listener);
    }

    private void setInnerComponentStyle(String styleName, String value, boolean primary) {
        Component innerComponent;
        Component component = innerComponent = primary ? this.primaryComponent : this.secondaryComponent;
        if (innerComponent != null) {
            innerComponent.getElement().getStyle().set(styleName, value);
        } else {
            this.getElement().executeJs("var element = this.children[$0]; if (element) { element.style[$1]=$2; }", new Serializable[]{Integer.valueOf(primary ? 0 : 1), styleName, value});
        }
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

