/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.server.Version;
import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.LoggerFactory;

public class ServerInfo
implements Serializable {
    private final String flowVersion = Version.getFullVersion();
    private final String vaadinVersion = this.fetchVaadinVersion();
    private final String javaVersion = this.fetchJavaVersion();
    private final String osVersion = this.fetchOperatingSystem();

    private String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    private String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchVaadinVersion() {
        try (InputStream vaadinVersionsStream = this.getClass().getClassLoader().getResourceAsStream("vaadin_versions.json");){
            if (vaadinVersionsStream != null) {
                ObjectMapper m = new ObjectMapper();
                JsonNode vaadinVersions = m.readTree(vaadinVersionsStream);
                String string = vaadinVersions.get("platform").asText();
                return string;
            }
            LoggerFactory.getLogger(this.getClass()).info("Unable to determine version information. No vaadin_versions.json found");
            return "?";
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Unable to determine version information", (Throwable)e);
        }
        return "?";
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public String getVaadinVersion() {
        return this.vaadinVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }
}

