/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.BrowserLiveReloadImpl;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLiveReloadAccessorImpl
implements BrowserLiveReloadAccessor {
    public BrowserLiveReload getLiveReload(VaadinContext context) {
        return (BrowserLiveReload)context.getAttribute(BrowserLiveReload.class, BrowserLiveReloadImpl::new);
    }

    public BrowserLiveReload getLiveReload(VaadinService service) {
        if (service.getDeploymentConfiguration().isProductionMode()) {
            BrowserLiveReloadAccessorImpl.getLogger().debug("BrowserLiveReloadAccessImpl::getLiveReload is called in production mode.");
            return null;
        }
        if (!service.getDeploymentConfiguration().isDevModeLiveReloadEnabled()) {
            BrowserLiveReloadAccessorImpl.getLogger().debug("BrowserLiveReloadAccessImpl::getLiveReload is called when live reload is disabled.");
            return null;
        }
        return this.getLiveReload(service.getContext());
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BrowserLiveReloadAccessor.class);
    }
}

