/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.startup;

import com.vaadin.base.devserver.DevBundleBuildingHandler;
import com.vaadin.base.devserver.OpenInCurrentIde;
import com.vaadin.base.devserver.ViteHandler;
import com.vaadin.base.devserver.startup.DevModeStartupListener;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.StatisticsSender;
import com.vaadin.base.devserver.stats.StatisticsStorage;
import com.vaadin.base.devserver.viteproxy.ViteWebsocketEndpoint;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.pro.licensechecker.LicenseChecker;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeInitializer
implements Serializable {
    private static final Pattern JAR_FILE_REGEX = Pattern.compile(".*file:(.+\\.jar).*");
    private static final Pattern ZIP_PROTOCOL_JAR_FILE_REGEX = Pattern.compile("(.+\\.jar).*");
    private static final Pattern VFS_FILE_REGEX = Pattern.compile("(vfs:/.+\\.jar).*");
    private static final Pattern VFS_DIRECTORY_REGEX = Pattern.compile("vfs:/.+");
    private static final Pattern DIR_REGEX_FRONTEND_DEFAULT = Pattern.compile("^(?:file:0)?(.+)META-INF/frontend/?$");
    private static final Pattern DIR_REGEX_RESOURCES_JAR_DEFAULT = Pattern.compile("^(?:file:0)?(.+)META-INF/resources/themes//?$");
    private static final Pattern DIR_REGEX_COMPATIBILITY_FRONTEND_DEFAULT = Pattern.compile("^(?:file:)?(.+)META-INF/resources/frontend/?$");

    public static DevModeHandler initDevModeHandler(Set<Class<?>> classes, VaadinContext context, Executor taskExecutor) throws VaadinInitializerException {
        ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)context);
        if (config.isProductionMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because PRODUCTION MODE is set.");
            return null;
        }
        FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)context);
        LicenseChecker.setStrictOffline((boolean)true);
        featureFlags.setPropertiesLocation(config.getJavaResourceFolder());
        File baseDir = config.getProjectFolder();
        if (config.isUsageStatisticsEnabled()) {
            StatisticsStorage storage = new StatisticsStorage();
            DevModeUsageStatistics.init(baseDir, storage, new StatisticsSender(storage));
            DevModeUsageStatistics.collectEvent("ide_" + OpenInCurrentIde.getIdeAndProcessInfo().ide().name().toLowerCase(Locale.ENGLISH));
        }
        File frontendFolder = config.getFrontendFolder();
        Lookup lookupFromContext = (Lookup)context.getAttribute(Lookup.class);
        Lookup lookupForClassFinder = Lookup.of((Object)((Object)new DevModeClassFinder(classes)), (Class[])new Class[]{ClassFinder.class});
        Lookup lookup = Lookup.compose((Lookup)lookupForClassFinder, (Lookup)lookupFromContext);
        Options options = new Options(lookup, baseDir).withFrontendDirectory(frontendFolder).withFrontendGeneratedFolder(new File(String.valueOf(frontendFolder) + "generated/")).withBuildDirectory(config.getBuildFolder());
        DevModeInitializer.log().info("Starting dev-mode updaters in {} folder.", (Object)options.getNpmFolder());
        File target = new File(baseDir, config.getBuildFolder());
        options.withBuildResultFolders(Paths.get(target.getPath(), "classes", "META-INF/VAADIN/webapp/").toFile(), Paths.get(target.getPath(), "classes", "META-INF/VAADIN/").toFile());
        if (!new File(options.getNpmFolder(), "package.json").exists()) {
            options.createMissingPackageJson(true);
        }
        ResourceProvider resourceProvider = (ResourceProvider)lookup.lookup(ResourceProvider.class);
        Set<File> frontendLocations = DevModeInitializer.getFrontendLocationsFromResourceProvider(resourceProvider);
        boolean useByteCodeScanner = config.getBooleanProperty("devmode.optimizeBundle", Boolean.parseBoolean(System.getProperty("devmode.optimizeBundle", Boolean.FALSE.toString())));
        boolean enablePnpm = config.isPnpmEnabled();
        boolean enableBun = config.isBunEnabled();
        boolean useGlobalPnpm = config.isGlobalPnpm();
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        String[] additionalPostinstallPackages = config.getStringProperty("npm.postinstallPackages", "").split(",");
        String frontendGeneratedFolderName = config.getStringProperty("project.frontend.generated", Paths.get(frontendFolder.getPath(), "generated/").toString());
        File frontendGeneratedFolder = new File(frontendGeneratedFolderName);
        File jarFrontendResourcesFolder = new File(frontendGeneratedFolder, "jar-resources");
        Mode mode = config.getMode();
        boolean reactEnable = config.getBooleanProperty("react.enable", FrontendUtils.isReactRouterRequired((File)options.getFrontendDirectory()));
        boolean npmExcludeWebComponents = config.getBooleanProperty("npm.excludeWebComponents", false);
        options.enablePackagesUpdate(true).useByteCodeScanner(useByteCodeScanner).withFrontendGeneratedFolder(frontendGeneratedFolder).withJarFrontendResourcesFolder(jarFrontendResourcesFolder).copyResources(frontendLocations).copyLocalResources(new File(baseDir, "src/main/resources/META-INF/resources/frontend")).enableImportsUpdate(true).withRunNpmInstall(mode == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD).withEmbeddableWebComponents(true).withEnablePnpm(enablePnpm).withEnableBun(enableBun).useGlobalPnpm(useGlobalPnpm).withHomeNodeExecRequired(useHomeNodeExec).withProductionMode(config.isProductionMode()).withPostinstallPackages(Arrays.asList(additionalPostinstallPackages)).withFrontendHotdeploy(mode == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD).withBundleBuild(mode == Mode.DEVELOPMENT_BUNDLE).withFrontendExtraFileExtensions(DevModeInitializer.getFrontendExtraFileExtensions(config)).withReact(reactEnable).withNpmExcludeWebComponents(npmExcludeWebComponents).withNodeVersion(config.getStringProperty("node.version", "v24.13.0")).withNodeFolder(config.getStringProperty("node.folder", null)).withNodeDownloadRoot(URI.create(config.getStringProperty("node.download.root", "https://nodejs.org/dist/")));
        NodeTasks tasks = new NodeTasks(options);
        Runnable runnable = () -> {
            DevModeInitializer.runNodeTasks(tasks);
            if (mode == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD && VaadinServlet.getFrontendMapping() == null) {
                DevModeInitializer.log().debug("Waiting for a VaadinServlet to be deployed");
                while (VaadinServlet.getFrontendMapping() == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        CompletableFuture<Void> nodeTasksFuture = CompletableFuture.runAsync(runnable, taskExecutor);
        Lookup devServerLookup = Lookup.compose((Lookup)lookup, (Lookup)Lookup.of((Object)config, (Class[])new Class[]{ApplicationConfiguration.class}));
        int port = Integer.parseInt(config.getStringProperty("devServerPort", "0"));
        if (mode == Mode.DEVELOPMENT_BUNDLE) {
            return new DevBundleBuildingHandler(nodeTasksFuture);
        }
        ViteHandler handler = new ViteHandler(devServerLookup, port, options.getNpmFolder(), nodeTasksFuture);
        VaadinServlet.whenFrontendMappingAvailable(() -> ViteWebsocketEndpoint.init(context, handler));
        return handler;
    }

    static List<String> getFrontendExtraFileExtensions(ApplicationConfiguration config) {
        List<String> stringProperty = Arrays.stream(config.getStringProperty("devmode.frontendExtraFileExtensions", "").split(",")).filter(input -> !input.isBlank()).toList();
        return stringProperty.isEmpty() ? null : stringProperty;
    }

    private static Logger log() {
        return LoggerFactory.getLogger(DevModeStartupListener.class);
    }

    static Set<File> getFrontendLocationsFromResourceProvider(ResourceProvider resourceProvider) throws VaadinInitializerException {
        HashSet<File> frontendFiles = new HashSet<File>();
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromResourceProvider(resourceProvider, "META-INF/frontend"));
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromResourceProvider(resourceProvider, "META-INF/resources/frontend"));
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromResourceProvider(resourceProvider, "META-INF/resources/themes/"));
        return frontendFiles;
    }

    private static void runNodeTasks(NodeTasks tasks) {
        try {
            tasks.execute();
        }
        catch (ExecutionFailedException exception) {
            DevModeInitializer.log().debug("Could not initialize dev mode handler. One of the node tasks failed", (Throwable)exception);
            throw new CompletionException(exception);
        }
    }

    private static Set<File> getFrontendLocationsFromResourceProvider(ResourceProvider resourceProvider, String resourcesFolder) throws VaadinInitializerException {
        HashSet<File> frontendFiles = new HashSet<File>();
        try {
            List en = resourceProvider.getApplicationResources(resourcesFolder);
            if (en == null) {
                return frontendFiles;
            }
            HashSet<String> vfsJars = new HashSet<String>();
            for (URL url : en) {
                String urlString = url.toString();
                String path = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8);
                Matcher jarMatcher = JAR_FILE_REGEX.matcher(path);
                Matcher zipProtocolJarMatcher = ZIP_PROTOCOL_JAR_FILE_REGEX.matcher(path);
                Matcher dirMatcher = DIR_REGEX_FRONTEND_DEFAULT.matcher(path);
                Matcher dirResourcesMatcher = DIR_REGEX_RESOURCES_JAR_DEFAULT.matcher(path);
                Matcher dirCompatibilityMatcher = DIR_REGEX_COMPATIBILITY_FRONTEND_DEFAULT.matcher(path);
                Matcher jarVfsMatcher = VFS_FILE_REGEX.matcher(urlString);
                Matcher dirVfsMatcher = VFS_DIRECTORY_REGEX.matcher(urlString);
                if (jarVfsMatcher.find()) {
                    String vfsJar = jarVfsMatcher.group(1);
                    if (!vfsJars.add(vfsJar)) continue;
                    frontendFiles.add(DevModeInitializer.getPhysicalFileOfJBossVfsJar(URI.create(vfsJar).toURL()));
                    continue;
                }
                if (dirVfsMatcher.find()) {
                    URL vfsDirUrl = URI.create(urlString.substring(0, urlString.lastIndexOf(resourcesFolder))).toURL();
                    frontendFiles.add(DevModeInitializer.getPhysicalFileOfJBossVfsDirectory(vfsDirUrl));
                    continue;
                }
                if (jarMatcher.find()) {
                    frontendFiles.add(new File(jarMatcher.group(1)));
                    continue;
                }
                if ("zip".equalsIgnoreCase(url.getProtocol()) && zipProtocolJarMatcher.find()) {
                    frontendFiles.add(new File(zipProtocolJarMatcher.group(1)));
                    continue;
                }
                if (dirMatcher.find()) {
                    frontendFiles.add(new File(dirMatcher.group(1)));
                    continue;
                }
                if (dirResourcesMatcher.find()) {
                    frontendFiles.add(new File(dirResourcesMatcher.group(1)));
                    continue;
                }
                if (dirCompatibilityMatcher.find()) {
                    frontendFiles.add(new File(dirCompatibilityMatcher.group(1)));
                    continue;
                }
                DevModeInitializer.log().warn("Resource {} not visited because does not meet supported formats.", (Object)url.getPath());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return frontendFiles;
    }

    private static File getPhysicalFileOfJBossVfsDirectory(URL url) throws IOException, VaadinInitializerException {
        try {
            Object virtualFile = url.openConnection().getContent();
            Class<?> virtualFileClass = virtualFile.getClass();
            Method getChildrenRecursivelyMethod = virtualFileClass.getMethod("getChildrenRecursively", new Class[0]);
            Method getPhysicalFileMethod = virtualFileClass.getMethod("getPhysicalFile", new Class[0]);
            List virtualFiles = (List)getChildrenRecursivelyMethod.invoke(virtualFile, new Object[0]);
            File rootDirectory = (File)getPhysicalFileMethod.invoke(virtualFile, new Object[0]);
            for (Object child : virtualFiles) {
                getPhysicalFileMethod.invoke(child, new Object[0]);
            }
            return rootDirectory;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new VaadinInitializerException("Failed to invoke JBoss VFS API.", (Throwable)exc);
        }
    }

    private static File getPhysicalFileOfJBossVfsJar(URL url) throws IOException, VaadinInitializerException {
        try {
            Object jarVirtualFile = url.openConnection().getContent();
            String vfsJarPath = url.toString();
            String fileNamePrefix = vfsJarPath.substring(vfsJarPath.lastIndexOf(vfsJarPath.contains("\\") ? 92 : 47) + 1, vfsJarPath.lastIndexOf(".jar"));
            Path tempJar = Files.createTempFile(fileNamePrefix, ".jar", new FileAttribute[0]);
            DevModeInitializer.generateJarFromJBossVfsFolder(jarVirtualFile, tempJar);
            File tempJarFile = tempJar.toFile();
            tempJarFile.deleteOnExit();
            return tempJarFile;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new VaadinInitializerException("Failed to invoke JBoss VFS API.", (Throwable)exc);
        }
    }

    private static void generateJarFromJBossVfsFolder(Object jarVirtualFile, Path tempJar) throws IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> virtualFileClass = jarVirtualFile.getClass();
        Method getChildrenRecursivelyMethod = virtualFileClass.getMethod("getChildrenRecursively", new Class[0]);
        Method openStreamMethod = virtualFileClass.getMethod("openStream", new Class[0]);
        Method isFileMethod = virtualFileClass.getMethod("isFile", new Class[0]);
        Method getPathNameRelativeToMethod = virtualFileClass.getMethod("getPathNameRelativeTo", virtualFileClass);
        List jarVirtualChildren = (List)getChildrenRecursivelyMethod.invoke(jarVirtualFile, new Object[0]);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempJar, new OpenOption[0]));){
            for (Object child : jarVirtualChildren) {
                if (!((Boolean)isFileMethod.invoke(child, new Object[0])).booleanValue()) continue;
                String relativePath = (String)getPathNameRelativeToMethod.invoke(child, jarVirtualFile);
                InputStream inputStream = (InputStream)openStreamMethod.invoke(child, new Object[0]);
                try {
                    ZipEntry zipEntry = new ZipEntry(relativePath);
                    zipOutputStream.putNextEntry(zipEntry);
                    inputStream.transferTo(zipOutputStream);
                    zipOutputStream.closeEntry();
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    static class DevModeClassFinder
    extends ClassFinder.DefaultClassFinder {
        private static final Set<String> APPLICABLE_CLASS_NAMES = Collections.unmodifiableSet(DevModeClassFinder.calculateApplicableClassNames());

        public DevModeClassFinder(Set<Class<?>> classes) {
            super(classes);
        }

        public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
            this.ensureImplementation(annotation);
            return super.getAnnotatedClasses(annotation);
        }

        public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
            this.ensureImplementation(type);
            return super.getSubTypesOf(type);
        }

        private void ensureImplementation(Class<?> clazz) {
            if (!APPLICABLE_CLASS_NAMES.contains(clazz.getName())) {
                throw new IllegalArgumentException("Unexpected class name " + String.valueOf(clazz) + ". Implementation error: the class finder instance is not aware of this class. Fix @HandlesTypes annotation value for " + DevModeStartupListener.class.getName());
            }
        }

        private static Set<String> calculateApplicableClassNames() {
            HandlesTypes handlesTypes = DevModeStartupListener.class.getAnnotation(HandlesTypes.class);
            return Stream.of(handlesTypes.value()).map(Class::getName).collect(Collectors.toSet());
        }
    }
}

