/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.startup;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.internal.Template;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.TypeScriptBootstrapModifier;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.flow.server.startup.VaadinServletContextStartupInitializer;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.servlet.annotation.WebListener;
import java.io.Serializable;
import java.util.Set;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Route.class, UIInitListener.class, VaadinServiceInitListener.class, WebComponentExporter.class, WebComponentExporterFactory.class, NpmPackage.class, NpmPackage.Container.class, JsModule.class, JsModule.Container.class, CssImport.class, CssImport.Container.class, JavaScript.class, JavaScript.Container.class, Theme.class, NoTheme.class, HasErrorParameter.class, PWA.class, AppShellConfigurator.class, Template.class, LoadDependenciesOnStartup.class, TypeScriptBootstrapModifier.class})
@WebListener
public class DevModeStartupListener
implements VaadinServletContextStartupInitializer,
Serializable,
ServletContextListener {
    private DevModeHandlerManager devModeHandlerManager;

    public void initialize(Set<Class<?>> classes, VaadinContext context) throws VaadinInitializerException {
        this.lookupDevModeHandlerManager(context).initDevModeHandler(classes, context);
    }

    public void contextInitialized(ServletContextEvent ctx) {
        this.devModeHandlerManager = this.lookupDevModeHandlerManager((VaadinContext)new VaadinServletContext(ctx.getServletContext()));
    }

    public void contextDestroyed(ServletContextEvent ctx) {
        if (this.devModeHandlerManager == null) {
            try {
                this.devModeHandlerManager = this.lookupDevModeHandlerManager((VaadinContext)new VaadinServletContext(ctx.getServletContext()));
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(DevModeStartupListener.class).debug("Cannot obtain DevModeHandlerManager instance during ServletContext destroy event. Potential cause could be DI container behind Lookup being already disposed.", (Throwable)exception);
            }
        }
        if (this.devModeHandlerManager != null) {
            this.devModeHandlerManager.stopDevModeHandler();
        }
        this.devModeHandlerManager = null;
    }

    private DevModeHandlerManager lookupDevModeHandlerManager(VaadinContext context) {
        Lookup lookup = (Lookup)context.getAttribute(Lookup.class);
        if (lookup == null) {
            LoggerFactory.getLogger(DevModeStartupListener.class).debug("Cannot obtain a Lookup instance from VaadinContext.");
            return null;
        }
        return (DevModeHandlerManager)lookup.lookup(DevModeHandlerManager.class);
    }
}

