/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.themeeditor;

import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSSelectorSimpleMember;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.vaadin.base.devserver.themeeditor.utils.ApplicationThemeNotAccessibleException;
import com.vaadin.base.devserver.themeeditor.utils.CssRule;
import com.vaadin.base.devserver.themeeditor.utils.ThemeEditorException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class ThemeModifier {
    private static final String THEME_EDITOR_CSS = "theme-editor.css";
    private static final String HEADER_TEXT = "This file has been created by the Vaadin Theme Editor. Please note that\nmanual changes to individual CSS properties may be overwritten by the theme editor.";
    private final State state;
    private VaadinContext context;
    private boolean importPresent;

    public ThemeModifier(VaadinContext context) {
        this.context = context;
        this.state = this.init();
    }

    public boolean isEnabled() {
        return !State.DISABLED.equals((Object)this.state);
    }

    public State getState() {
        return this.state;
    }

    public void setThemeProperties(List<CssRule> rules) {
        assert (rules != null);
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        for (CssRule rule : rules) {
            for (Map.Entry<String, String> property : rule.getProperties().entrySet()) {
                if (property.getValue() != null && !property.getValue().isBlank()) {
                    this.setCssProperty(styleSheet, rule.getSelector(), property.getKey(), property.getValue());
                    continue;
                }
                this.removeCssProperty(styleSheet, rule.getSelector(), property.getKey());
            }
        }
        this.sortStylesheet(styleSheet);
        this.writeStylesheet(styleSheet);
    }

    public String getCss() {
        try {
            StringWriter stringWriter = new StringWriter();
            CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
            CSSWriter cssWriter = new CSSWriter().setWriteHeaderText(false);
            cssWriter.getSettings().setOptimizedOutput(true).setRemoveUnnecessaryCode(true);
            cssWriter.writeCSS(styleSheet, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new ThemeEditorException("Cannot read stylesheet file.");
        }
    }

    public List<CssRule> getCssRules(List<String> selectors) {
        List<CSSSelector> cssSelectors = selectors.stream().map(this::parseSelector).toList();
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        return styleSheet.getAllStyleRules().stream().filter(rule -> rule.getSelectorCount() > 0).filter(rule -> cssSelectors.contains(rule.getSelectorAtIndex(0))).map(this::toCssRule).toList();
    }

    public void replaceClassName(String tagName, String oldClassName, String newClassName) {
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        this.replaceClassName(styleSheet, tagName, oldClassName, newClassName);
        this.writeStylesheet(styleSheet);
    }

    public int getRuleLocationLine(String selectorString) {
        CSSSelector selector;
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        CSSStyleRule rule = this.findRuleBySelector(styleSheet, selector = this.parseSelector(selectorString));
        if (rule == null) {
            return -1;
        }
        return rule.getSourceLocation().getFirstTokenBeginLineNumber();
    }

    public void createEmptyStyleRule(String selector) {
        CascadingStyleSheet styleSheet = this.getCascadingStyleSheet();
        CSSSelector cssSelector = new CSSSelector().addMember((ICSSSelectorMember)new CSSSelectorSimpleMember(selector));
        CSSStyleRule cssStyleRule = new CSSStyleRule().addSelector(cssSelector);
        styleSheet.addRule((ICSSTopLevelRule)cssStyleRule);
        this.sortStylesheet(styleSheet);
        this.writeStylesheet(styleSheet);
    }

    protected String getCssFileName() {
        return THEME_EDITOR_CSS;
    }

    protected String getHeaderText() {
        return HEADER_TEXT;
    }

    protected State init() {
        try {
            this.getThemeFile();
        }
        catch (Exception ex) {
            return State.MISSING_THEME;
        }
        return State.ENABLED;
    }

    protected File getFrontendFolder() {
        return new File(ApplicationConfiguration.get((VaadinContext)this.context).getStringProperty("project.basedir", null), "frontend");
    }

    protected File getThemeFile() {
        String themeName;
        File themes = new File(this.getFrontendFolder(), "themes");
        File theme = new File(themes, themeName = this.getThemeName(themes));
        if (!theme.exists() || !theme.canWrite()) {
            throw new ApplicationThemeNotAccessibleException();
        }
        return theme;
    }

    public File getStyleSheetFile() {
        File themeEditorStyles = new File(this.getThemeFile(), this.getCssFileName());
        if (!themeEditorStyles.exists()) {
            try {
                if (!themeEditorStyles.createNewFile()) {
                    throw new ThemeEditorException("Cannot create " + themeEditorStyles.getPath());
                }
            }
            catch (IOException e) {
                throw new ThemeEditorException("Cannot create " + themeEditorStyles.getPath(), e);
            }
        }
        if (!themeEditorStyles.canWrite()) {
            throw new ThemeEditorException(themeEditorStyles.getPath() + " is not writable.");
        }
        return themeEditorStyles;
    }

    protected CascadingStyleSheet getCascadingStyleSheet() {
        File styles = this.getStyleSheetFile();
        CascadingStyleSheet styleSheet = CSSReader.readFromFile((File)styles, (Charset)StandardCharsets.UTF_8, (ECSSVersion)ECSSVersion.LATEST);
        if (!this.importPresent) {
            this.insertImportIfNotExists();
            this.importPresent = true;
        }
        return styleSheet;
    }

    protected void setCssProperty(CascadingStyleSheet styleSheet, String selector, String property, String value) {
        CSSStyleRule newRule = this.createStyleRule(selector, property, value);
        CSSStyleRule existingRule = this.findRuleBySelector(styleSheet, newRule);
        if (existingRule == null) {
            styleSheet.addRule((ICSSTopLevelRule)newRule);
        } else {
            CSSDeclaration newDeclaration = newRule.getDeclarationAtIndex(0);
            CSSDeclaration existingDeclaration = existingRule.getDeclarationOfPropertyName(property);
            if (existingDeclaration == null) {
                existingRule.addDeclaration(newDeclaration);
            } else {
                existingDeclaration.setExpression(newDeclaration.getExpression());
            }
        }
    }

    protected void removeCssProperty(CascadingStyleSheet styleSheet, String selector, String property) {
        CSSStyleRule newRule = this.createStyleRule(selector, property, "none");
        CSSStyleRule existingRule = this.findRuleBySelector(styleSheet, newRule);
        if (existingRule != null) {
            this.removeProperty(existingRule, newRule);
            if (existingRule.getDeclarationCount() == 0) {
                styleSheet.removeRule((ICSSTopLevelRule)existingRule);
            }
        }
    }

    protected void writeStylesheet(CascadingStyleSheet styleSheet) {
        File styles = this.getStyleSheetFile();
        try {
            CSSWriter writer = new CSSWriter().setWriteHeaderText(true).setHeaderText(this.getHeaderText());
            writer.getSettings().setOptimizedOutput(false);
            writer.writeCSS(styleSheet, (Writer)new FileWriter(styles));
        }
        catch (IOException e) {
            throw new ThemeEditorException("Cannot write " + styles.getPath(), e);
        }
    }

    protected void sortStylesheet(CascadingStyleSheet styleSheet) {
        List<CSSStyleRule> sortedRules = styleSheet.getAllStyleRules().stream().sorted(Comparator.comparing(r -> r.getSelectorAtIndex(0).getAsCSSString())).collect(Collectors.toList());
        for (CSSStyleRule rule : sortedRules) {
            List<CSSDeclaration> sortedDeclarations = rule.getAllDeclarations().stream().sorted(Comparator.comparing(ICSSWriteable::getAsCSSString)).collect(Collectors.toList());
            rule.removeAllDeclarations();
            sortedDeclarations.forEach(arg_0 -> ((CSSStyleRule)rule).addDeclaration(arg_0));
        }
        sortedRules.forEach(arg_0 -> ((CascadingStyleSheet)styleSheet).removeRule(arg_0));
        sortedRules.forEach(arg_0 -> ((CascadingStyleSheet)styleSheet).addRule(arg_0));
    }

    protected CSSStyleRule createStyleRule(String selector, String property, String value) {
        return CSSReader.readFromString((String)(selector + "{" + property + ": " + value + "}"), (Charset)StandardCharsets.UTF_8, (ECSSVersion)ECSSVersion.LATEST).getStyleRuleAtIndex(0);
    }

    protected void removeProperty(CSSStyleRule existingRule, CSSStyleRule newRule) {
        CSSDeclaration newDeclaration = newRule.getDeclarationAtIndex(0);
        String property = newDeclaration.getProperty();
        CSSDeclaration declaration = existingRule.getDeclarationOfPropertyName(property);
        if (declaration != null) {
            existingRule.removeDeclaration(declaration);
        }
    }

    protected CSSStyleRule findRuleBySelector(CascadingStyleSheet styleSheet, CSSStyleRule rule) {
        return styleSheet.getAllStyleRules().stream().filter(r -> r.getAllSelectors().containsAll((Collection)rule.getAllSelectors())).findFirst().orElse(null);
    }

    protected CSSStyleRule findRuleBySelector(CascadingStyleSheet styleSheet, CSSSelector selector) {
        return styleSheet.getAllStyleRules().stream().filter(r -> r.getAllSelectors().contains((Object)selector)).findFirst().orElse(null);
    }

    protected void replaceClassName(CascadingStyleSheet styleSheet, String tagName, String oldClassName, String newClassName) {
        String dotOldClassName = "." + oldClassName;
        String dotNewClassName = "." + newClassName;
        for (CSSStyleRule rule : styleSheet.getAllStyleRules()) {
            for (CSSSelector selector : rule.getAllSelectors()) {
                if (selector.getAllMembers().containsNone(m -> tagName.equals(m.getAsCSSString()))) continue;
                ArrayList members = new ArrayList();
                selector.getAllMembers().findAll(m -> dotOldClassName.equals(m.getAsCSSString()), members::add);
                members.forEach(m -> {
                    int index = selector.getAllMembers().indexOf(m);
                    selector.removeMember(m);
                    selector.addMember(index, (ICSSSelectorMember)new CSSSelectorSimpleMember(dotNewClassName));
                });
            }
        }
    }

    protected void insertImportIfNotExists() {
        File themes = new File(this.getFrontendFolder(), "themes");
        String themeName = this.getThemeName(themes);
        File theme = new File(themes, themeName);
        File themeStyles = new File(theme, "styles.css");
        CascadingStyleSheet styleSheet = CSSReader.readFromFile((File)themeStyles, (Charset)StandardCharsets.UTF_8, (ECSSVersion)ECSSVersion.LATEST);
        CSSImportRule expectedRule = new CSSImportRule(this.getCssFileName());
        if (!styleSheet.getAllImportRules().contains((Object)expectedRule)) {
            FileWriter writer = null;
            try {
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                lines.add((CallSite)((Object)("@import \"" + this.getCssFileName() + "\";")));
                lines.addAll(IOUtils.readLines((Reader)new FileReader(themeStyles)));
                themeStyles.delete();
                themeStyles.createNewFile();
                writer = new FileWriter(themeStyles);
                IOUtils.writeLines(lines, (String)System.lineSeparator(), (Writer)writer);
            }
            catch (IOException e) {
                try {
                    throw new ThemeEditorException("Cannot insert theme-editor.css @import", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected String getThemeName(File themes) {
        String[] themeFolders = themes.list();
        if (themeFolders == null || themeFolders.length == 0) {
            throw new ThemeEditorException("No theme folder found in " + themes.getAbsolutePath());
        }
        if (themeFolders.length > 1) {
            throw new ThemeEditorException("Multiple theme folders found in " + themes.getAbsolutePath() + ". I don't know which to update");
        }
        return themeFolders[0];
    }

    protected CssRule toCssRule(CSSStyleRule rule) {
        CSSSelector selector = rule.getSelectorAtIndex(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        rule.getAllDeclarations().forEach(cssDeclaration -> properties.put(cssDeclaration.getProperty(), cssDeclaration.getExpressionAsCSSString()));
        return new CssRule(selector.getAsCSSString(), properties);
    }

    protected CSSSelector parseSelector(String selector) {
        CascadingStyleSheet css = CSSReader.readFromString((String)(selector + "{}"), (ECSSVersion)ECSSVersion.LATEST);
        return ((CSSStyleRule)css.getAllStyleRules().getFirst()).getSelectorAtIndex(0);
    }

    public static enum State {
        ENABLED,
        DISABLED,
        MISSING_THEME;

    }
}

