/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.function.SerializableConsumer;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class FileWatcher {
    private DirectoryWatcher watcher;

    public FileWatcher(SerializableConsumer<File> onChangeConsumer, File watchDirectory) throws IOException {
        Objects.requireNonNull(watchDirectory, "Watch directory cannot be null");
        Objects.requireNonNull(onChangeConsumer, "Change listener cannot be null");
        this.watcher = DirectoryWatcher.builder().path(watchDirectory.toPath()).listener(e -> onChangeConsumer.accept((Object)e.path().toFile())).build();
    }

    public void start() {
        this.watcher.watchAsync();
    }

    public void stop() throws IOException {
        this.watcher.close();
    }
}

