/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.DebugWindowMessage;
import com.vaadin.base.devserver.FeatureFlagMessage;
import com.vaadin.base.devserver.IdeIntegration;
import com.vaadin.base.devserver.ProductAndMessage;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugWindowConnection
implements BrowserLiveReload {
    private final ClassLoader classLoader;
    private VaadinContext context;
    private final ConcurrentLinkedQueue<WeakReference<AtmosphereResource>> atmosphereResources = new ConcurrentLinkedQueue();
    private BrowserLiveReload.Backend backend = null;
    private static final EnumMap<BrowserLiveReload.Backend, List<String>> IDENTIFIER_CLASSES = new EnumMap(BrowserLiveReload.Backend.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private IdeIntegration ideIntegration;

    DebugWindowConnection(VaadinContext context) {
        this(DebugWindowConnection.class.getClassLoader(), context);
    }

    DebugWindowConnection(ClassLoader classLoader, VaadinContext context) {
        this.classLoader = classLoader;
        this.context = context;
        this.ideIntegration = new IdeIntegration(ApplicationConfiguration.get((VaadinContext)context));
    }

    public BrowserLiveReload.Backend getBackend() {
        if (this.backend != null) {
            return this.backend;
        }
        for (Map.Entry<BrowserLiveReload.Backend, List<String>> entry : IDENTIFIER_CLASSES.entrySet()) {
            BrowserLiveReload.Backend backendCandidate = entry.getKey();
            boolean found = true;
            for (String clazz : entry.getValue()) {
                try {
                    this.classLoader.loadClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    DebugWindowConnection.getLogger().debug("Class {} not found, excluding {}", (Object)clazz, (Object)backendCandidate);
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            this.backend = backendCandidate;
            break;
        }
        return this.backend;
    }

    public void setBackend(BrowserLiveReload.Backend backend) {
        assert (backend != null);
        this.backend = backend;
    }

    public void onConnect(AtmosphereResource resource) {
        resource.suspend(-1L);
        this.atmosphereResources.add(new WeakReference<AtmosphereResource>(resource));
        resource.getBroadcaster().broadcast((Object)"{\"command\": \"hello\"}", resource);
        this.send(resource, "serverInfo", new ServerInfo());
        this.send(resource, "featureFlags", new FeatureFlagMessage(FeatureFlags.get((VaadinContext)this.context).getFeatures().stream().filter(feature -> !feature.equals((Object)FeatureFlags.EXAMPLE)).collect(Collectors.toList())));
    }

    private void send(AtmosphereResource resource, String command, Object data) {
        try {
            resource.getBroadcaster().broadcast((Object)this.objectMapper.writeValueAsString((Object)new DebugWindowMessage(command, data)), resource);
        }
        catch (Exception e) {
            DebugWindowConnection.getLogger().error("Error sending message", (Throwable)e);
        }
    }

    public void onDisconnect(AtmosphereResource resource) {
        if (!this.atmosphereResources.removeIf(resourceRef -> resource.equals(resourceRef.get()))) {
            String uuid = resource.uuid();
            DebugWindowConnection.getLogger().warn("Push connection {} is not a live-reload connection or already closed", (Object)uuid);
        }
    }

    public boolean isLiveReload(AtmosphereResource resource) {
        return this.atmosphereResources.stream().anyMatch(resourceRef -> resource.equals(resourceRef.get()));
    }

    public void reload() {
        this.atmosphereResources.forEach((Consumer<WeakReference<AtmosphereResource>>)((Consumer<WeakReference>)resourceRef -> {
            AtmosphereResource resource = (AtmosphereResource)resourceRef.get();
            if (resource != null) {
                resource.getBroadcaster().broadcast((Object)"{\"command\": \"reload\"}", resource);
            }
        }));
    }

    public void onMessage(AtmosphereResource resource, String message) {
        if (message.isEmpty()) {
            DebugWindowConnection.getLogger().debug("Received live reload heartbeat");
            return;
        }
        JsonObject json = Json.parse((String)message);
        String command = json.getString("command");
        JsonObject data = json.getObject("data");
        if ("setFeature".equals(command)) {
            FeatureFlags.get((VaadinContext)this.context).setEnabled(data.getString("featureId"), data.getBoolean("enabled"));
        } else if ("reportTelemetry".equals(command)) {
            DevModeUsageStatistics.handleBrowserData(data);
        } else if ("checkLicense".equals(command)) {
            boolean ok;
            String name = data.getString("name");
            String version = data.getString("version");
            Product product = new Product(name, version);
            String errorMessage = "";
            try {
                LicenseChecker.checkLicense((String)product.getName(), (String)product.getVersion(), (BuildType)BuildType.DEVELOPMENT, keyUrl -> this.send(resource, "license-check-nokey", new ProductAndMessage(product, (String)keyUrl)));
                ok = true;
            }
            catch (Exception e) {
                ok = false;
                errorMessage = e.getMessage();
            }
            if (ok) {
                this.send(resource, "license-check-ok", product);
            } else {
                ProductAndMessage pm = new ProductAndMessage(product, errorMessage);
                this.send(resource, "license-check-failed", pm);
            }
        } else if ("showComponentCreateLocation".equals(command) || "showComponentAttachLocation".equals(command)) {
            int nodeId = (int)data.getNumber("nodeId");
            int uiId = (int)data.getNumber("uiId");
            VaadinSession session = VaadinSession.getCurrent();
            session.access((Command & Serializable)() -> {
                Element element = session.findElement(uiId, nodeId);
                Optional c = element.getComponent();
                if (c.isPresent()) {
                    if ("showComponentCreateLocation".equals(command)) {
                        this.ideIntegration.showComponentCreateInIde((Component)c.get());
                    } else {
                        this.ideIntegration.showComponentAttachInIde((Component)c.get());
                    }
                } else {
                    DebugWindowConnection.getLogger().error("Only component locations are tracked. The given node id refers to an element and not a component");
                }
            });
        } else {
            DebugWindowConnection.getLogger().info("Unknown command from the browser: " + command);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DebugWindowConnection.class.getName());
    }

    static {
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.JREBEL, Collections.singletonList("org.zeroturnaround.jrebel.vaadin.JRebelClassEventListener"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.HOTSWAP_AGENT, Collections.singletonList("org.hotswap.agent.plugin.vaadin.VaadinIntegration"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.SPRING_BOOT_DEVTOOLS, Arrays.asList("com.vaadin.flow.spring.SpringServlet", "org.springframework.boot.devtools.livereload.LiveReloadServer"));
    }
}

