var __getOwnPropNames = Object.getOwnPropertyNames;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __commonJS = (cb2, mod) => function __require() {
  return mod || (0, cb2[__getOwnPropNames(cb2)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
import { aa as css$e, ab as addLumoGlobalStyles, ac as registerStyles$1, ad as overlay, ae as defineCustomElement, af as ThemableMixin, ag as DirMixin, ah as PolymerElement, ai as html, aj as PositionMixin, ak as OverlayMixin, al as overlayStyles$1, am as Debouncer$1, an as timeOut, ao as announce, ap as themeRegistry, aq as stylesFromTemplate, ar as unsafeCSS, as as DomModule, at as detailsSummary, au as ActiveMixin, av as details, aw as CollapsibleMixin, ax as DelegateFocusMixin, ay as DelegateStateMixin, az as SummaryController, aA as TooltipController, aB as ControllerMixin, aC as KeyboardDirectionMixin, aD as isElementFocused, aE as SlotObserver, aF as ElementMixin, aG as isIOS, aH as AriaModalController, aI as FocusTrapController, aJ as beforeNextRender, aK as afterNextRender, aL as button, aM as ButtonMixin, aN as isEmptyTextNode, aO as buttonStyles, aP as microTask, aQ as OverlayClassMixin, aR as generateUniqueId, aS as SlotController, aT as isKeyboardActive, aU as removeValueFromAttribute, aV as addValueToAttribute, aW as ThemePropertyMixin, aX as FocusMixin, aY as item, aZ as menuOverlayCore, a_ as listBox, a$ as ListMixin, b0 as ItemMixin, b1 as nothing, b2 as ResizeMixin, b3 as render$1, b4 as html$1, b5 as isElementHidden, b6 as wrap$e, b7 as microTask$1, b8 as get$5, b9 as requiredField, ba as helper, bb as FieldMixin, bc as DisabledMixin, bd as legacyOptimizations, be as useShadow, bf as dedupingMixin, bg as PropertyEffects, bh as strictTemplatePolicy, bi as legacyWarnings, bj as fastDomIf, bk as root, bl as suppressTemplateNotifications, bm as Directive, bn as isSingleExpression, bo as PartType, bp as directive, bq as noChange, br as idlePeriod, bs as timeOut$1, bt as ComboBoxPlaceholder, bu as dialogOverlay, bv as dialogOverlay$1, bw as DialogBaseMixin, bx as setAriaIDReference, by as gestures, bz as addListener, bA as removeListener, bB as resizableOverlay, bC as ColumnBaseMixin, bD as updateColumnOrders, bE as animationFrame, bF as ColumnObserver, bG as Button, bH as GridColumn, bI as get$6, bJ as set$1, bK as Grid, bL as FocusRestorationController, bM as MediaQueryController, bN as animationFrame$1, bO as isFocusable, bP as KeyboardMixin, bQ as getFlattenedElements, bR as menuOverlay, bS as inputFieldShared, bT as isElementFocusable, bU as matches, bV as translate$1, bW as setTouchAction, bX as InputConstraintsMixin, bY as VirtualKeyboardController, bZ as hideOthers, b_ as InputControlMixin, b$ as InputController, c0 as LabelledInputController, c1 as inputFieldShared$1, c2 as comboBoxOverlay, c3 as comboBoxItem, c4 as ComboBoxItemMixin, c5 as ComboBoxOverlayMixin, c6 as ComboBoxScrollerMixin, c7 as ComboBoxMixin, c8 as PatternMixin, c9 as set$2, ca as iterateRowCells, cb as updatePart, cc as Checkbox, cd as Select, ce as TextField, cf as SlotStylesMixin, cg as InputMixin, ch as color$h, ci as typography, cj as OverlayStackMixin, ck as isTemplateResult, cl as processTemplates, cm as LitElement, cn as isLastOverlay, co as getDeepActiveElement, cp as getFocusableElements, cq as LabelMixin, cr as CheckedMixin, cs as reactExports, ct as createRoot, cu as jsxDevRuntimeExports, cv as Outlet, cw as isFirefox$4, cx as fieldButton, cy as screenReaderOnly, cz as getNormalizedScrollLeft, cA as loader, cB as InputFieldMixin, cC as setCommittedValue, cD as isTouch, cE as Virtualizer, cF as Iconset } from "./indexhtml-z-VmjXL3.js";
var require_generated_flow_imports_00b = __commonJS({
  "VAADIN/build/generated-flow-imports-DPUxACtb.js"(exports) {
    var _a2, _b2, _c, _root, _rootRendered, _rendering, _state, _stateSetters, _customEvents, _dispatchFlowState, _readyCallback, _renderHooks, _Wrapper, _unmountComplete, _ReactAdapterElement_instances, maybeRenderRoot_fn, renderWrapper_fn, markAsUsed_fn, _d, _e;
    /**
     * @license
     * Copyright (c) 2017 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const userColors = css$e`
  :host {
    --vaadin-user-color-0: #df0b92;
    --vaadin-user-color-1: #650acc;
    --vaadin-user-color-2: #097faa;
    --vaadin-user-color-3: #ad6200;
    --vaadin-user-color-4: #bf16f3;
    --vaadin-user-color-5: #084391;
    --vaadin-user-color-6: #078836;
  }

  [theme~='dark'] {
    --vaadin-user-color-0: #ff66c7;
    --vaadin-user-color-1: #9d8aff;
    --vaadin-user-color-2: #8aff66;
    --vaadin-user-color-3: #ffbd66;
    --vaadin-user-color-4: #dc6bff;
    --vaadin-user-color-5: #66fffa;
    --vaadin-user-color-6: #e6ff66;
  }
`;
    addLumoGlobalStyles("user-color-props", userColors);
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1(
      "vaadin-field-outline",
      css$e`
    :host {
      transition: opacity 0.3s;
      -webkit-mask-image: none !important;
      mask-image: none !important;
    }

    :host::before {
      content: '';
      position: absolute;
      inset: 0;
      box-shadow: 0 0 0 2px var(--_active-user-color);
      border-radius: var(--lumo-border-radius-s);
      transition: box-shadow 0.3s;
    }

    :host([context$='checkbox'])::before {
      box-shadow:
        0 0 0 2px var(--lumo-base-color),
        0 0 0 4px var(--_active-user-color);
    }

    :host([context$='radio-button'])::before {
      border-radius: 50%;
      box-shadow:
        0 0 0 3px var(--lumo-base-color),
        0 0 0 5px var(--_active-user-color);
    }

    :host([context$='item'])::before {
      box-shadow: inset 0 0 0 2px var(--_active-user-color);
    }
  `,
      { moduleId: "lumo-field-outline" }
    );
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1(
      "vaadin-user-tags-overlay",
      [
        overlay,
        css$e`
      [part='overlay'] {
        will-change: opacity, transform;
      }

      :host([opening]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-enter ease-out both;
      }

      @keyframes lumo-user-tags-enter {
        0% {
          opacity: 0;
        }
      }

      :host([closing]) [part='overlay'] {
        animation: 0.1s lumo-user-tags-exit both;
      }

      @keyframes lumo-user-tags-exit {
        100% {
          opacity: 0;
        }
      }
    `
      ],
      {
        moduleId: "lumo-user-tags-overlay"
      }
    );
    registerStyles$1(
      "vaadin-user-tag",
      css$e`
    :host {
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-xxs);
      border-radius: var(--lumo-border-radius-s);
      box-shadow: var(--lumo-box-shadow-xs);
      --vaadin-user-tag-offset: var(--lumo-space-xs);
    }

    [part='name'] {
      color: var(--lumo-primary-contrast-color);
      padding: 0.3em calc(0.3em + var(--lumo-border-radius-s) / 4);
      line-height: 1;
      font-weight: 500;
      min-width: calc(var(--lumo-line-height-xs) * 1em + 0.45em);
    }
  `,
      { moduleId: "lumo-user-tag" }
    );
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class UserTag extends ThemableMixin(DirMixin(PolymerElement)) {
      static get is() {
        return "vaadin-user-tag";
      }
      static get template() {
        return html`
      <style>
        :host {
          display: block;
          box-sizing: border-box;
          margin: 0 0 var(--vaadin-user-tag-offset);
          opacity: 0;
          height: 1.3rem;
          transition: opacity 0.2s ease-in-out;
          background-color: var(--vaadin-user-tag-color);
          color: #fff;
          cursor: default;
          -webkit-user-select: none;
          user-select: none;
          --vaadin-user-tag-offset: 4px;
        }

        :host(.show) {
          opacity: 1;
        }

        :host(:last-of-type) {
          margin-bottom: 0;
        }

        [part='name'] {
          overflow: hidden;
          white-space: nowrap;
          text-overflow: ellipsis;
          box-sizing: border-box;
          padding: 2px 4px;
          height: 1.3rem;
          font-size: 13px;
        }
      </style>
      <div part="name">[[name]]</div>
    `;
      }
      static get properties() {
        return {
          /**
           * Name of the user.
           */
          name: {
            type: String
          },
          /**
           * Id of the user.
           */
          uid: {
            type: String
          },
          /**
           * Color index of the user.
           */
          colorIndex: {
            type: Number,
            observer: "_colorIndexChanged"
          }
        };
      }
      /** @protected */
      ready() {
        super.ready();
        this.addEventListener("mousedown", this._onClick.bind(this), true);
      }
      /** @private */
      _colorIndexChanged(index) {
        if (index != null) {
          this.style.setProperty("--vaadin-user-tag-color", `var(--vaadin-user-color-${index})`);
        }
      }
      /**
       * @param {Event} e
       * @private
       */
      _onClick(e2) {
        e2.preventDefault();
        this.dispatchEvent(
          new CustomEvent("user-tag-click", {
            bubbles: true,
            composed: true,
            detail: {
              name: this.name
            }
          })
        );
      }
    }
    defineCustomElement(UserTag);
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const userTagsOverlayStyles = css$e`
  :host {
    background: transparent;
    box-shadow: none;
  }

  [part='overlay'] {
    box-shadow: none;
    background: transparent;
    position: relative;
    left: -4px;
    padding: 4px;
    outline: none;
    overflow: visible;
  }

  ::slotted([part='tags']) {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
  }

  :host([dir='rtl']) [part='overlay'] {
    left: auto;
    right: -4px;
  }

  [part='content'] {
    padding: 0;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;
    registerStyles$1("vaadin-user-tags-overlay", [overlayStyles$1, userTagsOverlayStyles]);
    class UserTagsOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolymerElement)))) {
      static get is() {
        return "vaadin-user-tags-overlay";
      }
      static get template() {
        return html`
      <div id="backdrop" part="backdrop" hidden$="[[!withBackdrop]]"></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `;
      }
    }
    defineCustomElement(UserTagsOverlay);
    /**
    @license
    Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
    This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
    The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
    The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
    Code distributed by Google as part of the polymer project is also
    subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
    */
    function newSplice(index, removed, addedCount) {
      return {
        index,
        removed,
        addedCount
      };
    }
    const EDIT_LEAVE = 0;
    const EDIT_UPDATE = 1;
    const EDIT_ADD = 2;
    const EDIT_DELETE = 3;
    function calcEditDistances(current, currentStart, currentEnd, old, oldStart, oldEnd) {
      let rowCount = oldEnd - oldStart + 1;
      let columnCount = currentEnd - currentStart + 1;
      let distances = new Array(rowCount);
      for (let i2 = 0; i2 < rowCount; i2++) {
        distances[i2] = new Array(columnCount);
        distances[i2][0] = i2;
      }
      for (let j = 0; j < columnCount; j++)
        distances[0][j] = j;
      for (let i2 = 1; i2 < rowCount; i2++) {
        for (let j = 1; j < columnCount; j++) {
          if (equals$3(current[currentStart + j - 1], old[oldStart + i2 - 1]))
            distances[i2][j] = distances[i2 - 1][j - 1];
          else {
            let north = distances[i2 - 1][j] + 1;
            let west = distances[i2][j - 1] + 1;
            distances[i2][j] = north < west ? north : west;
          }
        }
      }
      return distances;
    }
    function spliceOperationsFromEditDistances(distances) {
      let i2 = distances.length - 1;
      let j = distances[0].length - 1;
      let current = distances[i2][j];
      let edits = [];
      while (i2 > 0 || j > 0) {
        if (i2 == 0) {
          edits.push(EDIT_ADD);
          j--;
          continue;
        }
        if (j == 0) {
          edits.push(EDIT_DELETE);
          i2--;
          continue;
        }
        let northWest = distances[i2 - 1][j - 1];
        let west = distances[i2 - 1][j];
        let north = distances[i2][j - 1];
        let min;
        if (west < north)
          min = west < northWest ? west : northWest;
        else
          min = north < northWest ? north : northWest;
        if (min == northWest) {
          if (northWest == current) {
            edits.push(EDIT_LEAVE);
          } else {
            edits.push(EDIT_UPDATE);
            current = northWest;
          }
          i2--;
          j--;
        } else if (min == west) {
          edits.push(EDIT_DELETE);
          i2--;
          current = west;
        } else {
          edits.push(EDIT_ADD);
          j--;
          current = north;
        }
      }
      edits.reverse();
      return edits;
    }
    function calcSplices(current, currentStart, currentEnd, old, oldStart, oldEnd) {
      let prefixCount = 0;
      let suffixCount = 0;
      let splice;
      let minLength = Math.min(currentEnd - currentStart, oldEnd - oldStart);
      if (currentStart == 0 && oldStart == 0)
        prefixCount = sharedPrefix(current, old, minLength);
      if (currentEnd == current.length && oldEnd == old.length)
        suffixCount = sharedSuffix(current, old, minLength - prefixCount);
      currentStart += prefixCount;
      oldStart += prefixCount;
      currentEnd -= suffixCount;
      oldEnd -= suffixCount;
      if (currentEnd - currentStart == 0 && oldEnd - oldStart == 0)
        return [];
      if (currentStart == currentEnd) {
        splice = newSplice(currentStart, [], 0);
        while (oldStart < oldEnd)
          splice.removed.push(old[oldStart++]);
        return [splice];
      } else if (oldStart == oldEnd)
        return [newSplice(currentStart, [], currentEnd - currentStart)];
      let ops = spliceOperationsFromEditDistances(
        calcEditDistances(
          current,
          currentStart,
          currentEnd,
          old,
          oldStart,
          oldEnd
        )
      );
      splice = void 0;
      let splices = [];
      let index = currentStart;
      let oldIndex = oldStart;
      for (let i2 = 0; i2 < ops.length; i2++) {
        switch (ops[i2]) {
          case EDIT_LEAVE:
            if (splice) {
              splices.push(splice);
              splice = void 0;
            }
            index++;
            oldIndex++;
            break;
          case EDIT_UPDATE:
            if (!splice)
              splice = newSplice(index, [], 0);
            splice.addedCount++;
            index++;
            splice.removed.push(old[oldIndex]);
            oldIndex++;
            break;
          case EDIT_ADD:
            if (!splice)
              splice = newSplice(index, [], 0);
            splice.addedCount++;
            index++;
            break;
          case EDIT_DELETE:
            if (!splice)
              splice = newSplice(index, [], 0);
            splice.removed.push(old[oldIndex]);
            oldIndex++;
            break;
        }
      }
      if (splice) {
        splices.push(splice);
      }
      return splices;
    }
    function sharedPrefix(current, old, searchLength) {
      for (let i2 = 0; i2 < searchLength; i2++)
        if (!equals$3(current[i2], old[i2]))
          return i2;
      return searchLength;
    }
    function sharedSuffix(current, old, searchLength) {
      let index1 = current.length;
      let index2 = old.length;
      let count = 0;
      while (count < searchLength && equals$3(current[--index1], old[--index2]))
        count++;
      return count;
    }
    function calculateSplices(current, previous) {
      return calcSplices(
        current,
        0,
        current.length,
        previous,
        0,
        previous.length
      );
    }
    function equals$3(currentValue, previousValue) {
      return currentValue === previousValue;
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const listenOnce$1 = (elem, type) => {
      return new Promise((resolve) => {
        const listener = () => {
          elem.removeEventListener(type, listener);
          resolve();
        };
        elem.addEventListener(type, listener);
      });
    };
    class UserTags extends PolymerElement {
      static get is() {
        return "vaadin-user-tags";
      }
      static get template() {
        return html`
      <style>
        :host {
          position: absolute;
        }
      </style>
      <vaadin-user-tags-overlay
        id="overlay"
        modeless
        opened="[[opened]]"
        no-vertical-overlap
        on-vaadin-overlay-open="_onOverlayOpen"
      ></vaadin-user-tags-overlay>
    `;
      }
      static get properties() {
        return {
          /**
           * True when the field has focus. In this case, the overlay
           * with a list of the user tags needs to be always visible.
           */
          hasFocus: {
            type: Boolean,
            value: false,
            observer: "_hasFocusChanged"
          },
          /**
           * True when the overlay is opened.
           */
          opened: {
            type: Boolean,
            value: false
          },
          /**
           * True when the overlay is flashing: quickly shown and then hidden
           * once a different user starts to interact with the field.
           */
          flashing: {
            type: Boolean,
            value: false
          },
          /**
           * A target element that the overlay is positioned to.
           */
          target: {
            type: Object,
            observer: "__targetChanged"
          },
          /**
           * A list of users who focused the field.
           */
          users: {
            type: Array,
            value: () => []
          },
          duration: {
            type: Number,
            value: 200
          },
          delay: {
            type: Number,
            value: 2e3
          },
          /** @private */
          __flashQueue: {
            type: Array,
            value: () => []
          },
          /** @private */
          __isTargetVisible: {
            type: Boolean,
            value: false
          }
        };
      }
      constructor() {
        super();
        this.__targetVisibilityObserver = new IntersectionObserver(
          ([entry]) => {
            this.__onTargetVisibilityChange(entry.isIntersecting);
          },
          { threshold: 1 }
        );
      }
      /** @protected */
      get wrapper() {
        return this.$.overlay.querySelector('[part="tags"]');
      }
      /** @protected */
      connectedCallback() {
        super.connectedCallback();
        if (this.target) {
          this.__targetVisibilityObserver.observe(this.target);
        }
      }
      /** @protected */
      disconnectedCallback() {
        super.disconnectedCallback();
        this.opened = false;
        if (this.target) {
          this.__targetVisibilityObserver.unobserve(this.target);
        }
      }
      /** @protected */
      ready() {
        super.ready();
        this.$.overlay.renderer = (root2) => {
          if (!root2.firstChild) {
            const tags = document.createElement("div");
            tags.setAttribute("part", "tags");
            root2.appendChild(tags);
          }
        };
        this.$.overlay.requestContentUpdate();
      }
      /** @private */
      __onTargetVisibilityChange(isVisible) {
        this.__isTargetVisible = isVisible;
        if (isVisible && this.__flashQueue.length > 0 && !this.flashing) {
          this.flashTags(this.__flashQueue.shift());
          return;
        }
        if (isVisible && this.hasFocus) {
          this.opened = true;
          return;
        }
        if (!isVisible && this.opened) {
          this.opened = false;
        }
      }
      /** @private */
      __targetChanged(newTarget, oldTarget) {
        this.$.overlay.positionTarget = newTarget;
        if (oldTarget) {
          this.__targetVisibilityObserver.unobserve(oldTarget);
        }
        if (newTarget) {
          this.__targetVisibilityObserver.observe(newTarget);
        }
      }
      /** @private */
      _hasFocusChanged(hasFocus) {
        if (hasFocus && this.flashing) {
          this.stopFlash();
        }
      }
      createUserTag(user) {
        const tag = document.createElement("vaadin-user-tag");
        tag.name = user.name;
        tag.uid = user.id;
        tag.colorIndex = user.colorIndex;
        return tag;
      }
      getTagForUser(user) {
        return Array.from(this.wrapper.children).find((tag) => tag.uid === user.id);
      }
      getChangedTags(addedUsers, removedUsers) {
        const removed = removedUsers.map((user) => this.getTagForUser(user));
        const added = addedUsers.map((user) => this.getTagForUser(user) || this.createUserTag(user));
        return { added, removed };
      }
      getChangedUsers(users, splices) {
        const usersToAdd = [];
        const usersToRemove = [];
        splices.forEach((splice) => {
          splice.removed.forEach((user) => {
            usersToRemove.push(user);
          });
          for (let i2 = splice.addedCount - 1; i2 >= 0; i2--) {
            usersToAdd.push(users[splice.index + i2]);
          }
        });
        const addedUsers = usersToAdd.filter((u2) => !usersToRemove.some((u22) => u2.id === u22.id));
        const removedUsers = usersToRemove.filter((u2) => !usersToAdd.some((u22) => u2.id === u22.id));
        return { addedUsers, removedUsers };
      }
      applyTagsStart({ added, removed }) {
        const wrapper = this.wrapper;
        removed.forEach((tag) => {
          if (tag) {
            tag.classList.add("removing");
            tag.classList.remove("show");
          }
        });
        added.forEach((tag) => wrapper.insertBefore(tag, wrapper.firstChild));
      }
      applyTagsEnd({ added, removed }) {
        const wrapper = this.wrapper;
        removed.forEach((tag) => {
          if (tag && tag.parentNode === wrapper) {
            wrapper.removeChild(tag);
          }
        });
        added.forEach((tag) => tag && tag.classList.add("show"));
      }
      setUsers(users) {
        this.requestContentUpdate();
        const splices = calculateSplices(users, this.users);
        if (splices.length === 0) {
          return;
        }
        const { addedUsers, removedUsers } = this.getChangedUsers(users, splices);
        if (addedUsers.length === 0 && removedUsers.length === 0) {
          return;
        }
        const changedTags = this.getChangedTags(addedUsers, removedUsers);
        if (this.__flashQueue.length > 0) {
          removedUsers.forEach((user, i2) => {
            if (changedTags.removed[i2] === null) {
              return;
            }
            this.__flashQueue.forEach((tags) => {
              if (tags.some((tag) => tag.uid === user.id)) {
                this.splice("__flashQueue", i2, 1);
              }
            });
          });
        }
        if (this.opened && this.hasFocus) {
          this.updateTags(users, changedTags);
        } else if (addedUsers.length > 0 && document.visibilityState !== "hidden") {
          const addedTags = changedTags.added;
          const removedTags = changedTags.removed;
          this.updateTagsSync(users, {
            added: [],
            removed: removedTags
          });
          if (this.flashing || !this.__isTargetVisible) {
            this.push("__flashQueue", addedTags);
          } else {
            this.flashTags(addedTags);
          }
        } else {
          this.updateTagsSync(users, changedTags);
        }
      }
      /** @private */
      _onOverlayOpen() {
        Array.from(this.wrapper.children).forEach((tag) => {
          if (!tag.classList.contains("removing")) {
            tag.classList.add("show");
          }
        });
      }
      flashTags(added) {
        this.flashing = true;
        const wrapper = this.wrapper;
        const hidden = Array.from(wrapper.children);
        hidden.forEach((tag) => {
          tag.style.display = "none";
        });
        added.forEach((tag) => {
          wrapper.insertBefore(tag, wrapper.firstChild);
        });
        this.flashPromise = new Promise((resolve) => {
          listenOnce$1(this.$.overlay, "vaadin-overlay-open").then(() => {
            this._debounceFlashStart = Debouncer$1.debounce(
              this._debounceFlashStart,
              timeOut.after(this.duration + this.delay),
              () => {
                if (!this.hasFocus) {
                  added.forEach((tag) => tag.classList.remove("show"));
                }
                this._debounceFlashEnd = Debouncer$1.debounce(this._debounceFlashEnd, timeOut.after(this.duration), () => {
                  const finishFlash = () => {
                    hidden.forEach((tag) => {
                      tag.style.display = "block";
                    });
                    this.flashing = false;
                    resolve();
                  };
                  if (this.hasFocus) {
                    finishFlash();
                  } else {
                    listenOnce$1(this.$.overlay, "animationend").then(() => {
                      finishFlash();
                    });
                    this.opened = false;
                  }
                });
              }
            );
          });
        }).then(() => {
          if (this.__flashQueue.length > 0) {
            const tags = this.__flashQueue[0];
            this.splice("__flashQueue", 0, 1);
            this.flashTags(tags);
          }
        });
        this.opened = true;
      }
      stopFlash() {
        if (this._debounceFlashStart) {
          this._debounceFlashStart.flush();
        }
        if (this._debounceFlashEnd) {
          this._debounceFlashEnd.flush();
        }
        this.$.overlay._flushAnimation("closing");
      }
      updateTags(users, changed) {
        this.applyTagsStart(changed);
        this._debounceRender = Debouncer$1.debounce(this._debounceRender, timeOut.after(this.duration), () => {
          this.set("users", users);
          this.applyTagsEnd(changed);
          if (users.length === 0 && this.opened) {
            this.opened = false;
          }
        });
      }
      updateTagsSync(users, changed) {
        this.applyTagsStart(changed);
        this.set("users", users);
        this.applyTagsEnd(changed);
      }
      show() {
        this.hasFocus = true;
        if (this.__isTargetVisible) {
          this.opened = true;
        }
      }
      hide() {
        this.hasFocus = false;
        this.opened = false;
      }
      requestContentUpdate() {
        if (this._debounceRender && this._debounceRender.isActive()) {
          this._debounceRender.flush();
        }
      }
    }
    defineCustomElement(UserTags);
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class FieldOutline extends ThemableMixin(DirMixin(PolymerElement)) {
      static get is() {
        return "vaadin-field-outline";
      }
      static get template() {
        return html`
      <style>
        :host {
          display: block;
          box-sizing: border-box;
          position: absolute;
          inset: 0;
          width: 100%;
          height: 100%;
          pointer-events: none;
          user-select: none;
          opacity: 0;
          --_active-user-color: transparent;
        }

        :host([has-active-user]) {
          opacity: 1;
        }
      </style>
    `;
      }
      static get properties() {
        return {
          /**
           * A user who last interacted with the field.
           */
          user: {
            type: Object,
            value: null,
            observer: "_userChanged"
          }
        };
      }
      /** @protected */
      ready() {
        super.ready();
        this.setAttribute("part", "outline");
        this._field = this.getRootNode().host;
      }
      /** @private */
      _userChanged(user) {
        this.toggleAttribute("has-active-user", Boolean(user));
        const value = user ? `var(--vaadin-user-color-${user.colorIndex})` : "transparent";
        const prop = "--_active-user-color";
        this.style.setProperty(prop, value);
        if (this._field) {
          this._field.style.setProperty(prop, value);
        }
      }
    }
    defineCustomElement(FieldOutline);
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const getOutlineTarget = (element, tagName) => {
      switch (tagName) {
        case "vaadin-big-decimal-field":
        case "vaadin-combo-box":
        case "vaadin-date-picker":
        case "vaadin-email-field":
        case "vaadin-integer-field":
        case "vaadin-number-field":
        case "vaadin-password-field":
        case "vaadin-select":
        case "vaadin-text-area":
        case "vaadin-text-field":
        case "vaadin-time-picker":
          return element.shadowRoot.querySelector('[part="input-field"]');
        case "vaadin-checkbox":
          return element.shadowRoot.querySelector('[part="checkbox"]');
        case "vaadin-radio-button":
          return element.shadowRoot.querySelector('[part="radio"]');
        default:
          return element;
      }
    };
    const fields = /* @__PURE__ */ new WeakMap();
    const initOutline = (field) => {
      if (!fields.has(field)) {
        const tagName = field.tagName.toLowerCase();
        const target = getOutlineTarget(field, tagName);
        target.style.position = "relative";
        if (tagName.endsWith("text-area")) {
          target.style.overflow = "visible";
        }
        const style = document.createElement("style");
        style.textContent = `
      :host([active]) [part="outline"],
      :host([focus-ring]) [part="outline"] {
        display: none;
      }
    `;
        field.shadowRoot.appendChild(style);
        const outline = document.createElement("vaadin-field-outline");
        (target === field ? field.shadowRoot : target).appendChild(outline);
        outline.setAttribute("context", tagName);
        fields.set(field, { root: field, target, outline });
      }
      return fields.get(field);
    };
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class ComponentObserver {
      constructor(component) {
        this.component = component;
        this.initTags(component);
      }
      getFields() {
        return [this.component];
      }
      getFieldIndex(field) {
        return this.getFields().indexOf(field);
      }
      getFocusTarget(_event) {
        return this.component;
      }
      initTags(component) {
        const tags = document.createElement("vaadin-user-tags");
        component.shadowRoot.appendChild(tags);
        tags.target = component;
        this._tags = tags;
        component.addEventListener("mouseenter", (event) => {
          if (event.relatedTarget === this._tags.$.overlay) {
            return;
          }
          this._mouse = true;
          this._mouseDebouncer = Debouncer$1.debounce(this._mouseDebouncer, timeOut.after(200), () => {
            if (this._mouse) {
              this._tags.show();
            }
          });
        });
        component.addEventListener("mouseleave", (event) => {
          if (event.relatedTarget === this._tags.$.overlay) {
            return;
          }
          this._mouse = false;
          if (!this._hasFocus) {
            this._tags.hide();
          }
        });
        component.addEventListener("vaadin-highlight-show", (_event) => {
          this._hasFocus = true;
          if (this._debouncer && this._debouncer.isActive()) {
            this._debouncer.cancel();
          } else {
            this._tags.show();
          }
        });
        component.addEventListener("vaadin-highlight-hide", (_event) => {
          this._hasFocus = false;
          if (!this._mouse) {
            this._debouncer = Debouncer$1.debounce(this._debouncer, timeOut.after(1), () => {
              this._tags.hide();
            });
          }
        });
        this._tags.$.overlay.addEventListener("mouseleave", (event) => {
          if (event.relatedTarget === component) {
            return;
          }
          this._mouse = false;
          if (!component.hasAttribute("focused")) {
            this._tags.hide();
          }
        });
      }
      setOutlines(users) {
        const fields2 = this.getFields();
        fields2.forEach((field, idx) => {
          const { outline } = initOutline(field);
          const index = fields2.length === 1 ? 0 : users.map((user) => user.fieldIndex).indexOf(idx);
          outline.user = users[index];
        });
      }
      showOutline(field) {
        this.fire("show", field);
      }
      hideOutline(field) {
        this.fire("hide", field);
      }
      fire(action, field) {
        this.component.dispatchEvent(
          new CustomEvent(`vaadin-highlight-${action}`, {
            bubbles: true,
            composed: true,
            detail: { fieldIndex: this.getFieldIndex(field) }
          })
        );
      }
      redraw(users) {
        this._tags.setUsers(users);
        this.setOutlines(users);
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class FieldObserver extends ComponentObserver {
      constructor(field) {
        super(field);
        this.addListeners(field);
      }
      addListeners(field) {
        field.addEventListener("focusin", (event) => this.onFocusIn(event));
        field.addEventListener("focusout", (event) => this.onFocusOut(event));
      }
      onFocusIn(event) {
        const target = this.getFocusTarget(event);
        this.showOutline(target);
      }
      onFocusOut(event) {
        const target = this.getFocusTarget(event);
        this.hideOutline(target);
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class CheckboxGroupObserver extends FieldObserver {
      getFields() {
        return this.component.__checkboxes;
      }
      getFocusTarget(event) {
        const fields2 = this.getFields();
        return Array.from(event.composedPath()).find((node) => fields2.includes(node));
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class DatePickerObserver extends ComponentObserver {
      constructor(datePicker2) {
        super(datePicker2);
        this.datePicker = datePicker2;
        this.fullscreenFocus = false;
        this.blurWhileOpened = false;
        this.addListeners(datePicker2);
      }
      addListeners(datePicker2) {
        this.overlay = datePicker2.$.overlay;
        datePicker2.addEventListener("blur", (event) => this.onBlur(event), true);
        datePicker2.addEventListener("opened-changed", (event) => this.onOpenedChanged(event));
        this.overlay.addEventListener("focusout", (event) => this.onOverlayFocusOut(event));
        datePicker2.addEventListener("focusin", (event) => this.onFocusIn(event));
        datePicker2.addEventListener("focusout", (event) => this.onFocusOut(event));
      }
      isEventInOverlay(node) {
        return this.datePicker._overlayContent && this.datePicker._overlayContent.contains(node);
      }
      onBlur(event) {
        const datePicker2 = this.datePicker;
        if (datePicker2._fullscreen && !this.isEventInOverlay(event.relatedTarget)) {
          this.fullscreenFocus = true;
        }
      }
      onFocusIn(event) {
        if (this.isEventInOverlay(event.relatedTarget)) {
          return;
        }
        if (this.blurWhileOpened) {
          this.blurWhileOpened = false;
          return;
        }
        this.showOutline(this.datePicker);
      }
      onFocusOut(event) {
        if (this.fullscreenFocus || this.isEventInOverlay(event.relatedTarget)) ;
        else if (!this.datePicker.opened) {
          this.hideOutline(this.datePicker);
        } else {
          this.blurWhileOpened = true;
        }
      }
      onOverlayFocusOut(event) {
        if (!this.datePicker.contains(event.relatedTarget)) {
          this.blurWhileOpened = true;
        }
      }
      onOpenedChanged(event) {
        if (event.detail.value === true && this.fullscreenFocus) {
          this.fullscreenFocus = false;
          this.showOutline(this.datePicker);
        }
        if (event.detail.value === false && this.blurWhileOpened) {
          this.blurWhileOpened = false;
          this.hideOutline(this.datePicker);
        }
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class DateObserver extends DatePickerObserver {
      constructor(datePicker2, host) {
        super(datePicker2);
        this.component = host;
      }
      getFieldIndex() {
        return 0;
      }
    }
    class TimeObserver extends FieldObserver {
      constructor(timePicker2, host) {
        super(timePicker2);
        this.component = host;
        this.timePicker = timePicker2;
      }
      getFocusTarget(_event) {
        return this.timePicker;
      }
      getFieldIndex() {
        return 1;
      }
    }
    class DateTimePickerObserver extends ComponentObserver {
      constructor(picker) {
        super(picker);
        const [datePicker2, timePicker2] = this.getFields();
        this.dateObserver = new DateObserver(datePicker2, picker);
        this.timeObserver = new TimeObserver(timePicker2, picker);
      }
      getFields() {
        return this.component.__inputs;
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class ListBoxObserver extends FieldObserver {
      getFields() {
        return this.component.items || [];
      }
      getFocusTarget(event) {
        const fields2 = this.getFields();
        return Array.from(event.composedPath()).find((node) => fields2.includes(node));
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class RadioGroupObserver extends FieldObserver {
      getFields() {
        return this.component.__radioButtons;
      }
      getFocusTarget(event) {
        const fields2 = this.getFields();
        return Array.from(event.composedPath()).find((node) => fields2.includes(node));
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class SelectObserver extends FieldObserver {
      constructor(select) {
        super(select);
        this.blurWhileOpened = false;
        this.overlay = select._overlayElement;
      }
      addListeners(select) {
        super.addListeners(select);
        select.addEventListener("opened-changed", (event) => {
          if (select._phone && event.detail.value === false) {
            this.hideOutline(select);
          }
        });
      }
      onFocusIn(event) {
        if (this.overlay.contains(event.relatedTarget)) {
          return;
        }
        if (!this.component._phone && this.overlay.hasAttribute("closing")) {
          return;
        }
        super.onFocusIn(event);
      }
      onFocusOut(event) {
        if (this.overlay.contains(event.relatedTarget)) {
          return;
        }
        super.onFocusOut(event);
      }
    }
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const initFieldObserver = (field) => {
      let result2;
      switch (field.tagName.toLowerCase()) {
        case "vaadin-date-picker":
          result2 = new DatePickerObserver(field);
          break;
        case "vaadin-date-time-picker":
          result2 = new DateTimePickerObserver(field);
          break;
        case "vaadin-select":
          result2 = new SelectObserver(field);
          break;
        case "vaadin-checkbox-group":
          result2 = new CheckboxGroupObserver(field);
          break;
        case "vaadin-radio-group":
          result2 = new RadioGroupObserver(field);
          break;
        case "vaadin-list-box":
          result2 = new ListBoxObserver(field);
          break;
        default:
          result2 = new FieldObserver(field);
      }
      return result2;
    };
    class FieldHighlighterController {
      constructor(host) {
        this.host = host;
        this.user = null;
        this.users = [];
      }
      get user() {
        return this._user;
      }
      set user(user) {
        this._user = user;
        if (user) {
          const msg = `${user.name} started editing`;
          const { label } = this.host;
          announce(label ? `${msg} ${label}` : msg);
        }
      }
      hostConnected() {
        this.redraw();
      }
      addUser(user) {
        if (user) {
          this.users.push(user);
          this.redraw();
          this.user = user;
        }
      }
      setUsers(users) {
        if (Array.isArray(users)) {
          this.users = users;
          this.redraw();
          this.user = users[users.length - 1] || null;
        }
      }
      removeUser(user) {
        if (user && user.id !== void 0) {
          let index;
          for (let i2 = 0; i2 < this.users.length; i2++) {
            if (this.users[i2].id === user.id) {
              index = i2;
              break;
            }
          }
          if (index !== void 0) {
            this.users.splice(index, 1);
            this.redraw();
            if (this.users.length > 0) {
              this.user = this.users[this.users.length - 1];
            } else {
              this.user = null;
            }
          }
        }
      }
      redraw() {
        this.observer.redraw([...this.users].reverse());
      }
    }
    class FieldHighlighter extends HTMLElement {
      static get is() {
        return "vaadin-field-highlighter";
      }
      static init(field) {
        if (!field._highlighterController) {
          const instance = new FieldHighlighterController(field);
          field.setAttribute("has-highlighter", "");
          instance.observer = initFieldObserver(field);
          field.addController(instance);
          field._highlighterController = instance;
        }
        return field._highlighterController;
      }
      static addUser(field, user) {
        this.init(field).addUser(user);
      }
      static removeUser(field, user) {
        this.init(field).removeUser(user);
      }
      static setUsers(field, users) {
        this.init(field).setUsers(users);
      }
    }
    defineCustomElement(FieldHighlighter);
    /**
     * @license
     * Copyright (c) 2021 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    let moduleIdIndex = 0;
    function registerStyles(themeFor, styles = [], options = {}) {
      const themeId = options.moduleId || `custom-style-module-${moduleIdIndex}`;
      moduleIdIndex += 1;
      const module2 = document.createElement("dom-module");
      if (themeFor) {
        module2.setAttribute("theme-for", themeFor);
      }
      const includeStylesToTemplate = !!(styles.length && options.moduleId);
      const moduleIncludes = [].concat(options.include || []);
      if (moduleIncludes.length === 0) {
        module2.__allStyles = styles;
      } else if (!includeStylesToTemplate) {
        module2.__partialStyles = styles;
      }
      module2.innerHTML = `
    <template>
      ${moduleIncludes.map((include) => `<style include=${include}></style>`)}
      ${includeStylesToTemplate ? `<style>${styles.map((style) => style.cssText).join("\n")}</style>` : ""}
    </template>
  `;
      module2.register(themeId);
    }
    function getModuleStyles(module2) {
      return stylesFromTemplate(module2.querySelector("template")).map((styleElement) => {
        return unsafeCSS(styleElement.textContent);
      });
    }
    function getAllThemes() {
      const domModule = DomModule;
      const modules = domModule.prototype.modules;
      return Object.keys(modules).map((moduleId) => {
        const module2 = modules[moduleId];
        const themeFor = module2.getAttribute("theme-for");
        if (!module2.__allStyles) {
          module2.__allStyles = getModuleStyles(module2).concat(module2.__partialStyles || []);
        }
        return {
          themeFor,
          moduleId,
          styles: module2.__allStyles
        };
      });
    }
    if (!window.Vaadin) {
      window.Vaadin = {};
    }
    window.Vaadin.styleModules = {
      getAllThemes,
      registerStyles
    };
    if (themeRegistry && themeRegistry.length > 0) {
      themeRegistry.forEach((theme2) => {
        registerStyles(theme2.themeFor, theme2.styles, {
          moduleId: theme2.moduleId,
          include: theme2.include
        });
      });
      themeRegistry.length = 0;
    }
    const accordionHeading$1 = css$e`
  :host {
    padding: 0;
  }

  [part='content'] {
    padding: var(--lumo-space-s) 0;
  }

  :host([theme~='filled']) {
    padding-top: 0;
    padding-bottom: 0;
  }
`;
    registerStyles$1("vaadin-accordion-heading", [detailsSummary, accordionHeading$1], { moduleId: "lumo-accordion-heading" });
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const accordionHeading = css$e`
  :host {
    display: block;
    outline: none;
    -webkit-user-select: none;
    -moz-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  button {
    display: flex;
    align-items: center;
    justify-content: inherit;
    width: 100%;
    margin: 0;
    padding: 0;
    background-color: initial;
    color: inherit;
    border: initial;
    outline: none;
    font: inherit;
    text-align: inherit;
  }
`;
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1("vaadin-accordion-heading", accordionHeading, { moduleId: "vaadin-accordion-heading-styles" });
    class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolymerElement))) {
      static get is() {
        return "vaadin-accordion-heading";
      }
      static get template() {
        return html`
      <button id="button" part="content" disabled$="[[disabled]]" aria-expanded$="[[__updateAriaExpanded(opened)]]">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `;
      }
      static get properties() {
        return {
          /**
           * When true, the element is opened.
           */
          opened: {
            type: Boolean,
            reflectToAttribute: true
          }
        };
      }
      /**
       * @param {DocumentFragment} dom
       * @return {null}
       * @protected
       * @override
       */
      _attachDom(dom) {
        const root2 = this.attachShadow({ mode: "open", delegatesFocus: true });
        root2.appendChild(dom);
        return root2;
      }
      /** @protected */
      ready() {
        super.ready();
        if (!this.hasAttribute("role")) {
          this.setAttribute("role", "heading");
        }
      }
      /** @private */
      __updateAriaExpanded(opened) {
        return opened ? "true" : "false";
      }
    }
    defineCustomElement(AccordionHeading);
    const accordionPanel$1 = css$e`
  :host {
    margin: 0;
    border-bottom: solid 1px var(--lumo-contrast-10pct);
  }

  :host(:last-child) {
    border-bottom: none;
  }

  :host([theme~='filled']) {
    border-bottom: none;
  }

  :host([theme~='filled']:not(:last-child)) {
    margin-bottom: 2px;
  }
`;
    registerStyles$1("vaadin-accordion-panel", [details, accordionPanel$1], { moduleId: "lumo-accordion-panel" });
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const AccordionPanelMixin = (superClass) => class AccordionPanelMixinClass extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(superClass))) {
      static get properties() {
        return {
          /**
           * A text that is displayed in the heading, if no
           * element is assigned to the `summary` slot.
           */
          summary: {
            type: String,
            observer: "_summaryChanged"
          }
        };
      }
      static get observers() {
        return ["__updateAriaAttributes(focusElement, _contentElements)"];
      }
      static get delegateAttrs() {
        return ["theme"];
      }
      static get delegateProps() {
        return ["disabled", "opened"];
      }
      constructor() {
        super();
        this._summaryController = new SummaryController(this, "vaadin-accordion-heading");
        this._summaryController.addEventListener("slot-content-changed", (event) => {
          const { node } = event.target;
          this._setFocusElement(node);
          this.stateTarget = node;
          this._tooltipController.setTarget(node);
        });
        this._tooltipController = new TooltipController(this);
        this._tooltipController.setPosition("bottom-start");
      }
      /** @protected */
      ready() {
        super.ready();
        this.addController(this._summaryController);
        this.addController(this._tooltipController);
      }
      /**
       * Override method inherited from `DisabledMixin`
       * to not set `aria-disabled` on the host element.
       *
       * @protected
       * @override
       */
      _setAriaDisabled() {
      }
      /** @private */
      _summaryChanged(summary) {
        this._summaryController.setSummary(summary);
      }
      /** @private */
      __updateAriaAttributes(focusElement, contentElements) {
        if (focusElement && contentElements) {
          const node = contentElements[0];
          if (node) {
            node.setAttribute("role", "region");
            node.setAttribute("aria-labelledby", focusElement.id);
          }
          if (node && node.id) {
            focusElement.setAttribute("aria-controls", node.id);
          } else {
            focusElement.removeAttribute("aria-controls");
          }
        }
      }
    };
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const accordionPanel = css$e`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    display: none;
    overflow: hidden;
  }

  :host([opened]) [part='content'] {
    display: block;
    overflow: visible;
  }
`;
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1("vaadin-accordion-panel", accordionPanel, { moduleId: "vaadin-accordion-panel-styles" });
    class AccordionPanel extends AccordionPanelMixin(ThemableMixin(ControllerMixin(PolymerElement))) {
      static get is() {
        return "vaadin-accordion-panel";
      }
      static get template() {
        return html`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `;
      }
    }
    defineCustomElement(AccordionPanel);
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const AccordionMixin = (superClass) => class AccordionMixinClass extends KeyboardDirectionMixin(superClass) {
      static get properties() {
        return {
          /**
           * The index of currently opened panel. First panel is opened by
           * default. Only one panel can be opened at the same time.
           * Setting null or undefined closes all the accordion panels.
           * @type {number}
           */
          opened: {
            type: Number,
            value: 0,
            notify: true,
            reflectToAttribute: true
          },
          /**
           * The list of `<vaadin-accordion-panel>` child elements.
           * It is populated from the elements passed to the light DOM,
           * and updated dynamically when adding or removing panels.
           * @type {!Array<!AccordionPanel>}
           */
          items: {
            type: Array,
            readOnly: true,
            notify: true
          }
        };
      }
      static get observers() {
        return ["_updateItems(items, opened)"];
      }
      constructor() {
        super();
        this._boundUpdateOpened = this._updateOpened.bind(this);
      }
      /**
       * Override getter from `KeyboardDirectionMixin`
       * to check if the heading element has focus.
       *
       * @return {Element | null}
       * @protected
       * @override
       */
      get focused() {
        return (this._getItems() || []).find((item2) => isElementFocused(item2.focusElement));
      }
      /**
       * @protected
       * @override
       */
      focus() {
        if (this._observer) {
          this._observer.flush();
        }
        super.focus();
      }
      /** @protected */
      ready() {
        super.ready();
        const slot = this.shadowRoot.querySelector("slot");
        this._observer = new SlotObserver(slot, (info) => {
          this._setItems(this._filterItems(Array.from(this.children)));
          this._filterItems(info.addedNodes).forEach((el) => {
            el.addEventListener("opened-changed", this._boundUpdateOpened);
          });
        });
      }
      /**
       * Override method inherited from `KeyboardDirectionMixin`
       * to use the stored list of accordion panels as items.
       *
       * @return {Element[]}
       * @protected
       * @override
       */
      _getItems() {
        return this.items;
      }
      /**
       * @param {!Array<!Element>} array
       * @return {!Array<!AccordionPanel>}
       * @protected
       */
      _filterItems(array) {
        return array.filter((el) => el instanceof customElements.get("vaadin-accordion-panel"));
      }
      /** @private */
      _updateItems(items, opened) {
        if (items) {
          const itemToOpen = items[opened];
          items.forEach((item2) => {
            item2.opened = item2 === itemToOpen;
          });
        }
      }
      /**
       * Override an event listener from `KeyboardMixin`
       * to only handle details toggle buttons events.
       *
       * @param {!KeyboardEvent} event
       * @protected
       * @override
       */
      _onKeyDown(event) {
        if (!this.items.some((item2) => item2.focusElement === event.target)) {
          return;
        }
        super._onKeyDown(event);
      }
      /** @private */
      _updateOpened(e2) {
        const target = this._filterItems(e2.composedPath())[0];
        const idx = this.items.indexOf(target);
        if (e2.detail.value) {
          if (target.disabled || idx === -1) {
            return;
          }
          this.opened = idx;
        } else if (!this.items.some((item2) => item2.opened)) {
          this.opened = null;
        }
      }
    };
    /**
     * @license
     * Copyright (c) 2019 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolymerElement))) {
      static get template() {
        return html`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `;
      }
      static get is() {
        return "vaadin-accordion";
      }
    }
    defineCustomElement(Accordion);
    registerStyles$1(
      "vaadin-app-layout",
      css$e`
    [part='navbar'],
    [part='drawer'] {
      background-color: var(--lumo-base-color);
      background-clip: padding-box;
    }

    [part='navbar'] {
      min-height: var(--lumo-size-xl);
      border-bottom: 1px solid var(--lumo-contrast-10pct);
    }

    [part='navbar'][bottom] {
      border-bottom: none;
      border-top: 1px solid var(--lumo-contrast-10pct);
    }

    [part='drawer'] {
      border-inline-end: 1px solid var(--lumo-contrast-10pct);
    }

    :host([overlay]) [part='drawer'] {
      border-inline-end: none;
      box-shadow: var(--lumo-box-shadow-s);
    }

    :host([primary-section='navbar']) [part='navbar'] {
      border: none;
      background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    }

    :host([primary-section='drawer']:not([overlay])) [part='drawer'] {
      background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
    }

    [part='backdrop'] {
      background-color: var(--lumo-shade-20pct);
      opacity: 1;
    }

    [part] ::slotted(h2),
    [part] ::slotted(h3),
    [part] ::slotted(h4) {
      margin-top: var(--lumo-space-xs) !important;
      margin-bottom: var(--lumo-space-xs) !important;
    }
  `,
      { moduleId: "lumo-app-layout" }
    );
    /**
     * @license
     * Copyright (c) 2018 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    function _detectIosNavbar() {
      if (isIOS) {
        const innerHeight = window.innerHeight;
        const innerWidth = window.innerWidth;
        const landscape = innerWidth > innerHeight;
        const clientHeight = document.documentElement.clientHeight;
        if (landscape && clientHeight > innerHeight) {
          document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom", `${clientHeight - innerHeight}px`);
        } else {
          document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom", "");
        }
      }
    }
    _detectIosNavbar();
    window.addEventListener("resize", _detectIosNavbar);
    const template$6 = document.createElement("template");
    template$6.innerHTML = `
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;
    document.head.appendChild(template$6.content);
    /**
     * @license
     * Copyright (c) 2018 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class AppLayout extends ElementMixin(ThemableMixin(ControllerMixin(PolymerElement))) {
      static get template() {
        return html`
      <style>
        :host {
          display: block;
          box-sizing: border-box;
          height: 100%;
          --vaadin-app-layout-transition: 200ms;
          transition: padding var(--vaadin-app-layout-transition);
          --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 16em);
          --vaadin-app-layout-touch-optimized: false;
          --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
          --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
          padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
          padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
        }

        :host([hidden]),
        [hidden] {
          display: none !important;
        }

        :host([no-anim]) {
          --vaadin-app-layout-transition: none !important;
        }

        :host([drawer-opened]) {
          --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
        }

        :host([overlay]) {
          --vaadin-app-layout-drawer-offset-left: 0;
          --vaadin-app-layout-navbar-offset-left: 0;
        }

        :host(:not([no-scroll])) [content] {
          overflow: auto;
        }

        [content] {
          height: 100%;
        }

        @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
          :host {
            --vaadin-app-layout-touch-optimized: true;
          }
        }

        [part='navbar'] {
          position: fixed;
          display: flex;
          align-items: center;
          top: 0;
          inset-inline: 0;
          transition: inset-inline-start var(--vaadin-app-layout-transition);
          padding-top: var(--safe-area-inset-top);
          padding-left: var(--safe-area-inset-left);
          padding-right: var(--safe-area-inset-right);
          z-index: 1;
        }

        :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
          inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
        }

        :host([primary-section='drawer']) [part='drawer'] {
          top: 0;
        }

        [part='navbar'][bottom] {
          top: auto;
          bottom: 0;
          padding-bottom: var(--safe-area-inset-bottom);
        }

        [part='drawer'] {
          overflow: auto;
          position: fixed;
          top: var(--vaadin-app-layout-navbar-offset-top, 0);
          bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
          inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
          transition:
            transform var(--vaadin-app-layout-transition),
            visibility var(--vaadin-app-layout-transition);
          transform: translateX(-100%);
          max-width: 90%;
          width: var(--_vaadin-app-layout-drawer-width);
          box-sizing: border-box;
          padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
          outline: none;
          /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
          visibility: hidden;
          display: flex;
          flex-direction: column;
        }

        :host([drawer-opened]) [part='drawer'] {
          /* The drawer should be accessible by the tabbing navigation when it is opened. */
          visibility: visible;
          transform: translateX(0%);
          touch-action: manipulation;
        }

        [part='backdrop'] {
          background-color: #000;
          opacity: 0.3;
        }

        :host(:not([drawer-opened])) [part='backdrop'] {
          opacity: 0;
        }

        :host([overlay]) [part='backdrop'] {
          position: fixed;
          inset: 0;
          pointer-events: none;
          transition: opacity var(--vaadin-app-layout-transition);
          -webkit-tap-highlight-color: transparent;
        }

        :host([overlay]) [part='drawer'] {
          top: 0;
          bottom: 0;
        }

        :host([overlay]) [part='drawer'],
        :host([overlay]) [part='backdrop'] {
          z-index: 2;
        }

        :host([drawer-opened][overlay]) [part='backdrop'] {
          pointer-events: auto;
          touch-action: manipulation;
        }

        :host([dir='rtl']) [part='drawer'] {
          transform: translateX(100%);
        }

        :host([dir='rtl'][drawer-opened]) [part='drawer'] {
          transform: translateX(0%);
        }

        :host([drawer-opened]:not([overlay])) {
          padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
        }

        @media (max-width: 800px), (max-height: 600px) {
          :host {
            --vaadin-app-layout-drawer-overlay: true;
            --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 20em);
          }
        }

        /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
        [part='drawer'] ::slotted(vaadin-scroller) {
          flex: 1;
          overscroll-behavior: contain;
        }
      </style>
      <div part="navbar" id="navbarTop">
        <slot name="navbar" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
      <div part="backdrop" on-click="_onBackdropClick" on-touchend="_onBackdropTouchend"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" on-slotchange="_updateDrawerSize"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" on-slotchange="_updateTouchOptimizedMode"></slot>
      </div>
    `;
      }
      static get is() {
        return "vaadin-app-layout";
      }
      static get properties() {
        return {
          /**
           * The object used to localize this component.
           * To change the default localization, replace the entire
           * `i18n` object with a custom one.
           *
           * To update individual properties, extend the existing i18n object as follows:
           * ```js
           * appLayout.i18n = {
           *   ...appLayout.i18n,
           *   drawer: 'Drawer'
           * }
           * ```
           *
           * The object has the following structure and default values:
           * ```
           * {
           *   drawer: 'Drawer'
           * }
           * ```
           *
           * @type {AppLayoutI18n}
           * @default {English/US}
           */
          i18n: {
            type: Object,
            observer: "__i18nChanged",
            value: () => {
              return {
                drawer: "Drawer"
              };
            }
          },
          /**
           * Defines whether navbar or drawer will come first visually.
           * - By default (`primary-section="navbar"`), the navbar takes the full available width and moves the drawer down.
           * - If `primary-section="drawer"` is set, then the drawer will move the navbar, taking the full available height.
           * @attr {navbar|drawer} primary-section
           * @type {!PrimarySection}
           */
          primarySection: {
            type: String,
            value: "navbar",
            notify: true,
            reflectToAttribute: true,
            observer: "__primarySectionChanged"
          },
          /**
           * Controls whether the drawer is opened (visible) or not.
           * Its default value depends on the viewport:
           * - `true`, for desktop size views
           * - `false`, for mobile size views
           * @attr {boolean} drawer-opened
           * @type {boolean}
           */
          drawerOpened: {
            type: Boolean,
            notify: true,
            value: true,
            reflectToAttribute: true,
            observer: "__drawerOpenedChanged"
          },
          /**
           * Drawer is an overlay on top of the content
           * Controlled via CSS using `--vaadin-app-layout-drawer-overlay: true|false`;
           * @type {boolean}
           */
          overlay: {
            type: Boolean,
            notify: true,
            readOnly: true,
            value: false,
            reflectToAttribute: true
          },
          /**
           * A global event that causes the drawer to close (be hidden) when it is in overlay mode.
           * - The default is `vaadin-router-location-changed` dispatched by Vaadin Router
           *
           * @attr {string} close-drawer-on
           * @type {string}
           */
          closeDrawerOn: {
            type: String,
            value: "vaadin-router-location-changed",
            observer: "_closeDrawerOnChanged"
          }
        };
      }
      /**
       * Helper static method that dispatches a `close-overlay-drawer` event
       */
      static dispatchCloseOverlayDrawerEvent() {
        window.dispatchEvent(new CustomEvent("close-overlay-drawer"));
      }
      constructor() {
        super();
        this.__boundResizeListener = this._resize.bind(this);
        this.__drawerToggleClickListener = this._drawerToggleClick.bind(this);
        this.__onDrawerKeyDown = this.__onDrawerKeyDown.bind(this);
        this.__closeOverlayDrawerListener = this.__closeOverlayDrawer.bind(this);
        this.__trapFocusInDrawer = this.__trapFocusInDrawer.bind(this);
        this.__releaseFocusFromDrawer = this.__releaseFocusFromDrawer.bind(this);
        this.__ariaModalController = new AriaModalController(this, () => [
          ...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')
        ]);
        this.__focusTrapController = new FocusTrapController(this);
      }
      /** @protected */
      connectedCallback() {
        super.connectedCallback();
        this._blockAnimationUntilAfterNextRender();
        window.addEventListener("resize", this.__boundResizeListener);
        this.addEventListener("drawer-toggle-click", this.__drawerToggleClickListener);
        beforeNextRender(this, this._afterFirstRender);
        this._updateTouchOptimizedMode();
        this._updateDrawerSize();
        this._updateOverlayMode();
        this._navbarSizeObserver = new ResizeObserver(() => {
          requestAnimationFrame(() => {
            if (this.__isDrawerAnimating) {
              this.__updateOffsetSizePending = true;
            } else {
              this._updateOffsetSize();
            }
          });
        });
        this._navbarSizeObserver.observe(this.$.navbarTop);
        this._navbarSizeObserver.observe(this.$.navbarBottom);
        window.addEventListener("close-overlay-drawer", this.__closeOverlayDrawerListener);
        window.addEventListener("keydown", this.__onDrawerKeyDown);
      }
      /** @protected */
      ready() {
        super.ready();
        this.addController(this.__focusTrapController);
        this.__setAriaExpanded();
        this.$.drawer.addEventListener("transitionstart", () => {
          this.__isDrawerAnimating = true;
        });
        this.$.drawer.addEventListener("transitionend", () => {
          if (this.__updateOffsetSizePending) {
            this.__updateOffsetSizePending = false;
            this._updateOffsetSize();
          }
          requestAnimationFrame(() => {
            this.__isDrawerAnimating = false;
          });
        });
      }
      /** @protected */
      disconnectedCallback() {
        super.disconnectedCallback();
        window.removeEventListener("resize", this.__boundResizeListener);
        this.removeEventListener("drawer-toggle-click", this.__drawerToggleClickListener);
        window.removeEventListener("close-overlay-drawer", this.__drawerToggleClickListener);
        window.removeEventListener("keydown", this.__onDrawerKeyDown);
      }
      /**
       * A callback for the `primarySection` property observer.
       *
       * Ensures the property is set to its default value `navbar`
       * whenever the new value is not one of the valid values: `navbar`, `drawer`.
       *
       * @param {string} value
       * @private
       */
      __primarySectionChanged(value) {
        const isValid2 = ["navbar", "drawer"].includes(value);
        if (!isValid2) {
          this.set("primarySection", "navbar");
        }
      }
      /**
       * A callback for the `drawerOpened` property observer.
       *
       * When the drawer opens, the method ensures the drawer has a proper height and sets focus on it.
       * As long as the drawer is open, the focus is trapped within the drawer.
       *
       * When the drawer closes, the method releases focus from the drawer, setting focus on the drawer toggle.
       *
       * @param {boolean} drawerOpened
       * @param {boolean} oldDrawerOpened
       * @private
       */
      __drawerOpenedChanged(drawerOpened, oldDrawerOpened) {
        if (this.overlay) {
          if (drawerOpened) {
            this.__trapFocusInDrawer();
          } else if (oldDrawerOpened) {
            this.__releaseFocusFromDrawer();
          }
        }
        this.__setAriaExpanded();
      }
      /**
       * A callback for the `i18n` property observer.
       *
       * The method ensures the drawer has ARIA attributes updated
       * once the `i18n` property changes.
       *
       * @private
       */
      __i18nChanged() {
        this.__updateDrawerAriaAttributes();
      }
      /** @protected */
      _afterFirstRender() {
        this._blockAnimationUntilAfterNextRender();
        this._updateOffsetSize();
      }
      /** @private */
      _drawerToggleClick(e2) {
        e2.stopPropagation();
        this.drawerOpened = !this.drawerOpened;
      }
      /** @private */
      __closeOverlayDrawer() {
        if (this.overlay) {
          this.drawerOpened = false;
        }
      }
      /** @private */
      __setAriaExpanded() {
        const toggle = this.querySelector("vaadin-drawer-toggle");
        if (toggle) {
          toggle.setAttribute("aria-expanded", this.drawerOpened);
        }
      }
      /** @protected */
      _updateDrawerSize() {
        const childCount = this.querySelectorAll("[slot=drawer]").length;
        const drawer = this.$.drawer;
        if (childCount === 0) {
          drawer.setAttribute("hidden", "");
          this.style.setProperty("--_vaadin-app-layout-drawer-width", 0);
        } else {
          drawer.removeAttribute("hidden");
          this.style.removeProperty("--_vaadin-app-layout-drawer-width");
        }
        this._updateOffsetSize();
      }
      /** @private */
      _resize() {
        this._blockAnimationUntilAfterNextRender();
        this._updateTouchOptimizedMode();
        this._updateOverlayMode();
      }
      /** @protected */
      _updateOffsetSize() {
        const navbar = this.$.navbarTop;
        const navbarRect = navbar.getBoundingClientRect();
        const navbarBottom = this.$.navbarBottom;
        const navbarBottomRect = navbarBottom.getBoundingClientRect();
        const drawer = this.$.drawer;
        const drawerRect = drawer.getBoundingClientRect();
        this.style.setProperty("--_vaadin-app-layout-navbar-offset-size", `${navbarRect.height}px`);
        this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom", `${navbarBottomRect.height}px`);
        this.style.setProperty("--_vaadin-app-layout-drawer-offset-size", `${drawerRect.width}px`);
      }
      /** @protected */
      _updateOverlayMode() {
        const overlay2 = this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay") === "true";
        if (!this.overlay && overlay2) {
          this._drawerStateSaved = this.drawerOpened;
          this.drawerOpened = false;
        }
        this._setOverlay(overlay2);
        if (!this.overlay && this._drawerStateSaved) {
          this.drawerOpened = this._drawerStateSaved;
          this._drawerStateSaved = null;
        }
        this.__updateDrawerAriaAttributes();
      }
      /**
       * Updates ARIA attributes on the drawer depending on the drawer mode.
       *
       * - In the overlay mode, the method marks the drawer with ARIA attributes as a dialog
       * labelled with the `i18n.drawer` property.
       * - In the normal mode, the method removes the ARIA attributes that has been set for the overlay mode.
       *
       * @private
       */
      __updateDrawerAriaAttributes() {
        const drawer = this.$.drawer;
        if (this.overlay) {
          drawer.setAttribute("role", "dialog");
          drawer.setAttribute("aria-modal", "true");
          drawer.setAttribute("aria-label", this.i18n.drawer);
        } else {
          drawer.removeAttribute("role");
          drawer.removeAttribute("aria-modal");
          drawer.removeAttribute("aria-label");
        }
      }
      /**
       * Returns a promise that resolves when the drawer opening/closing CSS transition ends.
       *
       * The method relies on the `--vaadin-app-layout-transition` CSS variable to detect whether
       * the drawer has a CSS transition that needs to be awaited. If the CSS variable equals `none`,
       * the promise resolves immediately.
       *
       * @return {Promise}
       * @private
       */
      __drawerTransitionComplete() {
        return new Promise((resolve) => {
          if (this._getCustomPropertyValue("--vaadin-app-layout-transition") === "none") {
            resolve();
            return;
          }
          this.$.drawer.addEventListener("transitionend", resolve, { once: true });
        });
      }
      /** @private */
      async __trapFocusInDrawer() {
        await this.__drawerTransitionComplete();
        if (!this.drawerOpened) {
          return;
        }
        this.$.drawer.setAttribute("tabindex", "0");
        this.__ariaModalController.showModal();
        this.__focusTrapController.trapFocus(this.$.drawer);
      }
      /** @private */
      async __releaseFocusFromDrawer() {
        await this.__drawerTransitionComplete();
        if (this.drawerOpened) {
          return;
        }
        this.__ariaModalController.close();
        this.__focusTrapController.releaseFocus();
        this.$.drawer.removeAttribute("tabindex");
        const toggle = this.querySelector("vaadin-drawer-toggle");
        if (toggle) {
          toggle.focus();
          toggle.setAttribute("focus-ring", "focus");
        }
      }
      /**
       * Closes the drawer on Escape press if it has been opened in the overlay mode.
       *
       * @param {KeyboardEvent} event
       * @private
       */
      __onDrawerKeyDown(event) {
        if (event.key === "Escape" && this.overlay) {
          this.drawerOpened = false;
        }
      }
      /** @private */
      _closeDrawerOnChanged(closeDrawerOn, oldCloseDrawerOn) {
        if (oldCloseDrawerOn) {
          window.removeEventListener(oldCloseDrawerOn, this.__closeOverlayDrawerListener);
        }
        if (closeDrawerOn) {
          window.addEventListener(closeDrawerOn, this.__closeOverlayDrawerListener);
        }
      }
      /** @private */
      _onBackdropClick() {
        this._close();
      }
      /** @private */
      _onBackdropTouchend(event) {
        event.preventDefault();
        this._close();
      }
      /** @protected */
      _close() {
        this.drawerOpened = false;
      }
      /** @private */
      _getCustomPropertyValue(customProperty) {
        const customPropertyValue = getComputedStyle(this).getPropertyValue(customProperty);
        return (customPropertyValue || "").trim().toLowerCase();
      }
      /** @protected */
      _updateTouchOptimizedMode() {
        const touchOptimized = this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized") === "true";
        const navbarItems = this.querySelectorAll('[slot*="navbar"]');
        if (navbarItems.length > 0) {
          Array.from(navbarItems).forEach((navbar) => {
            if (navbar.getAttribute("slot").indexOf("touch-optimized") > -1) {
              navbar.__touchOptimized = true;
            }
            if (touchOptimized && navbar.__touchOptimized) {
              navbar.setAttribute("slot", "navbar-bottom");
            } else {
              navbar.setAttribute("slot", "navbar");
            }
          });
        }
        if (this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length === 0) {
          this.$.navbarTop.setAttribute("hidden", "");
        } else {
          this.$.navbarTop.removeAttribute("hidden");
        }
        if (this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length === 0) {
          this.$.navbarBottom.setAttribute("hidden", "");
        } else {
          this.$.navbarBottom.removeAttribute("hidden");
        }
        this._updateOffsetSize();
      }
      /** @protected */
      _blockAnimationUntilAfterNextRender() {
        this.setAttribute("no-anim", "");
        afterNextRender(this, () => {
          this.removeAttribute("no-anim");
        });
      }
      /**
       * App Layout listens to `close-overlay-drawer` on the window level.
       * A custom event can be dispatched and the App Layout will close the drawer in overlay.
       *
       * That can be used, for instance, when a navigation occurs when user clicks in a menu item inside the drawer.
       *
       * See `dispatchCloseOverlayDrawerEvent()` helper method.
       *
       * @event close-overlay-drawer
       */
    }
    defineCustomElement(AppLayout);
    function disableOnClickListener({ currentTarget: button2 }) {
      if (button2.hasAttribute("disableOnClick")) {
        button2.disabled = true;
      }
    }
    window.Vaadin.Flow.button = {
      initDisableOnClick: (button2) => {
        if (!button2.__hasDisableOnClickListener) {
          button2.addEventListener("click", disableOnClickListener);
          button2.__hasDisableOnClickListener = true;
        }
      }
    };
    const drawerToggle$1 = css$e`
  :host {
    width: var(--lumo-size-l);
    height: var(--lumo-size-l);
    min-width: auto;
    margin: 0 var(--lumo-space-s);
    padding: 0;
    background: transparent;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: inherit;
    height: auto;
    width: auto;
    background: transparent;
    top: auto;
  }

  [part='icon']::before {
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    content: var(--lumo-icons-menu);
  }

  :host([slot~='navbar']) {
    color: var(--lumo-secondary-text-color);
  }
`;
    registerStyles$1("vaadin-drawer-toggle", [button, drawerToggle$1], { moduleId: "lumo-drawer-toggle" });
    /**
     * @license
     * Copyright (c) 2018 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const drawerToggle = css$e`
  :host {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: default;
    position: relative;
    outline: none;
    height: 24px;
    width: 24px;
    padding: 4px;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: absolute;
    top: 8px;
    height: 3px;
    width: 24px;
    background-color: #000;
  }

  [part='icon']::after,
  [part='icon']::before {
    content: '';
  }

  [part='icon']::after {
    top: 6px;
  }

  [part='icon']::before {
    top: 12px;
  }
`;
    /**
     * @license
     * Copyright (c) 2018 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1("vaadin-drawer-toggle", [buttonStyles, drawerToggle], { moduleId: "vaadin-drawer-toggle-styles" });
    class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolymerElement))) {
      static get template() {
        return html`
      <slot id="slot">
        <div part="icon"></div>
      </slot>
      <div part="icon" hidden$="[[!_showFallbackIcon]]"></div>
    `;
      }
      static get is() {
        return "vaadin-drawer-toggle";
      }
      static get properties() {
        return {
          ariaLabel: {
            type: String,
            value: "Toggle navigation panel",
            reflectToAttribute: true
          },
          /** @private */
          _showFallbackIcon: {
            type: Boolean,
            value: false
          }
        };
      }
      constructor() {
        super();
        this.addEventListener("click", () => {
          this.dispatchEvent(new CustomEvent("drawer-toggle-click", { bubbles: true, composed: true }));
        });
      }
      /** @protected */
      ready() {
        super.ready();
        this._toggleFallbackIcon();
        this.$.slot.addEventListener("slotchange", () => {
          this._toggleFallbackIcon();
        });
      }
      /** @private */
      _toggleFallbackIcon() {
        const nodes = this.$.slot.assignedNodes();
        this._showFallbackIcon = nodes.length > 0 && nodes.every((node) => isEmptyTextNode(node));
      }
    }
    defineCustomElement(DrawerToggle);
    const tooltipOverlay = css$e`
  :host {
    --vaadin-tooltip-offset-top: var(--lumo-space-xs);
    --vaadin-tooltip-offset-bottom: var(--lumo-space-xs);
    --vaadin-tooltip-offset-start: var(--lumo-space-xs);
    --vaadin-tooltip-offset-end: var(--lumo-space-xs);
  }

  [part='overlay'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }
`;
    registerStyles$1("vaadin-tooltip-overlay", [overlay, tooltipOverlay], { moduleId: "lumo-tooltip-overlay" });
    /**
     * @license
     * Copyright (c) 2022 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const PopoverOverlayMixin = (superClass) => class PopoverOverlayMixinClass extends PositionMixin(OverlayMixin(superClass)) {
      static get properties() {
        return {
          position: {
            type: String,
            reflectToAttribute: true
          }
        };
      }
      /**
       * Tag name prefix used by custom properties.
       * @protected
       * @return {string}
       */
      get _tagNamePrefix() {
        return "vaadin-popover";
      }
      requestContentUpdate() {
        super.requestContentUpdate();
        if (this.positionTarget && this.owner) {
          const style = getComputedStyle(this.owner);
          ["top", "bottom", "start", "end"].forEach((prop) => {
            this.style.setProperty(
              `--${this._tagNamePrefix}-offset-${prop}`,
              style.getPropertyValue(`--${this._tagNamePrefix}-offset-${prop}`)
            );
          });
        }
      }
      /**
       * @protected
       * @override
       */
      _updatePosition() {
        super._updatePosition();
        if (!this.positionTarget || !this.opened) {
          return;
        }
        this.removeAttribute("arrow-centered");
        if (this.position === "bottom" || this.position === "top") {
          const targetRect = this.positionTarget.getBoundingClientRect();
          const overlayRect = this.$.overlay.getBoundingClientRect();
          const offset2 = targetRect.width / 2 - overlayRect.width / 2;
          if (this.style.left) {
            const left = overlayRect.left + offset2;
            if (left > 0) {
              this.style.left = `${left}px`;
              this.setAttribute("arrow-centered", "");
            }
          }
          if (this.style.right) {
            const right = parseFloat(this.style.right) + offset2;
            if (right > 0) {
              this.style.right = `${right}px`;
              this.setAttribute("arrow-centered", "");
            }
          }
        }
        if (this.position === "start" || this.position === "end") {
          const targetRect = this.positionTarget.getBoundingClientRect();
          const overlayRect = this.$.overlay.getBoundingClientRect();
          const offset2 = targetRect.height / 2 - overlayRect.height / 2;
          this.style.top = `${overlayRect.top + offset2}px`;
        }
      }
    };
    /**
     * @license
     * Copyright (c) 2022 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const tooltipOverlayStyles = css$e`
  :host {
    z-index: 1100;
  }

  [part='overlay'] {
    max-width: 40ch;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, 0);
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, 0);
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, 0);
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, 0);
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 1px dashed;
    }
  }
`;
    /**
     * @license
     * Copyright (c) 2022 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1("vaadin-tooltip-overlay", [overlayStyles$1, tooltipOverlayStyles], {
      moduleId: "vaadin-tooltip-overlay-styles"
    });
    class TooltipOverlay extends PopoverOverlayMixin(DirMixin(ThemableMixin(PolymerElement))) {
      static get is() {
        return "vaadin-tooltip-overlay";
      }
      static get template() {
        return html`
      <div id="backdrop" part="backdrop" hidden></div>
      <div part="overlay" id="overlay">
        <div part="content" id="content"><slot></slot></div>
      </div>
    `;
      }
      /**
       * Tag name prefix used by custom properties.
       * @protected
       * @return {string}
       */
      get _tagNamePrefix() {
        return "vaadin-tooltip";
      }
      /** @protected */
      ready() {
        super.ready();
        this.owner = this.__dataHost;
        this.owner._overlayElement = this;
      }
      requestContentUpdate() {
        super.requestContentUpdate();
        this.toggleAttribute("hidden", this.textContent.trim() === "");
      }
    }
    defineCustomElement(TooltipOverlay);
    /**
     * @license
     * Copyright (c) 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const PopoverPositionMixin = (superClass) => class PopoverPositionMixinClass extends superClass {
      static get properties() {
        return {
          /**
           * Position of the overlay with respect to the target.
           * Supported values: `top-start`, `top`, `top-end`,
           * `bottom-start`, `bottom`, `bottom-end`, `start-top`,
           * `start`, `start-bottom`, `end-top`, `end`, `end-bottom`.
           */
          position: {
            type: String
          },
          /**
           * Default value used when `position` property is not set.
           * @protected
           */
          _position: {
            type: String,
            value: "bottom"
          },
          /** @private */
          __effectivePosition: {
            type: String,
            computed: "__computePosition(position, _position)"
          }
        };
      }
      /** @protected */
      __computeHorizontalAlign(position) {
        return ["top-end", "bottom-end", "start-top", "start", "start-bottom"].includes(position) ? "end" : "start";
      }
      /** @protected */
      __computeNoHorizontalOverlap(position) {
        return ["start-top", "start", "start-bottom", "end-top", "end", "end-bottom"].includes(position);
      }
      /** @protected */
      __computeNoVerticalOverlap(position) {
        return ["top-start", "top-end", "top", "bottom-start", "bottom", "bottom-end"].includes(position);
      }
      /** @protected */
      __computeVerticalAlign(position) {
        return ["top-start", "top-end", "top", "start-bottom", "end-bottom"].includes(position) ? "bottom" : "top";
      }
      /** @private */
      __computePosition(position, defaultPosition) {
        return position || defaultPosition;
      }
    };
    /**
     * @license
     * Copyright (c) 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const PopoverTargetMixin = (superClass) => class PopoverTargetMixinClass extends superClass {
      static get properties() {
        return {
          /**
           * The id of the element to be used as `target` value.
           * The element should be in the DOM by the time when
           * the attribute is set, otherwise a warning is shown.
           */
          for: {
            type: String,
            observer: "__forChanged"
          },
          /**
           * Reference to the DOM element used both to trigger the overlay
           * by user interaction and to visually position it on the screen.
           *
           * Defaults to an element referenced with `for` attribute, in
           * which case it must be located in the same shadow scope.
           */
          target: {
            type: Object,
            observer: "__targetChanged"
          }
        };
      }
      /** @protected */
      connectedCallback() {
        super.connectedCallback();
        if (this.target) {
          this._addTargetListeners(this.target);
        }
      }
      /** @protected */
      disconnectedCallback() {
        super.disconnectedCallback();
        if (this.target) {
          this._removeTargetListeners(this.target);
        }
      }
      /** @private */
      __forChanged(forId) {
        if (forId) {
          this.__setTargetByIdDebouncer = Debouncer$1.debounce(
            this.__setTargetByIdDebouncer,
            microTask,
            () => this.__setTargetById(forId)
          );
        }
      }
      /** @private */
      __setTargetById(targetId) {
        if (!this.isConnected) {
          return;
        }
        const target = this.getRootNode().getElementById(targetId);
        if (target) {
          this.target = target;
        } else {
          console.warn(`No element with id="${targetId}" set via "for" property found on the page.`);
        }
      }
      /** @private */
      __targetChanged(target, oldTarget) {
        if (oldTarget) {
          this._removeTargetListeners(oldTarget);
        }
        if (target) {
          this._addTargetListeners(target);
        }
      }
      /**
       * @param {HTMLElement} _target
       * @protected
       */
      _addTargetListeners(_target) {
      }
      /**
       * @param {HTMLElement} _target
       * @protected
       */
      _removeTargetListeners(_target) {
      }
    };
    /**
     * @license
     * Copyright (c) 2022 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const DEFAULT_DELAY$1 = 500;
    let defaultFocusDelay$3 = DEFAULT_DELAY$1;
    let defaultHoverDelay$3 = DEFAULT_DELAY$1;
    let defaultHideDelay$3 = DEFAULT_DELAY$1;
    const closing = /* @__PURE__ */ new Set();
    let warmedUp = false;
    let warmUpTimeout = null;
    let cooldownTimeout = null;
    class TooltipStateController {
      constructor(host) {
        this.host = host;
      }
      /** @private */
      get openedProp() {
        return this.host.manual ? "opened" : "_autoOpened";
      }
      /** @private */
      get focusDelay() {
        const tooltip = this.host;
        return tooltip.focusDelay != null && tooltip.focusDelay >= 0 ? tooltip.focusDelay : defaultFocusDelay$3;
      }
      /** @private */
      get hoverDelay() {
        const tooltip = this.host;
        return tooltip.hoverDelay != null && tooltip.hoverDelay >= 0 ? tooltip.hoverDelay : defaultHoverDelay$3;
      }
      /** @private */
      get hideDelay() {
        const tooltip = this.host;
        return tooltip.hideDelay != null && tooltip.hideDelay >= 0 ? tooltip.hideDelay : defaultHideDelay$3;
      }
      /**
       * Whether closing is currently in progress.
       * @return {boolean}
       */
      get isClosing() {
        return closing.has(this.host);
      }
      /**
       * Schedule opening the tooltip.
       * @param {Object} options
       */
      open(options = { immediate: false }) {
        const { immediate, hover, focus: focus2 } = options;
        const isHover = hover && this.hoverDelay > 0;
        const isFocus = focus2 && this.focusDelay > 0;
        if (!immediate && (isHover || isFocus) && !this.__closeTimeout) {
          this.__warmupTooltip(isFocus);
        } else {
          this.__showTooltip();
        }
      }
      /**
       * Schedule closing the tooltip.
       * @param {boolean} immediate
       */
      close(immediate) {
        if (!immediate && this.hideDelay > 0) {
          this.__scheduleClose();
        } else {
          this.__abortClose();
          this._setOpened(false);
        }
        this.__abortWarmUp();
        if (warmedUp) {
          this.__abortCooldown();
          this.__scheduleCooldown();
        }
      }
      /** @private */
      _isOpened() {
        return this.host[this.openedProp];
      }
      /** @private */
      _setOpened(opened) {
        this.host[this.openedProp] = opened;
      }
      /** @private */
      __flushClosingTooltips() {
        closing.forEach((tooltip) => {
          tooltip._stateController.close(true);
          closing.delete(tooltip);
        });
      }
      /** @private */
      __showTooltip() {
        this.__abortClose();
        this.__flushClosingTooltips();
        this._setOpened(true);
        warmedUp = true;
        this.__abortWarmUp();
        this.__abortCooldown();
      }
      /** @private */
      __warmupTooltip(isFocus) {
        if (!this._isOpened()) {
          if (warmedUp) {
            this.__showTooltip();
          } else if (warmUpTimeout == null) {
            this.__scheduleWarmUp(isFocus);
          }
        }
      }
      /** @private */
      __abortClose() {
        if (this.__closeTimeout) {
          clearTimeout(this.__closeTimeout);
          this.__closeTimeout = null;
        }
        if (this.isClosing) {
          closing.delete(this.host);
        }
      }
      /** @private */
      __abortCooldown() {
        if (cooldownTimeout) {
          clearTimeout(cooldownTimeout);
          cooldownTimeout = null;
        }
      }
      /** @private */
      __abortWarmUp() {
        if (warmUpTimeout) {
          clearTimeout(warmUpTimeout);
          warmUpTimeout = null;
        }
      }
      /** @private */
      __scheduleClose() {
        if (this._isOpened() && !this.isClosing) {
          closing.add(this.host);
          this.__closeTimeout = setTimeout(() => {
            closing.delete(this.host);
            this.__closeTimeout = null;
            this._setOpened(false);
          }, this.hideDelay);
        }
      }
      /** @private */
      __scheduleCooldown() {
        cooldownTimeout = setTimeout(() => {
          cooldownTimeout = null;
          warmedUp = false;
        }, this.hideDelay);
      }
      /** @private */
      __scheduleWarmUp(isFocus) {
        const delay = isFocus ? this.focusDelay : this.hoverDelay;
        warmUpTimeout = setTimeout(() => {
          warmUpTimeout = null;
          warmedUp = true;
          this.__showTooltip();
        }, delay);
      }
    }
    const TooltipMixin = (superClass) => class TooltipMixinClass extends PopoverPositionMixin(PopoverTargetMixin(OverlayClassMixin(superClass))) {
      static get properties() {
        return {
          /**
           * Element used to link with the `aria-describedby`
           * attribute. Supports array of multiple elements.
           * When not set, defaults to `target`.
           */
          ariaTarget: {
            type: Object
          },
          /**
           * Object with properties passed to `generator` and
           * `shouldShow` functions for generating tooltip text
           * or detecting whether to show the tooltip or not.
           */
          context: {
            type: Object,
            value: () => {
              return {};
            }
          },
          /**
           * The delay in milliseconds before the tooltip
           * is opened on keyboard focus, when not in manual mode.
           * @attr {number} focus-delay
           */
          focusDelay: {
            type: Number
          },
          /**
           * Function used to generate the tooltip content.
           * When provided, it overrides the `text` property.
           * Use the `context` property to provide argument
           * that can be passed to the generator function.
           */
          generator: {
            type: Object
          },
          /**
           * The delay in milliseconds before the tooltip
           * is closed on losing hover, when not in manual mode.
           * On blur, the tooltip is closed immediately.
           * @attr {number} hide-delay
           */
          hideDelay: {
            type: Number
          },
          /**
           * The delay in milliseconds before the tooltip
           * is opened on hover, when not in manual mode.
           * @attr {number} hover-delay
           */
          hoverDelay: {
            type: Number
          },
          /**
           * When true, the tooltip is controlled programmatically
           * instead of reacting to focus and mouse events.
           */
          manual: {
            type: Boolean,
            value: false,
            sync: true
          },
          /**
           * When true, the tooltip is opened programmatically.
           * Only works if `manual` is set to `true`.
           */
          opened: {
            type: Boolean,
            value: false,
            sync: true
          },
          /**
           * Function used to detect whether to show the tooltip based on a condition,
           * called every time the tooltip is about to be shown on hover and focus.
           * The function takes two parameters: `target` and `context`, which contain
           * values of the corresponding tooltip properties at the time of calling.
           * The tooltip is only shown when the function invocation returns `true`.
           */
          shouldShow: {
            type: Object,
            value: () => {
              return (_target, _context) => true;
            }
          },
          /**
           * String used as a tooltip content.
           */
          text: {
            type: String,
            observer: "__textChanged"
          },
          /**
           * Set to true when the overlay is opened using auto-added
           * event listeners: mouseenter and focusin (keyboard only).
           * @protected
           */
          _autoOpened: {
            type: Boolean,
            observer: "__autoOpenedChanged",
            sync: true
          },
          /**
           * Element used to link with the `aria-describedby`
           * attribute. When not set, defaults to `target`.
           * @protected
           */
          _effectiveAriaTarget: {
            type: Object,
            computed: "__computeAriaTarget(ariaTarget, target)",
            observer: "__effectiveAriaTargetChanged"
          },
          /** @private */
          __isTargetHidden: {
            type: Boolean,
            value: false
          },
          /** @private */
          _isConnected: {
            type: Boolean,
            sync: true
          },
          /** @private */
          _srLabel: {
            type: Object
          },
          /** @private */
          _overlayContent: {
            type: String
          }
        };
      }
      static get observers() {
        return [
          "__generatorChanged(_overlayElement, generator, context)",
          "__updateSrLabelText(_srLabel, _overlayContent)"
        ];
      }
      /**
       * Sets the default focus delay to be used by all tooltip instances,
       * except for those that have focus delay configured using property.
       *
       * @param {number} focusDelay
       */
      static setDefaultFocusDelay(focusDelay) {
        defaultFocusDelay$3 = focusDelay != null && focusDelay >= 0 ? focusDelay : DEFAULT_DELAY$1;
      }
      /**
       * Sets the default hide delay to be used by all tooltip instances,
       * except for those that have hide delay configured using property.
       *
       * @param {number} hideDelay
       */
      static setDefaultHideDelay(hideDelay) {
        defaultHideDelay$3 = hideDelay != null && hideDelay >= 0 ? hideDelay : DEFAULT_DELAY$1;
      }
      /**
       * Sets the default hover delay to be used by all tooltip instances,
       * except for those that have hover delay configured using property.
       *
       * @param {number} hoverDelay
       */
      static setDefaultHoverDelay(hoverDelay) {
        defaultHoverDelay$3 = hoverDelay != null && hoverDelay >= 0 ? hoverDelay : DEFAULT_DELAY$1;
      }
      constructor() {
        super();
        this._uniqueId = `vaadin-tooltip-${generateUniqueId()}`;
        this._renderer = this.__tooltipRenderer.bind(this);
        this.__onFocusin = this.__onFocusin.bind(this);
        this.__onFocusout = this.__onFocusout.bind(this);
        this.__onMouseDown = this.__onMouseDown.bind(this);
        this.__onMouseEnter = this.__onMouseEnter.bind(this);
        this.__onMouseLeave = this.__onMouseLeave.bind(this);
        this.__onKeyDown = this.__onKeyDown.bind(this);
        this.__onOverlayOpen = this.__onOverlayOpen.bind(this);
        this.__targetVisibilityObserver = new IntersectionObserver(
          (entries) => {
            entries.forEach((entry) => this.__onTargetVisibilityChange(entry.isIntersecting));
          },
          { threshold: 0 }
        );
        this._stateController = new TooltipStateController(this);
      }
      /** @protected */
      connectedCallback() {
        super.connectedCallback();
        this._isConnected = true;
        document.body.addEventListener("vaadin-overlay-open", this.__onOverlayOpen);
      }
      /** @protected */
      disconnectedCallback() {
        super.disconnectedCallback();
        if (this._autoOpened) {
          this._stateController.close(true);
        }
        this._isConnected = false;
        document.body.removeEventListener("vaadin-overlay-open", this.__onOverlayOpen);
      }
      /** @protected */
      ready() {
        super.ready();
        this._srLabelController = new SlotController(this, "sr-label", "div", {
          initializer: (element) => {
            element.id = this._uniqueId;
            element.setAttribute("role", "tooltip");
            this._srLabel = element;
          }
        });
        this.addController(this._srLabelController);
      }
      /** @private */
      __computeOpened(manual, opened, autoOpened, connected) {
        return connected && (manual ? opened : autoOpened);
      }
      /** @private */
      __autoOpenedChanged(opened, oldOpened) {
        if (opened) {
          document.addEventListener("keydown", this.__onKeyDown, true);
        } else if (oldOpened) {
          document.removeEventListener("keydown", this.__onKeyDown, true);
        }
      }
      /**
       * @param {HTMLElement} target
       * @protected
       * @override
       */
      _addTargetListeners(target) {
        target.addEventListener("mouseenter", this.__onMouseEnter);
        target.addEventListener("mouseleave", this.__onMouseLeave);
        target.addEventListener("focusin", this.__onFocusin);
        target.addEventListener("focusout", this.__onFocusout);
        target.addEventListener("mousedown", this.__onMouseDown);
        requestAnimationFrame(() => {
          this.__targetVisibilityObserver.observe(target);
        });
      }
      /**
       * @param {HTMLElement} target
       * @protected
       * @override
       */
      _removeTargetListeners(target) {
        target.removeEventListener("mouseenter", this.__onMouseEnter);
        target.removeEventListener("mouseleave", this.__onMouseLeave);
        target.removeEventListener("focusin", this.__onFocusin);
        target.removeEventListener("focusout", this.__onFocusout);
        target.removeEventListener("mousedown", this.__onMouseDown);
        this.__targetVisibilityObserver.unobserve(target);
      }
      /** @private */
      __onFocusin(event) {
        if (this.manual) {
          return;
        }
        if (!isKeyboardActive()) {
          return;
        }
        if (this.target.contains(event.relatedTarget)) {
          return;
        }
        if (!this.__isShouldShow()) {
          return;
        }
        this.__focusInside = true;
        if (!this.__isTargetHidden && (!this.__hoverInside || !this._autoOpened)) {
          this._stateController.open({ focus: true });
        }
      }
      /** @private */
      __onFocusout(event) {
        if (this.manual) {
          return;
        }
        if (this.target.contains(event.relatedTarget)) {
          return;
        }
        this.__focusInside = false;
        if (!this.__hoverInside) {
          this._stateController.close(true);
        }
      }
      /** @private */
      __onKeyDown(event) {
        if (event.key === "Escape") {
          event.stopPropagation();
          this._stateController.close(true);
        }
      }
      /** @private */
      __onMouseDown() {
        if (this.manual) {
          return;
        }
        this._stateController.close(true);
      }
      /** @private */
      __onMouseEnter() {
        if (this.manual) {
          return;
        }
        if (!this.__isShouldShow()) {
          return;
        }
        if (this.__hoverInside) {
          return;
        }
        this.__hoverInside = true;
        if (!this.__isTargetHidden && (!this.__focusInside || !this._autoOpened)) {
          this._stateController.open({ hover: true });
        }
      }
      /** @private */
      __onMouseLeave(event) {
        if (event.relatedTarget !== this._overlayElement) {
          this.__handleMouseLeave();
        }
      }
      /** @protected */
      __onOverlayMouseEnter() {
        if (this._stateController.isClosing) {
          this._stateController.open({ immediate: true });
        }
      }
      /** @protected */
      __onOverlayMouseLeave(event) {
        if (event.relatedTarget !== this.target) {
          this.__handleMouseLeave();
        }
      }
      /** @private */
      __handleMouseLeave() {
        if (this.manual) {
          return;
        }
        this.__hoverInside = false;
        if (!this.__focusInside) {
          this._stateController.close();
        }
      }
      /** @private */
      __onOverlayOpen() {
        if (this.manual) {
          return;
        }
        if (this._overlayElement.opened && !this._overlayElement._last) {
          this._stateController.close(true);
        }
      }
      /** @private */
      __onTargetVisibilityChange(isVisible) {
        const oldHidden = this.__isTargetHidden;
        this.__isTargetHidden = !isVisible;
        if (oldHidden && isVisible && (this.__focusInside || this.__hoverInside)) {
          this._stateController.open({ immediate: true });
          return;
        }
        if (!isVisible && this._autoOpened) {
          this._stateController.close(true);
        }
      }
      /** @private */
      __isShouldShow() {
        if (typeof this.shouldShow === "function" && this.shouldShow(this.target, this.context) !== true) {
          return false;
        }
        return true;
      }
      /** @private */
      __textChanged(text, oldText) {
        if (this._overlayElement && (text || oldText)) {
          this._overlayElement.requestContentUpdate();
        }
      }
      /** @private */
      __tooltipRenderer(root2) {
        root2.textContent = typeof this.generator === "function" ? this.generator(this.context) : this.text;
        this._overlayContent = root2.textContent;
      }
      /** @private */
      __computeAriaTarget(ariaTarget, target) {
        const isElementNode = (el) => el && el.nodeType === Node.ELEMENT_NODE;
        const isAriaTargetSet = Array.isArray(ariaTarget) ? ariaTarget.some(isElementNode) : ariaTarget;
        return isAriaTargetSet ? ariaTarget : target;
      }
      /** @private */
      __effectiveAriaTargetChanged(ariaTarget, oldAriaTarget) {
        if (oldAriaTarget) {
          [oldAriaTarget].flat().forEach((target) => {
            removeValueFromAttribute(target, "aria-describedby", this._uniqueId);
          });
        }
        if (ariaTarget) {
          [ariaTarget].flat().forEach((target) => {
            addValueToAttribute(target, "aria-describedby", this._uniqueId);
          });
        }
      }
      /** @private */
      __generatorChanged(overlayElement, generator, context) {
        if (overlayElement) {
          if (generator !== this.__oldTextGenerator || context !== this.__oldContext) {
            overlayElement.requestContentUpdate();
          }
          this.__oldTextGenerator = generator;
          this.__oldContext = context;
        }
      }
      /** @private */
      __updateSrLabelText(srLabel, textContent) {
        if (srLabel) {
          srLabel.textContent = textContent;
        }
      }
    };
    /**
     * @license
     * Copyright (c) 2022 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    let Tooltip$1 = class Tooltip extends TooltipMixin(ThemePropertyMixin(ElementMixin(ControllerMixin(PolymerElement)))) {
      static get is() {
        return "vaadin-tooltip";
      }
      static get template() {
        return html`
      <style>
        :host {
          display: none;
        }
      </style>
      <vaadin-tooltip-overlay
        renderer="[[_renderer]]"
        theme$="[[_theme]]"
        opened="[[__computeOpened(manual, opened, _autoOpened, _isConnected)]]"
        position-target="[[target]]"
        position="[[__effectivePosition]]"
        no-horizontal-overlap$="[[__computeNoHorizontalOverlap(__effectivePosition)]]"
        no-vertical-overlap$="[[__computeNoVerticalOverlap(__effectivePosition)]]"
        horizontal-align="[[__computeHorizontalAlign(__effectivePosition)]]"
        vertical-align="[[__computeVerticalAlign(__effectivePosition)]]"
        on-mouseenter="__onOverlayMouseEnter"
        on-mouseleave="__onOverlayMouseLeave"
        modeless
      ></vaadin-tooltip-overlay>

      <slot name="sr-label"></slot>
    `;
      }
    };
    defineCustomElement(Tooltip$1);
    const globalStyle = document.createElement("style");
    globalStyle.textContent = "html { --vaadin-avatar-size: var(--lumo-size-m); }";
    document.head.appendChild(globalStyle);
    registerStyles$1(
      "vaadin-avatar",
      css$e`
    :host {
      color: var(--lumo-secondary-text-color);
      background-color: var(--lumo-contrast-10pct);
      border-radius: 50%;
      outline: none;
      cursor: default;
      user-select: none;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
    }

    :host([has-color-index]) {
      color: var(--lumo-base-color);
    }

    :host([focus-ring]) {
      border-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    }

    [part='icon'],
    [part='abbr'] {
      fill: currentColor;
    }

    [part='abbr'] {
      font-family: var(--lumo-font-family);
      font-size: 2.4375em;
      font-weight: 500;
    }

    :host([theme~='xlarge']) [part='abbr'] {
      font-size: 2.5em;
    }

    :host([theme~='large']) [part='abbr'] {
      font-size: 2.375em;
    }

    :host([theme~='small']) [part='abbr'] {
      font-size: 2.75em;
    }

    :host([theme~='xsmall']) [part='abbr'] {
      font-size: 3em;
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,
      { moduleId: "lumo-avatar" }
    );
    /**
     * @license
     * Copyright (c) 2020 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const template$5 = document.createElement("template");
    template$5.innerHTML = `
  <style>
    @font-face {
      font-family: 'vaadin-avatar-icons';
      src: url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQAAAsAAAAABnwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABHU1VCAAABCAAAADsAAABUIIslek9TLzIAAAFEAAAAQwAAAFZAIUmEY21hcAAAAYgAAABLAAABcOspwa1nbHlmAAAB1AAAAEUAAABMYO4o1WhlYWQAAAIcAAAALgAAADYYaAmGaGhlYQAAAkwAAAAdAAAAJAZsA1VobXR4AAACbAAAAAgAAAAIA+gAAGxvY2EAAAJ0AAAABgAAAAYAJgAAbWF4cAAAAnwAAAAeAAAAIAEOACFuYW1lAAACnAAAAUIAAAKavFDYrHBvc3QAAAPgAAAAHQAAAC52hGZ4eJxjYGRgYOBiMGCwY2BycfMJYeDLSSzJY5BiYGGAAJA8MpsxJzM9kYEDxgPKsYBpDiBmg4gCACY7BUgAeJxjYGT8wjiBgZWBgamKaQ8DA0MPhGZ8wGDIyAQUZWBlZsAKAtJcUxgcXjG+YmQO+p/FEMUcxDANKMwIkgMADiUMJQB4nGNgYGBlYGBgBmIdIGZhYGAMYWBkAAE/oCgjWJyZgQsszsKgBFbDAhJ/xfj/P4wE8lnAJAMjG8Mo4AGTMlAeOKwgmIERADU0CX0AeJxjYGIAAmYJpkgGHgYRBgZGJT1GEztGIzlGET5GKEuU8YuSpZKSpQuI+LfLv21emz9jHJQPJP7dsUywsEiwBACG8g9CAAAAeJxjYGRgYADicIOnh+P5bb4ycDO/AIow3JZ4rIJMM0swRQIpDgYmEA8AKwgJOwAAeJxjYGRgYA76nwUkXzAAAbMEAyMDKmACAE2GAskAAAAAAAAAA+gAAAAAAAAAJgAAeJxjYGRgYGBiEAViBjCLgYELCBkY/oP5DAAKuwEwAAB4nI2Qu07DMBSG//SGaCWEhMSAGDx1QU0vYyemdmDrUDEhuamTpkriyHEj9RF4B56Bh2Bg5mmY+8d4Qh3qo9jf+c45thQAt/hGgGYFuHN7s1q4YvbHbdKD5w555LmLAZ499+hfPPfxhDfPA/p33hB0rmmG+PDcwg2+PLfpfzx3yL+eu7gPHj33MAxmnvtYB6+eB/SftZTbtBjJWlppRmmki2qlkkMmzZnKGbVWpkp1Iabh5Ex1qQplpFVbsTmKqk5m1sYiNjoXC11YlWValEbvVWTDnbXlfDyOvQ8jnaOGZGyRouCfky63/AyzFBE0fYUVFBIckLnKZTOXda15s+GZulxgihCTC2eXnC3cfFNV7BfY4Mi9eT3BjNYiZh6zRyMnLdxs050xNE3panuaiD7Ezk2VmGPMiP/1h+71/ATcWYAhAAB4nGNgYoAALgbsgImRiZGZgaW0OLWIgQEACl4B2QAAAA==) format('woff');
      font-weight: normal;
      font-style: normal;
    }
  </style>
`;
    document.head.appendChild(template$5.content);
    /**
     * @license
     * Copyright (c) 2017 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const AvatarMixin = (superClass) => class AvatarMixinClass extends FocusMixin(superClass) {
      static get properties() {
        return {
          /**
           * The path to the image
           */
          img: {
            type: String,
            reflectToAttribute: true,
            observer: "__imgChanged"
          },
          /**
           * A shortened form of name that is displayed
           * in the avatar when `img` is not provided.
           */
          abbr: {
            type: String,
            reflectToAttribute: true
          },
          /**
           * Full name of the user
           * used for the tooltip of the avatar.
           */
          name: {
            type: String,
            reflectToAttribute: true
          },
          /**
           * Color index used for avatar background.
           * @attr {number} color-index
           */
          colorIndex: {
            type: Number,
            observer: "__colorIndexChanged"
          },
          /**
           * The object used to localize this component.
           * To change the default localization, replace the entire
           * _i18n_ object or just the property you want to modify.
           *
           * The object has the following JSON structure and default values:
           *
           * ```
           * {
           *   // Translation of the anonymous user avatar tooltip.
           *   anonymous: 'anonymous'
           * }
           * ```
           *
           * @type {!AvatarI18n}
           * @default {English/US}
           */
          i18n: {
            type: Object,
            value: () => {
              return {
                anonymous: "anonymous"
              };
            }
          },
          /**
           * When true, the avatar has tooltip shown on hover and focus.
           * The tooltip text is based on the `name` and `abbr` properties.
           * When neither is provided, `i18n.anonymous` is used instead.
           * @attr {boolean} with-tooltip
           */
          withTooltip: {
            type: Boolean,
            value: false,
            observer: "__withTooltipChanged"
          },
          /** @protected */
          __imgVisible: Boolean,
          /** @protected */
          __iconVisible: Boolean,
          /** @protected */
          __abbrVisible: Boolean,
          /** @private */
          __tooltipNode: Object
        };
      }
      static get observers() {
        return [
          "__imgOrAbbrOrNameChanged(img, abbr, name)",
          "__i18nChanged(i18n)",
          "__tooltipChanged(__tooltipNode, name, abbr)"
        ];
      }
      /** @protected */
      ready() {
        super.ready();
        this.__updateVisibility();
        if (!this.hasAttribute("role")) {
          this.setAttribute("role", "button");
        }
        if (!this.hasAttribute("tabindex")) {
          this.setAttribute("tabindex", "0");
        }
        if (!this.name && !this.abbr) {
          this.__setTooltip();
        }
      }
      /** @private */
      __colorIndexChanged(index) {
        if (index != null) {
          const prop = `--vaadin-user-color-${index}`;
          const isValid2 = Boolean(getComputedStyle(document.documentElement).getPropertyValue(prop));
          if (isValid2) {
            this.setAttribute("has-color-index", "");
            this.style.setProperty("--vaadin-avatar-user-color", `var(${prop})`);
          } else {
            this.removeAttribute("has-color-index");
            console.warn(`The CSS property --vaadin-user-color-${index} is not defined`);
          }
        } else {
          this.removeAttribute("has-color-index");
        }
      }
      /** @private */
      __imgChanged() {
        this.__imgFailedToLoad = false;
      }
      /** @private */
      __imgOrAbbrOrNameChanged(_img, abbr, name) {
        this.__updateVisibility();
        if (abbr && abbr !== this.__generatedAbbr) {
          return;
        }
        if (name) {
          this.abbr = this.__generatedAbbr = name.split(" ").map((word) => word.charAt(0)).join("");
        } else {
          this.abbr = void 0;
        }
      }
      /** @private */
      __tooltipChanged(tooltipNode, name, abbr) {
        if (tooltipNode) {
          if (abbr && abbr !== this.__generatedAbbr) {
            this.__setTooltip(name ? `${name} (${abbr})` : abbr);
          } else {
            this.__setTooltip(name);
          }
        }
      }
      /** @private */
      __withTooltipChanged(withTooltip, oldWithTooltip) {
        if (withTooltip) {
          const tooltipNode = document.createElement("vaadin-tooltip");
          tooltipNode.setAttribute("slot", "tooltip");
          this.appendChild(tooltipNode);
          this.__tooltipNode = tooltipNode;
        } else if (oldWithTooltip) {
          this.__tooltipNode.target = null;
          this.__tooltipNode.remove();
          this.__tooltipNode = null;
        }
      }
      /** @private */
      __i18nChanged(i18n) {
        if (i18n && i18n.anonymous) {
          if (this.__oldAnonymous && this.__tooltipNode && this.__tooltipNode.text === this.__oldAnonymous) {
            this.__setTooltip();
          }
          this.__oldAnonymous = i18n.anonymous;
        }
      }
      /** @private */
      __updateVisibility() {
        this.__imgVisible = !!this.img && !this.__imgFailedToLoad;
        this.__abbrVisible = !this.__imgVisible && !!this.abbr;
        this.__iconVisible = !this.__imgVisible && !this.abbr;
      }
      /** @private */
      __setTooltip(tooltip) {
        const tooltipNode = this.__tooltipNode;
        if (tooltipNode) {
          tooltipNode.text = tooltip || this.i18n.anonymous;
        }
      }
      /** @protected */
      __onImageLoadError() {
        if (this.img) {
          console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`);
          this.__imgFailedToLoad = true;
          this.__updateVisibility();
        }
      }
    };
    /**
     * @license
     * Copyright (c) 2017 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const avatarStyles = css$e`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    overflow: hidden;
    height: var(--vaadin-avatar-size, 64px);
    width: var(--vaadin-avatar-size, 64px);
    border: var(--vaadin-avatar-outline-width) solid transparent;
    margin: calc(var(--vaadin-avatar-outline-width) * -1);
    background-clip: content-box;
    --vaadin-avatar-outline-width: var(--vaadin-focus-ring-width, 2px);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    font-size: 5.6em;
  }

  [part='abbr'] {
    font-size: 2.2em;
  }

  [part='icon'] > text {
    font-family: 'vaadin-avatar-icons';
  }

  :host([hidden]) {
    display: none !important;
  }

  svg[hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    position: relative;
    background-color: var(--vaadin-avatar-user-color);
  }

  :host([has-color-index])::before {
    position: absolute;
    content: '';
    inset: 0;
    border-radius: inherit;
    box-shadow: inset 0 0 0 2px var(--vaadin-avatar-user-color);
  }
`;
    /**
     * @license
     * Copyright (c) 2020 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1("vaadin-avatar", avatarStyles, { moduleId: "vaadin-avatar-styles" });
    class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))) {
      static get template() {
        return html`
      <img
        hidden$="[[!__imgVisible]]"
        src$="[[img]]"
        aria-hidden="true"
        on-error="__onImageLoadError"
        draggable="false"
      />
      <svg
        part="icon"
        hidden$="[[!__iconVisible]]"
        id="avatar-icon"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">&#xea01;</text>
      </svg>
      <svg
        part="abbr"
        hidden$="[[!__abbrVisible]]"
        id="avatar-abbr"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">[[abbr]]</text>
      </svg>

      <slot name="tooltip"></slot>
    `;
      }
      static get is() {
        return "vaadin-avatar";
      }
      /** @protected */
      ready() {
        super.ready();
        this._tooltipController = new TooltipController(this);
        this.addController(this._tooltipController);
      }
    }
    defineCustomElement(Avatar);
    registerStyles$1(
      "vaadin-avatar-group",
      css$e`
    :host {
      --vaadin-avatar-size: var(--lumo-size-m);
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-group-overlap: 12px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-group-overlap: 10px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-group-overlap: 6px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-group-overlap: 4px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,
      { moduleId: "lumo-avatar-group" }
    );
    const avatarGroupOverlay = css$e`
  :host {
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }

  [part='overlay'] {
    outline: none;
  }
`;
    registerStyles$1("vaadin-avatar-group-overlay", [overlay, menuOverlayCore, avatarGroupOverlay], {
      moduleId: "lumo-avatar-group-overlay"
    });
    registerStyles$1("vaadin-avatar-group-menu", listBox, { moduleId: "lumo-avatar-group-menu" });
    registerStyles$1(
      "vaadin-avatar-group-menu-item",
      [
        item,
        css$e`
      :host {
        padding: var(--lumo-space-xs);
        padding-inline-end: var(--lumo-space-m);
      }

      [part='content'] {
        display: flex;
        align-items: center;
      }

      [part='content'] ::slotted(vaadin-avatar) {
        width: var(--lumo-size-xs);
        height: var(--lumo-size-xs);
        margin-inline-end: var(--lumo-space-s);
      }
    `
      ],
      { moduleId: "lumo-avatar-group-menu-item" }
    );
    /**
     * @license
     * Copyright (c) 2020 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(ControllerMixin(PolymerElement)))) {
      static get is() {
        return "vaadin-avatar-group-menu";
      }
      static get template() {
        return html`
      <style>
        :host {
          display: flex;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='items'] {
          height: 100%;
          width: 100%;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch;
        }
      </style>
      <div part="items">
        <slot></slot>
      </div>
    `;
      }
      static get properties() {
        return {
          // We don't need to define this property since super default is vertical,
          // but we don't want it to be modified, or be shown in the API docs.
          /** @private */
          orientation: {
            readOnly: true
          }
        };
      }
      /**
       * @return {!HTMLElement}
       * @protected
       * @override
       */
      get _scrollerElement() {
        return this.shadowRoot.querySelector('[part="items"]');
      }
      /** @protected */
      ready() {
        super.ready();
        this.setAttribute("role", "menu");
      }
    }
    defineCustomElement(AvatarGroupMenu);
    /**
     * @license
     * Copyright (c) 2020 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolymerElement))) {
      static get is() {
        return "vaadin-avatar-group-menu-item";
      }
      static get template() {
        return html`
      <style>
        :host {
          display: inline-block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `;
      }
      /** @protected */
      ready() {
        super.ready();
        this.setAttribute("role", "menuitem");
      }
    }
    defineCustomElement(AvatarGroupMenuItem);
    /**
     * @license
     * Copyright (c) 2020 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    registerStyles$1("vaadin-avatar-group-overlay", [overlayStyles$1], {
      moduleId: "vaadin-avatar-group-overlay-styles"
    });
    class AvatarGroupOverlay extends PositionMixin(OverlayMixin(DirMixin(ThemableMixin(PolymerElement)))) {
      static get is() {
        return "vaadin-avatar-group-overlay";
      }
      static get template() {
        return html`
      <div id="backdrop" part="backdrop" hidden$="[[!withBackdrop]]"></div>
      <div part="overlay" id="overlay" tabindex="0">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `;
      }
    }
    defineCustomElement(AvatarGroupOverlay);
    /**
     * @license
     * Copyright 2018 Google LLC
     * SPDX-License-Identifier: BSD-3-Clause
     */
    const ifDefined = (value) => value ?? nothing;
    /**
     * @license
     * Copyright (c) 2020 - 2024 Vaadin Ltd.
     * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
     */
    const MINIMUM_DISPLAYED_AVATARS = 2;
    class AvatarGroup extends ResizeMixin(OverlayClassMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement))))) {
      static get template() {
        return html`
      <style>
        :host {
          display: block;
          width: 100%; /* prevent collapsing inside non-stretching column flex */
          --vaadin-avatar-group-overlap: 8px;
          --vaadin-avatar-group-overlap-border: 2px;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='container'] {
          display: flex;
          position: relative;
          width: 100%;
          flex-wrap: nowrap;
        }

        ::slotted(vaadin-avatar:not(:first-child)) {
          -webkit-mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
          mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
          -webkit-mask-size: calc(
            300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
          );
          mask-size: calc(
            300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
          );
        }

        ::slotted(vaadin-avatar:not([dir='rtl']):not(:first-child)) {
          margin-left: calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));
          -webkit-mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
          mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
        }

        ::slotted(vaadin-avatar[dir='rtl']:not(:first-child)) {
          margin-right: calc(var(--vaadin-avatar-group-overlap) * -1);
          -webkit-mask-position: calc(
            50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
          );
          mask-position: calc(
            50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
          );
        }
      </style>
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        opened="{{_opened}}"
        position-target="[[_overflow]]"
        no-vertical-overlap
        on-vaadin-overlay-close="_onVaadinOverlayClose"
      ></vaadin-avatar-group-overlay>
    `;
      }
      static get is() {
        return "vaadin-avatar-group";
      }
      static get properties() {
        return {
          /**
           * An array containing the items which will be stamped as avatars.
           *
           * The items objects allow to configure [`name`](#/elements/vaadin-avatar#property-name),
           * [`abbr`](#/elements/vaadin-avatar#property-abbr), [`img`](#/elements/vaadin-avatar#property-img)
           * and [`colorIndex`](#/elements/vaadin-avatar#property-colorIndex) properties on the
           * stamped avatars, and set `className` to provide CSS class names.
           *
           * #### Example
           *
           * ```js
           * group.items = [
           *   {
           *     name: 'User name',
           *     img: 'url-to-image.png',
           *     className: 'even'
           *   },
           *   {
           *     abbr: 'JD',
           *     colorIndex: 1,
           *     className: 'odd'
           *   },
           * ];
           * ```
           *
           * @type {!Array<!AvatarGroupItem> | undefined}
           */
          items: {
            type: Array
          },
          /**
           * The maximum number of avatars to display. By default, all the avatars are displayed.
           * When _maxItemsVisible_ is set, the overflowing avatars are grouped into one avatar with
           * a dropdown. Setting 0 or 1 has no effect so there are always at least two avatars visible.
           * @attr {number} max-items-visible
           */
          maxItemsVisible: {
            type: Number
          },
          /**
           * The object used to localize this component.
           * To change the default localization, replace the entire
           * _i18n_ object or just the property you want to modify.
           *
           * The object has the following JSON structure and default values:
           * ```
           * {
           *   // Translation of the anonymous user avatar tooltip.
           *   anonymous: 'anonymous',
           *   // Translation of the avatar group accessible label.
           *   // {count} is replaced with the actual count of users.
           *   activeUsers: {
           *     one: 'Currently one active user',
           *     many: 'Currently {count} active users'
           *   },
           *   // Screen reader announcement when user joins group.
           *   // {user} is replaced with the name or abbreviation.
           *   // When neither is set, "anonymous" is used instead.
           *   joined: '{user} joined',
           *   // Screen reader announcement when user leaves group.
           *   // {user} is replaced with the name or abbreviation.
           *   // When neither is set, "anonymous" is used instead.
           *   left: '{user} left'
           * }
           * ```
           * @type {!AvatarGroupI18n}
           * @default {English/US}
           */
          i18n: {
            type: Object,
            value: () => {
              return {
                anonymous: "anonymous",
                activeUsers: {
                  one: "Currently one active user",
                  many: "Currently {count} active users"
                },
                joined: "{user} joined",
                left: "{user} left"
              };
            }
          },
          /** @private */
          _avatars: {
            type: Array,
            value: () => []
          },
          /** @private */
          __maxReached: {
            type: Boolean,
            computed: "__computeMaxReached(items.length, maxItemsVisible)"
          },
          /** @private */
          __items: {
            type: Array
          },
          /** @private */
          __itemsInView: {
            type: Number,
            value: null
          },
          /** @private */
          _overflow: {
            type: Object
          },
          /** @private */
          _overflowItems: {
            type: Array,
            observer: "__overflowItemsChanged",
            computed: "__computeOverflowItems(items.*, __itemsInView, maxItemsVisible)"
          },
          /** @private */
          _overflowTooltip: {
            type: Object
          },
          /** @private */
          _opened: {
            type: Boolean,
            observer: "__openedChanged"
          }
        };
      }
      static get observers() {
        return [
          "__itemsChanged(items.splices, items.*)",
          "__i18nItemsChanged(i18n.*, items.length)",
          "__updateAvatarsTheme(_overflow, _avatars, _theme)",
          "__updateAvatars(items.*, __itemsInView, maxItemsVisible, _overflow, i18n)",
          "__updateOverflowAbbr(_overflow, items.length, __itemsInView, maxItemsVisible)",
          "__updateOverflowHidden(_overflow, items.length, __itemsInView, __maxReached)",
          "__updateOverflowTooltip(_overflowTooltip, items.length, __itemsInView, maxItemsVisible)"
        ];
      }
      /** @protected */
      ready() {
        super.ready();
        this._overflowController = new SlotController(this, "overflow", "vaadin-avatar", {
          initializer: (overflow) => {
            overflow.setAttribute("aria-haspopup", "menu");
            overflow.setAttribute("aria-expanded", "false");
            overflow.addEventListener("click", (e2) => this._onOverflowClick(e2));
            overflow.addEventListener("keydown", (e2) => this._onOverflowKeyDown(e2));
            const tooltip = document.createElement("vaadin-tooltip");
            tooltip.setAttribute("slot", "tooltip");
            overflow.appendChild(tooltip);
            this._overflow = overflow;
            this._overflowTooltip = tooltip;
          }
        });
        this.addController(this._overflowController);
        const overlay2 = this.$.overlay;
        overlay2.renderer = this.__overlayRenderer.bind(this);
        this._overlayElement = overlay2;
        afterNextRender(this, () => {
          this.__setItemsInView();
        });
      }
      /** @protected */
      disconnectedCallback() {
        super.disconnectedCallback();
        this._opened = false;
      }
      /** @private */
      __getMessage(user, action) {
        return action.replace("{user}", user.name || user.abbr || this.i18n.anonymous);
      }
      /**
       * Renders items when they are provided by the `items` property and clears the content otherwise.
       * @param {!HTMLElement} root
       * @param {!Select} _select
       * @private
       */
      __overlayRenderer(root2) {
        let menu = root2.firstElementChild;
        if (!menu) {
          menu = document.createElement("vaadin-avatar-group-menu");
          menu.addEventListener("keydown", (event) => this._onListKeyDown(event));
          root2.appendChild(menu);
        }
        menu.textContent = "";
        if (!this._overflowItems) {
          return;
        }
        this._overflowItems.forEach((item2) => {
          menu.appendChild(this.__createItemElement(item2));
        });
      }
      /** @private */
      __createItemElement(item2) {
        const itemElement = document.createElement("vaadin-avatar-group-menu-item");
        const avatar = document.createElement("vaadin-avatar");
        itemElement.appendChild(avatar);
        avatar.setAttribute("aria-hidden", "true");
        avatar.setAttribute("tabindex", "-1");
        avatar.i18n = this.i18n;
        if (this._theme) {
          avatar.setAttribute("theme", this._theme);
        }
        avatar.name = item2.name;
        avatar.abbr = item2.abbr;
        avatar.img = item2.img;
        avatar.colorIndex = item2.colorIndex;
        if (item2.className) {
          avatar.className = item2.className;
        }
        if (item2.name) {
          const text = document.createTextNode(item2.name);
          itemElement.appendChild(text);
        }
        return itemElement;
      }
      /** @private */
      _onOverflowClick(e2) {
        e2.stopPropagation();
        if (this._opened) {
          this.$.overlay.close();
        } else if (!e2.defaultPrevented) {
          this._opened = true;
        }
      }
      /** @private */
      _onOverflowKeyDown(e2) {
        if (!this._opened) {
          if (/^(Enter|SpaceBar|\s)$/u.test(e2.key)) {
            e2.preventDefault();
            this._opened = true;
          }
        }
      }
      /** @private */
      _onListKeyDown(event) {
        if (event.key === "Escape" || event.key === "Tab") {
          this._opened = false;
        }
      }
      /**
       * @protected
       * @override
       */
      _onResize() {
        this.__setItemsInView();
      }
      /** @private */
      _onVaadinOverlayClose(e2) {
        if (e2.detail.sourceEvent && e2.detail.sourceEvent.composedPath().includes(this)) {
          e2.preventDefault();
        }
      }
      /** @private */
      __renderAvatars(items) {
        render$1(
          html$1`
        ${items.map(
            (item2) => html$1`
            <vaadin-avatar
              .name="${item2.name}"
              .abbr="${item2.abbr}"
              .img="${item2.img}"
              .colorIndex="${item2.colorIndex}"
              .i18n="${this.i18n}"
              class="${ifDefined(item2.className)}"
              with-tooltip
            ></vaadin-avatar>
          `
          )}
      `,
          this,
          { renderBefore: this._overflow }
        );
      }
      /** @private */
      __updateAvatars(arr, itemsInView, maxItemsVisible, overflow) {
        if (!overflow) {
          return;
        }
        const items = arr.base || [];
        const limit = this.__getLimit(items.length, itemsInView, maxItemsVisible);
        this.__renderAvatars(limit ? items.slice(0, limit) : items);
        this._avatars = [...this.querySelectorAll("vaadin-avatar")];
      }
      /** @private */
      __computeOverflowItems(arr, itemsInView, maxItemsVisible) {
        const items = arr.base || [];
        const limit = this.__getLimit(items.length, itemsInView, maxItemsVisible);
        return limit ? items.slice(limit) : [];
      }
      /** @private */
      __computeMaxReached(items, maxItemsVisible) {
        return maxItemsVisible != null && items > this.__getMax(maxItemsVisible);
      }
      /** @private */
      __updateOverflowAbbr(overflow, items, itemsInView, maxItemsVisible) {
        if (overflow) {
          overflow.abbr = `+${items - this.__getLimit(items, itemsInView, maxItemsVisible)}`;
        }
      }
      /** @private */
      __updateOverflowHidden(overflow, items, itemsInView, maxReached) {
        if (overflow) {
          overflow.toggleAttribute("hidden", !maxReached && !(itemsInView && itemsInView < items));
        }
      }
      /** @private */
      __updateAvatarsTheme(overflow, avatars, theme2) {
        if (overflow) {
          [overflow, ...avatars].forEach((avatar) => {
            if (theme2) {
              avatar.setAttribute("theme", theme2);
            } else {
              avatar.removeAttribute("theme");
            }
          });
        }
      }
      /** @private */
      __updateOverflowTooltip(tooltip, items, itemsInView, maxItemsVisible) {
        if (!tooltip) {
          return;
        }
        const limit = this.__getLimit(items, itemsInView, maxItemsVisible);
        if (limit == null) {
          return;
        }
        const result2 = [];
        for (let i2 = limit; i2 < items; i2++) {
          const item2 = this.items[i2];
          if (item2) {
            result2.push(item2.name || item2.abbr || "anonymous");
          }
        }
        tooltip.text = result2.join("\n");
      }
      /** @private */
      __getLimit(items, itemsInView, maxItemsVisible) {
        let limit = null;
        const adjustedMax = this.__getMax(maxItemsVisible);
        if (maxItemsVisible != null && adjustedMax < items) {
          limit = adjustedMax - 1;
        } else if (itemsInView && itemsInView < items) {
          limit = itemsInView;
        }
        return Math.min(limit, this.__calculateAvatarsFitWidth());
      }
      /** @private */
      __getMax(maxItemsVisible) {
        return Math.max(maxItemsVisible, MINIMUM_DISPLAYED_AVATARS);
      }
      /** @private */
      __itemsChanged(splices, itemsChange) {
        const items = itemsChange.base;
        this.__setItemsInView();
        if (splices && Array.isArray(splices.indexSplices)) {
          splices.indexSplices.forEach((mutation) => {
            this.__announceItemsChange(items, mutation);
          });
        } else if (Array.isArray(items) && Array.isArray(this.__oldItems)) {
          const diff = calculateSplices(items, this.__oldItems);
          diff.forEach((mutation) => {
            this.__announceItemsChange(items, mutation);
          });
        }
        this.__oldItems = items;
      }
      /** @private */
      __announceItemsChange(items, mutation) {
        const { addedCount, index, removed } = mutation;
        let addedMsg = [];
        let removedMsg = [];
        if (addedCount) {
          addedMsg = items.slice(index, index + addedCount).map((user) => this.__getMessage(user, this.i18n.joined || "{user} joined"));
        }
        if (removed) {
          removedMsg = removed.map((user) => this.__getMessage(user, this.i18n.left || "{user} left"));
        }
        const messages = removedMsg.concat(addedMsg);
        if (messages.length > 0) {
          announce(messages.join(", "));
        }
      }
      /** @private */
      __i18nItemsChanged(i18n, items) {
        const { base } = i18n;
        if (base && base.activeUsers) {
          const field = items === 1 ? "one" : "many";
          if (base.activeUsers[field]) {
            this.setAttribute("aria-label", base.activeUsers[field].replace("{count}", items || 0));
          }
          this._avatars.forEach((avatar) => {
            avatar.i18n = base;
          });
        }
      }
      /** @private */
      __openedChanged(opened, wasOpened) {
        if (opened) {
          if (!this._menuElement) {
            this._menuElement = this.$.overlay.querySelector("vaadin-avatar-group-menu");
          }
          this._openedWithFocusRing = this._overflow.hasAttribute("focus-ring");
          this._menuElement.focus();
        } else if (wasOpened) {
          this._overflow.focus();
          if (this._openedWithFocusRing) {
            this._overflow.setAttribute("focus-ring", "");
          }
        }
        this._overflow.setAttribute("aria-expanded", opened === true);
      }
      /** @private */
      __overflowItemsChanged(items, oldItems) {
        if (items || oldItems) {
          this.$.overlay.requestContentUpdate();
        }
      }
      /** @private */
      __setItemsInView() {
        const avatars = this._avatars;
        const items = this.items;
        if (!items || !avatars || avatars.length < 3) {
          return;
        }
        let result2 = this.__calculateAvatarsFitWidth();
        if (result2 === items.length - 1) {
          result2 = items.length;
        }
        if (result2 >= items.length && this._opened) {
          this.$.overlay.close();
          this.$.overlay._flushAnimation("closing");
        }
        this.__itemsInView = result2;
      }
      /** @private */
      __calculateAvatarsFitWidth() {
        if (!this.shadowRoot || this._avatars.length < MINIMUM_DISPLAYED_AVATARS) {
          return MINIMUM_DISPLAYED_AVATARS;
        }
        const avatars = this._avatars;
        const avatarWidth = avatars[0].clientWidth;
        const { marginLeft, marginRight } = getComputedStyle(avatars[1]);
        const offset2 = this.__isRTL ? parseInt(marginRight, 0) - parseInt(marginLeft, 0) : parseInt(marginLeft, 0) - parseInt(marginRight, 0);
        return Math.floor((this.$.container.offsetWidth - avatarWidth) / (avatarWidth + offset2));
      }
    }
    defineCustomElement(AvatarGroup);
    /**
     * @license
     * Copyright (c) 2000 - 2024 Vaadin Ltd.
     *
     * This program is available under Vaadin Commercial License and Service Terms.
     *
     *
     * See https://vaadin.com/commercial-license-and-service-terms for the full
     * license.
     */
    const CLASSES = {
      SMALL: "small",
      MEDIUM: "medium",
      LARGE: "large"
    };
    class BoardRow extends ResizeMixin(ElementMixin(PolymerElement)) {
      static get template() {
        return html`
      <style>
        :host {
          display: flex;
          flex-flow: row wrap;
          align-items: stretch;
          --small-size: var(--vaadin-board-width-small, 600px);
          --medium-size: var(--vaadin-board-width-medium, 960px);
        }

        :host ::slotted(*) {
          box-sizing: border-box;
          flex-grow: 1;
          overflow: hidden;
        }
      </style>
      <slot id="insertionPoint"></slot>
    `;
      }
      static get is() {
        return "vaadin-board-row";
      }
      constructor() {
        super();
        this._oldWidth = 0;
        this._oldBreakpoints = { smallSize: 600, mediumSize: 960 };
        this._oldFlexBasis = [];
      }
      /** @protected */
      ready() {
        super.ready();
        this.$.insertionPoint.addEventListener("slotchange", () => this.redraw());
      }
      /** @protected */
      connectedCallback() {
        super.connectedCallback();
        this._onResize();
      }
      /**
       * Adds styles for board row based on width.
       * @private
       */
      _addStyleNames(width, breakpoints) {
        if (width < breakpoints.smallSize) {
          this.classList.add(CLASSES.SMALL);
          this.classList.remove(CLASSES.MEDIUM);
          this.classList.remove(CLASSES.LARGE);
        } else if (width < breakpoints.mediumSize) {
          this.classList.remove(CLASSES.SMALL);
          this.classList.add(CLASSES.MEDIUM);
          this.classList.remove(CLASSES.LARGE);
        } else {
          this.classList.remove(CLASSES.SMALL);
          this.classList.remove(CLASSES.MEDIUM);
          this.classList.add(CLASSES.LARGE);
        }
      }
      /**
       * Calculates flex basis based on colSpan, width and breakpoints.
       * @param {number} colSpan colspan value of the row
       * @param {number} width width of the row in px
       * @param {number} colsInRow number of columns in the row
       * @param {object} breakpoints object with smallSize and mediumSize number properties, which tells
       * where the row should switch rendering size in pixels.
       * @private
       */
      _calculateFlexBasis(colSpan, width, colsInRow, breakpoints) {
        if (width < breakpoints.smallSize) {
          colsInRow = 1;
        } else if (width < breakpoints.mediumSize && colsInRow === 4) {
          colsInRow = 2;
        }
        let flexBasis = colSpan / colsInRow * 100;
        flexBasis = flexBasis > 100 ? 100 : flexBasis;
        return `${flexBasis}%`;
      }
      /** @private */
      _reportError() {
        const errorMessage = "The column configuration is not valid; column count should add up to 3 or 4.";
        console.warn(errorMessage, `check: \r
${this.outerHTML}`);
      }
      /**
       * Parses board-cols from DOM.
       * If there is not enough space in the row drop board cols.
       * @param {!Array<!Node>} nodes array of nodes
       * @return {!Array<number>} array of boardCols
       * @private
       */
      _parseBoardCols(nodes) {
        const boardCols = nodes.map((node) => {
          if (node.getAttribute("board-cols")) {
            return parseInt(node.getAttribute("board-cols"));
          }
          return 1;
        });
        let spaceLeft = 4;
        let returnBoardCols = [];
        nodes.forEach((_node, i2) => {
          spaceLeft -= boardCols[i2];
        });
        if (spaceLeft < 0) {
          this._reportError();
          boardCols.forEach((_node, i2) => {
            returnBoardCols[i2] = 1;
          });
        } else {
          returnBoardCols = boardCols.slice(0);
        }
        return returnBoardCols;
      }
      /**
       * If there is not enough space in the row.
       * Extra items are dropped from DOM.
       * @param {!Array<number>} boardCols array of board-cols for every node
       * @param {!Array<!Node>} nodes array of nodes
       * @return {!Array<!Node>} filtered array of nodes
       * @private
       */
      _removeExtraNodesFromDOM(boardCols, nodes) {
        let isErrorReported = false;
        let spaceLeft = 4;
        const returnNodes = [];
        nodes.forEach((node, i2) => {
          spaceLeft -= boardCols[i2];
          if (spaceLeft < 0) {
            if (!isErrorReported) {
              isErrorReported = true;
              this._reportError();
            }
            this.removeChild(node);
          } else {
            returnNodes[i2] = node;
          }
        });
        return returnNodes;
      }
      /**
       * Redraws the row, if necessary.
       *
       * In most cases, a board row will redraw itself if your reconfigure it.
       * If you dynamically change breakpoints
       * --vaadin-board-width-small or --vaadin-board-width-medium,
       * then you need to call this method.
       */
      redraw() {
        this._recalculateFlexBasis(true);
      }
      /**
       * @protected
       * @override
       */
      _onResize() {
        this._recalculateFlexBasis(false);
      }
      /** @private */
      _recalculateFlexBasis(forceResize) {
        const width = this.getBoundingClientRect().width;
        const breakpoints = this._measureBreakpointsInPx();
        if (forceResize || this._shouldRecalculate(width, breakpoints)) {
          const nodes = this.$.insertionPoint.assignedNodes({ flatten: true });
          const filteredNodes = nodes.filter((node) => node.nodeType === Node.ELEMENT_NODE);
          this._addStyleNames(width, breakpoints);
          const boardCols = this._parseBoardCols(filteredNodes);
          const colsInRow = boardCols.reduce((a, b2) => a + b2, 0);
          this._removeExtraNodesFromDOM(boardCols, filteredNodes).forEach((e2, i2) => {
            const newFlexBasis = this._calculateFlexBasis(boardCols[i2], width, colsInRow, breakpoints);
            if (forceResize || !this._oldFlexBasis[i2] || this._oldFlexBasis[i2] !== newFlexBasis) {
              this._oldFlexBasis[i2] = newFlexBasis;
              e2.style.flexBasis = newFlexBasis;
            }
          });
          this._oldWidth = width;
          this._oldBreakpoints = breakpoints;
        }
      }
      /** @private */
      _shouldRecalculate(width, breakpoints) {
        if (isElementHidden(this)) {
          return false;
        }
        return width !== this._oldWidth || breakpoints.smallSize !== this._oldBreakpoints.smallSize || breakpoints.mediumSize !== this._oldBreakpoints.mediumSize;
      }
      /**
       * Measure the breakpoints in pixels.
       *
       * The breakpoints for `small` and `medium` can be given in any unit: `px`, `em`, `in` etc.
       * We need to know them in `px` so that they are comparable with the actual size.
       *
       * @return {object} object with smallSize and mediumSize number properties, which tells
       * where the row should switch rendering size in pixels.
       * @private
       */
      _measureBreakpointsInPx() {
        const breakpoints = {};
        const tmpStyleProp = "background-position";
        const smallSize = getComputedStyle(this).getPropertyValue("--small-size");
        const mediumSize = getComputedStyle(this).getPropertyValue("--medium-size");
        this.style.setProperty(tmpStyleProp, smallSize);
        breakpoints.smallSize = parseFloat(getComputedStyle(this).getPropertyValue(tmpStyleProp));
        this.style.setProperty(tmpStyleProp, mediumSize);
        breakpoints.mediumSize = parseFloat(getComputedStyle(this).getPropertyValue(tmpStyleProp));
        this.style.removeProperty(tmpStyleProp);
        return breakpoints;
      }
    }
    defineCustomElement(BoardRow);
    /**
     * @license
     * Copyright (c) 2000 - 2024 Vaadin Ltd.
     *
     * This program is available under Vaadin Commercial License and Service Terms.
     *
     *
     * See https://vaadin.com/commercial-license-and-service-terms for the full
     * license.
     */
    class Board extends ElementMixin(PolymerElement) {
      static get template() {
        return html`
      <style>
        :host {
          display: block;
        }
      </style>
      <slot></slot>
    `;
      }
      static get is() {
        return "vaadin-board";
      }
      static get cvdlName() {
        return "vaadin-board";
      }
      /**
       * Redraws the board and all rows inside it, if necessary.
       *
       * In most cases, board will redraw itself if your reconfigure it. If you dynamically change
       * breakpoints `--vaadin-board-width-small` or `--vaadin-board-width-medium`,
       * then you need to call this method.
       */
      redraw() {
        [...this.querySelectorAll("*")].filter((node) => node instanceof BoardRow).forEach((row) => row.redraw());
      }
    }
    defineCustomElement(Board);
    /**
     * @license
     * Copyright (c) 2000 - 2024 Vaadin Ltd.
     *
     * This program is available under Vaadin Commercial License and Service Terms.
     *
     *
     * See https://vaadin.com/commercial-license-and-service-terms for the full
     * license.
     */
    const chartBaseTheme = css$e`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;
    registerStyles$1("vaadin-chart", chartBaseTheme, { moduleId: "vaadin-chart-base-theme" });
    const chartColors = css$e`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`;
    const chartTheme = css$e`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;
    registerStyles$1("vaadin-chart", [chartColors, chartTheme], { moduleId: "lumo-chart" });
    var w = typeof win !== "undefined" ? win : typeof window !== "undefined" ? window : {};
    var Globals;
    (function(Globals2) {
      Globals2.SVG_NS = "http://www.w3.org/2000/svg", Globals2.product = "Highcharts", Globals2.version = "9.2.2", Globals2.win = w, Globals2.doc = Globals2.win.document, Globals2.svg = Globals2.doc && Globals2.doc.createElementNS && !!Globals2.doc.createElementNS(Globals2.SVG_NS, "svg").createSVGRect, Globals2.userAgent = Globals2.win.navigator && Globals2.win.navigator.userAgent || "", Globals2.isChrome = Globals2.userAgent.indexOf("Chrome") !== -1, Globals2.isFirefox = Globals2.userAgent.indexOf("Firefox") !== -1, Globals2.isMS = /(edge|msie|trident)/i.test(Globals2.userAgent) && !Globals2.win.opera, Globals2.isSafari = !Globals2.isChrome && Globals2.userAgent.indexOf("Safari") !== -1, Globals2.isTouchDevice = /(Mobile|Android|Windows Phone)/.test(Globals2.userAgent), Globals2.isWebKit = Globals2.userAgent.indexOf("AppleWebKit") !== -1, Globals2.deg2rad = Math.PI * 2 / 360, Globals2.hasBidiBug = Globals2.isFirefox && parseInt(Globals2.userAgent.split("Firefox/")[1], 10) < 4, Globals2.hasTouch = !!Globals2.win.TouchEvent, Globals2.marginNames = [
        "plotTop",
        "marginRight",
        "marginBottom",
        "plotLeft"
      ], Globals2.noop = function() {
      }, Globals2.supportsPassiveEvents = function() {
        var supportsPassive = false;
        if (!Globals2.isMS) {
          var opts = Object.defineProperty({}, "passive", {
            get: function() {
              supportsPassive = true;
            }
          });
          if (Globals2.win.addEventListener && Globals2.win.removeEventListener) {
            Globals2.win.addEventListener("testPassive", Globals2.noop, opts);
            Globals2.win.removeEventListener("testPassive", Globals2.noop, opts);
          }
        }
        return supportsPassive;
      }();
      Globals2.charts = [];
      Globals2.dateFormats = {};
      Globals2.seriesTypes = {};
      Globals2.symbolSizes = {};
      Globals2.chartCount = 0;
    })(Globals || (Globals = {}));
    const H = Globals;
    var charts$5 = H.charts, doc$m = H.doc, win$g = H.win;
    function error$a(code, stop2, chart, params2) {
      var severity = stop2 ? "Highcharts error" : "Highcharts warning";
      if (code === 32) {
        code = severity + ": Deprecated member";
      }
      var isCode = isNumber$R(code);
      var message = isCode ? severity + " #" + code + ": www.highcharts.com/errors/" + code + "/" : code.toString();
      var defaultHandler = function() {
        if (stop2) {
          throw new Error(message);
        }
        if (win$g.console && error$a.messages.indexOf(message) === -1) {
          console.warn(message);
        }
      };
      if (typeof params2 !== "undefined") {
        var additionalMessages_1 = "";
        if (isCode) {
          message += "?";
        }
        objectEach$B(params2, function(value, key) {
          additionalMessages_1 += "\n - " + key + ": " + value;
          if (isCode) {
            message += encodeURI(key) + "=" + encodeURI(value);
          }
        });
        message += additionalMessages_1;
      }
      fireEvent$B(H, "displayError", { chart, code, message, params: params2 }, defaultHandler);
      error$a.messages.push(message);
    }
    (function(error2) {
      error2.messages = [];
    })(error$a || (error$a = {}));
    function merge$1p() {
      var i2, args = arguments, ret = {};
      var doCopy = function(copy, original) {
        if (typeof copy !== "object") {
          copy = {};
        }
        objectEach$B(original, function(value, key) {
          if (key === "__proto__" || key === "constructor") {
            return;
          }
          if (isObject$f(value, true) && !isClass(value) && !isDOMElement(value)) {
            copy[key] = doCopy(copy[key] || {}, value);
          } else {
            copy[key] = original[key];
          }
        });
        return copy;
      };
      if (args[0] === true) {
        ret = args[1];
        args = Array.prototype.slice.call(args, 2);
      }
      var len = args.length;
      for (i2 = 0; i2 < len; i2++) {
        ret = doCopy(ret, args[i2]);
      }
      return ret;
    }
    function clamp$k(value, min, max) {
      return value > min ? value < max ? value : max : min;
    }
    function cleanRecursively$2(newer, older) {
      var result2 = {};
      objectEach$B(newer, function(_val, key) {
        var ob2;
        if (isObject$f(newer[key], true) && !newer.nodeType && // #10044
        older[key]) {
          ob2 = cleanRecursively$2(newer[key], older[key]);
          if (Object.keys(ob2).length) {
            result2[key] = ob2;
          }
        } else if (isObject$f(newer[key]) || newer[key] !== older[key]) {
          result2[key] = newer[key];
        }
      });
      return result2;
    }
    function pInt$a(s2, mag) {
      return parseInt(s2, mag || 10);
    }
    function isString$c(s2) {
      return typeof s2 === "string";
    }
    function isArray$n(obj) {
      var str = Object.prototype.toString.call(obj);
      return str === "[object Array]" || str === "[object Array Iterator]";
    }
    function isObject$f(obj, strict) {
      return !!obj && typeof obj === "object" && (!strict || !isArray$n(obj));
    }
    function isDOMElement(obj) {
      return isObject$f(obj) && typeof obj.nodeType === "number";
    }
    function isClass(obj) {
      var c2 = obj && obj.constructor;
      return !!(isObject$f(obj, true) && !isDOMElement(obj) && (c2 && c2.name && c2.name !== "Object"));
    }
    function isNumber$R(n2) {
      return typeof n2 === "number" && !isNaN(n2) && n2 < Infinity && n2 > -Infinity;
    }
    function erase$9(arr, item2) {
      var i2 = arr.length;
      while (i2--) {
        if (arr[i2] === item2) {
          arr.splice(i2, 1);
          break;
        }
      }
    }
    function defined$W(obj) {
      return typeof obj !== "undefined" && obj !== null;
    }
    function attr$8(elem, prop, value) {
      var ret;
      if (isString$c(prop)) {
        if (defined$W(value)) {
          elem.setAttribute(prop, value);
        } else if (elem && elem.getAttribute) {
          ret = elem.getAttribute(prop);
          if (!ret && prop === "class") {
            ret = elem.getAttribute(prop + "Name");
          }
        }
      } else {
        objectEach$B(prop, function(val, key) {
          elem.setAttribute(key, val);
        });
      }
      return ret;
    }
    function splat$j(obj) {
      return isArray$n(obj) ? obj : [obj];
    }
    function syncTimeout$9(fn, delay, context) {
      if (delay > 0) {
        return setTimeout(fn, delay, context);
      }
      fn.call(0, context);
      return -1;
    }
    function internalClearTimeout(id) {
      if (defined$W(id)) {
        clearTimeout(id);
      }
    }
    function extend$1u(a, b2) {
      var n2;
      if (!a) {
        a = {};
      }
      for (n2 in b2) {
        a[n2] = b2[n2];
      }
      return a;
    }
    function pick$1B() {
      var args = arguments;
      var length = args.length;
      for (var i2 = 0; i2 < length; i2++) {
        var arg = args[i2];
        if (typeof arg !== "undefined" && arg !== null) {
          return arg;
        }
      }
    }
    function css$d(el, styles) {
      if (H.isMS && !H.svg) {
        if (styles && typeof styles.opacity !== "undefined") {
          styles.filter = "alpha(opacity=" + styles.opacity * 100 + ")";
        }
      }
      extend$1u(el.style, styles);
    }
    function createElement$b(tag, attribs, styles, parent, nopad) {
      var el = doc$m.createElement(tag);
      if (attribs) {
        extend$1u(el, attribs);
      }
      if (nopad) {
        css$d(el, { padding: "0", border: "none", margin: "0" });
      }
      if (styles) {
        css$d(el, styles);
      }
      if (parent) {
        parent.appendChild(el);
      }
      return el;
    }
    function extendClass$2(parent, members) {
      var obj = function() {
      };
      obj.prototype = new parent();
      extend$1u(obj.prototype, members);
      return obj;
    }
    function pad$2(number, length, padder) {
      return new Array((length || 2) + 1 - String(number).replace("-", "").length).join(padder || "0") + number;
    }
    function relativeLength$a(value, base, offset2) {
      return /%$/.test(value) ? base * parseFloat(value) / 100 + (offset2 || 0) : parseFloat(value);
    }
    function wrap$d(obj, method, func) {
      var proceed = obj[method];
      obj[method] = function() {
        var args = Array.prototype.slice.call(arguments), outerArgs = arguments, ctx = this;
        ctx.proceed = function() {
          proceed.apply(ctx, arguments.length ? arguments : outerArgs);
        };
        args.unshift(proceed);
        var ret = func.apply(this, args);
        ctx.proceed = null;
        return ret;
      };
    }
    function getMagnitude$3(num) {
      return Math.pow(10, Math.floor(Math.log(num) / Math.LN10));
    }
    function normalizeTickInterval$3(interval, multiples, magnitude, allowDecimals, hasTickAmount) {
      var i2, retInterval = interval;
      magnitude = pick$1B(magnitude, 1);
      var normalized = interval / magnitude;
      if (!multiples) {
        multiples = hasTickAmount ? (
          // Finer grained ticks when the tick amount is hard set, including
          // when alignTicks is true on multiple axes (#4580).
          [1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8, 10]
        ) : (
          // Else, let ticks fall on rounder numbers
          [1, 2, 2.5, 5, 10]
        );
        if (allowDecimals === false) {
          if (magnitude === 1) {
            multiples = multiples.filter(function(num) {
              return num % 1 === 0;
            });
          } else if (magnitude <= 0.1) {
            multiples = [1 / magnitude];
          }
        }
      }
      for (i2 = 0; i2 < multiples.length; i2++) {
        retInterval = multiples[i2];
        if (hasTickAmount && retInterval * magnitude >= interval || !hasTickAmount && normalized <= (multiples[i2] + (multiples[i2 + 1] || multiples[i2])) / 2) {
          break;
        }
      }
      retInterval = correctFloat$d(retInterval * magnitude, -Math.round(Math.log(1e-3) / Math.LN10));
      return retInterval;
    }
    function stableSort$7(arr, sortFunction) {
      var length = arr.length;
      var sortValue, i2;
      for (i2 = 0; i2 < length; i2++) {
        arr[i2].safeI = i2;
      }
      arr.sort(function(a, b2) {
        sortValue = sortFunction(a, b2);
        return sortValue === 0 ? a.safeI - b2.safeI : sortValue;
      });
      for (i2 = 0; i2 < length; i2++) {
        delete arr[i2].safeI;
      }
    }
    function arrayMin$9(data) {
      var i2 = data.length, min = data[0];
      while (i2--) {
        if (data[i2] < min) {
          min = data[i2];
        }
      }
      return min;
    }
    function arrayMax$a(data) {
      var i2 = data.length, max = data[0];
      while (i2--) {
        if (data[i2] > max) {
          max = data[i2];
        }
      }
      return max;
    }
    function destroyObjectProperties$a(obj, except) {
      objectEach$B(obj, function(val, n2) {
        if (val && val !== except && val.destroy) {
          val.destroy();
        }
        delete obj[n2];
      });
    }
    function discardElement$7(element) {
      if (!garbageBin) {
        garbageBin = createElement$b("div");
      }
      if (element) {
        garbageBin.appendChild(element);
      }
      garbageBin.innerHTML = "";
    }
    var garbageBin;
    function correctFloat$d(num, prec) {
      return parseFloat(num.toPrecision(prec || 14));
    }
    var timeUnits$3 = {
      millisecond: 1,
      second: 1e3,
      minute: 6e4,
      hour: 36e5,
      day: 24 * 36e5,
      week: 7 * 24 * 36e5,
      month: 28 * 24 * 36e5,
      year: 364 * 24 * 36e5
    };
    Math.easeInOutSine = function(pos) {
      return -0.5 * (Math.cos(Math.PI * pos) - 1);
    };
    function getNestedProperty$3(path, parent) {
      var pathElements = path.split(".");
      while (pathElements.length && defined$W(parent)) {
        var pathElement = pathElements.shift();
        if (typeof pathElement === "undefined" || pathElement === "__proto__") {
          return;
        }
        var child = parent[pathElement];
        if (!defined$W(child) || typeof child === "function" || typeof child.nodeType === "number" || child === win$g) {
          return;
        }
        parent = child;
      }
      return parent;
    }
    function getStyle$2(el, prop, toInt) {
      var customGetStyle = H.getStyle || // oldie getStyle
      getStyle$2;
      var style;
      if (prop === "width") {
        var offsetWidth = Math.min(el.offsetWidth, el.scrollWidth);
        var boundingClientRectWidth = el.getBoundingClientRect && el.getBoundingClientRect().width;
        if (boundingClientRectWidth < offsetWidth && boundingClientRectWidth >= offsetWidth - 1) {
          offsetWidth = Math.floor(boundingClientRectWidth);
        }
        return Math.max(
          0,
          // #8377
          offsetWidth - (customGetStyle(el, "padding-left", true) || 0) - (customGetStyle(el, "padding-right", true) || 0)
        );
      }
      if (prop === "height") {
        return Math.max(
          0,
          // #8377
          Math.min(el.offsetHeight, el.scrollHeight) - (customGetStyle(el, "padding-top", true) || 0) - (customGetStyle(el, "padding-bottom", true) || 0)
        );
      }
      if (!win$g.getComputedStyle) {
        error$a(27, true);
      }
      var css2 = win$g.getComputedStyle(el, void 0);
      if (css2) {
        style = css2.getPropertyValue(prop);
        if (pick$1B(toInt, prop !== "opacity")) {
          style = pInt$a(style);
        }
      }
      return style;
    }
    function inArray(item2, arr, fromIndex) {
      error$a(32, false, void 0, { "Highcharts.inArray": "use Array.indexOf" });
      return arr.indexOf(item2, fromIndex);
    }
    var find$j = Array.prototype.find ? function(arr, callback) {
      return arr.find(callback);
    } : (
      // Legacy implementation. PhantomJS, IE <= 11 etc. #7223.
      function(arr, callback) {
        var i2;
        var length = arr.length;
        for (i2 = 0; i2 < length; i2++) {
          if (callback(arr[i2], i2)) {
            return arr[i2];
          }
        }
      }
    );
    function keys(obj) {
      error$a(32, false, void 0, { "Highcharts.keys": "use Object.keys" });
      return Object.keys(obj);
    }
    function offset$1(el) {
      var docElem = doc$m.documentElement, box = el.parentElement || el.parentNode ? el.getBoundingClientRect() : { top: 0, left: 0, width: 0, height: 0 };
      return {
        top: box.top + (win$g.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
        left: box.left + (win$g.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0),
        width: box.width,
        height: box.height
      };
    }
    function objectEach$B(obj, fn, ctx) {
      for (var key in obj) {
        if (Object.hasOwnProperty.call(obj, key)) {
          fn.call(ctx || obj[key], obj[key], key, obj);
        }
      }
    }
    objectEach$B({
      map: "map",
      each: "forEach",
      grep: "filter",
      reduce: "reduce",
      some: "some"
    }, function(val, key) {
      H[key] = function(arr) {
        var _a3;
        error$a(32, false, void 0, (_a3 = {}, _a3["Highcharts." + key] = "use Array." + val, _a3));
        return Array.prototype[val].apply(arr, [].slice.call(arguments, 1));
      };
    });
    function addEvent$12(el, type, fn, options) {
      if (options === void 0) {
        options = {};
      }
      var owner = typeof el === "function" && el.prototype || el;
      if (!Object.hasOwnProperty.call(owner, "hcEvents")) {
        owner.hcEvents = {};
      }
      var events = owner.hcEvents;
      if (H.Point && // without H a dependency loop occurs
      el instanceof H.Point && el.series && el.series.chart) {
        el.series.chart.runTrackerClick = true;
      }
      var addEventListener = el.addEventListener || H.addEventListenerPolyfill;
      if (addEventListener) {
        addEventListener.call(el, type, fn, H.supportsPassiveEvents ? {
          passive: options.passive === void 0 ? type.indexOf("touch") !== -1 : options.passive,
          capture: false
        } : false);
      }
      if (!events[type]) {
        events[type] = [];
      }
      var eventObject = {
        fn,
        order: typeof options.order === "number" ? options.order : Infinity
      };
      events[type].push(eventObject);
      events[type].sort(function(a, b2) {
        return a.order - b2.order;
      });
      return function() {
        removeEvent$c(el, type, fn);
      };
    }
    function removeEvent$c(el, type, fn) {
      function removeOneEvent(type2, fn2) {
        var removeEventListener = el.removeEventListener || H.removeEventListenerPolyfill;
        if (removeEventListener) {
          removeEventListener.call(el, type2, fn2, false);
        }
      }
      function removeAllEvents(eventCollection) {
        var types, len;
        if (!el.nodeName) {
          return;
        }
        if (type) {
          types = {};
          types[type] = true;
        } else {
          types = eventCollection;
        }
        objectEach$B(types, function(_val, n2) {
          if (eventCollection[n2]) {
            len = eventCollection[n2].length;
            while (len--) {
              removeOneEvent(n2, eventCollection[n2][len].fn);
            }
          }
        });
      }
      var owner = typeof el === "function" && el.prototype || el;
      if (Object.hasOwnProperty.call(owner, "hcEvents")) {
        var events = owner.hcEvents;
        if (type) {
          var typeEvents = events[type] || [];
          if (fn) {
            events[type] = typeEvents.filter(function(obj) {
              return fn !== obj.fn;
            });
            removeOneEvent(type, fn);
          } else {
            removeAllEvents(events);
            events[type] = [];
          }
        } else {
          removeAllEvents(events);
          delete owner.hcEvents;
        }
      }
    }
    function fireEvent$B(el, type, eventArguments, defaultFunction) {
      var e2;
      eventArguments = eventArguments || {};
      if (doc$m.createEvent && (el.dispatchEvent || el.fireEvent && // Enable firing events on Highcharts instance.
      el !== H)) {
        e2 = doc$m.createEvent("Events");
        e2.initEvent(type, true, true);
        eventArguments = extend$1u(e2, eventArguments);
        if (el.dispatchEvent) {
          el.dispatchEvent(eventArguments);
        } else {
          el.fireEvent(type, eventArguments);
        }
      } else if (el.hcEvents) {
        if (!eventArguments.target) {
          extend$1u(eventArguments, {
            // Attach a simple preventDefault function to skip
            // default handler if called. The built-in
            // defaultPrevented property is not overwritable (#5112)
            preventDefault: function() {
              eventArguments.defaultPrevented = true;
            },
            // Setting target to native events fails with clicking
            // the zoom-out button in Chrome.
            target: el,
            // If the type is not set, we're running a custom event
            // (#2297). If it is set, we're running a browser event,
            // and setting it will cause en error in IE8 (#2465).
            type
          });
        }
        var events = [];
        var object = el;
        var multilevel = false;
        while (object.hcEvents) {
          if (Object.hasOwnProperty.call(object, "hcEvents") && object.hcEvents[type]) {
            if (events.length) {
              multilevel = true;
            }
            events.unshift.apply(events, object.hcEvents[type]);
          }
          object = Object.getPrototypeOf(object);
        }
        if (multilevel) {
          events.sort(function(a, b2) {
            return a.order - b2.order;
          });
        }
        events.forEach(function(obj) {
          if (obj.fn.call(el, eventArguments) === false) {
            eventArguments.preventDefault();
          }
        });
      }
      if (defaultFunction && !eventArguments.defaultPrevented) {
        defaultFunction.call(el, eventArguments);
      }
    }
    var serialMode;
    var uniqueKey$8 = function() {
      var hash2 = Math.random().toString(36).substring(2, 9) + "-";
      var id = 0;
      return function() {
        return "highcharts-" + (serialMode ? "" : hash2) + id++;
      };
    }();
    function useSerialIds(mode2) {
      return serialMode = pick$1B(mode2, serialMode);
    }
    function isFunction$5(obj) {
      return typeof obj === "function";
    }
    if (win$g.jQuery) {
      win$g.jQuery.fn.highcharts = function() {
        var args = [].slice.call(arguments);
        if (this[0]) {
          if (args[0]) {
            new H[
              // eslint-disable-line computed-property-spacing, no-new
              // Constructor defaults to Chart
              isString$c(args[0]) ? args.shift() : "Chart"
            ](this[0], args[0], args[1]);
            return this;
          }
          return charts$5[attr$8(this[0], "data-highcharts-chart")];
        }
      };
    }
    var Utilities = {
      addEvent: addEvent$12,
      arrayMax: arrayMax$a,
      arrayMin: arrayMin$9,
      attr: attr$8,
      clamp: clamp$k,
      cleanRecursively: cleanRecursively$2,
      clearTimeout: internalClearTimeout,
      correctFloat: correctFloat$d,
      createElement: createElement$b,
      css: css$d,
      defined: defined$W,
      destroyObjectProperties: destroyObjectProperties$a,
      discardElement: discardElement$7,
      erase: erase$9,
      error: error$a,
      extend: extend$1u,
      extendClass: extendClass$2,
      find: find$j,
      fireEvent: fireEvent$B,
      getMagnitude: getMagnitude$3,
      getNestedProperty: getNestedProperty$3,
      getStyle: getStyle$2,
      inArray,
      isArray: isArray$n,
      isClass,
      isDOMElement,
      isFunction: isFunction$5,
      isNumber: isNumber$R,
      isObject: isObject$f,
      isString: isString$c,
      keys,
      merge: merge$1p,
      normalizeTickInterval: normalizeTickInterval$3,
      objectEach: objectEach$B,
      offset: offset$1,
      pad: pad$2,
      pick: pick$1B,
      pInt: pInt$a,
      relativeLength: relativeLength$a,
      removeEvent: removeEvent$c,
      splat: splat$j,
      stableSort: stableSort$7,
      syncTimeout: syncTimeout$9,
      timeUnits: timeUnits$3,
      uniqueKey: uniqueKey$8,
      useSerialIds,
      wrap: wrap$d
    };
    var palette = {
      /**
       * Colors for data series and points.
       */
      colors: [
        "#7cb5ec",
        "#434348",
        "#90ed7d",
        "#f7a35c",
        "#8085e9",
        "#f15c80",
        "#e4d354",
        "#2b908f",
        "#f45b5b",
        "#91e8e1"
      ],
      /**
       * Chart background, point stroke for markers and columns etc
       */
      backgroundColor: "#ffffff",
      /**
       * Strong text.
       */
      neutralColor100: "#000000",
      /**
       * Main text and some strokes.
       */
      neutralColor80: "#333333",
      /**
       * Axis labels, axis title, connector fallback.
       */
      neutralColor60: "#666666",
      /**
       * Credits text, export menu stroke.
       */
      neutralColor40: "#999999",
      /**
       * Disabled texts, button strokes, crosshair etc.
       */
      neutralColor20: "#cccccc",
      /**
       * Grid lines etc.
       */
      neutralColor10: "#e6e6e6",
      /**
       * Minor grid lines etc.
       */
      neutralColor5: "#f2f2f2",
      /**
       * Tooltip backgroud, button fills, map null points.
       */
      neutralColor3: "#f7f7f7",
      /**
       * Drilldown clickable labels, color axis max color.
       */
      highlightColor100: "#003399",
      /**
       * Selection marker, menu hover, button hover, chart border, navigator series.
       */
      highlightColor80: "#335cad",
      /**
       * Navigator mask fill.
       */
      highlightColor60: "#6685c2",
      /**
       * Ticks and axis line.
       */
      highlightColor20: "#ccd6eb",
      /**
       * Pressed button, color axis min color.
       */
      highlightColor10: "#e6ebf5",
      /**
       * Positive indicator color
       */
      positiveColor: "#06b535",
      /**
       * Negative indicator color
       */
      negativeColor: "#f21313"
    };
    var ChartDefaults = {
      /**
       * Default `mapData` for all series. If set to a string, it functions
       * as an index into the `Highcharts.maps` array. Otherwise it is
       * interpreted as map data.
       *
       * @see [mapData](#series.map.mapData)
       *
       * @sample    maps/demo/geojson
       *            Loading geoJSON data
       * @sample    maps/chart/topojson
       *            Loading topoJSON converted to geoJSON
       *
       * @type      {string|Array<*>|Highcharts.GeoJSON}
       * @since     5.0.0
       * @product   highmaps
       * @apioption chart.map
       */
      /**
       * Set lat/lon transformation definitions for the chart. If not defined,
       * these are extracted from the map data.
       *
       * @type      {*}
       * @since     5.0.0
       * @product   highmaps
       * @apioption chart.mapTransforms
       */
      /**
       * When using multiple axis, the ticks of two or more opposite axes
       * will automatically be aligned by adding ticks to the axis or axes
       * with the least ticks, as if `tickAmount` were specified.
       *
       * This can be prevented by setting `alignTicks` to false. If the grid
       * lines look messy, it's a good idea to hide them for the secondary
       * axis by setting `gridLineWidth` to 0.
       *
       * If `startOnTick` or `endOnTick` in an Axis options are set to false,
       * then the `alignTicks ` will be disabled for the Axis.
       *
       * Disabled for logarithmic axes.
       *
       * @sample {highcharts} highcharts/chart/alignticks-true/
       *         True by default
       * @sample {highcharts} highcharts/chart/alignticks-false/
       *         False
       * @sample {highstock} stock/chart/alignticks-true/
       *         True by default
       * @sample {highstock} stock/chart/alignticks-false/
       *         False
       *
       * @type      {boolean}
       * @default   true
       * @product   highcharts highstock gantt
       * @apioption chart.alignTicks
       */
      /**
       * Set the overall animation for all chart updating. Animation can be
       * disabled throughout the chart by setting it to false here. It can
       * be overridden for each individual API method as a function parameter.
       * The only animation not affected by this option is the initial series
       * animation, see [plotOptions.series.animation](
       * #plotOptions.series.animation).
       *
       * The animation can either be set as a boolean or a configuration
       * object. If `true`, it will use the 'swing' jQuery easing and a
       * duration of 500 ms. If used as a configuration object, the following
       * properties are supported:
       *
       * - `defer`: The animation delay time in milliseconds.
       *
       * - `duration`: The duration of the animation in milliseconds.
       *
       * - `easing`: A string reference to an easing function set on the
       *   `Math` object. See
       *   [the easing demo](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-animation-easing/).
       *
       * When zooming on a series with less than 100 points, the chart redraw
       * will be done with animation, but in case of more data points, it is
       * necessary to set this option to ensure animation on zoom.
       *
       * @sample {highcharts} highcharts/chart/animation-none/
       *         Updating with no animation
       * @sample {highcharts} highcharts/chart/animation-duration/
       *         With a longer duration
       * @sample {highcharts} highcharts/chart/animation-easing/
       *         With a jQuery UI easing
       * @sample {highmaps} maps/chart/animation-none/
       *         Updating with no animation
       * @sample {highmaps} maps/chart/animation-duration/
       *         With a longer duration
       *
       * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @default   undefined
       * @apioption chart.animation
       */
      /**
       * A CSS class name to apply to the charts container `div`, allowing
       * unique CSS styling for each chart.
       *
       * @type      {string}
       * @apioption chart.className
       */
      /**
       * Event listeners for the chart.
       *
       * @apioption chart.events
       */
      /**
       * Fires when a series is added to the chart after load time, using the
       * `addSeries` method. One parameter, `event`, is passed to the
       * function, containing common event information. Through
       * `event.options` you can access the series options that were passed to
       * the `addSeries` method. Returning false prevents the series from
       * being added.
       *
       * @sample {highcharts} highcharts/chart/events-addseries/
       *         Alert on add series
       * @sample {highstock} stock/chart/events-addseries/
       *         Alert on add series
       *
       * @type      {Highcharts.ChartAddSeriesCallbackFunction}
       * @since     1.2.0
       * @context   Highcharts.Chart
       * @apioption chart.events.addSeries
       */
      /**
       * Fires when clicking on the plot background. One parameter, `event`,
       * is passed to the function, containing common event information.
       *
       * Information on the clicked spot can be found through `event.xAxis`
       * and `event.yAxis`, which are arrays containing the axes of each
       * dimension and each axis' value at the clicked spot. The primary axes
       * are `event.xAxis[0]` and `event.yAxis[0]`. Remember the unit of a
       * datetime axis is milliseconds since 1970-01-01 00:00:00.
       *
       * ```js
       * click: function(e) {
       *     console.log(
       *         Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', e.xAxis[0].value),
       *         e.yAxis[0].value
       *     )
       * }
       * ```
       *
       * @sample {highcharts} highcharts/chart/events-click/
       *         Alert coordinates on click
       * @sample {highcharts} highcharts/chart/events-container/
       *         Alternatively, attach event to container
       * @sample {highstock} stock/chart/events-click/
       *         Alert coordinates on click
       * @sample {highstock} highcharts/chart/events-container/
       *         Alternatively, attach event to container
       * @sample {highmaps} maps/chart/events-click/
       *         Record coordinates on click
       * @sample {highmaps} highcharts/chart/events-container/
       *         Alternatively, attach event to container
       *
       * @type      {Highcharts.ChartClickCallbackFunction}
       * @since     1.2.0
       * @context   Highcharts.Chart
       * @apioption chart.events.click
       */
      /**
       * Fires when the chart is finished loading. Since v4.2.2, it also waits
       * for images to be loaded, for example from point markers. One
       * parameter, `event`, is passed to the function, containing common
       * event information.
       *
       * There is also a second parameter to the chart constructor where a
       * callback function can be passed to be executed on chart.load.
       *
       * @sample {highcharts} highcharts/chart/events-load/
       *         Alert on chart load
       * @sample {highstock} stock/chart/events-load/
       *         Alert on chart load
       * @sample {highmaps} maps/chart/events-load/
       *         Add series on chart load
       *
       * @type      {Highcharts.ChartLoadCallbackFunction}
       * @context   Highcharts.Chart
       * @apioption chart.events.load
       */
      /**
       * Fires when the chart is redrawn, either after a call to
       * `chart.redraw()` or after an axis, series or point is modified with
       * the `redraw` option set to `true`. One parameter, `event`, is passed
       * to the function, containing common event information.
       *
       * @sample {highcharts} highcharts/chart/events-redraw/
       *         Alert on chart redraw
       * @sample {highstock} stock/chart/events-redraw/
       *         Alert on chart redraw when adding a series or moving the
       *         zoomed range
       * @sample {highmaps} maps/chart/events-redraw/
       *         Set subtitle on chart redraw
       *
       * @type      {Highcharts.ChartRedrawCallbackFunction}
       * @since     1.2.0
       * @context   Highcharts.Chart
       * @apioption chart.events.redraw
       */
      /**
       * Fires after initial load of the chart (directly after the `load`
       * event), and after each redraw (directly after the `redraw` event).
       *
       * @type      {Highcharts.ChartRenderCallbackFunction}
       * @since     5.0.7
       * @context   Highcharts.Chart
       * @apioption chart.events.render
       */
      /**
       * Fires when an area of the chart has been selected. Selection is
       * enabled by setting the chart's zoomType. One parameter, `event`, is
       * passed to the function, containing common event information. The
       * default action for the selection event is to zoom the chart to the
       * selected area. It can be prevented by calling
       * `event.preventDefault()` or return false.
       *
       * Information on the selected area can be found through `event.xAxis`
       * and `event.yAxis`, which are arrays containing the axes of each
       * dimension and each axis' min and max values. The primary axes are
       * `event.xAxis[0]` and `event.yAxis[0]`. Remember the unit of a
       * datetime axis is milliseconds since 1970-01-01 00:00:00.
       *
       * ```js
       * selection: function(event) {
       *     // log the min and max of the primary, datetime x-axis
       *     console.log(
       *         Highcharts.dateFormat(
       *             '%Y-%m-%d %H:%M:%S',
       *             event.xAxis[0].min
       *         ),
       *         Highcharts.dateFormat(
       *             '%Y-%m-%d %H:%M:%S',
       *             event.xAxis[0].max
       *         )
       *     );
       *     // log the min and max of the y axis
       *     console.log(event.yAxis[0].min, event.yAxis[0].max);
       * }
       * ```
       *
       * @sample {highcharts} highcharts/chart/events-selection/
       *         Report on selection and reset
       * @sample {highcharts} highcharts/chart/events-selection-points/
       *         Select a range of points through a drag selection
       * @sample {highstock} stock/chart/events-selection/
       *         Report on selection and reset
       * @sample {highstock} highcharts/chart/events-selection-points/
       *         Select a range of points through a drag selection
       *         (Highcharts)
       *
       * @type      {Highcharts.ChartSelectionCallbackFunction}
       * @apioption chart.events.selection
       */
      /**
       * The margin between the outer edge of the chart and the plot area.
       * The numbers in the array designate top, right, bottom and left
       * respectively. Use the options `marginTop`, `marginRight`,
       * `marginBottom` and `marginLeft` for shorthand setting of one option.
       *
       * By default there is no margin. The actual space is dynamically
       * calculated from the offset of axis labels, axis title, title,
       * subtitle and legend in addition to the `spacingTop`, `spacingRight`,
       * `spacingBottom` and `spacingLeft` options.
       *
       * @sample {highcharts} highcharts/chart/margins-zero/
       *         Zero margins
       * @sample {highstock} stock/chart/margin-zero/
       *         Zero margins
       *
       * @type      {number|Array<number>}
       * @apioption chart.margin
       */
      /**
       * The margin between the bottom outer edge of the chart and the plot
       * area. Use this to set a fixed pixel value for the margin as opposed
       * to the default dynamic margin. See also `spacingBottom`.
       *
       * @sample {highcharts} highcharts/chart/marginbottom/
       *         100px bottom margin
       * @sample {highstock} stock/chart/marginbottom/
       *         100px bottom margin
       * @sample {highmaps} maps/chart/margin/
       *         100px margins
       *
       * @type      {number}
       * @since     2.0
       * @apioption chart.marginBottom
       */
      /**
       * The margin between the left outer edge of the chart and the plot
       * area. Use this to set a fixed pixel value for the margin as opposed
       * to the default dynamic margin. See also `spacingLeft`.
       *
       * @sample {highcharts} highcharts/chart/marginleft/
       *         150px left margin
       * @sample {highstock} stock/chart/marginleft/
       *         150px left margin
       * @sample {highmaps} maps/chart/margin/
       *         100px margins
       *
       * @type      {number}
       * @since     2.0
       * @apioption chart.marginLeft
       */
      /**
       * The margin between the right outer edge of the chart and the plot
       * area. Use this to set a fixed pixel value for the margin as opposed
       * to the default dynamic margin. See also `spacingRight`.
       *
       * @sample {highcharts} highcharts/chart/marginright/
       *         100px right margin
       * @sample {highstock} stock/chart/marginright/
       *         100px right margin
       * @sample {highmaps} maps/chart/margin/
       *         100px margins
       *
       * @type      {number}
       * @since     2.0
       * @apioption chart.marginRight
       */
      /**
       * The margin between the top outer edge of the chart and the plot area.
       * Use this to set a fixed pixel value for the margin as opposed to
       * the default dynamic margin. See also `spacingTop`.
       *
       * @sample {highcharts} highcharts/chart/margintop/ 100px top margin
       * @sample {highstock} stock/chart/margintop/
       *         100px top margin
       * @sample {highmaps} maps/chart/margin/
       *         100px margins
       *
       * @type      {number}
       * @since     2.0
       * @apioption chart.marginTop
       */
      /**
       * Callback function to override the default function that formats all
       * the numbers in the chart. Returns a string with the formatted number.
       *
       * @sample highcharts/members/highcharts-numberformat
       *      Arabic digits in Highcharts
       * @type {Highcharts.NumberFormatterCallbackFunction}
       * @since 8.0.0
       * @apioption chart.numberFormatter
       */
      /**
       * Allows setting a key to switch between zooming and panning. Can be
       * one of `alt`, `ctrl`, `meta` (the command key on Mac and Windows
       * key on Windows) or `shift`. The keys are mapped directly to the key
       * properties of the click event argument (`event.altKey`,
       * `event.ctrlKey`, `event.metaKey` and `event.shiftKey`).
       *
       * @type       {string}
       * @since      4.0.3
       * @product    highcharts gantt
       * @validvalue ["alt", "ctrl", "meta", "shift"]
       * @apioption  chart.panKey
       */
      /**
       * Allow panning in a chart. Best used with [panKey](#chart.panKey)
       * to combine zooming and panning.
       *
       * On touch devices, when the [tooltip.followTouchMove](
       * #tooltip.followTouchMove) option is `true` (default), panning
       * requires two fingers. To allow panning with one finger, set
       * `followTouchMove` to `false`.
       *
       * @sample  {highcharts} highcharts/chart/pankey/ Zooming and panning
       * @sample  {highstock} stock/chart/panning/ Zooming and xy panning
       */
      panning: {
        /**
         * Enable or disable chart panning.
         *
         * @type      {boolean}
         * @default   {highcharts} false
         * @default   {highstock|highmaps} true
         */
        enabled: false,
        /**
         * Decides in what dimensions the user can pan the chart. Can be
         * one of `x`, `y`, or `xy`.
         *
         * @sample {highcharts} highcharts/chart/panning-type
         *         Zooming and xy panning
         *
         * @type       {string}
         * @validvalue ["x", "y", "xy"]
         * @default    {highcharts|highstock} x
         * @default    {highmaps} xy
         */
        type: "x"
      },
      /**
       * Equivalent to [zoomType](#chart.zoomType), but for multitouch
       * gestures only. By default, the `pinchType` is the same as the
       * `zoomType` setting. However, pinching can be enabled separately in
       * some cases, for example in stock charts where a mouse drag pans the
       * chart, while pinching is enabled. When [tooltip.followTouchMove](
       * #tooltip.followTouchMove) is true, pinchType only applies to
       * two-finger touches.
       *
       * @type       {string}
       * @default    {highcharts} undefined
       * @default    {highstock} x
       * @since      3.0
       * @product    highcharts highstock gantt
       * @validvalue ["x", "y", "xy"]
       * @apioption  chart.pinchType
       */
      /**
       * Whether to apply styled mode. When in styled mode, no presentational
       * attributes or CSS are applied to the chart SVG. Instead, CSS rules
       * are required to style the chart. The default style sheet is
       * available from `https://code.highcharts.com/css/highcharts.css`.
       *
       * @type       {boolean}
       * @default    false
       * @since      7.0
       * @apioption  chart.styledMode
       */
      styledMode: false,
      /**
       * The corner radius of the outer chart border.
       *
       * @sample {highcharts} highcharts/chart/borderradius/
       *         20px radius
       * @sample {highstock} stock/chart/border/
       *         10px radius
       * @sample {highmaps} maps/chart/border/
       *         Border options
       *
       */
      borderRadius: 0,
      /**
       * In styled mode, this sets how many colors the class names
       * should rotate between. With ten colors, series (or points) are
       * given class names like `highcharts-color-0`, `highcharts-color-0`
       * [...] `highcharts-color-9`. The equivalent in non-styled mode
       * is to set colors using the [colors](#colors) setting.
       *
       * @since      5.0.0
       */
      colorCount: 10,
      /**
       * Alias of `type`.
       *
       * @sample {highcharts} highcharts/chart/defaultseriestype/
       *         Bar
       *
       * @deprecated
       *
       * @product highcharts
       */
      defaultSeriesType: "line",
      /**
       * If true, the axes will scale to the remaining visible series once
       * one series is hidden. If false, hiding and showing a series will
       * not affect the axes or the other series. For stacks, once one series
       * within the stack is hidden, the rest of the stack will close in
       * around it even if the axis is not affected.
       *
       * @sample {highcharts} highcharts/chart/ignorehiddenseries-true/
       *         True by default
       * @sample {highcharts} highcharts/chart/ignorehiddenseries-false/
       *         False
       * @sample {highcharts} highcharts/chart/ignorehiddenseries-true-stacked/
       *         True with stack
       * @sample {highstock} stock/chart/ignorehiddenseries-true/
       *         True by default
       * @sample {highstock} stock/chart/ignorehiddenseries-false/
       *         False
       *
       * @since   1.2.0
       * @product highcharts highstock gantt
       */
      ignoreHiddenSeries: true,
      /**
       * Whether to invert the axes so that the x axis is vertical and y axis
       * is horizontal. When `true`, the x axis is [reversed](#xAxis.reversed)
       * by default.
       *
       * @productdesc {highcharts}
       * If a bar series is present in the chart, it will be inverted
       * automatically. Inverting the chart doesn't have an effect if there
       * are no cartesian series in the chart, or if the chart is
       * [polar](#chart.polar).
       *
       * @sample {highcharts} highcharts/chart/inverted/
       *         Inverted line
       * @sample {highstock} stock/navigator/inverted/
       *         Inverted stock chart
       *
       * @type      {boolean}
       * @default   false
       * @product   highcharts highstock gantt
       * @apioption chart.inverted
       */
      /**
       * The distance between the outer edge of the chart and the content,
       * like title or legend, or axis title and labels if present. The
       * numbers in the array designate top, right, bottom and left
       * respectively. Use the options spacingTop, spacingRight, spacingBottom
       * and spacingLeft options for shorthand setting of one option.
       *
       * @type    {Array<number>}
       * @see     [chart.margin](#chart.margin)
       * @default [10, 10, 15, 10]
       * @since   3.0.6
       */
      spacing: [10, 10, 15, 10],
      /**
       * The button that appears after a selection zoom, allowing the user
       * to reset zoom.
       */
      resetZoomButton: {
        /**
         * What frame the button placement should be related to. Can be
         * either `plotBox` or `spacingBox`.
         *
         * @sample {highcharts} highcharts/chart/resetzoombutton-relativeto/
         *         Relative to the chart
         * @sample {highstock} highcharts/chart/resetzoombutton-relativeto/
         *         Relative to the chart
         *
         * @type       {Highcharts.ButtonRelativeToValue}
         * @default    plot
         * @since      2.2
         * @apioption  chart.resetZoomButton.relativeTo
         */
        /**
         * A collection of attributes for the button. The object takes SVG
         * attributes like `fill`, `stroke`, `stroke-width` or `r`, the
         * border radius. The theme also supports `style`, a collection of
         * CSS properties for the text. Equivalent attributes for the hover
         * state are given in `theme.states.hover`.
         *
         * @sample {highcharts} highcharts/chart/resetzoombutton-theme/
         *         Theming the button
         * @sample {highstock} highcharts/chart/resetzoombutton-theme/
         *         Theming the button
         *
         * @type {Highcharts.SVGAttributes}
         * @since 2.2
         */
        theme: {
          /** @internal */
          zIndex: 6
        },
        /**
         * The position of the button.
         *
         * @sample {highcharts} highcharts/chart/resetzoombutton-position/
         *         Above the plot area
         * @sample {highstock} highcharts/chart/resetzoombutton-position/
         *         Above the plot area
         * @sample {highmaps} highcharts/chart/resetzoombutton-position/
         *         Above the plot area
         *
         * @type  {Highcharts.AlignObject}
         * @since 2.2
         */
        position: {
          /**
           * The horizontal alignment of the button.
           */
          align: "right",
          /**
           * The horizontal offset of the button.
           */
          x: -10,
          /**
           * The vertical alignment of the button.
           *
           * @type       {Highcharts.VerticalAlignValue}
           * @default    top
           * @apioption  chart.resetZoomButton.position.verticalAlign
           */
          /**
           * The vertical offset of the button.
           */
          y: 10
        }
      },
      /**
       * The pixel width of the plot area border.
       *
       * @sample {highcharts} highcharts/chart/plotborderwidth/
       *         1px border
       * @sample {highstock} stock/chart/plotborder/
       *         2px border
       * @sample {highmaps} maps/chart/plotborder/
       *         Plot border options
       *
       * @type      {number}
       * @default   0
       * @apioption chart.plotBorderWidth
       */
      /**
       * Whether to apply a drop shadow to the plot area. Requires that
       * plotBackgroundColor be set. The shadow can be an object configuration
       * containing `color`, `offsetX`, `offsetY`, `opacity` and `width`.
       *
       * @sample {highcharts} highcharts/chart/plotshadow/
       *         Plot shadow
       * @sample {highstock} stock/chart/plotshadow/
       *         Plot shadow
       * @sample {highmaps} maps/chart/plotborder/
       *         Plot border options
       *
       * @type      {boolean|Highcharts.CSSObject}
       * @default   false
       * @apioption chart.plotShadow
       */
      /**
       * When true, cartesian charts like line, spline, area and column are
       * transformed into the polar coordinate system. This produces _polar
       * charts_, also known as _radar charts_.
       *
       * @sample {highcharts} highcharts/demo/polar/
       *         Polar chart
       * @sample {highcharts} highcharts/demo/polar-wind-rose/
       *         Wind rose, stacked polar column chart
       * @sample {highcharts} highcharts/demo/polar-spider/
       *         Spider web chart
       * @sample {highcharts} highcharts/parallel-coordinates/polar/
       *         Star plot, multivariate data in a polar chart
       *
       * @type      {boolean}
       * @default   false
       * @since     2.3.0
       * @product   highcharts
       * @requires  highcharts-more
       * @apioption chart.polar
       */
      /**
       * Whether to reflow the chart to fit the width of the container div
       * on resizing the window.
       *
       * @sample {highcharts} highcharts/chart/reflow-true/
       *         True by default
       * @sample {highcharts} highcharts/chart/reflow-false/
       *         False
       * @sample {highstock} stock/chart/reflow-true/
       *         True by default
       * @sample {highstock} stock/chart/reflow-false/
       *         False
       * @sample {highmaps} maps/chart/reflow-true/
       *         True by default
       * @sample {highmaps} maps/chart/reflow-false/
       *         False
       *
       * @type      {boolean}
       * @default   true
       * @since     2.1
       * @apioption chart.reflow
       */
      /**
       * The HTML element where the chart will be rendered. If it is a string,
       * the element by that id is used. The HTML element can also be passed
       * by direct reference, or as the first argument of the chart
       * constructor, in which case the option is not needed.
       *
       * @sample {highcharts} highcharts/chart/reflow-true/
       *         String
       * @sample {highcharts} highcharts/chart/renderto-object/
       *         Object reference
       * @sample {highstock} stock/chart/renderto-string/
       *         String
       * @sample {highstock} stock/chart/renderto-object/
       *         Object reference
       *
       * @type      {string|Highcharts.HTMLDOMElement}
       * @apioption chart.renderTo
       */
      /**
       * The background color of the marker square when selecting (zooming
       * in on) an area of the chart.
       *
       * @see In styled mode, the selection marker fill is set with the
       *      `.highcharts-selection-marker` class.
       *
       * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @default   rgba(51,92,173,0.25)
       * @since     2.1.7
       * @apioption chart.selectionMarkerFill
       */
      /**
       * Whether to apply a drop shadow to the outer chart area. Requires
       * that backgroundColor be set. The shadow can be an object
       * configuration containing `color`, `offsetX`, `offsetY`, `opacity` and
       * `width`.
       *
       * @sample {highcharts} highcharts/chart/shadow/
       *         Shadow
       * @sample {highstock} stock/chart/shadow/
       *         Shadow
       * @sample {highmaps} maps/chart/border/
       *         Chart border and shadow
       *
       * @type      {boolean|Highcharts.CSSObject}
       * @default   false
       * @apioption chart.shadow
       */
      /**
       * Whether to show the axes initially. This only applies to empty charts
       * where series are added dynamically, as axes are automatically added
       * to cartesian series.
       *
       * @sample {highcharts} highcharts/chart/showaxes-false/
       *         False by default
       * @sample {highcharts} highcharts/chart/showaxes-true/
       *         True
       *
       * @type      {boolean}
       * @since     1.2.5
       * @product   highcharts gantt
       * @apioption chart.showAxes
       */
      /**
       * The space between the bottom edge of the chart and the content (plot
       * area, axis title and labels, title, subtitle or legend in top
       * position).
       *
       * @sample {highcharts} highcharts/chart/spacingbottom/
       *         Spacing bottom set to 100
       * @sample {highstock} stock/chart/spacingbottom/
       *         Spacing bottom set to 100
       * @sample {highmaps} maps/chart/spacing/
       *         Spacing 100 all around
       *
       * @type      {number}
       * @default   15
       * @since     2.1
       * @apioption chart.spacingBottom
       */
      /**
       * The space between the left edge of the chart and the content (plot
       * area, axis title and labels, title, subtitle or legend in top
       * position).
       *
       * @sample {highcharts} highcharts/chart/spacingleft/
       *         Spacing left set to 100
       * @sample {highstock} stock/chart/spacingleft/
       *         Spacing left set to 100
       * @sample {highmaps} maps/chart/spacing/
       *         Spacing 100 all around
       *
       * @type      {number}
       * @default   10
       * @since     2.1
       * @apioption chart.spacingLeft
       */
      /**
       * The space between the right edge of the chart and the content (plot
       * area, axis title and labels, title, subtitle or legend in top
       * position).
       *
       * @sample {highcharts} highcharts/chart/spacingright-100/
       *         Spacing set to 100
       * @sample {highcharts} highcharts/chart/spacingright-legend/
       *         Legend in right position with default spacing
       * @sample {highstock} stock/chart/spacingright/
       *         Spacing set to 100
       * @sample {highmaps} maps/chart/spacing/
       *         Spacing 100 all around
       *
       * @type      {number}
       * @default   10
       * @since     2.1
       * @apioption chart.spacingRight
       */
      /**
       * The space between the top edge of the chart and the content (plot
       * area, axis title and labels, title, subtitle or legend in top
       * position).
       *
       * @sample {highcharts} highcharts/chart/spacingtop-100/
       *         A top spacing of 100
       * @sample {highcharts} highcharts/chart/spacingtop-10/
       *         Floating chart title makes the plot area align to the default
       *         spacingTop of 10.
       * @sample {highstock} stock/chart/spacingtop/
       *         A top spacing of 100
       * @sample {highmaps} maps/chart/spacing/
       *         Spacing 100 all around
       *
       * @type      {number}
       * @default   10
       * @since     2.1
       * @apioption chart.spacingTop
       */
      /**
       * Additional CSS styles to apply inline to the container `div`. Note
       * that since the default font styles are applied in the renderer, it
       * is ignorant of the individual chart options and must be set globally.
       *
       * @see    In styled mode, general chart styles can be set with the
       *         `.highcharts-root` class.
       * @sample {highcharts} highcharts/chart/style-serif-font/
       *         Using a serif type font
       * @sample {highcharts} highcharts/css/em/
       *         Styled mode with relative font sizes
       * @sample {highstock} stock/chart/style/
       *         Using a serif type font
       * @sample {highmaps} maps/chart/style-serif-font/
       *         Using a serif type font
       *
       * @type      {Highcharts.CSSObject}
       * @default   {"fontFamily": "\"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, Arial, Helvetica, sans-serif","fontSize":"12px"}
       * @apioption chart.style
       */
      /**
       * The default series type for the chart. Can be any of the chart types
       * listed under [plotOptions](#plotOptions) and [series](#series) or can
       * be a series provided by an additional module.
       *
       * In TypeScript this option has no effect in sense of typing and
       * instead the `type` option must always be set in the series.
       *
       * @sample {highcharts} highcharts/chart/type-bar/
       *         Bar
       * @sample {highstock} stock/chart/type/
       *         Areaspline
       * @sample {highmaps} maps/chart/type-mapline/
       *         Mapline
       *
       * @type       {string}
       * @default    {highcharts} line
       * @default    {highstock} line
       * @default    {highmaps} map
       * @since      2.1.0
       * @apioption  chart.type
       */
      /**
       * Decides in what dimensions the user can zoom by dragging the mouse.
       * Can be one of `x`, `y` or `xy`.
       *
       * @see [panKey](#chart.panKey)
       *
       * @sample {highcharts} highcharts/chart/zoomtype-none/
       *         None by default
       * @sample {highcharts} highcharts/chart/zoomtype-x/
       *         X
       * @sample {highcharts} highcharts/chart/zoomtype-y/
       *         Y
       * @sample {highcharts} highcharts/chart/zoomtype-xy/
       *         Xy
       * @sample {highstock} stock/demo/basic-line/
       *         None by default
       * @sample {highstock} stock/chart/zoomtype-x/
       *         X
       * @sample {highstock} stock/chart/zoomtype-y/
       *         Y
       * @sample {highstock} stock/chart/zoomtype-xy/
       *         Xy
       *
       * @type       {string}
       * @product    highcharts highstock gantt
       * @validvalue ["x", "y", "xy"]
       * @apioption  chart.zoomType
       */
      /**
       * Enables zooming by a single touch, in combination with
       * [chart.zoomType](#chart.zoomType). When enabled, two-finger pinch
       * will still work as set up by [chart.pinchType](#chart.pinchType).
       * However, `zoomBySingleTouch` will interfere with touch-dragging the
       * chart to read the tooltip. And especially when vertical zooming is
       * enabled, it will make it hard to scroll vertically on the page.
       * @since 9.0.0
       * @sample     highcharts/chart/zoombysingletouch
       *             Zoom by single touch enabled, with buttons to toggle
       * @product    highcharts highstock gantt
       */
      zoomBySingleTouch: false,
      /**
       * An explicit width for the chart. By default (when `null`) the width
       * is calculated from the offset width of the containing element.
       *
       * @sample {highcharts} highcharts/chart/width/
       *         800px wide
       * @sample {highstock} stock/chart/width/
       *         800px wide
       * @sample {highmaps} maps/chart/size/
       *         Chart with explicit size
       *
       * @type {null|number|string}
       */
      width: null,
      /**
       * An explicit height for the chart. If a _number_, the height is
       * given in pixels. If given a _percentage string_ (for example
       * `'56%'`), the height is given as the percentage of the actual chart
       * width. This allows for preserving the aspect ratio across responsive
       * sizes.
       *
       * By default (when `null`) the height is calculated from the offset
       * height of the containing element, or 400 pixels if the containing
       * element's height is 0.
       *
       * @sample {highcharts} highcharts/chart/height/
       *         500px height
       * @sample {highstock} stock/chart/height/
       *         300px height
       * @sample {highmaps} maps/chart/size/
       *         Chart with explicit size
       * @sample highcharts/chart/height-percent/
       *         Highcharts with percentage height
       *
       * @type {null|number|string}
       */
      height: null,
      /**
       * The color of the outer chart border.
       *
       * @see In styled mode, the stroke is set with the
       *      `.highcharts-background` class.
       *
       * @sample {highcharts} highcharts/chart/bordercolor/
       *         Brown border
       * @sample {highstock} stock/chart/border/
       *         Brown border
       * @sample {highmaps} maps/chart/border/
       *         Border options
       *
       * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       */
      borderColor: palette.highlightColor80,
      /**
       * The pixel width of the outer chart border.
       *
       * @see In styled mode, the stroke is set with the
       *      `.highcharts-background` class.
       *
       * @sample {highcharts} highcharts/chart/borderwidth/
       *         5px border
       * @sample {highstock} stock/chart/border/
       *         2px border
       * @sample {highmaps} maps/chart/border/
       *         Border options
       *
       * @type      {number}
       * @default   0
       * @apioption chart.borderWidth
       */
      /**
       * The background color or gradient for the outer chart area.
       *
       * @see In styled mode, the background is set with the
       *      `.highcharts-background` class.
       *
       * @sample {highcharts} highcharts/chart/backgroundcolor-color/
       *         Color
       * @sample {highcharts} highcharts/chart/backgroundcolor-gradient/
       *         Gradient
       * @sample {highstock} stock/chart/backgroundcolor-color/
       *         Color
       * @sample {highstock} stock/chart/backgroundcolor-gradient/
       *         Gradient
       * @sample {highmaps} maps/chart/backgroundcolor-color/
       *         Color
       * @sample {highmaps} maps/chart/backgroundcolor-gradient/
       *         Gradient
       *
       * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       */
      backgroundColor: palette.backgroundColor,
      /**
       * The background color or gradient for the plot area.
       *
       * @see In styled mode, the plot background is set with the
       *      `.highcharts-plot-background` class.
       *
       * @sample {highcharts} highcharts/chart/plotbackgroundcolor-color/
       *         Color
       * @sample {highcharts} highcharts/chart/plotbackgroundcolor-gradient/
       *         Gradient
       * @sample {highstock} stock/chart/plotbackgroundcolor-color/
       *         Color
       * @sample {highstock} stock/chart/plotbackgroundcolor-gradient/
       *         Gradient
       * @sample {highmaps} maps/chart/plotbackgroundcolor-color/
       *         Color
       * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
       *         Gradient
       *
       * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @apioption chart.plotBackgroundColor
       */
      /**
       * The URL for an image to use as the plot background. To set an image
       * as the background for the entire chart, set a CSS background image
       * to the container element. Note that for the image to be applied to
       * exported charts, its URL needs to be accessible by the export server.
       *
       * @see In styled mode, a plot background image can be set with the
       *      `.highcharts-plot-background` class and a [custom pattern](
       *      https://www.highcharts.com/docs/chart-design-and-style/
       *      gradients-shadows-and-patterns).
       *
       * @sample {highcharts} highcharts/chart/plotbackgroundimage/
       *         Skies
       * @sample {highstock} stock/chart/plotbackgroundimage/
       *         Skies
       *
       * @type      {string}
       * @apioption chart.plotBackgroundImage
       */
      /**
       * The color of the inner chart or plot area border.
       *
       * @see In styled mode, a plot border stroke can be set with the
       *      `.highcharts-plot-border` class.
       *
       * @sample {highcharts} highcharts/chart/plotbordercolor/
       *         Blue border
       * @sample {highstock} stock/chart/plotborder/
       *         Blue border
       * @sample {highmaps} maps/chart/plotborder/
       *         Plot border options
       *
       * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       */
      plotBorderColor: palette.neutralColor20
    };
    var isNumber$Q = Utilities.isNumber, merge$1o = Utilities.merge, pInt$9 = Utilities.pInt;
    var Color = (
      /** @class */
      function() {
        function Color2(input) {
          this.rgba = [NaN, NaN, NaN, NaN];
          this.input = input;
          var GlobalColor = H.Color;
          if (GlobalColor && GlobalColor !== Color2) {
            return new GlobalColor(input);
          }
          if (!(this instanceof Color2)) {
            return new Color2(input);
          }
          this.init(input);
        }
        Color2.parse = function(input) {
          return input ? new Color2(input) : Color2.None;
        };
        Color2.prototype.init = function(input) {
          var result2, rgba, i2, parser;
          if (typeof input === "object" && typeof input.stops !== "undefined") {
            this.stops = input.stops.map(function(stop2) {
              return new Color2(stop2[1]);
            });
          } else if (typeof input === "string") {
            this.input = input = Color2.names[input.toLowerCase()] || input;
            if (input.charAt(0) === "#") {
              var len = input.length, col = parseInt(input.substr(1), 16);
              if (len === 7) {
                rgba = [
                  (col & 16711680) >> 16,
                  (col & 65280) >> 8,
                  col & 255,
                  1
                ];
              } else if (len === 4) {
                rgba = [
                  (col & 3840) >> 4 | (col & 3840) >> 8,
                  (col & 240) >> 4 | col & 240,
                  (col & 15) << 4 | col & 15,
                  1
                ];
              }
            }
            if (!rgba) {
              i2 = Color2.parsers.length;
              while (i2-- && !rgba) {
                parser = Color2.parsers[i2];
                result2 = parser.regex.exec(input);
                if (result2) {
                  rgba = parser.parse(result2);
                }
              }
            }
          }
          if (rgba) {
            this.rgba = rgba;
          }
        };
        Color2.prototype.get = function(format2) {
          var input = this.input, rgba = this.rgba;
          if (typeof input === "object" && typeof this.stops !== "undefined") {
            var ret_1 = merge$1o(input);
            ret_1.stops = [].slice.call(ret_1.stops);
            this.stops.forEach(function(stop2, i2) {
              ret_1.stops[i2] = [
                ret_1.stops[i2][0],
                stop2.get(format2)
              ];
            });
            return ret_1;
          }
          if (rgba && isNumber$Q(rgba[0])) {
            if (format2 === "rgb" || !format2 && rgba[3] === 1) {
              return "rgb(" + rgba[0] + "," + rgba[1] + "," + rgba[2] + ")";
            }
            if (format2 === "a") {
              return "" + rgba[3];
            }
            return "rgba(" + rgba.join(",") + ")";
          }
          return input;
        };
        Color2.prototype.brighten = function(alpha) {
          var rgba = this.rgba;
          if (this.stops) {
            this.stops.forEach(function(stop2) {
              stop2.brighten(alpha);
            });
          } else if (isNumber$Q(alpha) && alpha !== 0) {
            for (var i2 = 0; i2 < 3; i2++) {
              rgba[i2] += pInt$9(alpha * 255);
              if (rgba[i2] < 0) {
                rgba[i2] = 0;
              }
              if (rgba[i2] > 255) {
                rgba[i2] = 255;
              }
            }
          }
          return this;
        };
        Color2.prototype.setOpacity = function(alpha) {
          this.rgba[3] = alpha;
          return this;
        };
        Color2.prototype.tweenTo = function(to, pos) {
          var fromRgba = this.rgba, toRgba = to.rgba;
          if (!isNumber$Q(fromRgba[0]) || !isNumber$Q(toRgba[0])) {
            return to.input || "none";
          }
          var hasAlpha = toRgba[3] !== 1 || fromRgba[3] !== 1;
          return (hasAlpha ? "rgba(" : "rgb(") + Math.round(toRgba[0] + (fromRgba[0] - toRgba[0]) * (1 - pos)) + "," + Math.round(toRgba[1] + (fromRgba[1] - toRgba[1]) * (1 - pos)) + "," + Math.round(toRgba[2] + (fromRgba[2] - toRgba[2]) * (1 - pos)) + (hasAlpha ? "," + (toRgba[3] + (fromRgba[3] - toRgba[3]) * (1 - pos)) : "") + ")";
        };
        Color2.names = {
          white: "#ffffff",
          black: "#000000"
        };
        Color2.parsers = [{
          // RGBA color
          // eslint-disable-next-line max-len
          regex: /rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,
          parse: function(result2) {
            return [
              pInt$9(result2[1]),
              pInt$9(result2[2]),
              pInt$9(result2[3]),
              parseFloat(result2[4], 10)
            ];
          }
        }, {
          // RGB color
          regex: /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,
          parse: function(result2) {
            return [pInt$9(result2[1]), pInt$9(result2[2]), pInt$9(result2[3]), 1];
          }
        }];
        Color2.None = new Color2("");
        return Color2;
      }()
    );
    var win$f = H.win;
    var defined$V = Utilities.defined, error$9 = Utilities.error, extend$1t = Utilities.extend, isObject$e = Utilities.isObject, merge$1n = Utilities.merge, objectEach$A = Utilities.objectEach, pad$1 = Utilities.pad, pick$1A = Utilities.pick, splat$i = Utilities.splat, timeUnits$2 = Utilities.timeUnits;
    var hasNewSafariBug = H.isSafari && win$f.Intl && win$f.Intl.DateTimeFormat.prototype.formatRange;
    var hasOldSafariBug = H.isSafari && win$f.Intl && !win$f.Intl.DateTimeFormat.prototype.formatRange;
    var Time = (
      /** @class */
      function() {
        function Time2(options) {
          this.options = {};
          this.useUTC = false;
          this.variableTimezone = false;
          this.Date = win$f.Date;
          this.getTimezoneOffset = this.timezoneOffsetFunction();
          this.update(options);
        }
        Time2.prototype.get = function(unit, date) {
          if (this.variableTimezone || this.timezoneOffset) {
            var realMs = date.getTime();
            var ms = realMs - this.getTimezoneOffset(date);
            date.setTime(ms);
            var ret = date["getUTC" + unit]();
            date.setTime(realMs);
            return ret;
          }
          if (this.useUTC) {
            return date["getUTC" + unit]();
          }
          return date["get" + unit]();
        };
        Time2.prototype.set = function(unit, date, value) {
          if (this.variableTimezone || this.timezoneOffset) {
            if (unit === "Milliseconds" || unit === "Seconds" || unit === "Minutes" && this.getTimezoneOffset(date) % 36e5 === 0) {
              return date["setUTC" + unit](value);
            }
            var offset2 = this.getTimezoneOffset(date);
            var ms = date.getTime() - offset2;
            date.setTime(ms);
            date["setUTC" + unit](value);
            var newOffset = this.getTimezoneOffset(date);
            ms = date.getTime() + newOffset;
            return date.setTime(ms);
          }
          if (this.useUTC || hasNewSafariBug && unit === "FullYear") {
            return date["setUTC" + unit](value);
          }
          return date["set" + unit](value);
        };
        Time2.prototype.update = function(options) {
          var useUTC = pick$1A(options && options.useUTC, true);
          this.options = options = merge$1n(true, this.options || {}, options);
          this.Date = options.Date || win$f.Date || Date;
          this.useUTC = useUTC;
          this.timezoneOffset = useUTC && options.timezoneOffset;
          this.getTimezoneOffset = this.timezoneOffsetFunction();
          this.variableTimezone = useUTC && !!(options.getTimezoneOffset || options.timezone);
        };
        Time2.prototype.makeTime = function(year, month, date, hours, minutes, seconds) {
          var d2, offset2, newOffset;
          if (this.useUTC) {
            d2 = this.Date.UTC.apply(0, arguments);
            offset2 = this.getTimezoneOffset(d2);
            d2 += offset2;
            newOffset = this.getTimezoneOffset(d2);
            if (offset2 !== newOffset) {
              d2 += newOffset - offset2;
            } else if (offset2 - 36e5 === this.getTimezoneOffset(d2 - 36e5) && !hasOldSafariBug) {
              d2 -= 36e5;
            }
          } else {
            d2 = new this.Date(year, month, pick$1A(date, 1), pick$1A(hours, 0), pick$1A(minutes, 0), pick$1A(seconds, 0)).getTime();
          }
          return d2;
        };
        Time2.prototype.timezoneOffsetFunction = function() {
          var time = this, options = this.options, moment = options.moment || win$f.moment;
          if (!this.useUTC) {
            return function(timestamp) {
              return new Date(timestamp.toString()).getTimezoneOffset() * 6e4;
            };
          }
          if (options.timezone) {
            if (!moment) {
              error$9(25);
            } else {
              return function(timestamp) {
                return -moment.tz(timestamp, options.timezone).utcOffset() * 6e4;
              };
            }
          }
          if (this.useUTC && options.getTimezoneOffset) {
            return function(timestamp) {
              return options.getTimezoneOffset(timestamp.valueOf()) * 6e4;
            };
          }
          return function() {
            return (time.timezoneOffset || 0) * 6e4;
          };
        };
        Time2.prototype.dateFormat = function(format2, timestamp, capitalize2) {
          if (!defined$V(timestamp) || isNaN(timestamp)) {
            return H.defaultOptions.lang && H.defaultOptions.lang.invalidDate || "";
          }
          format2 = pick$1A(format2, "%Y-%m-%d %H:%M:%S");
          var time = this, date = new this.Date(timestamp), hours = this.get("Hours", date), day = this.get("Day", date), dayOfMonth = this.get("Date", date), month = this.get("Month", date), fullYear = this.get("FullYear", date), lang2 = H.defaultOptions.lang, langWeekdays = lang2 && lang2.weekdays, shortWeekdays = lang2 && lang2.shortWeekdays, replacements = extend$1t({
            // Day
            // Short weekday, like 'Mon'
            a: shortWeekdays ? shortWeekdays[day] : langWeekdays[day].substr(0, 3),
            // Long weekday, like 'Monday'
            A: langWeekdays[day],
            // Two digit day of the month, 01 to 31
            d: pad$1(dayOfMonth),
            // Day of the month, 1 through 31
            e: pad$1(dayOfMonth, 2, " "),
            // Day of the week, 0 through 6
            w: day,
            // Week (none implemented)
            // 'W': weekNumber(),
            // Month
            // Short month, like 'Jan'
            b: lang2.shortMonths[month],
            // Long month, like 'January'
            B: lang2.months[month],
            // Two digit month number, 01 through 12
            m: pad$1(month + 1),
            // Month number, 1 through 12 (#8150)
            o: month + 1,
            // Year
            // Two digits year, like 09 for 2009
            y: fullYear.toString().substr(2, 2),
            // Four digits year, like 2009
            Y: fullYear,
            // Time
            // Two digits hours in 24h format, 00 through 23
            H: pad$1(hours),
            // Hours in 24h format, 0 through 23
            k: hours,
            // Two digits hours in 12h format, 00 through 11
            I: pad$1(hours % 12 || 12),
            // Hours in 12h format, 1 through 12
            l: hours % 12 || 12,
            // Two digits minutes, 00 through 59
            M: pad$1(this.get("Minutes", date)),
            // Upper case AM or PM
            p: hours < 12 ? "AM" : "PM",
            // Lower case AM or PM
            P: hours < 12 ? "am" : "pm",
            // Two digits seconds, 00 through  59
            S: pad$1(date.getSeconds()),
            // Milliseconds (naming from Ruby)
            L: pad$1(Math.floor(timestamp % 1e3), 3)
          }, H.dateFormats);
          objectEach$A(replacements, function(val, key) {
            while (format2.indexOf("%" + key) !== -1) {
              format2 = format2.replace("%" + key, typeof val === "function" ? val.call(time, timestamp) : val);
            }
          });
          return capitalize2 ? format2.substr(0, 1).toUpperCase() + format2.substr(1) : format2;
        };
        Time2.prototype.resolveDTLFormat = function(f2) {
          if (!isObject$e(f2, true)) {
            f2 = splat$i(f2);
            return {
              main: f2[0],
              from: f2[1],
              to: f2[2]
            };
          }
          return f2;
        };
        Time2.prototype.getTimeTicks = function(normalizedInterval, min, max, startOfWeek) {
          var time = this, Date2 = time.Date, tickPositions = [], higherRanks = {}, minDate = new Date2(min), interval = normalizedInterval.unitRange, count = normalizedInterval.count || 1;
          var i2, minYear, variableDayLength, minDay;
          startOfWeek = pick$1A(startOfWeek, 1);
          if (defined$V(min)) {
            time.set("Milliseconds", minDate, interval >= timeUnits$2.second ? 0 : (
              // #3935
              count * Math.floor(time.get("Milliseconds", minDate) / count)
            ));
            if (interval >= timeUnits$2.second) {
              time.set("Seconds", minDate, interval >= timeUnits$2.minute ? 0 : (
                // #3935
                count * Math.floor(time.get("Seconds", minDate) / count)
              ));
            }
            if (interval >= timeUnits$2.minute) {
              time.set("Minutes", minDate, interval >= timeUnits$2.hour ? 0 : count * Math.floor(time.get("Minutes", minDate) / count));
            }
            if (interval >= timeUnits$2.hour) {
              time.set("Hours", minDate, interval >= timeUnits$2.day ? 0 : count * Math.floor(time.get("Hours", minDate) / count));
            }
            if (interval >= timeUnits$2.day) {
              time.set("Date", minDate, interval >= timeUnits$2.month ? 1 : Math.max(1, count * Math.floor(time.get("Date", minDate) / count)));
            }
            if (interval >= timeUnits$2.month) {
              time.set("Month", minDate, interval >= timeUnits$2.year ? 0 : count * Math.floor(time.get("Month", minDate) / count));
              minYear = time.get("FullYear", minDate);
            }
            if (interval >= timeUnits$2.year) {
              minYear -= minYear % count;
              time.set("FullYear", minDate, minYear);
            }
            if (interval === timeUnits$2.week) {
              minDay = time.get("Day", minDate);
              time.set("Date", minDate, time.get("Date", minDate) - minDay + startOfWeek + // We don't want to skip days that are before
              // startOfWeek (#7051)
              (minDay < startOfWeek ? -7 : 0));
            }
            minYear = time.get("FullYear", minDate);
            var minMonth = time.get("Month", minDate), minDateDate = time.get("Date", minDate), minHours = time.get("Hours", minDate);
            min = minDate.getTime();
            if ((time.variableTimezone || !time.useUTC) && defined$V(max)) {
              variableDayLength = // Long range, assume we're crossing over.
              max - min > 4 * timeUnits$2.month || // Short range, check if min and max are in different time
              // zones.
              time.getTimezoneOffset(min) !== time.getTimezoneOffset(max);
            }
            var t2 = minDate.getTime();
            i2 = 1;
            while (t2 < max) {
              tickPositions.push(t2);
              if (interval === timeUnits$2.year) {
                t2 = time.makeTime(minYear + i2 * count, 0);
              } else if (interval === timeUnits$2.month) {
                t2 = time.makeTime(minYear, minMonth + i2 * count);
              } else if (variableDayLength && (interval === timeUnits$2.day || interval === timeUnits$2.week)) {
                t2 = time.makeTime(minYear, minMonth, minDateDate + i2 * count * (interval === timeUnits$2.day ? 1 : 7));
              } else if (variableDayLength && interval === timeUnits$2.hour && count > 1) {
                t2 = time.makeTime(minYear, minMonth, minDateDate, minHours + i2 * count);
              } else {
                t2 += interval * count;
              }
              i2++;
            }
            tickPositions.push(t2);
            if (interval <= timeUnits$2.hour && tickPositions.length < 1e4) {
              tickPositions.forEach(function(t3) {
                if (
                  // Speed optimization, no need to run dateFormat unless
                  // we're on a full or half hour
                  t3 % 18e5 === 0 && // Check for local or global midnight
                  time.dateFormat("%H%M%S%L", t3) === "000000000"
                ) {
                  higherRanks[t3] = "day";
                }
              });
            }
          }
          tickPositions.info = extend$1t(normalizedInterval, {
            higherRanks,
            totalRange: interval * count
          });
          return tickPositions;
        };
        Time2.prototype.getDateFormat = function(range, timestamp, startOfWeek, dateTimeLabelFormats) {
          var dateStr = this.dateFormat("%m-%d %H:%M:%S.%L", timestamp), blank = "01-01 00:00:00.000", strpos = {
            millisecond: 15,
            second: 12,
            minute: 9,
            hour: 6,
            day: 3
          };
          var format2, n2, lastN = "millisecond";
          for (n2 in timeUnits$2) {
            if (range === timeUnits$2.week && +this.dateFormat("%w", timestamp) === startOfWeek && dateStr.substr(6) === blank.substr(6)) {
              n2 = "week";
              break;
            }
            if (timeUnits$2[n2] > range) {
              n2 = lastN;
              break;
            }
            if (strpos[n2] && dateStr.substr(strpos[n2]) !== blank.substr(strpos[n2])) {
              break;
            }
            if (n2 !== "week") {
              lastN = n2;
            }
          }
          if (n2) {
            format2 = this.resolveDTLFormat(dateTimeLabelFormats[n2]).main;
          }
          return format2;
        };
        return Time2;
      }()
    );
    var color$g = Color.parse;
    var isTouchDevice$4 = H.isTouchDevice, svg$5 = H.svg;
    var merge$1m = Utilities.merge;
    var defaultOptions$g = {
      /**
       * An array containing the default colors for the chart's series. When
       * all colors are used, new colors are pulled from the start again.
       *
       * Default colors can also be set on a series or series.type basis,
       * see [column.colors](#plotOptions.column.colors),
       * [pie.colors](#plotOptions.pie.colors).
       *
       * In styled mode, the colors option doesn't exist. Instead, colors
       * are defined in CSS and applied either through series or point class
       * names, or through the [chart.colorCount](#chart.colorCount) option.
       *
       *
       * ### Legacy
       *
       * In Highcharts 3.x, the default colors were:
       * ```js
       * colors: ['#2f7ed8', '#0d233a', '#8bbc21', '#910000', '#1aadce',
       *         '#492970', '#f28f43', '#77a1e5', '#c42525', '#a6c96a']
       * ```
       *
       * In Highcharts 2.x, the default colors were:
       * ```js
       * colors: ['#4572A7', '#AA4643', '#89A54E', '#80699B', '#3D96AE',
       *         '#DB843D', '#92A8CD', '#A47D7C', '#B5CA92']
       * ```
       *
       * @sample {highcharts} highcharts/chart/colors/
       *         Assign a global color theme
       *
       * @type    {Array<Highcharts.ColorString>}
       * @default ["#7cb5ec", "#434348", "#90ed7d", "#f7a35c", "#8085e9",
       *          "#f15c80", "#e4d354", "#2b908f", "#f45b5b", "#91e8e1"]
       */
      colors: palette.colors,
      /**
       * Styled mode only. Configuration object for adding SVG definitions for
       * reusable elements. See [gradients, shadows and
       * patterns](https://www.highcharts.com/docs/chart-design-and-style/gradients-shadows-and-patterns)
       * for more information and code examples.
       *
       * @type      {*}
       * @since     5.0.0
       * @apioption defs
       */
      /**
       * @ignore-option
       */
      symbols: ["circle", "diamond", "square", "triangle", "triangle-down"],
      /**
       * The language object is global and it can't be set on each chart
       * initialization. Instead, use `Highcharts.setOptions` to set it before any
       * chart is initialized.
       *
       * ```js
       * Highcharts.setOptions({
       *     lang: {
       *         months: [
       *             'Janvier', 'Février', 'Mars', 'Avril',
       *             'Mai', 'Juin', 'Juillet', 'Août',
       *             'Septembre', 'Octobre', 'Novembre', 'Décembre'
       *         ],
       *         weekdays: [
       *             'Dimanche', 'Lundi', 'Mardi', 'Mercredi',
       *             'Jeudi', 'Vendredi', 'Samedi'
       *         ]
       *     }
       * });
       * ```
       */
      lang: {
        /**
         * The loading text that appears when the chart is set into the loading
         * state following a call to `chart.showLoading`.
         */
        loading: "Loading...",
        /**
         * An array containing the months names. Corresponds to the `%B` format
         * in `Highcharts.dateFormat()`.
         *
         * @type    {Array<string>}
         * @default ["January", "February", "March", "April", "May", "June",
         *          "July", "August", "September", "October", "November",
         *          "December"]
         */
        months: [
          "January",
          "February",
          "March",
          "April",
          "May",
          "June",
          "July",
          "August",
          "September",
          "October",
          "November",
          "December"
        ],
        /**
         * An array containing the months names in abbreviated form. Corresponds
         * to the `%b` format in `Highcharts.dateFormat()`.
         *
         * @type    {Array<string>}
         * @default ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
         *          "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
         */
        shortMonths: [
          "Jan",
          "Feb",
          "Mar",
          "Apr",
          "May",
          "Jun",
          "Jul",
          "Aug",
          "Sep",
          "Oct",
          "Nov",
          "Dec"
        ],
        /**
         * An array containing the weekday names.
         *
         * @type    {Array<string>}
         * @default ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
         *          "Friday", "Saturday"]
         */
        weekdays: [
          "Sunday",
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday",
          "Saturday"
        ],
        /**
         * Short week days, starting Sunday. If not specified, Highcharts uses
         * the first three letters of the `lang.weekdays` option.
         *
         * @sample highcharts/lang/shortweekdays/
         *         Finnish two-letter abbreviations
         *
         * @type      {Array<string>}
         * @since     4.2.4
         * @apioption lang.shortWeekdays
         */
        /**
         * What to show in a date field for invalid dates. Defaults to an empty
         * string.
         *
         * @type      {string}
         * @since     4.1.8
         * @product   highcharts highstock
         * @apioption lang.invalidDate
         */
        /**
         * The title appearing on hovering the zoom in button. The text itself
         * defaults to "+" and can be changed in the button options.
         *
         * @type      {string}
         * @default   Zoom in
         * @product   highmaps
         * @apioption lang.zoomIn
         */
        /**
         * The title appearing on hovering the zoom out button. The text itself
         * defaults to "-" and can be changed in the button options.
         *
         * @type      {string}
         * @default   Zoom out
         * @product   highmaps
         * @apioption lang.zoomOut
         */
        /**
         * The default decimal point used in the `Highcharts.numberFormat`
         * method unless otherwise specified in the function arguments.
         *
         * @since 1.2.2
         */
        decimalPoint: ".",
        /**
         * [Metric prefixes](https://en.wikipedia.org/wiki/Metric_prefix) used
         * to shorten high numbers in axis labels. Replacing any of the
         * positions with `null` causes the full number to be written. Setting
         * `numericSymbols` to `null` disables shortening altogether.
         *
         * @sample {highcharts} highcharts/lang/numericsymbols/
         *         Replacing the symbols with text
         * @sample {highstock} highcharts/lang/numericsymbols/
         *         Replacing the symbols with text
         *
         * @type    {Array<string>}
         * @default ["k", "M", "G", "T", "P", "E"]
         * @since   2.3.0
         */
        numericSymbols: ["k", "M", "G", "T", "P", "E"],
        /**
         * The magnitude of [numericSymbols](#lang.numericSymbol) replacements.
         * Use 10000 for Japanese, Korean and various Chinese locales, which
         * use symbols for 10^4, 10^8 and 10^12.
         *
         * @sample highcharts/lang/numericsymbolmagnitude/
         *         10000 magnitude for Japanese
         *
         * @type      {number}
         * @default   1000
         * @since     5.0.3
         * @apioption lang.numericSymbolMagnitude
         */
        /**
         * The text for the label appearing when a chart is zoomed.
         *
         * @since 1.2.4
         */
        resetZoom: "Reset zoom",
        /**
         * The tooltip title for the label appearing when a chart is zoomed.
         *
         * @since 1.2.4
         */
        resetZoomTitle: "Reset zoom level 1:1",
        /**
         * The default thousands separator used in the `Highcharts.numberFormat`
         * method unless otherwise specified in the function arguments. Defaults
         * to a single space character, which is recommended in
         * [ISO 31-0](https://en.wikipedia.org/wiki/ISO_31-0#Numbers) and works
         * across Anglo-American and continental European languages.
         *
         * @default \u0020
         * @since   1.2.2
         */
        thousandsSep: " "
      },
      /**
       * Global options that don't apply to each chart. These options, like
       * the `lang` options, must be set using the `Highcharts.setOptions`
       * method.
       *
       * ```js
       * Highcharts.setOptions({
       *     global: {
       *         useUTC: false
       *     }
       * });
       * ```
       */
      /**
       * _Canvg rendering for Android 2.x is removed as of Highcharts 5.0\.
       * Use the [libURL](#exporting.libURL) option to configure exporting._
       *
       * The URL to the additional file to lazy load for Android 2.x devices.
       * These devices don't support SVG, so we download a helper file that
       * contains [canvg](https://github.com/canvg/canvg), its dependency
       * rbcolor, and our own CanVG Renderer class. To avoid hotlinking to
       * our site, you can install canvas-tools.js on your own server and
       * change this option accordingly.
       *
       * @deprecated
       *
       * @type      {string}
       * @default   https://code.highcharts.com/{version}/modules/canvas-tools.js
       * @product   highcharts highmaps
       * @apioption global.canvasToolsURL
       */
      /**
       * This option is deprecated since v6.0.5. Instead, use
       * [time.useUTC](#time.useUTC) that supports individual time settings
       * per chart.
       *
       * @deprecated
       *
       * @type      {boolean}
       * @apioption global.useUTC
       */
      /**
       * This option is deprecated since v6.0.5. Instead, use
       * [time.Date](#time.Date) that supports individual time settings
       * per chart.
       *
       * @deprecated
       *
       * @type      {Function}
       * @product   highcharts highstock
       * @apioption global.Date
       */
      /**
       * This option is deprecated since v6.0.5. Instead, use
       * [time.getTimezoneOffset](#time.getTimezoneOffset) that supports
       * individual time settings per chart.
       *
       * @deprecated
       *
       * @type      {Function}
       * @product   highcharts highstock
       * @apioption global.getTimezoneOffset
       */
      /**
       * This option is deprecated since v6.0.5. Instead, use
       * [time.timezone](#time.timezone) that supports individual time
       * settings per chart.
       *
       * @deprecated
       *
       * @type      {string}
       * @product   highcharts highstock
       * @apioption global.timezone
       */
      /**
       * This option is deprecated since v6.0.5. Instead, use
       * [time.timezoneOffset](#time.timezoneOffset) that supports individual
       * time settings per chart.
       *
       * @deprecated
       *
       * @type      {number}
       * @product   highcharts highstock
       * @apioption global.timezoneOffset
       */
      global: {},
      /**
       * Time options that can apply globally or to individual charts. These
       * settings affect how `datetime` axes are laid out, how tooltips are
       * formatted, how series
       * [pointIntervalUnit](#plotOptions.series.pointIntervalUnit) works and how
       * the Highcharts Stock range selector handles time.
       *
       * The common use case is that all charts in the same Highcharts object
       * share the same time settings, in which case the global settings are set
       * using `setOptions`.
       *
       * ```js
       * // Apply time settings globally
       * Highcharts.setOptions({
       *     time: {
       *         timezone: 'Europe/London'
       *     }
       * });
       * // Apply time settings by instance
       * let chart = Highcharts.chart('container', {
       *     time: {
       *         timezone: 'America/New_York'
       *     },
       *     series: [{
       *         data: [1, 4, 3, 5]
       *     }]
       * });
       *
       * // Use the Time object
       * console.log(
       *        'Current time in New York',
       *        chart.time.dateFormat('%Y-%m-%d %H:%M:%S', Date.now())
       * );
       * ```
       *
       * Since v6.0.5, the time options were moved from the `global` obect to the
       * `time` object, and time options can be set on each individual chart.
       *
       * @sample {highcharts|highstock}
       *         highcharts/time/timezone/
       *         Set the timezone globally
       * @sample {highcharts}
       *         highcharts/time/individual/
       *         Set the timezone per chart instance
       * @sample {highstock}
       *         stock/time/individual/
       *         Set the timezone per chart instance
       *
       * @since     6.0.5
       * @optionparent time
       */
      time: {
        /**
         * A custom `Date` class for advanced date handling. For example,
         * [JDate](https://github.com/tahajahangir/jdate) can be hooked in to
         * handle Jalali dates.
         *
         * @type      {*}
         * @since     4.0.4
         * @product   highcharts highstock gantt
         */
        Date: void 0,
        /**
         * A callback to return the time zone offset for a given datetime. It
         * takes the timestamp in terms of milliseconds since January 1 1970,
         * and returns the timezone offset in minutes. This provides a hook
         * for drawing time based charts in specific time zones using their
         * local DST crossover dates, with the help of external libraries.
         *
         * @see [global.timezoneOffset](#global.timezoneOffset)
         *
         * @sample {highcharts|highstock} highcharts/time/gettimezoneoffset/
         *         Use moment.js to draw Oslo time regardless of browser locale
         *
         * @type      {Highcharts.TimezoneOffsetCallbackFunction}
         * @since     4.1.0
         * @product   highcharts highstock gantt
         */
        getTimezoneOffset: void 0,
        /**
         * Requires [moment.js](https://momentjs.com/). If the timezone option
         * is specified, it creates a default
         * [getTimezoneOffset](#time.getTimezoneOffset) function that looks
         * up the specified timezone in moment.js. If moment.js is not included,
         * this throws a Highcharts error in the console, but does not crash the
         * chart.
         *
         * @see [getTimezoneOffset](#time.getTimezoneOffset)
         *
         * @sample {highcharts|highstock} highcharts/time/timezone/
         *         Europe/Oslo
         *
         * @type      {string}
         * @since     5.0.7
         * @product   highcharts highstock gantt
         */
        timezone: void 0,
        /**
         * The timezone offset in minutes. Positive values are west, negative
         * values are east of UTC, as in the ECMAScript
         * [getTimezoneOffset](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTimezoneOffset)
         * method. Use this to display UTC based data in a predefined time zone.
         *
         * @see [time.getTimezoneOffset](#time.getTimezoneOffset)
         *
         * @sample {highcharts|highstock} highcharts/time/timezoneoffset/
         *         Timezone offset
         *
         * @since     3.0.8
         * @product   highcharts highstock gantt
         */
        timezoneOffset: 0,
        /**
         * Whether to use UTC time for axis scaling, tickmark placement and
         * time display in `Highcharts.dateFormat`. Advantages of using UTC
         * is that the time displays equally regardless of the user agent's
         * time zone settings. Local time can be used when the data is loaded
         * in real time or when correct Daylight Saving Time transitions are
         * required.
         *
         * @sample {highcharts} highcharts/time/useutc-true/
         *         True by default
         * @sample {highcharts} highcharts/time/useutc-false/
         *         False
         */
        useUTC: true
      },
      chart: ChartDefaults,
      /**
       * The chart's main title.
       *
       * @sample {highmaps} maps/title/title/
       *         Title options demonstrated
       */
      title: {
        /**
         * When the title is floating, the plot area will not move to make space
         * for it.
         *
         * @sample {highcharts} highcharts/chart/zoomtype-none/
         *         False by default
         * @sample {highcharts} highcharts/title/floating/
         *         True - title on top of the plot area
         * @sample {highstock} stock/chart/title-floating/
         *         True - title on top of the plot area
         *
         * @type      {boolean}
         * @default   false
         * @since     2.1
         * @apioption title.floating
         */
        /**
         * CSS styles for the title. Use this for font styling, but use `align`,
         * `x` and `y` for text alignment.
         *
         * In styled mode, the title style is given in the `.highcharts-title`
         * class.
         *
         * @sample {highcharts} highcharts/title/style/
         *         Custom color and weight
         * @sample {highstock} stock/chart/title-style/
         *         Custom color and weight
         * @sample highcharts/css/titles/
         *         Styled mode
         *
         * @type      {Highcharts.CSSObject}
         * @default   {highcharts|highmaps} { "color": "#333333", "fontSize": "18px" }
         * @default   {highstock} { "color": "#333333", "fontSize": "16px" }
         * @apioption title.style
         */
        /**
         * Whether to
         * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
         * to render the text.
         *
         * @type      {boolean}
         * @default   false
         * @apioption title.useHTML
         */
        /**
         * The vertical alignment of the title. Can be one of `"top"`,
         * `"middle"` and `"bottom"`. When a value is given, the title behaves
         * as if [floating](#title.floating) were `true`.
         *
         * @sample {highcharts} highcharts/title/verticalalign/
         *         Chart title in bottom right corner
         * @sample {highstock} stock/chart/title-verticalalign/
         *         Chart title in bottom right corner
         *
         * @type      {Highcharts.VerticalAlignValue}
         * @since     2.1
         * @apioption title.verticalAlign
         */
        /**
         * The x position of the title relative to the alignment within
         * `chart.spacingLeft` and `chart.spacingRight`.
         *
         * @sample {highcharts} highcharts/title/align/
         *         Aligned to the plot area (x = 70px = margin left - spacing
         *         left)
         * @sample {highstock} stock/chart/title-align/
         *         Aligned to the plot area (x = 50px = margin left - spacing
         *         left)
         *
         * @type      {number}
         * @default   0
         * @since     2.0
         * @apioption title.x
         */
        /**
         * The y position of the title relative to the alignment within
         * [chart.spacingTop](#chart.spacingTop) and [chart.spacingBottom](
         * #chart.spacingBottom). By default it depends on the font size.
         *
         * @sample {highcharts} highcharts/title/y/
         *         Title inside the plot area
         * @sample {highstock} stock/chart/title-verticalalign/
         *         Chart title in bottom right corner
         *
         * @type      {number}
         * @since     2.0
         * @apioption title.y
         */
        /**
         * The title of the chart. To disable the title, set the `text` to
         * `undefined`.
         *
         * @sample {highcharts} highcharts/title/text/
         *         Custom title
         * @sample {highstock} stock/chart/title-text/
         *         Custom title
         *
         * @default {highcharts|highmaps} Chart title
         * @default {highstock} undefined
         */
        text: "Chart title",
        /**
         * The horizontal alignment of the title. Can be one of "left", "center"
         * and "right".
         *
         * @sample {highcharts} highcharts/title/align/
         *         Aligned to the plot area (x = 70px = margin left - spacing
         *         left)
         * @sample {highstock} stock/chart/title-align/
         *         Aligned to the plot area (x = 50px = margin left - spacing
         *         left)
         *
         * @type  {Highcharts.AlignValue}
         * @since 2.0
         */
        align: "center",
        /**
         * The margin between the title and the plot area, or if a subtitle
         * is present, the margin between the subtitle and the plot area.
         *
         * @sample {highcharts} highcharts/title/margin-50/
         *         A chart title margin of 50
         * @sample {highcharts} highcharts/title/margin-subtitle/
         *         The same margin applied with a subtitle
         * @sample {highstock} stock/chart/title-margin/
         *         A chart title margin of 50
         *
         * @since 2.1
         */
        margin: 15,
        /**
         * Adjustment made to the title width, normally to reserve space for
         * the exporting burger menu.
         *
         * @sample highcharts/title/widthadjust/
         *         Wider menu, greater padding
         *
         * @since 4.2.5
         */
        widthAdjust: -44
      },
      /**
       * The chart's subtitle. This can be used both to display a subtitle below
       * the main title, and to display random text anywhere in the chart. The
       * subtitle can be updated after chart initialization through the
       * `Chart.setTitle` method.
       *
       * @sample {highmaps} maps/title/subtitle/
       *         Subtitle options demonstrated
       */
      subtitle: {
        /**
         * When the subtitle is floating, the plot area will not move to make
         * space for it.
         *
         * @sample {highcharts} highcharts/subtitle/floating/
         *         Floating title and subtitle
         * @sample {highstock} stock/chart/subtitle-footnote
         *         Footnote floating at bottom right of plot area
         *
         * @type      {boolean}
         * @default   false
         * @since     2.1
         * @apioption subtitle.floating
         */
        /**
         * CSS styles for the title.
         *
         * In styled mode, the subtitle style is given in the
         * `.highcharts-subtitle` class.
         *
         * @sample {highcharts} highcharts/subtitle/style/
         *         Custom color and weight
         * @sample {highcharts} highcharts/css/titles/
         *         Styled mode
         * @sample {highstock} stock/chart/subtitle-style
         *         Custom color and weight
         * @sample {highstock} highcharts/css/titles/
         *         Styled mode
         * @sample {highmaps} highcharts/css/titles/
         *         Styled mode
         *
         * @type      {Highcharts.CSSObject}
         * @default   {"color": "#666666"}
         * @apioption subtitle.style
         */
        /**
         * Whether to
         * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
         * to render the text.
         *
         * @type      {boolean}
         * @default   false
         * @apioption subtitle.useHTML
         */
        /**
         * The vertical alignment of the title. Can be one of `"top"`,
         * `"middle"` and `"bottom"`. When middle, the subtitle behaves as
         * floating.
         *
         * @sample {highcharts} highcharts/subtitle/verticalalign/
         *         Footnote at the bottom right of plot area
         * @sample {highstock} stock/chart/subtitle-footnote
         *         Footnote at the bottom right of plot area
         *
         * @type      {Highcharts.VerticalAlignValue}
         * @since     2.1
         * @apioption subtitle.verticalAlign
         */
        /**
         * The x position of the subtitle relative to the alignment within
         * `chart.spacingLeft` and `chart.spacingRight`.
         *
         * @sample {highcharts} highcharts/subtitle/align/
         *         Footnote at right of plot area
         * @sample {highstock} stock/chart/subtitle-footnote
         *         Footnote at the bottom right of plot area
         *
         * @type      {number}
         * @default   0
         * @since     2.0
         * @apioption subtitle.x
         */
        /**
         * The y position of the subtitle relative to the alignment within
         * `chart.spacingTop` and `chart.spacingBottom`. By default the subtitle
         * is laid out below the title unless the title is floating.
         *
         * @sample {highcharts} highcharts/subtitle/verticalalign/
         *         Footnote at the bottom right of plot area
         * @sample {highstock} stock/chart/subtitle-footnote
         *         Footnote at the bottom right of plot area
         *
         * @type      {number}
         * @since     2.0
         * @apioption subtitle.y
         */
        /**
         * The subtitle of the chart.
         *
         * @sample {highcharts|highstock} highcharts/subtitle/text/
         *         Custom subtitle
         * @sample {highcharts|highstock} highcharts/subtitle/text-formatted/
         *         Formatted and linked text.
         */
        text: "",
        /**
         * The horizontal alignment of the subtitle. Can be one of "left",
         *  "center" and "right".
         *
         * @sample {highcharts} highcharts/subtitle/align/
         *         Footnote at right of plot area
         * @sample {highstock} stock/chart/subtitle-footnote
         *         Footnote at bottom right of plot area
         *
         * @type  {Highcharts.AlignValue}
         * @since 2.0
         */
        align: "center",
        /**
         * Adjustment made to the subtitle width, normally to reserve space
         * for the exporting burger menu.
         *
         * @see [title.widthAdjust](#title.widthAdjust)
         *
         * @sample highcharts/title/widthadjust/
         *         Wider menu, greater padding
         *
         * @since 4.2.5
         */
        widthAdjust: -44
      },
      /**
       * The chart's caption, which will render below the chart and will be part
       * of exported charts. The caption can be updated after chart initialization
       * through the `Chart.update` or `Chart.caption.update` methods.
       *
       * @sample highcharts/caption/text/
       *         A chart with a caption
       * @since  7.2.0
       */
      caption: {
        /**
         * When the caption is floating, the plot area will not move to make
         * space for it.
         *
         * @type      {boolean}
         * @default   false
         * @apioption caption.floating
         */
        /**
         * The margin between the caption and the plot area.
         */
        margin: 15,
        /**
         * CSS styles for the caption.
         *
         * In styled mode, the caption style is given in the
         * `.highcharts-caption` class.
         *
         * @sample {highcharts} highcharts/css/titles/
         *         Styled mode
         *
         * @type      {Highcharts.CSSObject}
         * @default   {"color": "#666666"}
         * @apioption caption.style
         */
        /**
         * Whether to
         * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
         * to render the text.
         *
         * @type      {boolean}
         * @default   false
         * @apioption caption.useHTML
         */
        /**
         * The x position of the caption relative to the alignment within
         * `chart.spacingLeft` and `chart.spacingRight`.
         *
         * @type      {number}
         * @default   0
         * @apioption caption.x
         */
        /**
         * The y position of the caption relative to the alignment within
         * `chart.spacingTop` and `chart.spacingBottom`.
         *
         * @type      {number}
         * @apioption caption.y
         */
        /**
         * The caption text of the chart.
         *
         * @sample {highcharts} highcharts/caption/text/
         *         Custom caption
         */
        text: "",
        /**
         * The horizontal alignment of the caption. Can be one of "left",
         *  "center" and "right".
         *
         * @type  {Highcharts.AlignValue}
         */
        align: "left",
        /**
         * The vertical alignment of the caption. Can be one of `"top"`,
         * `"middle"` and `"bottom"`. When middle, the caption behaves as
         * floating.
         *
         * @type      {Highcharts.VerticalAlignValue}
         */
        verticalAlign: "bottom"
      },
      /**
       * The plotOptions is a wrapper object for config objects for each series
       * type. The config objects for each series can also be overridden for
       * each series item as given in the series array.
       *
       * Configuration options for the series are given in three levels. Options
       * for all series in a chart are given in the [plotOptions.series](
       * #plotOptions.series) object. Then options for all series of a specific
       * type are given in the plotOptions of that type, for example
       * `plotOptions.line`. Next, options for one single series are given in
       * [the series array](#series).
       */
      plotOptions: {},
      /**
       * HTML labels that can be positioned anywhere in the chart area.
       *
       * This option is deprecated since v7.1.2. Instead, use
       * [annotations](#annotations) that support labels.
       *
       * @deprecated
       * @product   highcharts highstock
       */
      labels: {
        /**
         * An HTML label that can be positioned anywhere in the chart area.
         *
         * @deprecated
         * @type      {Array<*>}
         * @apioption labels.items
         */
        /**
         * Inner HTML or text for the label.
         *
         * @deprecated
         * @type      {string}
         * @apioption labels.items.html
         */
        /**
         * CSS styles for each label. To position the label, use left and top
         * like this:
         * ```js
         * style: {
         *     left: '100px',
         *     top: '100px'
         * }
         * ```
         *
         * @deprecated
         * @type      {Highcharts.CSSObject}
         * @apioption labels.items.style
         */
        /**
         * Shared CSS styles for all labels.
         *
         * @deprecated
         * @type    {Highcharts.CSSObject}
         * @default {"color": "#333333", "position": "absolute"}
         */
        style: {
          /**
           * @ignore-option
           */
          position: "absolute",
          /**
           * @ignore-option
           */
          color: palette.neutralColor80
        }
      },
      /**
       * The legend is a box containing a symbol and name for each series
       * item or point item in the chart. Each series (or points in case
       * of pie charts) is represented by a symbol and its name in the legend.
       *
       * It is possible to override the symbol creator function and create
       * [custom legend symbols](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/studies/legend-custom-symbol/).
       *
       * @productdesc {highmaps}
       * A Highmaps legend by default contains one legend item per series, but if
       * a `colorAxis` is defined, the axis will be displayed in the legend.
       * Either as a gradient, or as multiple legend items for `dataClasses`.
       */
      legend: {
        /**
         * The background color of the legend.
         *
         * @see In styled mode, the legend background fill can be applied with
         *      the `.highcharts-legend-box` class.
         *
         * @sample {highcharts} highcharts/legend/backgroundcolor/
         *         Yellowish background
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/border-background/
         *         Border and background options
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @apioption legend.backgroundColor
         */
        /**
         * The width of the drawn border around the legend.
         *
         * @see In styled mode, the legend border stroke width can be applied
         *      with the `.highcharts-legend-box` class.
         *
         * @sample {highcharts} highcharts/legend/borderwidth/
         *         2px border width
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/border-background/
         *         Border and background options
         *
         * @type      {number}
         * @default   0
         * @apioption legend.borderWidth
         */
        /**
         * Enable or disable the legend. There is also a series-specific option,
         * [showInLegend](#plotOptions.series.showInLegend), that can hide the
         * series from the legend. In some series types this is `false` by
         * default, so it must set to `true` in order to show the legend for the
         * series.
         *
         * @sample {highcharts} highcharts/legend/enabled-false/ Legend disabled
         * @sample {highstock} stock/legend/align/ Various legend options
         * @sample {highmaps} maps/legend/enabled-false/ Legend disabled
         *
         * @default {highstock} false
         * @default {highmaps} true
         * @default {gantt} false
         */
        enabled: true,
        /**
         * The horizontal alignment of the legend box within the chart area.
         * Valid values are `left`, `center` and `right`.
         *
         * In the case that the legend is aligned in a corner position, the
         * `layout` option will determine whether to place it above/below
         * or on the side of the plot area.
         *
         * @sample {highcharts} highcharts/legend/align/
         *         Legend at the right of the chart
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/alignment/
         *         Legend alignment
         *
         * @type  {Highcharts.AlignValue}
         * @since 2.0
         */
        align: "center",
        /**
         * If the [layout](legend.layout) is `horizontal` and the legend items
         * span over two lines or more, whether to align the items into vertical
         * columns. Setting this to `false` makes room for more items, but will
         * look more messy.
         *
         * @since 6.1.0
         */
        alignColumns: true,
        /**
         * A CSS class name to apply to the legend group.
         */
        className: "highcharts-no-tooltip",
        /**
         * When the legend is floating, the plot area ignores it and is allowed
         * to be placed below it.
         *
         * @sample {highcharts} highcharts/legend/floating-false/
         *         False by default
         * @sample {highcharts} highcharts/legend/floating-true/
         *         True
         * @sample {highmaps} maps/legend/alignment/
         *         Floating legend
         *
         * @type      {boolean}
         * @default   false
         * @since     2.1
         * @apioption legend.floating
         */
        /**
         * The layout of the legend items. Can be one of `horizontal` or
         * `vertical` or `proximate`. When `proximate`, the legend items will be
         * placed as close as possible to the graphs they're representing,
         * except in inverted charts or when the legend position doesn't allow
         * it.
         *
         * @sample {highcharts} highcharts/legend/layout-horizontal/
         *         Horizontal by default
         * @sample {highcharts} highcharts/legend/layout-vertical/
         *         Vertical
         * @sample highcharts/legend/layout-proximate
         *         Labels proximate to the data
         * @sample {highstock} stock/legend/layout-horizontal/
         *         Horizontal by default
         * @sample {highmaps} maps/legend/padding-itemmargin/
         *         Vertical with data classes
         * @sample {highmaps} maps/legend/layout-vertical/
         *         Vertical with color axis gradient
         *
         * @validvalue ["horizontal", "vertical", "proximate"]
         */
        layout: "horizontal",
        /**
         * In a legend with horizontal layout, the itemDistance defines the
         * pixel distance between each item.
         *
         * @sample {highcharts} highcharts/legend/layout-horizontal/
         *         50px item distance
         * @sample {highstock} highcharts/legend/layout-horizontal/
         *         50px item distance
         *
         * @type      {number}
         * @default   {highcharts} 20
         * @default   {highstock} 20
         * @default   {highmaps} 8
         * @since     3.0.3
         * @apioption legend.itemDistance
         */
        /**
         * The pixel bottom margin for each legend item.
         *
         * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         * @sample {highmaps} maps/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         *
         * @type      {number}
         * @default   0
         * @since     2.2.0
         * @apioption legend.itemMarginBottom
         */
        /**
         * The pixel top margin for each legend item.
         *
         * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         * @sample {highmaps} maps/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         *
         * @type      {number}
         * @default   0
         * @since     2.2.0
         * @apioption legend.itemMarginTop
         */
        /**
         * The width for each legend item. By default the items are laid out
         * successively. In a [horizontal layout](legend.layout), if the items
         * are laid out across two rows or more, they will be vertically aligned
         * depending on the [legend.alignColumns](legend.alignColumns) option.
         *
         * @sample {highcharts} highcharts/legend/itemwidth-default/
         *         Undefined by default
         * @sample {highcharts} highcharts/legend/itemwidth-80/
         *         80 for aligned legend items
         *
         * @type      {number}
         * @since     2.0
         * @apioption legend.itemWidth
         */
        /**
         * A [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
         * for each legend label. Available variables relates to properties on
         * the series, or the point in case of pies.
         *
         * @type      {string}
         * @default   {name}
         * @since     1.3
         * @apioption legend.labelFormat
         */
        /* eslint-disable valid-jsdoc */
        /**
         * Callback function to format each of the series' labels. The `this`
         * keyword refers to the series object, or the point object in case of
         * pie charts. By default the series or point name is printed.
         *
         * @productdesc {highmaps}
         * In Highmaps the context can also be a data class in case of a
         * `colorAxis`.
         *
         * @sample {highcharts} highcharts/legend/labelformatter/
         *         Add text
         * @sample {highmaps} maps/legend/labelformatter/
         *         Data classes with label formatter
         *
         * @type {Highcharts.FormatterCallbackFunction<Point|Series>}
         */
        labelFormatter: function() {
          return this.name;
        },
        /**
         * Line height for the legend items. Deprecated as of 2.1\. Instead,
         * the line height for each item can be set using
         * `itemStyle.lineHeight`, and the padding between items using
         * `itemMarginTop` and `itemMarginBottom`.
         *
         * @sample {highcharts} highcharts/legend/lineheight/
         *         Setting padding
         *
         * @deprecated
         *
         * @type      {number}
         * @default   16
         * @since     2.0
         * @product   highcharts gantt
         * @apioption legend.lineHeight
         */
        /**
         * If the plot area sized is calculated automatically and the legend is
         * not floating, the legend margin is the space between the legend and
         * the axis labels or plot area.
         *
         * @sample {highcharts} highcharts/legend/margin-default/
         *         12 pixels by default
         * @sample {highcharts} highcharts/legend/margin-30/
         *         30 pixels
         *
         * @type      {number}
         * @default   12
         * @since     2.1
         * @apioption legend.margin
         */
        /**
         * Maximum pixel height for the legend. When the maximum height is
         * extended, navigation will show.
         *
         * @type      {number}
         * @since     2.3.0
         * @apioption legend.maxHeight
         */
        /**
         * The color of the drawn border around the legend.
         *
         * @see In styled mode, the legend border stroke can be applied with the
         *      `.highcharts-legend-box` class.
         *
         * @sample {highcharts} highcharts/legend/bordercolor/
         *         Brown border
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/border-background/
         *         Border and background options
         *
         * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         */
        borderColor: palette.neutralColor40,
        /**
         * The border corner radius of the legend.
         *
         * @sample {highcharts} highcharts/legend/borderradius-default/
         *         Square by default
         * @sample {highcharts} highcharts/legend/borderradius-round/
         *         5px rounded
         * @sample {highmaps} maps/legend/border-background/
         *         Border and background options
         */
        borderRadius: 0,
        /**
         * Options for the paging or navigation appearing when the legend is
         * overflown. Navigation works well on screen, but not in static
         * exported images. One way of working around that is to
         * [increase the chart height in
         * export](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/legend/navigation-enabled-false/).
         */
        navigation: {
          /**
           * How to animate the pages when navigating up or down. A value of
           * `true` applies the default navigation given in the
           * `chart.animation` option. Additional options can be given as an
           * object containing values for easing and duration.
           *
           * @sample {highcharts} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           * @sample {highstock} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           *
           * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
           * @default   true
           * @since     2.2.4
           * @apioption legend.navigation.animation
           */
          /**
           * The pixel size of the up and down arrows in the legend paging
           * navigation.
           *
           * @sample {highcharts} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           * @sample {highstock} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           *
           * @type      {number}
           * @default   12
           * @since     2.2.4
           * @apioption legend.navigation.arrowSize
           */
          /**
           * Whether to enable the legend navigation. In most cases, disabling
           * the navigation results in an unwanted overflow.
           *
           * See also the [adapt chart to legend](
           * https://www.highcharts.com/products/plugin-registry/single/8/Adapt-Chart-To-Legend)
           * plugin for a solution to extend the chart height to make room for
           * the legend, optionally in exported charts only.
           *
           * @type      {boolean}
           * @default   true
           * @since     4.2.4
           * @apioption legend.navigation.enabled
           */
          /**
           * Text styles for the legend page navigation.
           *
           * @see In styled mode, the navigation items are styled with the
           *      `.highcharts-legend-navigation` class.
           *
           * @sample {highcharts} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           * @sample {highstock} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           *
           * @type      {Highcharts.CSSObject}
           * @since     2.2.4
           * @apioption legend.navigation.style
           */
          /**
           * The color for the active up or down arrow in the legend page
           * navigation.
           *
           * @see In styled mode, the active arrow be styled with the
           *      `.highcharts-legend-nav-active` class.
           *
           * @sample  {highcharts} highcharts/legend/navigation/
           *          Legend page navigation demonstrated
           * @sample  {highstock} highcharts/legend/navigation/
           *          Legend page navigation demonstrated
           *
           * @type  {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
           * @since 2.2.4
           */
          activeColor: palette.highlightColor100,
          /**
           * The color of the inactive up or down arrow in the legend page
           * navigation. .
           *
           * @see In styled mode, the inactive arrow be styled with the
           *      `.highcharts-legend-nav-inactive` class.
           *
           * @sample {highcharts} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           * @sample {highstock} highcharts/legend/navigation/
           *         Legend page navigation demonstrated
           *
           * @type  {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
           * @since 2.2.4
           */
          inactiveColor: palette.neutralColor20
        },
        /**
         * The inner padding of the legend box.
         *
         * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         * @sample {highmaps} maps/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         *
         * @type      {number}
         * @default   8
         * @since     2.2.0
         * @apioption legend.padding
         */
        /**
         * Whether to reverse the order of the legend items compared to the
         * order of the series or points as defined in the configuration object.
         *
         * @see [yAxis.reversedStacks](#yAxis.reversedStacks),
         *      [series.legendIndex](#series.legendIndex)
         *
         * @sample {highcharts} highcharts/legend/reversed/
         *         Stacked bar with reversed legend
         *
         * @type      {boolean}
         * @default   false
         * @since     1.2.5
         * @apioption legend.reversed
         */
        /**
         * Whether to show the symbol on the right side of the text rather than
         * the left side. This is common in Arabic and Hebrew.
         *
         * @sample {highcharts} highcharts/legend/rtl/
         *         Symbol to the right
         *
         * @type      {boolean}
         * @default   false
         * @since     2.2
         * @apioption legend.rtl
         */
        /**
         * CSS styles for the legend area. In the 1.x versions the position
         * of the legend area was determined by CSS. In 2.x, the position is
         * determined by properties like `align`, `verticalAlign`, `x` and `y`,
         * but the styles are still parsed for backwards compatibility.
         *
         * @deprecated
         *
         * @type      {Highcharts.CSSObject}
         * @product   highcharts highstock
         * @apioption legend.style
         */
        /**
         * CSS styles for each legend item. Only a subset of CSS is supported,
         * notably those options related to text. The default `textOverflow`
         * property makes long texts truncate. Set it to `undefined` to wrap
         * text instead. A `width` property can be added to control the text
         * width.
         *
         * @see In styled mode, the legend items can be styled with the
         *      `.highcharts-legend-item` class.
         *
         * @sample {highcharts} highcharts/legend/itemstyle/
         *         Bold black text
         * @sample {highmaps} maps/legend/itemstyle/
         *         Item text styles
         *
         * @type    {Highcharts.CSSObject}
         * @default {"color": "#333333", "cursor": "pointer", "fontSize": "12px", "fontWeight": "bold", "textOverflow": "ellipsis"}
         */
        itemStyle: {
          /**
           * @ignore
           */
          color: palette.neutralColor80,
          /**
           * @ignore
           */
          cursor: "pointer",
          /**
           * @ignore
           */
          fontSize: "12px",
          /**
           * @ignore
           */
          fontWeight: "bold",
          /**
           * @ignore
           */
          textOverflow: "ellipsis"
        },
        /**
         * CSS styles for each legend item in hover mode. Only a subset of
         * CSS is supported, notably those options related to text. Properties
         * are inherited from `style` unless overridden here.
         *
         * @see In styled mode, the hovered legend items can be styled with
         *      the `.highcharts-legend-item:hover` pesudo-class.
         *
         * @sample {highcharts} highcharts/legend/itemhoverstyle/
         *         Red on hover
         * @sample {highmaps} maps/legend/itemstyle/
         *         Item text styles
         *
         * @type    {Highcharts.CSSObject}
         * @default {"color": "#000000"}
         */
        itemHoverStyle: {
          /**
           * @ignore
           */
          color: palette.neutralColor100
        },
        /**
         * CSS styles for each legend item when the corresponding series or
         * point is hidden. Only a subset of CSS is supported, notably those
         * options related to text. Properties are inherited from `style`
         * unless overridden here.
         *
         * @see In styled mode, the hidden legend items can be styled with
         *      the `.highcharts-legend-item-hidden` class.
         *
         * @sample {highcharts} highcharts/legend/itemhiddenstyle/
         *         Darker gray color
         *
         * @type    {Highcharts.CSSObject}
         * @default {"color": "#cccccc"}
         */
        itemHiddenStyle: {
          /**
           * @ignore
           */
          color: palette.neutralColor20
        },
        /**
         * Whether to apply a drop shadow to the legend. A `backgroundColor`
         * also needs to be applied for this to take effect. The shadow can be
         * an object configuration containing `color`, `offsetX`, `offsetY`,
         * `opacity` and `width`.
         *
         * @sample {highcharts} highcharts/legend/shadow/
         *         White background and drop shadow
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/border-background/
         *         Border and background options
         *
         * @type {boolean|Highcharts.CSSObject}
         */
        shadow: false,
        /**
         * Default styling for the checkbox next to a legend item when
         * `showCheckbox` is true.
         *
         * @type {Highcharts.CSSObject}
         * @default {"width": "13px", "height": "13px", "position":"absolute"}
         */
        itemCheckboxStyle: {
          /**
           * @ignore
           */
          position: "absolute",
          /**
           * @ignore
           */
          width: "13px",
          /**
           * @ignore
           */
          height: "13px"
        },
        // itemWidth: undefined,
        /**
         * When this is true, the legend symbol width will be the same as
         * the symbol height, which in turn defaults to the font size of the
         * legend items.
         *
         * @since 5.0.0
         */
        squareSymbol: true,
        /**
         * The pixel height of the symbol for series types that use a rectangle
         * in the legend. Defaults to the font size of legend items.
         *
         * @productdesc {highmaps}
         * In Highmaps, when the symbol is the gradient of a vertical color
         * axis, the height defaults to 200.
         *
         * @sample {highmaps} maps/legend/layout-vertical-sized/
         *         Sized vertical gradient
         * @sample {highmaps} maps/legend/padding-itemmargin/
         *         No distance between data classes
         *
         * @type      {number}
         * @since     3.0.8
         * @apioption legend.symbolHeight
         */
        /**
         * The border radius of the symbol for series types that use a rectangle
         * in the legend. Defaults to half the `symbolHeight`.
         *
         * @sample {highcharts} highcharts/legend/symbolradius/
         *         Round symbols
         * @sample {highstock} highcharts/legend/symbolradius/
         *         Round symbols
         * @sample {highmaps} highcharts/legend/symbolradius/
         *         Round symbols
         *
         * @type      {number}
         * @since     3.0.8
         * @apioption legend.symbolRadius
         */
        /**
         * The pixel width of the legend item symbol. When the `squareSymbol`
         * option is set, this defaults to the `symbolHeight`, otherwise 16.
         *
         * @productdesc {highmaps}
         * In Highmaps, when the symbol is the gradient of a horizontal color
         * axis, the width defaults to 200.
         *
         * @sample {highcharts} highcharts/legend/symbolwidth/
         *         Greater symbol width and padding
         * @sample {highmaps} maps/legend/padding-itemmargin/
         *         Padding and item margins demonstrated
         * @sample {highmaps} maps/legend/layout-vertical-sized/
         *         Sized vertical gradient
         *
         * @type      {number}
         * @apioption legend.symbolWidth
         */
        /**
         * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
         * to render the legend item texts.
         *
         * Prior to 4.1.7, when using HTML, [legend.navigation](
         * #legend.navigation) was disabled.
         *
         * @type      {boolean}
         * @default   false
         * @apioption legend.useHTML
         */
        /**
         * The width of the legend box. If a number is set, it translates to
         * pixels. Since v7.0.2 it allows setting a percent string of the full
         * chart width, for example `40%`.
         *
         * Defaults to the full chart width for legends below or above the
         * chart, half the chart width for legends to the left and right.
         *
         * @sample {highcharts} highcharts/legend/width/
         *         Aligned to the plot area
         * @sample {highcharts} highcharts/legend/width-percent/
         *         A percent of the chart width
         *
         * @type      {number|string}
         * @since     2.0
         * @apioption legend.width
         */
        /**
         * The pixel padding between the legend item symbol and the legend
         * item text.
         *
         * @sample {highcharts} highcharts/legend/symbolpadding/
         *         Greater symbol width and padding
         */
        symbolPadding: 5,
        /**
         * The vertical alignment of the legend box. Can be one of `top`,
         * `middle` or `bottom`. Vertical position can be further determined
         * by the `y` option.
         *
         * In the case that the legend is aligned in a corner position, the
         * `layout` option will determine whether to place it above/below
         * or on the side of the plot area.
         *
         * When the [layout](#legend.layout) option is `proximate`, the
         * `verticalAlign` option doesn't apply.
         *
         * @sample {highcharts} highcharts/legend/verticalalign/
         *         Legend 100px from the top of the chart
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/alignment/
         *         Legend alignment
         *
         * @type  {Highcharts.VerticalAlignValue}
         * @since 2.0
         */
        verticalAlign: "bottom",
        // width: undefined,
        /**
         * The x offset of the legend relative to its horizontal alignment
         * `align` within chart.spacingLeft and chart.spacingRight. Negative
         * x moves it to the left, positive x moves it to the right.
         *
         * @sample {highcharts} highcharts/legend/width/
         *         Aligned to the plot area
         *
         * @since 2.0
         */
        x: 0,
        /**
         * The vertical offset of the legend relative to it's vertical alignment
         * `verticalAlign` within chart.spacingTop and chart.spacingBottom.
         *  Negative y moves it up, positive y moves it down.
         *
         * @sample {highcharts} highcharts/legend/verticalalign/
         *         Legend 100px from the top of the chart
         * @sample {highstock} stock/legend/align/
         *         Various legend options
         * @sample {highmaps} maps/legend/alignment/
         *         Legend alignment
         *
         * @since 2.0
         */
        y: 0,
        /**
         * A title to be added on top of the legend.
         *
         * @sample {highcharts} highcharts/legend/title/
         *         Legend title
         * @sample {highmaps} maps/legend/alignment/
         *         Legend with title
         *
         * @since 3.0
         */
        title: {
          /**
           * A text or HTML string for the title.
           *
           * @type      {string}
           * @since     3.0
           * @apioption legend.title.text
           */
          /**
           * Generic CSS styles for the legend title.
           *
           * @see In styled mode, the legend title is styled with the
           *      `.highcharts-legend-title` class.
           *
           * @type    {Highcharts.CSSObject}
           * @default {"fontWeight": "bold"}
           * @since   3.0
           */
          style: {
            /**
             * @ignore
             */
            fontWeight: "bold"
          }
        }
      },
      /**
       * The loading options control the appearance of the loading screen
       * that covers the plot area on chart operations. This screen only
       * appears after an explicit call to `chart.showLoading()`. It is a
       * utility for developers to communicate to the end user that something
       * is going on, for example while retrieving new data via an XHR connection.
       * The "Loading..." text itself is not part of this configuration
       * object, but part of the `lang` object.
       */
      loading: {
        /**
         * The duration in milliseconds of the fade out effect.
         *
         * @sample highcharts/loading/hideduration/
         *         Fade in and out over a second
         *
         * @type      {number}
         * @default   100
         * @since     1.2.0
         * @apioption loading.hideDuration
         */
        /**
         * The duration in milliseconds of the fade in effect.
         *
         * @sample highcharts/loading/hideduration/
         *         Fade in and out over a second
         *
         * @type      {number}
         * @default   100
         * @since     1.2.0
         * @apioption loading.showDuration
         */
        /**
         * CSS styles for the loading label `span`.
         *
         * @see In styled mode, the loading label is styled with the
         *      `.highcharts-loading-inner` class.
         *
         * @sample {highcharts|highmaps} highcharts/loading/labelstyle/
         *         Vertically centered
         * @sample {highstock} stock/loading/general/
         *         Label styles
         *
         * @type    {Highcharts.CSSObject}
         * @default {"fontWeight": "bold", "position": "relative", "top": "45%"}
         * @since   1.2.0
         */
        labelStyle: {
          /**
           * @ignore
           */
          fontWeight: "bold",
          /**
           * @ignore
           */
          position: "relative",
          /**
           * @ignore
           */
          top: "45%"
        },
        /**
         * CSS styles for the loading screen that covers the plot area.
         *
         * In styled mode, the loading label is styled with the
         * `.highcharts-loading` class.
         *
         * @sample  {highcharts|highmaps} highcharts/loading/style/
         *          Gray plot area, white text
         * @sample  {highstock} stock/loading/general/
         *          Gray plot area, white text
         *
         * @type    {Highcharts.CSSObject}
         * @default {"position": "absolute", "backgroundColor": "#ffffff", "opacity": 0.5, "textAlign": "center"}
         * @since   1.2.0
         */
        style: {
          /**
           * @ignore
           */
          position: "absolute",
          /**
           * @ignore
           */
          backgroundColor: palette.backgroundColor,
          /**
           * @ignore
           */
          opacity: 0.5,
          /**
           * @ignore
           */
          textAlign: "center"
        }
      },
      /**
       * Options for the tooltip that appears when the user hovers over a
       * series or point.
       *
       * @declare Highcharts.TooltipOptions
       */
      tooltip: {
        /**
         * The color of the tooltip border. When `undefined`, the border takes
         * the color of the corresponding series or point.
         *
         * @sample {highcharts} highcharts/tooltip/bordercolor-default/
         *         Follow series by default
         * @sample {highcharts} highcharts/tooltip/bordercolor-black/
         *         Black border
         * @sample {highstock} stock/tooltip/general/
         *         Styled tooltip
         * @sample {highmaps} maps/tooltip/background-border/
         *         Background and border demo
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @apioption tooltip.borderColor
         */
        /**
         * A CSS class name to apply to the tooltip's container div,
         * allowing unique CSS styling for each chart.
         *
         * @type      {string}
         * @apioption tooltip.className
         */
        /**
         * Since 4.1, the crosshair definitions are moved to the Axis object
         * in order for a better separation from the tooltip. See
         * [xAxis.crosshair](#xAxis.crosshair).
         *
         * @sample {highcharts} highcharts/tooltip/crosshairs-x/
         *         Enable a crosshair for the x value
         *
         * @deprecated
         *
         * @type      {*}
         * @default   true
         * @apioption tooltip.crosshairs
         */
        /**
         * Distance from point to tooltip in pixels.
         *
         * @type      {number}
         * @default   16
         * @apioption tooltip.distance
         */
        /**
         * Whether the tooltip should follow the mouse as it moves across
         * columns, pie slices and other point types with an extent.
         * By default it behaves this way for pie, polygon, map, sankey
         * and wordcloud series by override in the `plotOptions`
         * for those series types.
         *
         * Does not apply if [split](#tooltip.split) is `true`.
         *
         * For touch moves to behave the same way, [followTouchMove](
         * #tooltip.followTouchMove) must be `true` also.
         *
         * @type      {boolean}
         * @default   {highcharts} false
         * @default   {highstock} false
         * @default   {highmaps} true
         * @since     3.0
         * @apioption tooltip.followPointer
         */
        /**
         * Whether the tooltip should update as the finger moves on a touch
         * device. If this is `true` and [chart.panning](#chart.panning) is
         * set,`followTouchMove` will take over one-finger touches, so the user
         * needs to use two fingers for zooming and panning.
         *
         * Note the difference to [followPointer](#tooltip.followPointer) that
         * only defines the _position_ of the tooltip. If `followPointer` is
         * false in for example a column series, the tooltip will show above or
         * below the column, but as `followTouchMove` is true, the tooltip will
         * jump from column to column as the user swipes across the plot area.
         *
         * @type      {boolean}
         * @default   {highcharts} true
         * @default   {highstock} true
         * @default   {highmaps} false
         * @since     3.0.1
         * @apioption tooltip.followTouchMove
         */
        /**
         * Callback function to format the text of the tooltip from scratch. In
         * case of single or [shared](#tooltip.shared) tooltips, a string should
         * be returned. In case of [split](#tooltip.split) tooltips, it should
         * return an array where the first item is the header, and subsequent
         * items are mapped to the points. Return `false` to disable tooltip for
         * a specific point on series.
         *
         * A subset of HTML is supported. Unless `useHTML` is true, the HTML of
         * the tooltip is parsed and converted to SVG, therefore this isn't a
         * complete HTML renderer. The following HTML tags are supported: `b`,
         * `br`, `em`, `i`, `span`, `strong`. Spans can be styled with a `style`
         * attribute, but only text-related CSS, that is shared with SVG, is
         * handled.
         *
         * The available data in the formatter differ a bit depending on whether
         * the tooltip is shared or split, or belongs to a single point. In a
         * shared/split tooltip, all properties except `x`, which is common for
         * all points, are kept in an array, `this.points`.
         *
         * Available data are:
         *
         * - **this.percentage (not shared) /**
         *   **this.points[i].percentage (shared)**:
         *   Stacked series and pies only. The point's percentage of the total.
         *
         * - **this.point (not shared) / this.points[i].point (shared)**:
         *   The point object. The point name, if defined, is available through
         *   `this.point.name`.
         *
         * - **this.points**:
         *   In a shared tooltip, this is an array containing all other
         *   properties for each point.
         *
         * - **this.series (not shared) / this.points[i].series (shared)**:
         *   The series object. The series name is available through
         *   `this.series.name`.
         *
         * - **this.total (not shared) / this.points[i].total (shared)**:
         *   Stacked series only. The total value at this point's x value.
         *
         * - **this.x**:
         *   The x value. This property is the same regardless of the tooltip
         *   being shared or not.
         *
         * - **this.y (not shared) / this.points[i].y (shared)**:
         *   The y value.
         *
         * @sample {highcharts} highcharts/tooltip/formatter-simple/
         *         Simple string formatting
         * @sample {highcharts} highcharts/tooltip/formatter-shared/
         *         Formatting with shared tooltip
         * @sample {highcharts|highstock} highcharts/tooltip/formatter-split/
         *         Formatting with split tooltip
         * @sample highcharts/tooltip/formatter-conditional-default/
         *         Extending default formatter
         * @sample {highstock} stock/tooltip/formatter/
         *         Formatting with shared tooltip
         * @sample {highmaps} maps/tooltip/formatter/
         *         String formatting
         *
         * @type      {Highcharts.TooltipFormatterCallbackFunction}
         * @apioption tooltip.formatter
         */
        /**
         * Callback function to format the text of the tooltip for
         * visible null points.
         * Works analogously to [formatter](#tooltip.formatter).
         *
         * @sample highcharts/plotoptions/series-nullformat
         *         Format data label and tooltip for null point.
         *
         * @type      {Highcharts.TooltipFormatterCallbackFunction}
         * @apioption tooltip.nullFormatter
         */
        /**
         * Whether to allow the tooltip to render outside the chart's SVG
         * element box. By default (`false`), the tooltip is rendered within the
         * chart's SVG element, which results in the tooltip being aligned
         * inside the chart area. For small charts, this may result in clipping
         * or overlapping. When `true`, a separate SVG element is created and
         * overlaid on the page, allowing the tooltip to be aligned inside the
         * page itself.
         *
         * Defaults to `true` if `chart.scrollablePlotArea` is activated,
         * otherwise `false`.
         *
         * @sample highcharts/tooltip/outside
         *         Small charts with tooltips outside
         *
         * @type      {boolean|undefined}
         * @default   undefined
         * @since     6.1.1
         * @apioption tooltip.outside
         */
        /**
         * A callback function for formatting the HTML output for a single point
         * in the tooltip. Like the `pointFormat` string, but with more
         * flexibility.
         *
         * @type      {Highcharts.FormatterCallbackFunction<Highcharts.Point>}
         * @since     4.1.0
         * @context   Highcharts.Point
         * @apioption tooltip.pointFormatter
         */
        /**
         * A callback function to place the tooltip in a default position. The
         * callback receives three parameters: `labelWidth`, `labelHeight` and
         * `point`, where point contains values for `plotX` and `plotY` telling
         * where the reference point is in the plot area. Add `chart.plotLeft`
         * and `chart.plotTop` to get the full coordinates.
         *
         * Since v7, when [tooltip.split](#tooltip.split) option is enabled,
         * positioner is called for each of the boxes separately, including
         * xAxis header. xAxis header is not a point, instead `point` argument
         * contains info:
         * `{ plotX: Number, plotY: Number, isHeader: Boolean }`
         *
         *
         * The return should be an object containing x and y values, for example
         * `{ x: 100, y: 100 }`.
         *
         * @sample {highcharts} highcharts/tooltip/positioner/
         *         A fixed tooltip position
         * @sample {highstock} stock/tooltip/positioner/
         *         A fixed tooltip position on top of the chart
         * @sample {highmaps} maps/tooltip/positioner/
         *         A fixed tooltip position
         * @sample {highstock} stock/tooltip/split-positioner/
         *         Split tooltip with fixed positions
         * @sample {highstock} stock/tooltip/positioner-scrollable-plotarea/
         *         Scrollable plot area combined with tooltip positioner
         *
         * @type      {Highcharts.TooltipPositionerCallbackFunction}
         * @since     2.2.4
         * @apioption tooltip.positioner
         */
        /**
         * Split the tooltip into one label per series, with the header close
         * to the axis. This is recommended over [shared](#tooltip.shared)
         * tooltips for charts with multiple line series, generally making them
         * easier to read. This option takes precedence over `tooltip.shared`.
         *
         * @productdesc {highstock} In Highcharts Stock, tooltips are split
         * by default since v6.0.0. Stock charts typically contain
         * multi-dimension points and multiple panes, making split tooltips
         * the preferred layout over
         * the previous `shared` tooltip.
         *
         * @sample highcharts/tooltip/split/
         *         Split tooltip
         * @sample {highcharts|highstock} highcharts/tooltip/formatter-split/
         *         Split tooltip and custom formatter callback
         *
         * @type      {boolean}
         * @default   {highcharts} false
         * @default   {highstock} true
         * @since     5.0.0
         * @product   highcharts highstock
         * @apioption tooltip.split
         */
        /**
         * Prevents the tooltip from switching or closing, when touched or
         * pointed.
         *
         * @sample highcharts/tooltip/stickoncontact/
         *         Tooltip sticks on pointer contact
         *
         * @type      {boolean}
         * @since     8.0.1
         * @apioption tooltip.stickOnContact
         */
        /**
         * Use HTML to render the contents of the tooltip instead of SVG. Using
         * HTML allows advanced formatting like tables and images in the
         * tooltip. It is also recommended for rtl languages as it works around
         * rtl bugs in early Firefox.
         *
         * @sample {highcharts|highstock} highcharts/tooltip/footerformat/
         *         A table for value alignment
         * @sample {highcharts|highstock} highcharts/tooltip/fullhtml/
         *         Full HTML tooltip
         * @sample {highmaps} maps/tooltip/usehtml/
         *         Pure HTML tooltip
         *
         * @type      {boolean}
         * @default   false
         * @since     2.2
         * @apioption tooltip.useHTML
         */
        /**
         * How many decimals to show in each series' y value. This is
         * overridable in each series' tooltip options object. The default is to
         * preserve all decimals.
         *
         * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
         *         Set decimals, prefix and suffix for the value
         * @sample {highmaps} maps/tooltip/valuedecimals/
         *         Set decimals, prefix and suffix for the value
         *
         * @type      {number|undefined}
         * @since     2.2
         * @apioption tooltip.valueDecimals
         */
        /**
         * A string to prepend to each series' y value. Overridable in each
         * series' tooltip options object.
         *
         * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
         *         Set decimals, prefix and suffix for the value
         * @sample {highmaps} maps/tooltip/valuedecimals/
         *         Set decimals, prefix and suffix for the value
         *
         * @type      {string}
         * @since     2.2
         * @apioption tooltip.valuePrefix
         */
        /**
         * A string to append to each series' y value. Overridable in each
         * series' tooltip options object.
         *
         * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
         *         Set decimals, prefix and suffix for the value
         * @sample {highmaps} maps/tooltip/valuedecimals/
         *         Set decimals, prefix and suffix for the value
         *
         * @type      {string}
         * @since     2.2
         * @apioption tooltip.valueSuffix
         */
        /**
         * The format for the date in the tooltip header if the X axis is a
         * datetime axis. The default is a best guess based on the smallest
         * distance between points in the chart.
         *
         * @sample {highcharts} highcharts/tooltip/xdateformat/
         *         A different format
         *
         * @type      {string}
         * @product   highcharts highstock gantt
         * @apioption tooltip.xDateFormat
         */
        /**
         * How many decimals to show for the `point.change` value when the
         * `series.compare` option is set. This is overridable in each series'
         * tooltip options object. The default is to preserve all decimals.
         *
         * @type      {number}
         * @since     1.0.1
         * @product   highstock
         * @apioption tooltip.changeDecimals
         */
        /**
         * Enable or disable the tooltip.
         *
         * @sample {highcharts} highcharts/tooltip/enabled/
         *         Disabled
         * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
         *         Disable tooltip and show values on chart instead
         */
        enabled: true,
        /**
         * Enable or disable animation of the tooltip.
         *
         * @type       {boolean}
         * @default    true
         * @since      2.3.0
         */
        animation: svg$5,
        /**
         * The radius of the rounded border corners.
         *
         * @sample {highcharts} highcharts/tooltip/bordercolor-default/
         *         5px by default
         * @sample {highcharts} highcharts/tooltip/borderradius-0/
         *         Square borders
         * @sample {highmaps} maps/tooltip/background-border/
         *         Background and border demo
         */
        borderRadius: 3,
        /**
         * For series on datetime axes, the date format in the tooltip's
         * header will by default be guessed based on the closest data points.
         * This member gives the default string representations used for
         * each unit. For an overview of the replacement codes, see
         * [dateFormat](/class-reference/Highcharts#.dateFormat).
         *
         * @see [xAxis.dateTimeLabelFormats](#xAxis.dateTimeLabelFormats)
         *
         * @type    {Highcharts.Dictionary<string>}
         * @product highcharts highstock gantt
         */
        dateTimeLabelFormats: {
          /** @internal */
          millisecond: "%A, %b %e, %H:%M:%S.%L",
          /** @internal */
          second: "%A, %b %e, %H:%M:%S",
          /** @internal */
          minute: "%A, %b %e, %H:%M",
          /** @internal */
          hour: "%A, %b %e, %H:%M",
          /** @internal */
          day: "%A, %b %e, %Y",
          /** @internal */
          week: "Week from %A, %b %e, %Y",
          /** @internal */
          month: "%B %Y",
          /** @internal */
          year: "%Y"
        },
        /**
         * A string to append to the tooltip format.
         *
         * @sample {highcharts} highcharts/tooltip/footerformat/
         *         A table for value alignment
         * @sample {highmaps} maps/tooltip/format/
         *         Format demo
         *
         * @since 2.2
         */
        footerFormat: "",
        /**
         * The name of a symbol to use for the border around the tooltip
         * header. Applies only when [tooltip.split](#tooltip.split) is
         * enabled.
         *
         * Custom callbacks for symbol path generation can also be added to
         * `Highcharts.SVGRenderer.prototype.symbols` the same way as for
         * [series.marker.symbol](plotOptions.line.marker.symbol).
         *
         * @see [tooltip.shape](#tooltip.shape)
         *
         * @sample {highstock} stock/tooltip/split-positioner/
         *         Different shapes for header and split boxes
         *
         * @type       {Highcharts.TooltipShapeValue}
         * @validvalue ["callout", "square"]
         * @since      7.0
         */
        headerShape: "callout",
        /**
         * The number of milliseconds to wait until the tooltip is hidden when
         * mouse out from a point or chart.
         *
         * @since     3.0
         */
        hideDelay: 500,
        /**
         * Padding inside the tooltip, in pixels.
         *
         * @since      5.0.0
         */
        padding: 8,
        /**
         * The name of a symbol to use for the border around the tooltip. Can
         * be one of: `"callout"`, `"circle"` or `"rect"`. When
         * [tooltip.split](#tooltip.split)
         * option is enabled, shape is applied to all boxes except header, which
         * is controlled by
         * [tooltip.headerShape](#tooltip.headerShape).
         *
         * Custom callbacks for symbol path generation can also be added to
         * `Highcharts.SVGRenderer.prototype.symbols` the same way as for
         * [series.marker.symbol](plotOptions.line.marker.symbol).
         *
         * @type      {Highcharts.TooltipShapeValue}
         * @since     4.0
         */
        shape: "callout",
        /**
         * When the tooltip is shared, the entire plot area will capture mouse
         * movement or touch events. Tooltip texts for series types with ordered
         * data (not pie, scatter, flags etc) will be shown in a single bubble.
         * This is recommended for single series charts and for tablet/mobile
         * optimized charts.
         *
         * See also [tooltip.split](#tooltip.split), that is better suited for
         * charts with many series, especially line-type series. The
         * `tooltip.split` option takes precedence over `tooltip.shared`.
         *
         * @sample {highcharts} highcharts/tooltip/shared-false/
         *         False by default
         * @sample {highcharts} highcharts/tooltip/shared-true/
         *         True
         * @sample {highcharts} highcharts/tooltip/shared-x-crosshair/
         *         True with x axis crosshair
         * @sample {highcharts} highcharts/tooltip/shared-true-mixed-types/
         *         True with mixed series types
         *
         * @since     2.1
         * @product   highcharts highstock
         */
        shared: false,
        /**
         * Proximity snap for graphs or single points. It defaults to 10 for
         * mouse-powered devices and 25 for touch devices.
         *
         * Note that in most cases the whole plot area captures the mouse
         * movement, and in these cases `tooltip.snap` doesn't make sense. This
         * applies when [stickyTracking](#plotOptions.series.stickyTracking)
         * is `true` (default) and when the tooltip is [shared](#tooltip.shared)
         * or [split](#tooltip.split).
         *
         * @sample {highcharts} highcharts/tooltip/bordercolor-default/
         *         10 px by default
         * @sample {highcharts} highcharts/tooltip/snap-50/
         *         50 px on graph
         *
         * @type    {number}
         * @default 10/25
         * @since   1.2.0
         * @product highcharts highstock
         */
        snap: isTouchDevice$4 ? 25 : 10,
        /**
         * The HTML of the tooltip header line. Variables are enclosed by
         * curly brackets. Available variables are `point.key`, `series.name`,
         * `series.color` and other members from the `point` and `series`
         * objects. The `point.key` variable contains the category name, x
         * value or datetime string depending on the type of axis. For datetime
         * axes, the `point.key` date format can be set using
         * `tooltip.xDateFormat`.
         *
         * @sample {highcharts} highcharts/tooltip/footerformat/
         *         An HTML table in the tooltip
         * @sample {highstock} highcharts/tooltip/footerformat/
         *         An HTML table in the tooltip
         * @sample {highmaps} maps/tooltip/format/
         *         Format demo
         *
         * @type       {string}
         * @apioption  tooltip.headerFormat
         */
        headerFormat: '<span style="font-size: 10px">{point.key}</span><br/>',
        /**
         * The HTML of the null point's line in the tooltip. Works analogously
         * to [pointFormat](#tooltip.pointFormat).
         *
         * @sample {highcharts} highcharts/plotoptions/series-nullformat
         *         Format data label and tooltip for null point.
         *
         * @type      {string}
         * @apioption tooltip.nullFormat
         */
        /**
         * The HTML of the point's line in the tooltip. Variables are enclosed
         * by curly brackets. Available variables are `point.x`, `point.y`,
         * `series.name` and `series.color` and other properties on the same
         * form. Furthermore, `point.y` can be extended by the
         * `tooltip.valuePrefix` and `tooltip.valueSuffix` variables. This can
         * also be overridden for each series, which makes it a good hook for
         * displaying units.
         *
         * In styled mode, the dot is colored by a class name rather
         * than the point color.
         *
         * @sample {highcharts} highcharts/tooltip/pointformat/
         *         A different point format with value suffix
         * @sample {highmaps} maps/tooltip/format/
         *         Format demo
         *
         * @type       {string}
         * @since      2.2
         * @apioption  tooltip.pointFormat
         */
        pointFormat: '<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',
        /**
         * The background color or gradient for the tooltip.
         *
         * In styled mode, the stroke width is set in the
         * `.highcharts-tooltip-box` class.
         *
         * @sample {highcharts} highcharts/tooltip/backgroundcolor-solid/
         *         Yellowish background
         * @sample {highcharts} highcharts/tooltip/backgroundcolor-gradient/
         *         Gradient
         * @sample {highcharts} highcharts/css/tooltip-border-background/
         *         Tooltip in styled mode
         * @sample {highstock} stock/tooltip/general/
         *         Custom tooltip
         * @sample {highstock} highcharts/css/tooltip-border-background/
         *         Tooltip in styled mode
         * @sample {highmaps} maps/tooltip/background-border/
         *         Background and border demo
         * @sample {highmaps} highcharts/css/tooltip-border-background/
         *         Tooltip in styled mode
         *
         * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         */
        backgroundColor: color$g(palette.neutralColor3).setOpacity(0.85).get(),
        /**
         * The pixel width of the tooltip border.
         *
         * In styled mode, the stroke width is set in the
         * `.highcharts-tooltip-box` class.
         *
         * @sample {highcharts} highcharts/tooltip/bordercolor-default/
         *         2px by default
         * @sample {highcharts} highcharts/tooltip/borderwidth/
         *         No border (shadow only)
         * @sample {highcharts} highcharts/css/tooltip-border-background/
         *         Tooltip in styled mode
         * @sample {highstock} stock/tooltip/general/
         *         Custom tooltip
         * @sample {highstock} highcharts/css/tooltip-border-background/
         *         Tooltip in styled mode
         * @sample {highmaps} maps/tooltip/background-border/
         *         Background and border demo
         * @sample {highmaps} highcharts/css/tooltip-border-background/
         *         Tooltip in styled mode
         */
        borderWidth: 1,
        /**
         * Whether to apply a drop shadow to the tooltip.
         *
         * @sample {highcharts} highcharts/tooltip/bordercolor-default/
         *         True by default
         * @sample {highcharts} highcharts/tooltip/shadow/
         *         False
         * @sample {highmaps} maps/tooltip/positioner/
         *         Fixed tooltip position, border and shadow disabled
         *
         * @type {boolean|Highcharts.ShadowOptionsObject}
         */
        shadow: true,
        /**
         * Prevents the tooltip from switching or closing when touched or
         * pointed.
         *
         * @sample highcharts/tooltip/stickoncontact/
         *         Tooltip sticks on pointer contact
         *
         * @since     8.0.1
         */
        stickOnContact: false,
        /**
         * CSS styles for the tooltip. The tooltip can also be styled through
         * the CSS class `.highcharts-tooltip`.
         *
         * Note that the default `pointerEvents` style makes the tooltip ignore
         * mouse events, so in order to use clickable tooltips, this value must
         * be set to `auto`.
         *
         * @sample {highcharts} highcharts/tooltip/style/
         *         Greater padding, bold text
         *
         * @type {Highcharts.CSSObject}
         */
        style: {
          /** @internal */
          color: palette.neutralColor80,
          /** @internal */
          cursor: "default",
          /** @internal */
          fontSize: "12px",
          /** @internal */
          whiteSpace: "nowrap"
        },
        /**
         * Use HTML to render the contents of the tooltip instead of SVG. Using
         * HTML allows advanced formatting like tables and images in the
         * tooltip. It is also recommended for rtl languages as it works around
         * rtl bugs in early Firefox.
         *
         * @sample {highcharts|highstock} highcharts/tooltip/footerformat/
         *         A table for value alignment
         * @sample {highcharts|highstock} highcharts/tooltip/fullhtml/
         *         Full HTML tooltip
         * @sample {highmaps} maps/tooltip/usehtml/
         *         Pure HTML tooltip
         *
         * @since     2.2
         */
        useHTML: false
      },
      /**
       * Highchart by default puts a credits label in the lower right corner
       * of the chart. This can be changed using these options.
       */
      credits: {
        /**
         * Credits for map source to be concatenated with conventional credit
         * text. By default this is a format string that collects copyright
         * information from the map if available.
         *
         * @see [mapTextFull](#credits.mapTextFull)
         * @see [text](#credits.text)
         *
         * @type      {string}
         * @default   \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>
         * @since     4.2.2
         * @product   highmaps
         * @apioption credits.mapText
         */
        /**
         * Detailed credits for map source to be displayed on hover of credits
         * text. By default this is a format string that collects copyright
         * information from the map if available.
         *
         * @see [mapText](#credits.mapText)
         * @see [text](#credits.text)
         *
         * @type      {string}
         * @default   {geojson.copyright}
         * @since     4.2.2
         * @product   highmaps
         * @apioption credits.mapTextFull
         */
        /**
         * Whether to show the credits text.
         *
         * @sample {highcharts} highcharts/credits/enabled-false/
         *         Credits disabled
         * @sample {highstock} stock/credits/enabled/
         *         Credits disabled
         * @sample {highmaps} maps/credits/enabled-false/
         *         Credits disabled
         */
        enabled: true,
        /**
         * The URL for the credits label.
         *
         * @sample {highcharts} highcharts/credits/href/
         *         Custom URL and text
         * @sample {highmaps} maps/credits/customized/
         *         Custom URL and text
         */
        href: "https://www.highcharts.com?credits",
        /**
         * Position configuration for the credits label.
         *
         * @sample {highcharts} highcharts/credits/position-left/
         *         Left aligned
         * @sample {highcharts} highcharts/credits/position-left/
         *         Left aligned
         * @sample {highmaps} maps/credits/customized/
         *         Left aligned
         * @sample {highmaps} maps/credits/customized/
         *         Left aligned
         *
         * @type    {Highcharts.AlignObject}
         * @since   2.1
         */
        position: {
          /** @internal */
          align: "right",
          /** @internal */
          x: -10,
          /** @internal */
          verticalAlign: "bottom",
          /** @internal */
          y: -5
        },
        /**
         * CSS styles for the credits label.
         *
         * @see In styled mode, credits styles can be set with the
         *      `.highcharts-credits` class.
         *
         * @type {Highcharts.CSSObject}
         */
        style: {
          /** @internal */
          cursor: "pointer",
          /** @internal */
          color: palette.neutralColor40,
          /** @internal */
          fontSize: "9px"
        },
        /**
         * The text for the credits label.
         *
         * @productdesc {highmaps}
         * If a map is loaded as GeoJSON, the text defaults to
         * `Highcharts @ {map-credits}`. Otherwise, it defaults to
         * `Highcharts.com`.
         *
         * @sample {highcharts} highcharts/credits/href/
         *         Custom URL and text
         * @sample {highmaps} maps/credits/customized/
         *         Custom URL and text
         */
        text: "Highcharts.com"
      }
    };
    defaultOptions$g.chart.styledMode = false;
    var defaultTime$2 = new Time(merge$1m(defaultOptions$g.global, defaultOptions$g.time));
    function getOptions$3() {
      return defaultOptions$g;
    }
    function setOptions$2(options) {
      merge$1m(true, defaultOptions$g, options);
      if (options.time || options.global) {
        if (H.time) {
          H.time.update(merge$1m(defaultOptions$g.global, defaultOptions$g.time, options.global, options.time));
        } else {
          H.time = defaultTime$2;
        }
      }
      return defaultOptions$g;
    }
    var DefaultOptions = {
      defaultOptions: defaultOptions$g,
      defaultTime: defaultTime$2,
      getOptions: getOptions$3,
      setOptions: setOptions$2
    };
    var color$f = Color.parse;
    var win$e = H.win;
    var isNumber$P = Utilities.isNumber, objectEach$z = Utilities.objectEach;
    var Fx = (
      /** @class */
      function() {
        function Fx2(elem, options, prop) {
          this.pos = NaN;
          this.options = options;
          this.elem = elem;
          this.prop = prop;
        }
        Fx2.prototype.dSetter = function() {
          var paths = this.paths, start2 = paths && paths[0], end = paths && paths[1], now = this.now || 0;
          var path = [];
          if (now === 1 || !start2 || !end) {
            path = this.toD || [];
          } else if (start2.length === end.length && now < 1) {
            for (var i2 = 0; i2 < end.length; i2++) {
              var startSeg = start2[i2];
              var endSeg = end[i2];
              var tweenSeg = [];
              for (var j = 0; j < endSeg.length; j++) {
                var startItem = startSeg[j];
                var endItem = endSeg[j];
                if (isNumber$P(startItem) && isNumber$P(endItem) && // Arc boolean flags
                !(endSeg[0] === "A" && (j === 4 || j === 5))) {
                  tweenSeg[j] = startItem + now * (endItem - startItem);
                } else {
                  tweenSeg[j] = endItem;
                }
              }
              path.push(tweenSeg);
            }
          } else {
            path = end;
          }
          this.elem.attr("d", path, void 0, true);
        };
        Fx2.prototype.update = function() {
          var elem = this.elem, prop = this.prop, now = this.now, step = this.options.step;
          if (this[prop + "Setter"]) {
            this[prop + "Setter"]();
          } else if (elem.attr) {
            if (elem.element) {
              elem.attr(prop, now, null, true);
            }
          } else {
            elem.style[prop] = now + this.unit;
          }
          if (step) {
            step.call(elem, now, this);
          }
        };
        Fx2.prototype.run = function(from, to, unit) {
          var self2 = this, options = self2.options, timer = function(gotoEnd) {
            return timer.stopped ? false : self2.step(gotoEnd);
          }, requestAnimationFrame2 = win$e.requestAnimationFrame || function(step2) {
            setTimeout(step2, 13);
          }, step = function() {
            for (var i2 = 0; i2 < Fx2.timers.length; i2++) {
              if (!Fx2.timers[i2]()) {
                Fx2.timers.splice(i2--, 1);
              }
            }
            if (Fx2.timers.length) {
              requestAnimationFrame2(step);
            }
          };
          if (from === to && !this.elem["forceAnimate:" + this.prop]) {
            delete options.curAnim[this.prop];
            if (options.complete && Object.keys(options.curAnim).length === 0) {
              options.complete.call(this.elem);
            }
          } else {
            this.startTime = +/* @__PURE__ */ new Date();
            this.start = from;
            this.end = to;
            this.unit = unit;
            this.now = this.start;
            this.pos = 0;
            timer.elem = this.elem;
            timer.prop = this.prop;
            if (timer() && Fx2.timers.push(timer) === 1) {
              requestAnimationFrame2(step);
            }
          }
        };
        Fx2.prototype.step = function(gotoEnd) {
          var t2 = +/* @__PURE__ */ new Date(), options = this.options, elem = this.elem, complete = options.complete, duration = options.duration, curAnim = options.curAnim;
          var ret, done;
          if (elem.attr && !elem.element) {
            ret = false;
          } else if (gotoEnd || t2 >= duration + this.startTime) {
            this.now = this.end;
            this.pos = 1;
            this.update();
            curAnim[this.prop] = true;
            done = true;
            objectEach$z(curAnim, function(val) {
              if (val !== true) {
                done = false;
              }
            });
            if (done && complete) {
              complete.call(elem);
            }
            ret = false;
          } else {
            this.pos = options.easing((t2 - this.startTime) / duration);
            this.now = this.start + (this.end - this.start) * this.pos;
            this.update();
            ret = true;
          }
          return ret;
        };
        Fx2.prototype.initPath = function(elem, fromD, toD) {
          var startX = elem.startX, endX = elem.endX, end = toD.slice(), isArea = elem.isArea, positionFactor = isArea ? 2 : 1;
          var shift, fullLength, i2, reverse, start2 = fromD && fromD.slice();
          if (!start2) {
            return [end, end];
          }
          function prepend(arr, other) {
            while (arr.length < fullLength) {
              var moveSegment = arr[0], otherSegment = other[fullLength - arr.length];
              if (otherSegment && moveSegment[0] === "M") {
                if (otherSegment[0] === "C") {
                  arr[0] = [
                    "C",
                    moveSegment[1],
                    moveSegment[2],
                    moveSegment[1],
                    moveSegment[2],
                    moveSegment[1],
                    moveSegment[2]
                  ];
                } else {
                  arr[0] = ["L", moveSegment[1], moveSegment[2]];
                }
              }
              arr.unshift(moveSegment);
              if (isArea) {
                var z = arr.pop();
                arr.push(arr[arr.length - 1], z);
              }
            }
          }
          function append(arr, other) {
            while (arr.length < fullLength) {
              var segmentToAdd = arr[Math.floor(arr.length / positionFactor) - 1].slice();
              if (segmentToAdd[0] === "C") {
                segmentToAdd[1] = segmentToAdd[5];
                segmentToAdd[2] = segmentToAdd[6];
              }
              if (!isArea) {
                arr.push(segmentToAdd);
              } else {
                var lowerSegmentToAdd = arr[Math.floor(arr.length / positionFactor)].slice();
                arr.splice(arr.length / 2, 0, segmentToAdd, lowerSegmentToAdd);
              }
            }
          }
          if (startX && endX && endX.length) {
            for (i2 = 0; i2 < startX.length; i2++) {
              if (startX[i2] === endX[0]) {
                shift = i2;
                break;
              } else if (startX[0] === endX[endX.length - startX.length + i2]) {
                shift = i2;
                reverse = true;
                break;
              } else if (startX[startX.length - 1] === endX[endX.length - startX.length + i2]) {
                shift = startX.length - i2;
                break;
              }
            }
            if (typeof shift === "undefined") {
              start2 = [];
            }
          }
          if (start2.length && isNumber$P(shift)) {
            fullLength = end.length + shift * positionFactor;
            if (!reverse) {
              prepend(end, start2);
              append(start2);
            } else {
              prepend(start2, end);
              append(end);
            }
          }
          return [start2, end];
        };
        Fx2.prototype.fillSetter = function() {
          Fx2.prototype.strokeSetter.apply(this, arguments);
        };
        Fx2.prototype.strokeSetter = function() {
          this.elem.attr(this.prop, color$f(this.start).tweenTo(color$f(this.end), this.pos), null, true);
        };
        Fx2.timers = [];
        return Fx2;
      }()
    );
    var defined$U = Utilities.defined, getStyle$1 = Utilities.getStyle, isArray$m = Utilities.isArray, isNumber$O = Utilities.isNumber, isObject$d = Utilities.isObject, merge$1l = Utilities.merge, objectEach$y = Utilities.objectEach, pick$1z = Utilities.pick;
    function setAnimation$5(animation, chart) {
      chart.renderer.globalAnimation = pick$1z(animation, chart.options.chart.animation, true);
    }
    function animObject$c(animation) {
      return isObject$d(animation) ? merge$1l({ duration: 500, defer: 0 }, animation) : { duration: animation ? 500 : 0, defer: 0 };
    }
    function getDeferredAnimation$3(chart, animation, series) {
      var labelAnimation = animObject$c(animation), s2 = series ? [series] : chart.series;
      var defer = 0, duration = 0;
      s2.forEach(function(series2) {
        var seriesAnim = animObject$c(series2.options.animation);
        defer = animation && defined$U(animation.defer) ? labelAnimation.defer : Math.max(defer, seriesAnim.duration + seriesAnim.defer);
        duration = Math.min(labelAnimation.duration, seriesAnim.duration);
      });
      if (chart.renderer.forExport) {
        defer = 0;
      }
      var anim = {
        defer: Math.max(0, defer - duration),
        duration: Math.min(defer, duration)
      };
      return anim;
    }
    function animate$2(el, params2, opt) {
      var start2, unit = "", end, fx, args;
      if (!isObject$d(opt)) {
        args = arguments;
        opt = {
          duration: args[2],
          easing: args[3],
          complete: args[4]
        };
      }
      if (!isNumber$O(opt.duration)) {
        opt.duration = 400;
      }
      opt.easing = typeof opt.easing === "function" ? opt.easing : Math[opt.easing] || Math.easeInOutSine;
      opt.curAnim = merge$1l(params2);
      objectEach$y(params2, function(val, prop) {
        stop$2(el, prop);
        fx = new Fx(el, opt, prop);
        end = void 0;
        if (prop === "d" && isArray$m(params2.d)) {
          fx.paths = fx.initPath(el, el.pathArray, params2.d);
          fx.toD = params2.d;
          start2 = 0;
          end = 1;
        } else if (el.attr) {
          start2 = el.attr(prop);
        } else {
          start2 = parseFloat(getStyle$1(el, prop)) || 0;
          if (prop !== "opacity") {
            unit = "px";
          }
        }
        if (!end) {
          end = val;
        }
        if (typeof end === "string" && end.match("px")) {
          end = end.replace(/px/g, "");
        }
        fx.run(start2, end, unit);
      });
    }
    function stop$2(el, prop) {
      var i2 = Fx.timers.length;
      while (i2--) {
        if (Fx.timers[i2].elem === el && (!prop || prop === Fx.timers[i2].prop)) {
          Fx.timers[i2].stopped = true;
        }
      }
    }
    var animationExports = {
      animate: animate$2,
      animObject: animObject$c,
      getDeferredAnimation: getDeferredAnimation$3,
      setAnimation: setAnimation$5,
      stop: stop$2
    };
    var SVG_NS$3 = H.SVG_NS;
    var attr$7 = Utilities.attr, createElement$a = Utilities.createElement, discardElement$6 = Utilities.discardElement, error$8 = Utilities.error, isString$b = Utilities.isString, objectEach$x = Utilities.objectEach, splat$h = Utilities.splat;
    var hasValidDOMParser = function() {
      try {
        return Boolean(new DOMParser().parseFromString("", "text/html"));
      } catch (e2) {
        return false;
      }
    }();
    var AST = (
      /** @class */
      function() {
        function AST2(source) {
          this.nodes = typeof source === "string" ? this.parseMarkup(source) : source;
        }
        AST2.filterUserAttributes = function(attributes) {
          objectEach$x(attributes, function(val, key) {
            var valid = true;
            if (AST2.allowedAttributes.indexOf(key) === -1) {
              valid = false;
            }
            if (["background", "dynsrc", "href", "lowsrc", "src"].indexOf(key) !== -1) {
              valid = isString$b(val) && AST2.allowedReferences.some(function(ref) {
                return val.indexOf(ref) === 0;
              });
            }
            if (!valid) {
              error$8("Highcharts warning: Invalid attribute '" + key + "' in config");
              delete attributes[key];
            }
          });
          return attributes;
        };
        AST2.setElementHTML = function(el, html2) {
          el.innerHTML = "";
          if (html2) {
            var ast = new AST2(html2);
            ast.addToDOM(el);
          }
        };
        AST2.prototype.addToDOM = function(parent) {
          function recurse(subtree, subParent) {
            var ret;
            splat$h(subtree).forEach(function(item2) {
              var tagName = item2.tagName;
              var textNode = item2.textContent ? H.doc.createTextNode(item2.textContent) : void 0;
              var node;
              if (tagName) {
                if (tagName === "#text") {
                  node = textNode;
                } else if (AST2.allowedTags.indexOf(tagName) !== -1) {
                  var NS = tagName === "svg" ? SVG_NS$3 : subParent.namespaceURI || SVG_NS$3;
                  var element = H.doc.createElementNS(NS, tagName);
                  var attributes_1 = item2.attributes || {};
                  objectEach$x(item2, function(val, key) {
                    if (key !== "tagName" && key !== "attributes" && key !== "children" && key !== "textContent") {
                      attributes_1[key] = val;
                    }
                  });
                  attr$7(element, AST2.filterUserAttributes(attributes_1));
                  if (textNode) {
                    element.appendChild(textNode);
                  }
                  recurse(item2.children || [], element);
                  node = element;
                } else {
                  error$8("Highcharts warning: Invalid tagName '" + tagName + "' in config");
                }
              }
              if (node) {
                subParent.appendChild(node);
              }
              ret = node;
            });
            return ret;
          }
          return recurse(this.nodes, parent);
        };
        AST2.prototype.parseMarkup = function(markup) {
          var nodes = [];
          markup = markup.trim();
          var doc2;
          var body;
          if (hasValidDOMParser) {
            doc2 = new DOMParser().parseFromString(markup, "text/html");
          } else {
            body = createElement$a("div");
            body.innerHTML = markup;
            doc2 = { body };
          }
          var appendChildNodes = function(node, addTo) {
            var tagName = node.nodeName.toLowerCase();
            var astNode = {
              tagName
            };
            if (tagName === "#text") {
              astNode.textContent = node.textContent || "";
            }
            var parsedAttributes = node.attributes;
            if (parsedAttributes) {
              var attributes_2 = {};
              [].forEach.call(parsedAttributes, function(attrib) {
                attributes_2[attrib.name] = attrib.value;
              });
              astNode.attributes = attributes_2;
            }
            if (node.childNodes.length) {
              var children_1 = [];
              [].forEach.call(node.childNodes, function(childNode) {
                appendChildNodes(childNode, children_1);
              });
              if (children_1.length) {
                astNode.children = children_1;
              }
            }
            addTo.push(astNode);
          };
          [].forEach.call(doc2.body.childNodes, function(childNode) {
            return appendChildNodes(childNode, nodes);
          });
          if (body) {
            discardElement$6(body);
          }
          return nodes;
        };
        AST2.allowedAttributes = [
          "aria-controls",
          "aria-describedby",
          "aria-expanded",
          "aria-haspopup",
          "aria-hidden",
          "aria-label",
          "aria-labelledby",
          "aria-live",
          "aria-pressed",
          "aria-readonly",
          "aria-roledescription",
          "aria-selected",
          "class",
          "clip-path",
          "color",
          "colspan",
          "cx",
          "cy",
          "d",
          "dx",
          "dy",
          "disabled",
          "fill",
          "height",
          "href",
          "id",
          "in",
          "markerHeight",
          "markerWidth",
          "offset",
          "opacity",
          "orient",
          "padding",
          "paddingLeft",
          "paddingRight",
          "patternUnits",
          "r",
          "refX",
          "refY",
          "role",
          "scope",
          "slope",
          "src",
          "startOffset",
          "stdDeviation",
          "stroke",
          "stroke-linecap",
          "stroke-width",
          "style",
          "tableValues",
          "result",
          "rowspan",
          "summary",
          "target",
          "tabindex",
          "text-align",
          "textAnchor",
          "textLength",
          "type",
          "valign",
          "width",
          "x",
          "x1",
          "x2",
          "y",
          "y1",
          "y2",
          "zIndex"
        ];
        AST2.allowedReferences = [
          "https://",
          "http://",
          "mailto:",
          "/",
          "../",
          "./",
          "#"
        ];
        AST2.allowedTags = [
          "a",
          "b",
          "br",
          "button",
          "caption",
          "circle",
          "clipPath",
          "code",
          "dd",
          "defs",
          "div",
          "dl",
          "dt",
          "em",
          "feComponentTransfer",
          "feFuncA",
          "feFuncB",
          "feFuncG",
          "feFuncR",
          "feGaussianBlur",
          "feOffset",
          "feMerge",
          "feMergeNode",
          "filter",
          "h1",
          "h2",
          "h3",
          "h4",
          "h5",
          "h6",
          "hr",
          "i",
          "img",
          "li",
          "linearGradient",
          "marker",
          "ol",
          "p",
          "path",
          "pattern",
          "pre",
          "rect",
          "small",
          "span",
          "stop",
          "strong",
          "style",
          "sub",
          "sup",
          "svg",
          "table",
          "text",
          "thead",
          "tbody",
          "tspan",
          "td",
          "th",
          "tr",
          "u",
          "ul",
          "#text"
        ];
        return AST2;
      }()
    );
    var defaultOptions$f = DefaultOptions.defaultOptions, defaultTime$1 = DefaultOptions.defaultTime;
    var getNestedProperty$2 = Utilities.getNestedProperty, isNumber$N = Utilities.isNumber, pick$1y = Utilities.pick, pInt$8 = Utilities.pInt;
    function dateFormat(format2, timestamp, capitalize2) {
      return defaultTime$1.dateFormat(format2, timestamp, capitalize2);
    }
    function format$e(str, ctx, chart) {
      var splitter = "{", isInside = false, segment, valueAndFormat, val, index;
      var floatRegex = /f$/;
      var decRegex = /\.([0-9])/;
      var lang2 = defaultOptions$f.lang;
      var time = chart && chart.time || defaultTime$1;
      var numberFormatter = chart && chart.numberFormatter || numberFormat$2;
      var ret = [];
      while (str) {
        index = str.indexOf(splitter);
        if (index === -1) {
          break;
        }
        segment = str.slice(0, index);
        if (isInside) {
          valueAndFormat = segment.split(":");
          val = getNestedProperty$2(valueAndFormat.shift() || "", ctx);
          if (valueAndFormat.length && typeof val === "number") {
            segment = valueAndFormat.join(":");
            if (floatRegex.test(segment)) {
              var decimals = parseInt((segment.match(decRegex) || ["", "-1"])[1], 10);
              if (val !== null) {
                val = numberFormatter(val, decimals, lang2.decimalPoint, segment.indexOf(",") > -1 ? lang2.thousandsSep : "");
              }
            } else {
              val = time.dateFormat(segment, val);
            }
          }
          ret.push(val);
        } else {
          ret.push(segment);
        }
        str = str.slice(index + 1);
        isInside = !isInside;
        splitter = isInside ? "}" : "{";
      }
      ret.push(str);
      return ret.join("");
    }
    function numberFormat$2(number, decimals, decimalPoint, thousandsSep) {
      number = +number || 0;
      decimals = +decimals;
      var ret, fractionDigits;
      var lang2 = defaultOptions$f.lang, origDec = (number.toString().split(".")[1] || "").split("e")[0].length, exponent = number.toString().split("e"), firstDecimals = decimals;
      if (decimals === -1) {
        decimals = Math.min(origDec, 20);
      } else if (!isNumber$N(decimals)) {
        decimals = 2;
      } else if (decimals && exponent[1] && exponent[1] < 0) {
        fractionDigits = decimals + +exponent[1];
        if (fractionDigits >= 0) {
          exponent[0] = (+exponent[0]).toExponential(fractionDigits).split("e")[0];
          decimals = fractionDigits;
        } else {
          exponent[0] = exponent[0].split(".")[0] || 0;
          if (decimals < 20) {
            number = (exponent[0] * Math.pow(10, exponent[1])).toFixed(decimals);
          } else {
            number = 0;
          }
          exponent[1] = 0;
        }
      }
      var roundedNumber = (Math.abs(exponent[1] ? exponent[0] : number) + Math.pow(10, -Math.max(decimals, origDec) - 1)).toFixed(decimals);
      var strinteger = String(pInt$8(roundedNumber));
      var thousands = strinteger.length > 3 ? strinteger.length % 3 : 0;
      decimalPoint = pick$1y(decimalPoint, lang2.decimalPoint);
      thousandsSep = pick$1y(thousandsSep, lang2.thousandsSep);
      ret = number < 0 ? "-" : "";
      ret += thousands ? strinteger.substr(0, thousands) + thousandsSep : "";
      if (+exponent[1] < 0 && !firstDecimals) {
        ret = "0";
      } else {
        ret += strinteger.substr(thousands).replace(/(\d{3})(?=\d)/g, "$1" + thousandsSep);
      }
      if (decimals) {
        ret += decimalPoint + roundedNumber.slice(-decimals);
      }
      if (exponent[1] && +ret !== 0) {
        ret += "e" + exponent[1];
      }
      return ret;
    }
    var FormatUtilities = {
      dateFormat,
      format: format$e,
      numberFormat: numberFormat$2
    };
    var clamp$j = Utilities.clamp, pick$1x = Utilities.pick, stableSort$6 = Utilities.stableSort;
    var RendererUtilities;
    (function(RendererUtilities2) {
      function distribute2(boxes, len, maxDistance) {
        var origBoxes = boxes, reducedLen = origBoxes.reducedLen || len, sortByRank = function(a, b2) {
          return (b2.rank || 0) - (a.rank || 0);
        }, sortByTarget = function(a, b2) {
          return a.target - b2.target;
        };
        var i2, overlapping = true, restBoxes = [], box, target, total = 0;
        i2 = boxes.length;
        while (i2--) {
          total += boxes[i2].size;
        }
        if (total > reducedLen) {
          stableSort$6(boxes, sortByRank);
          i2 = 0;
          total = 0;
          while (total <= reducedLen) {
            total += boxes[i2].size;
            i2++;
          }
          restBoxes = boxes.splice(i2 - 1, boxes.length);
        }
        stableSort$6(boxes, sortByTarget);
        boxes = boxes.map(function(box2) {
          return {
            size: box2.size,
            targets: [box2.target],
            align: pick$1x(box2.align, 0.5)
          };
        });
        while (overlapping) {
          i2 = boxes.length;
          while (i2--) {
            box = boxes[i2];
            target = (Math.min.apply(0, box.targets) + Math.max.apply(0, box.targets)) / 2;
            box.pos = clamp$j(target - box.size * box.align, 0, len - box.size);
          }
          i2 = boxes.length;
          overlapping = false;
          while (i2--) {
            if (i2 > 0 && boxes[i2 - 1].pos + boxes[i2 - 1].size > boxes[i2].pos) {
              boxes[i2 - 1].size += boxes[i2].size;
              boxes[i2 - 1].targets = boxes[i2 - 1].targets.concat(boxes[i2].targets);
              boxes[i2 - 1].align = 0.5;
              if (boxes[i2 - 1].pos + boxes[i2 - 1].size > len) {
                boxes[i2 - 1].pos = len - boxes[i2 - 1].size;
              }
              boxes.splice(i2, 1);
              overlapping = true;
            }
          }
        }
        origBoxes.push.apply(origBoxes, restBoxes);
        i2 = 0;
        boxes.some(function(box2) {
          var posInCompositeBox = 0;
          return (box2.targets || []).some(function() {
            origBoxes[i2].pos = box2.pos + posInCompositeBox;
            if (typeof maxDistance !== "undefined" && Math.abs(origBoxes[i2].pos - origBoxes[i2].target) > maxDistance) {
              origBoxes.slice(0, i2 + 1).forEach(function(box3) {
                return delete box3.pos;
              });
              origBoxes.reducedLen = (origBoxes.reducedLen || len) - len * 0.1;
              if (origBoxes.reducedLen > len * 0.1) {
                distribute2(origBoxes, len, maxDistance);
              }
              return true;
            }
            posInCompositeBox += origBoxes[i2].size;
            i2++;
            return false;
          });
        });
        stableSort$6(origBoxes, sortByTarget);
        return origBoxes;
      }
      RendererUtilities2.distribute = distribute2;
    })(RendererUtilities || (RendererUtilities = {}));
    const R = RendererUtilities;
    var animate$1 = animationExports.animate, animObject$b = animationExports.animObject, stop$1 = animationExports.stop;
    var deg2rad$8 = H.deg2rad, doc$l = H.doc, noop$l = H.noop, svg$4 = H.svg, SVG_NS$2 = H.SVG_NS, win$d = H.win;
    var addEvent$11 = Utilities.addEvent, attr$6 = Utilities.attr, createElement$9 = Utilities.createElement, css$c = Utilities.css, defined$T = Utilities.defined, erase$8 = Utilities.erase, extend$1s = Utilities.extend, fireEvent$A = Utilities.fireEvent, isArray$l = Utilities.isArray, isFunction$4 = Utilities.isFunction, isNumber$M = Utilities.isNumber, isString$a = Utilities.isString, merge$1k = Utilities.merge, objectEach$w = Utilities.objectEach, pick$1w = Utilities.pick, pInt$7 = Utilities.pInt, syncTimeout$8 = Utilities.syncTimeout, uniqueKey$7 = Utilities.uniqueKey;
    var SVGElement = (
      /** @class */
      function() {
        function SVGElement2() {
          this.element = void 0;
          this.onEvents = {};
          this.opacity = 1;
          this.renderer = void 0;
          this.SVG_NS = SVG_NS$2;
          this.symbolCustomAttribs = [
            "x",
            "y",
            "width",
            "height",
            "r",
            "start",
            "end",
            "innerR",
            "anchorX",
            "anchorY",
            "rounded"
          ];
        }
        SVGElement2.prototype._defaultGetter = function(key) {
          var ret = pick$1w(
            this[key + "Value"],
            // align getter
            this[key],
            this.element ? this.element.getAttribute(key) : null,
            0
          );
          if (/^[\-0-9\.]+$/.test(ret)) {
            ret = parseFloat(ret);
          }
          return ret;
        };
        SVGElement2.prototype._defaultSetter = function(value, key, element) {
          element.setAttribute(key, value);
        };
        SVGElement2.prototype.add = function(parent) {
          var renderer = this.renderer, element = this.element;
          var inserted;
          if (parent) {
            this.parentGroup = parent;
          }
          this.parentInverted = parent && parent.inverted;
          if (typeof this.textStr !== "undefined" && this.element.nodeName === "text") {
            renderer.buildText(this);
          }
          this.added = true;
          if (!parent || parent.handleZ || this.zIndex) {
            inserted = this.zIndexSetter();
          }
          if (!inserted) {
            (parent ? parent.element : renderer.box).appendChild(element);
          }
          if (this.onAdd) {
            this.onAdd();
          }
          return this;
        };
        SVGElement2.prototype.addClass = function(className, replace) {
          var currentClassName = replace ? "" : this.attr("class") || "";
          className = (className || "").split(/ /g).reduce(function(newClassName, name) {
            if (currentClassName.indexOf(name) === -1) {
              newClassName.push(name);
            }
            return newClassName;
          }, currentClassName ? [currentClassName] : []).join(" ");
          if (className !== currentClassName) {
            this.attr("class", className);
          }
          return this;
        };
        SVGElement2.prototype.afterSetters = function() {
          if (this.doTransform) {
            this.updateTransform();
            this.doTransform = false;
          }
        };
        SVGElement2.prototype.align = function(alignOptions, alignByTranslate, box) {
          var attribs = {}, renderer = this.renderer, alignedObjects = renderer.alignedObjects;
          var x, y, alignTo, alignFactor, vAlignFactor;
          if (alignOptions) {
            this.alignOptions = alignOptions;
            this.alignByTranslate = alignByTranslate;
            if (!box || isString$a(box)) {
              this.alignTo = alignTo = box || "renderer";
              erase$8(alignedObjects, this);
              alignedObjects.push(this);
              box = void 0;
            }
          } else {
            alignOptions = this.alignOptions;
            alignByTranslate = this.alignByTranslate;
            alignTo = this.alignTo;
          }
          box = pick$1w(box, renderer[alignTo], alignTo === "scrollablePlotBox" ? renderer.plotBox : void 0, renderer);
          var align = alignOptions.align, vAlign = alignOptions.verticalAlign;
          x = (box.x || 0) + (alignOptions.x || 0);
          y = (box.y || 0) + (alignOptions.y || 0);
          if (align === "right") {
            alignFactor = 1;
          } else if (align === "center") {
            alignFactor = 2;
          }
          if (alignFactor) {
            x += (box.width - (alignOptions.width || 0)) / alignFactor;
          }
          attribs[alignByTranslate ? "translateX" : "x"] = Math.round(x);
          if (vAlign === "bottom") {
            vAlignFactor = 1;
          } else if (vAlign === "middle") {
            vAlignFactor = 2;
          }
          if (vAlignFactor) {
            y += (box.height - (alignOptions.height || 0)) / vAlignFactor;
          }
          attribs[alignByTranslate ? "translateY" : "y"] = Math.round(y);
          this[this.placed ? "animate" : "attr"](attribs);
          this.placed = true;
          this.alignAttr = attribs;
          return this;
        };
        SVGElement2.prototype.alignSetter = function(value) {
          var convert = {
            left: "start",
            center: "middle",
            right: "end"
          };
          if (convert[value]) {
            this.alignValue = value;
            this.element.setAttribute("text-anchor", convert[value]);
          }
        };
        SVGElement2.prototype.animate = function(params2, options, complete) {
          var _this = this;
          var animOptions = animObject$b(pick$1w(options, this.renderer.globalAnimation, true)), deferTime = animOptions.defer;
          if (pick$1w(doc$l.hidden, doc$l.msHidden, doc$l.webkitHidden, false)) {
            animOptions.duration = 0;
          }
          if (animOptions.duration !== 0) {
            if (complete) {
              animOptions.complete = complete;
            }
            syncTimeout$8(function() {
              if (_this.element) {
                animate$1(_this, params2, animOptions);
              }
            }, deferTime);
          } else {
            this.attr(params2, void 0, complete);
            objectEach$w(params2, function(val, prop) {
              if (animOptions.step) {
                animOptions.step.call(this, val, { prop, pos: 1, elem: this });
              }
            }, this);
          }
          return this;
        };
        SVGElement2.prototype.applyTextOutline = function(textOutline) {
          var elem = this.element, hasContrast = textOutline.indexOf("contrast") !== -1;
          if (hasContrast) {
            textOutline = textOutline.replace(/contrast/g, this.renderer.getContrast(elem.style.fill));
          }
          var parts = textOutline.split(" ");
          var color2 = parts[parts.length - 1];
          var strokeWidth = parts[0];
          if (strokeWidth && strokeWidth !== "none" && H.svg) {
            this.fakeTS = true;
            this.ySetter = this.xSetter;
            strokeWidth = strokeWidth.replace(/(^[\d\.]+)(.*?)$/g, function(match2, digit, unit) {
              return 2 * Number(digit) + unit;
            });
            this.removeTextOutline();
            var outline_1 = doc$l.createElementNS(SVG_NS$2, "tspan");
            attr$6(outline_1, {
              "class": "highcharts-text-outline",
              fill: color2,
              stroke: color2,
              "stroke-width": strokeWidth,
              "stroke-linejoin": "round"
            });
            [].forEach.call(elem.childNodes, function(childNode) {
              var clone2 = childNode.cloneNode(true);
              if (clone2.removeAttribute) {
                ["fill", "stroke", "stroke-width", "stroke"].forEach(function(prop) {
                  return clone2.removeAttribute(prop);
                });
              }
              outline_1.appendChild(clone2);
            });
            var br_1 = doc$l.createElementNS(SVG_NS$2, "tspan");
            br_1.textContent = "​";
            ["x", "y"].forEach(function(key) {
              var value = elem.getAttribute(key);
              if (value) {
                br_1.setAttribute(key, value);
              }
            });
            outline_1.appendChild(br_1);
            elem.insertBefore(outline_1, elem.firstChild);
          }
        };
        SVGElement2.prototype.attr = function(hash2, val, complete, continueAnimation) {
          var element = this.element, symbolCustomAttribs = this.symbolCustomAttribs;
          var key, hasSetSymbolSize, ret = this, skipAttr, setter;
          if (typeof hash2 === "string" && typeof val !== "undefined") {
            key = hash2;
            hash2 = {};
            hash2[key] = val;
          }
          if (typeof hash2 === "string") {
            ret = (this[hash2 + "Getter"] || this._defaultGetter).call(this, hash2, element);
          } else {
            objectEach$w(hash2, function eachAttribute(val2, key2) {
              skipAttr = false;
              if (!continueAnimation) {
                stop$1(this, key2);
              }
              if (this.symbolName && symbolCustomAttribs.indexOf(key2) !== -1) {
                if (!hasSetSymbolSize) {
                  this.symbolAttr(hash2);
                  hasSetSymbolSize = true;
                }
                skipAttr = true;
              }
              if (this.rotation && (key2 === "x" || key2 === "y")) {
                this.doTransform = true;
              }
              if (!skipAttr) {
                setter = this[key2 + "Setter"] || this._defaultSetter;
                setter.call(this, val2, key2, element);
                if (!this.styledMode && this.shadows && /^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(key2)) {
                  this.updateShadows(key2, val2, setter);
                }
              }
            }, this);
            this.afterSetters();
          }
          if (complete) {
            complete.call(this);
          }
          return ret;
        };
        SVGElement2.prototype.clip = function(clipRect) {
          return this.attr("clip-path", clipRect ? "url(" + this.renderer.url + "#" + clipRect.id + ")" : "none");
        };
        SVGElement2.prototype.crisp = function(rect2, strokeWidth) {
          var wrapper = this;
          strokeWidth = strokeWidth || rect2.strokeWidth || 0;
          var normalizer = Math.round(strokeWidth) % 2 / 2;
          rect2.x = Math.floor(rect2.x || wrapper.x || 0) + normalizer;
          rect2.y = Math.floor(rect2.y || wrapper.y || 0) + normalizer;
          rect2.width = Math.floor((rect2.width || wrapper.width || 0) - 2 * normalizer);
          rect2.height = Math.floor((rect2.height || wrapper.height || 0) - 2 * normalizer);
          if (defined$T(rect2.strokeWidth)) {
            rect2.strokeWidth = strokeWidth;
          }
          return rect2;
        };
        SVGElement2.prototype.complexColor = function(colorOptions, prop, elem) {
          var renderer = this.renderer;
          var colorObject, gradName, gradAttr, radAttr, gradients, stops, stopColor, stopOpacity, radialReference, id, key = [], value;
          fireEvent$A(this.renderer, "complexColor", {
            args: arguments
          }, function() {
            if (colorOptions.radialGradient) {
              gradName = "radialGradient";
            } else if (colorOptions.linearGradient) {
              gradName = "linearGradient";
            }
            if (gradName) {
              gradAttr = colorOptions[gradName];
              gradients = renderer.gradients;
              stops = colorOptions.stops;
              radialReference = elem.radialReference;
              if (isArray$l(gradAttr)) {
                colorOptions[gradName] = gradAttr = {
                  x1: gradAttr[0],
                  y1: gradAttr[1],
                  x2: gradAttr[2],
                  y2: gradAttr[3],
                  gradientUnits: "userSpaceOnUse"
                };
              }
              if (gradName === "radialGradient" && radialReference && !defined$T(gradAttr.gradientUnits)) {
                radAttr = gradAttr;
                gradAttr = merge$1k(gradAttr, renderer.getRadialAttr(radialReference, radAttr), { gradientUnits: "userSpaceOnUse" });
              }
              objectEach$w(gradAttr, function(value2, n2) {
                if (n2 !== "id") {
                  key.push(n2, value2);
                }
              });
              objectEach$w(stops, function(val) {
                key.push(val);
              });
              key = key.join(",");
              if (gradients[key]) {
                id = gradients[key].attr("id");
              } else {
                gradAttr.id = id = uniqueKey$7();
                var gradientObject_1 = gradients[key] = renderer.createElement(gradName).attr(gradAttr).add(renderer.defs);
                gradientObject_1.radAttr = radAttr;
                gradientObject_1.stops = [];
                stops.forEach(function(stop2) {
                  if (stop2[1].indexOf("rgba") === 0) {
                    colorObject = Color.parse(stop2[1]);
                    stopColor = colorObject.get("rgb");
                    stopOpacity = colorObject.get("a");
                  } else {
                    stopColor = stop2[1];
                    stopOpacity = 1;
                  }
                  var stopObject = renderer.createElement("stop").attr({
                    offset: stop2[0],
                    "stop-color": stopColor,
                    "stop-opacity": stopOpacity
                  }).add(gradientObject_1);
                  gradientObject_1.stops.push(stopObject);
                });
              }
              value = "url(" + renderer.url + "#" + id + ")";
              elem.setAttribute(prop, value);
              elem.gradient = key;
              colorOptions.toString = function() {
                return value;
              };
            }
          });
        };
        SVGElement2.prototype.css = function(styles) {
          var oldStyles = this.styles, newStyles = {}, elem = this.element, svgPseudoProps = ["textOutline", "textOverflow", "width"];
          var textWidth, serializedCss = "", hyphenate, hasNew = !oldStyles;
          if (styles && styles.color) {
            styles.fill = styles.color;
          }
          if (oldStyles) {
            objectEach$w(styles, function(style, n2) {
              if (oldStyles && oldStyles[n2] !== style) {
                newStyles[n2] = style;
                hasNew = true;
              }
            });
          }
          if (hasNew) {
            if (oldStyles) {
              styles = extend$1s(oldStyles, newStyles);
            }
            if (styles) {
              if (styles.width === null || styles.width === "auto") {
                delete this.textWidth;
              } else if (elem.nodeName.toLowerCase() === "text" && styles.width) {
                textWidth = this.textWidth = pInt$7(styles.width);
              }
            }
            this.styles = styles;
            if (textWidth && (!svg$4 && this.renderer.forExport)) {
              delete styles.width;
            }
            if (elem.namespaceURI === this.SVG_NS) {
              hyphenate = function(a, b2) {
                return "-" + b2.toLowerCase();
              };
              objectEach$w(styles, function(style, n2) {
                if (svgPseudoProps.indexOf(n2) === -1) {
                  serializedCss += n2.replace(/([A-Z])/g, hyphenate) + ":" + style + ";";
                }
              });
              if (serializedCss) {
                attr$6(elem, "style", serializedCss);
              }
            } else {
              css$c(elem, styles);
            }
            if (this.added) {
              if (this.element.nodeName === "text") {
                this.renderer.buildText(this);
              }
              if (styles && styles.textOutline) {
                this.applyTextOutline(styles.textOutline);
              }
            }
          }
          return this;
        };
        SVGElement2.prototype.dashstyleSetter = function(value) {
          var i2, strokeWidth = this["stroke-width"];
          if (strokeWidth === "inherit") {
            strokeWidth = 1;
          }
          value = value && value.toLowerCase();
          if (value) {
            var v2 = value.replace("shortdashdotdot", "3,1,1,1,1,1,").replace("shortdashdot", "3,1,1,1").replace("shortdot", "1,1,").replace("shortdash", "3,1,").replace("longdash", "8,3,").replace(/dot/g, "1,3,").replace("dash", "4,3,").replace(/,$/, "").split(",");
            i2 = v2.length;
            while (i2--) {
              v2[i2] = "" + pInt$7(v2[i2]) * pick$1w(strokeWidth, NaN);
            }
            value = v2.join(",").replace(/NaN/g, "none");
            this.element.setAttribute("stroke-dasharray", value);
          }
        };
        SVGElement2.prototype.destroy = function() {
          var wrapper = this, element = wrapper.element || {}, renderer = wrapper.renderer, ownerSVGElement = element.ownerSVGElement;
          var parentToClean = renderer.isSVG && element.nodeName === "SPAN" && wrapper.parentGroup || void 0, grandParent, i2;
          element.onclick = element.onmouseout = element.onmouseover = element.onmousemove = element.point = null;
          stop$1(wrapper);
          if (wrapper.clipPath && ownerSVGElement) {
            var clipPath_1 = wrapper.clipPath;
            [].forEach.call(ownerSVGElement.querySelectorAll("[clip-path],[CLIP-PATH]"), function(el) {
              if (el.getAttribute("clip-path").indexOf(clipPath_1.element.id) > -1) {
                el.removeAttribute("clip-path");
              }
            });
            wrapper.clipPath = clipPath_1.destroy();
          }
          if (wrapper.stops) {
            for (i2 = 0; i2 < wrapper.stops.length; i2++) {
              wrapper.stops[i2].destroy();
            }
            wrapper.stops.length = 0;
            wrapper.stops = void 0;
          }
          wrapper.safeRemoveChild(element);
          if (!renderer.styledMode) {
            wrapper.destroyShadows();
          }
          while (parentToClean && parentToClean.div && parentToClean.div.childNodes.length === 0) {
            grandParent = parentToClean.parentGroup;
            wrapper.safeRemoveChild(parentToClean.div);
            delete parentToClean.div;
            parentToClean = grandParent;
          }
          if (wrapper.alignTo) {
            erase$8(renderer.alignedObjects, wrapper);
          }
          objectEach$w(wrapper, function(val, key) {
            if (wrapper[key] && wrapper[key].parentGroup === wrapper && wrapper[key].destroy) {
              wrapper[key].destroy();
            }
            delete wrapper[key];
          });
          return;
        };
        SVGElement2.prototype.destroyShadows = function() {
          (this.shadows || []).forEach(function(shadow) {
            this.safeRemoveChild(shadow);
          }, this);
          this.shadows = void 0;
        };
        SVGElement2.prototype.destroyTextPath = function(elem, path) {
          var textElement = elem.getElementsByTagName("text")[0];
          var childNodes;
          if (textElement) {
            textElement.removeAttribute("dx");
            textElement.removeAttribute("dy");
            path.element.setAttribute("id", "");
            if (this.textPathWrapper && textElement.getElementsByTagName("textPath").length) {
              childNodes = this.textPathWrapper.element.childNodes;
              while (childNodes.length) {
                textElement.appendChild(childNodes[0]);
              }
              textElement.removeChild(this.textPathWrapper.element);
            }
          } else if (elem.getAttribute("dx") || elem.getAttribute("dy")) {
            elem.removeAttribute("dx");
            elem.removeAttribute("dy");
          }
          if (this.textPathWrapper) {
            this.textPathWrapper = this.textPathWrapper.destroy();
          }
        };
        SVGElement2.prototype.dSetter = function(value, key, element) {
          if (isArray$l(value)) {
            if (typeof value[0] === "string") {
              value = this.renderer.pathToSegments(value);
            }
            this.pathArray = value;
            value = value.reduce(function(acc, seg, i2) {
              if (!seg || !seg.join) {
                return (seg || "").toString();
              }
              return (i2 ? acc + " " : "") + seg.join(" ");
            }, "");
          }
          if (/(NaN| {2}|^$)/.test(value)) {
            value = "M 0 0";
          }
          if (this[key] !== value) {
            element.setAttribute(key, value);
            this[key] = value;
          }
        };
        SVGElement2.prototype.fadeOut = function(duration) {
          var elemWrapper = this;
          elemWrapper.animate({
            opacity: 0
          }, {
            duration: pick$1w(duration, 150),
            complete: function() {
              elemWrapper.attr({ y: -9999 }).hide();
            }
          });
        };
        SVGElement2.prototype.fillSetter = function(value, key, element) {
          if (typeof value === "string") {
            element.setAttribute(key, value);
          } else if (value) {
            this.complexColor(value, key, element);
          }
        };
        SVGElement2.prototype.getBBox = function(reload, rot) {
          var wrapper = this, renderer = wrapper.renderer, element = wrapper.element, styles = wrapper.styles, textStr = wrapper.textStr, cache2 = renderer.cache, cacheKeys = renderer.cacheKeys, isSVG = element.namespaceURI === wrapper.SVG_NS, rotation = pick$1w(rot, wrapper.rotation, 0), fontSize = renderer.styledMode ? element && SVGElement2.prototype.getStyle.call(element, "font-size") : styles && styles.fontSize;
          var bBox, width, height, toggleTextShadowShim, cacheKey;
          if (defined$T(textStr)) {
            cacheKey = textStr.toString();
            if (cacheKey.indexOf("<") === -1) {
              cacheKey = cacheKey.replace(/[0-9]/g, "0");
            }
            cacheKey += [
              "",
              rotation,
              fontSize,
              wrapper.textWidth,
              styles && styles.textOverflow,
              styles && styles.fontWeight
              // #12163
            ].join(",");
          }
          if (cacheKey && !reload) {
            bBox = cache2[cacheKey];
          }
          if (!bBox) {
            if (isSVG || renderer.forExport) {
              try {
                toggleTextShadowShim = this.fakeTS && function(display) {
                  var outline = element.querySelector(".highcharts-text-outline");
                  if (outline) {
                    css$c(outline, { display });
                  }
                };
                if (isFunction$4(toggleTextShadowShim)) {
                  toggleTextShadowShim("none");
                }
                bBox = element.getBBox ? (
                  // SVG: use extend because IE9 is not allowed to change
                  // width and height in case of rotation (below)
                  extend$1s({}, element.getBBox())
                ) : {
                  // Legacy IE in export mode
                  width: element.offsetWidth,
                  height: element.offsetHeight
                };
                if (isFunction$4(toggleTextShadowShim)) {
                  toggleTextShadowShim("");
                }
              } catch (e2) {
              }
              if (!bBox || bBox.width < 0) {
                bBox = { width: 0, height: 0 };
              }
            } else {
              bBox = wrapper.htmlGetBBox();
            }
            if (renderer.isSVG) {
              width = bBox.width;
              height = bBox.height;
              if (isSVG) {
                bBox.height = height = {
                  "11px,17": 14,
                  "13px,20": 16
                }[styles && styles.fontSize + "," + Math.round(height)] || height;
              }
              if (rotation) {
                var rad = rotation * deg2rad$8;
                bBox.width = Math.abs(height * Math.sin(rad)) + Math.abs(width * Math.cos(rad));
                bBox.height = Math.abs(height * Math.cos(rad)) + Math.abs(width * Math.sin(rad));
              }
            }
            if (cacheKey && (textStr === "" || bBox.height > 0)) {
              while (cacheKeys.length > 250) {
                delete cache2[cacheKeys.shift()];
              }
              if (!cache2[cacheKey]) {
                cacheKeys.push(cacheKey);
              }
              cache2[cacheKey] = bBox;
            }
          }
          return bBox;
        };
        SVGElement2.prototype.getStyle = function(prop) {
          return win$d.getComputedStyle(this.element || this, "").getPropertyValue(prop);
        };
        SVGElement2.prototype.hasClass = function(className) {
          return ("" + this.attr("class")).split(" ").indexOf(className) !== -1;
        };
        SVGElement2.prototype.hide = function(hideByTranslation) {
          if (hideByTranslation) {
            this.attr({ y: -9999 });
          } else {
            this.attr({ visibility: "hidden" });
          }
          return this;
        };
        SVGElement2.prototype.htmlGetBBox = function() {
          return { height: 0, width: 0, x: 0, y: 0 };
        };
        SVGElement2.prototype.init = function(renderer, nodeName) {
          this.element = nodeName === "span" ? createElement$9(nodeName) : doc$l.createElementNS(this.SVG_NS, nodeName);
          this.renderer = renderer;
          fireEvent$A(this, "afterInit");
        };
        SVGElement2.prototype.invert = function(inverted) {
          this.inverted = inverted;
          this.updateTransform();
          return this;
        };
        SVGElement2.prototype.on = function(eventType, handler) {
          var onEvents = this.onEvents;
          if (onEvents[eventType]) {
            onEvents[eventType]();
          }
          onEvents[eventType] = addEvent$11(this.element, eventType, handler);
          return this;
        };
        SVGElement2.prototype.opacitySetter = function(value, key, element) {
          var opacity = Number(Number(value).toFixed(3));
          this.opacity = opacity;
          element.setAttribute(key, opacity);
        };
        SVGElement2.prototype.removeClass = function(className) {
          return this.attr("class", ("" + this.attr("class")).replace(isString$a(className) ? new RegExp("(^| )" + className + "( |$)") : (
            // #12064, #13590
            className
          ), " ").replace(/ +/g, " ").trim());
        };
        SVGElement2.prototype.removeTextOutline = function() {
          var outline = this.element.querySelector("tspan.highcharts-text-outline");
          if (outline) {
            this.safeRemoveChild(outline);
          }
        };
        SVGElement2.prototype.safeRemoveChild = function(element) {
          var parentNode = element.parentNode;
          if (parentNode) {
            parentNode.removeChild(element);
          }
        };
        SVGElement2.prototype.setRadialReference = function(coordinates2) {
          var existingGradient = this.element.gradient && this.renderer.gradients[this.element.gradient];
          this.element.radialReference = coordinates2;
          if (existingGradient && existingGradient.radAttr) {
            existingGradient.animate(this.renderer.getRadialAttr(coordinates2, existingGradient.radAttr));
          }
          return this;
        };
        SVGElement2.prototype.setTextPath = function(path, textPathOptions) {
          var elem = this.element, textNode = this.text ? this.text.element : elem, attribsMap = {
            textAnchor: "text-anchor"
          };
          var adder = false, textPathElement, textPathId, textPathWrapper = this.textPathWrapper, firstTime = !textPathWrapper;
          textPathOptions = merge$1k(true, {
            enabled: true,
            attributes: {
              dy: -5,
              startOffset: "50%",
              textAnchor: "middle"
            }
          }, textPathOptions);
          var attrs = AST.filterUserAttributes(textPathOptions.attributes);
          if (path && textPathOptions && textPathOptions.enabled) {
            if (textPathWrapper && textPathWrapper.element.parentNode === null) {
              firstTime = true;
              textPathWrapper = textPathWrapper.destroy();
            } else if (textPathWrapper) {
              this.removeTextOutline.call(textPathWrapper.parentGroup);
            }
            if (this.options && this.options.padding) {
              attrs.dx = -this.options.padding;
            }
            if (!textPathWrapper) {
              this.textPathWrapper = textPathWrapper = this.renderer.createElement("textPath");
              adder = true;
            }
            textPathElement = textPathWrapper.element;
            textPathId = path.element.getAttribute("id");
            if (!textPathId) {
              path.element.setAttribute("id", textPathId = uniqueKey$7());
            }
            if (firstTime) {
              textNode.setAttribute("y", 0);
              if (isNumber$M(attrs.dx)) {
                textNode.setAttribute("x", -attrs.dx);
              }
              var childNodes = [].slice.call(textNode.childNodes);
              for (var i2 = 0; i2 < childNodes.length; i2++) {
                var childNode = childNodes[i2];
                if (childNode.nodeType === Node.TEXT_NODE || childNode.nodeName === "tspan") {
                  textPathElement.appendChild(childNode);
                }
              }
            }
            if (adder && textPathWrapper) {
              textPathWrapper.add({ element: textNode });
            }
            textPathElement.setAttributeNS("http://www.w3.org/1999/xlink", "href", this.renderer.url + "#" + textPathId);
            if (defined$T(attrs.dy)) {
              textPathElement.parentNode.setAttribute("dy", attrs.dy);
              delete attrs.dy;
            }
            if (defined$T(attrs.dx)) {
              textPathElement.parentNode.setAttribute("dx", attrs.dx);
              delete attrs.dx;
            }
            objectEach$w(attrs, function(val, key) {
              textPathElement.setAttribute(attribsMap[key] || key, val);
            });
            elem.removeAttribute("transform");
            this.removeTextOutline.call(textPathWrapper);
            if (this.text && !this.renderer.styledMode) {
              this.attr({
                fill: "none",
                "stroke-width": 0
              });
            }
            this.updateTransform = noop$l;
            this.applyTextOutline = noop$l;
          } else if (textPathWrapper) {
            delete this.updateTransform;
            delete this.applyTextOutline;
            this.destroyTextPath(elem, path);
            this.updateTransform();
            if (this.options && this.options.rotation) {
              this.applyTextOutline(this.options.style.textOutline);
            }
          }
          return this;
        };
        SVGElement2.prototype.shadow = function(shadowOptions, group, cutOff) {
          var shadows = [], element = this.element, oldShadowOptions = this.oldShadowOptions, defaultShadowOptions = {
            color: palette.neutralColor100,
            offsetX: this.parentInverted ? -1 : 1,
            offsetY: this.parentInverted ? -1 : 1,
            opacity: 0.15,
            width: 3
          };
          var i2, shadow, strokeWidth, shadowElementOpacity, update = false, transform2, options;
          if (shadowOptions === true) {
            options = defaultShadowOptions;
          } else if (typeof shadowOptions === "object") {
            options = extend$1s(defaultShadowOptions, shadowOptions);
          }
          if (options) {
            if (options && oldShadowOptions) {
              objectEach$w(options, function(value, key) {
                if (value !== oldShadowOptions[key]) {
                  update = true;
                }
              });
            }
            if (update) {
              this.destroyShadows();
            }
            this.oldShadowOptions = options;
          }
          if (!options) {
            this.destroyShadows();
          } else if (!this.shadows) {
            shadowElementOpacity = options.opacity / options.width;
            transform2 = this.parentInverted ? "translate(" + options.offsetY + ", " + options.offsetX + ")" : "translate(" + options.offsetX + ", " + options.offsetY + ")";
            for (i2 = 1; i2 <= options.width; i2++) {
              shadow = element.cloneNode(false);
              strokeWidth = options.width * 2 + 1 - 2 * i2;
              attr$6(shadow, {
                stroke: shadowOptions.color || palette.neutralColor100,
                "stroke-opacity": shadowElementOpacity * i2,
                "stroke-width": strokeWidth,
                transform: transform2,
                fill: "none"
              });
              shadow.setAttribute("class", (shadow.getAttribute("class") || "") + " highcharts-shadow");
              if (cutOff) {
                attr$6(shadow, "height", Math.max(attr$6(shadow, "height") - strokeWidth, 0));
                shadow.cutHeight = strokeWidth;
              }
              if (group) {
                group.element.appendChild(shadow);
              } else if (element.parentNode) {
                element.parentNode.insertBefore(shadow, element);
              }
              shadows.push(shadow);
            }
            this.shadows = shadows;
          }
          return this;
        };
        SVGElement2.prototype.show = function(inherit) {
          return this.attr({ visibility: inherit ? "inherit" : "visible" });
        };
        SVGElement2.prototype.strokeSetter = function(value, key, element) {
          this[key] = value;
          if (this.stroke && this["stroke-width"]) {
            SVGElement2.prototype.fillSetter.call(this, this.stroke, "stroke", element);
            element.setAttribute("stroke-width", this["stroke-width"]);
            this.hasStroke = true;
          } else if (key === "stroke-width" && value === 0 && this.hasStroke) {
            element.removeAttribute("stroke");
            this.hasStroke = false;
          } else if (this.renderer.styledMode && this["stroke-width"]) {
            element.setAttribute("stroke-width", this["stroke-width"]);
            this.hasStroke = true;
          }
        };
        SVGElement2.prototype.strokeWidth = function() {
          if (!this.renderer.styledMode) {
            return this["stroke-width"] || 0;
          }
          var val = this.getStyle("stroke-width");
          var ret = 0, dummy;
          if (val.indexOf("px") === val.length - 2) {
            ret = pInt$7(val);
          } else if (val !== "") {
            dummy = doc$l.createElementNS(SVG_NS$2, "rect");
            attr$6(dummy, {
              width: val,
              "stroke-width": 0
            });
            this.element.parentNode.appendChild(dummy);
            ret = dummy.getBBox().width;
            dummy.parentNode.removeChild(dummy);
          }
          return ret;
        };
        SVGElement2.prototype.symbolAttr = function(hash2) {
          var wrapper = this;
          [
            "x",
            "y",
            "r",
            "start",
            "end",
            "width",
            "height",
            "innerR",
            "anchorX",
            "anchorY",
            "clockwise"
          ].forEach(function(key) {
            wrapper[key] = pick$1w(hash2[key], wrapper[key]);
          });
          wrapper.attr({
            d: wrapper.renderer.symbols[wrapper.symbolName](wrapper.x, wrapper.y, wrapper.width, wrapper.height, wrapper)
          });
        };
        SVGElement2.prototype.textSetter = function(value) {
          if (value !== this.textStr) {
            delete this.textPxLength;
            this.textStr = value;
            if (this.added) {
              this.renderer.buildText(this);
            }
          }
        };
        SVGElement2.prototype.titleSetter = function(value) {
          var el = this.element;
          var titleNode = el.getElementsByTagName("title")[0] || doc$l.createElementNS(this.SVG_NS, "title");
          if (el.insertBefore) {
            el.insertBefore(titleNode, el.firstChild);
          } else {
            el.appendChild(titleNode);
          }
          titleNode.textContent = // #3276, #3895
          String(pick$1w(value, "")).replace(/<[^>]*>/g, "").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
        };
        SVGElement2.prototype.toFront = function() {
          var element = this.element;
          element.parentNode.appendChild(element);
          return this;
        };
        SVGElement2.prototype.translate = function(x, y) {
          return this.attr({
            translateX: x,
            translateY: y
          });
        };
        SVGElement2.prototype.updateShadows = function(key, value, setter) {
          var shadows = this.shadows;
          if (shadows) {
            var i2 = shadows.length;
            while (i2--) {
              setter.call(shadows[i2], key === "height" ? Math.max(value - (shadows[i2].cutHeight || 0), 0) : key === "d" ? this.d : value, key, shadows[i2]);
            }
          }
        };
        SVGElement2.prototype.updateTransform = function() {
          var wrapper = this, scaleX = wrapper.scaleX, scaleY = wrapper.scaleY, inverted = wrapper.inverted, rotation = wrapper.rotation, matrix = wrapper.matrix, element = wrapper.element;
          var translateX = wrapper.translateX || 0, translateY = wrapper.translateY || 0;
          if (inverted) {
            translateX += wrapper.width;
            translateY += wrapper.height;
          }
          var transform2 = ["translate(" + translateX + "," + translateY + ")"];
          if (defined$T(matrix)) {
            transform2.push("matrix(" + matrix.join(",") + ")");
          }
          if (inverted) {
            transform2.push("rotate(90) scale(-1,1)");
          } else if (rotation) {
            transform2.push("rotate(" + rotation + " " + pick$1w(this.rotationOriginX, element.getAttribute("x"), 0) + " " + pick$1w(this.rotationOriginY, element.getAttribute("y") || 0) + ")");
          }
          if (defined$T(scaleX) || defined$T(scaleY)) {
            transform2.push("scale(" + pick$1w(scaleX, 1) + " " + pick$1w(scaleY, 1) + ")");
          }
          if (transform2.length) {
            element.setAttribute("transform", transform2.join(" "));
          }
        };
        SVGElement2.prototype.visibilitySetter = function(value, key, element) {
          if (value === "inherit") {
            element.removeAttribute(key);
          } else if (this[key] !== value) {
            element.setAttribute(key, value);
          }
          this[key] = value;
        };
        SVGElement2.prototype.xGetter = function(key) {
          if (this.element.nodeName === "circle") {
            if (key === "x") {
              key = "cx";
            } else if (key === "y") {
              key = "cy";
            }
          }
          return this._defaultGetter(key);
        };
        SVGElement2.prototype.zIndexSetter = function(value, key) {
          var renderer = this.renderer, parentGroup = this.parentGroup, parentWrapper = parentGroup || renderer, parentNode = parentWrapper.element || renderer.box, element = this.element, svgParent = parentNode === renderer.box;
          var childNodes, otherElement, otherZIndex, inserted = false, undefinedOtherZIndex, run = this.added, i2;
          if (defined$T(value)) {
            element.setAttribute("data-z-index", value);
            value = +value;
            if (this[key] === value) {
              run = false;
            }
          } else if (defined$T(this[key])) {
            element.removeAttribute("data-z-index");
          }
          this[key] = value;
          if (run) {
            value = this.zIndex;
            if (value && parentGroup) {
              parentGroup.handleZ = true;
            }
            childNodes = parentNode.childNodes;
            for (i2 = childNodes.length - 1; i2 >= 0 && !inserted; i2--) {
              otherElement = childNodes[i2];
              otherZIndex = otherElement.getAttribute("data-z-index");
              undefinedOtherZIndex = !defined$T(otherZIndex);
              if (otherElement !== element) {
                if (
                  // Negative zIndex versus no zIndex:
                  // On all levels except the highest. If the parent is
                  // <svg>, then we don't want to put items before <desc>
                  // or <defs>
                  value < 0 && undefinedOtherZIndex && !svgParent && !i2
                ) {
                  parentNode.insertBefore(element, childNodes[i2]);
                  inserted = true;
                } else if (
                  // Insert after the first element with a lower zIndex
                  pInt$7(otherZIndex) <= value || // If negative zIndex, add this before first undefined
                  // zIndex element
                  undefinedOtherZIndex && (!defined$T(value) || value >= 0)
                ) {
                  parentNode.insertBefore(
                    element,
                    childNodes[i2 + 1] || null
                    // null for oldIE export
                  );
                  inserted = true;
                }
              }
            }
            if (!inserted) {
              parentNode.insertBefore(
                element,
                childNodes[svgParent ? 3 : 0] || null
                // null for oldIE
              );
              inserted = true;
            }
          }
          return inserted;
        };
        return SVGElement2;
      }()
    );
    SVGElement.prototype["stroke-widthSetter"] = SVGElement.prototype.strokeSetter;
    SVGElement.prototype.yGetter = SVGElement.prototype.xGetter;
    SVGElement.prototype.matrixSetter = SVGElement.prototype.rotationOriginXSetter = SVGElement.prototype.rotationOriginYSetter = SVGElement.prototype.rotationSetter = SVGElement.prototype.scaleXSetter = SVGElement.prototype.scaleYSetter = SVGElement.prototype.translateXSetter = SVGElement.prototype.translateYSetter = SVGElement.prototype.verticalAlignSetter = function(value, key) {
      this[key] = value;
      this.doTransform = true;
    };
    var RendererRegistry;
    (function(RendererRegistry2) {
      RendererRegistry2.rendererTypes = {};
      var defaultRenderer;
      function getRendererType(rendererType) {
        if (rendererType === void 0) {
          rendererType = defaultRenderer;
        }
        return RendererRegistry2.rendererTypes[rendererType] || RendererRegistry2.rendererTypes[defaultRenderer];
      }
      RendererRegistry2.getRendererType = getRendererType;
      function registerRendererType(rendererType, rendererClass, setAsDefault) {
        RendererRegistry2.rendererTypes[rendererType] = rendererClass;
        if (!defaultRenderer || setAsDefault) {
          defaultRenderer = rendererType;
          H.Renderer = rendererClass;
        }
      }
      RendererRegistry2.registerRendererType = registerRendererType;
    })(RendererRegistry || (RendererRegistry = {}));
    const RendererRegistry$1 = RendererRegistry;
    var __extends$2e = /* @__PURE__ */ function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p5 in b3) if (b3.hasOwnProperty(p5)) d3[p5] = b3[p5];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var defined$S = Utilities.defined, extend$1r = Utilities.extend, isNumber$L = Utilities.isNumber, merge$1j = Utilities.merge, pick$1v = Utilities.pick, removeEvent$b = Utilities.removeEvent;
    var SVGLabel = (
      /** @class */
      function(_super) {
        __extends$2e(SVGLabel2, _super);
        function SVGLabel2(renderer, str, x, y, shape, anchorX, anchorY, useHTML, baseline, className) {
          var _this = _super.call(this) || this;
          _this.paddingLeftSetter = _this.paddingSetter;
          _this.paddingRightSetter = _this.paddingSetter;
          _this.init(renderer, "g");
          _this.textStr = str;
          _this.x = x;
          _this.y = y;
          _this.anchorX = anchorX;
          _this.anchorY = anchorY;
          _this.baseline = baseline;
          _this.className = className;
          _this.addClass(className === "button" ? "highcharts-no-tooltip" : "highcharts-label");
          if (className) {
            _this.addClass("highcharts-" + className);
          }
          _this.text = renderer.text(void 0, 0, 0, useHTML).attr({ zIndex: 1 });
          var hasBGImage;
          if (typeof shape === "string") {
            hasBGImage = /^url\((.*?)\)$/.test(shape);
            if (hasBGImage || _this.renderer.symbols[shape]) {
              _this.symbolKey = shape;
            }
          }
          _this.bBox = SVGLabel2.emptyBBox;
          _this.padding = 3;
          _this.baselineOffset = 0;
          _this.needsBox = renderer.styledMode || hasBGImage;
          _this.deferredAttr = {};
          _this.alignFactor = 0;
          return _this;
        }
        SVGLabel2.prototype.alignSetter = function(value) {
          var alignFactor = {
            left: 0,
            center: 0.5,
            right: 1
          }[value];
          if (alignFactor !== this.alignFactor) {
            this.alignFactor = alignFactor;
            if (this.bBox && isNumber$L(this.xSetting)) {
              this.attr({ x: this.xSetting });
            }
          }
        };
        SVGLabel2.prototype.anchorXSetter = function(value, key) {
          this.anchorX = value;
          this.boxAttr(key, Math.round(value) - this.getCrispAdjust() - this.xSetting);
        };
        SVGLabel2.prototype.anchorYSetter = function(value, key) {
          this.anchorY = value;
          this.boxAttr(key, value - this.ySetting);
        };
        SVGLabel2.prototype.boxAttr = function(key, value) {
          if (this.box) {
            this.box.attr(key, value);
          } else {
            this.deferredAttr[key] = value;
          }
        };
        SVGLabel2.prototype.css = function(styles) {
          if (styles) {
            var textStyles_1 = {};
            styles = merge$1j(styles);
            SVGLabel2.textProps.forEach(function(prop) {
              if (typeof styles[prop] !== "undefined") {
                textStyles_1[prop] = styles[prop];
                delete styles[prop];
              }
            });
            this.text.css(textStyles_1);
            var isWidth = "width" in textStyles_1, isFontStyle = "fontSize" in textStyles_1 || "fontWeight" in textStyles_1;
            if (isFontStyle) {
              this.updateTextPadding();
            } else if (isWidth) {
              this.updateBoxSize();
            }
          }
          return SVGElement.prototype.css.call(this, styles);
        };
        SVGLabel2.prototype.destroy = function() {
          removeEvent$b(this.element, "mouseenter");
          removeEvent$b(this.element, "mouseleave");
          if (this.text) {
            this.text.destroy();
          }
          if (this.box) {
            this.box = this.box.destroy();
          }
          SVGElement.prototype.destroy.call(this);
          return void 0;
        };
        SVGLabel2.prototype.fillSetter = function(value, key) {
          if (value) {
            this.needsBox = true;
          }
          this.fill = value;
          this.boxAttr(key, value);
        };
        SVGLabel2.prototype.getBBox = function() {
          if (this.textStr && this.bBox.width === 0 && this.bBox.height === 0) {
            this.updateBoxSize();
          }
          var padding = this.padding;
          var paddingLeft = pick$1v(this.paddingLeft, padding);
          return {
            width: this.width,
            height: this.height,
            x: this.bBox.x - paddingLeft,
            y: this.bBox.y - padding
          };
        };
        SVGLabel2.prototype.getCrispAdjust = function() {
          return this.renderer.styledMode && this.box ? this.box.strokeWidth() % 2 / 2 : (this["stroke-width"] ? parseInt(this["stroke-width"], 10) : 0) % 2 / 2;
        };
        SVGLabel2.prototype.heightSetter = function(value) {
          this.heightSetting = value;
        };
        SVGLabel2.prototype.onAdd = function() {
          var str = this.textStr;
          this.text.add(this);
          this.attr({
            // Alignment is available now  (#3295, 0 not rendered if given
            // as a value)
            text: defined$S(str) ? str : "",
            x: this.x,
            y: this.y
          });
          if (this.box && defined$S(this.anchorX)) {
            this.attr({
              anchorX: this.anchorX,
              anchorY: this.anchorY
            });
          }
        };
        SVGLabel2.prototype.paddingSetter = function(value, key) {
          if (!isNumber$L(value)) {
            this[key] = void 0;
          } else if (value !== this[key]) {
            this[key] = value;
            this.updateTextPadding();
          }
        };
        SVGLabel2.prototype.rSetter = function(value, key) {
          this.boxAttr(key, value);
        };
        SVGLabel2.prototype.shadow = function(b2) {
          if (b2 && !this.renderer.styledMode) {
            this.updateBoxSize();
            if (this.box) {
              this.box.shadow(b2);
            }
          }
          return this;
        };
        SVGLabel2.prototype.strokeSetter = function(value, key) {
          this.stroke = value;
          this.boxAttr(key, value);
        };
        SVGLabel2.prototype["stroke-widthSetter"] = function(value, key) {
          if (value) {
            this.needsBox = true;
          }
          this["stroke-width"] = value;
          this.boxAttr(key, value);
        };
        SVGLabel2.prototype["text-alignSetter"] = function(value) {
          this.textAlign = value;
        };
        SVGLabel2.prototype.textSetter = function(text) {
          if (typeof text !== "undefined") {
            this.text.attr({ text });
          }
          this.updateTextPadding();
        };
        SVGLabel2.prototype.updateBoxSize = function() {
          var style = this.text.element.style, attribs = {}, padding = this.padding, bBox = this.bBox = (!isNumber$L(this.widthSetting) || !isNumber$L(this.heightSetting) || this.textAlign) && defined$S(this.text.textStr) ? this.text.getBBox() : SVGLabel2.emptyBBox;
          var crispAdjust;
          this.width = this.getPaddedWidth();
          this.height = (this.heightSetting || bBox.height || 0) + 2 * padding;
          var metrics = this.renderer.fontMetrics(style && style.fontSize, this.text);
          this.baselineOffset = padding + Math.min(
            // When applicable, use the font size of the first line (#15707)
            (this.text.firstLineMetrics || metrics).b,
            // When the height is 0, there is no bBox, so go with the font
            // metrics. Highmaps CSS demos.
            bBox.height || Infinity
          );
          if (this.heightSetting) {
            this.baselineOffset += (this.heightSetting - metrics.h) / 2;
          }
          if (this.needsBox) {
            if (!this.box) {
              var box = this.box = this.symbolKey ? this.renderer.symbol(this.symbolKey) : this.renderer.rect();
              box.addClass(
                // Don't use label className for buttons
                (this.className === "button" ? "" : "highcharts-label-box") + (this.className ? " highcharts-" + this.className + "-box" : "")
              );
              box.add(this);
            }
            crispAdjust = this.getCrispAdjust();
            attribs.x = crispAdjust;
            attribs.y = (this.baseline ? -this.baselineOffset : 0) + crispAdjust;
            attribs.width = Math.round(this.width);
            attribs.height = Math.round(this.height);
            this.box.attr(extend$1r(attribs, this.deferredAttr));
            this.deferredAttr = {};
          }
        };
        SVGLabel2.prototype.updateTextPadding = function() {
          var text = this.text;
          this.updateBoxSize();
          var textY = this.baseline ? 0 : this.baselineOffset;
          var textX = pick$1v(this.paddingLeft, this.padding);
          if (defined$S(this.widthSetting) && this.bBox && (this.textAlign === "center" || this.textAlign === "right")) {
            textX += { center: 0.5, right: 1 }[this.textAlign] * (this.widthSetting - this.bBox.width);
          }
          if (textX !== text.x || textY !== text.y) {
            text.attr("x", textX);
            if (text.hasBoxWidthChanged) {
              this.bBox = text.getBBox(true);
            }
            if (typeof textY !== "undefined") {
              text.attr("y", textY);
            }
          }
          text.x = textX;
          text.y = textY;
        };
        SVGLabel2.prototype.widthSetter = function(value) {
          this.widthSetting = isNumber$L(value) ? value : void 0;
        };
        SVGLabel2.prototype.getPaddedWidth = function() {
          var padding = this.padding;
          var paddingLeft = pick$1v(this.paddingLeft, padding);
          var paddingRight = pick$1v(this.paddingRight, padding);
          return (this.widthSetting || this.bBox.width || 0) + paddingLeft + paddingRight;
        };
        SVGLabel2.prototype.xSetter = function(value) {
          this.x = value;
          if (this.alignFactor) {
            value -= this.alignFactor * this.getPaddedWidth();
            this["forceAnimate:x"] = true;
          }
          this.xSetting = Math.round(value);
          this.attr("translateX", this.xSetting);
        };
        SVGLabel2.prototype.ySetter = function(value) {
          this.ySetting = this.y = Math.round(value);
          this.attr("translateY", this.ySetting);
        };
        SVGLabel2.emptyBBox = { width: 0, height: 0, x: 0, y: 0 };
        SVGLabel2.textProps = [
          "color",
          "direction",
          "fontFamily",
          "fontSize",
          "fontStyle",
          "fontWeight",
          "lineHeight",
          "textAlign",
          "textDecoration",
          "textOutline",
          "textOverflow",
          "width"
        ];
        return SVGLabel2;
      }(SVGElement)
    );
    var defined$R = Utilities.defined, isNumber$K = Utilities.isNumber, pick$1u = Utilities.pick;
    function arc$1(x, y, w2, h2, options) {
      var arc2 = [];
      if (options) {
        var start2 = options.start || 0, rx = pick$1u(options.r, w2), ry = pick$1u(options.r, h2 || w2), proximity = 1e-3, fullCircle = Math.abs((options.end || 0) - start2 - 2 * Math.PI) < proximity, end = (options.end || 0) - proximity, innerRadius = options.innerR, open_1 = pick$1u(options.open, fullCircle), cosStart = Math.cos(start2), sinStart = Math.sin(start2), cosEnd = Math.cos(end), sinEnd = Math.sin(end), longArc = pick$1u(options.longArc, end - start2 - Math.PI < proximity ? 0 : 1);
        arc2.push([
          "M",
          x + rx * cosStart,
          y + ry * sinStart
        ], [
          "A",
          rx,
          ry,
          0,
          longArc,
          pick$1u(options.clockwise, 1),
          x + rx * cosEnd,
          y + ry * sinEnd
        ]);
        if (defined$R(innerRadius)) {
          arc2.push(open_1 ? [
            "M",
            x + innerRadius * cosEnd,
            y + innerRadius * sinEnd
          ] : [
            "L",
            x + innerRadius * cosEnd,
            y + innerRadius * sinEnd
          ], [
            "A",
            innerRadius,
            innerRadius,
            0,
            longArc,
            // Clockwise - opposite to the outer arc clockwise
            defined$R(options.clockwise) ? 1 - options.clockwise : 0,
            x + innerRadius * cosStart,
            y + innerRadius * sinStart
          ]);
        }
        if (!open_1) {
          arc2.push(["Z"]);
        }
      }
      return arc2;
    }
    function callout(x, y, w2, h2, options) {
      var arrowLength = 6, halfDistance = 6, r2 = Math.min(options && options.r || 0, w2, h2), safeDistance = r2 + halfDistance, anchorX = options && options.anchorX, anchorY = options && options.anchorY || 0;
      var path = roundedRect(x, y, w2, h2, { r: r2 });
      if (!isNumber$K(anchorX)) {
        return path;
      }
      if (x + anchorX >= w2) {
        if (anchorY > y + safeDistance && anchorY < y + h2 - safeDistance) {
          path.splice(3, 1, ["L", x + w2, anchorY - halfDistance], ["L", x + w2 + arrowLength, anchorY], ["L", x + w2, anchorY + halfDistance], ["L", x + w2, y + h2 - r2]);
        } else {
          path.splice(3, 1, ["L", x + w2, h2 / 2], ["L", anchorX, anchorY], ["L", x + w2, h2 / 2], ["L", x + w2, y + h2 - r2]);
        }
      } else if (x + anchorX <= 0) {
        if (anchorY > y + safeDistance && anchorY < y + h2 - safeDistance) {
          path.splice(7, 1, ["L", x, anchorY + halfDistance], ["L", x - arrowLength, anchorY], ["L", x, anchorY - halfDistance], ["L", x, y + r2]);
        } else {
          path.splice(7, 1, ["L", x, h2 / 2], ["L", anchorX, anchorY], ["L", x, h2 / 2], ["L", x, y + r2]);
        }
      } else if (
        // replace bottom
        anchorY && anchorY > h2 && anchorX > x + safeDistance && anchorX < x + w2 - safeDistance
      ) {
        path.splice(5, 1, ["L", anchorX + halfDistance, y + h2], ["L", anchorX, y + h2 + arrowLength], ["L", anchorX - halfDistance, y + h2], ["L", x + r2, y + h2]);
      } else if (
        // replace top
        anchorY && anchorY < 0 && anchorX > x + safeDistance && anchorX < x + w2 - safeDistance
      ) {
        path.splice(1, 1, ["L", anchorX - halfDistance, y], ["L", anchorX, y - arrowLength], ["L", anchorX + halfDistance, y], ["L", w2 - r2, y]);
      }
      return path;
    }
    function circle(x, y, w2, h2) {
      return arc$1(x + w2 / 2, y + h2 / 2, w2 / 2, h2 / 2, {
        start: Math.PI * 0.5,
        end: Math.PI * 2.5,
        open: false
      });
    }
    function diamond(x, y, w2, h2) {
      return [
        ["M", x + w2 / 2, y],
        ["L", x + w2, y + h2 / 2],
        ["L", x + w2 / 2, y + h2],
        ["L", x, y + h2 / 2],
        ["Z"]
      ];
    }
    function rect(x, y, w2, h2, options) {
      if (options && options.r) {
        return roundedRect(x, y, w2, h2, options);
      }
      return [
        ["M", x, y],
        ["L", x + w2, y],
        ["L", x + w2, y + h2],
        ["L", x, y + h2],
        ["Z"]
      ];
    }
    function roundedRect(x, y, w2, h2, options) {
      var r2 = options && options.r || 0;
      return [
        ["M", x + r2, y],
        ["L", x + w2 - r2, y],
        ["C", x + w2, y, x + w2, y, x + w2, y + r2],
        ["L", x + w2, y + h2 - r2],
        ["C", x + w2, y + h2, x + w2, y + h2, x + w2 - r2, y + h2],
        ["L", x + r2, y + h2],
        ["C", x, y + h2, x, y + h2, x, y + h2 - r2],
        ["L", x, y + r2],
        ["C", x, y, x, y, x + r2, y]
        // top-left corner
      ];
    }
    function triangle(x, y, w2, h2) {
      return [
        ["M", x + w2 / 2, y],
        ["L", x + w2, y + h2],
        ["L", x, y + h2],
        ["Z"]
      ];
    }
    function triangleDown(x, y, w2, h2) {
      return [
        ["M", x, y],
        ["L", x + w2, y],
        ["L", x + w2 / 2, y + h2],
        ["Z"]
      ];
    }
    var Symbols = {
      arc: arc$1,
      callout,
      circle,
      diamond,
      rect,
      roundedRect,
      square: rect,
      triangle,
      "triangle-down": triangleDown
    };
    var doc$k = H.doc, SVG_NS$1 = H.SVG_NS;
    var attr$5 = Utilities.attr, isString$9 = Utilities.isString, objectEach$v = Utilities.objectEach, pick$1t = Utilities.pick;
    var TextBuilder = (
      /** @class */
      function() {
        function TextBuilder2(svgElement) {
          var textStyles = svgElement.styles;
          this.renderer = svgElement.renderer;
          this.svgElement = svgElement;
          this.width = svgElement.textWidth;
          this.textLineHeight = textStyles && textStyles.lineHeight;
          this.textOutline = textStyles && textStyles.textOutline;
          this.ellipsis = Boolean(textStyles && textStyles.textOverflow === "ellipsis");
          this.noWrap = Boolean(textStyles && textStyles.whiteSpace === "nowrap");
          this.fontSize = textStyles && textStyles.fontSize;
        }
        TextBuilder2.prototype.buildSVG = function() {
          var wrapper = this.svgElement, textNode = wrapper.element, renderer = wrapper.renderer, textStr = pick$1t(wrapper.textStr, "").toString(), hasMarkup = textStr.indexOf("<") !== -1, childNodes = textNode.childNodes, tempParent = this.width && !wrapper.added && renderer.box, regexMatchBreaks = /<br.*?>/g, textCache = [
            textStr,
            this.ellipsis,
            this.noWrap,
            this.textLineHeight,
            this.textOutline,
            this.fontSize,
            this.width
          ].join(",");
          if (textCache === wrapper.textCache) {
            return;
          }
          wrapper.textCache = textCache;
          delete wrapper.actualWidth;
          for (var i2 = childNodes.length; i2--; ) {
            textNode.removeChild(childNodes[i2]);
          }
          if (!hasMarkup && !this.ellipsis && !this.width && (textStr.indexOf(" ") === -1 || this.noWrap && !regexMatchBreaks.test(textStr))) {
            textNode.appendChild(doc$k.createTextNode(this.unescapeEntities(textStr)));
          } else if (textStr !== "") {
            if (tempParent) {
              tempParent.appendChild(textNode);
            }
            var ast = new AST(textStr);
            this.modifyTree(ast.nodes);
            ast.addToDOM(wrapper.element);
            this.modifyDOM();
            if (this.ellipsis && (textNode.textContent || "").indexOf("…") !== -1) {
              wrapper.attr(
                "title",
                this.unescapeEntities(wrapper.textStr || "", ["&lt;", "&gt;"])
                // #7179
              );
            }
            if (tempParent) {
              tempParent.removeChild(textNode);
            }
          }
          if (isString$9(this.textOutline) && wrapper.applyTextOutline) {
            wrapper.applyTextOutline(this.textOutline);
          }
        };
        TextBuilder2.prototype.modifyDOM = function() {
          var _this = this;
          var wrapper = this.svgElement;
          var x = attr$5(wrapper.element, "x");
          wrapper.firstLineMetrics = void 0;
          var firstChild;
          while (firstChild = wrapper.element.firstChild) {
            if (/^[\s\u200B]*$/.test(firstChild.textContent || " ")) {
              wrapper.element.removeChild(firstChild);
            } else {
              break;
            }
          }
          [].forEach.call(wrapper.element.querySelectorAll("tspan.highcharts-br"), function(br, i2) {
            if (br.nextSibling && br.previousSibling) {
              if (i2 === 0 && br.previousSibling.nodeType === 1) {
                wrapper.firstLineMetrics = wrapper.renderer.fontMetrics(void 0, br.previousSibling);
              }
              attr$5(br, {
                // Since the break is inserted in front of the next
                // line, we need to use the next sibling for the line
                // height
                dy: _this.getLineHeight(br.nextSibling),
                x
              });
            }
          });
          var width = this.width || 0;
          if (!width) {
            return;
          }
          var modifyTextNode = function(textNode, parentElement) {
            var text = textNode.textContent || "";
            var words = text.replace(/([^\^])-/g, "$1- ").split(" ");
            var hasWhiteSpace = !_this.noWrap && (words.length > 1 || wrapper.element.childNodes.length > 1);
            var dy = _this.getLineHeight(parentElement);
            var lineNo = 0;
            var startAt = wrapper.actualWidth;
            if (_this.ellipsis) {
              if (text) {
                _this.truncate(
                  textNode,
                  text,
                  void 0,
                  0,
                  // Target width
                  Math.max(
                    0,
                    // Substract the font face to make room for the
                    // ellipsis itself
                    width - parseInt(_this.fontSize || 12, 10)
                  ),
                  // Build the text to test for
                  function(text2, currentIndex) {
                    return text2.substring(0, currentIndex) + "…";
                  }
                );
              }
            } else if (hasWhiteSpace) {
              var lines = [];
              var precedingSiblings = [];
              while (parentElement.firstChild && parentElement.firstChild !== textNode) {
                precedingSiblings.push(parentElement.firstChild);
                parentElement.removeChild(parentElement.firstChild);
              }
              while (words.length) {
                if (words.length && !_this.noWrap && lineNo > 0) {
                  lines.push(textNode.textContent || "");
                  textNode.textContent = words.join(" ").replace(/- /g, "-");
                }
                _this.truncate(
                  textNode,
                  void 0,
                  words,
                  lineNo === 0 ? startAt || 0 : 0,
                  width,
                  // Build the text to test for
                  function(t2, currentIndex) {
                    return words.slice(0, currentIndex).join(" ").replace(/- /g, "-");
                  }
                );
                startAt = wrapper.actualWidth;
                lineNo++;
              }
              precedingSiblings.forEach(function(childNode) {
                parentElement.insertBefore(childNode, textNode);
              });
              lines.forEach(function(line) {
                parentElement.insertBefore(doc$k.createTextNode(line), textNode);
                var br = doc$k.createElementNS(SVG_NS$1, "tspan");
                br.textContent = "​";
                attr$5(br, { dy, x });
                parentElement.insertBefore(br, textNode);
              });
            }
          };
          var modifyChildren = function(node) {
            var childNodes = [].slice.call(node.childNodes);
            childNodes.forEach(function(childNode) {
              if (childNode.nodeType === Node.TEXT_NODE) {
                modifyTextNode(childNode, node);
              } else {
                if (childNode.className.baseVal.indexOf("highcharts-br") !== -1) {
                  wrapper.actualWidth = 0;
                }
                modifyChildren(childNode);
              }
            });
          };
          modifyChildren(wrapper.element);
        };
        TextBuilder2.prototype.getLineHeight = function(node) {
          var fontSizeStyle;
          var element = node.nodeType === Node.TEXT_NODE ? node.parentElement : node;
          if (!this.renderer.styledMode) {
            fontSizeStyle = element && /(px|em)$/.test(element.style.fontSize) ? element.style.fontSize : this.fontSize || this.renderer.style.fontSize || 12;
          }
          return this.textLineHeight ? parseInt(this.textLineHeight.toString(), 10) : this.renderer.fontMetrics(fontSizeStyle, element || this.svgElement.element).h;
        };
        TextBuilder2.prototype.modifyTree = function(nodes) {
          var _this = this;
          var modifyChild = function(node, i2) {
            var tagName = node.tagName;
            var styledMode = _this.renderer.styledMode;
            var attributes = node.attributes || {};
            if (tagName === "b" || tagName === "strong") {
              if (styledMode) {
                attributes["class"] = "highcharts-strong";
              } else {
                attributes.style = "font-weight:bold;" + (attributes.style || "");
              }
            } else if (tagName === "i" || tagName === "em") {
              if (styledMode) {
                attributes["class"] = "highcharts-emphasized";
              } else {
                attributes.style = "font-style:italic;" + (attributes.style || "");
              }
            }
            if (isString$9(attributes.style)) {
              attributes.style = attributes.style.replace(/(;| |^)color([ :])/, "$1fill$2");
            }
            if (tagName === "br") {
              attributes["class"] = "highcharts-br";
              node.textContent = "​";
              var nextNode = nodes[i2 + 1];
              if (nextNode && nextNode.textContent) {
                nextNode.textContent = nextNode.textContent.replace(/^ +/gm, "");
              }
            }
            if (tagName !== "#text" && tagName !== "a") {
              node.tagName = "tspan";
            }
            node.attributes = attributes;
            if (node.children) {
              node.children.filter(function(c2) {
                return c2.tagName !== "#text";
              }).forEach(modifyChild);
            }
          };
          nodes.forEach(modifyChild);
        };
        TextBuilder2.prototype.truncate = function(textNode, text, words, startAt, width, getString) {
          var svgElement = this.svgElement;
          var renderer = svgElement.renderer, rotation = svgElement.rotation;
          var lengths = [];
          var minIndex = words ? 1 : 0;
          var maxIndex = (text || words || "").length;
          var currentIndex = maxIndex;
          var str;
          var actualWidth;
          var getSubStringLength = function(charEnd, concatenatedEnd) {
            var end = concatenatedEnd || charEnd;
            var parentNode = textNode.parentNode;
            if (parentNode && typeof lengths[end] === "undefined") {
              if (parentNode.getSubStringLength) {
                try {
                  lengths[end] = startAt + parentNode.getSubStringLength(0, words ? end + 1 : end);
                } catch (e2) {
                }
              } else if (renderer.getSpanWidth) {
                textNode.textContent = getString(text || words, charEnd);
                lengths[end] = startAt + renderer.getSpanWidth(svgElement, textNode);
              }
            }
            return lengths[end];
          };
          svgElement.rotation = 0;
          actualWidth = getSubStringLength(textNode.textContent.length);
          if (startAt + actualWidth > width) {
            while (minIndex <= maxIndex) {
              currentIndex = Math.ceil((minIndex + maxIndex) / 2);
              if (words) {
                str = getString(words, currentIndex);
              }
              actualWidth = getSubStringLength(currentIndex, str && str.length - 1);
              if (minIndex === maxIndex) {
                minIndex = maxIndex + 1;
              } else if (actualWidth > width) {
                maxIndex = currentIndex - 1;
              } else {
                minIndex = currentIndex;
              }
            }
            if (maxIndex === 0) {
              textNode.textContent = "";
            } else if (!(text && maxIndex === text.length - 1)) {
              textNode.textContent = str || getString(text || words, currentIndex);
            }
          }
          if (words) {
            words.splice(0, currentIndex);
          }
          svgElement.actualWidth = actualWidth;
          svgElement.rotation = rotation;
        };
        TextBuilder2.prototype.unescapeEntities = function(inputStr, except) {
          objectEach$v(this.renderer.escapes, function(value, key) {
            if (!except || except.indexOf(value) === -1) {
              inputStr = inputStr.toString().replace(new RegExp(value, "g"), key);
            }
          });
          return inputStr;
        };
        return TextBuilder2;
      }()
    );
    var charts$4 = H.charts, deg2rad$7 = H.deg2rad, doc$j = H.doc, isFirefox$3 = H.isFirefox, isMS$2 = H.isMS, isWebKit$1 = H.isWebKit, noop$k = H.noop, SVG_NS = H.SVG_NS, symbolSizes = H.symbolSizes, win$c = H.win;
    var addEvent$10 = Utilities.addEvent, attr$4 = Utilities.attr, createElement$8 = Utilities.createElement, css$b = Utilities.css, defined$Q = Utilities.defined, destroyObjectProperties$9 = Utilities.destroyObjectProperties, extend$1q = Utilities.extend, isArray$k = Utilities.isArray, isNumber$J = Utilities.isNumber, isObject$c = Utilities.isObject, isString$8 = Utilities.isString, merge$1i = Utilities.merge, pick$1s = Utilities.pick, pInt$6 = Utilities.pInt, uniqueKey$6 = Utilities.uniqueKey;
    var hasInternalReferenceBug;
    var SVGRenderer = (
      /** @class */
      function() {
        function SVGRenderer2(container, width, height, style, forExport, allowHTML, styledMode) {
          this.alignedObjects = void 0;
          this.box = void 0;
          this.boxWrapper = void 0;
          this.cache = void 0;
          this.cacheKeys = void 0;
          this.chartIndex = void 0;
          this.defs = void 0;
          this.globalAnimation = void 0;
          this.gradients = void 0;
          this.height = void 0;
          this.imgCount = void 0;
          this.isSVG = void 0;
          this.style = void 0;
          this.url = void 0;
          this.width = void 0;
          this.init(container, width, height, style, forExport, allowHTML, styledMode);
        }
        SVGRenderer2.prototype.init = function(container, width, height, style, forExport, allowHTML, styledMode) {
          var renderer = this, boxWrapper = renderer.createElement("svg").attr({
            version: "1.1",
            "class": "highcharts-root"
          }), element = boxWrapper.element;
          if (!styledMode) {
            boxWrapper.css(this.getStyle(style));
          }
          container.appendChild(element);
          attr$4(container, "dir", "ltr");
          if (container.innerHTML.indexOf("xmlns") === -1) {
            attr$4(element, "xmlns", this.SVG_NS);
          }
          renderer.isSVG = true;
          this.box = element;
          this.boxWrapper = boxWrapper;
          renderer.alignedObjects = [];
          this.url = this.getReferenceURL();
          var desc = this.createElement("desc").add();
          desc.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2"));
          renderer.defs = this.createElement("defs").add();
          renderer.allowHTML = allowHTML;
          renderer.forExport = forExport;
          renderer.styledMode = styledMode;
          renderer.gradients = {};
          renderer.cache = {};
          renderer.cacheKeys = [];
          renderer.imgCount = 0;
          renderer.setSize(width, height, false);
          var subPixelFix, rect2;
          if (isFirefox$3 && container.getBoundingClientRect) {
            subPixelFix = function() {
              css$b(container, { left: 0, top: 0 });
              rect2 = container.getBoundingClientRect();
              css$b(container, {
                left: Math.ceil(rect2.left) - rect2.left + "px",
                top: Math.ceil(rect2.top) - rect2.top + "px"
              });
            };
            subPixelFix();
            renderer.unSubPixelFix = addEvent$10(win$c, "resize", subPixelFix);
          }
        };
        SVGRenderer2.prototype.definition = function(def) {
          var ast = new AST([def]);
          return ast.addToDOM(this.defs.element);
        };
        SVGRenderer2.prototype.getReferenceURL = function() {
          if ((isFirefox$3 || isWebKit$1) && doc$j.getElementsByTagName("base").length) {
            if (!defined$Q(hasInternalReferenceBug)) {
              var id = uniqueKey$6();
              var ast = new AST([{
                tagName: "svg",
                attributes: {
                  width: 8,
                  height: 8
                },
                children: [{
                  tagName: "defs",
                  children: [{
                    tagName: "clipPath",
                    attributes: {
                      id
                    },
                    children: [{
                      tagName: "rect",
                      attributes: {
                        width: 4,
                        height: 4
                      }
                    }]
                  }]
                }, {
                  tagName: "rect",
                  attributes: {
                    id: "hitme",
                    width: 8,
                    height: 8,
                    "clip-path": "url(#" + id + ")",
                    fill: "rgba(0,0,0,0.001)"
                  }
                }]
              }]);
              var svg2 = ast.addToDOM(doc$j.body);
              css$b(svg2, {
                position: "fixed",
                top: 0,
                left: 0,
                zIndex: 9e5
              });
              var hitElement = doc$j.elementFromPoint(6, 6);
              hasInternalReferenceBug = (hitElement && hitElement.id) === "hitme";
              doc$j.body.removeChild(svg2);
            }
            if (hasInternalReferenceBug) {
              return win$c.location.href.split("#")[0].replace(/<[^>]*>/g, "").replace(/([\('\)])/g, "\\$1").replace(/ /g, "%20");
            }
          }
          return "";
        };
        SVGRenderer2.prototype.getStyle = function(style) {
          this.style = extend$1q({
            fontFamily: '"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
            fontSize: "12px"
          }, style);
          return this.style;
        };
        SVGRenderer2.prototype.setStyle = function(style) {
          this.boxWrapper.css(this.getStyle(style));
        };
        SVGRenderer2.prototype.isHidden = function() {
          return !this.boxWrapper.getBBox().width;
        };
        SVGRenderer2.prototype.destroy = function() {
          var renderer = this, rendererDefs = renderer.defs;
          renderer.box = null;
          renderer.boxWrapper = renderer.boxWrapper.destroy();
          destroyObjectProperties$9(renderer.gradients || {});
          renderer.gradients = null;
          if (rendererDefs) {
            renderer.defs = rendererDefs.destroy();
          }
          if (renderer.unSubPixelFix) {
            renderer.unSubPixelFix();
          }
          renderer.alignedObjects = null;
          return null;
        };
        SVGRenderer2.prototype.createElement = function(nodeName) {
          var wrapper = new this.Element();
          wrapper.init(this, nodeName);
          return wrapper;
        };
        SVGRenderer2.prototype.getRadialAttr = function(radialReference, gradAttr) {
          return {
            cx: radialReference[0] - radialReference[2] / 2 + (gradAttr.cx || 0) * radialReference[2],
            cy: radialReference[1] - radialReference[2] / 2 + (gradAttr.cy || 0) * radialReference[2],
            r: (gradAttr.r || 0) * radialReference[2]
          };
        };
        SVGRenderer2.prototype.buildText = function(wrapper) {
          new TextBuilder(wrapper).buildSVG();
        };
        SVGRenderer2.prototype.getContrast = function(rgba) {
          rgba = Color.parse(rgba).rgba;
          rgba[0] *= 1;
          rgba[1] *= 1.2;
          rgba[2] *= 0.5;
          return rgba[0] + rgba[1] + rgba[2] > 1.8 * 255 ? "#000000" : "#FFFFFF";
        };
        SVGRenderer2.prototype.button = function(text, x, y, callback, theme2, hoverState, pressedState, disabledState, shape, useHTML) {
          var label = this.label(text, x, y, shape, void 0, void 0, useHTML, void 0, "button"), styledMode = this.styledMode;
          var curState = 0, normalState = theme2 ? merge$1i(theme2) : {};
          var userNormalStyle = normalState && normalState.style || {};
          normalState = AST.filterUserAttributes(normalState);
          label.attr(merge$1i({ padding: 8, r: 2 }, normalState));
          var normalStyle, hoverStyle, pressedStyle, disabledStyle;
          if (!styledMode) {
            normalState = merge$1i({
              fill: palette.neutralColor3,
              stroke: palette.neutralColor20,
              "stroke-width": 1,
              style: {
                color: palette.neutralColor80,
                cursor: "pointer",
                fontWeight: "normal"
              }
            }, {
              style: userNormalStyle
            }, normalState);
            normalStyle = normalState.style;
            delete normalState.style;
            hoverState = merge$1i(normalState, {
              fill: palette.neutralColor10
            }, AST.filterUserAttributes(hoverState || {}));
            hoverStyle = hoverState.style;
            delete hoverState.style;
            pressedState = merge$1i(normalState, {
              fill: palette.highlightColor10,
              style: {
                color: palette.neutralColor100,
                fontWeight: "bold"
              }
            }, AST.filterUserAttributes(pressedState || {}));
            pressedStyle = pressedState.style;
            delete pressedState.style;
            disabledState = merge$1i(normalState, {
              style: {
                color: palette.neutralColor20
              }
            }, AST.filterUserAttributes(disabledState || {}));
            disabledStyle = disabledState.style;
            delete disabledState.style;
          }
          addEvent$10(label.element, isMS$2 ? "mouseover" : "mouseenter", function() {
            if (curState !== 3) {
              label.setState(1);
            }
          });
          addEvent$10(label.element, isMS$2 ? "mouseout" : "mouseleave", function() {
            if (curState !== 3) {
              label.setState(curState);
            }
          });
          label.setState = function(state) {
            if (state !== 1) {
              label.state = curState = state;
            }
            label.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-" + ["normal", "hover", "pressed", "disabled"][state || 0]);
            if (!styledMode) {
              label.attr([
                normalState,
                hoverState,
                pressedState,
                disabledState
              ][state || 0]).css([
                normalStyle,
                hoverStyle,
                pressedStyle,
                disabledStyle
              ][state || 0]);
            }
          };
          if (!styledMode) {
            label.attr(normalState).css(extend$1q({ cursor: "default" }, normalStyle));
          }
          return label.on("touchstart", function(e2) {
            return e2.stopPropagation();
          }).on("click", function(e2) {
            if (curState !== 3) {
              callback.call(label, e2);
            }
          });
        };
        SVGRenderer2.prototype.crispLine = function(points, width, roundingFunction) {
          if (roundingFunction === void 0) {
            roundingFunction = "round";
          }
          var start2 = points[0];
          var end = points[1];
          if (defined$Q(start2[1]) && start2[1] === end[1]) {
            start2[1] = end[1] = Math[roundingFunction](start2[1]) - width % 2 / 2;
          }
          if (defined$Q(start2[2]) && start2[2] === end[2]) {
            start2[2] = end[2] = Math[roundingFunction](start2[2]) + width % 2 / 2;
          }
          return points;
        };
        SVGRenderer2.prototype.path = function(path) {
          var attribs = this.styledMode ? {} : {
            fill: "none"
          };
          if (isArray$k(path)) {
            attribs.d = path;
          } else if (isObject$c(path)) {
            extend$1q(attribs, path);
          }
          return this.createElement("path").attr(attribs);
        };
        SVGRenderer2.prototype.circle = function(x, y, r2) {
          var attribs = isObject$c(x) ? x : typeof x === "undefined" ? {} : { x, y, r: r2 }, wrapper = this.createElement("circle");
          wrapper.xSetter = wrapper.ySetter = function(value, key, element) {
            element.setAttribute("c" + key, value);
          };
          return wrapper.attr(attribs);
        };
        SVGRenderer2.prototype.arc = function(x, y, r2, innerR, start2, end) {
          var options;
          if (isObject$c(x)) {
            options = x;
            y = options.y;
            r2 = options.r;
            innerR = options.innerR;
            start2 = options.start;
            end = options.end;
            x = options.x;
          } else {
            options = { innerR, start: start2, end };
          }
          var arc2 = this.symbol("arc", x, y, r2, r2, options);
          arc2.r = r2;
          return arc2;
        };
        SVGRenderer2.prototype.rect = function(x, y, width, height, r2, strokeWidth) {
          r2 = isObject$c(x) ? x.r : r2;
          var wrapper = this.createElement("rect");
          var attribs = isObject$c(x) ? x : typeof x === "undefined" ? {} : {
            x,
            y,
            width: Math.max(width, 0),
            height: Math.max(height, 0)
          };
          if (!this.styledMode) {
            if (typeof strokeWidth !== "undefined") {
              attribs["stroke-width"] = strokeWidth;
              attribs = wrapper.crisp(attribs);
            }
            attribs.fill = "none";
          }
          if (r2) {
            attribs.r = r2;
          }
          wrapper.rSetter = function(value, _key, element) {
            wrapper.r = value;
            attr$4(element, {
              rx: value,
              ry: value
            });
          };
          wrapper.rGetter = function() {
            return wrapper.r || 0;
          };
          return wrapper.attr(attribs);
        };
        SVGRenderer2.prototype.setSize = function(width, height, animate2) {
          var renderer = this;
          renderer.width = width;
          renderer.height = height;
          renderer.boxWrapper.animate({
            width,
            height
          }, {
            step: function() {
              this.attr({
                viewBox: "0 0 " + this.attr("width") + " " + this.attr("height")
              });
            },
            duration: pick$1s(animate2, true) ? void 0 : 0
          });
          renderer.alignElements();
        };
        SVGRenderer2.prototype.g = function(name) {
          var elem = this.createElement("g");
          return name ? elem.attr({ "class": "highcharts-" + name }) : elem;
        };
        SVGRenderer2.prototype.image = function(src, x, y, width, height, onload) {
          var attribs = { preserveAspectRatio: "none" }, setSVGImageSource = function(el, src2) {
            if (el.setAttributeNS) {
              el.setAttributeNS("http://www.w3.org/1999/xlink", "href", src2);
            } else {
              el.setAttribute("hc-svg-href", src2);
            }
          };
          if (arguments.length > 1) {
            extend$1q(attribs, {
              x,
              y,
              width,
              height
            });
          }
          var elemWrapper = this.createElement("image").attr(attribs), onDummyLoad = function(e2) {
            setSVGImageSource(elemWrapper.element, src);
            onload.call(elemWrapper, e2);
          };
          if (onload) {
            setSVGImageSource(
              elemWrapper.element,
              "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="
              /* eslint-disable-line */
            );
            var dummy = new win$c.Image();
            addEvent$10(dummy, "load", onDummyLoad);
            dummy.src = src;
            if (dummy.complete) {
              onDummyLoad({});
            }
          } else {
            setSVGImageSource(elemWrapper.element, src);
          }
          return elemWrapper;
        };
        SVGRenderer2.prototype.symbol = function(symbol, x, y, width, height, options) {
          var ren = this, imageRegex = /^url\((.*?)\)$/, isImage = imageRegex.test(symbol), sym = !isImage && (this.symbols[symbol] ? symbol : "circle"), symbolFn = sym && this.symbols[sym];
          var obj, path, imageSrc, centerImage;
          if (symbolFn) {
            if (typeof x === "number") {
              path = symbolFn.call(this.symbols, Math.round(x || 0), Math.round(y || 0), width || 0, height || 0, options);
            }
            obj = this.path(path);
            if (!ren.styledMode) {
              obj.attr("fill", "none");
            }
            extend$1q(obj, {
              symbolName: sym || void 0,
              x,
              y,
              width,
              height
            });
            if (options) {
              extend$1q(obj, options);
            }
          } else if (isImage) {
            imageSrc = symbol.match(imageRegex)[1];
            var img_1 = obj = this.image(imageSrc);
            img_1.imgwidth = pick$1s(symbolSizes[imageSrc] && symbolSizes[imageSrc].width, options && options.width);
            img_1.imgheight = pick$1s(symbolSizes[imageSrc] && symbolSizes[imageSrc].height, options && options.height);
            centerImage = function(obj2) {
              return obj2.attr({
                width: obj2.width,
                height: obj2.height
              });
            };
            ["width", "height"].forEach(function(key) {
              img_1[key + "Setter"] = function(value, key2) {
                var imgSize = this["img" + key2];
                this[key2] = value;
                if (defined$Q(imgSize)) {
                  if (options && options.backgroundSize === "within" && this.width && this.height) {
                    imgSize = Math.round(imgSize * Math.min(this.width / this.imgwidth, this.height / this.imgheight));
                  }
                  if (this.element) {
                    this.element.setAttribute(key2, imgSize);
                  }
                  if (!this.alignByTranslate) {
                    var translate2 = ((this[key2] || 0) - imgSize) / 2;
                    var attribs = key2 === "width" ? { translateX: translate2 } : { translateY: translate2 };
                    this.attr(attribs);
                  }
                }
              };
            });
            if (defined$Q(x)) {
              img_1.attr({
                x,
                y
              });
            }
            img_1.isImg = true;
            if (defined$Q(img_1.imgwidth) && defined$Q(img_1.imgheight)) {
              centerImage(img_1);
            } else {
              img_1.attr({ width: 0, height: 0 });
              createElement$8("img", {
                onload: function() {
                  var chart = charts$4[ren.chartIndex];
                  if (this.width === 0) {
                    css$b(this, {
                      position: "absolute",
                      top: "-999em"
                    });
                    doc$j.body.appendChild(this);
                  }
                  symbolSizes[imageSrc] = {
                    width: this.width,
                    height: this.height
                  };
                  img_1.imgwidth = this.width;
                  img_1.imgheight = this.height;
                  if (img_1.element) {
                    centerImage(img_1);
                  }
                  if (this.parentNode) {
                    this.parentNode.removeChild(this);
                  }
                  ren.imgCount--;
                  if (!ren.imgCount && chart && !chart.hasLoaded) {
                    chart.onload();
                  }
                },
                src: imageSrc
              });
              this.imgCount++;
            }
          }
          return obj;
        };
        SVGRenderer2.prototype.clipRect = function(x, y, width, height) {
          var id = uniqueKey$6() + "-", clipPath = this.createElement("clipPath").attr({
            id
          }).add(this.defs), wrapper = this.rect(x, y, width, height, 0).add(clipPath);
          wrapper.id = id;
          wrapper.clipPath = clipPath;
          wrapper.count = 0;
          return wrapper;
        };
        SVGRenderer2.prototype.text = function(str, x, y, useHTML) {
          var renderer = this, attribs = {};
          if (useHTML && (renderer.allowHTML || !renderer.forExport)) {
            return renderer.html(str, x, y);
          }
          attribs.x = Math.round(x || 0);
          if (y) {
            attribs.y = Math.round(y);
          }
          if (defined$Q(str)) {
            attribs.text = str;
          }
          var wrapper = renderer.createElement("text").attr(attribs);
          if (!useHTML || renderer.forExport && !renderer.allowHTML) {
            wrapper.xSetter = function(value, key, element) {
              var tspans = element.getElementsByTagName("tspan"), parentVal = element.getAttribute(key);
              for (var i2 = 0, tspan = void 0; i2 < tspans.length; i2++) {
                tspan = tspans[i2];
                if (tspan.getAttribute(key) === parentVal) {
                  tspan.setAttribute(key, value);
                }
              }
              element.setAttribute(key, value);
            };
          }
          return wrapper;
        };
        SVGRenderer2.prototype.fontMetrics = function(fontSize, elem) {
          if ((this.styledMode || !/px/.test(fontSize)) && win$c.getComputedStyle) {
            fontSize = elem && SVGElement.prototype.getStyle.call(elem, "font-size");
          } else {
            fontSize = fontSize || // When the elem is a DOM element (#5932)
            elem && elem.style && elem.style.fontSize || // Fall back on the renderer style default
            this.style && this.style.fontSize;
          }
          if (/px/.test(fontSize)) {
            fontSize = pInt$6(fontSize);
          } else {
            fontSize = 12;
          }
          var lineHeight = fontSize < 24 ? fontSize + 3 : Math.round(fontSize * 1.2), baseline = Math.round(lineHeight * 0.8);
          return {
            h: lineHeight,
            b: baseline,
            f: fontSize
          };
        };
        SVGRenderer2.prototype.rotCorr = function(baseline, rotation, alterY) {
          var y = baseline;
          if (rotation && alterY) {
            y = Math.max(y * Math.cos(rotation * deg2rad$7), 4);
          }
          return {
            x: -baseline / 3 * Math.sin(rotation * deg2rad$7),
            y
          };
        };
        SVGRenderer2.prototype.pathToSegments = function(path) {
          var ret = [];
          var segment = [];
          var commandLength = {
            A: 8,
            C: 7,
            H: 2,
            L: 3,
            M: 3,
            Q: 5,
            S: 5,
            T: 3,
            V: 2
          };
          for (var i2 = 0; i2 < path.length; i2++) {
            if (isString$8(segment[0]) && isNumber$J(path[i2]) && segment.length === commandLength[segment[0].toUpperCase()]) {
              path.splice(i2, 0, segment[0].replace("M", "L").replace("m", "l"));
            }
            if (typeof path[i2] === "string") {
              if (segment.length) {
                ret.push(segment.slice(0));
              }
              segment.length = 0;
            }
            segment.push(path[i2]);
          }
          ret.push(segment.slice(0));
          return ret;
        };
        SVGRenderer2.prototype.label = function(str, x, y, shape, anchorX, anchorY, useHTML, baseline, className) {
          return new SVGLabel(this, str, x, y, shape, anchorX, anchorY, useHTML, baseline, className);
        };
        SVGRenderer2.prototype.alignElements = function() {
          this.alignedObjects.forEach(function(el) {
            return el.align();
          });
        };
        return SVGRenderer2;
      }()
    );
    extend$1q(SVGRenderer.prototype, {
      /**
       * A pointer to the renderer's associated Element class. The VMLRenderer
       * will have a pointer to VMLElement here.
       *
       * @name Highcharts.SVGRenderer#Element
       * @type {Highcharts.SVGElement}
       */
      Element: SVGElement,
      SVG_NS,
      /**
       * A collection of characters mapped to HTML entities. When `useHTML` on an
       * element is true, these entities will be rendered correctly by HTML. In
       * the SVG pseudo-HTML, they need to be unescaped back to simple characters,
       * so for example `&lt;` will render as `<`.
       *
       * @example
       * // Add support for unescaping quotes
       * Highcharts.SVGRenderer.prototype.escapes['"'] = '&quot;';
       *
       * @name Highcharts.SVGRenderer#escapes
       * @type {Highcharts.Dictionary<string>}
       */
      escapes: {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        "'": "&#39;",
        '"': "&quot;"
      },
      /**
       * An extendable collection of functions for defining symbol paths.
       *
       * @name Highcharts.SVGRenderer#symbols
       * @type {Highcharts.SymbolDictionary}
       */
      symbols: Symbols,
      /**
       * Dummy function for plugins, called every time the renderer is updated.
       * Prior to Highcharts 5, this was used for the canvg renderer.
       *
       * @deprecated
       * @function Highcharts.SVGRenderer#draw
       */
      draw: noop$k
    });
    RendererRegistry$1.registerRendererType("svg", SVGRenderer, true);
    var __extends$2d = /* @__PURE__ */ function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p5 in b3) if (b3.hasOwnProperty(p5)) d3[p5] = b3[p5];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var isFirefox$2 = H.isFirefox, isMS$1 = H.isMS, isWebKit = H.isWebKit, win$b = H.win;
    var css$a = Utilities.css, defined$P = Utilities.defined, extend$1p = Utilities.extend, pick$1r = Utilities.pick, pInt$5 = Utilities.pInt;
    var HTMLElement$1 = (
      /** @class */
      function(_super) {
        __extends$2d(HTMLElement2, _super);
        function HTMLElement2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        HTMLElement2.compose = function(SVGElementClass) {
          if (HTMLElement2.composedClasses.indexOf(SVGElementClass) === -1) {
            HTMLElement2.composedClasses.push(SVGElementClass);
            var htmlElementProto = HTMLElement2.prototype, svgElementProto = SVGElementClass.prototype;
            svgElementProto.getSpanCorrection = htmlElementProto.getSpanCorrection;
            svgElementProto.htmlCss = htmlElementProto.htmlCss;
            svgElementProto.htmlGetBBox = htmlElementProto.htmlGetBBox;
            svgElementProto.htmlUpdateTransform = htmlElementProto.htmlUpdateTransform;
            svgElementProto.setSpanRotation = htmlElementProto.setSpanRotation;
          }
          return SVGElementClass;
        };
        HTMLElement2.prototype.getSpanCorrection = function(width, baseline, alignCorrection) {
          this.xCorr = -width * alignCorrection;
          this.yCorr = -baseline;
        };
        HTMLElement2.prototype.htmlCss = function(styles) {
          var wrapper = this, element = wrapper.element, isSettingWidth = element.tagName === "SPAN" && styles && "width" in styles, textWidth = pick$1r(isSettingWidth && styles.width, void 0);
          var doTransform;
          if (isSettingWidth) {
            delete styles.width;
            wrapper.textWidth = textWidth;
            doTransform = true;
          }
          if (styles && styles.textOverflow === "ellipsis") {
            styles.whiteSpace = "nowrap";
            styles.overflow = "hidden";
          }
          wrapper.styles = extend$1p(wrapper.styles, styles);
          css$a(wrapper.element, styles);
          if (doTransform) {
            wrapper.htmlUpdateTransform();
          }
          return wrapper;
        };
        HTMLElement2.prototype.htmlGetBBox = function() {
          var wrapper = this, element = wrapper.element;
          return {
            x: element.offsetLeft,
            y: element.offsetTop,
            width: element.offsetWidth,
            height: element.offsetHeight
          };
        };
        HTMLElement2.prototype.htmlUpdateTransform = function() {
          if (!this.added) {
            this.alignOnAdd = true;
            return;
          }
          var wrapper = this, renderer = wrapper.renderer, elem = wrapper.element, translateX = wrapper.translateX || 0, translateY = wrapper.translateY || 0, x = wrapper.x || 0, y = wrapper.y || 0, align = wrapper.textAlign || "left", alignCorrection = {
            left: 0,
            center: 0.5,
            right: 1
          }[align], styles = wrapper.styles, whiteSpace = styles && styles.whiteSpace;
          function getTextPxLength() {
            css$a(elem, {
              width: "",
              whiteSpace: whiteSpace || "nowrap"
            });
            return elem.offsetWidth;
          }
          css$a(elem, {
            marginLeft: translateX,
            marginTop: translateY
          });
          if (!renderer.styledMode && wrapper.shadows) {
            wrapper.shadows.forEach(function(shadow) {
              css$a(shadow, {
                marginLeft: translateX + 1,
                marginTop: translateY + 1
              });
            });
          }
          if (wrapper.inverted) {
            [].forEach.call(elem.childNodes, function(child) {
              renderer.invertChild(child, elem);
            });
          }
          if (elem.tagName === "SPAN") {
            var rotation = wrapper.rotation, textWidth = wrapper.textWidth && pInt$5(wrapper.textWidth), currentTextTransform = [
              rotation,
              align,
              elem.innerHTML,
              wrapper.textWidth,
              wrapper.textAlign
            ].join(",");
            var baseline = void 0;
            if (textWidth !== wrapper.oldTextWidth && (textWidth > wrapper.oldTextWidth || (wrapper.textPxLength || getTextPxLength()) > textWidth) && // Only set the width if the text is able to word-wrap, or
            // text-overflow is ellipsis (#9537)
            (/[ \-]/.test(elem.textContent || elem.innerText) || elem.style.textOverflow === "ellipsis")) {
              css$a(elem, {
                width: textWidth + "px",
                display: "block",
                whiteSpace: whiteSpace || "normal"
                // #3331
              });
              wrapper.oldTextWidth = textWidth;
              wrapper.hasBoxWidthChanged = true;
            } else {
              wrapper.hasBoxWidthChanged = false;
            }
            if (currentTextTransform !== wrapper.cTT) {
              baseline = renderer.fontMetrics(elem.style.fontSize, elem).b;
              if (defined$P(rotation) && (rotation !== (wrapper.oldRotation || 0) || align !== wrapper.oldAlign)) {
                wrapper.setSpanRotation(rotation, alignCorrection, baseline);
              }
              wrapper.getSpanCorrection(
                // Avoid elem.offsetWidth if we can, it affects rendering
                // time heavily (#7656)
                !defined$P(rotation) && wrapper.textPxLength || // #7920
                elem.offsetWidth,
                baseline,
                alignCorrection,
                rotation,
                align
              );
            }
            css$a(elem, {
              left: x + (wrapper.xCorr || 0) + "px",
              top: y + (wrapper.yCorr || 0) + "px"
            });
            wrapper.cTT = currentTextTransform;
            wrapper.oldRotation = rotation;
            wrapper.oldAlign = align;
          }
        };
        HTMLElement2.prototype.setSpanRotation = function(rotation, alignCorrection, baseline) {
          var getTransformKey = function() {
            return isMS$1 && !/Edge/.test(win$b.navigator.userAgent) ? "-ms-transform" : isWebKit ? "-webkit-transform" : isFirefox$2 ? "MozTransform" : win$b.opera ? "-o-transform" : void 0;
          };
          var rotationStyle = {}, cssTransformKey = getTransformKey();
          if (cssTransformKey) {
            rotationStyle[cssTransformKey] = rotationStyle.transform = "rotate(" + rotation + "deg)";
            rotationStyle[cssTransformKey + (isFirefox$2 ? "Origin" : "-origin")] = rotationStyle.transformOrigin = alignCorrection * 100 + "% " + baseline + "px";
            css$a(this.element, rotationStyle);
          }
        };
        HTMLElement2.composedClasses = [];
        return HTMLElement2;
      }(SVGElement)
    );
    var __extends$2c = /* @__PURE__ */ function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p5 in b3) if (b3.hasOwnProperty(p5)) d3[p5] = b3[p5];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var attr$3 = Utilities.attr, createElement$7 = Utilities.createElement, extend$1o = Utilities.extend, pick$1q = Utilities.pick;
    var HTMLRenderer = (
      /** @class */
      function(_super) {
        __extends$2c(HTMLRenderer2, _super);
        function HTMLRenderer2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        HTMLRenderer2.compose = function(SVGRendererClass) {
          if (HTMLRenderer2.composedClasses.indexOf(SVGRendererClass) === -1) {
            HTMLRenderer2.composedClasses.push(SVGRendererClass);
            var htmlRendererProto = HTMLRenderer2.prototype, svgRendererProto = SVGRendererClass.prototype;
            svgRendererProto.html = htmlRendererProto.html;
          }
          return SVGRendererClass;
        };
        HTMLRenderer2.prototype.html = function(str, x, y) {
          var wrapper = this.createElement("span"), element = wrapper.element, renderer = wrapper.renderer, isSVG = renderer.isSVG, addSetters = function(gWrapper, style) {
            ["opacity", "visibility"].forEach(function(prop) {
              gWrapper[prop + "Setter"] = function(value, key, elem) {
                var styleObject = gWrapper.div ? gWrapper.div.style : style;
                SVGElement.prototype[prop + "Setter"].call(this, value, key, elem);
                if (styleObject) {
                  styleObject[key] = value;
                }
              };
            });
            gWrapper.addedSetters = true;
          };
          wrapper.textSetter = function(value) {
            if (value !== this.textStr) {
              delete this.bBox;
              delete this.oldTextWidth;
              AST.setElementHTML(this.element, pick$1q(value, ""));
              this.textStr = value;
              wrapper.doTransform = true;
            }
          };
          if (isSVG) {
            addSetters(wrapper, wrapper.element.style);
          }
          wrapper.xSetter = wrapper.ySetter = wrapper.alignSetter = wrapper.rotationSetter = function(value, key) {
            if (key === "align") {
              wrapper.alignValue = wrapper.textAlign = value;
            } else {
              wrapper[key] = value;
            }
            wrapper.doTransform = true;
          };
          wrapper.afterSetters = function() {
            if (this.doTransform) {
              this.htmlUpdateTransform();
              this.doTransform = false;
            }
          };
          wrapper.attr({
            text: str,
            x: Math.round(x),
            y: Math.round(y)
          }).css({
            position: "absolute"
          });
          if (!renderer.styledMode) {
            wrapper.css({
              fontFamily: this.style.fontFamily,
              fontSize: this.style.fontSize
            });
          }
          element.style.whiteSpace = "nowrap";
          wrapper.css = wrapper.htmlCss;
          if (isSVG) {
            wrapper.add = function(svgGroupWrapper) {
              var container = renderer.box.parentNode, parents = [];
              var htmlGroup, parentGroup;
              this.parentGroup = svgGroupWrapper;
              if (svgGroupWrapper) {
                htmlGroup = svgGroupWrapper.div;
                if (!htmlGroup) {
                  parentGroup = svgGroupWrapper;
                  while (parentGroup) {
                    parents.push(parentGroup);
                    parentGroup = parentGroup.parentGroup;
                  }
                  parents.reverse().forEach(function(parentGroup2) {
                    var cls = attr$3(parentGroup2.element, "class");
                    function translateSetter(value, key) {
                      parentGroup2[key] = value;
                      if (key === "translateX") {
                        htmlGroupStyle.left = value + "px";
                      } else {
                        htmlGroupStyle.top = value + "px";
                      }
                      parentGroup2.doTransform = true;
                    }
                    var parentGroupStyles = parentGroup2.styles || {};
                    htmlGroup = parentGroup2.div = parentGroup2.div || createElement$7("div", cls ? { className: cls } : void 0, {
                      position: "absolute",
                      left: (parentGroup2.translateX || 0) + "px",
                      top: (parentGroup2.translateY || 0) + "px",
                      display: parentGroup2.display,
                      opacity: parentGroup2.opacity,
                      cursor: parentGroupStyles.cursor,
                      pointerEvents: parentGroupStyles.pointerEvents,
                      visibility: parentGroup2.visibility
                      // the top group is appended to container
                    }, htmlGroup || container);
                    var htmlGroupStyle = htmlGroup.style;
                    extend$1o(parentGroup2, {
                      // (#7287) Pass htmlGroup to use
                      // the related group
                      classSetter: /* @__PURE__ */ function(htmlGroup2) {
                        return function(value) {
                          this.element.setAttribute("class", value);
                          htmlGroup2.className = value;
                        };
                      }(htmlGroup),
                      on: function() {
                        if (parents[0].div) {
                          wrapper.on.apply({
                            element: parents[0].div,
                            onEvents: parentGroup2.onEvents
                          }, arguments);
                        }
                        return parentGroup2;
                      },
                      translateXSetter: translateSetter,
                      translateYSetter: translateSetter
                    });
                    if (!parentGroup2.addedSetters) {
                      addSetters(parentGroup2);
                    }
                  });
                }
              } else {
                htmlGroup = container;
              }
              htmlGroup.appendChild(element);
              wrapper.added = true;
              if (wrapper.alignOnAdd) {
                wrapper.htmlUpdateTransform();
              }
              return wrapper;
            };
          }
          return wrapper;
        };
        HTMLRenderer2.composedClasses = [];
        return HTMLRenderer2;
      }(SVGRenderer)
    );
    var AxisDefaults;
    (function(AxisDefaults2) {
      AxisDefaults2.defaultXAxisOptions = {
        /**
         * When using multiple axis, the ticks of two or more opposite axes
         * will automatically be aligned by adding ticks to the axis or axes
         * with the least ticks, as if `tickAmount` were specified.
         *
         * This can be prevented by setting `alignTicks` to false. If the grid
         * lines look messy, it's a good idea to hide them for the secondary
         * axis by setting `gridLineWidth` to 0.
         *
         * If `startOnTick` or `endOnTick` in an Axis options are set to false,
         * then the `alignTicks ` will be disabled for the Axis.
         *
         * Disabled for logarithmic axes.
         *
         * @product   highcharts highstock gantt
         */
        alignTicks: true,
        /**
         * Whether to allow decimals in this axis' ticks. When counting
         * integers, like persons or hits on a web page, decimals should
         * be avoided in the labels. By default, decimals are allowed on small
         * scale axes.
         *
         * @see [minTickInterval](#xAxis.minTickInterval)
         *
         * @sample {highcharts|highstock} highcharts/yaxis/allowdecimals-true/
         *         True by default
         * @sample {highcharts|highstock} highcharts/yaxis/allowdecimals-false/
         *         False
         *
         * @type      {boolean|undefined}
         * @default   undefined
         * @since     2.0
         */
        allowDecimals: void 0,
        /**
         * When using an alternate grid color, a band is painted across the
         * plot area between every other grid line.
         *
         * @sample {highcharts} highcharts/yaxis/alternategridcolor/
         *         Alternate grid color on the Y axis
         * @sample {highstock} stock/xaxis/alternategridcolor/
         *         Alternate grid color on the Y axis
         *
         * @type      {Highcharts.ColorType}
         * @apioption xAxis.alternateGridColor
         */
        /**
         * An array defining breaks in the axis, the sections defined will be
         * left out and all the points shifted closer to each other.
         *
         * @productdesc {highcharts}
         * Requires that the broken-axis.js module is loaded.
         *
         * @sample {highcharts} highcharts/axisbreak/break-simple/
         *         Simple break
         * @sample {highcharts|highstock} highcharts/axisbreak/break-visualized/
         *         Advanced with callback
         * @sample {highstock} stock/demo/intraday-breaks/
         *         Break on nights and weekends
         *
         * @type      {Array<*>}
         * @since     4.1.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.breaks
         */
        /**
         * A number indicating how much space should be left between the start
         * and the end of the break. The break size is given in axis units,
         * so for instance on a `datetime` axis, a break size of 3600000 would
         * indicate the equivalent of an hour.
         *
         * @type      {number}
         * @default   0
         * @since     4.1.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.breaks.breakSize
         */
        /**
         * The point where the break starts.
         *
         * @type      {number}
         * @since     4.1.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.breaks.from
         */
        /**
         * Defines an interval after which the break appears again. By default
         * the breaks do not repeat.
         *
         * @type      {number}
         * @default   0
         * @since     4.1.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.breaks.repeat
         */
        /**
         * The point where the break ends.
         *
         * @type      {number}
         * @since     4.1.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.breaks.to
         */
        /**
         * If categories are present for the xAxis, names are used instead of
         * numbers for that axis.
         *
         * Since Highcharts 3.0, categories can also
         * be extracted by giving each point a [name](#series.data) and setting
         * axis [type](#xAxis.type) to `category`. However, if you have multiple
         * series, best practice remains defining the `categories` array.
         *
         * Example: `categories: ['Apples', 'Bananas', 'Oranges']`
         *
         * @sample {highcharts} highcharts/demo/line-labels/
         *         With
         * @sample {highcharts} highcharts/xaxis/categories/
         *         Without
         *
         * @type      {Array<string>}
         * @product   highcharts gantt
         * @apioption xAxis.categories
         */
        /**
         * The highest allowed value for automatically computed axis extremes.
         *
         * @see [floor](#xAxis.floor)
         *
         * @sample {highcharts|highstock} highcharts/yaxis/floor-ceiling/
         *         Floor and ceiling
         *
         * @type       {number}
         * @since      4.0
         * @product    highcharts highstock gantt
         * @apioption  xAxis.ceiling
         */
        /**
         * A class name that opens for styling the axis by CSS, especially in
         * Highcharts styled mode. The class name is applied to group elements
         * for the grid, axis elements and labels.
         *
         * @sample {highcharts|highstock|highmaps} highcharts/css/axis/
         *         Multiple axes with separate styling
         *
         * @type      {string}
         * @since     5.0.0
         * @apioption xAxis.className
         */
        /**
         * Configure a crosshair that follows either the mouse pointer or the
         * hovered point.
         *
         * In styled mode, the crosshairs are styled in the
         * `.highcharts-crosshair`, `.highcharts-crosshair-thin` or
         * `.highcharts-xaxis-category` classes.
         *
         * @productdesc {highstock}
         * In Highcharts stock, by default, the crosshair is enabled on the
         * X axis and disabled on the Y axis.
         *
         * @sample {highcharts} highcharts/xaxis/crosshair-both/
         *         Crosshair on both axes
         * @sample {highstock} stock/xaxis/crosshairs-xy/
         *         Crosshair on both axes
         * @sample {highmaps} highcharts/xaxis/crosshair-both/
         *         Crosshair on both axes
         *
         * @declare   Highcharts.AxisCrosshairOptions
         * @type      {boolean|*}
         * @default   false
         * @since     4.1
         * @apioption xAxis.crosshair
         */
        /**
         * A class name for the crosshair, especially as a hook for styling.
         *
         * @type      {string}
         * @since     5.0.0
         * @apioption xAxis.crosshair.className
         */
        /**
         * The color of the crosshair. Defaults to `#cccccc` for numeric and
         * datetime axes, and `rgba(204,214,235,0.25)` for category axes, where
         * the crosshair by default highlights the whole category.
         *
         * @sample {highcharts|highstock|highmaps} highcharts/xaxis/crosshair-customized/
         *         Customized crosshairs
         *
         * @type      {Highcharts.ColorType}
         * @default   #cccccc
         * @since     4.1
         * @apioption xAxis.crosshair.color
         */
        /**
         * The dash style for the crosshair. See
         * [plotOptions.series.dashStyle](#plotOptions.series.dashStyle)
         * for possible values.
         *
         * @sample {highcharts|highmaps} highcharts/xaxis/crosshair-dotted/
         *         Dotted crosshair
         * @sample {highstock} stock/xaxis/crosshair-dashed/
         *         Dashed X axis crosshair
         *
         * @type      {Highcharts.DashStyleValue}
         * @default   Solid
         * @since     4.1
         * @apioption xAxis.crosshair.dashStyle
         */
        /**
         * A label on the axis next to the crosshair.
         *
         * In styled mode, the label is styled with the
         * `.highcharts-crosshair-label` class.
         *
         * @sample {highstock} stock/xaxis/crosshair-label/
         *         Crosshair labels
         * @sample {highstock} highcharts/css/crosshair-label/
         *         Style mode
         *
         * @declare   Highcharts.AxisCrosshairLabelOptions
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label
         */
        /**
         * Alignment of the label compared to the axis. Defaults to `"left"` for
         * right-side axes, `"right"` for left-side axes and `"center"` for
         * horizontal axes.
         *
         * @type      {Highcharts.AlignValue}
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.align
         */
        /**
         * The background color for the label. Defaults to the related series
         * color, or `#666666` if that is not available.
         *
         * @type      {Highcharts.ColorType}
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.backgroundColor
         */
        /**
         * The border color for the crosshair label
         *
         * @type      {Highcharts.ColorType}
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.borderColor
         */
        /**
         * The border corner radius of the crosshair label.
         *
         * @type      {number}
         * @default   3
         * @since     2.1.10
         * @product   highstock
         * @apioption xAxis.crosshair.label.borderRadius
         */
        /**
         * The border width for the crosshair label.
         *
         * @type      {number}
         * @default   0
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.borderWidth
         */
        /**
         * Flag to enable crosshair's label.
         *
         * @sample {highstock} stock/xaxis/crosshairs-xy/
         *         Enabled label for yAxis' crosshair
         *
         * @type      {boolean}
         * @default   false
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.enabled
         */
        /**
         * A format string for the crosshair label. Defaults to `{value}` for
         * numeric axes and `{value:%b %d, %Y}` for datetime axes.
         *
         * @type      {string}
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.format
         */
        /**
         * Formatter function for the label text.
         *
         * @type      {Highcharts.XAxisCrosshairLabelFormatterCallbackFunction}
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.formatter
         */
        /**
         * Padding inside the crosshair label.
         *
         * @type      {number}
         * @default   8
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.padding
         */
        /**
         * The shape to use for the label box.
         *
         * @type      {string}
         * @default   callout
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.shape
         */
        /**
         * Text styles for the crosshair label.
         *
         * @type      {Highcharts.CSSObject}
         * @default   {"color": "white", "fontWeight": "normal", "fontSize": "11px", "textAlign": "center"}
         * @since     2.1
         * @product   highstock
         * @apioption xAxis.crosshair.label.style
         */
        /**
         * Whether the crosshair should snap to the point or follow the pointer
         * independent of points.
         *
         * @sample {highcharts|highstock} highcharts/xaxis/crosshair-snap-false/
         *         True by default
         * @sample {highmaps} maps/demo/latlon-advanced/
         *         Snap is false
         *
         * @type      {boolean}
         * @default   true
         * @since     4.1
         * @apioption xAxis.crosshair.snap
         */
        /**
         * The pixel width of the crosshair. Defaults to 1 for numeric or
         * datetime axes, and for one category width for category axes.
         *
         * @sample {highcharts} highcharts/xaxis/crosshair-customized/
         *         Customized crosshairs
         * @sample {highstock} highcharts/xaxis/crosshair-customized/
         *         Customized crosshairs
         * @sample {highmaps} highcharts/xaxis/crosshair-customized/
         *         Customized crosshairs
         *
         * @type      {number}
         * @default   1
         * @since     4.1
         * @apioption xAxis.crosshair.width
         */
        /**
         * The Z index of the crosshair. Higher Z indices allow drawing the
         * crosshair on top of the series or behind the grid lines.
         *
         * @type      {number}
         * @default   2
         * @since     4.1
         * @apioption xAxis.crosshair.zIndex
         */
        /**
         * Whether to pan axis. If `chart.panning` is enabled, the option
         * allows to disable panning on an individual axis.
         */
        panningEnabled: true,
        /**
         * The Z index for the axis group.
         */
        zIndex: 2,
        /**
         * Whether to zoom axis. If `chart.zoomType` is set, the option allows
         * to disable zooming on an individual axis.
         *
         * @sample {highcharts} highcharts/xaxis/zoomenabled/
         *         Zoom enabled is false
         */
        zoomEnabled: true,
        /**
         * For a datetime axis, the scale will automatically adjust to the
         * appropriate unit. This member gives the default string
         * representations used for each unit. For intermediate values,
         * different units may be used, for example the `day` unit can be used
         * on midnight and `hour` unit be used for intermediate values on the
         * same axis.
         *
         * For an overview of the replacement codes, see
         * [dateFormat](/class-reference/Highcharts#.dateFormat).
         *
         * Defaults to:
         * ```js
         * {
         *     millisecond: '%H:%M:%S.%L',
         *     second: '%H:%M:%S',
         *     minute: '%H:%M',
         *     hour: '%H:%M',
         *     day: '%e. %b',
         *     week: '%e. %b',
         *     month: '%b \'%y',
         *     year: '%Y'
         * }
         * ```
         *
         * @sample {highcharts} highcharts/xaxis/datetimelabelformats/
         *         Different day format on X axis
         * @sample {highstock} stock/xaxis/datetimelabelformats/
         *         More information in x axis labels
         *
         * @declare Highcharts.AxisDateTimeLabelFormatsOptions
         * @product highcharts highstock gantt
         */
        dateTimeLabelFormats: {
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          millisecond: {
            main: "%H:%M:%S.%L",
            range: false
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          second: {
            main: "%H:%M:%S",
            range: false
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          minute: {
            main: "%H:%M",
            range: false
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          hour: {
            main: "%H:%M",
            range: false
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          day: {
            main: "%e. %b"
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          week: {
            main: "%e. %b"
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          month: {
            main: "%b '%y"
          },
          /**
           * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
           * @type {string|*}
           */
          year: {
            main: "%Y"
          }
        },
        /**
         * Whether to force the axis to end on a tick. Use this option with
         * the `maxPadding` option to control the axis end.
         *
         * @productdesc {highstock}
         * In Highcharts Stock, `endOnTick` is always `false` when the navigator
         * is enabled, to prevent jumpy scrolling.
         *
         * @sample {highcharts} highcharts/chart/reflow-true/
         *         True by default
         * @sample {highcharts} highcharts/yaxis/endontick/
         *         False
         * @sample {highstock} stock/demo/basic-line/
         *         True by default
         * @sample {highstock} stock/xaxis/endontick/
         *         False
         *
         * @since 1.2.0
         */
        endOnTick: false,
        /**
         * Event handlers for the axis.
         *
         * @type      {*}
         * @apioption xAxis.events
         */
        /**
         * An event fired after the breaks have rendered.
         *
         * @see [breaks](#xAxis.breaks)
         *
         * @sample {highcharts} highcharts/axisbreak/break-event/
         *         AfterBreak Event
         *
         * @type      {Highcharts.AxisEventCallbackFunction}
         * @since     4.1.0
         * @product   highcharts gantt
         * @apioption xAxis.events.afterBreaks
         */
        /**
         * As opposed to the `setExtremes` event, this event fires after the
         * final min and max values are computed and corrected for `minRange`.
         *
         * Fires when the minimum and maximum is set for the axis, either by
         * calling the `.setExtremes()` method or by selecting an area in the
         * chart. One parameter, `event`, is passed to the function, containing
         * common event information.
         *
         * The new user set minimum and maximum values can be found by
         * `event.min` and `event.max`. These reflect the axis minimum and
         * maximum in axis values. The actual data extremes are found in
         * `event.dataMin` and `event.dataMax`.
         *
         * @type      {Highcharts.AxisSetExtremesEventCallbackFunction}
         * @since     2.3
         * @context   Highcharts.Axis
         * @apioption xAxis.events.afterSetExtremes
         */
        /**
         * An event fired when a break from this axis occurs on a point.
         *
         * @see [breaks](#xAxis.breaks)
         *
         * @sample {highcharts} highcharts/axisbreak/break-visualized/
         *         Visualization of a Break
         *
         * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
         * @since     4.1.0
         * @product   highcharts gantt
         * @context   Highcharts.Axis
         * @apioption xAxis.events.pointBreak
         */
        /**
         * An event fired when a point falls inside a break from this axis.
         *
         * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
         * @product   highcharts highstock gantt
         * @context   Highcharts.Axis
         * @apioption xAxis.events.pointInBreak
         */
        /**
         * Fires when the minimum and maximum is set for the axis, either by
         * calling the `.setExtremes()` method or by selecting an area in the
         * chart. One parameter, `event`, is passed to the function,
         * containing common event information.
         *
         * The new user set minimum and maximum values can be found by
         * `event.min` and `event.max`. These reflect the axis minimum and
         * maximum in data values. When an axis is zoomed all the way out from
         * the "Reset zoom" button, `event.min` and `event.max` are null, and
         * the new extremes are set based on `this.dataMin` and `this.dataMax`.
         *
         * @sample {highstock} stock/xaxis/events-setextremes/
         *         Log new extremes on x axis
         *
         * @type      {Highcharts.AxisSetExtremesEventCallbackFunction}
         * @since     1.2.0
         * @context   Highcharts.Axis
         * @apioption xAxis.events.setExtremes
         */
        /**
         * The lowest allowed value for automatically computed axis extremes.
         *
         * @see [ceiling](#yAxis.ceiling)
         *
         * @sample {highcharts} highcharts/yaxis/floor-ceiling/
         *         Floor and ceiling
         * @sample {highstock} stock/demo/lazy-loading/
         *         Prevent negative stock price on Y axis
         *
         * @type      {number}
         * @since     4.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.floor
         */
        /**
         * The dash or dot style of the grid lines. For possible values, see
         * [this demonstration](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-dashstyle-all/).
         *
         * @sample {highcharts} highcharts/yaxis/gridlinedashstyle/
         *         Long dashes
         * @sample {highstock} stock/xaxis/gridlinedashstyle/
         *         Long dashes
         *
         * @type      {Highcharts.DashStyleValue}
         * @since     1.2
         */
        gridLineDashStyle: "Solid",
        /**
         * The Z index of the grid lines.
         *
         * @sample {highcharts|highstock} highcharts/xaxis/gridzindex/
         *         A Z index of 4 renders the grid above the graph
         *
         * @product   highcharts highstock gantt
         */
        gridZIndex: 1,
        /**
         * An id for the axis. This can be used after render time to get
         * a pointer to the axis object through `chart.get()`.
         *
         * @sample {highcharts} highcharts/xaxis/id/
         *         Get the object
         * @sample {highstock} stock/xaxis/id/
         *         Get the object
         *
         * @type      {string}
         * @since     1.2.0
         * @apioption xAxis.id
         */
        /**
         * The axis labels show the number or category for each tick.
         *
         * Since v8.0.0: Labels are animated in categorized x-axis with
         * updating data if `tickInterval` and `step` is set to 1.
         *
         * @productdesc {highmaps}
         * X and Y axis labels are by default disabled in Highmaps, but the
         * functionality is inherited from Highcharts and used on `colorAxis`,
         * and can be enabled on X and Y axes too.
         */
        labels: {
          /**
           * What part of the string the given position is anchored to.
           * If `left`, the left side of the string is at the axis position.
           * Can be one of `"left"`, `"center"` or `"right"`. Defaults to
           * an intelligent guess based on which side of the chart the axis
           * is on and the rotation of the label.
           *
           * @see [reserveSpace](#xAxis.labels.reserveSpace)
           *
           * @sample {highcharts} highcharts/xaxis/labels-align-left/
           *         Left
           * @sample {highcharts} highcharts/xaxis/labels-align-right/
           *         Right
           * @sample {highcharts} highcharts/xaxis/labels-reservespace-true/
           *         Left-aligned labels on a vertical category axis
           *
           * @type       {Highcharts.AlignValue}
           * @apioption  xAxis.labels.align
           */
          /**
           * Whether to allow the axis labels to overlap.
           * When false, overlapping labels are hidden.
           *
           * @sample {highcharts} highcharts/xaxis/labels-allowoverlap-true/
           *         X axis labels overlap enabled
           *
           * @type {boolean}
           * @default false
           * @apioption xAxis.labels.allowOverlap
           *
           */
          /**
           * For horizontal axes, the allowed degrees of label rotation
           * to prevent overlapping labels. If there is enough space,
           * labels are not rotated. As the chart gets narrower, it
           * will start rotating the labels -45 degrees, then remove
           * every second label and try again with rotations 0 and -45 etc.
           * Set it to `undefined` to disable rotation, which will
           * cause the labels to word-wrap if possible. Defaults to `[-45]``
           * on bottom and top axes, `undefined` on left and right axes.
           *
           * @sample {highcharts|highstock} highcharts/xaxis/labels-autorotation-default/
           *         Default auto rotation of 0 or -45
           * @sample {highcharts|highstock} highcharts/xaxis/labels-autorotation-0-90/
           *         Custom graded auto rotation
           *
           * @type      {Array<number>}
           * @default   undefined
           * @since     4.1.0
           * @product   highcharts highstock gantt
           * @apioption xAxis.labels.autoRotation
           */
          autoRotation: void 0,
          /**
           * When each category width is more than this many pixels, we don't
           * apply auto rotation. Instead, we lay out the axis label with word
           * wrap. A lower limit makes sense when the label contains multiple
           * short words that don't extend the available horizontal space for
           * each label.
           *
           * @sample {highcharts} highcharts/xaxis/labels-autorotationlimit/
           *         Lower limit
           *
           * @since     4.1.5
           * @product   highcharts gantt
           */
          autoRotationLimit: 80,
          /**
           * Polar charts only. The label's pixel distance from the perimeter
           * of the plot area.
           *
           * @type      {number}
           * @default   undefined
           * @product   highcharts gantt
           */
          distance: void 0,
          /**
           * Enable or disable the axis labels.
           *
           * @sample {highcharts} highcharts/xaxis/labels-enabled/
           *         X axis labels disabled
           * @sample {highstock} stock/xaxis/labels-enabled/
           *         X axis labels disabled
           *
           * @default {highcharts|highstock|gantt} true
           * @default {highmaps} false
           */
          enabled: true,
          /**
           * A format string for the axis label. The context is available as
           * format string variables. For example, you can use `{text}` to
           * insert the default formatted text. The recommended way of adding
           * units for the label is using `text`, for example `{text} km`.
           *
           * To add custom numeric or datetime formatting, use `{value}` with
           * formatting, for example `{value:.1f}` or `{value:%Y-%m-%d}`.
           *
           * See
           * [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
           * for more examples of formatting.
           *
           * The default value is not specified due to the dynamic
           * nature of the default implementation.
           *
           * @sample {highcharts|highstock} highcharts/yaxis/labels-format/
           *         Add units to Y axis label
           * @sample {highcharts} highcharts/xaxis/labels-format-linked/
           *         Linked category names
           * @sample {highcharts} highcharts/xaxis/labels-format-custom/
           *         Custom number format
           *
           * @type      {string}
           * @since     3.0
           * @apioption xAxis.labels.format
           */
          /**
           * Callback JavaScript function to format the label. The value
           * is given by `this.value`. Additional properties for `this` are
           * `axis`, `chart`, `isFirst`, `isLast` and `text` which holds the
           * value of the default formatter.
           *
           * Defaults to a built in function returning a formatted string
           * depending on whether the axis is `category`, `datetime`,
           * `numeric` or other.
           *
           * @sample {highcharts} highcharts/xaxis/labels-formatter-linked/
           *         Linked category names
           * @sample {highcharts} highcharts/xaxis/labels-formatter-extended/
           *         Modified numeric labels
           * @sample {highstock} stock/xaxis/labels-formatter/
           *         Added units on Y axis
           *
           * @type      {Highcharts.AxisLabelsFormatterCallbackFunction}
           * @apioption xAxis.labels.formatter
           */
          /**
           * The number of pixels to indent the labels per level in a treegrid
           * axis.
           *
           * @sample gantt/treegrid-axis/demo
           *         Indentation 10px by default.
           * @sample gantt/treegrid-axis/indentation-0px
           *         Indentation set to 0px.
           *
           * @product gantt
           */
          indentation: 10,
          /**
           * Horizontal axis only. When `staggerLines` is not set,
           * `maxStaggerLines` defines how many lines the axis is allowed to
           * add to automatically avoid overlapping X labels. Set to `1` to
           * disable overlap detection.
           *
           * @deprecated
           * @type      {number}
           * @default   5
           * @since     1.3.3
           * @apioption xAxis.labels.maxStaggerLines
           */
          /**
           * How to handle overflowing labels on horizontal axis. If set to
           * `"allow"`, it will not be aligned at all. By default it
           * `"justify"` labels inside the chart area. If there is room to
           * move it, it will be aligned to the edge, else it will be removed.
           *
           * @since      2.2.5
           * @validvalue ["allow", "justify"]
           */
          overflow: "justify",
          /**
           * The pixel padding for axis labels, to ensure white space between
           * them.
           *
           * @product   highcharts gantt
           */
          padding: 5,
          /**
           * Whether to reserve space for the labels. By default, space is
           * reserved for the labels in these cases:
           *
           * * On all horizontal axes.
           * * On vertical axes if `label.align` is `right` on a left-side
           * axis or `left` on a right-side axis.
           * * On vertical axes if `label.align` is `center`.
           *
           * This can be turned off when for example the labels are rendered
           * inside the plot area instead of outside.
           *
           * @see [labels.align](#xAxis.labels.align)
           *
           * @sample {highcharts} highcharts/xaxis/labels-reservespace/
           *         No reserved space, labels inside plot
           * @sample {highcharts} highcharts/xaxis/labels-reservespace-true/
           *         Left-aligned labels on a vertical category axis
           *
           * @type      {boolean}
           * @since     4.1.10
           * @product   highcharts gantt
           * @apioption xAxis.labels.reserveSpace
           */
          reserveSpace: void 0,
          /**
           * Rotation of the labels in degrees. When `undefined`, the
           * `autoRotation` option takes precedence.
           *
           * @sample {highcharts} highcharts/xaxis/labels-rotation/
           *         X axis labels rotated 90°
           *
           * @type      {number}
           * @default   0
           * @apioption xAxis.labels.rotation
           */
          rotation: void 0,
          /**
           * Horizontal axes only. The number of lines to spread the labels
           * over to make room or tighter labels. 0 disables staggering.
           *
           * @sample {highcharts} highcharts/xaxis/labels-staggerlines/
           *         Show labels over two lines
           * @sample {highstock} stock/xaxis/labels-staggerlines/
           *         Show labels over two lines
           *
           * @since     2.1
           */
          staggerLines: 0,
          /**
           * To show only every _n_'th label on the axis, set the step to _n_.
           * Setting the step to 2 shows every other label.
           *
           * By default, when 0, the step is calculated automatically to avoid
           * overlap. To prevent this, set it to 1\. This usually only
           * happens on a category axis, and is often a sign that you have
           * chosen the wrong axis type.
           *
           * Read more at
           * [Axis docs](https://www.highcharts.com/docs/chart-concepts/axes)
           * => What axis should I use?
           *
           * @sample {highcharts} highcharts/xaxis/labels-step/
           *         Showing only every other axis label on a categorized
           *         x-axis
           * @sample {highcharts} highcharts/xaxis/labels-step-auto/
           *         Auto steps on a category axis
           *
           * @since     2.1
           */
          step: 0,
          /**
           * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
           * to render the labels.
           */
          useHTML: false,
          /**
           * The x position offset of all labels relative to the tick
           * positions on the axis.
           *
           * @sample {highcharts} highcharts/xaxis/labels-x/
           *         Y axis labels placed on grid lines
           */
          x: 0,
          /**
           * The y position offset of all labels relative to the tick
           * positions on the axis. The default makes it adapt to the font
           * size of the bottom axis.
           *
           * @sample {highcharts} highcharts/xaxis/labels-x/
           *         Y axis labels placed on grid lines
           *
           * @type      {number}
           * @apioption xAxis.labels.y
           */
          /**
           * The Z index for the axis labels.
           */
          zIndex: 7,
          /**
           * CSS styles for the label. Use `whiteSpace: 'nowrap'` to prevent
           * wrapping of category labels. Use `textOverflow: 'none'` to
           * prevent ellipsis (dots).
           *
           * In styled mode, the labels are styled with the
           * `.highcharts-axis-labels` class.
           *
           * @sample {highcharts} highcharts/xaxis/labels-style/
           *         Red X axis labels
           *
           * @type      {Highcharts.CSSObject}
           */
          style: {
            /** @internal */
            color: palette.neutralColor60,
            /** @internal */
            cursor: "default",
            /** @internal */
            fontSize: "11px"
          }
        },
        /**
         * The left position as the horizontal axis. If it's a number, it is
         * interpreted as pixel position relative to the chart.
         *
         * Since Highcharts v5.0.13: If it's a percentage string, it is
         * interpreted as percentages of the plot width, offset from plot area
         * left.
         *
         * @type      {number|string}
         * @product   highcharts highstock
         * @apioption xAxis.left
         */
        /**
         * The top position as the vertical axis. If it's a number, it is
         * interpreted as pixel position relative to the chart.
         *
         * Since Highcharts 2: If it's a percentage string, it is interpreted
         * as percentages of the plot height, offset from plot area top.
         *
         * @type      {number|string}
         * @product   highcharts highstock
         * @apioption xAxis.top
         */
        /**
         * Index of another axis that this axis is linked to. When an axis is
         * linked to a master axis, it will take the same extremes as
         * the master, but as assigned by min or max or by setExtremes.
         * It can be used to show additional info, or to ease reading the
         * chart by duplicating the scales.
         *
         * @sample {highcharts} highcharts/xaxis/linkedto/
         *         Different string formats of the same date
         * @sample {highcharts} highcharts/yaxis/linkedto/
         *         Y values on both sides
         *
         * @type      {number}
         * @since     2.0.2
         * @product   highcharts highstock gantt
         * @apioption xAxis.linkedTo
         */
        /**
         * The maximum value of the axis. If `null`, the max value is
         * automatically calculated.
         *
         * If the [endOnTick](#yAxis.endOnTick) option is true, the `max` value
         * might be rounded up.
         *
         * If a [tickAmount](#yAxis.tickAmount) is set, the axis may be extended
         * beyond the set max in order to reach the given number of ticks. The
         * same may happen in a chart with multiple axes, determined by [chart.
         * alignTicks](#chart), where a `tickAmount` is applied internally.
         *
         * @sample {highcharts} highcharts/yaxis/max-200/
         *         Y axis max of 200
         * @sample {highcharts} highcharts/yaxis/max-logarithmic/
         *         Y axis max on logarithmic axis
         * @sample {highstock} stock/xaxis/min-max/
         *         Fixed min and max on X axis
         * @sample {highmaps} maps/axis/min-max/
         *         Pre-zoomed to a specific area
         *
         * @type      {number|null}
         * @apioption xAxis.max
         */
        /**
         * Padding of the max value relative to the length of the axis. A
         * padding of 0.05 will make a 100px axis 5px longer. This is useful
         * when you don't want the highest data value to appear on the edge
         * of the plot area. When the axis' `max` option is set or a max extreme
         * is set using `axis.setExtremes()`, the maxPadding will be ignored.
         *
         * @productdesc {highstock}
         * For an [ordinal](#xAxis.ordinal) axis, `minPadding` and `maxPadding`
         * are ignored. Use [overscroll](#xAxis.overscroll) instead.
         *
         * @sample {highcharts} highcharts/yaxis/maxpadding/
         *         Max padding of 0.25 on y axis
         * @sample {highstock} stock/xaxis/minpadding-maxpadding/
         *         Greater min- and maxPadding
         * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
         *         Add some padding
         *
         * @default   {highcharts} 0.01
         * @default   {highstock|highmaps} 0
         * @since     1.2.0
         */
        maxPadding: 0.01,
        /**
         * Deprecated. Use `minRange` instead.
         *
         * @deprecated
         * @type      {number}
         * @product   highcharts highstock
         * @apioption xAxis.maxZoom
         */
        /**
         * The minimum value of the axis. If `null` the min value is
         * automatically calculated.
         *
         * If the [startOnTick](#yAxis.startOnTick) option is true (default),
         * the `min` value might be rounded down.
         *
         * The automatically calculated minimum value is also affected by
         * [floor](#yAxis.floor), [softMin](#yAxis.softMin),
         * [minPadding](#yAxis.minPadding), [minRange](#yAxis.minRange)
         * as well as [series.threshold](#plotOptions.series.threshold)
         * and [series.softThreshold](#plotOptions.series.softThreshold).
         *
         * @sample {highcharts} highcharts/yaxis/min-startontick-false/
         *         -50 with startOnTick to false
         * @sample {highcharts} highcharts/yaxis/min-startontick-true/
         *         -50 with startOnTick true by default
         * @sample {highstock} stock/xaxis/min-max/
         *         Set min and max on X axis
         * @sample {highmaps} maps/axis/min-max/
         *         Pre-zoomed to a specific area
         *
         * @type      {number|null}
         * @apioption xAxis.min
         */
        /**
         * The dash or dot style of the minor grid lines. For possible values,
         * see [this demonstration](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-dashstyle-all/).
         *
         * @sample {highcharts} highcharts/yaxis/minorgridlinedashstyle/
         *         Long dashes on minor grid lines
         * @sample {highstock} stock/xaxis/minorgridlinedashstyle/
         *         Long dashes on minor grid lines
         *
         * @type      {Highcharts.DashStyleValue}
         * @since     1.2
         */
        minorGridLineDashStyle: "Solid",
        /**
         * Specific tick interval in axis units for the minor ticks. On a linear
         * axis, if `"auto"`, the minor tick interval is calculated as a fifth
         * of the tickInterval. If `null` or `undefined`, minor ticks are not
         * shown.
         *
         * On logarithmic axes, the unit is the power of the value. For example,
         * setting the minorTickInterval to 1 puts one tick on each of 0.1, 1,
         * 10, 100 etc. Setting the minorTickInterval to 0.1 produces 9 ticks
         * between 1 and 10, 10 and 100 etc.
         *
         * If user settings dictate minor ticks to become too dense, they don't
         * make sense, and will be ignored to prevent performance problems.
         *
         * @sample {highcharts} highcharts/yaxis/minortickinterval-null/
         *         Null by default
         * @sample {highcharts} highcharts/yaxis/minortickinterval-5/
         *         5 units
         * @sample {highcharts} highcharts/yaxis/minortickinterval-log-auto/
         *         "auto"
         * @sample {highcharts} highcharts/yaxis/minortickinterval-log/
         *         0.1
         * @sample {highstock} stock/demo/basic-line/
         *         Null by default
         * @sample {highstock} stock/xaxis/minortickinterval-auto/
         *         "auto"
         *
         * @type      {number|string|null}
         * @apioption xAxis.minorTickInterval
         */
        /**
         * The pixel length of the minor tick marks.
         *
         * @sample {highcharts} highcharts/yaxis/minorticklength/
         *         10px on Y axis
         * @sample {highstock} stock/xaxis/minorticks/
         *         10px on Y axis
         */
        minorTickLength: 2,
        /**
         * The position of the minor tick marks relative to the axis line.
         *  Can be one of `inside` and `outside`.
         *
         * @sample {highcharts} highcharts/yaxis/minortickposition-outside/
         *         Outside by default
         * @sample {highcharts} highcharts/yaxis/minortickposition-inside/
         *         Inside
         * @sample {highstock} stock/xaxis/minorticks/
         *         Inside
         *
         * @validvalue ["inside", "outside"]
         */
        minorTickPosition: "outside",
        /**
         * Enable or disable minor ticks. Unless
         * [minorTickInterval](#xAxis.minorTickInterval) is set, the tick
         * interval is calculated as a fifth of the `tickInterval`.
         *
         * On a logarithmic axis, minor ticks are laid out based on a best
         * guess, attempting to enter approximately 5 minor ticks between
         * each major tick.
         *
         * Prior to v6.0.0, ticks were unabled in auto layout by setting
         * `minorTickInterval` to `"auto"`.
         *
         * @productdesc {highcharts}
         * On axes using [categories](#xAxis.categories), minor ticks are not
         * supported.
         *
         * @sample {highcharts} highcharts/yaxis/minorticks-true/
         *         Enabled on linear Y axis
         *
         * @type      {boolean}
         * @default   false
         * @since     6.0.0
         * @apioption xAxis.minorTicks
         */
        /**
         * The pixel width of the minor tick mark.
         *
         * @sample {highcharts} highcharts/yaxis/minortickwidth/
         *         3px width
         * @sample {highstock} stock/xaxis/minorticks/
         *         1px width
         *
         * @type      {number}
         * @default   0
         * @apioption xAxis.minorTickWidth
         */
        /**
         * Padding of the min value relative to the length of the axis. A
         * padding of 0.05 will make a 100px axis 5px longer. This is useful
         * when you don't want the lowest data value to appear on the edge
         * of the plot area. When the axis' `min` option is set or a min extreme
         * is set using `axis.setExtremes()`, the minPadding will be ignored.
         *
         * @productdesc {highstock}
         * For an [ordinal](#xAxis.ordinal) axis, `minPadding` and `maxPadding`
         * are ignored. Use [overscroll](#xAxis.overscroll) instead.
         *
         * @sample {highcharts} highcharts/yaxis/minpadding/
         *         Min padding of 0.2
         * @sample {highstock} stock/xaxis/minpadding-maxpadding/
         *         Greater min- and maxPadding
         * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
         *         Add some padding
         *
         * @default    {highcharts} 0.01
         * @default    {highstock|highmaps} 0
         * @since      1.2.0
         * @product    highcharts highstock gantt
         */
        minPadding: 0.01,
        /**
         * The minimum range to display on this axis. The entire axis will not
         * be allowed to span over a smaller interval than this. For example,
         * for a datetime axis the main unit is milliseconds. If minRange is
         * set to 3600000, you can't zoom in more than to one hour.
         *
         * The default minRange for the x axis is five times the smallest
         * interval between any of the data points.
         *
         * On a logarithmic axis, the unit for the minimum range is the power.
         * So a minRange of 1 means that the axis can be zoomed to 10-100,
         * 100-1000, 1000-10000 etc.
         *
         * **Note**: The `minPadding`, `maxPadding`, `startOnTick` and
         * `endOnTick` settings also affect how the extremes of the axis
         * are computed.
         *
         * @sample {highcharts} highcharts/xaxis/minrange/
         *         Minimum range of 5
         * @sample {highstock} stock/xaxis/minrange/
         *         Max zoom of 6 months overrides user selections
         * @sample {highmaps} maps/axis/minrange/
         *         Minimum range of 1000
         *
         * @type      {number}
         * @apioption xAxis.minRange
         */
        /**
         * The minimum tick interval allowed in axis values. For example on
         * zooming in on an axis with daily data, this can be used to prevent
         * the axis from showing hours. Defaults to the closest distance between
         * two points on the axis.
         *
         * @type      {number}
         * @since     2.3.0
         * @apioption xAxis.minTickInterval
         */
        /**
         * The distance in pixels from the plot area to the axis line.
         * A positive offset moves the axis with it's line, labels and ticks
         * away from the plot area. This is typically used when two or more
         * axes are displayed on the same side of the plot. With multiple
         * axes the offset is dynamically adjusted to avoid collision, this
         * can be overridden by setting offset explicitly.
         *
         * @sample {highcharts} highcharts/yaxis/offset/
         *         Y axis offset of 70
         * @sample {highcharts} highcharts/yaxis/offset-centered/
         *         Axes positioned in the center of the plot
         * @sample {highstock} stock/xaxis/offset/
         *         Y axis offset by 70 px
         *
         * @type {number}
         */
        offset: void 0,
        /**
         * Whether to display the axis on the opposite side of the normal. The
         * normal is on the left side for vertical axes and bottom for
         * horizontal, so the opposite sides will be right and top respectively.
         * This is typically used with dual or multiple axes.
         *
         * @sample {highcharts} highcharts/yaxis/opposite/
         *         Secondary Y axis opposite
         * @sample {highstock} stock/xaxis/opposite/
         *         Y axis on left side
         *
         * @default   {highcharts|highstock|highmaps} false
         * @default   {gantt} true
         */
        opposite: false,
        /**
         * In an ordinal axis, the points are equally spaced in the chart
         * regardless of the actual time or x distance between them. This means
         * that missing data periods (e.g. nights or weekends for a stock chart)
         * will not take up space in the chart.
         * Having `ordinal: false` will show any gaps created by the `gapSize`
         * setting proportionate to their duration.
         *
         * In stock charts the X axis is ordinal by default, unless
         * the boost module is used and at least one of the series' data length
         * exceeds the [boostThreshold](#series.line.boostThreshold).
         *
         * For an ordinal axis, `minPadding` and `maxPadding` are ignored. Use
         * [overscroll](#xAxis.overscroll) instead.
         *
         * @sample {highstock} stock/xaxis/ordinal-true/
         *         True by default
         * @sample {highstock} stock/xaxis/ordinal-false/
         *         False
         *
         * @see [overscroll](#xAxis.overscroll)
         *
         * @type      {boolean}
         * @default   true
         * @since     1.1
         * @product   highstock
         * @apioption xAxis.ordinal
         */
        /**
         * Additional range on the right side of the xAxis. Works similar to
         * `xAxis.maxPadding`, but value is set in milliseconds. Can be set for
         * both main `xAxis` and the navigator's `xAxis`.
         *
         * @sample {highstock} stock/xaxis/overscroll/
         *         One minute overscroll with live data
         *
         * @type      {number}
         * @default   0
         * @since     6.0.0
         * @product   highstock
         * @apioption xAxis.overscroll
         */
        /**
         * Refers to the index in the [panes](#panes) array. Used for circular
         * gauges and polar charts. When the option is not set then first pane
         * will be used.
         *
         * @sample highcharts/demo/gauge-vu-meter
         *         Two gauges with different center
         *
         * @type      {number}
         * @product   highcharts
         * @apioption xAxis.pane
         */
        /**
         * The zoomed range to display when only defining one or none of `min`
         * or `max`. For example, to show the latest month, a range of one month
         * can be set.
         *
         * @sample {highstock} stock/xaxis/range/
         *         Setting a zoomed range when the rangeSelector is disabled
         *
         * @type      {number}
         * @product   highstock
         * @apioption xAxis.range
         */
        /**
         * Whether to reverse the axis so that the highest number is closest
         * to the origin. If the chart is inverted, the x axis is reversed by
         * default.
         *
         * @sample {highcharts} highcharts/yaxis/reversed/
         *         Reversed Y axis
         * @sample {highstock} stock/xaxis/reversed/
         *         Reversed Y axis
         *
         * @type      {boolean}
         * @default   undefined
         * @apioption xAxis.reversed
         */
        reversed: void 0,
        /**
         * This option determines how stacks should be ordered within a group.
         * For example reversed xAxis also reverses stacks, so first series
         * comes last in a group. To keep order like for non-reversed xAxis
         * enable this option.
         *
         * @sample {highcharts} highcharts/xaxis/reversedstacks/
         *         Reversed stacks comparison
         * @sample {highstock} highcharts/xaxis/reversedstacks/
         *         Reversed stacks comparison
         *
         * @since     6.1.1
         * @product   highcharts highstock
         */
        reversedStacks: false,
        /**
         * An optional scrollbar to display on the X axis in response to
         * limiting the minimum and maximum of the axis values.
         *
         * In styled mode, all the presentational options for the scrollbar are
         * replaced by the classes `.highcharts-scrollbar-thumb`,
         * `.highcharts-scrollbar-arrow`, `.highcharts-scrollbar-button`,
         * `.highcharts-scrollbar-rifles` and `.highcharts-scrollbar-track`.
         *
         * @sample {highstock} stock/yaxis/heatmap-scrollbars/
         *         Heatmap with both scrollbars
         *
         * @extends   scrollbar
         * @since     4.2.6
         * @product   highstock
         * @apioption xAxis.scrollbar
         */
        /**
         * Whether to show the axis line and title when the axis has no data.
         *
         * @sample {highcharts} highcharts/yaxis/showempty/
         *         When clicking the legend to hide series, one axis preserves
         *         line and title, the other doesn't
         * @sample {highstock} highcharts/yaxis/showempty/
         *         When clicking the legend to hide series, one axis preserves
         *         line and title, the other doesn't
         *
         * @since     1.1
         */
        showEmpty: true,
        /**
         * Whether to show the first tick label.
         *
         * @sample {highcharts} highcharts/xaxis/showfirstlabel-false/
         *         Set to false on X axis
         * @sample {highstock} stock/xaxis/showfirstlabel/
         *         Labels below plot lines on Y axis
         */
        showFirstLabel: true,
        /**
         * Whether to show the last tick label. Defaults to `true` on cartesian
         * charts, and `false` on polar charts.
         *
         * @sample {highcharts} highcharts/xaxis/showlastlabel-true/
         *         Set to true on X axis
         * @sample {highstock} stock/xaxis/showfirstlabel/
         *         Labels below plot lines on Y axis
         *
         * @product   highcharts highstock gantt
         */
        showLastLabel: true,
        /**
         * A soft maximum for the axis. If the series data maximum is less than
         * this, the axis will stay at this maximum, but if the series data
         * maximum is higher, the axis will flex to show all data.
         *
         * @sample highcharts/yaxis/softmin-softmax/
         *         Soft min and max
         *
         * @type      {number}
         * @since     5.0.1
         * @product   highcharts highstock gantt
         * @apioption xAxis.softMax
         */
        /**
         * A soft minimum for the axis. If the series data minimum is greater
         * than this, the axis will stay at this minimum, but if the series
         * data minimum is lower, the axis will flex to show all data.
         *
         * @sample highcharts/yaxis/softmin-softmax/
         *         Soft min and max
         *
         * @type      {number}
         * @since     5.0.1
         * @product   highcharts highstock gantt
         * @apioption xAxis.softMin
         */
        /**
         * For datetime axes, this decides where to put the tick between weeks.
         *  0 = Sunday, 1 = Monday.
         *
         * @sample {highcharts} highcharts/xaxis/startofweek-monday/
         *         Monday by default
         * @sample {highcharts} highcharts/xaxis/startofweek-sunday/
         *         Sunday
         * @sample {highstock} stock/xaxis/startofweek-1
         *         Monday by default
         * @sample {highstock} stock/xaxis/startofweek-0
         *         Sunday
         *
         * @product highcharts highstock gantt
         */
        startOfWeek: 1,
        /**
         * Whether to force the axis to start on a tick. Use this option with
         * the `minPadding` option to control the axis start.
         *
         * @productdesc {highstock}
         * In Highcharts Stock, `startOnTick` is always `false` when
         * the navigator is enabled, to prevent jumpy scrolling.
         *
         * @sample {highcharts} highcharts/xaxis/startontick-false/
         *         False by default
         * @sample {highcharts} highcharts/xaxis/startontick-true/
         *         True
         *
         * @since 1.2.0
         */
        startOnTick: false,
        /**
         * The amount of ticks to draw on the axis. This opens up for aligning
         * the ticks of multiple charts or panes within a chart. This option
         * overrides the `tickPixelInterval` option.
         *
         * This option only has an effect on linear axes. Datetime, logarithmic
         * or category axes are not affected.
         *
         * @sample {highcharts} highcharts/yaxis/tickamount/
         *         8 ticks on Y axis
         * @sample {highstock} highcharts/yaxis/tickamount/
         *         8 ticks on Y axis
         *
         * @type      {number}
         * @since     4.1.0
         * @product   highcharts highstock gantt
         * @apioption xAxis.tickAmount
         */
        /**
         * The interval of the tick marks in axis units. When `undefined`, the
         * tick interval is computed to approximately follow the
         * [tickPixelInterval](#xAxis.tickPixelInterval) on linear and datetime
         * axes. On categorized axes, a `undefined` tickInterval will default to
         * 1, one category. Note that datetime axes are based on milliseconds,
         * so for example an interval of one day is expressed as
         * `24 * 3600 * 1000`.
         *
         * On logarithmic axes, the tickInterval is based on powers, so a
         * tickInterval of 1 means one tick on each of 0.1, 1, 10, 100 etc. A
         * tickInterval of 2 means a tick of 0.1, 10, 1000 etc. A tickInterval
         * of 0.2 puts a tick on 0.1, 0.2, 0.4, 0.6, 0.8, 1, 2, 4, 6, 8, 10, 20,
         * 40 etc.
         *
         *
         * If the tickInterval is too dense for labels to be drawn, Highcharts
         * may remove ticks.
         *
         * If the chart has multiple axes, the [alignTicks](#chart.alignTicks)
         * option may interfere with the `tickInterval` setting.
         *
         * @see [tickPixelInterval](#xAxis.tickPixelInterval)
         * @see [tickPositions](#xAxis.tickPositions)
         * @see [tickPositioner](#xAxis.tickPositioner)
         *
         * @sample {highcharts} highcharts/xaxis/tickinterval-5/
         *         Tick interval of 5 on a linear axis
         * @sample {highstock} stock/xaxis/tickinterval/
         *         Tick interval of 0.01 on Y axis
         *
         * @type      {number}
         * @apioption xAxis.tickInterval
         */
        /**
         * The pixel length of the main tick marks.
         *
         * @sample {highcharts} highcharts/xaxis/ticklength/
         *         20 px tick length on the X axis
         * @sample {highstock} stock/xaxis/ticks/
         *         Formatted ticks on X axis
         */
        tickLength: 10,
        /**
         * If tickInterval is `null` this option sets the approximate pixel
         * interval of the tick marks. Not applicable to categorized axis.
         *
         * The tick interval is also influenced by the [minTickInterval](
         * #xAxis.minTickInterval) option, that, by default prevents ticks from
         * being denser than the data points.
         *
         * @see [tickInterval](#xAxis.tickInterval)
         * @see [tickPositioner](#xAxis.tickPositioner)
         * @see [tickPositions](#xAxis.tickPositions)
         *
         * @sample {highcharts} highcharts/xaxis/tickpixelinterval-50/
         *         50 px on X axis
         * @sample {highstock} stock/xaxis/tickpixelinterval/
         *         200 px on X axis
         */
        tickPixelInterval: 100,
        /**
         * For categorized axes only. If `on` the tick mark is placed in the
         * center of the category, if `between` the tick mark is placed between
         * categories. The default is `between` if the `tickInterval` is 1, else
         * `on`.
         *
         * @sample {highcharts} highcharts/xaxis/tickmarkplacement-between/
         *         "between" by default
         * @sample {highcharts} highcharts/xaxis/tickmarkplacement-on/
         *         "on"
         *
         * @product    highcharts gantt
         * @validvalue ["on", "between"]
         */
        tickmarkPlacement: "between",
        /**
         * The position of the major tick marks relative to the axis line.
         * Can be one of `inside` and `outside`.
         *
         * @sample {highcharts} highcharts/xaxis/tickposition-outside/
         *         "outside" by default
         * @sample {highcharts} highcharts/xaxis/tickposition-inside/
         *         "inside"
         * @sample {highstock} stock/xaxis/ticks/
         *         Formatted ticks on X axis
         *
         * @validvalue ["inside", "outside"]
         */
        tickPosition: "outside",
        /**
         * A callback function returning array defining where the ticks are
         * laid out on the axis. This overrides the default behaviour of
         * [tickPixelInterval](#xAxis.tickPixelInterval) and [tickInterval](
         * #xAxis.tickInterval). The automatic tick positions are accessible
         * through `this.tickPositions` and can be modified by the callback.
         *
         * @see [tickPositions](#xAxis.tickPositions)
         *
         * @sample {highcharts} highcharts/xaxis/tickpositions-tickpositioner/
         *         Demo of tickPositions and tickPositioner
         * @sample {highstock} highcharts/xaxis/tickpositions-tickpositioner/
         *         Demo of tickPositions and tickPositioner
         *
         * @type      {Highcharts.AxisTickPositionerCallbackFunction}
         * @apioption xAxis.tickPositioner
         */
        /**
         * An array defining where the ticks are laid out on the axis. This
         * overrides the default behaviour of [tickPixelInterval](
         * #xAxis.tickPixelInterval) and [tickInterval](#xAxis.tickInterval).
         *
         * @see [tickPositioner](#xAxis.tickPositioner)
         *
         * @sample {highcharts} highcharts/xaxis/tickpositions-tickpositioner/
         *         Demo of tickPositions and tickPositioner
         * @sample {highstock} highcharts/xaxis/tickpositions-tickpositioner/
         *         Demo of tickPositions and tickPositioner
         *
         * @type      {Array<number>}
         * @apioption xAxis.tickPositions
         */
        /**
         * The pixel width of the major tick marks. Defaults to 0 on category
         * axes, otherwise 1.
         *
         * In styled mode, the stroke width is given in the `.highcharts-tick`
         * class, but in order for the element to be generated on category axes,
         * the option must be explicitly set to 1.
         *
         * @sample {highcharts} highcharts/xaxis/tickwidth/
         *         10 px width
         * @sample {highcharts} highcharts/css/axis-grid/
         *         Styled mode
         * @sample {highstock} stock/xaxis/ticks/
         *         Formatted ticks on X axis
         * @sample {highstock} highcharts/css/axis-grid/
         *         Styled mode
         *
         * @type      {undefined|number}
         * @default   {highstock} 1
         * @default   {highmaps} 0
         * @apioption xAxis.tickWidth
         */
        /**
         * The axis title, showing next to the axis line.
         *
         * @productdesc {highmaps}
         * In Highmaps, the axis is hidden by default, but adding an axis title
         * is still possible. X axis and Y axis titles will appear at the bottom
         * and left by default.
         */
        title: {
          /**
           * Alignment of the title relative to the axis values. Possible
           * values are "low", "middle" or "high".
           *
           * @sample {highcharts} highcharts/xaxis/title-align-low/
           *         "low"
           * @sample {highcharts} highcharts/xaxis/title-align-center/
           *         "middle" by default
           * @sample {highcharts} highcharts/xaxis/title-align-high/
           *         "high"
           * @sample {highcharts} highcharts/yaxis/title-offset/
           *         Place the Y axis title on top of the axis
           * @sample {highstock} stock/xaxis/title-align/
           *         Aligned to "high" value
           *
           * @type {Highcharts.AxisTitleAlignValue}
           */
          align: "middle",
          /**
           * Deprecated. Set the `text` to `undefined` to disable the title.
           *
           * @deprecated
           * @type      {boolean}
           * @product   highcharts
           * @apioption xAxis.title.enabled
           */
          /**
           * The pixel distance between the axis labels or line and the title.
           * Defaults to 0 for horizontal axes, 10 for vertical
           *
           * @sample {highcharts} highcharts/xaxis/title-margin/
           *         Y axis title margin of 60
           *
           * @type      {number}
           * @apioption xAxis.title.margin
           */
          /**
           * The distance of the axis title from the axis line. By default,
           * this distance is computed from the offset width of the labels,
           * the labels' distance from the axis and the title's margin.
           * However when the offset option is set, it overrides all this.
           *
           * @sample {highcharts} highcharts/yaxis/title-offset/
           *         Place the axis title on top of the axis
           * @sample {highstock} highcharts/yaxis/title-offset/
           *         Place the axis title on top of the Y axis
           *
           * @type      {number}
           * @since     2.2.0
           * @apioption xAxis.title.offset
           */
          /**
           * Whether to reserve space for the title when laying out the axis.
           *
           * @type      {boolean}
           * @default   true
           * @since     5.0.11
           * @product   highcharts highstock gantt
           * @apioption xAxis.title.reserveSpace
           */
          /**
           * The rotation of the text in degrees. 0 is horizontal, 270 is
           * vertical reading from bottom to top.
           *
           * @sample {highcharts} highcharts/yaxis/title-offset/
           *         Horizontal
           */
          rotation: 0,
          /**
           * The actual text of the axis title. It can contain basic HTML tags
           * like `b`, `i` and `span` with style.
           *
           * @sample {highcharts} highcharts/xaxis/title-text/
           *         Custom HTML
           * @sample {highstock} stock/xaxis/title-text/
           *         Titles for both axes
           *
           * @type      {string|null}
           * @apioption xAxis.title.text
           */
          /**
           * Alignment of the text, can be `"left"`, `"right"` or `"center"`.
           * Default alignment depends on the
           * [title.align](xAxis.title.align):
           *
           * Horizontal axes:
           * - for `align` = `"low"`, `textAlign` is set to `left`
           * - for `align` = `"middle"`, `textAlign` is set to `center`
           * - for `align` = `"high"`, `textAlign` is set to `right`
           *
           * Vertical axes:
           * - for `align` = `"low"` and `opposite` = `true`, `textAlign` is
           *   set to `right`
           * - for `align` = `"low"` and `opposite` = `false`, `textAlign` is
           *   set to `left`
           * - for `align` = `"middle"`, `textAlign` is set to `center`
           * - for `align` = `"high"` and `opposite` = `true` `textAlign` is
           *   set to `left`
           * - for `align` = `"high"` and `opposite` = `false` `textAlign` is
           *   set to `right`
           *
           * @type      {Highcharts.AlignValue}
           * @apioption xAxis.title.textAlign
           */
          /**
           * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
           * to render the axis title.
           *
           * @product   highcharts highstock gantt
           */
          useHTML: false,
          /**
           * Horizontal pixel offset of the title position.
           *
           * @since     4.1.6
           * @product   highcharts highstock gantt
           */
          x: 0,
          /**
           * Vertical pixel offset of the title position.
           *
           * @product   highcharts highstock gantt
           */
          y: 0,
          /**
           * CSS styles for the title. If the title text is longer than the
           * axis length, it will wrap to multiple lines by default. This can
           * be customized by setting `textOverflow: 'ellipsis'`, by
           * setting a specific `width` or by setting `whiteSpace: 'nowrap'`.
           *
           * In styled mode, the stroke width is given in the
           * `.highcharts-axis-title` class.
           *
           * @sample {highcharts} highcharts/xaxis/title-style/
           *         Red
           * @sample {highcharts} highcharts/css/axis/
           *         Styled mode
           *
           * @type    {Highcharts.CSSObject}
           */
          style: {
            /** @internal */
            color: palette.neutralColor60
          }
        },
        /**
         * The type of axis. Can be one of `linear`, `logarithmic`, `datetime`
         * or `category`. In a datetime axis, the numbers are given in
         * milliseconds, and tick marks are placed on appropriate values like
         * full hours or days. In a category axis, the
         * [point names](#series.line.data.name) of the chart's series are used
         * for categories, if not a [categories](#xAxis.categories) array is
         * defined.
         *
         * @sample {highcharts} highcharts/xaxis/type-linear/
         *         Linear
         * @sample {highcharts} highcharts/yaxis/type-log/
         *         Logarithmic
         * @sample {highcharts} highcharts/yaxis/type-log-minorgrid/
         *         Logarithmic with minor grid lines
         * @sample {highcharts} highcharts/xaxis/type-log-both/
         *         Logarithmic on two axes
         * @sample {highcharts} highcharts/yaxis/type-log-negative/
         *         Logarithmic with extension to emulate negative values
         *
         * @type    {Highcharts.AxisTypeValue}
         * @product highcharts gantt
         */
        type: "linear",
        /**
         * If there are multiple axes on the same side of the chart, the pixel
         * margin between the axes. Defaults to 0 on vertical axes, 15 on
         * horizontal axes.
         *
         * @type      {number}
         * @since     7.0.3
         * @apioption xAxis.margin
         */
        /**
         * Applies only when the axis `type` is `category`. When `uniqueNames`
         * is true, points are placed on the X axis according to their names.
         * If the same point name is repeated in the same or another series,
         * the point is placed on the same X position as other points of the
         * same name. When `uniqueNames` is false, the points are laid out in
         * increasing X positions regardless of their names, and the X axis
         * category will take the name of the last point in each position.
         *
         * @sample {highcharts} highcharts/xaxis/uniquenames-true/
         *         True by default
         * @sample {highcharts} highcharts/xaxis/uniquenames-false/
         *         False
         *
         * @since     4.2.7
         * @product   highcharts gantt
         */
        uniqueNames: true,
        /**
         * Datetime axis only. An array determining what time intervals the
         * ticks are allowed to fall on. Each array item is an array where the
         * first value is the time unit and the second value another array of
         * allowed multiples.
         *
         * Defaults to:
         * ```js
         * units: [[
         *     'millisecond', // unit name
         *     [1, 2, 5, 10, 20, 25, 50, 100, 200, 500] // allowed multiples
         * ], [
         *     'second',
         *     [1, 2, 5, 10, 15, 30]
         * ], [
         *     'minute',
         *     [1, 2, 5, 10, 15, 30]
         * ], [
         *     'hour',
         *     [1, 2, 3, 4, 6, 8, 12]
         * ], [
         *     'day',
         *     [1, 2]
         * ], [
         *     'week',
         *     [1, 2]
         * ], [
         *     'month',
         *     [1, 2, 3, 4, 6]
         * ], [
         *     'year',
         *     null
         * ]]
         * ```
         *
         * @type      {Array<Array<string,(Array<number>|null)>>}
         * @product   highcharts highstock gantt
         * @apioption xAxis.units
         */
        /**
         * Whether axis, including axis title, line, ticks and labels, should
         * be visible.
         *
         * @since     4.1.9
         * @product   highcharts highstock gantt
         */
        visible: true,
        /**
         * Color of the minor, secondary grid lines.
         *
         * In styled mode, the stroke width is given in the
         * `.highcharts-minor-grid-line` class.
         *
         * @sample {highcharts} highcharts/yaxis/minorgridlinecolor/
         *         Bright grey lines from Y axis
         * @sample {highcharts|highstock} highcharts/css/axis-grid/
         *         Styled mode
         * @sample {highstock} stock/xaxis/minorgridlinecolor/
         *         Bright grey lines from Y axis
         *
         * @type    {Highcharts.ColorType}
         * @default #f2f2f2
         */
        minorGridLineColor: palette.neutralColor5,
        /**
         * Width of the minor, secondary grid lines.
         *
         * In styled mode, the stroke width is given in the
         * `.highcharts-grid-line` class.
         *
         * @sample {highcharts} highcharts/yaxis/minorgridlinewidth/
         *         2px lines from Y axis
         * @sample {highcharts|highstock} highcharts/css/axis-grid/
         *         Styled mode
         * @sample {highstock} stock/xaxis/minorgridlinewidth/
         *         2px lines from Y axis
         */
        minorGridLineWidth: 1,
        /**
         * Color for the minor tick marks.
         *
         * @sample {highcharts} highcharts/yaxis/minortickcolor/
         *         Black tick marks on Y axis
         * @sample {highstock} stock/xaxis/minorticks/
         *         Black tick marks on Y axis
         *
         * @type    {Highcharts.ColorType}
         * @default #999999
         */
        minorTickColor: palette.neutralColor40,
        /**
         * The color of the line marking the axis itself.
         *
         * In styled mode, the line stroke is given in the
         * `.highcharts-axis-line` or `.highcharts-xaxis-line` class.
         *
         * @productdesc {highmaps}
         * In Highmaps, the axis line is hidden by default, because the axis is
         * not visible by default.
         *
         * @sample {highcharts} highcharts/yaxis/linecolor/
         *         A red line on Y axis
         * @sample {highcharts|highstock} highcharts/css/axis/
         *         Axes in styled mode
         * @sample {highstock} stock/xaxis/linecolor/
         *         A red line on X axis
         *
         * @type    {Highcharts.ColorType}
         * @default #ccd6eb
         */
        lineColor: palette.highlightColor20,
        /**
         * The width of the line marking the axis itself.
         *
         * In styled mode, the stroke width is given in the
         * `.highcharts-axis-line` or `.highcharts-xaxis-line` class.
         *
         * @sample {highcharts} highcharts/yaxis/linecolor/
         *         A 1px line on Y axis
         * @sample {highcharts|highstock} highcharts/css/axis/
         *         Axes in styled mode
         * @sample {highstock} stock/xaxis/linewidth/
         *         A 2px line on X axis
         *
         * @default {highcharts|highstock} 1
         * @default {highmaps} 0
         */
        lineWidth: 1,
        /**
         * Color of the grid lines extending the ticks across the plot area.
         *
         * In styled mode, the stroke is given in the `.highcharts-grid-line`
         * class.
         *
         * @productdesc {highmaps}
         * In Highmaps, the grid lines are hidden by default.
         *
         * @sample {highcharts} highcharts/yaxis/gridlinecolor/
         *         Green lines
         * @sample {highcharts|highstock} highcharts/css/axis-grid/
         *         Styled mode
         * @sample {highstock} stock/xaxis/gridlinecolor/
         *         Green lines
         *
         * @type    {Highcharts.ColorType}
         * @default #e6e6e6
         */
        gridLineColor: palette.neutralColor10,
        /**
         * The width of the grid lines extending the ticks across the plot area.
         * Defaults to 1 on the Y axis and 0 on the X axis, except for 3d
         * charts.
         *
         * In styled mode, the stroke width is given in the
         * `.highcharts-grid-line` class.
         *
         * @sample {highcharts} highcharts/yaxis/gridlinewidth/
         *         2px lines
         * @sample {highcharts|highstock} highcharts/css/axis-grid/
         *         Styled mode
         * @sample {highstock} stock/xaxis/gridlinewidth/
         *         2px lines
         *
         * @type      {number}
         * @apioption xAxis.gridLineWidth
         */
        gridLineWidth: void 0,
        /**
         * The height as the vertical axis. If it's a number, it is
         * interpreted as pixels.
         *
         * Since Highcharts 2: If it's a percentage string, it is interpreted
         * as percentages of the total plot height.
         *
         * @type      {number|string}
         * @product   highcharts highstock
         * @apioption xAxis.height
         */
        /**
         * The width as the horizontal axis. If it's a number, it is interpreted
         * as pixels.
         *
         * Since Highcharts v5.0.13: If it's a percentage string, it is
         * interpreted as percentages of the total plot width.
         *
         * @type      {number|string}
         * @product   highcharts highstock
         * @apioption xAxis.width
         */
        /**
         * Color for the main tick marks.
         *
         * In styled mode, the stroke is given in the `.highcharts-tick`
         * class.
         *
         * @sample {highcharts} highcharts/xaxis/tickcolor/
         *         Red ticks on X axis
         * @sample {highcharts|highstock} highcharts/css/axis-grid/
         *         Styled mode
         * @sample {highstock} stock/xaxis/ticks/
         *         Formatted ticks on X axis
         *
         * @type    {Highcharts.ColorType}
         * @default #ccd6eb
         */
        tickColor: palette.highlightColor20
        // tickWidth: 1
      };
      AxisDefaults2.defaultYAxisOptions = {
        /**
         * The type of axis. Can be one of `linear`, `logarithmic`, `datetime`,
         * `category` or `treegrid`. Defaults to `treegrid` for Gantt charts,
         * `linear` for other chart types.
         *
         * In a datetime axis, the numbers are given in milliseconds, and tick
         * marks are placed on appropriate values, like full hours or days. In a
         * category or treegrid axis, the [point names](#series.line.data.name)
         * of the chart's series are used for categories, if a
         * [categories](#xAxis.categories) array is not defined.
         *
         * @sample {highcharts} highcharts/yaxis/type-log-minorgrid/
         *         Logarithmic with minor grid lines
         * @sample {highcharts} highcharts/yaxis/type-log-negative/
         *         Logarithmic with extension to emulate negative values
         * @sample {gantt} gantt/treegrid-axis/demo
         *         Treegrid axis
         *
         * @type      {Highcharts.AxisTypeValue}
         * @default   {highcharts} linear
         * @default   {gantt} treegrid
         * @product   highcharts gantt
         * @apioption yAxis.type
         */
        /**
         * The height of the Y axis. If it's a number, it is interpreted as
         * pixels.
         *
         * Since Highcharts 2: If it's a percentage string, it is interpreted as
         * percentages of the total plot height.
         *
         * @see [yAxis.top](#yAxis.top)
         *
         * @sample {highstock} stock/demo/candlestick-and-volume/
         *         Percentage height panes
         *
         * @type      {number|string}
         * @product   highcharts highstock
         * @apioption yAxis.height
         */
        /**
         * Solid gauge only. Unless [stops](#yAxis.stops) are set, the color
         * to represent the maximum value of the Y axis.
         *
         * @sample {highcharts} highcharts/yaxis/mincolor-maxcolor/
         *         Min and max colors
         *
         * @type      {Highcharts.ColorType}
         * @default   #003399
         * @since     4.0
         * @product   highcharts
         * @apioption yAxis.maxColor
         */
        /**
         * Solid gauge only. Unless [stops](#yAxis.stops) are set, the color
         * to represent the minimum value of the Y axis.
         *
         * @sample {highcharts} highcharts/yaxis/mincolor-maxcolor/
         *         Min and max color
         *
         * @type      {Highcharts.ColorType}
         * @default   #e6ebf5
         * @since     4.0
         * @product   highcharts
         * @apioption yAxis.minColor
         */
        /**
         * Whether to reverse the axis so that the highest number is closest
         * to the origin.
         *
         * @sample {highcharts} highcharts/yaxis/reversed/
         *         Reversed Y axis
         * @sample {highstock} stock/xaxis/reversed/
         *         Reversed Y axis
         *
         * @type      {boolean}
         * @default   {highcharts} false
         * @default   {highstock} false
         * @default   {highmaps} true
         * @default   {gantt} true
         * @apioption yAxis.reversed
         */
        /**
         * If `true`, the first series in a stack will be drawn on top in a
         * positive, non-reversed Y axis. If `false`, the first series is in
         * the base of the stack.
         *
         * @sample {highcharts} highcharts/yaxis/reversedstacks-false/
         *         Non-reversed stacks
         * @sample {highstock} highcharts/yaxis/reversedstacks-false/
         *         Non-reversed stacks
         *
         * @type      {boolean}
         * @default   true
         * @since     3.0.10
         * @product   highcharts highstock
         * @apioption yAxis.reversedStacks
         */
        reversedStacks: true,
        /**
         * Solid gauge series only. Color stops for the solid gauge. Use this
         * in cases where a linear gradient between a `minColor` and `maxColor`
         * is not sufficient. The stops is an array of tuples, where the first
         * item is a float between 0 and 1 assigning the relative position in
         * the gradient, and the second item is the color.
         *
         * For solid gauges, the Y axis also inherits the concept of
         * [data classes](https://api.highcharts.com/highmaps#colorAxis.dataClasses)
         * from the Highmaps color axis.
         *
         * @see [minColor](#yAxis.minColor)
         * @see [maxColor](#yAxis.maxColor)
         *
         * @sample {highcharts} highcharts/demo/gauge-solid/
         *         True by default
         *
         * @type      {Array<Array<number,Highcharts.ColorType>>}
         * @since     4.0
         * @product   highcharts
         * @apioption yAxis.stops
         */
        /**
         * The pixel width of the major tick marks.
         *
         * @sample {highcharts} highcharts/xaxis/tickwidth/ 10 px width
         * @sample {highstock} stock/xaxis/ticks/ Formatted ticks on X axis
         *
         * @type      {number}
         * @default   0
         * @product   highcharts highstock gantt
         * @apioption yAxis.tickWidth
         */
        /**
         * Whether to force the axis to end on a tick. Use this option with
         * the `maxPadding` option to control the axis end.
         *
         * This option is always disabled, when panning type is
         * either `y` or `xy`.
         *
         * @see [type](#chart.panning.type)
         *
         *
         * @sample {highcharts} highcharts/chart/reflow-true/
         *         True by default
         * @sample {highcharts} highcharts/yaxis/endontick/
         *         False
         * @sample {highstock} stock/demo/basic-line/
         *         True by default
         * @sample {highstock} stock/xaxis/endontick/
         *         False for Y axis
         *
         * @since 1.2.0
         */
        endOnTick: true,
        /**
         * Padding of the max value relative to the length of the axis. A
         * padding of 0.05 will make a 100px axis 5px longer. This is useful
         * when you don't want the highest data value to appear on the edge
         * of the plot area. When the axis' `max` option is set or a max extreme
         * is set using `axis.setExtremes()`, the maxPadding will be ignored.
         *
         * Also the `softThreshold` option takes precedence over `maxPadding`,
         * so if the data is tangent to the threshold, `maxPadding` may not
         * apply unless `softThreshold` is set to false.
         *
         * @sample {highcharts} highcharts/yaxis/maxpadding-02/
         *         Max padding of 0.2
         * @sample {highstock} stock/xaxis/minpadding-maxpadding/
         *         Greater min- and maxPadding
         *
         * @since   1.2.0
         * @product highcharts highstock gantt
         */
        maxPadding: 0.05,
        /**
         * Padding of the min value relative to the length of the axis. A
         * padding of 0.05 will make a 100px axis 5px longer. This is useful
         * when you don't want the lowest data value to appear on the edge
         * of the plot area. When the axis' `min` option is set or a max extreme
         * is set using `axis.setExtremes()`, the maxPadding will be ignored.
         *
         * Also the `softThreshold` option takes precedence over `minPadding`,
         * so if the data is tangent to the threshold, `minPadding` may not
         * apply unless `softThreshold` is set to false.
         *
         * @sample {highcharts} highcharts/yaxis/minpadding/
         *         Min padding of 0.2
         * @sample {highstock} stock/xaxis/minpadding-maxpadding/
         *         Greater min- and maxPadding
         *
         * @since   1.2.0
         * @product highcharts highstock gantt
         */
        minPadding: 0.05,
        /**
         * @productdesc {highstock}
         * In Highcharts Stock 1.x, the Y axis was placed
         * on the left side by default.
         *
         * @sample {highcharts} highcharts/yaxis/opposite/
         *         Secondary Y axis opposite
         * @sample {highstock} stock/xaxis/opposite/
         *         Y axis on left side
         *
         * @type      {boolean}
         * @default   {highstock} true
         * @default   {highcharts} false
         * @product   highstock highcharts gantt
         * @apioption yAxis.opposite
         */
        /**
         * @see [tickInterval](#xAxis.tickInterval)
         * @see [tickPositioner](#xAxis.tickPositioner)
         * @see [tickPositions](#xAxis.tickPositions)
         */
        tickPixelInterval: 72,
        showLastLabel: true,
        /**
         * @extends xAxis.labels
         */
        labels: {
          /**
           * Angular gauges and solid gauges only.
           * The label's pixel distance from the perimeter of the plot area.
           *
           * Since v7.1.2: If it's a percentage string, it is interpreted the
           * same as [series.radius](#plotOptions.gauge.radius), so label can be
           * aligned under the gauge's shape.
           *
           * @sample {highcharts} highcharts/yaxis/labels-distance/
           *         Labels centered under the arc
           *
           * @type      {number|string}
           * @default   -25
           * @product   highcharts
           * @apioption yAxis.labels.distance
           */
          /**
           * The y position offset of all labels relative to the tick
           * positions on the axis. For polar and radial axis consider the use
           * of the [distance](#yAxis.labels.distance) option.
           *
           * @sample {highcharts} highcharts/xaxis/labels-x/
           *         Y axis labels placed on grid lines
           *
           * @type      {number}
           * @default   {highcharts} 3
           * @default   {highstock} -2
           * @default   {highmaps} 3
           * @apioption yAxis.labels.y
           */
          /**
           * What part of the string the given position is anchored to. Can
           * be one of `"left"`, `"center"` or `"right"`. The exact position
           * also depends on the `labels.x` setting.
           *
           * Angular gauges and solid gauges defaults to `"center"`.
           * Solid gauges with two labels have additional option `"auto"`
           * for automatic horizontal and vertical alignment.
           *
           * @see [yAxis.labels.distance](#yAxis.labels.distance)
           *
           * @sample {highcharts} highcharts/yaxis/labels-align-left/
           *         Left
           * @sample {highcharts} highcharts/series-solidgauge/labels-auto-aligned/
           *         Solid gauge labels auto aligned
           *
           * @type       {Highcharts.AlignValue}
           * @default    {highcharts|highmaps} right
           * @default    {highstock} left
           * @apioption  yAxis.labels.align
           */
          /**
           * The x position offset of all labels relative to the tick
           * positions on the axis. Defaults to -15 for left axis, 15 for
           * right axis.
           *
           * @sample {highcharts} highcharts/xaxis/labels-x/
           *         Y axis labels placed on grid lines
           */
          x: -8
        },
        /**
         * @productdesc {highmaps}
         * In Highmaps, the axis line is hidden by default, because the axis is
         * not visible by default.
         *
         * @type      {Highcharts.ColorType}
         * @apioption yAxis.lineColor
         */
        /**
         * @sample {highcharts} highcharts/yaxis/max-200/
         *         Y axis max of 200
         * @sample {highcharts} highcharts/yaxis/max-logarithmic/
         *         Y axis max on logarithmic axis
         * @sample {highstock} stock/yaxis/min-max/
         *         Fixed min and max on Y axis
         * @sample {highmaps} maps/axis/min-max/
         *         Pre-zoomed to a specific area
         *
         * @apioption yAxis.max
         */
        /**
         * @sample {highcharts} highcharts/yaxis/min-startontick-false/
         *         -50 with startOnTick to false
         * @sample {highcharts} highcharts/yaxis/min-startontick-true/
         *         -50 with startOnTick true by default
         * @sample {highstock} stock/yaxis/min-max/
         *         Fixed min and max on Y axis
         * @sample {highmaps} maps/axis/min-max/
         *         Pre-zoomed to a specific area
         *
         * @apioption yAxis.min
         */
        /**
         * An optional scrollbar to display on the Y axis in response to
         * limiting the minimum an maximum of the axis values.
         *
         * In styled mode, all the presentational options for the scrollbar
         * are replaced by the classes `.highcharts-scrollbar-thumb`,
         * `.highcharts-scrollbar-arrow`, `.highcharts-scrollbar-button`,
         * `.highcharts-scrollbar-rifles` and `.highcharts-scrollbar-track`.
         *
         * @sample {highstock} stock/yaxis/scrollbar/
         *         Scrollbar on the Y axis
         *
         * @extends   scrollbar
         * @since     4.2.6
         * @product   highstock
         * @excluding height
         * @apioption yAxis.scrollbar
         */
        /**
         * Enable the scrollbar on the Y axis.
         *
         * @sample {highstock} stock/yaxis/scrollbar/
         *         Enabled on Y axis
         *
         * @type      {boolean}
         * @default   false
         * @since     4.2.6
         * @product   highstock
         * @apioption yAxis.scrollbar.enabled
         */
        /**
         * Pixel margin between the scrollbar and the axis elements.
         *
         * @type      {number}
         * @default   10
         * @since     4.2.6
         * @product   highstock
         * @apioption yAxis.scrollbar.margin
         */
        /**
         * Whether to show the scrollbar when it is fully zoomed out at max
         * range. Setting it to `false` on the Y axis makes the scrollbar stay
         * hidden until the user zooms in, like common in browsers.
         *
         * @type      {boolean}
         * @default   true
         * @since     4.2.6
         * @product   highstock
         * @apioption yAxis.scrollbar.showFull
         */
        /**
         * The width of a vertical scrollbar or height of a horizontal
         * scrollbar. Defaults to 20 on touch devices.
         *
         * @type      {number}
         * @default   14
         * @since     4.2.6
         * @product   highstock
         * @apioption yAxis.scrollbar.size
         */
        /**
         * Z index of the scrollbar elements.
         *
         * @type      {number}
         * @default   3
         * @since     4.2.6
         * @product   highstock
         * @apioption yAxis.scrollbar.zIndex
         */
        /**
         * A soft maximum for the axis. If the series data maximum is less
         * than this, the axis will stay at this maximum, but if the series
         * data maximum is higher, the axis will flex to show all data.
         *
         * **Note**: The [series.softThreshold](
         * #plotOptions.series.softThreshold) option takes precedence over this
         * option.
         *
         * @sample highcharts/yaxis/softmin-softmax/
         *         Soft min and max
         *
         * @type      {number}
         * @since     5.0.1
         * @product   highcharts highstock gantt
         * @apioption yAxis.softMax
         */
        /**
         * A soft minimum for the axis. If the series data minimum is greater
         * than this, the axis will stay at this minimum, but if the series
         * data minimum is lower, the axis will flex to show all data.
         *
         * **Note**: The [series.softThreshold](
         * #plotOptions.series.softThreshold) option takes precedence over this
         * option.
         *
         * @sample highcharts/yaxis/softmin-softmax/
         *         Soft min and max
         *
         * @type      {number}
         * @since     5.0.1
         * @product   highcharts highstock gantt
         * @apioption yAxis.softMin
         */
        /**
         * Defines the horizontal alignment of the stack total label. Can be one
         * of `"left"`, `"center"` or `"right"`. The default value is calculated
         * at runtime and depends on orientation and whether the stack is
         * positive or negative.
         *
         * @sample {highcharts} highcharts/yaxis/stacklabels-align-left/
         *         Aligned to the left
         * @sample {highcharts} highcharts/yaxis/stacklabels-align-center/
         *         Aligned in center
         * @sample {highcharts} highcharts/yaxis/stacklabels-align-right/
         *         Aligned to the right
         *
         * @type      {Highcharts.AlignValue}
         * @since     2.1.5
         * @product   highcharts
         * @apioption yAxis.stackLabels.align
         */
        /**
         * A format string for the data label. Available variables are the same
         * as for `formatter`.
         *
         * @type      {string}
         * @default   {total}
         * @since     3.0.2
         * @product   highcharts highstock
         * @apioption yAxis.stackLabels.format
         */
        /**
         * Rotation of the labels in degrees.
         *
         * @sample {highcharts} highcharts/yaxis/stacklabels-rotation/
         *         Labels rotated 45°
         *
         * @type      {number}
         * @default   0
         * @since     2.1.5
         * @product   highcharts
         * @apioption yAxis.stackLabels.rotation
         */
        /**
         * The text alignment for the label. While `align` determines where the
         * texts anchor point is placed with regards to the stack, `textAlign`
         * determines how the text is aligned against its anchor point. Possible
         * values are `"left"`, `"center"` and `"right"`. The default value is
         * calculated at runtime and depends on orientation and whether the
         * stack is positive or negative.
         *
         * @sample {highcharts} highcharts/yaxis/stacklabels-textalign-left/
         *         Label in center position but text-aligned left
         *
         * @type      {Highcharts.AlignValue}
         * @since     2.1.5
         * @product   highcharts
         * @apioption yAxis.stackLabels.textAlign
         */
        /**
         * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
         * to render the labels.
         *
         * @type      {boolean}
         * @default   false
         * @since     3.0
         * @product   highcharts highstock
         * @apioption yAxis.stackLabels.useHTML
         */
        /**
         * Defines the vertical alignment of the stack total label. Can be one
         * of `"top"`, `"middle"` or `"bottom"`. The default value is calculated
         * at runtime and depends on orientation and whether the stack is
         * positive or negative.
         *
         * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-top/
         *         Vertically aligned top
         * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-middle/
         *         Vertically aligned middle
         * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-bottom/
         *         Vertically aligned bottom
         *
         * @type      {Highcharts.VerticalAlignValue}
         * @since     2.1.5
         * @product   highcharts
         * @apioption yAxis.stackLabels.verticalAlign
         */
        /**
         * The x position offset of the label relative to the left of the
         * stacked bar. The default value is calculated at runtime and depends
         * on orientation and whether the stack is positive or negative.
         *
         * @sample {highcharts} highcharts/yaxis/stacklabels-x/
         *         Stack total labels with x offset
         *
         * @type      {number}
         * @since     2.1.5
         * @product   highcharts
         * @apioption yAxis.stackLabels.x
         */
        /**
         * The y position offset of the label relative to the tick position
         * on the axis. The default value is calculated at runtime and depends
         * on orientation and whether the stack is positive or negative.
         *
         * @sample {highcharts} highcharts/yaxis/stacklabels-y/
         *         Stack total labels with y offset
         *
         * @type      {number}
         * @since     2.1.5
         * @product   highcharts
         * @apioption yAxis.stackLabels.y
         */
        /**
         * Whether to force the axis to start on a tick. Use this option with
         * the `maxPadding` option to control the axis start.
         *
         * This option is always disabled, when panning type is
         * either `y` or `xy`.
         *
         * @see [type](#chart.panning.type)
         *
         * @sample {highcharts} highcharts/xaxis/startontick-false/
         *         False by default
         * @sample {highcharts} highcharts/xaxis/startontick-true/
         *         True
         * @sample {highstock} stock/xaxis/endontick/
         *         False for Y axis
         *
         * @since   1.2.0
         * @product highcharts highstock gantt
         */
        startOnTick: true,
        title: {
          /**
           * The pixel distance between the axis labels and the title.
           * Positive values are outside the axis line, negative are inside.
           *
           * @sample {highcharts} highcharts/xaxis/title-margin/
           *         Y axis title margin of 60
           *
           * @type      {number}
           * @default   40
           * @apioption yAxis.title.margin
           */
          /**
           * The rotation of the text in degrees. 0 is horizontal, 270 is
           * vertical reading from bottom to top.
           *
           * @sample {highcharts} highcharts/yaxis/title-offset/
           *         Horizontal
           */
          rotation: 270,
          /**
           * The actual text of the axis title. Horizontal texts can contain
           * HTML, but rotated texts are painted using vector techniques and
           * must be clean text. The Y axis title is disabled by setting the
           * `text` option to `undefined`.
           *
           * @sample {highcharts} highcharts/xaxis/title-text/
           *         Custom HTML
           *
           * @type    {string|null}
           * @default {highcharts} Values
           * @default {highstock} undefined
           * @product highcharts highstock gantt
           */
          text: "Values"
        },
        /**
         * The top position of the Y axis. If it's a number, it is interpreted
         * as pixel position relative to the chart.
         *
         * Since Highcharts 2: If it's a percentage string, it is interpreted as
         * percentages of the plot height, offset from plot area top.
         *
         * @see [yAxis.height](#yAxis.height)
         *
         * @sample {highstock} stock/demo/candlestick-and-volume/
         *         Percentage height panes
         *
         * @type      {number|string}
         * @product   highcharts highstock
         * @apioption yAxis.top
         */
        /**
         * The stack labels show the total value for each bar in a stacked
         * column or bar chart. The label will be placed on top of positive
         * columns and below negative columns. In case of an inverted column
         * chart or a bar chart the label is placed to the right of positive
         * bars and to the left of negative bars.
         *
         * @product highcharts
         */
        stackLabels: {
          /**
           * Enable or disable the initial animation when a series is
           * displayed for the `stackLabels`. The animation can also be set as
           * a configuration object. Please note that this option only
           * applies to the initial animation.
           * For other animations, see [chart.animation](#chart.animation)
           * and the animation parameter under the API methods.
           * The following properties are supported:
           *
           * - `defer`: The animation delay time in milliseconds.
           *
           * @sample {highcharts} highcharts/plotoptions/animation-defer/
           *          Animation defer settings
           * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
           * @since 8.2.0
           * @apioption yAxis.stackLabels.animation
           */
          animation: {},
          /**
           * The animation delay time in milliseconds.
           * Set to `0` renders stackLabel immediately.
           * As `undefined` inherits defer time from the [series.animation.defer](#plotOptions.series.animation.defer).
           *
           * @type      {number}
           * @since 8.2.0
           * @apioption yAxis.stackLabels.animation.defer
           */
          /**
           * Allow the stack labels to overlap.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-allowoverlap-false/
           *         Default false
           *
           * @since   5.0.13
           * @product highcharts
           */
          allowOverlap: false,
          /**
           * The background color or gradient for the stack label.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-box/
           *          Stack labels box options
           * @type      {Highcharts.ColorType}
           * @since 8.1.0
           * @apioption yAxis.stackLabels.backgroundColor
           */
          /**
           * The border color for the stack label. Defaults to `undefined`.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-box/
           *          Stack labels box options
           * @type      {Highcharts.ColorType}
           * @since 8.1.0
           * @apioption yAxis.stackLabels.borderColor
           */
          /**
           * The border radius in pixels for the stack label.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-box/
           *          Stack labels box options
           * @type      {number}
           * @default   0
           * @since 8.1.0
           * @apioption yAxis.stackLabels.borderRadius
           */
          /**
           * The border width in pixels for the stack label.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-box/
           *          Stack labels box options
           * @type      {number}
           * @default   0
           * @since 8.1.0
           * @apioption yAxis.stackLabels.borderWidth
           */
          /**
           * Enable or disable the stack total labels.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-enabled/
           *         Enabled stack total labels
           * @sample {highcharts} highcharts/yaxis/stacklabels-enabled-waterfall/
           *         Enabled stack labels in waterfall chart
           *
           * @since   2.1.5
           * @product highcharts
           */
          enabled: false,
          /**
           * Whether to hide stack labels that are outside the plot area.
           * By default, the stack label is moved
           * inside the plot area according to the
           * [overflow](/highcharts/#yAxis/stackLabels/overflow)
           * option.
           *
           * @type  {boolean}
           * @since 7.1.3
           */
          crop: true,
          /**
           * How to handle stack total labels that flow outside the plot area.
           * The default is set to `"justify"`,
           * which aligns them inside the plot area.
           * For columns and bars, this means it will be moved inside the bar.
           * To display stack labels outside the plot area,
           * set `crop` to `false` and `overflow` to `"allow"`.
           *
           * @sample highcharts/yaxis/stacklabels-overflow/
           *         Stack labels flows outside the plot area.
           *
           * @type  {Highcharts.DataLabelsOverflowValue}
           * @since 7.1.3
           */
          overflow: "justify",
          /* eslint-disable valid-jsdoc */
          /**
           * Callback JavaScript function to format the label. The value is
           * given by `this.total`.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-formatter/
           *         Added units to stack total value
           *
           * @type    {Highcharts.FormatterCallbackFunction<Highcharts.StackItemObject>}
           * @since   2.1.5
           * @product highcharts
           */
          formatter: function() {
            var numberFormatter = this.axis.chart.numberFormatter;
            return numberFormatter(this.total, -1);
          },
          /**
           * CSS styles for the label.
           *
           * In styled mode, the styles are set in the
           * `.highcharts-stack-label` class.
           *
           * @sample {highcharts} highcharts/yaxis/stacklabels-style/
           *         Red stack total labels
           *
           * @type    {Highcharts.CSSObject}
           * @since   2.1.5
           * @product highcharts
           */
          style: {
            /** @internal */
            color: palette.neutralColor100,
            /** @internal */
            fontSize: "11px",
            /** @internal */
            fontWeight: "bold",
            /** @internal */
            textOutline: "1px contrast"
          }
        },
        gridLineWidth: 1,
        lineWidth: 0
        // tickWidth: 0
      };
      AxisDefaults2.defaultLeftAxisOptions = {
        labels: {
          x: -15
        },
        title: {
          rotation: 270
        }
      };
      AxisDefaults2.defaultRightAxisOptions = {
        labels: {
          x: 15
        },
        title: {
          rotation: 90
        }
      };
      AxisDefaults2.defaultBottomAxisOptions = {
        labels: {
          autoRotation: [-45],
          x: 0
          // overflow: undefined,
          // staggerLines: null
        },
        margin: 15,
        title: {
          rotation: 0
        }
      };
      AxisDefaults2.defaultTopAxisOptions = {
        labels: {
          autoRotation: [-45],
          x: 0
          // overflow: undefined
          // staggerLines: null
        },
        margin: 15,
        title: {
          rotation: 0
        }
      };
    })(AxisDefaults || (AxisDefaults = {}));
    const AxisDefaults$1 = AxisDefaults;
    var addEvent$$ = Utilities.addEvent, isFunction$3 = Utilities.isFunction, objectEach$u = Utilities.objectEach, removeEvent$a = Utilities.removeEvent;
    var registerEventOptions$3 = function(component, options) {
      component.eventOptions = component.eventOptions || {};
      objectEach$u(options.events, function(event, eventType) {
        if (component.eventOptions[eventType] !== event) {
          if (component.eventOptions[eventType]) {
            removeEvent$a(component, eventType, component.eventOptions[eventType]);
            delete component.eventOptions[eventType];
          }
          if (isFunction$3(event)) {
            component.eventOptions[eventType] = event;
            addEvent$$(component, eventType, event);
          }
        }
      });
    };
    var exports$6 = {
      registerEventOptions: registerEventOptions$3
    };
    var deg2rad$6 = H.deg2rad;
    var clamp$i = Utilities.clamp, correctFloat$c = Utilities.correctFloat, defined$O = Utilities.defined, destroyObjectProperties$8 = Utilities.destroyObjectProperties, extend$1n = Utilities.extend, fireEvent$z = Utilities.fireEvent, isNumber$I = Utilities.isNumber, merge$1h = Utilities.merge, objectEach$t = Utilities.objectEach, pick$1p = Utilities.pick;
    var Tick = (
      /** @class */
      function() {
        function Tick2(axis, pos, type, noLabel, parameters) {
          this.isNew = true;
          this.isNewLabel = true;
          this.axis = axis;
          this.pos = pos;
          this.type = type || "";
          this.parameters = parameters || {};
          this.tickmarkOffset = this.parameters.tickmarkOffset;
          this.options = this.parameters.options;
          fireEvent$z(this, "init");
          if (!type && !noLabel) {
            this.addLabel();
          }
        }
        Tick2.prototype.addLabel = function() {
          var tick = this, axis = tick.axis, options = axis.options, chart = axis.chart, categories = axis.categories, log = axis.logarithmic, names2 = axis.names, pos = tick.pos, labelOptions = pick$1p(tick.options && tick.options.labels, options.labels), tickPositions = axis.tickPositions, isFirst = pos === tickPositions[0], isLast = pos === tickPositions[tickPositions.length - 1], animateLabels = (!labelOptions.step || labelOptions.step === 1) && axis.tickInterval === 1, tickPositionInfo = tickPositions.info;
          var label = tick.label, dateTimeLabelFormat, dateTimeLabelFormats, i2;
          var value = this.parameters.category || (categories ? pick$1p(categories[pos], names2[pos], pos) : pos);
          if (log && isNumber$I(value)) {
            value = correctFloat$c(log.lin2log(value));
          }
          if (axis.dateTime) {
            if (tickPositionInfo) {
              dateTimeLabelFormats = chart.time.resolveDTLFormat(options.dateTimeLabelFormats[!options.grid && tickPositionInfo.higherRanks[pos] || tickPositionInfo.unitName]);
              dateTimeLabelFormat = dateTimeLabelFormats.main;
            } else if (isNumber$I(value)) {
              dateTimeLabelFormat = axis.dateTime.getXDateFormat(value, options.dateTimeLabelFormats || {});
            }
          }
          tick.isFirst = isFirst;
          tick.isLast = isLast;
          var ctx = {
            axis,
            chart,
            dateTimeLabelFormat,
            isFirst,
            isLast,
            pos,
            tick,
            tickPositionInfo,
            value
          };
          fireEvent$z(this, "labelFormat", ctx);
          var labelFormatter = function(ctx2) {
            if (labelOptions.formatter) {
              return labelOptions.formatter.call(ctx2, ctx2);
            }
            if (labelOptions.format) {
              ctx2.text = axis.defaultLabelFormatter.call(ctx2);
              return FormatUtilities.format(labelOptions.format, ctx2, chart);
            }
            return axis.defaultLabelFormatter.call(ctx2, ctx2);
          };
          var str = labelFormatter.call(ctx, ctx);
          var list = dateTimeLabelFormats && dateTimeLabelFormats.list;
          if (list) {
            tick.shortenLabel = function() {
              for (i2 = 0; i2 < list.length; i2++) {
                extend$1n(ctx, { dateTimeLabelFormat: list[i2] });
                label.attr({
                  text: labelFormatter.call(ctx, ctx)
                });
                if (label.getBBox().width < axis.getSlotWidth(tick) - 2 * labelOptions.padding) {
                  return;
                }
              }
              label.attr({
                text: ""
              });
            };
          } else {
            tick.shortenLabel = void 0;
          }
          if (animateLabels && axis._addedPlotLB) {
            tick.moveLabel(str, labelOptions);
          }
          if (!defined$O(label) && !tick.movedLabel) {
            tick.label = label = tick.createLabel({ x: 0, y: 0 }, str, labelOptions);
            tick.rotation = 0;
          } else if (label && label.textStr !== str && !animateLabels) {
            if (label.textWidth && !labelOptions.style.width && !label.styles.width) {
              label.css({ width: null });
            }
            label.attr({ text: str });
            label.textPxLength = label.getBBox().width;
          }
        };
        Tick2.prototype.createLabel = function(xy, str, labelOptions) {
          var axis = this.axis, chart = axis.chart, label = defined$O(str) && labelOptions.enabled ? chart.renderer.text(str, xy.x, xy.y, labelOptions.useHTML).add(axis.labelGroup) : null;
          if (label) {
            if (!chart.styledMode) {
              label.css(merge$1h(labelOptions.style));
            }
            label.textPxLength = label.getBBox().width;
          }
          return label;
        };
        Tick2.prototype.destroy = function() {
          destroyObjectProperties$8(this, this.axis);
        };
        Tick2.prototype.getPosition = function(horiz, tickPos, tickmarkOffset, old) {
          var axis = this.axis, chart = axis.chart, cHeight = old && chart.oldChartHeight || chart.chartHeight, pos = {
            x: horiz ? correctFloat$c(axis.translate(tickPos + tickmarkOffset, null, null, old) + axis.transB) : axis.left + axis.offset + (axis.opposite ? (old && chart.oldChartWidth || chart.chartWidth) - axis.right - axis.left : 0),
            y: horiz ? cHeight - axis.bottom + axis.offset - (axis.opposite ? axis.height : 0) : correctFloat$c(cHeight - axis.translate(tickPos + tickmarkOffset, null, null, old) - axis.transB)
          };
          pos.y = clamp$i(pos.y, -1e5, 1e5);
          fireEvent$z(this, "afterGetPosition", { pos });
          return pos;
        };
        Tick2.prototype.getLabelPosition = function(x, y, label, horiz, labelOptions, tickmarkOffset, index, step) {
          var axis = this.axis, transA = axis.transA, reversed = (
            // #7911
            axis.isLinked && axis.linkedParent ? axis.linkedParent.reversed : axis.reversed
          ), staggerLines = axis.staggerLines, rotCorr = axis.tickRotCorr || { x: 0, y: 0 }, labelOffsetCorrection = !horiz && !axis.reserveSpaceDefault ? -axis.labelOffset * (axis.labelAlign === "center" ? 0.5 : 1) : 0, pos = {};
          var yOffset = labelOptions.y, line;
          if (!defined$O(yOffset)) {
            if (axis.side === 0) {
              yOffset = label.rotation ? -8 : -label.getBBox().height;
            } else if (axis.side === 2) {
              yOffset = rotCorr.y + 8;
            } else {
              yOffset = Math.cos(label.rotation * deg2rad$6) * (rotCorr.y - label.getBBox(false, 0).height / 2);
            }
          }
          x = x + labelOptions.x + labelOffsetCorrection + rotCorr.x - (tickmarkOffset && horiz ? tickmarkOffset * transA * (reversed ? -1 : 1) : 0);
          y = y + yOffset - (tickmarkOffset && !horiz ? tickmarkOffset * transA * (reversed ? 1 : -1) : 0);
          if (staggerLines) {
            line = index / (step || 1) % staggerLines;
            if (axis.opposite) {
              line = staggerLines - line - 1;
            }
            y += line * (axis.labelOffset / staggerLines);
          }
          pos.x = x;
          pos.y = Math.round(y);
          fireEvent$z(this, "afterGetLabelPosition", { pos, tickmarkOffset, index });
          return pos;
        };
        Tick2.prototype.getLabelSize = function() {
          return this.label ? this.label.getBBox()[this.axis.horiz ? "height" : "width"] : 0;
        };
        Tick2.prototype.getMarkPath = function(x, y, tickLength, tickWidth, horiz, renderer) {
          return renderer.crispLine([[
            "M",
            x,
            y
          ], [
            "L",
            x + (horiz ? 0 : -tickLength),
            y + (horiz ? tickLength : 0)
          ]], tickWidth);
        };
        Tick2.prototype.handleOverflow = function(xy) {
          var tick = this, axis = this.axis, labelOptions = axis.options.labels, pxPos = xy.x, chartWidth = axis.chart.chartWidth, spacing = axis.chart.spacing, leftBound = pick$1p(axis.labelLeft, Math.min(axis.pos, spacing[3])), rightBound = pick$1p(axis.labelRight, Math.max(!axis.isRadial ? axis.pos + axis.len : 0, chartWidth - spacing[1])), label = this.label, rotation = this.rotation, factor = {
            left: 0,
            center: 0.5,
            right: 1
          }[axis.labelAlign || label.attr("align")], labelWidth = label.getBBox().width, slotWidth = axis.getSlotWidth(tick), xCorrection = factor, css2 = {};
          var modifiedSlotWidth = slotWidth, goRight = 1, leftPos, rightPos, textWidth;
          if (!rotation && labelOptions.overflow === "justify") {
            leftPos = pxPos - factor * labelWidth;
            rightPos = pxPos + (1 - factor) * labelWidth;
            if (leftPos < leftBound) {
              modifiedSlotWidth = xy.x + modifiedSlotWidth * (1 - factor) - leftBound;
            } else if (rightPos > rightBound) {
              modifiedSlotWidth = rightBound - xy.x + modifiedSlotWidth * factor;
              goRight = -1;
            }
            modifiedSlotWidth = Math.min(slotWidth, modifiedSlotWidth);
            if (modifiedSlotWidth < slotWidth && axis.labelAlign === "center") {
              xy.x += goRight * (slotWidth - modifiedSlotWidth - xCorrection * (slotWidth - Math.min(labelWidth, modifiedSlotWidth)));
            }
            if (labelWidth > modifiedSlotWidth || axis.autoRotation && (label.styles || {}).width) {
              textWidth = modifiedSlotWidth;
            }
          } else if (rotation < 0 && pxPos - factor * labelWidth < leftBound) {
            textWidth = Math.round(pxPos / Math.cos(rotation * deg2rad$6) - leftBound);
          } else if (rotation > 0 && pxPos + factor * labelWidth > rightBound) {
            textWidth = Math.round((chartWidth - pxPos) / Math.cos(rotation * deg2rad$6));
          }
          if (textWidth) {
            if (tick.shortenLabel) {
              tick.shortenLabel();
            } else {
              css2.width = Math.floor(textWidth) + "px";
              if (!(labelOptions.style || {}).textOverflow) {
                css2.textOverflow = "ellipsis";
              }
              label.css(css2);
            }
          }
        };
        Tick2.prototype.moveLabel = function(str, labelOptions) {
          var tick = this, label = tick.label, axis = tick.axis, reversed = axis.reversed;
          var moved = false, labelPos, xPos, yPos;
          if (label && label.textStr === str) {
            tick.movedLabel = label;
            moved = true;
            delete tick.label;
          } else {
            objectEach$t(axis.ticks, function(currentTick) {
              if (!moved && !currentTick.isNew && currentTick !== tick && currentTick.label && currentTick.label.textStr === str) {
                tick.movedLabel = currentTick.label;
                moved = true;
                currentTick.labelPos = tick.movedLabel.xy;
                delete currentTick.label;
              }
            });
          }
          if (!moved && (tick.labelPos || label)) {
            labelPos = tick.labelPos || label.xy;
            xPos = axis.horiz ? reversed ? 0 : axis.width + axis.left : labelPos.x;
            yPos = axis.horiz ? labelPos.y : reversed ? axis.width + axis.left : 0;
            tick.movedLabel = tick.createLabel({ x: xPos, y: yPos }, str, labelOptions);
            if (tick.movedLabel) {
              tick.movedLabel.attr({ opacity: 0 });
            }
          }
        };
        Tick2.prototype.render = function(index, old, opacity) {
          var tick = this, axis = tick.axis, horiz = axis.horiz, pos = tick.pos, tickmarkOffset = pick$1p(tick.tickmarkOffset, axis.tickmarkOffset), xy = tick.getPosition(horiz, pos, tickmarkOffset, old), x = xy.x, y = xy.y, reverseCrisp = horiz && x === axis.pos + axis.len || !horiz && y === axis.pos ? -1 : 1;
          var labelOpacity = pick$1p(
            opacity,
            tick.label && tick.label.newOpacity,
            // #15528
            1
          );
          opacity = pick$1p(opacity, 1);
          this.isActive = true;
          this.renderGridLine(old, opacity, reverseCrisp);
          this.renderMark(xy, opacity, reverseCrisp);
          this.renderLabel(xy, old, labelOpacity, index);
          tick.isNew = false;
          fireEvent$z(this, "afterRender");
        };
        Tick2.prototype.renderGridLine = function(old, opacity, reverseCrisp) {
          var tick = this, axis = tick.axis, options = axis.options, attribs = {}, pos = tick.pos, type = tick.type, tickmarkOffset = pick$1p(tick.tickmarkOffset, axis.tickmarkOffset), renderer = axis.chart.renderer;
          var gridLine = tick.gridLine, gridLinePath, gridLineWidth = options.gridLineWidth, gridLineColor = options.gridLineColor, dashStyle = options.gridLineDashStyle;
          if (tick.type === "minor") {
            gridLineWidth = options.minorGridLineWidth;
            gridLineColor = options.minorGridLineColor;
            dashStyle = options.minorGridLineDashStyle;
          }
          if (!gridLine) {
            if (!axis.chart.styledMode) {
              attribs.stroke = gridLineColor;
              attribs["stroke-width"] = gridLineWidth || 0;
              attribs.dashstyle = dashStyle;
            }
            if (!type) {
              attribs.zIndex = 1;
            }
            if (old) {
              opacity = 0;
            }
            tick.gridLine = gridLine = renderer.path().attr(attribs).addClass("highcharts-" + (type ? type + "-" : "") + "grid-line").add(axis.gridGroup);
          }
          if (gridLine) {
            gridLinePath = axis.getPlotLinePath({
              value: pos + tickmarkOffset,
              lineWidth: gridLine.strokeWidth() * reverseCrisp,
              force: "pass",
              old
            });
            if (gridLinePath) {
              gridLine[old || tick.isNew ? "attr" : "animate"]({
                d: gridLinePath,
                opacity
              });
            }
          }
        };
        Tick2.prototype.renderMark = function(xy, opacity, reverseCrisp) {
          var tick = this, axis = tick.axis, options = axis.options, renderer = axis.chart.renderer, type = tick.type, tickSize = axis.tickSize(type ? type + "Tick" : "tick"), x = xy.x, y = xy.y, tickWidth = pick$1p(options[type !== "minor" ? "tickWidth" : "minorTickWidth"], !type && axis.isXAxis ? 1 : 0), tickColor = options[type !== "minor" ? "tickColor" : "minorTickColor"];
          var mark = tick.mark;
          var isNewMark = !mark;
          if (tickSize) {
            if (axis.opposite) {
              tickSize[0] = -tickSize[0];
            }
            if (!mark) {
              tick.mark = mark = renderer.path().addClass("highcharts-" + (type ? type + "-" : "") + "tick").add(axis.axisGroup);
              if (!axis.chart.styledMode) {
                mark.attr({
                  stroke: tickColor,
                  "stroke-width": tickWidth
                });
              }
            }
            mark[isNewMark ? "attr" : "animate"]({
              d: tick.getMarkPath(x, y, tickSize[0], mark.strokeWidth() * reverseCrisp, axis.horiz, renderer),
              opacity
            });
          }
        };
        Tick2.prototype.renderLabel = function(xy, old, opacity, index) {
          var tick = this, axis = tick.axis, horiz = axis.horiz, options = axis.options, label = tick.label, labelOptions = options.labels, step = labelOptions.step, tickmarkOffset = pick$1p(tick.tickmarkOffset, axis.tickmarkOffset), x = xy.x, y = xy.y;
          var show = true;
          if (label && isNumber$I(x)) {
            label.xy = xy = tick.getLabelPosition(x, y, label, horiz, labelOptions, tickmarkOffset, index, step);
            if (tick.isFirst && !tick.isLast && !options.showFirstLabel || tick.isLast && !tick.isFirst && !options.showLastLabel) {
              show = false;
            } else if (horiz && !labelOptions.step && !labelOptions.rotation && !old && opacity !== 0) {
              tick.handleOverflow(xy);
            }
            if (step && index % step) {
              show = false;
            }
            if (show && isNumber$I(xy.y)) {
              xy.opacity = opacity;
              label[tick.isNewLabel ? "attr" : "animate"](xy);
              tick.isNewLabel = false;
            } else {
              label.attr("y", -9999);
              tick.isNewLabel = true;
            }
          }
        };
        Tick2.prototype.replaceMovedLabel = function() {
          var tick = this, label = tick.label, axis = tick.axis, reversed = axis.reversed;
          var x, y;
          if (label && !tick.isNew) {
            x = axis.horiz ? reversed ? axis.left : axis.width + axis.left : label.xy.x;
            y = axis.horiz ? label.xy.y : reversed ? axis.width + axis.top : axis.top;
            label.animate({ x, y, opacity: 0 }, void 0, label.destroy);
            delete tick.label;
          }
          axis.isDirty = true;
          tick.label = tick.movedLabel;
          delete tick.movedLabel;
        };
        return Tick2;
      }()
    );
    var animObject$a = animationExports.animObject;
    var defaultOptions$e = DefaultOptions.defaultOptions;
    var registerEventOptions$2 = exports$6.registerEventOptions;
    var deg2rad$5 = H.deg2rad;
    var arrayMax$9 = Utilities.arrayMax, arrayMin$8 = Utilities.arrayMin, clamp$h = Utilities.clamp, correctFloat$b = Utilities.correctFloat, defined$N = Utilities.defined, destroyObjectProperties$7 = Utilities.destroyObjectProperties, erase$7 = Utilities.erase, error$7 = Utilities.error, extend$1m = Utilities.extend, fireEvent$y = Utilities.fireEvent, getMagnitude$2 = Utilities.getMagnitude, isArray$j = Utilities.isArray, isNumber$H = Utilities.isNumber, isString$7 = Utilities.isString, merge$1g = Utilities.merge, normalizeTickInterval$2 = Utilities.normalizeTickInterval, objectEach$s = Utilities.objectEach, pick$1o = Utilities.pick, relativeLength$9 = Utilities.relativeLength, removeEvent$9 = Utilities.removeEvent, splat$g = Utilities.splat, syncTimeout$7 = Utilities.syncTimeout;
    var Axis = (
      /** @class */
      function() {
        function Axis2(chart, userOptions) {
          this.alternateBands = void 0;
          this.bottom = void 0;
          this.categories = void 0;
          this.chart = void 0;
          this.closestPointRange = void 0;
          this.coll = void 0;
          this.eventOptions = void 0;
          this.hasNames = void 0;
          this.hasVisibleSeries = void 0;
          this.height = void 0;
          this.isLinked = void 0;
          this.labelEdge = void 0;
          this.labelFormatter = void 0;
          this.left = void 0;
          this.len = void 0;
          this.max = void 0;
          this.maxLabelLength = void 0;
          this.min = void 0;
          this.minorTickInterval = void 0;
          this.minorTicks = void 0;
          this.minPixelPadding = void 0;
          this.names = void 0;
          this.offset = void 0;
          this.options = void 0;
          this.overlap = void 0;
          this.paddedTicks = void 0;
          this.plotLinesAndBands = void 0;
          this.plotLinesAndBandsGroups = void 0;
          this.pointRange = void 0;
          this.pointRangePadding = void 0;
          this.pos = void 0;
          this.positiveValuesOnly = void 0;
          this.right = void 0;
          this.series = void 0;
          this.side = void 0;
          this.tickAmount = void 0;
          this.tickInterval = void 0;
          this.tickmarkOffset = void 0;
          this.tickPositions = void 0;
          this.tickRotCorr = void 0;
          this.ticks = void 0;
          this.top = void 0;
          this.transA = void 0;
          this.transB = void 0;
          this.translationSlope = void 0;
          this.userOptions = void 0;
          this.visible = void 0;
          this.width = void 0;
          this.zoomEnabled = void 0;
          this.init(chart, userOptions);
        }
        Axis2.prototype.init = function(chart, userOptions) {
          var isXAxis = userOptions.isX, axis = this;
          axis.chart = chart;
          axis.horiz = chart.inverted && !axis.isZAxis ? !isXAxis : isXAxis;
          axis.isXAxis = isXAxis;
          axis.coll = axis.coll || (isXAxis ? "xAxis" : "yAxis");
          fireEvent$y(this, "init", { userOptions });
          axis.opposite = pick$1o(userOptions.opposite, axis.opposite);
          axis.side = pick$1o(
            userOptions.side,
            axis.side,
            axis.horiz ? axis.opposite ? 0 : 2 : (
              // top : bottom
              axis.opposite ? 1 : 3
            )
            // right : left
          );
          axis.setOptions(userOptions);
          var options = this.options, labelsOptions = options.labels, type = options.type;
          axis.userOptions = userOptions;
          axis.minPixelPadding = 0;
          axis.reversed = pick$1o(options.reversed, axis.reversed);
          axis.visible = options.visible;
          axis.zoomEnabled = options.zoomEnabled;
          axis.hasNames = type === "category" || options.categories === true;
          axis.categories = options.categories || axis.hasNames;
          if (!axis.names) {
            axis.names = [];
            axis.names.keys = {};
          }
          axis.plotLinesAndBandsGroups = {};
          axis.positiveValuesOnly = !!axis.logarithmic;
          axis.isLinked = defined$N(options.linkedTo);
          axis.ticks = {};
          axis.labelEdge = [];
          axis.minorTicks = {};
          axis.plotLinesAndBands = [];
          axis.alternateBands = {};
          axis.len = 0;
          axis.minRange = axis.userMinRange = options.minRange || options.maxZoom;
          axis.range = options.range;
          axis.offset = options.offset || 0;
          axis.max = null;
          axis.min = null;
          var crosshair = pick$1o(options.crosshair, splat$g(chart.options.tooltip.crosshairs)[isXAxis ? 0 : 1]);
          axis.crosshair = crosshair === true ? {} : crosshair;
          if (chart.axes.indexOf(axis) === -1) {
            if (isXAxis) {
              chart.axes.splice(chart.xAxis.length, 0, axis);
            } else {
              chart.axes.push(axis);
            }
            chart[axis.coll].push(axis);
          }
          axis.series = axis.series || [];
          if (chart.inverted && !axis.isZAxis && isXAxis && typeof axis.reversed === "undefined") {
            axis.reversed = true;
          }
          axis.labelRotation = isNumber$H(labelsOptions.rotation) ? labelsOptions.rotation : void 0;
          registerEventOptions$2(axis, options);
          fireEvent$y(this, "afterInit");
        };
        Axis2.prototype.setOptions = function(userOptions) {
          this.options = merge$1g(AxisDefaults$1.defaultXAxisOptions, this.coll === "yAxis" && AxisDefaults$1.defaultYAxisOptions, [
            AxisDefaults$1.defaultTopAxisOptions,
            AxisDefaults$1.defaultRightAxisOptions,
            AxisDefaults$1.defaultBottomAxisOptions,
            AxisDefaults$1.defaultLeftAxisOptions
          ][this.side], merge$1g(
            // if set in setOptions (#1053):
            defaultOptions$e[this.coll],
            userOptions
          ));
          fireEvent$y(this, "afterSetOptions", { userOptions });
        };
        Axis2.prototype.defaultLabelFormatter = function(ctx) {
          var axis = this.axis, chart = this.chart, numberFormatter = chart.numberFormatter, value = isNumber$H(this.value) ? this.value : NaN, time = axis.chart.time, categories = axis.categories, dateTimeLabelFormat = this.dateTimeLabelFormat, lang2 = defaultOptions$e.lang, numericSymbols = lang2.numericSymbols, numSymMagnitude = lang2.numericSymbolMagnitude || 1e3, numericSymbolDetector = axis.logarithmic ? Math.abs(value) : axis.tickInterval;
          var i2 = numericSymbols && numericSymbols.length, multi, ret;
          if (categories) {
            ret = "" + this.value;
          } else if (dateTimeLabelFormat) {
            ret = time.dateFormat(dateTimeLabelFormat, value);
          } else if (i2 && numericSymbolDetector >= 1e3) {
            while (i2-- && typeof ret === "undefined") {
              multi = Math.pow(numSymMagnitude, i2 + 1);
              if (
                // Only accept a numeric symbol when the distance is more
                // than a full unit. So for example if the symbol is k, we
                // don't accept numbers like 0.5k.
                numericSymbolDetector >= multi && // Accept one decimal before the symbol. Accepts 0.5k but
                // not 0.25k. How does this work with the previous?
                value * 10 % multi === 0 && numericSymbols[i2] !== null && value !== 0
              ) {
                ret = numberFormatter(value / multi, -1) + numericSymbols[i2];
              }
            }
          }
          if (typeof ret === "undefined") {
            if (Math.abs(value) >= 1e4) {
              ret = numberFormatter(value, -1);
            } else {
              ret = numberFormatter(value, -1, void 0, "");
            }
          }
          return ret;
        };
        Axis2.prototype.getSeriesExtremes = function() {
          var axis = this, chart = axis.chart;
          var xExtremes;
          fireEvent$y(this, "getSeriesExtremes", null, function() {
            axis.hasVisibleSeries = false;
            axis.dataMin = axis.dataMax = axis.threshold = null;
            axis.softThreshold = !axis.isXAxis;
            if (axis.stacking) {
              axis.stacking.buildStacks();
            }
            axis.series.forEach(function(series) {
              if (series.visible || !chart.options.chart.ignoreHiddenSeries) {
                var seriesOptions = series.options;
                var xData = void 0, threshold = seriesOptions.threshold, seriesDataMin = void 0, seriesDataMax = void 0;
                axis.hasVisibleSeries = true;
                if (axis.positiveValuesOnly && threshold <= 0) {
                  threshold = null;
                }
                if (axis.isXAxis) {
                  xData = series.xData;
                  if (xData.length) {
                    xData = axis.logarithmic ? xData.filter(axis.validatePositiveValue) : xData;
                    xExtremes = series.getXExtremes(xData);
                    seriesDataMin = xExtremes.min;
                    seriesDataMax = xExtremes.max;
                    if (!isNumber$H(seriesDataMin) && // #5010:
                    !(seriesDataMin instanceof Date)) {
                      xData = xData.filter(isNumber$H);
                      xExtremes = series.getXExtremes(xData);
                      seriesDataMin = xExtremes.min;
                      seriesDataMax = xExtremes.max;
                    }
                    if (xData.length) {
                      axis.dataMin = Math.min(pick$1o(axis.dataMin, seriesDataMin), seriesDataMin);
                      axis.dataMax = Math.max(pick$1o(axis.dataMax, seriesDataMax), seriesDataMax);
                    }
                  }
                } else {
                  var dataExtremes = series.applyExtremes();
                  if (isNumber$H(dataExtremes.dataMin)) {
                    seriesDataMin = dataExtremes.dataMin;
                    axis.dataMin = Math.min(pick$1o(axis.dataMin, seriesDataMin), seriesDataMin);
                  }
                  if (isNumber$H(dataExtremes.dataMax)) {
                    seriesDataMax = dataExtremes.dataMax;
                    axis.dataMax = Math.max(pick$1o(axis.dataMax, seriesDataMax), seriesDataMax);
                  }
                  if (defined$N(threshold)) {
                    axis.threshold = threshold;
                  }
                  if (!seriesOptions.softThreshold || axis.positiveValuesOnly) {
                    axis.softThreshold = false;
                  }
                }
              }
            });
          });
          fireEvent$y(this, "afterGetSeriesExtremes");
        };
        Axis2.prototype.translate = function(val, backwards, cvsCoord, old, handleLog, pointPlacement) {
          var axis = this.linkedParent || this, localMin = old && axis.old ? axis.old.min : axis.min, minPixelPadding = axis.minPixelPadding, doPostTranslate = (axis.isOrdinal || axis.brokenAxis && axis.brokenAxis.hasBreaks || axis.logarithmic && handleLog) && axis.lin2val;
          var sign2 = 1, cvsOffset = 0, localA = old && axis.old ? axis.old.transA : axis.transA, returnValue = 0;
          if (!localA) {
            localA = axis.transA;
          }
          if (cvsCoord) {
            sign2 *= -1;
            cvsOffset = axis.len;
          }
          if (axis.reversed) {
            sign2 *= -1;
            cvsOffset -= sign2 * (axis.sector || axis.len);
          }
          if (backwards) {
            val = val * sign2 + cvsOffset;
            val -= minPixelPadding;
            returnValue = val / localA + localMin;
            if (doPostTranslate) {
              returnValue = axis.lin2val(returnValue);
            }
          } else {
            if (doPostTranslate) {
              val = axis.val2lin(val);
            }
            returnValue = isNumber$H(localMin) ? sign2 * (val - localMin) * localA + cvsOffset + sign2 * minPixelPadding + (isNumber$H(pointPlacement) ? localA * pointPlacement : 0) : void 0;
          }
          return returnValue;
        };
        Axis2.prototype.toPixels = function(value, paneCoordinates) {
          return this.translate(value, false, !this.horiz, null, true) + (paneCoordinates ? 0 : this.pos);
        };
        Axis2.prototype.toValue = function(pixel, paneCoordinates) {
          return this.translate(pixel - (paneCoordinates ? 0 : this.pos), true, !this.horiz, null, true);
        };
        Axis2.prototype.getPlotLinePath = function(options) {
          var axis = this, chart = axis.chart, axisLeft = axis.left, axisTop = axis.top, old = options.old, value = options.value, lineWidth = options.lineWidth, cHeight = old && chart.oldChartHeight || chart.chartHeight, cWidth = old && chart.oldChartWidth || chart.chartWidth, transB = axis.transB;
          var translatedValue = options.translatedValue, force = options.force, x1, y1, x2, y2, skip;
          function between(x, a, b2) {
            if (force !== "pass" && x < a || x > b2) {
              if (force) {
                x = clamp$h(x, a, b2);
              } else {
                skip = true;
              }
            }
            return x;
          }
          var evt = {
            value,
            lineWidth,
            old,
            force,
            acrossPanes: options.acrossPanes,
            translatedValue
          };
          fireEvent$y(this, "getPlotLinePath", evt, function(e2) {
            translatedValue = pick$1o(translatedValue, axis.translate(value, null, null, old));
            translatedValue = clamp$h(translatedValue, -1e5, 1e5);
            x1 = x2 = Math.round(translatedValue + transB);
            y1 = y2 = Math.round(cHeight - translatedValue - transB);
            if (!isNumber$H(translatedValue)) {
              skip = true;
              force = false;
            } else if (axis.horiz) {
              y1 = axisTop;
              y2 = cHeight - axis.bottom;
              x1 = x2 = between(x1, axisLeft, axisLeft + axis.width);
            } else {
              x1 = axisLeft;
              x2 = cWidth - axis.right;
              y1 = y2 = between(y1, axisTop, axisTop + axis.height);
            }
            e2.path = skip && !force ? null : chart.renderer.crispLine([["M", x1, y1], ["L", x2, y2]], lineWidth || 1);
          });
          return evt.path;
        };
        Axis2.prototype.getLinearTickPositions = function(tickInterval, min, max) {
          var roundedMin = correctFloat$b(Math.floor(min / tickInterval) * tickInterval), roundedMax = correctFloat$b(Math.ceil(max / tickInterval) * tickInterval), tickPositions = [];
          var pos, lastPos, precision;
          if (correctFloat$b(roundedMin + tickInterval) === roundedMin) {
            precision = 20;
          }
          if (this.single) {
            return [min];
          }
          pos = roundedMin;
          while (pos <= roundedMax) {
            tickPositions.push(pos);
            pos = correctFloat$b(pos + tickInterval, precision);
            if (pos === lastPos) {
              break;
            }
            lastPos = pos;
          }
          return tickPositions;
        };
        Axis2.prototype.getMinorTickInterval = function() {
          var options = this.options;
          if (options.minorTicks === true) {
            return pick$1o(options.minorTickInterval, "auto");
          }
          if (options.minorTicks === false) {
            return null;
          }
          return options.minorTickInterval;
        };
        Axis2.prototype.getMinorTickPositions = function() {
          var axis = this, options = axis.options, tickPositions = axis.tickPositions, minorTickInterval = axis.minorTickInterval, pointRangePadding = axis.pointRangePadding || 0, min = axis.min - pointRangePadding, max = axis.max + pointRangePadding, range = max - min;
          var minorTickPositions = [], pos;
          if (range && range / minorTickInterval < axis.len / 3) {
            var logarithmic_1 = axis.logarithmic;
            if (logarithmic_1) {
              this.paddedTicks.forEach(function(_pos, i2, paddedTicks) {
                if (i2) {
                  minorTickPositions.push.apply(minorTickPositions, logarithmic_1.getLogTickPositions(minorTickInterval, paddedTicks[i2 - 1], paddedTicks[i2], true));
                }
              });
            } else if (axis.dateTime && this.getMinorTickInterval() === "auto") {
              minorTickPositions = minorTickPositions.concat(axis.getTimeTicks(axis.dateTime.normalizeTimeTickInterval(minorTickInterval), min, max, options.startOfWeek));
            } else {
              for (pos = min + (tickPositions[0] - min) % minorTickInterval; pos <= max; pos += minorTickInterval) {
                if (pos === minorTickPositions[0]) {
                  break;
                }
                minorTickPositions.push(pos);
              }
            }
          }
          if (minorTickPositions.length !== 0) {
            axis.trimTicks(minorTickPositions);
          }
          return minorTickPositions;
        };
        Axis2.prototype.adjustForMinRange = function() {
          var axis = this, options = axis.options, log = axis.logarithmic;
          var min = axis.min, max = axis.max, zoomOffset, spaceAvailable, closestDataRange = 0, i2, distance, xData, loopLength, minArgs, maxArgs, minRange;
          if (axis.isXAxis && typeof axis.minRange === "undefined" && !log) {
            if (defined$N(options.min) || defined$N(options.max)) {
              axis.minRange = null;
            } else {
              axis.series.forEach(function(series) {
                xData = series.xData;
                loopLength = series.xIncrement ? 1 : xData.length - 1;
                if (xData.length > 1) {
                  for (i2 = loopLength; i2 > 0; i2--) {
                    distance = xData[i2] - xData[i2 - 1];
                    if (!closestDataRange || distance < closestDataRange) {
                      closestDataRange = distance;
                    }
                  }
                }
              });
              axis.minRange = Math.min(closestDataRange * 5, axis.dataMax - axis.dataMin);
            }
          }
          if (max - min < axis.minRange) {
            spaceAvailable = axis.dataMax - axis.dataMin >= axis.minRange;
            minRange = axis.minRange;
            zoomOffset = (minRange - max + min) / 2;
            minArgs = [
              min - zoomOffset,
              pick$1o(options.min, min - zoomOffset)
            ];
            if (spaceAvailable) {
              minArgs[2] = axis.logarithmic ? axis.logarithmic.log2lin(axis.dataMin) : axis.dataMin;
            }
            min = arrayMax$9(minArgs);
            maxArgs = [
              min + minRange,
              pick$1o(options.max, min + minRange)
            ];
            if (spaceAvailable) {
              maxArgs[2] = log ? log.log2lin(axis.dataMax) : axis.dataMax;
            }
            max = arrayMin$8(maxArgs);
            if (max - min < minRange) {
              minArgs[0] = max - minRange;
              minArgs[1] = pick$1o(options.min, max - minRange);
              min = arrayMax$9(minArgs);
            }
          }
          axis.min = min;
          axis.max = max;
        };
        Axis2.prototype.getClosest = function() {
          var ret;
          if (this.categories) {
            ret = 1;
          } else {
            this.series.forEach(function(series) {
              var seriesClosest = series.closestPointRange, visible = series.visible || !series.chart.options.chart.ignoreHiddenSeries;
              if (!series.noSharedTooltip && defined$N(seriesClosest) && visible) {
                ret = defined$N(ret) ? Math.min(ret, seriesClosest) : seriesClosest;
              }
            });
          }
          return ret;
        };
        Axis2.prototype.nameToX = function(point) {
          var explicitCategories = isArray$j(this.categories), names2 = explicitCategories ? this.categories : this.names;
          var nameX = point.options.x, x;
          point.series.requireSorting = false;
          if (!defined$N(nameX)) {
            nameX = this.options.uniqueNames ? explicitCategories ? names2.indexOf(point.name) : pick$1o(names2.keys[point.name], -1) : point.series.autoIncrement();
          }
          if (nameX === -1) {
            if (!explicitCategories) {
              x = names2.length;
            }
          } else {
            x = nameX;
          }
          if (typeof x !== "undefined") {
            this.names[x] = point.name;
            this.names.keys[point.name] = x;
          }
          return x;
        };
        Axis2.prototype.updateNames = function() {
          var axis = this, names2 = this.names, i2 = names2.length;
          if (i2 > 0) {
            Object.keys(names2.keys).forEach(function(key) {
              delete names2.keys[key];
            });
            names2.length = 0;
            this.minRange = this.userMinRange;
            (this.series || []).forEach(function(series) {
              series.xIncrement = null;
              if (!series.points || series.isDirtyData) {
                axis.max = Math.max(axis.max, series.xData.length - 1);
                series.processData();
                series.generatePoints();
              }
              series.data.forEach(function(point, i3) {
                var x;
                if (point && point.options && typeof point.name !== "undefined") {
                  x = axis.nameToX(point);
                  if (typeof x !== "undefined" && x !== point.x) {
                    point.x = x;
                    series.xData[i3] = x;
                  }
                }
              });
            });
          }
        };
        Axis2.prototype.setAxisTranslation = function() {
          var axis = this, range = axis.max - axis.min, linkedParent = axis.linkedParent, hasCategories = !!axis.categories, isXAxis = axis.isXAxis;
          var pointRange = axis.axisPointRange || 0, closestPointRange, minPointOffset = 0, pointRangePadding = 0, ordinalCorrection, transA = axis.transA;
          if (isXAxis || hasCategories || pointRange) {
            closestPointRange = axis.getClosest();
            if (linkedParent) {
              minPointOffset = linkedParent.minPointOffset;
              pointRangePadding = linkedParent.pointRangePadding;
            } else {
              axis.series.forEach(function(series) {
                var seriesPointRange = hasCategories ? 1 : isXAxis ? pick$1o(series.options.pointRange, closestPointRange, 0) : axis.axisPointRange || 0, pointPlacement = series.options.pointPlacement;
                pointRange = Math.max(pointRange, seriesPointRange);
                if (!axis.single || hasCategories) {
                  var isPointPlacementAxis = series.is("xrange") ? !isXAxis : isXAxis;
                  minPointOffset = Math.max(minPointOffset, isPointPlacementAxis && isString$7(pointPlacement) ? 0 : seriesPointRange / 2);
                  pointRangePadding = Math.max(pointRangePadding, isPointPlacementAxis && pointPlacement === "on" ? 0 : seriesPointRange);
                }
              });
            }
            ordinalCorrection = axis.ordinal && axis.ordinal.slope && closestPointRange ? axis.ordinal.slope / closestPointRange : 1;
            axis.minPointOffset = minPointOffset = minPointOffset * ordinalCorrection;
            axis.pointRangePadding = pointRangePadding = pointRangePadding * ordinalCorrection;
            axis.pointRange = Math.min(pointRange, axis.single && hasCategories ? 1 : range);
            if (isXAxis) {
              axis.closestPointRange = closestPointRange;
            }
          }
          axis.translationSlope = axis.transA = transA = axis.staticScale || axis.len / (range + pointRangePadding || 1);
          axis.transB = axis.horiz ? axis.left : axis.bottom;
          axis.minPixelPadding = transA * minPointOffset;
          fireEvent$y(this, "afterSetAxisTranslation");
        };
        Axis2.prototype.minFromRange = function() {
          var axis = this;
          return axis.max - axis.range;
        };
        Axis2.prototype.setTickInterval = function(secondPass) {
          var axis = this, chart = axis.chart, log = axis.logarithmic, options = axis.options, isXAxis = axis.isXAxis, isLinked = axis.isLinked, tickPixelIntervalOption = options.tickPixelInterval, categories = axis.categories, softThreshold = axis.softThreshold;
          var maxPadding = options.maxPadding, minPadding = options.minPadding, length, linkedParentExtremes, tickIntervalOption = options.tickInterval, threshold = isNumber$H(axis.threshold) ? axis.threshold : null, thresholdMin, thresholdMax, hardMin, hardMax;
          if (!axis.dateTime && !categories && !isLinked) {
            this.getTickAmount();
          }
          hardMin = pick$1o(axis.userMin, options.min);
          hardMax = pick$1o(axis.userMax, options.max);
          if (isLinked) {
            axis.linkedParent = chart[axis.coll][options.linkedTo];
            linkedParentExtremes = axis.linkedParent.getExtremes();
            axis.min = pick$1o(linkedParentExtremes.min, linkedParentExtremes.dataMin);
            axis.max = pick$1o(linkedParentExtremes.max, linkedParentExtremes.dataMax);
            if (options.type !== axis.linkedParent.options.type) {
              error$7(11, 1, chart);
            }
          } else {
            if (softThreshold && defined$N(threshold)) {
              if (axis.dataMin >= threshold) {
                thresholdMin = threshold;
                minPadding = 0;
              } else if (axis.dataMax <= threshold) {
                thresholdMax = threshold;
                maxPadding = 0;
              }
            }
            axis.min = pick$1o(hardMin, thresholdMin, axis.dataMin);
            axis.max = pick$1o(hardMax, thresholdMax, axis.dataMax);
          }
          if (log) {
            if (axis.positiveValuesOnly && !secondPass && Math.min(axis.min, pick$1o(axis.dataMin, axis.min)) <= 0) {
              error$7(10, 1, chart);
            }
            axis.min = correctFloat$b(log.log2lin(axis.min), 16);
            axis.max = correctFloat$b(log.log2lin(axis.max), 16);
          }
          if (axis.range && defined$N(axis.max)) {
            axis.userMin = axis.min = hardMin = Math.max(axis.dataMin, axis.minFromRange());
            axis.userMax = hardMax = axis.max;
            axis.range = null;
          }
          fireEvent$y(axis, "foundExtremes");
          if (axis.beforePadding) {
            axis.beforePadding();
          }
          axis.adjustForMinRange();
          if (!categories && !axis.axisPointRange && !(axis.stacking && axis.stacking.usePercentage) && !isLinked && defined$N(axis.min) && defined$N(axis.max)) {
            length = axis.max - axis.min;
            if (length) {
              if (!defined$N(hardMin) && minPadding) {
                axis.min -= length * minPadding;
              }
              if (!defined$N(hardMax) && maxPadding) {
                axis.max += length * maxPadding;
              }
            }
          }
          if (!isNumber$H(axis.userMin)) {
            if (isNumber$H(options.softMin) && options.softMin < axis.min) {
              axis.min = hardMin = options.softMin;
            }
            if (isNumber$H(options.floor)) {
              axis.min = Math.max(axis.min, options.floor);
            }
          }
          if (!isNumber$H(axis.userMax)) {
            if (isNumber$H(options.softMax) && options.softMax > axis.max) {
              axis.max = hardMax = options.softMax;
            }
            if (isNumber$H(options.ceiling)) {
              axis.max = Math.min(axis.max, options.ceiling);
            }
          }
          if (softThreshold && defined$N(axis.dataMin)) {
            threshold = threshold || 0;
            if (!defined$N(hardMin) && axis.min < threshold && axis.dataMin >= threshold) {
              axis.min = axis.options.minRange ? Math.min(threshold, axis.max - axis.minRange) : threshold;
            } else if (!defined$N(hardMax) && axis.max > threshold && axis.dataMax <= threshold) {
              axis.max = axis.options.minRange ? Math.max(threshold, axis.min + axis.minRange) : threshold;
            }
          }
          if (isNumber$H(axis.min) && isNumber$H(axis.max) && !this.chart.polar && axis.min > axis.max) {
            if (defined$N(axis.options.min)) {
              axis.max = axis.min;
            } else if (defined$N(axis.options.max)) {
              axis.min = axis.max;
            }
          }
          if (axis.min === axis.max || typeof axis.min === "undefined" || typeof axis.max === "undefined") {
            axis.tickInterval = 1;
          } else if (isLinked && axis.linkedParent && !tickIntervalOption && tickPixelIntervalOption === axis.linkedParent.options.tickPixelInterval) {
            axis.tickInterval = tickIntervalOption = axis.linkedParent.tickInterval;
          } else {
            axis.tickInterval = pick$1o(
              tickIntervalOption,
              this.tickAmount ? (axis.max - axis.min) / Math.max(this.tickAmount - 1, 1) : void 0,
              // For categoried axis, 1 is default, for linear axis use
              // tickPix
              categories ? 1 : (
                // don't let it be more than the data range
                (axis.max - axis.min) * tickPixelIntervalOption / Math.max(axis.len, tickPixelIntervalOption)
              )
            );
          }
          if (isXAxis && !secondPass) {
            axis.series.forEach(function(series) {
              series.forceCrop = series.forceCropping && series.forceCropping();
              series.processData(axis.min !== (axis.old && axis.old.min) || axis.max !== (axis.old && axis.old.max));
            });
            fireEvent$y(this, "postProcessData");
          }
          axis.setAxisTranslation();
          fireEvent$y(this, "initialAxisTranslation");
          if (axis.pointRange && !tickIntervalOption) {
            axis.tickInterval = Math.max(axis.pointRange, axis.tickInterval);
          }
          var minTickInterval = pick$1o(
            options.minTickInterval,
            // In datetime axes, don't go below the data interval, except when
            // there are scatter-like series involved (#13369).
            axis.dateTime && !axis.series.some(function(s2) {
              return s2.noSharedTooltip;
            }) ? axis.closestPointRange : 0
          );
          if (!tickIntervalOption && axis.tickInterval < minTickInterval) {
            axis.tickInterval = minTickInterval;
          }
          if (!axis.dateTime && !axis.logarithmic && !tickIntervalOption) {
            axis.tickInterval = normalizeTickInterval$2(axis.tickInterval, void 0, getMagnitude$2(axis.tickInterval), pick$1o(
              options.allowDecimals,
              // If the tick interval is greather than 0.5, avoid
              // decimals, as linear axes are often used to render
              // discrete values. #3363. If a tick amount is set, allow
              // decimals by default, as it increases the chances for a
              // good fit.
              axis.tickInterval < 0.5 || this.tickAmount !== void 0
            ), !!this.tickAmount);
          }
          if (!this.tickAmount) {
            axis.tickInterval = axis.unsquish();
          }
          this.setTickPositions();
        };
        Axis2.prototype.setTickPositions = function() {
          var axis = this, options = this.options, tickPositionsOption = options.tickPositions, minorTickIntervalOption = this.getMinorTickInterval(), hasVerticalPanning = this.hasVerticalPanning(), isColorAxis = this.coll === "colorAxis", startOnTick = (isColorAxis || !hasVerticalPanning) && options.startOnTick, endOnTick = (isColorAxis || !hasVerticalPanning) && options.endOnTick;
          var tickPositions, tickPositioner = options.tickPositioner;
          this.tickmarkOffset = this.categories && options.tickmarkPlacement === "between" && this.tickInterval === 1 ? 0.5 : 0;
          this.minorTickInterval = minorTickIntervalOption === "auto" && this.tickInterval ? this.tickInterval / 5 : minorTickIntervalOption;
          this.single = this.min === this.max && defined$N(this.min) && !this.tickAmount && // Data is on integer (#6563)
          (parseInt(this.min, 10) === this.min || // Between integers and decimals are not allowed (#6274)
          options.allowDecimals !== false);
          this.tickPositions = // Find the tick positions. Work on a copy (#1565)
          tickPositions = tickPositionsOption && tickPositionsOption.slice();
          if (!tickPositions) {
            if ((!axis.ordinal || !axis.ordinal.positions) && (this.max - this.min) / this.tickInterval > Math.max(2 * this.len, 200)) {
              tickPositions = [this.min, this.max];
              error$7(19, false, this.chart);
            } else if (axis.dateTime) {
              tickPositions = axis.getTimeTicks(axis.dateTime.normalizeTimeTickInterval(this.tickInterval, options.units), this.min, this.max, options.startOfWeek, axis.ordinal && axis.ordinal.positions, this.closestPointRange, true);
            } else if (axis.logarithmic) {
              tickPositions = axis.logarithmic.getLogTickPositions(this.tickInterval, this.min, this.max);
            } else {
              tickPositions = this.getLinearTickPositions(this.tickInterval, this.min, this.max);
            }
            if (tickPositions.length > this.len) {
              tickPositions = [tickPositions[0], tickPositions.pop()];
              if (tickPositions[0] === tickPositions[1]) {
                tickPositions.length = 1;
              }
            }
            this.tickPositions = tickPositions;
            if (tickPositioner) {
              tickPositioner = tickPositioner.apply(axis, [this.min, this.max]);
              if (tickPositioner) {
                this.tickPositions = tickPositions = tickPositioner;
              }
            }
          }
          this.paddedTicks = tickPositions.slice(0);
          this.trimTicks(tickPositions, startOnTick, endOnTick);
          if (!this.isLinked) {
            if (this.single && tickPositions.length < 2 && !this.categories && !this.series.some(function(s2) {
              return s2.is("heatmap") && s2.options.pointPlacement === "between";
            })) {
              this.min -= 0.5;
              this.max += 0.5;
            }
            if (!tickPositionsOption && !tickPositioner) {
              this.adjustTickAmount();
            }
          }
          fireEvent$y(this, "afterSetTickPositions");
        };
        Axis2.prototype.trimTicks = function(tickPositions, startOnTick, endOnTick) {
          var roundedMin = tickPositions[0], roundedMax = tickPositions[tickPositions.length - 1], minPointOffset = !this.isOrdinal && this.minPointOffset || 0;
          fireEvent$y(this, "trimTicks");
          if (!this.isLinked) {
            if (startOnTick && roundedMin !== -Infinity) {
              this.min = roundedMin;
            } else {
              while (this.min - minPointOffset > tickPositions[0]) {
                tickPositions.shift();
              }
            }
            if (endOnTick) {
              this.max = roundedMax;
            } else {
              while (this.max + minPointOffset < tickPositions[tickPositions.length - 1]) {
                tickPositions.pop();
              }
            }
            if (tickPositions.length === 0 && defined$N(roundedMin) && !this.options.tickPositions) {
              tickPositions.push((roundedMax + roundedMin) / 2);
            }
          }
        };
        Axis2.prototype.alignToOthers = function() {
          var axis = this, others = (
            // Whether there is another axis to pair with this one
            {}
          ), options = axis.options;
          var hasOther;
          if (
            // Only if alignTicks is true
            this.chart.options.chart.alignTicks !== false && options.alignTicks && // Disabled when startOnTick or endOnTick are false (#7604)
            options.startOnTick !== false && options.endOnTick !== false && // Don't try to align ticks on a log axis, they are not evenly
            // spaced (#6021)
            !axis.logarithmic
          ) {
            this.chart[this.coll].forEach(function(axis2) {
              var otherOptions = axis2.options, horiz = axis2.horiz, key = [
                horiz ? otherOptions.left : otherOptions.top,
                otherOptions.width,
                otherOptions.height,
                otherOptions.pane
              ].join(",");
              if (axis2.series.length) {
                if (others[key]) {
                  hasOther = true;
                } else {
                  others[key] = 1;
                }
              }
            });
          }
          return hasOther;
        };
        Axis2.prototype.getTickAmount = function() {
          var axis = this, options = this.options, tickPixelInterval = options.tickPixelInterval;
          var tickAmount = options.tickAmount;
          if (!defined$N(options.tickInterval) && !tickAmount && this.len < tickPixelInterval && !this.isRadial && !axis.logarithmic && options.startOnTick && options.endOnTick) {
            tickAmount = 2;
          }
          if (!tickAmount && this.alignToOthers()) {
            tickAmount = Math.ceil(this.len / tickPixelInterval) + 1;
          }
          if (tickAmount < 4) {
            this.finalTickAmt = tickAmount;
            tickAmount = 5;
          }
          this.tickAmount = tickAmount;
        };
        Axis2.prototype.adjustTickAmount = function() {
          var axis = this, axisOptions = axis.options, tickInterval = axis.tickInterval, tickPositions = axis.tickPositions, tickAmount = axis.tickAmount, finalTickAmt = axis.finalTickAmt, currentTickAmount = tickPositions && tickPositions.length, threshold = pick$1o(axis.threshold, axis.softThreshold ? 0 : null);
          var len, i2;
          if (axis.hasData() && isNumber$H(axis.min) && isNumber$H(axis.max)) {
            if (currentTickAmount < tickAmount) {
              while (tickPositions.length < tickAmount) {
                if (tickPositions.length % 2 || axis.min === threshold) {
                  tickPositions.push(correctFloat$b(tickPositions[tickPositions.length - 1] + tickInterval));
                } else {
                  tickPositions.unshift(correctFloat$b(tickPositions[0] - tickInterval));
                }
              }
              axis.transA *= (currentTickAmount - 1) / (tickAmount - 1);
              axis.min = axisOptions.startOnTick ? tickPositions[0] : Math.min(axis.min, tickPositions[0]);
              axis.max = axisOptions.endOnTick ? tickPositions[tickPositions.length - 1] : Math.max(axis.max, tickPositions[tickPositions.length - 1]);
            } else if (currentTickAmount > tickAmount) {
              axis.tickInterval *= 2;
              axis.setTickPositions();
            }
            if (defined$N(finalTickAmt)) {
              i2 = len = tickPositions.length;
              while (i2--) {
                if (
                  // Remove every other tick
                  finalTickAmt === 3 && i2 % 2 === 1 || // Remove all but first and last
                  finalTickAmt <= 2 && i2 > 0 && i2 < len - 1
                ) {
                  tickPositions.splice(i2, 1);
                }
              }
              axis.finalTickAmt = void 0;
            }
          }
        };
        Axis2.prototype.setScale = function() {
          var axis = this;
          var isDirtyData = false, isXAxisDirty = false;
          axis.series.forEach(function(series) {
            isDirtyData = isDirtyData || series.isDirtyData || series.isDirty;
            isXAxisDirty = isXAxisDirty || series.xAxis && series.xAxis.isDirty || false;
          });
          axis.setAxisSize();
          var isDirtyAxisLength = axis.len !== (axis.old && axis.old.len);
          if (isDirtyAxisLength || isDirtyData || isXAxisDirty || axis.isLinked || axis.forceRedraw || axis.userMin !== (axis.old && axis.old.userMin) || axis.userMax !== (axis.old && axis.old.userMax) || axis.alignToOthers()) {
            if (axis.stacking) {
              axis.stacking.resetStacks();
            }
            axis.forceRedraw = false;
            axis.getSeriesExtremes();
            axis.setTickInterval();
            if (!axis.isDirty) {
              axis.isDirty = isDirtyAxisLength || axis.min !== (axis.old && axis.old.min) || axis.max !== (axis.old && axis.old.max);
            }
          } else if (axis.stacking) {
            axis.stacking.cleanStacks();
          }
          if (isDirtyData && axis.panningState) {
            axis.panningState.isDirty = true;
          }
          fireEvent$y(this, "afterSetScale");
        };
        Axis2.prototype.setExtremes = function(newMin, newMax, redraw, animation, eventArguments) {
          var axis = this, chart = axis.chart;
          redraw = pick$1o(redraw, true);
          axis.series.forEach(function(serie) {
            delete serie.kdTree;
          });
          eventArguments = extend$1m(eventArguments, {
            min: newMin,
            max: newMax
          });
          fireEvent$y(axis, "setExtremes", eventArguments, function() {
            axis.userMin = newMin;
            axis.userMax = newMax;
            axis.eventArgs = eventArguments;
            if (redraw) {
              chart.redraw(animation);
            }
          });
        };
        Axis2.prototype.zoom = function(newMin, newMax) {
          var axis = this, dataMin = this.dataMin, dataMax = this.dataMax, options = this.options, min = Math.min(dataMin, pick$1o(options.min, dataMin)), max = Math.max(dataMax, pick$1o(options.max, dataMax)), evt = {
            newMin,
            newMax
          };
          fireEvent$y(this, "zoom", evt, function(e2) {
            var newMin2 = e2.newMin, newMax2 = e2.newMax;
            if (newMin2 !== axis.min || newMax2 !== axis.max) {
              if (!axis.allowZoomOutside) {
                if (defined$N(dataMin)) {
                  if (newMin2 < min) {
                    newMin2 = min;
                  }
                  if (newMin2 > max) {
                    newMin2 = max;
                  }
                }
                if (defined$N(dataMax)) {
                  if (newMax2 < min) {
                    newMax2 = min;
                  }
                  if (newMax2 > max) {
                    newMax2 = max;
                  }
                }
              }
              axis.displayBtn = typeof newMin2 !== "undefined" || typeof newMax2 !== "undefined";
              axis.setExtremes(newMin2, newMax2, false, void 0, { trigger: "zoom" });
            }
            e2.zoomed = true;
          });
          return evt.zoomed;
        };
        Axis2.prototype.setAxisSize = function() {
          var chart = this.chart, options = this.options, offsets = options.offsets || [0, 0, 0, 0], horiz = this.horiz, width = this.width = Math.round(relativeLength$9(pick$1o(options.width, chart.plotWidth - offsets[3] + offsets[1]), chart.plotWidth)), height = this.height = Math.round(relativeLength$9(pick$1o(options.height, chart.plotHeight - offsets[0] + offsets[2]), chart.plotHeight)), top = this.top = Math.round(relativeLength$9(pick$1o(options.top, chart.plotTop + offsets[0]), chart.plotHeight, chart.plotTop)), left = this.left = Math.round(relativeLength$9(pick$1o(options.left, chart.plotLeft + offsets[3]), chart.plotWidth, chart.plotLeft));
          this.bottom = chart.chartHeight - height - top;
          this.right = chart.chartWidth - width - left;
          this.len = Math.max(horiz ? width : height, 0);
          this.pos = horiz ? left : top;
        };
        Axis2.prototype.getExtremes = function() {
          var axis = this, log = axis.logarithmic;
          return {
            min: log ? correctFloat$b(log.lin2log(axis.min)) : axis.min,
            max: log ? correctFloat$b(log.lin2log(axis.max)) : axis.max,
            dataMin: axis.dataMin,
            dataMax: axis.dataMax,
            userMin: axis.userMin,
            userMax: axis.userMax
          };
        };
        Axis2.prototype.getThreshold = function(threshold) {
          var axis = this, log = axis.logarithmic, realMin = log ? log.lin2log(axis.min) : axis.min, realMax = log ? log.lin2log(axis.max) : axis.max;
          if (threshold === null || threshold === -Infinity) {
            threshold = realMin;
          } else if (threshold === Infinity) {
            threshold = realMax;
          } else if (realMin > threshold) {
            threshold = realMin;
          } else if (realMax < threshold) {
            threshold = realMax;
          }
          return axis.translate(threshold, 0, 1, 0, 1);
        };
        Axis2.prototype.autoLabelAlign = function(rotation) {
          var angle = (pick$1o(rotation, 0) - this.side * 90 + 720) % 360, evt = { align: "center" };
          fireEvent$y(this, "autoLabelAlign", evt, function(e2) {
            if (angle > 15 && angle < 165) {
              e2.align = "right";
            } else if (angle > 195 && angle < 345) {
              e2.align = "left";
            }
          });
          return evt.align;
        };
        Axis2.prototype.tickSize = function(prefix) {
          var options = this.options, tickWidth = pick$1o(
            options[prefix === "tick" ? "tickWidth" : "minorTickWidth"],
            // Default to 1 on linear and datetime X axes
            prefix === "tick" && this.isXAxis && !this.categories ? 1 : 0
          );
          var tickLength = options[prefix === "tick" ? "tickLength" : "minorTickLength"], tickSize;
          if (tickWidth && tickLength) {
            if (options[prefix + "Position"] === "inside") {
              tickLength = -tickLength;
            }
            tickSize = [tickLength, tickWidth];
          }
          var e2 = { tickSize };
          fireEvent$y(this, "afterTickSize", e2);
          return e2.tickSize;
        };
        Axis2.prototype.labelMetrics = function() {
          var index = this.tickPositions && this.tickPositions[0] || 0;
          return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize, this.ticks[index] && this.ticks[index].label);
        };
        Axis2.prototype.unsquish = function() {
          var labelOptions = this.options.labels, horiz = this.horiz, tickInterval = this.tickInterval, slotSize = this.len / (((this.categories ? 1 : 0) + this.max - this.min) / tickInterval), rotationOption = labelOptions.rotation, labelMetrics = this.labelMetrics(), range = Math.max(this.max - this.min, 0), getStep = function(spaceNeeded) {
            var step2 = spaceNeeded / (slotSize || 1);
            step2 = step2 > 1 ? Math.ceil(step2) : 1;
            if (step2 * tickInterval > range && spaceNeeded !== Infinity && slotSize !== Infinity && range) {
              step2 = Math.ceil(range / tickInterval);
            }
            return correctFloat$b(step2 * tickInterval);
          };
          var newTickInterval = tickInterval, rotation, step, bestScore = Number.MAX_VALUE, autoRotation;
          if (horiz) {
            if (!labelOptions.staggerLines && !labelOptions.step) {
              if (isNumber$H(rotationOption)) {
                autoRotation = [rotationOption];
              } else if (slotSize < labelOptions.autoRotationLimit) {
                autoRotation = labelOptions.autoRotation;
              }
            }
            if (autoRotation) {
              autoRotation.forEach(function(rot) {
                var score;
                if (rot === rotationOption || rot && rot >= -90 && rot <= 90) {
                  step = getStep(Math.abs(labelMetrics.h / Math.sin(deg2rad$5 * rot)));
                  score = step + Math.abs(rot / 360);
                  if (score < bestScore) {
                    bestScore = score;
                    rotation = rot;
                    newTickInterval = step;
                  }
                }
              });
            }
          } else if (!labelOptions.step) {
            newTickInterval = getStep(labelMetrics.h);
          }
          this.autoRotation = autoRotation;
          this.labelRotation = pick$1o(rotation, isNumber$H(rotationOption) ? rotationOption : 0);
          return newTickInterval;
        };
        Axis2.prototype.getSlotWidth = function(tick) {
          var chart = this.chart, horiz = this.horiz, labelOptions = this.options.labels, slotCount = Math.max(this.tickPositions.length - (this.categories ? 0 : 1), 1), marginLeft = chart.margin[3];
          if (tick && isNumber$H(tick.slotWidth)) {
            return tick.slotWidth;
          }
          if (horiz && labelOptions.step < 2) {
            if (labelOptions.rotation) {
              return 0;
            }
            return (this.staggerLines || 1) * this.len / slotCount;
          }
          if (!horiz) {
            var cssWidth = labelOptions.style.width;
            if (cssWidth !== void 0) {
              return parseInt(String(cssWidth), 10);
            }
            if (marginLeft) {
              return marginLeft - chart.spacing[3];
            }
          }
          return chart.chartWidth * 0.33;
        };
        Axis2.prototype.renderUnsquish = function() {
          var chart = this.chart, renderer = chart.renderer, tickPositions = this.tickPositions, ticks = this.ticks, labelOptions = this.options.labels, labelStyleOptions = labelOptions.style, horiz = this.horiz, slotWidth = this.getSlotWidth(), innerWidth = Math.max(1, Math.round(slotWidth - 2 * labelOptions.padding)), attr2 = {}, labelMetrics = this.labelMetrics(), textOverflowOption = labelStyleOptions.textOverflow;
          var commonWidth, commonTextOverflow, maxLabelLength = 0, label, i2, pos;
          if (!isString$7(labelOptions.rotation)) {
            attr2.rotation = labelOptions.rotation || 0;
          }
          tickPositions.forEach(function(tickPosition) {
            var tick = ticks[tickPosition];
            if (tick.movedLabel) {
              tick.replaceMovedLabel();
            }
            if (tick && tick.label && tick.label.textPxLength > maxLabelLength) {
              maxLabelLength = tick.label.textPxLength;
            }
          });
          this.maxLabelLength = maxLabelLength;
          if (this.autoRotation) {
            if (maxLabelLength > innerWidth && maxLabelLength > labelMetrics.h) {
              attr2.rotation = this.labelRotation;
            } else {
              this.labelRotation = 0;
            }
          } else if (slotWidth) {
            commonWidth = innerWidth;
            if (!textOverflowOption) {
              commonTextOverflow = "clip";
              i2 = tickPositions.length;
              while (!horiz && i2--) {
                pos = tickPositions[i2];
                label = ticks[pos].label;
                if (label) {
                  if (label.styles && label.styles.textOverflow === "ellipsis") {
                    label.css({ textOverflow: "clip" });
                  } else if (label.textPxLength > slotWidth) {
                    label.css({ width: slotWidth + "px" });
                  }
                  if (label.getBBox().height > this.len / tickPositions.length - (labelMetrics.h - labelMetrics.f)) {
                    label.specificTextOverflow = "ellipsis";
                  }
                }
              }
            }
          }
          if (attr2.rotation) {
            commonWidth = maxLabelLength > chart.chartHeight * 0.5 ? chart.chartHeight * 0.33 : maxLabelLength;
            if (!textOverflowOption) {
              commonTextOverflow = "ellipsis";
            }
          }
          this.labelAlign = labelOptions.align || this.autoLabelAlign(this.labelRotation);
          if (this.labelAlign) {
            attr2.align = this.labelAlign;
          }
          tickPositions.forEach(function(pos2) {
            var tick = ticks[pos2], label2 = tick && tick.label, widthOption = labelStyleOptions.width, css2 = {};
            if (label2) {
              label2.attr(attr2);
              if (tick.shortenLabel) {
                tick.shortenLabel();
              } else if (commonWidth && !widthOption && // Setting width in this case messes with the bounding box
              // (#7975)
              labelStyleOptions.whiteSpace !== "nowrap" && // Speed optimizing, #7656
              (commonWidth < label2.textPxLength || // Resetting CSS, #4928
              label2.element.tagName === "SPAN")) {
                css2.width = commonWidth + "px";
                if (!textOverflowOption) {
                  css2.textOverflow = label2.specificTextOverflow || commonTextOverflow;
                }
                label2.css(css2);
              } else if (label2.styles && label2.styles.width && !css2.width && !widthOption) {
                label2.css({ width: null });
              }
              delete label2.specificTextOverflow;
              tick.rotation = attr2.rotation;
            }
          }, this);
          this.tickRotCorr = renderer.rotCorr(labelMetrics.b, this.labelRotation || 0, this.side !== 0);
        };
        Axis2.prototype.hasData = function() {
          return this.series.some(function(s2) {
            return s2.hasData();
          }) || this.options.showEmpty && defined$N(this.min) && defined$N(this.max);
        };
        Axis2.prototype.addTitle = function(display) {
          var axis = this, renderer = axis.chart.renderer, horiz = axis.horiz, opposite = axis.opposite, options = axis.options, axisTitleOptions = options.title, styledMode = axis.chart.styledMode;
          var textAlign;
          if (!axis.axisTitle) {
            textAlign = axisTitleOptions.textAlign;
            if (!textAlign) {
              textAlign = (horiz ? {
                low: "left",
                middle: "center",
                high: "right"
              } : {
                low: opposite ? "right" : "left",
                middle: "center",
                high: opposite ? "left" : "right"
              })[axisTitleOptions.align];
            }
            axis.axisTitle = renderer.text(axisTitleOptions.text || "", 0, 0, axisTitleOptions.useHTML).attr({
              zIndex: 7,
              rotation: axisTitleOptions.rotation,
              align: textAlign
            }).addClass("highcharts-axis-title");
            if (!styledMode) {
              axis.axisTitle.css(merge$1g(axisTitleOptions.style));
            }
            axis.axisTitle.add(axis.axisGroup);
            axis.axisTitle.isNew = true;
          }
          if (!styledMode && !axisTitleOptions.style.width && !axis.isRadial) {
            axis.axisTitle.css({
              width: axis.len + "px"
            });
          }
          axis.axisTitle[display ? "show" : "hide"](display);
        };
        Axis2.prototype.generateTick = function(pos) {
          var axis = this, ticks = axis.ticks;
          if (!ticks[pos]) {
            ticks[pos] = new Tick(axis, pos);
          } else {
            ticks[pos].addLabel();
          }
        };
        Axis2.prototype.getOffset = function() {
          var _this = this;
          var axis = this, chart = axis.chart, renderer = chart.renderer, options = axis.options, tickPositions = axis.tickPositions, ticks = axis.ticks, horiz = axis.horiz, side = axis.side, invertedSide = chart.inverted && !axis.isZAxis ? [1, 0, 3, 2][side] : side, hasData = axis.hasData(), axisTitleOptions = options.title, labelOptions = options.labels, axisOffset = chart.axisOffset, clipOffset = chart.clipOffset, directionFactor = [-1, 1, 1, -1][side], className = options.className, axisParent = axis.axisParent;
          var showAxis, titleOffset = 0, titleOffsetOption, titleMargin = 0, labelOffset = 0, labelOffsetPadded, lineHeightCorrection;
          axis.showAxis = showAxis = hasData || options.showEmpty;
          axis.staggerLines = axis.horiz && labelOptions.staggerLines || void 0;
          if (!axis.axisGroup) {
            var createGroup = function(name, suffix, zIndex) {
              return renderer.g(name).attr({ zIndex }).addClass("highcharts-" + _this.coll.toLowerCase() + suffix + " " + (_this.isRadial ? "highcharts-radial-axis" + suffix + " " : "") + (className || "")).add(axisParent);
            };
            axis.gridGroup = createGroup("grid", "-grid", options.gridZIndex);
            axis.axisGroup = createGroup("axis", "", options.zIndex);
            axis.labelGroup = createGroup("axis-labels", "-labels", labelOptions.zIndex);
          }
          if (hasData || axis.isLinked) {
            tickPositions.forEach(function(pos) {
              axis.generateTick(pos);
            });
            axis.renderUnsquish();
            axis.reserveSpaceDefault = side === 0 || side === 2 || { 1: "left", 3: "right" }[side] === axis.labelAlign;
            if (pick$1o(labelOptions.reserveSpace, axis.labelAlign === "center" ? true : null, axis.reserveSpaceDefault)) {
              tickPositions.forEach(function(pos) {
                labelOffset = Math.max(ticks[pos].getLabelSize(), labelOffset);
              });
            }
            if (axis.staggerLines) {
              labelOffset *= axis.staggerLines;
            }
            axis.labelOffset = labelOffset * (axis.opposite ? -1 : 1);
          } else {
            objectEach$s(ticks, function(tick, n2) {
              tick.destroy();
              delete ticks[n2];
            });
          }
          if (axisTitleOptions && axisTitleOptions.text && axisTitleOptions.enabled !== false) {
            axis.addTitle(showAxis);
            if (showAxis && axisTitleOptions.reserveSpace !== false) {
              axis.titleOffset = titleOffset = axis.axisTitle.getBBox()[horiz ? "height" : "width"];
              titleOffsetOption = axisTitleOptions.offset;
              titleMargin = defined$N(titleOffsetOption) ? 0 : pick$1o(axisTitleOptions.margin, horiz ? 5 : 10);
            }
          }
          axis.renderLine();
          axis.offset = directionFactor * pick$1o(options.offset, axisOffset[side] ? axisOffset[side] + (options.margin || 0) : 0);
          axis.tickRotCorr = axis.tickRotCorr || { x: 0, y: 0 };
          if (side === 0) {
            lineHeightCorrection = -axis.labelMetrics().h;
          } else if (side === 2) {
            lineHeightCorrection = axis.tickRotCorr.y;
          } else {
            lineHeightCorrection = 0;
          }
          labelOffsetPadded = Math.abs(labelOffset) + titleMargin;
          if (labelOffset) {
            labelOffsetPadded -= lineHeightCorrection;
            labelOffsetPadded += directionFactor * (horiz ? pick$1o(labelOptions.y, axis.tickRotCorr.y + directionFactor * 8) : labelOptions.x);
          }
          axis.axisTitleMargin = pick$1o(titleOffsetOption, labelOffsetPadded);
          if (axis.getMaxLabelDimensions) {
            axis.maxLabelDimensions = axis.getMaxLabelDimensions(ticks, tickPositions);
          }
          var tickSize = this.tickSize("tick");
          axisOffset[side] = Math.max(
            axisOffset[side],
            (axis.axisTitleMargin || 0) + titleOffset + directionFactor * axis.offset,
            labelOffsetPadded,
            // #3027
            tickPositions && tickPositions.length && tickSize ? tickSize[0] + directionFactor * axis.offset : 0
            // #4866
          );
          var clip = options.offset ? 0 : (
            // #4308, #4371:
            Math.floor(axis.axisLine.strokeWidth() / 2) * 2
          );
          clipOffset[invertedSide] = Math.max(clipOffset[invertedSide], clip);
          fireEvent$y(this, "afterGetOffset");
        };
        Axis2.prototype.getLinePath = function(lineWidth) {
          var chart = this.chart, opposite = this.opposite, offset2 = this.offset, horiz = this.horiz, lineLeft = this.left + (opposite ? this.width : 0) + offset2, lineTop = chart.chartHeight - this.bottom - (opposite ? this.height : 0) + offset2;
          if (opposite) {
            lineWidth *= -1;
          }
          return chart.renderer.crispLine([
            [
              "M",
              horiz ? this.left : lineLeft,
              horiz ? lineTop : this.top
            ],
            [
              "L",
              horiz ? chart.chartWidth - this.right : lineLeft,
              horiz ? lineTop : chart.chartHeight - this.bottom
            ]
          ], lineWidth);
        };
        Axis2.prototype.renderLine = function() {
          if (!this.axisLine) {
            this.axisLine = this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup);
            if (!this.chart.styledMode) {
              this.axisLine.attr({
                stroke: this.options.lineColor,
                "stroke-width": this.options.lineWidth,
                zIndex: 7
              });
            }
          }
        };
        Axis2.prototype.getTitlePosition = function() {
          var horiz = this.horiz, axisLeft = this.left, axisTop = this.top, axisLength = this.len, axisTitleOptions = this.options.title, margin = horiz ? axisLeft : axisTop, opposite = this.opposite, offset2 = this.offset, xOption = axisTitleOptions.x, yOption = axisTitleOptions.y, axisTitle = this.axisTitle, fontMetrics = this.chart.renderer.fontMetrics(axisTitleOptions.style.fontSize, axisTitle), textHeightOvershoot = Math.max(axisTitle.getBBox(null, 0).height - fontMetrics.h - 1, 0), alongAxis = {
            low: margin + (horiz ? 0 : axisLength),
            middle: margin + axisLength / 2,
            high: margin + (horiz ? axisLength : 0)
          }[axisTitleOptions.align], offAxis = (horiz ? axisTop + this.height : axisLeft) + (horiz ? 1 : -1) * // horizontal axis reverses the margin
          (opposite ? -1 : 1) * // so does opposite axes
          this.axisTitleMargin + [
            -textHeightOvershoot,
            textHeightOvershoot,
            fontMetrics.f,
            -textHeightOvershoot
            // left
          ][this.side], titlePosition = {
            x: horiz ? alongAxis + xOption : offAxis + (opposite ? this.width : 0) + offset2 + xOption,
            y: horiz ? offAxis + yOption - (opposite ? this.height : 0) + offset2 : alongAxis + yOption
          };
          fireEvent$y(this, "afterGetTitlePosition", { titlePosition });
          return titlePosition;
        };
        Axis2.prototype.renderMinorTick = function(pos, slideIn) {
          var axis = this;
          var minorTicks = axis.minorTicks;
          if (!minorTicks[pos]) {
            minorTicks[pos] = new Tick(axis, pos, "minor");
          }
          if (slideIn && minorTicks[pos].isNew) {
            minorTicks[pos].render(null, true);
          }
          minorTicks[pos].render(null, false, 1);
        };
        Axis2.prototype.renderTick = function(pos, i2, slideIn) {
          var axis = this, isLinked = axis.isLinked, ticks = axis.ticks;
          if (!isLinked || pos >= axis.min && pos <= axis.max || axis.grid && axis.grid.isColumn) {
            if (!ticks[pos]) {
              ticks[pos] = new Tick(axis, pos);
            }
            if (slideIn && ticks[pos].isNew) {
              ticks[pos].render(i2, true, -1);
            }
            ticks[pos].render(i2);
          }
        };
        Axis2.prototype.render = function() {
          var axis = this, chart = axis.chart, log = axis.logarithmic, renderer = chart.renderer, options = axis.options, isLinked = axis.isLinked, tickPositions = axis.tickPositions, axisTitle = axis.axisTitle, ticks = axis.ticks, minorTicks = axis.minorTicks, alternateBands = axis.alternateBands, stackLabelOptions = options.stackLabels, alternateGridColor = options.alternateGridColor, tickmarkOffset = axis.tickmarkOffset, axisLine = axis.axisLine, showAxis = axis.showAxis, animation = animObject$a(renderer.globalAnimation);
          var from, to;
          axis.labelEdge.length = 0;
          axis.overlap = false;
          [ticks, minorTicks, alternateBands].forEach(function(coll) {
            objectEach$s(coll, function(tick) {
              tick.isActive = false;
            });
          });
          if (axis.hasData() || isLinked) {
            var slideInTicks_1 = axis.chart.hasRendered && axis.old && isNumber$H(axis.old.min);
            if (axis.minorTickInterval && !axis.categories) {
              axis.getMinorTickPositions().forEach(function(pos) {
                axis.renderMinorTick(pos, slideInTicks_1);
              });
            }
            if (tickPositions.length) {
              tickPositions.forEach(function(pos, i2) {
                axis.renderTick(pos, i2, slideInTicks_1);
              });
              if (tickmarkOffset && (axis.min === 0 || axis.single)) {
                if (!ticks[-1]) {
                  ticks[-1] = new Tick(axis, -1, null, true);
                }
                ticks[-1].render(-1);
              }
            }
            if (alternateGridColor) {
              tickPositions.forEach(function(pos, i2) {
                to = typeof tickPositions[i2 + 1] !== "undefined" ? tickPositions[i2 + 1] + tickmarkOffset : axis.max - tickmarkOffset;
                if (i2 % 2 === 0 && pos < axis.max && to <= axis.max + (chart.polar ? -tickmarkOffset : tickmarkOffset)) {
                  if (!alternateBands[pos]) {
                    alternateBands[pos] = new H.PlotLineOrBand(axis);
                  }
                  from = pos + tickmarkOffset;
                  alternateBands[pos].options = {
                    from: log ? log.lin2log(from) : from,
                    to: log ? log.lin2log(to) : to,
                    color: alternateGridColor,
                    className: "highcharts-alternate-grid"
                  };
                  alternateBands[pos].render();
                  alternateBands[pos].isActive = true;
                }
              });
            }
            if (!axis._addedPlotLB) {
              axis._addedPlotLB = true;
              (options.plotLines || []).concat(options.plotBands || []).forEach(function(plotLineOptions) {
                axis.addPlotBandOrLine(plotLineOptions);
              });
            }
          }
          [ticks, minorTicks, alternateBands].forEach(function(coll) {
            var forDestruction = [], delay = animation.duration, destroyInactiveItems = function() {
              var i2 = forDestruction.length;
              while (i2--) {
                if (coll[forDestruction[i2]] && !coll[forDestruction[i2]].isActive) {
                  coll[forDestruction[i2]].destroy();
                  delete coll[forDestruction[i2]];
                }
              }
            };
            objectEach$s(coll, function(tick, pos) {
              if (!tick.isActive) {
                tick.render(pos, false, 0);
                tick.isActive = false;
                forDestruction.push(pos);
              }
            });
            syncTimeout$7(destroyInactiveItems, coll === alternateBands || !chart.hasRendered || !delay ? 0 : delay);
          });
          if (axisLine) {
            axisLine[axisLine.isPlaced ? "animate" : "attr"]({
              d: this.getLinePath(axisLine.strokeWidth())
            });
            axisLine.isPlaced = true;
            axisLine[showAxis ? "show" : "hide"](showAxis);
          }
          if (axisTitle && showAxis) {
            var titleXy = axis.getTitlePosition();
            if (isNumber$H(titleXy.y)) {
              axisTitle[axisTitle.isNew ? "attr" : "animate"](titleXy);
              axisTitle.isNew = false;
            } else {
              axisTitle.attr("y", -9999);
              axisTitle.isNew = true;
            }
          }
          if (stackLabelOptions && stackLabelOptions.enabled && axis.stacking) {
            axis.stacking.renderStackTotals();
          }
          axis.old = {
            len: axis.len,
            max: axis.max,
            min: axis.min,
            transA: axis.transA,
            userMax: axis.userMax,
            userMin: axis.userMin
          };
          axis.isDirty = false;
          fireEvent$y(this, "afterRender");
        };
        Axis2.prototype.redraw = function() {
          if (this.visible) {
            this.render();
            this.plotLinesAndBands.forEach(function(plotLine) {
              plotLine.render();
            });
          }
          this.series.forEach(function(series) {
            series.isDirty = true;
          });
        };
        Axis2.prototype.getKeepProps = function() {
          return this.keepProps || Axis2.keepProps;
        };
        Axis2.prototype.destroy = function(keepEvents) {
          var axis = this, plotLinesAndBands = axis.plotLinesAndBands, eventOptions = this.eventOptions;
          fireEvent$y(this, "destroy", { keepEvents });
          if (!keepEvents) {
            removeEvent$9(axis);
          }
          [axis.ticks, axis.minorTicks, axis.alternateBands].forEach(function(coll) {
            destroyObjectProperties$7(coll);
          });
          if (plotLinesAndBands) {
            var i2 = plotLinesAndBands.length;
            while (i2--) {
              plotLinesAndBands[i2].destroy();
            }
          }
          [
            "axisLine",
            "axisTitle",
            "axisGroup",
            "gridGroup",
            "labelGroup",
            "cross",
            "scrollbar"
          ].forEach(function(prop) {
            if (axis[prop]) {
              axis[prop] = axis[prop].destroy();
            }
          });
          for (var plotGroup in axis.plotLinesAndBandsGroups) {
            axis.plotLinesAndBandsGroups[plotGroup] = axis.plotLinesAndBandsGroups[plotGroup].destroy();
          }
          objectEach$s(axis, function(val, key) {
            if (axis.getKeepProps().indexOf(key) === -1) {
              delete axis[key];
            }
          });
          this.eventOptions = eventOptions;
        };
        Axis2.prototype.drawCrosshair = function(e2, point) {
          var options = this.crosshair, snap2 = pick$1o(options && options.snap, true), chart = this.chart;
          var path, pos, categorized, graphic = this.cross, crossOptions;
          fireEvent$y(this, "drawCrosshair", { e: e2, point });
          if (!e2) {
            e2 = this.cross && this.cross.e;
          }
          if (
            // Disabled in options
            !options || // Snap
            (defined$N(point) || !snap2) === false
          ) {
            this.hideCrosshair();
          } else {
            if (!snap2) {
              pos = e2 && (this.horiz ? e2.chartX - this.pos : this.len - e2.chartY + this.pos);
            } else if (defined$N(point)) {
              pos = pick$1o(this.coll !== "colorAxis" ? point.crosshairPos : (
                // 3D axis extension
                null
              ), this.isXAxis ? point.plotX : this.len - point.plotY);
            }
            if (defined$N(pos)) {
              crossOptions = {
                // value, only used on radial
                value: point && (this.isXAxis ? point.x : pick$1o(point.stackY, point.y)),
                translatedValue: pos
              };
              if (chart.polar) {
                extend$1m(crossOptions, {
                  isCrosshair: true,
                  chartX: e2 && e2.chartX,
                  chartY: e2 && e2.chartY,
                  point
                });
              }
              path = this.getPlotLinePath(crossOptions) || null;
            }
            if (!defined$N(path)) {
              this.hideCrosshair();
              return;
            }
            categorized = this.categories && !this.isRadial;
            if (!graphic) {
              this.cross = graphic = chart.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-" + (categorized ? "category " : "thin ") + (options.className || "")).attr({
                zIndex: pick$1o(options.zIndex, 2)
              }).add();
              if (!chart.styledMode) {
                graphic.attr({
                  stroke: options.color || (categorized ? Color.parse(palette.highlightColor20).setOpacity(0.25).get() : palette.neutralColor20),
                  "stroke-width": pick$1o(options.width, 1)
                }).css({
                  "pointer-events": "none"
                });
                if (options.dashStyle) {
                  graphic.attr({
                    dashstyle: options.dashStyle
                  });
                }
              }
            }
            graphic.show().attr({
              d: path
            });
            if (categorized && !options.width) {
              graphic.attr({
                "stroke-width": this.transA
              });
            }
            this.cross.e = e2;
          }
          fireEvent$y(this, "afterDrawCrosshair", { e: e2, point });
        };
        Axis2.prototype.hideCrosshair = function() {
          if (this.cross) {
            this.cross.hide();
          }
          fireEvent$y(this, "afterHideCrosshair");
        };
        Axis2.prototype.hasVerticalPanning = function() {
          var panningOptions = this.chart.options.chart.panning;
          return Boolean(panningOptions && panningOptions.enabled && // #14624
          /y/.test(panningOptions.type));
        };
        Axis2.prototype.validatePositiveValue = function(value) {
          return isNumber$H(value) && value > 0;
        };
        Axis2.prototype.update = function(options, redraw) {
          var chart = this.chart;
          options = merge$1g(this.userOptions, options);
          this.destroy(true);
          this.init(chart, options);
          chart.isDirtyBox = true;
          if (pick$1o(redraw, true)) {
            chart.redraw();
          }
        };
        Axis2.prototype.remove = function(redraw) {
          var chart = this.chart, key = this.coll, axisSeries = this.series;
          var i2 = axisSeries.length;
          while (i2--) {
            if (axisSeries[i2]) {
              axisSeries[i2].remove(false);
            }
          }
          erase$7(chart.axes, this);
          erase$7(chart[key], this);
          chart[key].forEach(function(axis, i3) {
            axis.options.index = axis.userOptions.index = i3;
          });
          this.destroy();
          chart.isDirtyBox = true;
          if (pick$1o(redraw, true)) {
            chart.redraw();
          }
        };
        Axis2.prototype.setTitle = function(titleOptions, redraw) {
          this.update({ title: titleOptions }, redraw);
        };
        Axis2.prototype.setCategories = function(categories, redraw) {
          this.update({ categories }, redraw);
        };
        Axis2.defaultOptions = AxisDefaults$1.defaultXAxisOptions;
        Axis2.keepProps = ["extKey", "hcEvents", "names", "series", "userMax", "userMin"];
        return Axis2;
      }()
    );
    var addEvent$_ = Utilities.addEvent, getMagnitude$1 = Utilities.getMagnitude, normalizeTickInterval$1 = Utilities.normalizeTickInterval, timeUnits$1 = Utilities.timeUnits;
    var DateTimeAxis;
    (function(DateTimeAxis2) {
      var composedClasses2 = [];
      function compose2(AxisClass) {
        if (composedClasses2.indexOf(AxisClass) === -1) {
          composedClasses2.push(AxisClass);
          AxisClass.keepProps.push("dateTime");
          var axisProto = AxisClass.prototype;
          axisProto.getTimeTicks = getTimeTicks;
          addEvent$_(AxisClass, "init", onInit);
        }
        return AxisClass;
      }
      DateTimeAxis2.compose = compose2;
      function getTimeTicks() {
        return this.chart.time.getTimeTicks.apply(this.chart.time, arguments);
      }
      function onInit(e2) {
        var axis = this;
        var options = e2.userOptions;
        if (options.type !== "datetime") {
          axis.dateTime = void 0;
          return;
        }
        if (!axis.dateTime) {
          axis.dateTime = new Additions(axis);
        }
      }
      var Additions = (
        /** @class */
        function() {
          function Additions2(axis) {
            this.axis = axis;
          }
          Additions2.prototype.normalizeTimeTickInterval = function(tickInterval, unitsOption) {
            var units2 = unitsOption || [[
              "millisecond",
              [1, 2, 5, 10, 20, 25, 50, 100, 200, 500]
              // allowed multiples
            ], [
              "second",
              [1, 2, 5, 10, 15, 30]
            ], [
              "minute",
              [1, 2, 5, 10, 15, 30]
            ], [
              "hour",
              [1, 2, 3, 4, 6, 8, 12]
            ], [
              "day",
              [1, 2]
            ], [
              "week",
              [1, 2]
            ], [
              "month",
              [1, 2, 3, 4, 6]
            ], [
              "year",
              null
            ]];
            var unit = units2[units2.length - 1], interval = timeUnits$1[unit[0]], multiples = unit[1], i2;
            for (i2 = 0; i2 < units2.length; i2++) {
              unit = units2[i2];
              interval = timeUnits$1[unit[0]];
              multiples = unit[1];
              if (units2[i2 + 1]) {
                var lessThan = (interval * multiples[multiples.length - 1] + timeUnits$1[units2[i2 + 1][0]]) / 2;
                if (tickInterval <= lessThan) {
                  break;
                }
              }
            }
            if (interval === timeUnits$1.year && tickInterval < 5 * interval) {
              multiples = [1, 2, 5];
            }
            var count = normalizeTickInterval$1(tickInterval / interval, multiples, unit[0] === "year" ? (
              // #1913, #2360
              Math.max(getMagnitude$1(tickInterval / interval), 1)
            ) : 1);
            return {
              unitRange: interval,
              count,
              unitName: unit[0]
            };
          };
          Additions2.prototype.getXDateFormat = function(x, dateTimeLabelFormats) {
            var axis = this.axis;
            return axis.closestPointRange ? axis.chart.time.getDateFormat(axis.closestPointRange, x, axis.options.startOfWeek, dateTimeLabelFormats) || dateTimeLabelFormats.year : (
              // #2546, 2581
              dateTimeLabelFormats.day
            );
          };
          return Additions2;
        }()
      );
      DateTimeAxis2.Additions = Additions;
    })(DateTimeAxis || (DateTimeAxis = {}));
    const DateTimeAxis$1 = DateTimeAxis;
    var addEvent$Z = Utilities.addEvent, getMagnitude = Utilities.getMagnitude, normalizeTickInterval = Utilities.normalizeTickInterval, pick$1n = Utilities.pick;
    var LogarithmicAxis;
    (function(LogarithmicAxis2) {
      var composedClasses2 = [];
      function compose2(AxisClass) {
        if (composedClasses2.indexOf(AxisClass) === -1) {
          composedClasses2.push(AxisClass);
          AxisClass.keepProps.push("logarithmic");
          addEvent$Z(AxisClass, "init", onInit);
          addEvent$Z(AxisClass, "afterInit", onAfterInit);
        }
        return AxisClass;
      }
      LogarithmicAxis2.compose = compose2;
      function onInit(e2) {
        var axis = this;
        var options = e2.userOptions;
        var logarithmic = axis.logarithmic;
        if (options.type !== "logarithmic") {
          axis.logarithmic = void 0;
        } else {
          if (!logarithmic) {
            logarithmic = axis.logarithmic = new Additions(axis);
          }
        }
      }
      function onAfterInit() {
        var axis = this;
        var log = axis.logarithmic;
        if (log) {
          axis.lin2val = function(num) {
            return log.lin2log(num);
          };
          axis.val2lin = function(num) {
            return log.log2lin(num);
          };
        }
      }
      var Additions = (
        /** @class */
        function() {
          function Additions2(axis) {
            this.axis = axis;
          }
          Additions2.prototype.getLogTickPositions = function(interval, min, max, minor) {
            var log = this;
            var axis = log.axis;
            var axisLength = axis.len;
            var options = axis.options;
            var positions = [];
            if (!minor) {
              log.minorAutoInterval = void 0;
            }
            if (interval >= 0.5) {
              interval = Math.round(interval);
              positions = axis.getLinearTickPositions(interval, min, max);
            } else if (interval >= 0.08) {
              var roundedMin = Math.floor(min);
              var intermediate = void 0, i2 = void 0, j = void 0, len = void 0, pos = void 0, lastPos = void 0, break2 = void 0;
              if (interval > 0.3) {
                intermediate = [1, 2, 4];
              } else if (interval > 0.15) {
                intermediate = [1, 2, 4, 6, 8];
              } else {
                intermediate = [1, 2, 3, 4, 5, 6, 7, 8, 9];
              }
              for (i2 = roundedMin; i2 < max + 1 && !break2; i2++) {
                len = intermediate.length;
                for (j = 0; j < len && !break2; j++) {
                  pos = log.log2lin(log.lin2log(i2) * intermediate[j]);
                  if (pos > min && (!minor || lastPos <= max) && typeof lastPos !== "undefined") {
                    positions.push(lastPos);
                  }
                  if (lastPos > max) {
                    break2 = true;
                  }
                  lastPos = pos;
                }
              }
            } else {
              var realMin = log.lin2log(min), realMax = log.lin2log(max), tickIntervalOption = minor ? axis.getMinorTickInterval() : options.tickInterval, filteredTickIntervalOption = tickIntervalOption === "auto" ? null : tickIntervalOption, tickPixelIntervalOption = options.tickPixelInterval / (minor ? 5 : 1), totalPixelLength = minor ? axisLength / axis.tickPositions.length : axisLength;
              interval = pick$1n(filteredTickIntervalOption, log.minorAutoInterval, (realMax - realMin) * tickPixelIntervalOption / (totalPixelLength || 1));
              interval = normalizeTickInterval(interval, void 0, getMagnitude(interval));
              positions = axis.getLinearTickPositions(interval, realMin, realMax).map(log.log2lin);
              if (!minor) {
                log.minorAutoInterval = interval / 5;
              }
            }
            if (!minor) {
              axis.tickInterval = interval;
            }
            return positions;
          };
          Additions2.prototype.lin2log = function(num) {
            return Math.pow(10, num);
          };
          Additions2.prototype.log2lin = function(num) {
            return Math.log(num) / Math.LN10;
          };
          return Additions2;
        }()
      );
      LogarithmicAxis2.Additions = Additions;
    })(LogarithmicAxis || (LogarithmicAxis = {}));
    const LogarithmicAxis$1 = LogarithmicAxis;
    var erase$6 = Utilities.erase, extend$1l = Utilities.extend, isNumber$G = Utilities.isNumber;
    var PlotLineOrBandAxis;
    (function(PlotLineOrBandAxis2) {
      var composedClasses2 = [];
      var PlotLineOrBandClass;
      function compose2(PlotLineOrBandType, AxisClass) {
        if (!PlotLineOrBandClass) {
          PlotLineOrBandClass = PlotLineOrBandType;
        }
        if (composedClasses2.indexOf(AxisClass) === -1) {
          composedClasses2.push(AxisClass);
          extend$1l(AxisClass.prototype, Additions.prototype);
        }
        return AxisClass;
      }
      PlotLineOrBandAxis2.compose = compose2;
      var Additions = (
        /** @class */
        function() {
          function Additions2() {
          }
          Additions2.prototype.getPlotBandPath = function(from, to, options) {
            if (options === void 0) {
              options = this.options;
            }
            var toPath = this.getPlotLinePath({
              value: to,
              force: true,
              acrossPanes: options.acrossPanes
            }), result2 = [], horiz = this.horiz, outside = !isNumber$G(this.min) || !isNumber$G(this.max) || from < this.min && to < this.min || from > this.max && to > this.max;
            var path = this.getPlotLinePath({
              value: from,
              force: true,
              acrossPanes: options.acrossPanes
            }), i2, plus = 1, isFlat;
            if (path && toPath) {
              if (outside) {
                isFlat = path.toString() === toPath.toString();
                plus = 0;
              }
              for (i2 = 0; i2 < path.length; i2 += 2) {
                var pathStart = path[i2], pathEnd = path[i2 + 1], toPathStart = toPath[i2], toPathEnd = toPath[i2 + 1];
                if ((pathStart[0] === "M" || pathStart[0] === "L") && (pathEnd[0] === "M" || pathEnd[0] === "L") && (toPathStart[0] === "M" || toPathStart[0] === "L") && (toPathEnd[0] === "M" || toPathEnd[0] === "L")) {
                  if (horiz && toPathStart[1] === pathStart[1]) {
                    toPathStart[1] += plus;
                    toPathEnd[1] += plus;
                  } else if (!horiz && toPathStart[2] === pathStart[2]) {
                    toPathStart[2] += plus;
                    toPathEnd[2] += plus;
                  }
                  result2.push(["M", pathStart[1], pathStart[2]], ["L", pathEnd[1], pathEnd[2]], ["L", toPathEnd[1], toPathEnd[2]], ["L", toPathStart[1], toPathStart[2]], ["Z"]);
                }
                result2.isFlat = isFlat;
              }
            } else {
              path = null;
            }
            return result2;
          };
          Additions2.prototype.addPlotBand = function(options) {
            return this.addPlotBandOrLine(options, "plotBands");
          };
          Additions2.prototype.addPlotLine = function(options) {
            return this.addPlotBandOrLine(options, "plotLines");
          };
          Additions2.prototype.addPlotBandOrLine = function(options, coll) {
            var _this = this;
            var userOptions = this.userOptions;
            var obj = new PlotLineOrBandClass(this, options);
            if (this.visible) {
              obj = obj.render();
            }
            if (obj) {
              if (!this._addedPlotLB) {
                this._addedPlotLB = true;
                (userOptions.plotLines || []).concat(userOptions.plotBands || []).forEach(function(plotLineOptions) {
                  _this.addPlotBandOrLine(plotLineOptions);
                });
              }
              if (coll) {
                var updatedOptions = userOptions[coll] || [];
                updatedOptions.push(options);
                userOptions[coll] = updatedOptions;
              }
              this.plotLinesAndBands.push(obj);
            }
            return obj;
          };
          Additions2.prototype.removePlotBandOrLine = function(id) {
            var plotLinesAndBands = this.plotLinesAndBands, options = this.options, userOptions = this.userOptions;
            if (plotLinesAndBands) {
              var i_1 = plotLinesAndBands.length;
              while (i_1--) {
                if (plotLinesAndBands[i_1].id === id) {
                  plotLinesAndBands[i_1].destroy();
                }
              }
              [
                options.plotLines || [],
                userOptions.plotLines || [],
                options.plotBands || [],
                userOptions.plotBands || []
              ].forEach(function(arr) {
                i_1 = arr.length;
                while (i_1--) {
                  if ((arr[i_1] || {}).id === id) {
                    erase$6(arr, arr[i_1]);
                  }
                }
              });
            }
          };
          Additions2.prototype.removePlotBand = function(id) {
            this.removePlotBandOrLine(id);
          };
          Additions2.prototype.removePlotLine = function(id) {
            this.removePlotBandOrLine(id);
          };
          return Additions2;
        }()
      );
    })(PlotLineOrBandAxis || (PlotLineOrBandAxis = {}));
    const PlotLineOrBandAxis$1 = PlotLineOrBandAxis;
    var arrayMax$8 = Utilities.arrayMax, arrayMin$7 = Utilities.arrayMin, defined$M = Utilities.defined, destroyObjectProperties$6 = Utilities.destroyObjectProperties, erase$5 = Utilities.erase, fireEvent$x = Utilities.fireEvent, merge$1f = Utilities.merge, objectEach$r = Utilities.objectEach, pick$1m = Utilities.pick;
    var PlotLineOrBand = (
      /** @class */
      function() {
        function PlotLineOrBand2(axis, options) {
          this.axis = axis;
          if (options) {
            this.options = options;
            this.id = options.id;
          }
        }
        PlotLineOrBand2.compose = function(AxisClass) {
          return PlotLineOrBandAxis$1.compose(PlotLineOrBand2, AxisClass);
        };
        PlotLineOrBand2.prototype.render = function() {
          fireEvent$x(this, "render");
          var plotLine = this, axis = plotLine.axis, horiz = axis.horiz, log = axis.logarithmic, options = plotLine.options, color2 = options.color, zIndex = pick$1m(options.zIndex, 0), events = options.events, groupAttribs = {}, renderer = axis.chart.renderer;
          var optionsLabel = options.label, label = plotLine.label, to = options.to, from = options.from, value = options.value, svgElem = plotLine.svgElem, path = [], group;
          var isBand = defined$M(from) && defined$M(to), isLine = defined$M(value), isNew = !svgElem, attribs = {
            "class": "highcharts-plot-" + (isBand ? "band " : "line ") + (options.className || "")
          };
          var groupName = isBand ? "bands" : "lines";
          if (log) {
            from = log.log2lin(from);
            to = log.log2lin(to);
            value = log.log2lin(value);
          }
          if (!axis.chart.styledMode) {
            if (isLine) {
              attribs.stroke = color2 || palette.neutralColor40;
              attribs["stroke-width"] = pick$1m(options.width, 1);
              if (options.dashStyle) {
                attribs.dashstyle = options.dashStyle;
              }
            } else if (isBand) {
              attribs.fill = color2 || palette.highlightColor10;
              if (options.borderWidth) {
                attribs.stroke = options.borderColor;
                attribs["stroke-width"] = options.borderWidth;
              }
            }
          }
          groupAttribs.zIndex = zIndex;
          groupName += "-" + zIndex;
          group = axis.plotLinesAndBandsGroups[groupName];
          if (!group) {
            axis.plotLinesAndBandsGroups[groupName] = group = renderer.g("plot-" + groupName).attr(groupAttribs).add();
          }
          if (isNew) {
            plotLine.svgElem = svgElem = renderer.path().attr(attribs).add(group);
          }
          if (isLine) {
            path = axis.getPlotLinePath({
              value,
              lineWidth: svgElem.strokeWidth(),
              acrossPanes: options.acrossPanes
            });
          } else if (isBand) {
            path = axis.getPlotBandPath(from, to, options);
          } else {
            return;
          }
          if (!plotLine.eventsAdded && events) {
            objectEach$r(events, function(event, eventType) {
              svgElem.on(eventType, function(e2) {
                events[eventType].apply(plotLine, [e2]);
              });
            });
            plotLine.eventsAdded = true;
          }
          if ((isNew || !svgElem.d) && path && path.length) {
            svgElem.attr({ d: path });
          } else if (svgElem) {
            if (path) {
              svgElem.show(true);
              svgElem.animate({ d: path });
            } else if (svgElem.d) {
              svgElem.hide();
              if (label) {
                plotLine.label = label = label.destroy();
              }
            }
          }
          if (optionsLabel && (defined$M(optionsLabel.text) || defined$M(optionsLabel.formatter)) && path && path.length && axis.width > 0 && axis.height > 0 && !path.isFlat) {
            optionsLabel = merge$1f({
              align: horiz && isBand && "center",
              x: horiz ? !isBand && 4 : 10,
              verticalAlign: !horiz && isBand && "middle",
              y: horiz ? isBand ? 16 : 10 : isBand ? 6 : -4,
              rotation: horiz && !isBand && 90
            }, optionsLabel);
            this.renderLabel(optionsLabel, path, isBand, zIndex);
          } else if (label) {
            label.hide();
          }
          return plotLine;
        };
        PlotLineOrBand2.prototype.renderLabel = function(optionsLabel, path, isBand, zIndex) {
          var plotLine = this, axis = plotLine.axis, renderer = axis.chart.renderer;
          var label = plotLine.label;
          if (!label) {
            plotLine.label = label = renderer.text(this.getLabelText(optionsLabel), 0, 0, optionsLabel.useHTML).attr({
              align: optionsLabel.textAlign || optionsLabel.align,
              rotation: optionsLabel.rotation,
              "class": "highcharts-plot-" + (isBand ? "band" : "line") + "-label " + (optionsLabel.className || ""),
              zIndex
            }).add();
            if (!axis.chart.styledMode) {
              label.css(merge$1f({
                textOverflow: "ellipsis"
              }, optionsLabel.style));
            }
          }
          var xBounds = path.xBounds || [path[0][1], path[1][1], isBand ? path[2][1] : path[0][1]];
          var yBounds = path.yBounds || [path[0][2], path[1][2], isBand ? path[2][2] : path[0][2]];
          var x = arrayMin$7(xBounds);
          var y = arrayMin$7(yBounds);
          label.align(optionsLabel, false, {
            x,
            y,
            width: arrayMax$8(xBounds) - x,
            height: arrayMax$8(yBounds) - y
          });
          if (!label.alignValue || label.alignValue === "left") {
            label.css({
              width: (label.rotation === 90 ? axis.height - (label.alignAttr.y - axis.top) : axis.width - (label.alignAttr.x - axis.left)) + "px"
            });
          }
          label.show(true);
        };
        PlotLineOrBand2.prototype.getLabelText = function(optionsLabel) {
          return defined$M(optionsLabel.formatter) ? optionsLabel.formatter.call(this) : optionsLabel.text;
        };
        PlotLineOrBand2.prototype.destroy = function() {
          erase$5(this.axis.plotLinesAndBands, this);
          delete this.axis;
          destroyObjectProperties$6(this);
        };
        return PlotLineOrBand2;
      }()
    );
    var format$d = FormatUtilities.format;
    var doc$i = H.doc;
    var distribute$3 = R.distribute;
    var addEvent$Y = Utilities.addEvent, clamp$g = Utilities.clamp, css$9 = Utilities.css, defined$L = Utilities.defined, discardElement$5 = Utilities.discardElement, extend$1k = Utilities.extend, fireEvent$w = Utilities.fireEvent, isArray$i = Utilities.isArray, isNumber$F = Utilities.isNumber, isString$6 = Utilities.isString, merge$1e = Utilities.merge, pick$1l = Utilities.pick, splat$f = Utilities.splat, syncTimeout$6 = Utilities.syncTimeout;
    var Tooltip = (
      /** @class */
      function() {
        function Tooltip2(chart, options) {
          this.container = void 0;
          this.crosshairs = [];
          this.distance = 0;
          this.isHidden = true;
          this.isSticky = false;
          this.now = {};
          this.options = {};
          this.outside = false;
          this.chart = chart;
          this.init(chart, options);
        }
        Tooltip2.prototype.applyFilter = function() {
          var chart = this.chart;
          chart.renderer.definition({
            tagName: "filter",
            attributes: {
              id: "drop-shadow-" + chart.index,
              opacity: 0.5
            },
            children: [{
              tagName: "feGaussianBlur",
              attributes: {
                "in": "SourceAlpha",
                stdDeviation: 1
              }
            }, {
              tagName: "feOffset",
              attributes: {
                dx: 1,
                dy: 1
              }
            }, {
              tagName: "feComponentTransfer",
              children: [{
                tagName: "feFuncA",
                attributes: {
                  type: "linear",
                  slope: 0.3
                }
              }]
            }, {
              tagName: "feMerge",
              children: [{
                tagName: "feMergeNode"
              }, {
                tagName: "feMergeNode",
                attributes: {
                  "in": "SourceGraphic"
                }
              }]
            }]
          });
        };
        Tooltip2.prototype.bodyFormatter = function(items) {
          return items.map(function(item2) {
            var tooltipOptions = item2.series.tooltipOptions;
            return (tooltipOptions[(item2.point.formatPrefix || "point") + "Formatter"] || item2.point.tooltipFormatter).call(item2.point, tooltipOptions[(item2.point.formatPrefix || "point") + "Format"] || "");
          });
        };
        Tooltip2.prototype.cleanSplit = function(force) {
          this.chart.series.forEach(function(series) {
            var tt = series && series.tt;
            if (tt) {
              if (!tt.isActive || force) {
                series.tt = tt.destroy();
              } else {
                tt.isActive = false;
              }
            }
          });
        };
        Tooltip2.prototype.defaultFormatter = function(tooltip) {
          var items = this.points || splat$f(this);
          var s2;
          s2 = [tooltip.tooltipFooterHeaderFormatter(items[0])];
          s2 = s2.concat(tooltip.bodyFormatter(items));
          s2.push(tooltip.tooltipFooterHeaderFormatter(items[0], true));
          return s2;
        };
        Tooltip2.prototype.destroy = function() {
          if (this.label) {
            this.label = this.label.destroy();
          }
          if (this.split && this.tt) {
            this.cleanSplit(this.chart, true);
            this.tt = this.tt.destroy();
          }
          if (this.renderer) {
            this.renderer = this.renderer.destroy();
            discardElement$5(this.container);
          }
          Utilities.clearTimeout(this.hideTimer);
          Utilities.clearTimeout(this.tooltipTimeout);
        };
        Tooltip2.prototype.getAnchor = function(points, mouseEvent) {
          var chart = this.chart, pointer = chart.pointer, inverted = chart.inverted, plotTop = chart.plotTop, plotLeft = chart.plotLeft;
          var ret, yAxis, xAxis, plotX = 0, plotY = 0;
          points = splat$f(points);
          if (this.followPointer && mouseEvent) {
            if (typeof mouseEvent.chartX === "undefined") {
              mouseEvent = pointer.normalize(mouseEvent);
            }
            ret = [
              mouseEvent.chartX - plotLeft,
              mouseEvent.chartY - plotTop
            ];
          } else if (points[0].tooltipPos) {
            ret = points[0].tooltipPos;
          } else {
            points.forEach(function(point) {
              yAxis = point.series.yAxis;
              xAxis = point.series.xAxis;
              plotX += point.plotX || 0;
              plotY += point.plotLow ? (point.plotLow + (point.plotHigh || 0)) / 2 : point.plotY || 0;
              if (xAxis && yAxis) {
                if (!inverted) {
                  plotX += xAxis.pos - plotLeft;
                  plotY += yAxis.pos - plotTop;
                } else {
                  plotX += plotTop + chart.plotHeight - xAxis.len - xAxis.pos;
                  plotY += plotLeft + chart.plotWidth - yAxis.len - yAxis.pos;
                }
              }
            });
            plotX /= points.length;
            plotY /= points.length;
            ret = [
              inverted ? chart.plotWidth - plotY : plotX,
              inverted ? chart.plotHeight - plotX : plotY
            ];
            if (this.shared && points.length > 1 && mouseEvent) {
              if (inverted) {
                ret[0] = mouseEvent.chartX - plotLeft;
              } else {
                ret[1] = mouseEvent.chartY - plotTop;
              }
            }
          }
          return ret.map(Math.round);
        };
        Tooltip2.prototype.getLabel = function() {
          var tooltip = this, styledMode = this.chart.styledMode, options = this.options, className = "tooltip" + (defined$L(options.className) ? " " + options.className : ""), pointerEvents = options.style.pointerEvents || (!this.followPointer && options.stickOnContact ? "auto" : "none"), onMouseEnter = function() {
            tooltip.inContact = true;
          }, onMouseLeave = function(e2) {
            var series = tooltip.chart.hoverSeries;
            tooltip.inContact = tooltip.shouldStickOnContact() && tooltip.chart.pointer.inClass(e2.relatedTarget, "highcharts-tooltip");
            if (!tooltip.inContact && series && series.onMouseOut) {
              series.onMouseOut();
            }
          };
          var container, renderer = this.chart.renderer;
          if (!this.label) {
            if (this.outside) {
              var chartStyle = this.chart.options.chart.style, Renderer2 = RendererRegistry$1.getRendererType();
              this.container = container = H.doc.createElement("div");
              container.className = "highcharts-tooltip-container";
              css$9(container, {
                position: "absolute",
                top: "1px",
                pointerEvents,
                zIndex: Math.max(this.options.style.zIndex || 0, (chartStyle && chartStyle.zIndex || 0) + 3)
              });
              addEvent$Y(container, "mouseenter", onMouseEnter);
              addEvent$Y(container, "mouseleave", onMouseLeave);
              H.doc.body.appendChild(container);
              this.renderer = renderer = new Renderer2(container, 0, 0, chartStyle, void 0, void 0, renderer.styledMode);
            }
            if (this.split) {
              this.label = renderer.g(className);
            } else {
              this.label = renderer.label("", 0, 0, options.shape, void 0, void 0, options.useHTML, void 0, className).attr({
                padding: options.padding,
                r: options.borderRadius
              });
              if (!styledMode) {
                this.label.attr({
                  fill: options.backgroundColor,
                  "stroke-width": options.borderWidth
                }).css(options.style).css({ pointerEvents }).shadow(options.shadow);
              }
            }
            if (styledMode && options.shadow) {
              this.applyFilter();
              this.label.attr({
                filter: "url(#drop-shadow-" + this.chart.index + ")"
              });
            }
            if (tooltip.outside && !tooltip.split) {
              var label_1 = this.label;
              var xSetter_1 = label_1.xSetter, ySetter_1 = label_1.ySetter;
              label_1.xSetter = function(value) {
                xSetter_1.call(label_1, tooltip.distance);
                container.style.left = value + "px";
              };
              label_1.ySetter = function(value) {
                ySetter_1.call(label_1, tooltip.distance);
                container.style.top = value + "px";
              };
            }
            this.label.on("mouseenter", onMouseEnter).on("mouseleave", onMouseLeave).attr({ zIndex: 8 }).add();
          }
          return this.label;
        };
        Tooltip2.prototype.getPosition = function(boxWidth, boxHeight, point) {
          var chart = this.chart, distance = this.distance, ret = {}, h2 = chart.inverted && point.h || 0, outside = this.outside, outerWidth = outside ? (
            // substract distance to prevent scrollbars
            doc$i.documentElement.clientWidth - 2 * distance
          ) : chart.chartWidth, outerHeight = outside ? Math.max(doc$i.body.scrollHeight, doc$i.documentElement.scrollHeight, doc$i.body.offsetHeight, doc$i.documentElement.offsetHeight, doc$i.documentElement.clientHeight) : chart.chartHeight, chartPosition = chart.pointer.getChartPosition(), scaleX = function(val) {
            return (
              // eslint-disable-line no-confusing-arrow
              val * chartPosition.scaleX
            );
          }, scaleY = function(val) {
            return (
              // eslint-disable-line no-confusing-arrow
              val * chartPosition.scaleY
            );
          }, buildDimensionArray = function(dim) {
            var isX = dim === "x";
            return [
              dim,
              isX ? outerWidth : outerHeight,
              isX ? boxWidth : boxHeight
            ].concat(outside ? [
              // If we are using tooltip.outside, we need to scale the
              // position to match scaling of the container in case there
              // is a transform/zoom on the container. #11329
              isX ? scaleX(boxWidth) : scaleY(boxHeight),
              isX ? chartPosition.left - distance + scaleX(point.plotX + chart.plotLeft) : chartPosition.top - distance + scaleY(point.plotY + chart.plotTop),
              0,
              isX ? outerWidth : outerHeight
            ] : [
              // Not outside, no scaling is needed
              isX ? boxWidth : boxHeight,
              isX ? point.plotX + chart.plotLeft : point.plotY + chart.plotTop,
              isX ? chart.plotLeft : chart.plotTop,
              isX ? chart.plotLeft + chart.plotWidth : chart.plotTop + chart.plotHeight
            ]);
          };
          var first = buildDimensionArray("y"), second = buildDimensionArray("x"), swapped;
          var preferFarSide = !this.followPointer && pick$1l(point.ttBelow, !chart.inverted === !!point.negative), firstDimension = function(dim, outerSize, innerSize, scaledInnerSize, point2, min, max) {
            var scaledDist = outside ? dim === "y" ? scaleY(distance) : scaleX(distance) : distance, scaleDiff = (innerSize - scaledInnerSize) / 2, roomLeft = scaledInnerSize < point2 - distance, roomRight = point2 + distance + scaledInnerSize < outerSize, alignedLeft = point2 - scaledDist - innerSize + scaleDiff, alignedRight = point2 + scaledDist - scaleDiff;
            if (preferFarSide && roomRight) {
              ret[dim] = alignedRight;
            } else if (!preferFarSide && roomLeft) {
              ret[dim] = alignedLeft;
            } else if (roomLeft) {
              ret[dim] = Math.min(max - scaledInnerSize, alignedLeft - h2 < 0 ? alignedLeft : alignedLeft - h2);
            } else if (roomRight) {
              ret[dim] = Math.max(min, alignedRight + h2 + innerSize > outerSize ? alignedRight : alignedRight + h2);
            } else {
              return false;
            }
          }, secondDimension = function(dim, outerSize, innerSize, scaledInnerSize, point2) {
            var retVal;
            if (point2 < distance || point2 > outerSize - distance) {
              retVal = false;
            } else if (point2 < innerSize / 2) {
              ret[dim] = 1;
            } else if (point2 > outerSize - scaledInnerSize / 2) {
              ret[dim] = outerSize - scaledInnerSize - 2;
            } else {
              ret[dim] = point2 - innerSize / 2;
            }
            return retVal;
          }, swap2 = function(count) {
            var temp = first;
            first = second;
            second = temp;
            swapped = count;
          }, run = function() {
            if (firstDimension.apply(0, first) !== false) {
              if (secondDimension.apply(0, second) === false && !swapped) {
                swap2(true);
                run();
              }
            } else if (!swapped) {
              swap2(true);
              run();
            } else {
              ret.x = ret.y = 0;
            }
          };
          if (chart.inverted || this.len > 1) {
            swap2();
          }
          run();
          return ret;
        };
        Tooltip2.prototype.hide = function(delay) {
          var tooltip = this;
          Utilities.clearTimeout(this.hideTimer);
          delay = pick$1l(delay, this.options.hideDelay);
          if (!this.isHidden) {
            this.hideTimer = syncTimeout$6(function() {
              tooltip.getLabel().fadeOut(delay ? void 0 : delay);
              tooltip.isHidden = true;
            }, delay);
          }
        };
        Tooltip2.prototype.init = function(chart, options) {
          this.chart = chart;
          this.options = options;
          this.crosshairs = [];
          this.now = { x: 0, y: 0 };
          this.isHidden = true;
          this.split = options.split && !chart.inverted && !chart.polar;
          this.shared = options.shared || this.split;
          this.outside = pick$1l(options.outside, Boolean(chart.scrollablePixelsX || chart.scrollablePixelsY));
        };
        Tooltip2.prototype.shouldStickOnContact = function() {
          return !!(!this.followPointer && this.options.stickOnContact);
        };
        Tooltip2.prototype.isStickyOnContact = function() {
          return !!(this.shouldStickOnContact() && this.inContact);
        };
        Tooltip2.prototype.move = function(x, y, anchorX, anchorY) {
          var tooltip = this, now = tooltip.now, animate2 = tooltip.options.animation !== false && !tooltip.isHidden && // When we get close to the target position, abort animation and
          // land on the right place (#3056)
          (Math.abs(x - now.x) > 1 || Math.abs(y - now.y) > 1), skipAnchor = tooltip.followPointer || tooltip.len > 1;
          extend$1k(now, {
            x: animate2 ? (2 * now.x + x) / 3 : x,
            y: animate2 ? (now.y + y) / 2 : y,
            anchorX: skipAnchor ? void 0 : animate2 ? (2 * now.anchorX + anchorX) / 3 : anchorX,
            anchorY: skipAnchor ? void 0 : animate2 ? (now.anchorY + anchorY) / 2 : anchorY
          });
          tooltip.getLabel().attr(now);
          tooltip.drawTracker();
          if (animate2) {
            Utilities.clearTimeout(this.tooltipTimeout);
            this.tooltipTimeout = setTimeout(function() {
              if (tooltip) {
                tooltip.move(x, y, anchorX, anchorY);
              }
            }, 32);
          }
        };
        Tooltip2.prototype.refresh = function(pointOrPoints, mouseEvent) {
          var tooltip = this, chart = this.chart, options = tooltip.options, points = splat$f(pointOrPoints), point = points[0], pointConfig = [], formatter = options.formatter || tooltip.defaultFormatter, shared2 = tooltip.shared, styledMode = chart.styledMode;
          var textConfig = {};
          if (!options.enabled) {
            return;
          }
          Utilities.clearTimeout(this.hideTimer);
          tooltip.followPointer = !tooltip.split && point.series.tooltipOptions.followPointer;
          var anchor = tooltip.getAnchor(pointOrPoints, mouseEvent), x = anchor[0], y = anchor[1];
          if (shared2 && !(!isArray$i(pointOrPoints) && pointOrPoints.series && pointOrPoints.series.noSharedTooltip)) {
            chart.pointer.applyInactiveState(points);
            points.forEach(function(item2) {
              item2.setState("hover");
              pointConfig.push(item2.getLabelConfig());
            });
            textConfig = {
              x: point.category,
              y: point.y
            };
            textConfig.points = pointConfig;
          } else {
            textConfig = point.getLabelConfig();
          }
          this.len = pointConfig.length;
          var text = formatter.call(textConfig, tooltip);
          var currentSeries = point.series;
          this.distance = pick$1l(currentSeries.tooltipOptions.distance, 16);
          if (text === false) {
            this.hide();
          } else {
            if (tooltip.split) {
              this.renderSplit(text, points);
            } else {
              var checkX = x;
              var checkY = y;
              if (mouseEvent && chart.pointer.isDirectTouch) {
                checkX = mouseEvent.chartX - chart.plotLeft;
                checkY = mouseEvent.chartY - chart.plotTop;
              }
              if (chart.polar || currentSeries.options.clip === false || currentSeries.shouldShowTooltip(checkX, checkY)) {
                var label = tooltip.getLabel();
                if (!options.style.width || styledMode) {
                  label.css({
                    width: this.chart.spacingBox.width + "px"
                  });
                }
                label.attr({
                  text: text && text.join ? text.join("") : text
                });
                label.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-" + pick$1l(point.colorIndex, currentSeries.colorIndex));
                if (!styledMode) {
                  label.attr({
                    stroke: options.borderColor || point.color || currentSeries.color || palette.neutralColor60
                  });
                }
                tooltip.updatePosition({
                  plotX: x,
                  plotY: y,
                  negative: point.negative,
                  ttBelow: point.ttBelow,
                  h: anchor[2] || 0
                });
              } else {
                tooltip.hide();
                return;
              }
            }
            if (tooltip.isHidden && tooltip.label) {
              tooltip.label.attr({
                opacity: 1
              }).show();
            }
            tooltip.isHidden = false;
          }
          fireEvent$w(this, "refresh");
        };
        Tooltip2.prototype.renderSplit = function(labels, points) {
          var tooltip = this;
          var chart = tooltip.chart, _a3 = tooltip.chart, chartWidth = _a3.chartWidth, chartHeight = _a3.chartHeight, plotHeight = _a3.plotHeight, plotLeft = _a3.plotLeft, plotTop = _a3.plotTop, pointer = _a3.pointer, _b3 = _a3.scrollablePixelsY, scrollablePixelsY = _b3 === void 0 ? 0 : _b3, scrollablePixelsX = _a3.scrollablePixelsX, _c2 = _a3.scrollingContainer, _d2 = _c2 === void 0 ? { scrollLeft: 0, scrollTop: 0 } : _c2, scrollLeft = _d2.scrollLeft, scrollTop = _d2.scrollTop, styledMode = _a3.styledMode, distance = tooltip.distance, options = tooltip.options, positioner = tooltip.options.positioner;
          var bounds = tooltip.outside && typeof scrollablePixelsX !== "number" ? doc$i.documentElement.getBoundingClientRect() : {
            left: scrollLeft,
            right: scrollLeft + chartWidth,
            top: scrollTop,
            bottom: scrollTop + chartHeight
          };
          var tooltipLabel = tooltip.getLabel();
          var ren = this.renderer || chart.renderer;
          var headerTop = Boolean(chart.xAxis[0] && chart.xAxis[0].opposite);
          var _e2 = pointer.getChartPosition(), chartLeft = _e2.left, chartTop = _e2.top;
          var distributionBoxTop = plotTop + scrollTop;
          var headerHeight = 0;
          var adjustedPlotHeight = plotHeight - scrollablePixelsY;
          function getAnchor(point) {
            var isHeader = point.isHeader, _a4 = point.plotX, plotX = _a4 === void 0 ? 0 : _a4, _b4 = point.plotY, plotY = _b4 === void 0 ? 0 : _b4, series = point.series;
            var anchorX;
            var anchorY;
            if (isHeader) {
              anchorX = plotLeft + plotX;
              anchorY = plotTop + plotHeight / 2;
            } else {
              var xAxis = series.xAxis, yAxis = series.yAxis;
              anchorX = xAxis.pos + clamp$g(plotX, -distance, xAxis.len + distance);
              if (series.shouldShowTooltip(0, yAxis.pos - plotTop + plotY, {
                ignoreX: true
              })) {
                anchorY = yAxis.pos + plotY;
              }
            }
            anchorX = clamp$g(anchorX, bounds.left - distance, bounds.right + distance);
            return { anchorX, anchorY };
          }
          function defaultPositioner(anchorX, anchorY, isHeader, boxWidth, alignedLeft) {
            if (alignedLeft === void 0) {
              alignedLeft = true;
            }
            var y2;
            var x2;
            if (isHeader) {
              y2 = headerTop ? 0 : adjustedPlotHeight;
              x2 = clamp$g(anchorX - boxWidth / 2, bounds.left, bounds.right - boxWidth - (tooltip.outside ? chartLeft : 0));
            } else {
              y2 = anchorY - distributionBoxTop;
              x2 = alignedLeft ? anchorX - boxWidth - distance : anchorX + distance;
              x2 = clamp$g(x2, alignedLeft ? x2 : bounds.left, bounds.right);
            }
            return { x: x2, y: y2 };
          }
          function updatePartialTooltip(partialTooltip, point, str) {
            var tt = partialTooltip;
            var isHeader = point.isHeader, series = point.series;
            var colorClass = "highcharts-color-" + pick$1l(point.colorIndex, series.colorIndex, "none");
            if (!tt) {
              var attribs = {
                padding: options.padding,
                r: options.borderRadius
              };
              if (!styledMode) {
                attribs.fill = options.backgroundColor;
                attribs["stroke-width"] = options.borderWidth;
              }
              tt = ren.label("", 0, 0, options[isHeader ? "headerShape" : "shape"], void 0, void 0, options.useHTML).addClass((isHeader ? "highcharts-tooltip-header " : "") + "highcharts-tooltip-box " + colorClass).attr(attribs).add(tooltipLabel);
            }
            tt.isActive = true;
            tt.attr({
              text: str
            });
            if (!styledMode) {
              tt.css(options.style).shadow(options.shadow).attr({
                stroke: options.borderColor || point.color || series.color || palette.neutralColor80
              });
            }
            return tt;
          }
          if (isString$6(labels)) {
            labels = [false, labels];
          }
          var boxes = labels.slice(0, points.length + 1).reduce(function(boxes2, str, i2) {
            if (str !== false && str !== "") {
              var point = points[i2 - 1] || {
                // Item 0 is the header. Instead of this, we could also
                // use the crosshair label
                isHeader: true,
                plotX: points[0].plotX,
                plotY: plotHeight,
                series: {}
              };
              var isHeader = point.isHeader;
              var owner = isHeader ? tooltip : point.series;
              var tt = owner.tt = updatePartialTooltip(owner.tt, point, str.toString());
              var bBox = tt.getBBox();
              var boxWidth = bBox.width + tt.strokeWidth();
              if (isHeader) {
                headerHeight = bBox.height;
                adjustedPlotHeight += headerHeight;
                if (headerTop) {
                  distributionBoxTop -= headerHeight;
                }
              }
              var _a4 = getAnchor(point), anchorX = _a4.anchorX, anchorY = _a4.anchorY;
              if (typeof anchorY === "number") {
                var size = bBox.height + 1;
                var boxPosition = positioner ? positioner.call(tooltip, boxWidth, size, point) : defaultPositioner(anchorX, anchorY, isHeader, boxWidth);
                boxes2.push({
                  // 0-align to the top, 1-align to the bottom
                  align: positioner ? 0 : void 0,
                  anchorX,
                  anchorY,
                  boxWidth,
                  point,
                  rank: pick$1l(boxPosition.rank, isHeader ? 1 : 0),
                  size,
                  target: boxPosition.y,
                  tt,
                  x: boxPosition.x
                });
              } else {
                tt.isActive = false;
              }
            }
            return boxes2;
          }, []);
          if (!positioner && boxes.some(function(box) {
            var outside2 = tooltip.outside;
            var boxStart = (outside2 ? chartLeft : 0) + box.anchorX;
            if (boxStart < bounds.left && boxStart + box.boxWidth < bounds.right) {
              return true;
            }
            return boxStart < chartLeft - bounds.left + box.boxWidth && bounds.right - boxStart > boxStart;
          })) {
            boxes = boxes.map(function(box) {
              var _a4 = defaultPositioner(box.anchorX, box.anchorY, box.point.isHeader, box.boxWidth, false), x2 = _a4.x, y2 = _a4.y;
              return extend$1k(box, {
                target: y2,
                x: x2
              });
            });
          }
          tooltip.cleanSplit();
          distribute$3(boxes, adjustedPlotHeight);
          var boxExtremes = {
            left: chartLeft,
            right: chartLeft
          };
          boxes.forEach(function(box) {
            var x2 = box.x, boxWidth = box.boxWidth, isHeader = box.isHeader;
            if (!isHeader) {
              if (tooltip.outside && chartLeft + x2 < boxExtremes.left) {
                boxExtremes.left = chartLeft + x2;
              }
              if (!isHeader && tooltip.outside && boxExtremes.left + boxWidth > boxExtremes.right) {
                boxExtremes.right = chartLeft + x2;
              }
            }
          });
          boxes.forEach(function(box) {
            var x2 = box.x, anchorX = box.anchorX, anchorY = box.anchorY, pos = box.pos, isHeader = box.point.isHeader;
            var attributes = {
              visibility: typeof pos === "undefined" ? "hidden" : "inherit",
              x: x2,
              /* NOTE: y should equal pos to be consistent with !split
               * tooltip, but is currently relative to plotTop. Is left as is
               * to avoid breaking change. Remove distributionBoxTop to make
               * it consistent.
               */
              y: pos + distributionBoxTop,
              anchorX,
              anchorY
            };
            if (tooltip.outside && x2 < anchorX) {
              var offset2 = chartLeft - boxExtremes.left;
              if (offset2 > 0) {
                if (!isHeader) {
                  attributes.x = x2 + offset2;
                  attributes.anchorX = anchorX + offset2;
                }
                if (isHeader) {
                  attributes.x = (boxExtremes.right - boxExtremes.left) / 2;
                  attributes.anchorX = anchorX + offset2;
                }
              }
            }
            box.tt.attr(attributes);
          });
          var container = tooltip.container, outside = tooltip.outside, renderer = tooltip.renderer;
          if (outside && container && renderer) {
            var _f = tooltipLabel.getBBox(), width = _f.width, height = _f.height, x = _f.x, y = _f.y;
            renderer.setSize(width + x, height + y, false);
            container.style.left = boxExtremes.left + "px";
            container.style.top = chartTop + "px";
          }
        };
        Tooltip2.prototype.drawTracker = function() {
          var tooltip = this;
          if (tooltip.followPointer || !tooltip.options.stickOnContact) {
            if (tooltip.tracker) {
              tooltip.tracker.destroy();
            }
            return;
          }
          var chart = tooltip.chart;
          var label = tooltip.label;
          var points = tooltip.shared ? chart.hoverPoints : chart.hoverPoint;
          if (!label || !points) {
            return;
          }
          var box = {
            x: 0,
            y: 0,
            width: 0,
            height: 0
          };
          var anchorPos = this.getAnchor(points);
          var labelBBox = label.getBBox();
          anchorPos[0] += chart.plotLeft - label.translateX;
          anchorPos[1] += chart.plotTop - label.translateY;
          box.x = Math.min(0, anchorPos[0]);
          box.y = Math.min(0, anchorPos[1]);
          box.width = anchorPos[0] < 0 ? Math.max(Math.abs(anchorPos[0]), labelBBox.width - anchorPos[0]) : Math.max(Math.abs(anchorPos[0]), labelBBox.width);
          box.height = anchorPos[1] < 0 ? Math.max(Math.abs(anchorPos[1]), labelBBox.height - Math.abs(anchorPos[1])) : Math.max(Math.abs(anchorPos[1]), labelBBox.height);
          if (tooltip.tracker) {
            tooltip.tracker.attr(box);
          } else {
            tooltip.tracker = label.renderer.rect(box).addClass("highcharts-tracker").add(label);
            if (!chart.styledMode) {
              tooltip.tracker.attr({
                fill: "rgba(0,0,0,0)"
              });
            }
          }
        };
        Tooltip2.prototype.styledModeFormat = function(formatString) {
          return formatString.replace('style="font-size: 10px"', 'class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g, 'class="highcharts-color-{$1.colorIndex}"');
        };
        Tooltip2.prototype.tooltipFooterHeaderFormatter = function(labelConfig, isFooter) {
          var series = labelConfig.series, tooltipOptions = series.tooltipOptions, xAxis = series.xAxis, dateTime = xAxis && xAxis.dateTime, e2 = {
            isFooter,
            labelConfig
          };
          var xDateFormat = tooltipOptions.xDateFormat, formatString = tooltipOptions[isFooter ? "footerFormat" : "headerFormat"];
          fireEvent$w(this, "headerFormatter", e2, function(e3) {
            if (dateTime && !xDateFormat && isNumber$F(labelConfig.key)) {
              xDateFormat = dateTime.getXDateFormat(labelConfig.key, tooltipOptions.dateTimeLabelFormats);
            }
            if (dateTime && xDateFormat) {
              (labelConfig.point && labelConfig.point.tooltipDateKeys || ["key"]).forEach(function(key) {
                formatString = formatString.replace("{point." + key + "}", "{point." + key + ":" + xDateFormat + "}");
              });
            }
            if (series.chart.styledMode) {
              formatString = this.styledModeFormat(formatString);
            }
            e3.text = format$d(formatString, {
              point: labelConfig,
              series
            }, this.chart);
          });
          return e2.text;
        };
        Tooltip2.prototype.update = function(options) {
          this.destroy();
          merge$1e(true, this.chart.options.tooltip.userOptions, options);
          this.init(this.chart, merge$1e(true, this.options, options));
        };
        Tooltip2.prototype.updatePosition = function(point) {
          var chart = this.chart, options = this.options, pointer = chart.pointer, label = this.getLabel(), chartPosition = pointer.getChartPosition(), pos = (options.positioner || this.getPosition).call(this, label.width, label.height, point);
          var anchorX = point.plotX + chart.plotLeft, anchorY = point.plotY + chart.plotTop, pad2;
          if (this.outside) {
            pad2 = options.borderWidth + 2 * this.distance;
            this.renderer.setSize(label.width + pad2, label.height + pad2, false);
            if (chartPosition.scaleX !== 1 || chartPosition.scaleY !== 1) {
              css$9(this.container, {
                transform: "scale(" + chartPosition.scaleX + ", " + chartPosition.scaleY + ")"
              });
              anchorX *= chartPosition.scaleX;
              anchorY *= chartPosition.scaleY;
            }
            anchorX += chartPosition.left - pos.x;
            anchorY += chartPosition.top - pos.y;
          }
          this.move(
            Math.round(pos.x),
            Math.round(pos.y || 0),
            // can be undefined (#3977)
            anchorX,
            anchorY
          );
        };
        return Tooltip2;
      }()
    );
    var animObject$9 = animationExports.animObject;
    var defaultOptions$d = DefaultOptions.defaultOptions;
    var format$c = FormatUtilities.format;
    var addEvent$X = Utilities.addEvent, defined$K = Utilities.defined, erase$4 = Utilities.erase, extend$1j = Utilities.extend, fireEvent$v = Utilities.fireEvent, getNestedProperty$1 = Utilities.getNestedProperty, isArray$h = Utilities.isArray, isFunction$2 = Utilities.isFunction, isNumber$E = Utilities.isNumber, isObject$b = Utilities.isObject, merge$1d = Utilities.merge, objectEach$q = Utilities.objectEach, pick$1k = Utilities.pick, syncTimeout$5 = Utilities.syncTimeout, removeEvent$8 = Utilities.removeEvent, uniqueKey$5 = Utilities.uniqueKey;
    var Point$4 = (
      /** @class */
      function() {
        function Point2() {
          this.category = void 0;
          this.colorIndex = void 0;
          this.formatPrefix = "point";
          this.id = void 0;
          this.isNull = false;
          this.name = void 0;
          this.options = void 0;
          this.percentage = void 0;
          this.selected = false;
          this.series = void 0;
          this.total = void 0;
          this.visible = true;
          this.x = void 0;
        }
        Point2.prototype.animateBeforeDestroy = function() {
          var point = this, animateParams = { x: point.startXPos, opacity: 0 }, graphicalProps = point.getGraphicalProps();
          graphicalProps.singular.forEach(function(prop) {
            var isDataLabel = prop === "dataLabel";
            point[prop] = point[prop].animate(isDataLabel ? {
              x: point[prop].startXPos,
              y: point[prop].startYPos,
              opacity: 0
            } : animateParams);
          });
          graphicalProps.plural.forEach(function(plural) {
            point[plural].forEach(function(item2) {
              if (item2.element) {
                item2.animate(extend$1j({ x: point.startXPos }, item2.startYPos ? {
                  x: item2.startXPos,
                  y: item2.startYPos
                } : {}));
              }
            });
          });
        };
        Point2.prototype.applyOptions = function(options, x) {
          var point = this, series = point.series, pointValKey = series.options.pointValKey || series.pointValKey;
          options = Point2.prototype.optionsToObject.call(this, options);
          extend$1j(point, options);
          point.options = point.options ? extend$1j(point.options, options) : options;
          if (options.group) {
            delete point.group;
          }
          if (options.dataLabels) {
            delete point.dataLabels;
          }
          if (pointValKey) {
            point.y = Point2.prototype.getNestedProperty.call(point, pointValKey);
          }
          point.isNull = pick$1k(point.isValid && !point.isValid(), point.x === null || !isNumber$E(point.y));
          point.formatPrefix = point.isNull ? "null" : "point";
          if (point.selected) {
            point.state = "select";
          }
          if ("name" in point && typeof x === "undefined" && series.xAxis && series.xAxis.hasNames) {
            point.x = series.xAxis.nameToX(point);
          }
          if (typeof point.x === "undefined" && series) {
            if (typeof x === "undefined") {
              point.x = series.autoIncrement();
            } else {
              point.x = x;
            }
          } else if (isNumber$E(options.x) && series.options.relativeXValue) {
            point.x = series.autoIncrement(options.x);
          }
          return point;
        };
        Point2.prototype.destroy = function() {
          var point = this, series = point.series, chart = series.chart, dataSorting = series.options.dataSorting, hoverPoints = chart.hoverPoints, globalAnimation = point.series.chart.renderer.globalAnimation, animation = animObject$9(globalAnimation);
          var prop;
          function destroyPoint() {
            if (point.graphic || point.dataLabel || point.dataLabels) {
              removeEvent$8(point);
              point.destroyElements();
            }
            for (prop in point) {
              point[prop] = null;
            }
          }
          if (point.legendItem) {
            chart.legend.destroyItem(point);
          }
          if (hoverPoints) {
            point.setState();
            erase$4(hoverPoints, point);
            if (!hoverPoints.length) {
              chart.hoverPoints = null;
            }
          }
          if (point === chart.hoverPoint) {
            point.onMouseOut();
          }
          if (!dataSorting || !dataSorting.enabled) {
            destroyPoint();
          } else {
            this.animateBeforeDestroy();
            syncTimeout$5(destroyPoint, animation.duration);
          }
          chart.pointCount--;
        };
        Point2.prototype.destroyElements = function(kinds) {
          var point = this, props = point.getGraphicalProps(kinds);
          props.singular.forEach(function(prop) {
            point[prop] = point[prop].destroy();
          });
          props.plural.forEach(function(plural) {
            point[plural].forEach(function(item2) {
              if (item2.element) {
                item2.destroy();
              }
            });
            delete point[plural];
          });
        };
        Point2.prototype.firePointEvent = function(eventType, eventArgs, defaultFunction) {
          var point = this, series = this.series, seriesOptions = series.options;
          if (seriesOptions.point.events[eventType] || point.options && point.options.events && point.options.events[eventType]) {
            point.importEvents();
          }
          if (eventType === "click" && seriesOptions.allowPointSelect) {
            defaultFunction = function(event) {
              if (point.select) {
                point.select(null, event.ctrlKey || event.metaKey || event.shiftKey);
              }
            };
          }
          fireEvent$v(point, eventType, eventArgs, defaultFunction);
        };
        Point2.prototype.getClassName = function() {
          var point = this;
          return "highcharts-point" + (point.selected ? " highcharts-point-select" : "") + (point.negative ? " highcharts-negative" : "") + (point.isNull ? " highcharts-null-point" : "") + (typeof point.colorIndex !== "undefined" ? " highcharts-color-" + point.colorIndex : "") + (point.options.className ? " " + point.options.className : "") + (point.zone && point.zone.className ? " " + point.zone.className.replace("highcharts-negative", "") : "");
        };
        Point2.prototype.getGraphicalProps = function(kinds) {
          var point = this, props = [], graphicalProps = { singular: [], plural: [] };
          var prop, i2;
          kinds = kinds || { graphic: 1, dataLabel: 1 };
          if (kinds.graphic) {
            props.push("graphic", "upperGraphic", "shadowGroup");
          }
          if (kinds.dataLabel) {
            props.push("dataLabel", "dataLabelUpper", "connector");
          }
          i2 = props.length;
          while (i2--) {
            prop = props[i2];
            if (point[prop]) {
              graphicalProps.singular.push(prop);
            }
          }
          ["dataLabel", "connector"].forEach(function(prop2) {
            var plural = prop2 + "s";
            if (kinds[prop2] && point[plural]) {
              graphicalProps.plural.push(plural);
            }
          });
          return graphicalProps;
        };
        Point2.prototype.getLabelConfig = function() {
          return {
            x: this.category,
            y: this.y,
            color: this.color,
            colorIndex: this.colorIndex,
            key: this.name || this.category,
            series: this.series,
            point: this,
            percentage: this.percentage,
            total: this.total || this.stackTotal
          };
        };
        Point2.prototype.getNestedProperty = function(key) {
          if (!key) {
            return;
          }
          if (key.indexOf("custom.") === 0) {
            return getNestedProperty$1(key, this.options);
          }
          return this[key];
        };
        Point2.prototype.getZone = function() {
          var series = this.series, zones = series.zones, zoneAxis = series.zoneAxis || "y";
          var zone, i2 = 0;
          zone = zones[i2];
          while (this[zoneAxis] >= zone.value) {
            zone = zones[++i2];
          }
          if (!this.nonZonedColor) {
            this.nonZonedColor = this.color;
          }
          if (zone && zone.color && !this.options.color) {
            this.color = zone.color;
          } else {
            this.color = this.nonZonedColor;
          }
          return zone;
        };
        Point2.prototype.hasNewShapeType = function() {
          var point = this;
          var oldShapeType = point.graphic && (point.graphic.symbolName || point.graphic.element.nodeName);
          return oldShapeType !== this.shapeType;
        };
        Point2.prototype.init = function(series, options, x) {
          this.series = series;
          this.applyOptions(options, x);
          this.id = defined$K(this.id) ? this.id : uniqueKey$5();
          this.resolveColor();
          series.chart.pointCount++;
          fireEvent$v(this, "afterInit");
          return this;
        };
        Point2.prototype.optionsToObject = function(options) {
          var series = this.series, keys2 = series.options.keys, pointArrayMap = keys2 || series.pointArrayMap || ["y"], valueCount = pointArrayMap.length;
          var ret = {}, firstItemType, i2 = 0, j = 0;
          if (isNumber$E(options) || options === null) {
            ret[pointArrayMap[0]] = options;
          } else if (isArray$h(options)) {
            if (!keys2 && options.length > valueCount) {
              firstItemType = typeof options[0];
              if (firstItemType === "string") {
                ret.name = options[0];
              } else if (firstItemType === "number") {
                ret.x = options[0];
              }
              i2++;
            }
            while (j < valueCount) {
              if (!keys2 || typeof options[i2] !== "undefined") {
                if (pointArrayMap[j].indexOf(".") > 0) {
                  Point2.prototype.setNestedProperty(ret, options[i2], pointArrayMap[j]);
                } else {
                  ret[pointArrayMap[j]] = options[i2];
                }
              }
              i2++;
              j++;
            }
          } else if (typeof options === "object") {
            ret = options;
            if (options.dataLabels) {
              series._hasPointLabels = true;
            }
            if (options.marker) {
              series._hasPointMarkers = true;
            }
          }
          return ret;
        };
        Point2.prototype.resolveColor = function() {
          var series = this.series, optionsChart = series.chart.options.chart, styledMode = series.chart.styledMode;
          var color2, colors, colorCount = optionsChart.colorCount, colorIndex;
          delete this.nonZonedColor;
          if (series.options.colorByPoint) {
            if (!styledMode) {
              colors = series.options.colors || series.chart.options.colors;
              color2 = colors[series.colorCounter];
              colorCount = colors.length;
            }
            colorIndex = series.colorCounter;
            series.colorCounter++;
            if (series.colorCounter === colorCount) {
              series.colorCounter = 0;
            }
          } else {
            if (!styledMode) {
              color2 = series.color;
            }
            colorIndex = series.colorIndex;
          }
          this.colorIndex = pick$1k(this.options.colorIndex, colorIndex);
          this.color = pick$1k(this.options.color, color2);
        };
        Point2.prototype.setNestedProperty = function(object, value, key) {
          var nestedKeys = key.split(".");
          nestedKeys.reduce(function(result2, key2, i2, arr) {
            var isLastKey = arr.length - 1 === i2;
            result2[key2] = isLastKey ? value : isObject$b(result2[key2], true) ? result2[key2] : {};
            return result2[key2];
          }, object);
          return object;
        };
        Point2.prototype.tooltipFormatter = function(pointFormat) {
          var series = this.series, seriesTooltipOptions = series.tooltipOptions, valueDecimals = pick$1k(seriesTooltipOptions.valueDecimals, ""), valuePrefix = seriesTooltipOptions.valuePrefix || "", valueSuffix = seriesTooltipOptions.valueSuffix || "";
          if (series.chart.styledMode) {
            pointFormat = series.chart.tooltip.styledModeFormat(pointFormat);
          }
          (series.pointArrayMap || ["y"]).forEach(function(key) {
            key = "{point." + key;
            if (valuePrefix || valueSuffix) {
              pointFormat = pointFormat.replace(RegExp(key + "}", "g"), valuePrefix + key + "}" + valueSuffix);
            }
            pointFormat = pointFormat.replace(RegExp(key + "}", "g"), key + ":,." + valueDecimals + "f}");
          });
          return format$c(pointFormat, {
            point: this,
            series: this.series
          }, series.chart);
        };
        Point2.prototype.update = function(options, redraw, animation, runEvent) {
          var point = this, series = point.series, graphic = point.graphic, chart = series.chart, seriesOptions = series.options;
          var i2;
          redraw = pick$1k(redraw, true);
          function update() {
            point.applyOptions(options);
            var hasDummyGraphic = graphic && point.hasDummyGraphic;
            var shouldDestroyGraphic = point.y === null ? !hasDummyGraphic : hasDummyGraphic;
            if (graphic && shouldDestroyGraphic) {
              point.graphic = graphic.destroy();
              delete point.hasDummyGraphic;
            }
            if (isObject$b(options, true)) {
              if (graphic && graphic.element) {
                if (options && options.marker && typeof options.marker.symbol !== "undefined") {
                  point.graphic = graphic.destroy();
                }
              }
              if (options && options.dataLabels && point.dataLabel) {
                point.dataLabel = point.dataLabel.destroy();
              }
              if (point.connector) {
                point.connector = point.connector.destroy();
              }
            }
            i2 = point.index;
            series.updateParallelArrays(point, i2);
            seriesOptions.data[i2] = isObject$b(seriesOptions.data[i2], true) || isObject$b(options, true) ? point.options : pick$1k(options, seriesOptions.data[i2]);
            series.isDirty = series.isDirtyData = true;
            if (!series.fixedBox && series.hasCartesianSeries) {
              chart.isDirtyBox = true;
            }
            if (seriesOptions.legendType === "point") {
              chart.isDirtyLegend = true;
            }
            if (redraw) {
              chart.redraw(animation);
            }
          }
          if (runEvent === false) {
            update();
          } else {
            point.firePointEvent("update", { options }, update);
          }
        };
        Point2.prototype.remove = function(redraw, animation) {
          this.series.removePoint(this.series.data.indexOf(this), redraw, animation);
        };
        Point2.prototype.select = function(selected, accumulate) {
          var point = this, series = point.series, chart = series.chart;
          selected = pick$1k(selected, !point.selected);
          this.selectedStaging = selected;
          point.firePointEvent(selected ? "select" : "unselect", { accumulate }, function() {
            point.selected = point.options.selected = selected;
            series.options.data[series.data.indexOf(point)] = point.options;
            point.setState(selected && "select");
            if (!accumulate) {
              chart.getSelectedPoints().forEach(function(loopPoint) {
                var loopSeries = loopPoint.series;
                if (loopPoint.selected && loopPoint !== point) {
                  loopPoint.selected = loopPoint.options.selected = false;
                  loopSeries.options.data[loopSeries.data.indexOf(loopPoint)] = loopPoint.options;
                  loopPoint.setState(chart.hoverPoints && loopSeries.options.inactiveOtherPoints ? "inactive" : "");
                  loopPoint.firePointEvent("unselect");
                }
              });
            }
          });
          delete this.selectedStaging;
        };
        Point2.prototype.onMouseOver = function(e2) {
          var point = this, series = point.series, chart = series.chart, pointer = chart.pointer;
          e2 = e2 ? pointer.normalize(e2) : (
            // In cases where onMouseOver is called directly without an event
            pointer.getChartCoordinatesFromPoint(point, chart.inverted)
          );
          pointer.runPointActions(e2, point);
        };
        Point2.prototype.onMouseOut = function() {
          var point = this, chart = point.series.chart;
          point.firePointEvent("mouseOut");
          if (!point.series.options.inactiveOtherPoints) {
            (chart.hoverPoints || []).forEach(function(p5) {
              p5.setState();
            });
          }
          chart.hoverPoints = chart.hoverPoint = null;
        };
        Point2.prototype.importEvents = function() {
          if (!this.hasImportedEvents) {
            var point_1 = this, options = merge$1d(point_1.series.options.point, point_1.options), events = options.events;
            point_1.events = events;
            objectEach$q(events, function(event, eventType) {
              if (isFunction$2(event)) {
                addEvent$X(point_1, eventType, event);
              }
            });
            this.hasImportedEvents = true;
          }
        };
        Point2.prototype.setState = function(state, move) {
          var point = this, series = point.series, previousState = point.state, stateOptions = series.options.states[state || "normal"] || {}, markerOptions = defaultOptions$d.plotOptions[series.type].marker && series.options.marker, normalDisabled = markerOptions && markerOptions.enabled === false, markerStateOptions = markerOptions && markerOptions.states && markerOptions.states[state || "normal"] || {}, stateDisabled = markerStateOptions.enabled === false, pointMarker = point.marker || {}, chart = series.chart, hasMarkers = markerOptions && series.markerAttribs;
          var halo = series.halo, markerAttribs, pointAttribs2, pointAttribsAnimation, stateMarkerGraphic = series.stateMarkerGraphic, newSymbol;
          state = state || "";
          if (
            // already has this state
            state === point.state && !move || // selected points don't respond to hover
            point.selected && state !== "select" || // series' state options is disabled
            stateOptions.enabled === false || // general point marker's state options is disabled
            state && (stateDisabled || normalDisabled && markerStateOptions.enabled === false) || // individual point marker's state options is disabled
            state && pointMarker.states && pointMarker.states[state] && pointMarker.states[state].enabled === false
          ) {
            return;
          }
          point.state = state;
          if (hasMarkers) {
            markerAttribs = series.markerAttribs(point, state);
          }
          if (point.graphic && !point.hasDummyGraphic) {
            if (previousState) {
              point.graphic.removeClass("highcharts-point-" + previousState);
            }
            if (state) {
              point.graphic.addClass("highcharts-point-" + state);
            }
            if (!chart.styledMode) {
              pointAttribs2 = series.pointAttribs(point, state);
              pointAttribsAnimation = pick$1k(chart.options.chart.animation, stateOptions.animation);
              if (series.options.inactiveOtherPoints && isNumber$E(pointAttribs2.opacity)) {
                (point.dataLabels || []).forEach(function(label) {
                  if (label) {
                    label.animate({
                      opacity: pointAttribs2.opacity
                    }, pointAttribsAnimation);
                  }
                });
                if (point.connector) {
                  point.connector.animate({
                    opacity: pointAttribs2.opacity
                  }, pointAttribsAnimation);
                }
              }
              point.graphic.animate(pointAttribs2, pointAttribsAnimation);
            }
            if (markerAttribs) {
              point.graphic.animate(markerAttribs, pick$1k(
                // Turn off globally:
                chart.options.chart.animation,
                markerStateOptions.animation,
                markerOptions.animation
              ));
            }
            if (stateMarkerGraphic) {
              stateMarkerGraphic.hide();
            }
          } else {
            if (state && markerStateOptions) {
              newSymbol = pointMarker.symbol || series.symbol;
              if (stateMarkerGraphic && stateMarkerGraphic.currentSymbol !== newSymbol) {
                stateMarkerGraphic = stateMarkerGraphic.destroy();
              }
              if (markerAttribs) {
                if (!stateMarkerGraphic) {
                  if (newSymbol) {
                    series.stateMarkerGraphic = stateMarkerGraphic = chart.renderer.symbol(newSymbol, markerAttribs.x, markerAttribs.y, markerAttribs.width, markerAttribs.height).add(series.markerGroup);
                    stateMarkerGraphic.currentSymbol = newSymbol;
                  }
                } else {
                  stateMarkerGraphic[move ? "animate" : "attr"]({
                    x: markerAttribs.x,
                    y: markerAttribs.y
                  });
                }
              }
              if (!chart.styledMode && stateMarkerGraphic) {
                stateMarkerGraphic.attr(series.pointAttribs(point, state));
              }
            }
            if (stateMarkerGraphic) {
              stateMarkerGraphic[state && point.isInside ? "show" : "hide"]();
              stateMarkerGraphic.element.point = point;
              stateMarkerGraphic.addClass(point.getClassName(), true);
            }
          }
          var haloOptions = stateOptions.halo;
          var markerGraphic = point.graphic || stateMarkerGraphic;
          var markerVisibility = markerGraphic && markerGraphic.visibility || "inherit";
          if (haloOptions && haloOptions.size && markerGraphic && markerVisibility !== "hidden" && !point.isCluster) {
            if (!halo) {
              series.halo = halo = chart.renderer.path().add(markerGraphic.parentGroup);
            }
            halo.show()[move ? "animate" : "attr"]({
              d: point.haloPath(haloOptions.size)
            });
            halo.attr({
              "class": "highcharts-halo highcharts-color-" + pick$1k(point.colorIndex, series.colorIndex) + (point.className ? " " + point.className : ""),
              "visibility": markerVisibility,
              "zIndex": -1
              // #4929, #8276
            });
            halo.point = point;
            if (!chart.styledMode) {
              halo.attr(extend$1j({
                "fill": point.color || series.color,
                "fill-opacity": haloOptions.opacity
              }, AST.filterUserAttributes(haloOptions.attributes || {})));
            }
          } else if (halo && halo.point && halo.point.haloPath) {
            halo.animate(
              { d: halo.point.haloPath(0) },
              null,
              // Hide after unhovering. The `complete` callback runs in the
              // halo's context (#7681).
              halo.hide
            );
          }
          fireEvent$v(point, "afterSetState", { state });
        };
        Point2.prototype.haloPath = function(size) {
          var series = this.series, chart = series.chart;
          return chart.renderer.symbols.circle(Math.floor(this.plotX) - size, this.plotY - size, size * 2, size * 2);
        };
        return Point2;
      }()
    );
    var color$e = Color.parse;
    var charts$3 = H.charts, noop$j = H.noop;
    var addEvent$W = Utilities.addEvent, attr$2 = Utilities.attr, css$8 = Utilities.css, defined$J = Utilities.defined, extend$1i = Utilities.extend, find$i = Utilities.find, fireEvent$u = Utilities.fireEvent, isNumber$D = Utilities.isNumber, isObject$a = Utilities.isObject, objectEach$p = Utilities.objectEach, offset = Utilities.offset, pick$1j = Utilities.pick, splat$e = Utilities.splat;
    var Pointer = (
      /** @class */
      function() {
        function Pointer2(chart, options) {
          this.lastValidTouch = {};
          this.pinchDown = [];
          this.runChartClick = false;
          this.eventsToUnbind = [];
          this.chart = chart;
          this.hasDragged = false;
          this.options = options;
          this.init(chart, options);
        }
        Pointer2.prototype.applyInactiveState = function(points) {
          var activeSeries = [], series;
          (points || []).forEach(function(item2) {
            series = item2.series;
            activeSeries.push(series);
            if (series.linkedParent) {
              activeSeries.push(series.linkedParent);
            }
            if (series.linkedSeries) {
              activeSeries = activeSeries.concat(series.linkedSeries);
            }
            if (series.navigatorSeries) {
              activeSeries.push(series.navigatorSeries);
            }
          });
          this.chart.series.forEach(function(inactiveSeries) {
            if (activeSeries.indexOf(inactiveSeries) === -1) {
              inactiveSeries.setState("inactive", true);
            } else if (inactiveSeries.options.inactiveOtherPoints) {
              inactiveSeries.setAllPointsToState("inactive");
            }
          });
        };
        Pointer2.prototype.destroy = function() {
          var pointer = this;
          this.eventsToUnbind.forEach(function(unbind) {
            return unbind();
          });
          this.eventsToUnbind = [];
          if (!H.chartCount) {
            if (Pointer2.unbindDocumentMouseUp) {
              Pointer2.unbindDocumentMouseUp = Pointer2.unbindDocumentMouseUp();
            }
            if (Pointer2.unbindDocumentTouchEnd) {
              Pointer2.unbindDocumentTouchEnd = Pointer2.unbindDocumentTouchEnd();
            }
          }
          clearInterval(pointer.tooltipTimeout);
          objectEach$p(pointer, function(_val, prop) {
            pointer[prop] = void 0;
          });
        };
        Pointer2.prototype.drag = function(e2) {
          var chart = this.chart, chartOptions = chart.options.chart, zoomHor = this.zoomHor, zoomVert = this.zoomVert, plotLeft = chart.plotLeft, plotTop = chart.plotTop, plotWidth = chart.plotWidth, plotHeight = chart.plotHeight, mouseDownX = this.mouseDownX || 0, mouseDownY = this.mouseDownY || 0, panningEnabled = isObject$a(chartOptions.panning) ? chartOptions.panning && chartOptions.panning.enabled : chartOptions.panning, panKey = chartOptions.panKey && e2[chartOptions.panKey + "Key"];
          var chartX = e2.chartX, chartY = e2.chartY, clickedInside, size, selectionMarker = this.selectionMarker;
          if (selectionMarker && selectionMarker.touch) {
            return;
          }
          if (chartX < plotLeft) {
            chartX = plotLeft;
          } else if (chartX > plotLeft + plotWidth) {
            chartX = plotLeft + plotWidth;
          }
          if (chartY < plotTop) {
            chartY = plotTop;
          } else if (chartY > plotTop + plotHeight) {
            chartY = plotTop + plotHeight;
          }
          this.hasDragged = Math.sqrt(Math.pow(mouseDownX - chartX, 2) + Math.pow(mouseDownY - chartY, 2));
          if (this.hasDragged > 10) {
            clickedInside = chart.isInsidePlot(mouseDownX - plotLeft, mouseDownY - plotTop, {
              visiblePlotOnly: true
            });
            if (chart.hasCartesianSeries && (this.zoomX || this.zoomY) && clickedInside && !panKey) {
              if (!selectionMarker) {
                this.selectionMarker = selectionMarker = chart.renderer.rect(plotLeft, plotTop, zoomHor ? 1 : plotWidth, zoomVert ? 1 : plotHeight, 0).attr({
                  "class": "highcharts-selection-marker",
                  zIndex: 7
                }).add();
                if (!chart.styledMode) {
                  selectionMarker.attr({
                    fill: chartOptions.selectionMarkerFill || color$e(palette.highlightColor80).setOpacity(0.25).get()
                  });
                }
              }
            }
            if (selectionMarker && zoomHor) {
              size = chartX - mouseDownX;
              selectionMarker.attr({
                width: Math.abs(size),
                x: (size > 0 ? 0 : size) + mouseDownX
              });
            }
            if (selectionMarker && zoomVert) {
              size = chartY - mouseDownY;
              selectionMarker.attr({
                height: Math.abs(size),
                y: (size > 0 ? 0 : size) + mouseDownY
              });
            }
            if (clickedInside && !selectionMarker && panningEnabled) {
              chart.pan(e2, chartOptions.panning);
            }
          }
        };
        Pointer2.prototype.dragStart = function(e2) {
          var chart = this.chart;
          chart.mouseIsDown = e2.type;
          chart.cancelClick = false;
          chart.mouseDownX = this.mouseDownX = e2.chartX;
          chart.mouseDownY = this.mouseDownY = e2.chartY;
        };
        Pointer2.prototype.drop = function(e2) {
          var pointer = this, chart = this.chart, hasPinched = this.hasPinched;
          if (this.selectionMarker) {
            var selectionData_1 = {
              originalEvent: e2,
              xAxis: [],
              yAxis: []
            }, selectionBox = this.selectionMarker, selectionLeft_1 = selectionBox.attr ? selectionBox.attr("x") : selectionBox.x, selectionTop_1 = selectionBox.attr ? selectionBox.attr("y") : selectionBox.y, selectionWidth_1 = selectionBox.attr ? selectionBox.attr("width") : selectionBox.width, selectionHeight_1 = selectionBox.attr ? selectionBox.attr("height") : selectionBox.height;
            var runZoom_1;
            if (this.hasDragged || hasPinched) {
              chart.axes.forEach(function(axis) {
                if (axis.zoomEnabled && defined$J(axis.min) && (hasPinched || pointer[{
                  xAxis: "zoomX",
                  yAxis: "zoomY"
                }[axis.coll]]) && isNumber$D(selectionLeft_1) && isNumber$D(selectionTop_1)) {
                  var horiz = axis.horiz, minPixelPadding = e2.type === "touchend" ? axis.minPixelPadding : 0, selectionMin = axis.toValue((horiz ? selectionLeft_1 : selectionTop_1) + minPixelPadding), selectionMax = axis.toValue((horiz ? selectionLeft_1 + selectionWidth_1 : selectionTop_1 + selectionHeight_1) - minPixelPadding);
                  selectionData_1[axis.coll].push({
                    axis,
                    // Min/max for reversed axes
                    min: Math.min(selectionMin, selectionMax),
                    max: Math.max(selectionMin, selectionMax)
                  });
                  runZoom_1 = true;
                }
              });
              if (runZoom_1) {
                fireEvent$u(chart, "selection", selectionData_1, function(args) {
                  chart.zoom(extend$1i(args, hasPinched ? { animation: false } : null));
                });
              }
            }
            if (isNumber$D(chart.index)) {
              this.selectionMarker = this.selectionMarker.destroy();
            }
            if (hasPinched) {
              this.scaleGroups();
            }
          }
          if (chart && isNumber$D(chart.index)) {
            css$8(chart.container, { cursor: chart._cursor });
            chart.cancelClick = this.hasDragged > 10;
            chart.mouseIsDown = this.hasDragged = this.hasPinched = false;
            this.pinchDown = [];
          }
        };
        Pointer2.prototype.findNearestKDPoint = function(series, shared2, e2) {
          var chart = this.chart;
          var hoverPoint = chart.hoverPoint;
          var tooltip = chart.tooltip;
          if (hoverPoint && tooltip && tooltip.isStickyOnContact()) {
            return hoverPoint;
          }
          var closest;
          function sort(p12, p22) {
            var isCloserX = p12.distX - p22.distX, isCloser = p12.dist - p22.dist, isAbove = (p22.series.group && p22.series.group.zIndex) - (p12.series.group && p12.series.group.zIndex);
            var result2;
            if (isCloserX !== 0 && shared2) {
              result2 = isCloserX;
            } else if (isCloser !== 0) {
              result2 = isCloser;
            } else if (isAbove !== 0) {
              result2 = isAbove;
            } else {
              result2 = p12.series.index > p22.series.index ? -1 : 1;
            }
            return result2;
          }
          series.forEach(function(s2) {
            var noSharedTooltip = s2.noSharedTooltip && shared2, compareX = !noSharedTooltip && s2.options.findNearestPointBy.indexOf("y") < 0, point = s2.searchPoint(e2, compareX);
            if (
              // Check that we actually found a point on the series.
              isObject$a(point, true) && point.series && // Use the new point if it is closer.
              (!isObject$a(closest, true) || sort(closest, point) > 0)
            ) {
              closest = point;
            }
          });
          return closest;
        };
        Pointer2.prototype.getChartCoordinatesFromPoint = function(point, inverted) {
          var series = point.series, xAxis = series.xAxis, yAxis = series.yAxis, shapeArgs = point.shapeArgs;
          if (xAxis && yAxis) {
            var x = pick$1j(point.clientX, point.plotX);
            var y = point.plotY || 0;
            if (point.isNode && shapeArgs && isNumber$D(shapeArgs.x) && isNumber$D(shapeArgs.y)) {
              x = shapeArgs.x;
              y = shapeArgs.y;
            }
            return inverted ? {
              chartX: yAxis.len + yAxis.pos - y,
              chartY: xAxis.len + xAxis.pos - x
            } : {
              chartX: x + xAxis.pos,
              chartY: y + yAxis.pos
            };
          }
          if (shapeArgs && shapeArgs.x && shapeArgs.y) {
            return {
              chartX: shapeArgs.x,
              chartY: shapeArgs.y
            };
          }
        };
        Pointer2.prototype.getChartPosition = function() {
          if (this.chartPosition) {
            return this.chartPosition;
          }
          var container = this.chart.container;
          var pos = offset(container);
          this.chartPosition = {
            left: pos.left,
            top: pos.top,
            scaleX: 1,
            scaleY: 1
          };
          var offsetWidth = container.offsetWidth;
          var offsetHeight = container.offsetHeight;
          if (offsetWidth > 2 && // #13342
          offsetHeight > 2) {
            this.chartPosition.scaleX = pos.width / offsetWidth;
            this.chartPosition.scaleY = pos.height / offsetHeight;
          }
          return this.chartPosition;
        };
        Pointer2.prototype.getCoordinates = function(e2) {
          var coordinates2 = {
            xAxis: [],
            yAxis: []
          };
          this.chart.axes.forEach(function(axis) {
            coordinates2[axis.isXAxis ? "xAxis" : "yAxis"].push({
              axis,
              value: axis.toValue(e2[axis.horiz ? "chartX" : "chartY"])
            });
          });
          return coordinates2;
        };
        Pointer2.prototype.getHoverData = function(existingHoverPoint, existingHoverSeries, series, isDirectTouch, shared2, e2) {
          var hoverPoints = [], useExisting = !!(isDirectTouch && existingHoverPoint), filter = function(s2) {
            return s2.visible && !(!shared2 && s2.directTouch) && // #3821
            pick$1j(s2.options.enableMouseTracking, true);
          };
          var hoverSeries = existingHoverSeries, searchSeries, eventArgs = {
            chartX: e2 ? e2.chartX : void 0,
            chartY: e2 ? e2.chartY : void 0,
            shared: shared2
          };
          fireEvent$u(this, "beforeGetHoverData", eventArgs);
          var notSticky = hoverSeries && !hoverSeries.stickyTracking;
          searchSeries = notSticky ? (
            // Only search on hovered series if it has stickyTracking false
            [hoverSeries]
          ) : (
            // Filter what series to look in.
            series.filter(function(s2) {
              return eventArgs.filter ? eventArgs.filter(s2) : filter(s2) && s2.stickyTracking;
            })
          );
          var hoverPoint = useExisting || !e2 ? existingHoverPoint : this.findNearestKDPoint(searchSeries, shared2, e2);
          hoverSeries = hoverPoint && hoverPoint.series;
          if (hoverPoint) {
            if (shared2 && !hoverSeries.noSharedTooltip) {
              searchSeries = series.filter(function(s2) {
                return eventArgs.filter ? eventArgs.filter(s2) : filter(s2) && !s2.noSharedTooltip;
              });
              searchSeries.forEach(function(s2) {
                var point = find$i(s2.points, function(p5) {
                  return p5.x === hoverPoint.x && !p5.isNull;
                });
                if (isObject$a(point)) {
                  if (s2.chart.isBoosting) {
                    point = s2.getPoint(point);
                  }
                  hoverPoints.push(point);
                }
              });
            } else {
              hoverPoints.push(hoverPoint);
            }
          }
          eventArgs = { hoverPoint };
          fireEvent$u(this, "afterGetHoverData", eventArgs);
          return {
            hoverPoint: eventArgs.hoverPoint,
            hoverSeries,
            hoverPoints
          };
        };
        Pointer2.prototype.getPointFromEvent = function(e2) {
          var target = e2.target, point;
          while (target && !point) {
            point = target.point;
            target = target.parentNode;
          }
          return point;
        };
        Pointer2.prototype.onTrackerMouseOut = function(e2) {
          var chart = this.chart;
          var relatedTarget = e2.relatedTarget || e2.toElement;
          var series = chart.hoverSeries;
          this.isDirectTouch = false;
          if (series && relatedTarget && !series.stickyTracking && !this.inClass(relatedTarget, "highcharts-tooltip") && (!this.inClass(relatedTarget, "highcharts-series-" + series.index) || // #2499, #4465, #5553
          !this.inClass(relatedTarget, "highcharts-tracker"))) {
            series.onMouseOut();
          }
        };
        Pointer2.prototype.inClass = function(element, className) {
          var elemClassName;
          while (element) {
            elemClassName = attr$2(element, "class");
            if (elemClassName) {
              if (elemClassName.indexOf(className) !== -1) {
                return true;
              }
              if (elemClassName.indexOf("highcharts-container") !== -1) {
                return false;
              }
            }
            element = element.parentNode;
          }
        };
        Pointer2.prototype.init = function(chart, options) {
          this.options = options;
          this.chart = chart;
          this.runChartClick = Boolean(options.chart.events && options.chart.events.click);
          this.pinchDown = [];
          this.lastValidTouch = {};
          if (Tooltip) {
            chart.tooltip = new Tooltip(chart, options.tooltip);
            this.followTouchMove = pick$1j(options.tooltip.followTouchMove, true);
          }
          this.setDOMEvents();
        };
        Pointer2.prototype.normalize = function(e2, chartPosition) {
          var touches2 = e2.touches;
          var ePos = touches2 ? touches2.length ? touches2.item(0) : pick$1j(
            // #13534
            touches2.changedTouches,
            e2.changedTouches
          )[0] : e2;
          if (!chartPosition) {
            chartPosition = this.getChartPosition();
          }
          var chartX = ePos.pageX - chartPosition.left, chartY = ePos.pageY - chartPosition.top;
          chartX /= chartPosition.scaleX;
          chartY /= chartPosition.scaleY;
          return extend$1i(e2, {
            chartX: Math.round(chartX),
            chartY: Math.round(chartY)
          });
        };
        Pointer2.prototype.onContainerClick = function(e2) {
          var chart = this.chart;
          var hoverPoint = chart.hoverPoint;
          var pEvt = this.normalize(e2);
          var plotLeft = chart.plotLeft;
          var plotTop = chart.plotTop;
          if (!chart.cancelClick) {
            if (hoverPoint && this.inClass(pEvt.target, "highcharts-tracker")) {
              fireEvent$u(hoverPoint.series, "click", extend$1i(pEvt, {
                point: hoverPoint
              }));
              if (chart.hoverPoint) {
                hoverPoint.firePointEvent("click", pEvt);
              }
            } else {
              extend$1i(pEvt, this.getCoordinates(pEvt));
              if (chart.isInsidePlot(pEvt.chartX - plotLeft, pEvt.chartY - plotTop, {
                visiblePlotOnly: true
              })) {
                fireEvent$u(chart, "click", pEvt);
              }
            }
          }
        };
        Pointer2.prototype.onContainerMouseDown = function(e2) {
          var isPrimaryButton = ((e2.buttons || e2.button) & 1) === 1;
          e2 = this.normalize(e2);
          if (H.isFirefox && e2.button !== 0) {
            this.onContainerMouseMove(e2);
          }
          if (typeof e2.button === "undefined" || isPrimaryButton) {
            this.zoomOption(e2);
            if (isPrimaryButton && e2.preventDefault) {
              e2.preventDefault();
            }
            this.dragStart(e2);
          }
        };
        Pointer2.prototype.onContainerMouseLeave = function(e2) {
          var chart = charts$3[pick$1j(Pointer2.hoverChartIndex, -1)];
          var tooltip = this.chart.tooltip;
          if (tooltip && tooltip.shouldStickOnContact() && this.inClass(e2.relatedTarget, "highcharts-tooltip-container")) {
            return;
          }
          e2 = this.normalize(e2);
          if (chart && (e2.relatedTarget || e2.toElement)) {
            chart.pointer.reset();
            chart.pointer.chartPosition = void 0;
          }
          if (
            // #11635, Firefox wheel scroll does not fire out events consistently
            tooltip && !tooltip.isHidden
          ) {
            this.reset();
          }
        };
        Pointer2.prototype.onContainerMouseEnter = function(e2) {
          delete this.chartPosition;
        };
        Pointer2.prototype.onContainerMouseMove = function(e2) {
          var chart = this.chart;
          var pEvt = this.normalize(e2);
          this.setHoverChartIndex();
          if (!pEvt.preventDefault) {
            pEvt.returnValue = false;
          }
          if (chart.mouseIsDown === "mousedown" || this.touchSelect(pEvt)) {
            this.drag(pEvt);
          }
          if (!chart.openMenu && (this.inClass(pEvt.target, "highcharts-tracker") || chart.isInsidePlot(pEvt.chartX - chart.plotLeft, pEvt.chartY - chart.plotTop, {
            visiblePlotOnly: true
          }))) {
            if (this.inClass(pEvt.target, "highcharts-no-tooltip")) {
              this.reset(false, 0);
            } else {
              this.runPointActions(pEvt);
            }
          }
        };
        Pointer2.prototype.onDocumentTouchEnd = function(e2) {
          var hoverChart = charts$3[pick$1j(Pointer2.hoverChartIndex, -1)];
          if (hoverChart) {
            hoverChart.pointer.drop(e2);
          }
        };
        Pointer2.prototype.onContainerTouchMove = function(e2) {
          if (this.touchSelect(e2)) {
            this.onContainerMouseMove(e2);
          } else {
            this.touch(e2);
          }
        };
        Pointer2.prototype.onContainerTouchStart = function(e2) {
          if (this.touchSelect(e2)) {
            this.onContainerMouseDown(e2);
          } else {
            this.zoomOption(e2);
            this.touch(e2, true);
          }
        };
        Pointer2.prototype.onDocumentMouseMove = function(e2) {
          var chart = this.chart;
          var chartPosition = this.chartPosition;
          var pEvt = this.normalize(e2, chartPosition);
          var tooltip = chart.tooltip;
          if (chartPosition && (!tooltip || !tooltip.isStickyOnContact()) && !chart.isInsidePlot(pEvt.chartX - chart.plotLeft, pEvt.chartY - chart.plotTop, {
            visiblePlotOnly: true
          }) && !this.inClass(pEvt.target, "highcharts-tracker")) {
            this.reset();
          }
        };
        Pointer2.prototype.onDocumentMouseUp = function(e2) {
          var chart = charts$3[pick$1j(Pointer2.hoverChartIndex, -1)];
          if (chart) {
            chart.pointer.drop(e2);
          }
        };
        Pointer2.prototype.pinch = function(e2) {
          var self2 = this, chart = self2.chart, pinchDown = self2.pinchDown, touches2 = e2.touches || [], touchesLength = touches2.length, lastValidTouch = self2.lastValidTouch, hasZoom = self2.hasZoom, transform2 = {}, fireClickEvent = touchesLength === 1 && (self2.inClass(e2.target, "highcharts-tracker") && chart.runTrackerClick || self2.runChartClick), clip = {};
          var selectionMarker = self2.selectionMarker;
          if (touchesLength > 1) {
            self2.initiated = true;
          } else if (touchesLength === 1 && this.followTouchMove) {
            self2.initiated = false;
          }
          if (hasZoom && self2.initiated && !fireClickEvent && e2.cancelable !== false) {
            e2.preventDefault();
          }
          [].map.call(touches2, function(e3) {
            return self2.normalize(e3);
          });
          if (e2.type === "touchstart") {
            [].forEach.call(touches2, function(e3, i2) {
              pinchDown[i2] = { chartX: e3.chartX, chartY: e3.chartY };
            });
            lastValidTouch.x = [pinchDown[0].chartX, pinchDown[1] && pinchDown[1].chartX];
            lastValidTouch.y = [pinchDown[0].chartY, pinchDown[1] && pinchDown[1].chartY];
            chart.axes.forEach(function(axis) {
              if (axis.zoomEnabled) {
                var bounds = chart.bounds[axis.horiz ? "h" : "v"], minPixelPadding = axis.minPixelPadding, min = axis.toPixels(Math.min(pick$1j(axis.options.min, axis.dataMin), axis.dataMin)), max = axis.toPixels(Math.max(pick$1j(axis.options.max, axis.dataMax), axis.dataMax)), absMin = Math.min(min, max), absMax = Math.max(min, max);
                bounds.min = Math.min(axis.pos, absMin - minPixelPadding);
                bounds.max = Math.max(axis.pos + axis.len, absMax + minPixelPadding);
              }
            });
            self2.res = true;
          } else if (self2.followTouchMove && touchesLength === 1) {
            this.runPointActions(self2.normalize(e2));
          } else if (pinchDown.length) {
            if (!selectionMarker) {
              self2.selectionMarker = selectionMarker = extend$1i({
                destroy: noop$j,
                touch: true
              }, chart.plotBox);
            }
            self2.pinchTranslate(pinchDown, touches2, transform2, selectionMarker, clip, lastValidTouch);
            self2.hasPinched = hasZoom;
            self2.scaleGroups(transform2, clip);
            if (self2.res) {
              self2.res = false;
              this.reset(false, 0);
            }
          }
        };
        Pointer2.prototype.pinchTranslate = function(pinchDown, touches2, transform2, selectionMarker, clip, lastValidTouch) {
          if (this.zoomHor) {
            this.pinchTranslateDirection(true, pinchDown, touches2, transform2, selectionMarker, clip, lastValidTouch);
          }
          if (this.zoomVert) {
            this.pinchTranslateDirection(false, pinchDown, touches2, transform2, selectionMarker, clip, lastValidTouch);
          }
        };
        Pointer2.prototype.pinchTranslateDirection = function(horiz, pinchDown, touches2, transform2, selectionMarker, clip, lastValidTouch, forcedScale) {
          var chart = this.chart, xy = horiz ? "x" : "y", XY = horiz ? "X" : "Y", sChartXY = "chart" + XY, wh = horiz ? "width" : "height", plotLeftTop = chart["plot" + (horiz ? "Left" : "Top")], inverted = chart.inverted, bounds = chart.bounds[horiz ? "h" : "v"], singleTouch = pinchDown.length === 1, touch0Start = pinchDown[0][sChartXY], touch1Start = !singleTouch && pinchDown[1][sChartXY], setScale = function() {
            if (typeof touch1Now === "number" && Math.abs(touch0Start - touch1Start) > 20) {
              scale2 = forcedScale || Math.abs(touch0Now - touch1Now) / Math.abs(touch0Start - touch1Start);
            }
            clipXY = (plotLeftTop - touch0Now) / scale2 + touch0Start;
            selectionWH = chart["plot" + (horiz ? "Width" : "Height")] / scale2;
          };
          var selectionWH, selectionXY, clipXY, scale2 = forcedScale || 1, touch0Now = touches2[0][sChartXY], touch1Now = !singleTouch && touches2[1][sChartXY], outOfBounds;
          setScale();
          selectionXY = clipXY;
          if (selectionXY < bounds.min) {
            selectionXY = bounds.min;
            outOfBounds = true;
          } else if (selectionXY + selectionWH > bounds.max) {
            selectionXY = bounds.max - selectionWH;
            outOfBounds = true;
          }
          if (outOfBounds) {
            touch0Now -= 0.8 * (touch0Now - lastValidTouch[xy][0]);
            if (typeof touch1Now === "number") {
              touch1Now -= 0.8 * (touch1Now - lastValidTouch[xy][1]);
            }
            setScale();
          } else {
            lastValidTouch[xy] = [touch0Now, touch1Now];
          }
          if (!inverted) {
            clip[xy] = clipXY - plotLeftTop;
            clip[wh] = selectionWH;
          }
          var scaleKey = inverted ? horiz ? "scaleY" : "scaleX" : "scale" + XY;
          var transformScale = inverted ? 1 / scale2 : scale2;
          selectionMarker[wh] = selectionWH;
          selectionMarker[xy] = selectionXY;
          transform2[scaleKey] = scale2;
          transform2["translate" + XY] = transformScale * plotLeftTop + (touch0Now - transformScale * touch0Start);
        };
        Pointer2.prototype.reset = function(allowMove, delay) {
          var pointer = this, chart = pointer.chart, hoverSeries = chart.hoverSeries, hoverPoint = chart.hoverPoint, hoverPoints = chart.hoverPoints, tooltip = chart.tooltip, tooltipPoints = tooltip && tooltip.shared ? hoverPoints : hoverPoint;
          if (allowMove && tooltipPoints) {
            splat$e(tooltipPoints).forEach(function(point) {
              if (point.series.isCartesian && typeof point.plotX === "undefined") {
                allowMove = false;
              }
            });
          }
          if (allowMove) {
            if (tooltip && tooltipPoints && splat$e(tooltipPoints).length) {
              tooltip.refresh(tooltipPoints);
              if (tooltip.shared && hoverPoints) {
                hoverPoints.forEach(function(point) {
                  point.setState(point.state, true);
                  if (point.series.isCartesian) {
                    if (point.series.xAxis.crosshair) {
                      point.series.xAxis.drawCrosshair(null, point);
                    }
                    if (point.series.yAxis.crosshair) {
                      point.series.yAxis.drawCrosshair(null, point);
                    }
                  }
                });
              } else if (hoverPoint) {
                hoverPoint.setState(hoverPoint.state, true);
                chart.axes.forEach(function(axis) {
                  if (axis.crosshair && hoverPoint.series[axis.coll] === axis) {
                    axis.drawCrosshair(null, hoverPoint);
                  }
                });
              }
            }
          } else {
            if (hoverPoint) {
              hoverPoint.onMouseOut();
            }
            if (hoverPoints) {
              hoverPoints.forEach(function(point) {
                point.setState();
              });
            }
            if (hoverSeries) {
              hoverSeries.onMouseOut();
            }
            if (tooltip) {
              tooltip.hide(delay);
            }
            if (pointer.unDocMouseMove) {
              pointer.unDocMouseMove = pointer.unDocMouseMove();
            }
            chart.axes.forEach(function(axis) {
              axis.hideCrosshair();
            });
            pointer.hoverX = chart.hoverPoints = chart.hoverPoint = null;
          }
        };
        Pointer2.prototype.runPointActions = function(e2, p5) {
          var pointer = this, chart = pointer.chart, series = chart.series, tooltip = chart.tooltip && chart.tooltip.options.enabled ? chart.tooltip : void 0, shared2 = tooltip ? tooltip.shared : false;
          var hoverPoint = p5 || chart.hoverPoint, hoverSeries = hoverPoint && hoverPoint.series || chart.hoverSeries;
          var isDirectTouch = (!e2 || e2.type !== "touchmove") && (!!p5 || hoverSeries && hoverSeries.directTouch && pointer.isDirectTouch), hoverData = this.getHoverData(hoverPoint, hoverSeries, series, isDirectTouch, shared2, e2);
          hoverPoint = hoverData.hoverPoint;
          hoverSeries = hoverData.hoverSeries;
          var points = hoverData.hoverPoints, followPointer = hoverSeries && hoverSeries.tooltipOptions.followPointer && !hoverSeries.tooltipOptions.split, useSharedTooltip = shared2 && hoverSeries && !hoverSeries.noSharedTooltip;
          if (hoverPoint && // !(hoverSeries && hoverSeries.directTouch) &&
          (hoverPoint !== chart.hoverPoint || tooltip && tooltip.isHidden)) {
            (chart.hoverPoints || []).forEach(function(p6) {
              if (points.indexOf(p6) === -1) {
                p6.setState();
              }
            });
            if (chart.hoverSeries !== hoverSeries) {
              hoverSeries.onMouseOver();
            }
            pointer.applyInactiveState(points);
            (points || []).forEach(function(p6) {
              p6.setState("hover");
            });
            if (chart.hoverPoint) {
              chart.hoverPoint.firePointEvent("mouseOut");
            }
            if (!hoverPoint.series) {
              return;
            }
            chart.hoverPoints = points;
            chart.hoverPoint = hoverPoint;
            hoverPoint.firePointEvent("mouseOver");
            if (tooltip) {
              tooltip.refresh(useSharedTooltip ? points : hoverPoint, e2);
            }
          } else if (followPointer && tooltip && !tooltip.isHidden) {
            var anchor = tooltip.getAnchor([{}], e2);
            if (chart.isInsidePlot(anchor[0], anchor[1], {
              visiblePlotOnly: true
            })) {
              tooltip.updatePosition({ plotX: anchor[0], plotY: anchor[1] });
            }
          }
          if (!pointer.unDocMouseMove) {
            pointer.unDocMouseMove = addEvent$W(chart.container.ownerDocument, "mousemove", function(e3) {
              var chart2 = charts$3[Pointer2.hoverChartIndex];
              if (chart2) {
                chart2.pointer.onDocumentMouseMove(e3);
              }
            });
            pointer.eventsToUnbind.push(pointer.unDocMouseMove);
          }
          chart.axes.forEach(function drawAxisCrosshair(axis) {
            var snap2 = pick$1j((axis.crosshair || {}).snap, true);
            var point;
            if (snap2) {
              point = chart.hoverPoint;
              if (!point || point.series[axis.coll] !== axis) {
                point = find$i(points, function(p6) {
                  return p6.series[axis.coll] === axis;
                });
              }
            }
            if (point || !snap2) {
              axis.drawCrosshair(e2, point);
            } else {
              axis.hideCrosshair();
            }
          });
        };
        Pointer2.prototype.scaleGroups = function(attribs, clip) {
          var chart = this.chart;
          chart.series.forEach(function(series) {
            var seriesAttribs = attribs || series.getPlotBox();
            if (series.xAxis && series.xAxis.zoomEnabled && series.group) {
              series.group.attr(seriesAttribs);
              if (series.markerGroup) {
                series.markerGroup.attr(seriesAttribs);
                series.markerGroup.clip(clip ? chart.clipRect : null);
              }
              if (series.dataLabelsGroup) {
                series.dataLabelsGroup.attr(seriesAttribs);
              }
            }
          });
          chart.clipRect.attr(clip || chart.clipBox);
        };
        Pointer2.prototype.setDOMEvents = function() {
          var _this = this;
          var container = this.chart.container, ownerDoc = container.ownerDocument;
          container.onmousedown = this.onContainerMouseDown.bind(this);
          container.onmousemove = this.onContainerMouseMove.bind(this);
          container.onclick = this.onContainerClick.bind(this);
          this.eventsToUnbind.push(addEvent$W(container, "mouseenter", this.onContainerMouseEnter.bind(this)));
          this.eventsToUnbind.push(addEvent$W(container, "mouseleave", this.onContainerMouseLeave.bind(this)));
          if (!Pointer2.unbindDocumentMouseUp) {
            Pointer2.unbindDocumentMouseUp = addEvent$W(ownerDoc, "mouseup", this.onDocumentMouseUp.bind(this));
          }
          var parent = this.chart.renderTo.parentElement;
          while (parent && parent.tagName !== "BODY") {
            this.eventsToUnbind.push(addEvent$W(parent, "scroll", function() {
              delete _this.chartPosition;
            }));
            parent = parent.parentElement;
          }
          if (H.hasTouch) {
            this.eventsToUnbind.push(addEvent$W(container, "touchstart", this.onContainerTouchStart.bind(this), { passive: false }));
            this.eventsToUnbind.push(addEvent$W(container, "touchmove", this.onContainerTouchMove.bind(this), { passive: false }));
            if (!Pointer2.unbindDocumentTouchEnd) {
              Pointer2.unbindDocumentTouchEnd = addEvent$W(ownerDoc, "touchend", this.onDocumentTouchEnd.bind(this), { passive: false });
            }
          }
        };
        Pointer2.prototype.setHoverChartIndex = function() {
          var chart = this.chart;
          var hoverChart = H.charts[pick$1j(Pointer2.hoverChartIndex, -1)];
          if (hoverChart && hoverChart !== chart) {
            hoverChart.pointer.onContainerMouseLeave({ relatedTarget: true });
          }
          if (!hoverChart || !hoverChart.mouseIsDown) {
            Pointer2.hoverChartIndex = chart.index;
          }
        };
        Pointer2.prototype.touch = function(e2, start2) {
          var chart = this.chart;
          var hasMoved, pinchDown, isInside;
          this.setHoverChartIndex();
          if (e2.touches.length === 1) {
            e2 = this.normalize(e2);
            isInside = chart.isInsidePlot(e2.chartX - chart.plotLeft, e2.chartY - chart.plotTop, {
              visiblePlotOnly: true
            });
            if (isInside && !chart.openMenu) {
              if (start2) {
                this.runPointActions(e2);
              }
              if (e2.type === "touchmove") {
                pinchDown = this.pinchDown;
                hasMoved = pinchDown[0] ? Math.sqrt(
                  // #5266
                  Math.pow(pinchDown[0].chartX - e2.chartX, 2) + Math.pow(pinchDown[0].chartY - e2.chartY, 2)
                ) >= 4 : false;
              }
              if (pick$1j(hasMoved, true)) {
                this.pinch(e2);
              }
            } else if (start2) {
              this.reset();
            }
          } else if (e2.touches.length === 2) {
            this.pinch(e2);
          }
        };
        Pointer2.prototype.touchSelect = function(e2) {
          return Boolean(this.chart.options.chart.zoomBySingleTouch && e2.touches && e2.touches.length === 1);
        };
        Pointer2.prototype.zoomOption = function(e2) {
          var chart = this.chart, options = chart.options.chart, inverted = chart.inverted;
          var zoomType = options.zoomType || "", zoomX, zoomY;
          if (/touch/.test(e2.type)) {
            zoomType = pick$1j(options.pinchType, zoomType);
          }
          this.zoomX = zoomX = /x/.test(zoomType);
          this.zoomY = zoomY = /y/.test(zoomType);
          this.zoomHor = zoomX && !inverted || zoomY && inverted;
          this.zoomVert = zoomY && !inverted || zoomX && inverted;
          this.hasZoom = zoomX || zoomY;
        };
        return Pointer2;
      }()
    );
    var __extends$2b = /* @__PURE__ */ function() {
      var extendStatics = function(d2, b2) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d3, b3) {
          d3.__proto__ = b3;
        } || function(d3, b3) {
          for (var p5 in b3) if (b3.hasOwnProperty(p5)) d3[p5] = b3[p5];
        };
        return extendStatics(d2, b2);
      };
      return function(d2, b2) {
        extendStatics(d2, b2);
        function __() {
          this.constructor = d2;
        }
        d2.prototype = b2 === null ? Object.create(b2) : (__.prototype = b2.prototype, new __());
      };
    }();
    var charts$2 = H.charts, doc$h = H.doc, noop$i = H.noop, win$a = H.win;
    var addEvent$V = Utilities.addEvent, css$7 = Utilities.css, objectEach$o = Utilities.objectEach, removeEvent$7 = Utilities.removeEvent;
    var touches = {};
    var hasPointerEvent = !!win$a.PointerEvent;
    function getWebkitTouches() {
      var fake = [];
      fake.item = function(i2) {
        return this[i2];
      };
      objectEach$o(touches, function(touch) {
        fake.push({
          pageX: touch.pageX,
          pageY: touch.pageY,
          target: touch.target
        });
      });
      return fake;
    }
    function translateMSPointer(e2, method, wktype, func) {
      var chart = charts$2[Pointer.hoverChartIndex || NaN];
      if ((e2.pointerType === "touch" || e2.pointerType === e2.MSPOINTER_TYPE_TOUCH) && chart) {
        var p5 = chart.pointer;
        func(e2);
        p5[method]({
          type: wktype,
          target: e2.currentTarget,
          preventDefault: noop$i,
          touches: getWebkitTouches()
        });
      }
    }
    var MSPointer = (
      /** @class */
      function(_super) {
        __extends$2b(MSPointer2, _super);
        function MSPointer2() {
          return _super !== null && _super.apply(this, arguments) || this;
        }
        MSPointer2.isRequired = function() {
          return !!(!H.hasTouch && (win$a.PointerEvent || win$a.MSPointerEvent));
        };
        MSPointer2.prototype.batchMSEvents = function(fn) {
          fn(this.chart.container, hasPointerEvent ? "pointerdown" : "MSPointerDown", this.onContainerPointerDown);
          fn(this.chart.container, hasPointerEvent ? "pointermove" : "MSPointerMove", this.onContainerPointerMove);
          fn(doc$h, hasPointerEvent ? "pointerup" : "MSPointerUp", this.onDocumentPointerUp);
        };
        MSPointer2.prototype.destroy = function() {
          this.batchMSEvents(removeEvent$7);
          _super.prototype.destroy.call(this);
        };
        MSPointer2.prototype.init = function(chart, options) {
          _super.prototype.init.call(this, chart, options);
          if (this.hasZoom) {
            css$7(chart.container, {
              "-ms-touch-action": "none",
              "touch-action": "none"
            });
          }
        };
        MSPointer2.prototype.onContainerPointerDown = function(e2) {
          translateMSPointer(e2, "onContainerTouchStart", "touchstart", function(e3) {
            touches[e3.pointerId] = {
              pageX: e3.pageX,
              pageY: e3.pageY,
              target: e3.currentTarget
            };
          });
        };
        MSPointer2.prototype.onContainerPointerMove = function(e2) {
          translateMSPointer(e2, "onContainerTouchMove", "touchmove", function(e3) {
            touches[e3.pointerId] = { pageX: e3.pageX, pageY: e3.pageY };
            if (!touches[e3.pointerId].target) {
              touches[e3.pointerId].target = e3.currentTarget;
            }
          });
        };
        MSPointer2.prototype.onDocumentPointerUp = function(e2) {
          translateMSPointer(e2, "onDocumentTouchEnd", "touchend", function(e3) {
            delete touches[e3.pointerId];
          });
        };
        MSPointer2.prototype.setDOMEvents = function() {
          _super.prototype.setDOMEvents.call(this);
          if (this.hasZoom || this.followTouchMove) {
            this.batchMSEvents(addEvent$V);
          }
        };
        return MSPointer2;
      }(Pointer)
    );
    var animObject$8 = animationExports.animObject, setAnimation$4 = animationExports.setAnimation;
    var format$b = FormatUtilities.format;
    var isFirefox$1 = H.isFirefox, marginNames$1 = H.marginNames, win$9 = H.win;
    var distribute$2 = R.distribute;
    var addEvent$U = Utilities.addEvent, createElement$6 = Utilities.createElement, css$6 = Utilities.css, defined$I = Utilities.defined, discardElement$4 = Utilities.discardElement, find$h = Utilities.find, fireEvent$t = Utilities.fireEvent, isNumber$C = Utilities.isNumber, merge$1c = Utilities.merge, pick$1i = Utilities.pick, relativeLength$8 = Utilities.relativeLength, stableSort$5 = Utilities.stableSort, syncTimeout$4 = Utilities.syncTimeout, wrap$c = Utilities.wrap;
    var Legend = (
      /** @class */
      function() {
        function Legend2(chart, options) {
          this.allItems = [];
          this.box = void 0;
          this.contentGroup = void 0;
          this.display = false;
          this.group = void 0;
          this.initialItemY = 0;
          this.itemHeight = 0;
          this.itemMarginBottom = 0;
          this.itemMarginTop = 0;
          this.itemX = 0;
          this.itemY = 0;
          this.lastItemY = 0;
          this.lastLineHeight = 0;
          this.legendHeight = 0;
          this.legendWidth = 0;
          this.maxItemWidth = 0;
          this.maxLegendWidth = 0;
          this.offsetWidth = 0;
          this.options = {};
          this.padding = 0;
          this.pages = [];
          this.proximate = false;
          this.scrollGroup = void 0;
          this.symbolHeight = 0;
          this.symbolWidth = 0;
          this.titleHeight = 0;
          this.totalItemWidth = 0;
          this.widthOption = 0;
          this.chart = chart;
          this.init(chart, options);
        }
        Legend2.prototype.init = function(chart, options) {
          this.chart = chart;
          this.setOptions(options);
          if (options.enabled) {
            this.render();
            addEvent$U(this.chart, "endResize", function() {
              this.legend.positionCheckboxes();
            });
            if (this.proximate) {
              this.unchartrender = addEvent$U(this.chart, "render", function() {
                this.legend.proximatePositions();
                this.legend.positionItems();
              });
            } else if (this.unchartrender) {
              this.unchartrender();
            }
          }
        };
        Legend2.prototype.setOptions = function(options) {
          var padding = pick$1i(options.padding, 8);
          this.options = options;
          if (!this.chart.styledMode) {
            this.itemStyle = options.itemStyle;
            this.itemHiddenStyle = merge$1c(this.itemStyle, options.itemHiddenStyle);
          }
          this.itemMarginTop = options.itemMarginTop || 0;
          this.itemMarginBottom = options.itemMarginBottom || 0;
          this.padding = padding;
          this.initialItemY = padding - 5;
          this.symbolWidth = pick$1i(options.symbolWidth, 16);
          this.pages = [];
          this.proximate = options.layout === "proximate" && !this.chart.inverted;
          this.baseline = void 0;
        };
        Legend2.prototype.update = function(options, redraw) {
          var chart = this.chart;
          this.setOptions(merge$1c(true, this.options, options));
          this.destroy();
          chart.isDirtyLegend = chart.isDirtyBox = true;
          if (pick$1i(redraw, true)) {
            chart.redraw();
          }
          fireEvent$t(this, "afterUpdate");
        };
        Legend2.prototype.colorizeItem = function(item2, visible) {
          item2.legendGroup[visible ? "removeClass" : "addClass"]("highcharts-legend-item-hidden");
          if (!this.chart.styledMode) {
            var legend = this, options = legend.options, legendItem = item2.legendItem, legendLine = item2.legendLine, legendSymbol = item2.legendSymbol, hiddenColor = legend.itemHiddenStyle.color, textColor = visible ? options.itemStyle.color : hiddenColor, symbolColor = visible ? item2.color || hiddenColor : hiddenColor, markerOptions = item2.options && item2.options.marker;
            var symbolAttr = { fill: symbolColor };
            if (legendItem) {
              legendItem.css({
                fill: textColor,
                color: textColor
                // #1553, oldIE
              });
            }
            if (legendLine) {
              legendLine.attr({ stroke: symbolColor });
            }
            if (legendSymbol) {
              if (markerOptions && legendSymbol.isMarker) {
                symbolAttr = item2.pointAttribs();
                if (!visible) {
                  symbolAttr.stroke = symbolAttr.fill = hiddenColor;
                }
              }
              legendSymbol.attr(symbolAttr);
            }
          }
          fireEvent$t(this, "afterColorizeItem", { item: item2, visible });
        };
        Legend2.prototype.positionItems = function() {
          this.allItems.forEach(this.positionItem, this);
          if (!this.chart.isResizing) {
            this.positionCheckboxes();
          }
        };
        Legend2.prototype.positionItem = function(item2) {
          var _this = this;
          var legend = this, options = legend.options, symbolPadding = options.symbolPadding, ltr = !options.rtl, legendItemPos = item2._legendItemPos, itemX = legendItemPos[0], itemY = legendItemPos[1], checkbox = item2.checkbox, legendGroup = item2.legendGroup;
          if (legendGroup && legendGroup.element) {
            var attribs = {
              translateX: ltr ? itemX : legend.legendWidth - itemX - 2 * symbolPadding - 4,
              translateY: itemY
            };
            var complete = function() {
              fireEvent$t(_this, "afterPositionItem", { item: item2 });
            };
            if (defined$I(legendGroup.translateY)) {
              legendGroup.animate(attribs, void 0, complete);
            } else {
              legendGroup.attr(attribs);
              complete();
            }
          }
          if (checkbox) {
            checkbox.x = itemX;
            checkbox.y = itemY;
          }
        };
        Legend2.prototype.destroyItem = function(item2) {
          var checkbox = item2.checkbox;
          ["legendItem", "legendLine", "legendSymbol", "legendGroup"].forEach(function(key) {
            if (item2[key]) {
              item2[key] = item2[key].destroy();
            }
          });
          if (checkbox) {
            discardElement$4(item2.checkbox);
          }
        };
        Legend2.prototype.destroy = function() {
          function destroyItems(key) {
            if (this[key]) {
              this[key] = this[key].destroy();
            }
          }
          this.getAllItems().forEach(function(item2) {
            ["legendItem", "legendGroup"].forEach(destroyItems, item2);
          });
          [
            "clipRect",
            "up",
            "down",
            "pager",
            "nav",
            "box",
            "title",
            "group"
          ].forEach(destroyItems, this);
          this.display = null;
        };
        Legend2.prototype.positionCheckboxes = function() {
          var alignAttr = this.group && this.group.alignAttr, clipHeight = this.clipHeight || this.legendHeight, titleHeight = this.titleHeight;
          var translateY;
          if (alignAttr) {
            translateY = alignAttr.translateY;
            this.allItems.forEach(function(item2) {
              var checkbox = item2.checkbox;
              var top;
              if (checkbox) {
                top = translateY + titleHeight + checkbox.y + (this.scrollOffset || 0) + 3;
                css$6(checkbox, {
                  left: alignAttr.translateX + item2.checkboxOffset + checkbox.x - 20 + "px",
                  top: top + "px",
                  display: this.proximate || top > translateY - 6 && top < translateY + clipHeight - 6 ? "" : "none"
                });
              }
            }, this);
          }
        };
        Legend2.prototype.renderTitle = function() {
          var options = this.options, padding = this.padding, titleOptions = options.title;
          var bBox, titleHeight = 0;
          if (titleOptions.text) {
            if (!this.title) {
              this.title = this.chart.renderer.label(titleOptions.text, padding - 3, padding - 4, null, null, null, options.useHTML, null, "legend-title").attr({ zIndex: 1 });
              if (!this.chart.styledMode) {
                this.title.css(titleOptions.style);
              }
              this.title.add(this.group);
            }
            if (!titleOptions.width) {
              this.title.css({
                width: this.maxLegendWidth + "px"
              });
            }
            bBox = this.title.getBBox();
            titleHeight = bBox.height;
            this.offsetWidth = bBox.width;
            this.contentGroup.attr({ translateY: titleHeight });
          }
          this.titleHeight = titleHeight;
        };
        Legend2.prototype.setText = function(item2) {
          var options = this.options;
          item2.legendItem.attr({
            text: options.labelFormat ? format$b(options.labelFormat, item2, this.chart) : options.labelFormatter.call(item2)
          });
        };
        Legend2.prototype.renderItem = function(item2) {
          var legend = this, chart = legend.chart, renderer = chart.renderer, options = legend.options, horizontal = options.layout === "horizontal", symbolWidth = legend.symbolWidth, symbolPadding = options.symbolPadding || 0, itemStyle = legend.itemStyle, itemHiddenStyle = legend.itemHiddenStyle, itemDistance = horizontal ? pick$1i(options.itemDistance, 20) : 0, ltr = !options.rtl, isSeries = !item2.series, series = !isSeries && item2.series.drawLegendSymbol ? item2.series : item2, seriesOptions = series.options, showCheckbox = legend.createCheckboxForItem && seriesOptions && seriesOptions.showCheckbox, useHTML = options.useHTML, itemClassName = item2.options.className;
          var li = item2.legendItem, itemExtraWidth = symbolWidth + symbolPadding + itemDistance + (showCheckbox ? 20 : 0);
          if (!li) {
            item2.legendGroup = renderer.g("legend-item").addClass("highcharts-" + series.type + "-series highcharts-color-" + item2.colorIndex + (itemClassName ? " " + itemClassName : "") + (isSeries ? " highcharts-series-" + item2.index : "")).attr({ zIndex: 1 }).add(legend.scrollGroup);
            item2.legendItem = li = renderer.text("", ltr ? symbolWidth + symbolPadding : -symbolPadding, legend.baseline || 0, useHTML);
            if (!chart.styledMode) {
              li.css(merge$1c(item2.visible ? itemStyle : itemHiddenStyle));
            }
            li.attr({
              align: ltr ? "left" : "right",
              zIndex: 2
            }).add(item2.legendGroup);
            if (!legend.baseline) {
              legend.fontMetrics = renderer.fontMetrics(chart.styledMode ? 12 : itemStyle.fontSize, li);
              legend.baseline = legend.fontMetrics.f + 3 + legend.itemMarginTop;
              li.attr("y", legend.baseline);
              legend.symbolHeight = options.symbolHeight || legend.fontMetrics.f;
              if (options.squareSymbol) {
                legend.symbolWidth = pick$1i(options.symbolWidth, Math.max(legend.symbolHeight, 16));
                itemExtraWidth = legend.symbolWidth + symbolPadding + itemDistance + (showCheckbox ? 20 : 0);
                if (ltr) {
                  li.attr("x", legend.symbolWidth + symbolPadding);
                }
              }
            }
            series.drawLegendSymbol(legend, item2);
            if (legend.setItemEvents) {
              legend.setItemEvents(item2, li, useHTML);
            }
          }
          if (showCheckbox && !item2.checkbox && legend.createCheckboxForItem) {
            legend.createCheckboxForItem(item2);
          }
          legend.colorizeItem(item2, item2.visible);
          if (chart.styledMode || !itemStyle.width) {
            li.css({
              width: (options.itemWidth || legend.widthOption || chart.spacingBox.width) - itemExtraWidth + "px"
            });
          }
          legend.setText(item2);
          var bBox = li.getBBox();
          item2.itemWidth = item2.checkboxOffset = options.itemWidth || item2.legendItemWidth || bBox.width + itemExtraWidth;
          legend.maxItemWidth = Math.max(legend.maxItemWidth, item2.itemWidth);
          legend.totalItemWidth += item2.itemWidth;
          legend.itemHeight = item2.itemHeight = Math.round(item2.legendItemHeight || bBox.height || legend.symbolHeight);
        };
        Legend2.prototype.layoutItem = function(item2) {
          var options = this.options, padding = this.padding, horizontal = options.layout === "horizontal", itemHeight = item2.itemHeight, itemMarginBottom = this.itemMarginBottom, itemMarginTop = this.itemMarginTop, itemDistance = horizontal ? pick$1i(options.itemDistance, 20) : 0, maxLegendWidth = this.maxLegendWidth, itemWidth = options.alignColumns && this.totalItemWidth > maxLegendWidth ? this.maxItemWidth : item2.itemWidth;
          if (horizontal && this.itemX - padding + itemWidth > maxLegendWidth) {
            this.itemX = padding;
            if (this.lastLineHeight) {
              this.itemY += itemMarginTop + this.lastLineHeight + itemMarginBottom;
            }
            this.lastLineHeight = 0;
          }
          this.lastItemY = itemMarginTop + this.itemY + itemMarginBottom;
          this.lastLineHeight = Math.max(
            // #915
            itemHeight,
            this.lastLineHeight
          );
          item2._legendItemPos = [this.itemX, this.itemY];
          if (horizontal) {
            this.itemX += itemWidth;
          } else {
            this.itemY += itemMarginTop + itemHeight + itemMarginBottom;
            this.lastLineHeight = itemHeight;
          }
          this.offsetWidth = this.widthOption || Math.max((horizontal ? this.itemX - padding - (item2.checkbox ? (
            // decrease by itemDistance only when no checkbox #4853
            0
          ) : itemDistance) : itemWidth) + padding, this.offsetWidth);
        };
        Legend2.prototype.getAllItems = function() {
          var allItems = [];
          this.chart.series.forEach(function(series) {
            var seriesOptions = series && series.options;
            if (series && pick$1i(seriesOptions.showInLegend, !defined$I(seriesOptions.linkedTo) ? void 0 : false, true)) {
              allItems = allItems.concat(series.legendItems || (seriesOptions.legendType === "point" ? series.data : series));
            }
          });
          fireEvent$t(this, "afterGetAllItems", { allItems });
          return allItems;
        };
        Legend2.prototype.getAlignment = function() {
          var options = this.options;
          if (this.proximate) {
            return options.align.charAt(0) + "tv";
          }
          return options.floating ? "" : options.align.charAt(0) + options.verticalAlign.charAt(0) + options.layout.charAt(0);
        };
        Legend2.prototype.adjustMargins = function(margin, spacing) {
          var chart = this.chart, options = this.options, alignment = this.getAlignment();
          if (alignment) {
            [
              /(lth|ct|rth)/,
              /(rtv|rm|rbv)/,
              /(rbh|cb|lbh)/,
              /(lbv|lm|ltv)/
            ].forEach(function(alignments, side) {
              if (alignments.test(alignment) && !defined$I(margin[side])) {
                chart[marginNames$1[side]] = Math.max(chart[marginNames$1[side]], chart.legend[(side + 1) % 2 ? "legendHeight" : "legendWidth"] + [1, -1, -1, 1][side] * options[side % 2 ? "x" : "y"] + pick$1i(options.margin, 12) + spacing[side] + (chart.titleOffset[side] || 0));
              }
            });
          }
        };
        Legend2.prototype.proximatePositions = function() {
          var chart = this.chart, boxes = [], alignLeft = this.options.align === "left";
          this.allItems.forEach(function(item2) {
            var lastPoint, height, useFirstPoint = alignLeft, target, top;
            if (item2.yAxis) {
              if (item2.xAxis.options.reversed) {
                useFirstPoint = !useFirstPoint;
              }
              if (item2.points) {
                lastPoint = find$h(useFirstPoint ? item2.points : item2.points.slice(0).reverse(), function(item3) {
                  return isNumber$C(item3.plotY);
                });
              }
              height = this.itemMarginTop + item2.legendItem.getBBox().height + this.itemMarginBottom;
              top = item2.yAxis.top - chart.plotTop;
              if (item2.visible) {
                target = lastPoint ? lastPoint.plotY : item2.yAxis.height;
                target += top - 0.3 * height;
              } else {
                target = top + item2.yAxis.height;
              }
              boxes.push({
                target,
                size: height,
                item: item2
              });
            }
          }, this);
          distribute$2(boxes, chart.plotHeight).forEach(function(box) {
            if (box.item._legendItemPos) {
              box.item._legendItemPos[1] = chart.plotTop - chart.spacing[0] + box.pos;
            }
          });
        };
        Legend2.prototype.render = function() {
          var legend = this, chart = legend.chart, renderer = chart.renderer, options = legend.options, padding = legend.padding, allItems = legend.getAllItems();
          var display, legendWidth, legendHeight, legendGroup = legend.group, allowedWidth, box = legend.box;
          legend.itemX = padding;
          legend.itemY = legend.initialItemY;
          legend.offsetWidth = 0;
          legend.lastItemY = 0;
          legend.widthOption = relativeLength$8(options.width, chart.spacingBox.width - padding);
          allowedWidth = chart.spacingBox.width - 2 * padding - options.x;
          if (["rm", "lm"].indexOf(legend.getAlignment().substring(0, 2)) > -1) {
            allowedWidth /= 2;
          }
          legend.maxLegendWidth = legend.widthOption || allowedWidth;
          if (!legendGroup) {
            legend.group = legendGroup = renderer.g("legend").addClass(options.className || "").attr({ zIndex: 7 }).add();
            legend.contentGroup = renderer.g().attr({ zIndex: 1 }).add(legendGroup);
            legend.scrollGroup = renderer.g().add(legend.contentGroup);
          }
          legend.renderTitle();
          stableSort$5(allItems, function(a, b2) {
            return (a.options && a.options.legendIndex || 0) - (b2.options && b2.options.legendIndex || 0);
          });
          if (options.reversed) {
            allItems.reverse();
          }
          legend.allItems = allItems;
          legend.display = display = !!allItems.length;
          legend.lastLineHeight = 0;
          legend.maxItemWidth = 0;
          legend.totalItemWidth = 0;
          legend.itemHeight = 0;
          allItems.forEach(legend.renderItem, legend);
          allItems.forEach(legend.layoutItem, legend);
          legendWidth = (legend.widthOption || legend.offsetWidth) + padding;
          legendHeight = legend.lastItemY + legend.lastLineHeight + legend.titleHeight;
          legendHeight = legend.handleOverflow(legendHeight);
          legendHeight += padding;
          if (!box) {
            legend.box = box = renderer.rect().addClass("highcharts-legend-box").attr({
              r: options.borderRadius
            }).add(legendGroup);
            box.isNew = true;
          }
          if (!chart.styledMode) {
            box.attr({
              stroke: options.borderColor,
              "stroke-width": options.borderWidth || 0,
              fill: options.backgroundColor || "none"
            }).shadow(options.shadow);
          }
          if (legendWidth > 0 && legendHeight > 0) {
            box[box.isNew ? "attr" : "animate"](box.crisp.call({}, {
              x: 0,
              y: 0,
              width: legendWidth,
              height: legendHeight
            }, box.strokeWidth()));
            box.isNew = false;
          }
          box[display ? "show" : "hide"]();
          if (chart.styledMode && legendGroup.getStyle("display") === "none") {
            legendWidth = legendHeight = 0;
          }
          legend.legendWidth = legendWidth;
          legend.legendHeight = legendHeight;
          if (display) {
            legend.align();
          }
          if (!this.proximate) {
            this.positionItems();
          }
          fireEvent$t(this, "afterRender");
        };
        Legend2.prototype.align = function(alignTo) {
          if (alignTo === void 0) {
            alignTo = this.chart.spacingBox;
          }
          var chart = this.chart, options = this.options;
          var y = alignTo.y;
          if (/(lth|ct|rth)/.test(this.getAlignment()) && chart.titleOffset[0] > 0) {
            y += chart.titleOffset[0];
          } else if (/(lbh|cb|rbh)/.test(this.getAlignment()) && chart.titleOffset[2] > 0) {
            y -= chart.titleOffset[2];
          }
          if (y !== alignTo.y) {
            alignTo = merge$1c(alignTo, { y });
          }
          this.group.align(merge$1c(options, {
            width: this.legendWidth,
            height: this.legendHeight,
            verticalAlign: this.proximate ? "top" : options.verticalAlign
          }), true, alignTo);
        };
        Legend2.prototype.handleOverflow = function(legendHeight) {
          var legend = this, chart = this.chart, renderer = chart.renderer, options = this.options, optionsY = options.y, alignTop = options.verticalAlign === "top", padding = this.padding, maxHeight = options.maxHeight, navOptions = options.navigation, animation = pick$1i(navOptions.animation, true), arrowSize = navOptions.arrowSize || 12, pages = this.pages, allItems = this.allItems, clipToHeight = function(height) {
            if (typeof height === "number") {
              clipRect.attr({
                height
              });
            } else if (clipRect) {
              legend.clipRect = clipRect.destroy();
              legend.contentGroup.clip();
            }
            if (legend.contentGroup.div) {
              legend.contentGroup.div.style.clip = height ? "rect(" + padding + "px,9999px," + (padding + height) + "px,0)" : "auto";
            }
          }, addTracker = function(key) {
            legend[key] = renderer.circle(0, 0, arrowSize * 1.3).translate(arrowSize / 2, arrowSize / 2).add(nav);
            if (!chart.styledMode) {
              legend[key].attr("fill", "rgba(0,0,0,0.0001)");
            }
            return legend[key];
          };
          var clipHeight, lastY, spaceHeight = chart.spacingBox.height + (alignTop ? -optionsY : optionsY) - padding, nav = this.nav, clipRect = this.clipRect;
          if (options.layout === "horizontal" && options.verticalAlign !== "middle" && !options.floating) {
            spaceHeight /= 2;
          }
          if (maxHeight) {
            spaceHeight = Math.min(spaceHeight, maxHeight);
          }
          pages.length = 0;
          if (legendHeight && spaceHeight > 0 && legendHeight > spaceHeight && navOptions.enabled !== false) {
            this.clipHeight = clipHeight = Math.max(spaceHeight - 20 - this.titleHeight - padding, 0);
            this.currentPage = pick$1i(this.currentPage, 1);
            this.fullHeight = legendHeight;
            allItems.forEach(function(item2, i2) {
              var y = item2._legendItemPos[1], h2 = Math.round(item2.legendItem.getBBox().height);
              var len = pages.length;
              if (!len || y - pages[len - 1] > clipHeight && (lastY || y) !== pages[len - 1]) {
                pages.push(lastY || y);
                len++;
              }
              item2.pageIx = len - 1;
              if (lastY) {
                allItems[i2 - 1].pageIx = len - 1;
              }
              if (i2 === allItems.length - 1 && y + h2 - pages[len - 1] > clipHeight && y !== lastY) {
                pages.push(y);
                item2.pageIx = len;
              }
              if (y !== lastY) {
                lastY = y;
              }
            });
            if (!clipRect) {
              clipRect = legend.clipRect = renderer.clipRect(0, padding, 9999, 0);
              legend.contentGroup.clip(clipRect);
            }
            clipToHeight(clipHeight);
            if (!nav) {
              this.nav = nav = renderer.g().attr({ zIndex: 1 }).add(this.group);
              this.up = renderer.symbol("triangle", 0, 0, arrowSize, arrowSize).add(nav);
              addTracker("upTracker").on("click", function() {
                legend.scroll(-1, animation);
              });
              this.pager = renderer.text("", 15, 10).addClass("highcharts-legend-navigation");
              if (!chart.styledMode) {
                this.pager.css(navOptions.style);
              }
              this.pager.add(nav);
              this.down = renderer.symbol("triangle-down", 0, 0, arrowSize, arrowSize).add(nav);
              addTracker("downTracker").on("click", function() {
                legend.scroll(1, animation);
              });
            }
            legend.scroll(0);
            legendHeight = spaceHeight;
          } else if (nav) {
            clipToHeight();
            this.nav = nav.destroy();
            this.scrollGroup.attr({
              translateY: 1
            });
            this.clipHeight = 0;
          }
          return legendHeight;
        };
        Legend2.prototype.scroll = function(scrollBy, animation) {
          var _this = this;
          var chart = this.chart, pages = this.pages, pageCount = pages.length, clipHeight = this.clipHeight, navOptions = this.options.navigation, pager = this.pager, padding = this.padding;
          var currentPage = this.currentPage + scrollBy;
          if (currentPage > pageCount) {
            currentPage = pageCount;
          }
          if (currentPage > 0) {
            if (typeof animation !== "undefined") {
              setAnimation$4(animation, chart);
            }
            this.nav.attr({
              translateX: padding,
              translateY: clipHeight + this.padding + 7 + this.titleHeight,
              visibility: "visible"
            });
            [this.up, this.upTracker].forEach(function(elem) {
              elem.attr({
                "class": currentPage === 1 ? "highcharts-legend-nav-inactive" : "highcharts-legend-nav-active"
              });
            });
            pager.attr({
              text: currentPage + "/" + pageCount
            });
            [this.down, this.downTracker].forEach(function(elem) {
              elem.attr({
                // adjust to text width
                x: 18 + this.pager.getBBox().width,
                "class": currentPage === pageCount ? "highcharts-legend-nav-inactive" : "highcharts-legend-nav-active"
              });
            }, this);
            if (!chart.styledMode) {
              this.up.attr({
                fill: currentPage === 1 ? navOptions.inactiveColor : navOptions.activeColor
              });
              this.upTracker.css({
                cursor: currentPage === 1 ? "default" : "pointer"
              });
              this.down.attr({
                fill: currentPage === pageCount ? navOptions.inactiveColor : navOptions.activeColor
              });
              this.downTracker.css({
                cursor: currentPage === pageCount ? "default" : "pointer"
              });
            }
            this.scrollOffset = -pages[currentPage - 1] + this.initialItemY;
            this.scrollGroup.animate({
              translateY: this.scrollOffset
            });
            this.currentPage = currentPage;
            this.positionCheckboxes();
            var animOptions = animObject$8(pick$1i(animation, chart.renderer.globalAnimation, true));
            syncTimeout$4(function() {
              fireEvent$t(_this, "afterScroll", { currentPage });
            }, animOptions.duration);
          }
        };
        Legend2.prototype.setItemEvents = function(item2, legendItem, useHTML) {
          var legend = this, boxWrapper = legend.chart.renderer.boxWrapper, isPoint = item2 instanceof Point$4, activeClass = "highcharts-legend-" + (isPoint ? "point" : "series") + "-active", styledMode = legend.chart.styledMode, legendItems = useHTML ? [legendItem, item2.legendSymbol] : [item2.legendGroup];
          var setOtherItemsState = function(state) {
            legend.allItems.forEach(function(otherItem) {
              if (item2 !== otherItem) {
                [otherItem].concat(otherItem.linkedSeries || []).forEach(function(otherItem2) {
                  otherItem2.setState(state, !isPoint);
                });
              }
            });
          };
          legendItems.forEach(function(element) {
            if (element) {
              element.on("mouseover", function() {
                if (item2.visible) {
                  setOtherItemsState("inactive");
                }
                item2.setState("hover");
                if (item2.visible) {
                  boxWrapper.addClass(activeClass);
                }
                if (!styledMode) {
                  legendItem.css(legend.options.itemHoverStyle);
                }
              }).on("mouseout", function() {
                if (!legend.chart.styledMode) {
                  legendItem.css(merge$1c(item2.visible ? legend.itemStyle : legend.itemHiddenStyle));
                }
                setOtherItemsState("");
                boxWrapper.removeClass(activeClass);
                item2.setState();
              }).on("click", function(event) {
                var strLegendItemClick = "legendItemClick", fnLegendItemClick = function() {
                  if (item2.setVisible) {
                    item2.setVisible();
                  }
                  setOtherItemsState(item2.visible ? "inactive" : "");
                };
                boxWrapper.removeClass(activeClass);
                event = {
                  browserEvent: event
                };
                if (item2.firePointEvent) {
                  item2.firePointEvent(strLegendItemClick, event, fnLegendItemClick);
                } else {
                  fireEvent$t(item2, strLegendItemClick, event, fnLegendItemClick);
                }
              });
            }
          });
        };
        Legend2.prototype.createCheckboxForItem = function(item2) {
          var legend = this;
          item2.checkbox = createElement$6("input", {
            type: "checkbox",
            className: "highcharts-legend-checkbox",
            checked: item2.selected,
            defaultChecked: item2.selected
            // required by IE7
          }, legend.options.itemCheckboxStyle, legend.chart.container);
          addEvent$U(item2.checkbox, "click", function(event) {
            var target = event.target;
            fireEvent$t(item2.series || item2, "checkboxClick", {
              checked: target.checked,
              item: item2
            }, function() {
              item2.select();
            });
          });
        };
        return Legend2;
      }()
    );
    if (/Trident\/7\.0/.test(win$9.navigator && win$9.navigator.userAgent) || isFirefox$1) {
      wrap$c(Legend.prototype, "positionItem", function(proceed, item2) {
        var legend = this, runPositionItem = function() {
          if (item2._legendItemPos) {
            proceed.call(legend, item2);
          }
        };
        runPositionItem();
        if (!legend.bubbleLegend) {
          setTimeout(runPositionItem);
        }
      });
    }
    var defaultOptions$c = DefaultOptions.defaultOptions;
    var error$6 = Utilities.error, extendClass$1 = Utilities.extendClass, merge$1b = Utilities.merge;
    var SeriesRegistry;
    (function(SeriesRegistry2) {
      SeriesRegistry2.seriesTypes = H.seriesTypes;
      function getSeries(chart, options) {
        if (options === void 0) {
          options = {};
        }
        var optionsChart = chart.options.chart, type = options.type || optionsChart.type || optionsChart.defaultSeriesType || "", SeriesClass = SeriesRegistry2.seriesTypes[type];
        if (!SeriesRegistry2) {
          error$6(17, true, chart, { missingModuleFor: type });
        }
        var series = new SeriesClass();
        if (typeof series.init === "function") {
          series.init(chart, options);
        }
        return series;
      }
      SeriesRegistry2.getSeries = getSeries;
      function registerSeriesType(seriesType2, seriesClass) {
        var defaultPlotOptions = defaultOptions$c.plotOptions || {}, seriesOptions = seriesClass.defaultOptions;
        if (!seriesClass.prototype.pointClass) {
          seriesClass.prototype.pointClass = Point$4;
        }
        seriesClass.prototype.type = seriesType2;
        if (seriesOptions) {
          defaultPlotOptions[seriesType2] = seriesOptions;
        }
        SeriesRegistry2.seriesTypes[seriesType2] = seriesClass;
      }
      SeriesRegistry2.registerSeriesType = registerSeriesType;
      function seriesType(type, parent, options, seriesProto2, pointProto2) {
        var defaultPlotOptions = defaultOptions$c.plotOptions || {};
        parent = parent || "";
        defaultPlotOptions[type] = merge$1b(defaultPlotOptions[parent], options);
        registerSeriesType(type, extendClass$1(SeriesRegistry2.seriesTypes[parent] || function() {
        }, seriesProto2));
        SeriesRegistry2.seriesTypes[type].prototype.type = type;
        if (pointProto2) {
          SeriesRegistry2.seriesTypes[type].prototype.pointClass = extendClass$1(Point$4, pointProto2);
        }
        return SeriesRegistry2.seriesTypes[type];
      }
      SeriesRegistry2.seriesType = seriesType;
    })(SeriesRegistry || (SeriesRegistry = {}));
    const SeriesRegistry$1 = SeriesRegistry;
    var animate = animationExports.animate, animObject$7 = animationExports.animObject, setAnimation$3 = animationExports.setAnimation;
    var numberFormat$1 = FormatUtilities.numberFormat;
    var registerEventOptions$1 = exports$6.registerEventOptions;
    var charts$1 = H.charts, doc$g = H.doc, marginNames = H.marginNames, svg$3 = H.svg, win$8 = H.win;
    var defaultOptions$b = DefaultOptions.defaultOptions, defaultTime = DefaultOptions.defaultTime;
    var seriesTypes$7 = SeriesRegistry$1.seriesTypes;
    var addEvent$T = Utilities.addEvent, attr$1 = Utilities.attr, cleanRecursively$1 = Utilities.cleanRecursively, createElement$5 = Utilities.createElement, css$5 = Utilities.css, defined$H = Utilities.defined, discardElement$3 = Utilities.discardElement, erase$3 = Utilities.erase, error$5 = Utilities.error, extend$1h = Utilities.extend, find$g = Utilities.find, fireEvent$s = Utilities.fireEvent, getStyle = Utilities.getStyle, isArray$g = Utilities.isArray, isNumber$B = Utilities.isNumber, isObject$9 = Utilities.isObject, isString$5 = Utilities.isString, merge$1a = Utilities.merge, objectEach$n = Utilities.objectEach, pick$1h = Utilities.pick, pInt$4 = Utilities.pInt, relativeLength$7 = Utilities.relativeLength, removeEvent$6 = Utilities.removeEvent, splat$d = Utilities.splat, syncTimeout$3 = Utilities.syncTimeout, uniqueKey$4 = Utilities.uniqueKey;
    var Chart$1 = (
      /** @class */
      function() {
        function Chart2(a, b2, c2) {
          this.axes = void 0;
          this.axisOffset = void 0;
          this.bounds = void 0;
          this.chartHeight = void 0;
          this.chartWidth = void 0;
          this.clipBox = void 0;
          this.colorCounter = void 0;
          this.container = void 0;
          this.eventOptions = void 0;
          this.index = void 0;
          this.isResizing = void 0;
          this.labelCollectors = void 0;
          this.legend = void 0;
          this.margin = void 0;
          this.numberFormatter = void 0;
          this.options = void 0;
          this.plotBox = void 0;
          this.plotHeight = void 0;
          this.plotLeft = void 0;
          this.plotTop = void 0;
          this.plotWidth = void 0;
          this.pointCount = void 0;
          this.pointer = void 0;
          this.renderer = void 0;
          this.renderTo = void 0;
          this.series = void 0;
          this.sharedClips = {};
          this.spacing = void 0;
          this.spacingBox = void 0;
          this.symbolCounter = void 0;
          this.time = void 0;
          this.titleOffset = void 0;
          this.userOptions = void 0;
          this.xAxis = void 0;
          this.yAxis = void 0;
          this.getArgs(a, b2, c2);
        }
        Chart2.chart = function(a, b2, c2) {
          return new Chart2(a, b2, c2);
        };
        Chart2.prototype.getArgs = function(a, b2, c2) {
          if (isString$5(a) || a.nodeName) {
            this.renderTo = a;
            this.init(b2, c2);
          } else {
            this.init(a, b2);
          }
        };
        Chart2.prototype.init = function(userOptions, callback) {
          var userPlotOptions = userOptions.plotOptions || {};
          fireEvent$s(this, "init", { args: arguments }, function() {
            var options = merge$1a(defaultOptions$b, userOptions);
            var optionsChart = options.chart;
            objectEach$n(options.plotOptions, function(typeOptions, type) {
              if (isObject$9(typeOptions)) {
                typeOptions.tooltip = userPlotOptions[type] && // override by copy:
                merge$1a(userPlotOptions[type].tooltip) || void 0;
              }
            });
            options.tooltip.userOptions = userOptions.chart && userOptions.chart.forExport && userOptions.tooltip.userOptions || userOptions.tooltip;
            this.userOptions = userOptions;
            this.margin = [];
            this.spacing = [];
            this.bounds = { h: {}, v: {} };
            this.labelCollectors = [];
            this.callback = callback;
            this.isResizing = 0;
            this.options = options;
            this.axes = [];
            this.series = [];
            this.time = userOptions.time && Object.keys(userOptions.time).length ? new Time(userOptions.time) : H.time;
            this.numberFormatter = optionsChart.numberFormatter || numberFormat$1;
            this.styledMode = optionsChart.styledMode;
            this.hasCartesianSeries = optionsChart.showAxes;
            var chart = this;
            chart.index = charts$1.length;
            charts$1.push(chart);
            H.chartCount++;
            registerEventOptions$1(this, optionsChart);
            chart.xAxis = [];
            chart.yAxis = [];
            chart.pointCount = chart.colorCounter = chart.symbolCounter = 0;
            fireEvent$s(chart, "afterInit");
            chart.firstRender();
          });
        };
        Chart2.prototype.initSeries = function(options) {
          var chart = this, optionsChart = chart.options.chart, type = options.type || optionsChart.type || optionsChart.defaultSeriesType, SeriesClass = seriesTypes$7[type];
          if (!SeriesClass) {
            error$5(17, true, chart, { missingModuleFor: type });
          }
          var series = new SeriesClass();
          if (typeof series.init === "function") {
            series.init(chart, options);
          }
          return series;
        };
        Chart2.prototype.setSeriesData = function() {
          this.getSeriesOrderByLinks().forEach(function(series) {
            if (!series.points && !series.data && series.enabledDataSorting) {
              series.setData(series.options.data, false);
            }
          });
        };
        Chart2.prototype.getSeriesOrderByLinks = function() {
          return this.series.concat().sort(function(a, b2) {
            if (a.linkedSeries.length || b2.linkedSeries.length) {
              return b2.linkedSeries.length - a.linkedSeries.length;
            }
            return 0;
          });
        };
        Chart2.prototype.orderSeries = function(fromIndex) {
          var series = this.series;
          for (var i2 = fromIndex || 0, iEnd = series.length; i2 < iEnd; ++i2) {
            if (series[i2]) {
              series[i2].index = i2;
              series[i2].name = series[i2].getName();
            }
          }
        };
        Chart2.prototype.isInsidePlot = function(plotX, plotY, options) {
          var _a3;
          if (options === void 0) {
            options = {};
          }
          var _b3 = this, inverted = _b3.inverted, plotBox = _b3.plotBox, plotLeft = _b3.plotLeft, plotTop = _b3.plotTop, scrollablePlotBox = _b3.scrollablePlotBox;
          var scrollLeft = 0, scrollTop = 0;
          if (options.visiblePlotOnly && this.scrollingContainer) {
            _a3 = this.scrollingContainer, scrollLeft = _a3.scrollLeft, scrollTop = _a3.scrollTop;
          }
          var series = options.series, box = options.visiblePlotOnly && scrollablePlotBox || plotBox, x = options.inverted ? plotY : plotX, y = options.inverted ? plotX : plotY, e2 = {
            x,
            y,
            isInsidePlot: true
          };
          if (!options.ignoreX) {
            var xAxis = series && (inverted ? series.yAxis : series.xAxis) || {
              pos: plotLeft,
              len: Infinity
            };
            var chartX = options.paneCoordinates ? xAxis.pos + x : plotLeft + x;
            if (!(chartX >= Math.max(scrollLeft + plotLeft, xAxis.pos) && chartX <= Math.min(scrollLeft + plotLeft + box.width, xAxis.pos + xAxis.len))) {
              e2.isInsidePlot = false;
            }
          }
          if (!options.ignoreY && e2.isInsidePlot) {
            var yAxis = series && (inverted ? series.xAxis : series.yAxis) || {
              pos: plotTop,
              len: Infinity
            };
            var chartY = options.paneCoordinates ? yAxis.pos + y : plotTop + y;
            if (!(chartY >= Math.max(scrollTop + plotTop, yAxis.pos) && chartY <= Math.min(scrollTop + plotTop + box.height, yAxis.pos + yAxis.len))) {
              e2.isInsidePlot = false;
            }
          }
          fireEvent$s(this, "afterIsInsidePlot", e2);
          return e2.isInsidePlot;
        };
        Chart2.prototype.redraw = function(animation) {
          fireEvent$s(this, "beforeRedraw");
          var chart = this, axes = chart.hasCartesianSeries ? chart.axes : chart.colorAxis || [], series = chart.series, pointer = chart.pointer, legend = chart.legend, legendUserOptions = chart.userOptions.legend, renderer = chart.renderer, isHiddenChart = renderer.isHidden(), afterRedraw = [];
          var hasDirtyStacks, hasStackedSeries, i2, isDirtyBox = chart.isDirtyBox, redrawLegend = chart.isDirtyLegend, serie;
          if (chart.setResponsive) {
            chart.setResponsive(false);
          }
          setAnimation$3(chart.hasRendered ? animation : false, chart);
          if (isHiddenChart) {
            chart.temporaryDisplay();
          }
          chart.layOutTitles();
          i2 = series.length;
          while (i2--) {
            serie = series[i2];
            if (serie.options.stacking || serie.options.centerInCategory) {
              hasStackedSeries = true;
              if (serie.isDirty) {
                hasDirtyStacks = true;
                break;
              }
            }
          }
          if (hasDirtyStacks) {
            i2 = series.length;
            while (i2--) {
              serie = series[i2];
              if (serie.options.stacking) {
                serie.isDirty = true;
              }
            }
          }
          series.forEach(function(serie2) {
            if (serie2.isDirty) {
              if (serie2.options.legendType === "point") {
                if (typeof serie2.updateTotals === "function") {
                  serie2.updateTotals();
                }
                redrawLegend = true;
              } else if (legendUserOptions && (legendUserOptions.labelFormatter || legendUserOptions.labelFormat)) {
                redrawLegend = true;
              }
            }
            if (serie2.isDirtyData) {
              fireEvent$s(serie2, "updatedData");
            }
          });
          if (redrawLegend && legend && legend.options.enabled) {
            legend.render();
            chart.isDirtyLegend = false;
          }
          if (hasStackedSeries) {
            chart.getStacks();
          }
          axes.forEach(function(axis) {
            axis.updateNames();
            axis.setScale();
          });
          chart.getMargins();
          axes.forEach(function(axis) {
            if (axis.isDirty) {
              isDirtyBox = true;
            }
          });
          axes.forEach(function(axis) {
            var key = axis.min + "," + axis.max;
            if (axis.extKey !== key) {
              axis.extKey = key;
              afterRedraw.push(function() {
                fireEvent$s(axis, "afterSetExtremes", extend$1h(axis.eventArgs, axis.getExtremes()));
                delete axis.eventArgs;
              });
            }
            if (isDirtyBox || hasStackedSeries) {
              axis.redraw();
            }
          });
          if (isDirtyBox) {
            chart.drawChartBox();
          }
          fireEvent$s(chart, "predraw");
          series.forEach(function(serie2) {
            if ((isDirtyBox || serie2.isDirty) && serie2.visible) {
              serie2.redraw();
            }
            serie2.isDirtyData = false;
          });
          if (pointer) {
            pointer.reset(true);
          }
          renderer.draw();
          fireEvent$s(chart, "redraw");
          fireEvent$s(chart, "render");
          if (isHiddenChart) {
            chart.temporaryDisplay(true);
          }
          afterRedraw.forEach(function(callback) {
            callback.call();
          });
        };
        Chart2.prototype.get = function(id) {
          var series = this.series;
          function itemById(item2) {
            return item2.id === id || item2.options && item2.options.id === id;
          }
          var ret = (
            // Search axes
            find$g(this.axes, itemById) || // Search series
            find$g(this.series, itemById)
          );
          for (var i2 = 0; !ret && i2 < series.length; i2++) {
            ret = find$g(series[i2].points || [], itemById);
          }
          return ret;
        };
        Chart2.prototype.getAxes = function() {
          var chart = this, options = this.options, xAxisOptions = options.xAxis = splat$d(options.xAxis || {}), yAxisOptions = options.yAxis = splat$d(options.yAxis || {});
          fireEvent$s(this, "getAxes");
          xAxisOptions.forEach(function(axis, i2) {
            axis.index = i2;
            axis.isX = true;
          });
          yAxisOptions.forEach(function(axis, i2) {
            axis.index = i2;
          });
          var optionsArray = xAxisOptions.concat(yAxisOptions);
          optionsArray.forEach(function(axisOptions) {
            new Axis(chart, axisOptions);
          });
          fireEvent$s(this, "afterGetAxes");
        };
        Chart2.prototype.getSelectedPoints = function() {
          return this.series.reduce(function(acc, series) {
            series.getPointsCollection().forEach(function(point) {
              if (pick$1h(point.selectedStaging, point.selected)) {
                acc.push(point);
              }
            });
            return acc;
          }, []);
        };
        Chart2.prototype.getSelectedSeries = function() {
          return this.series.filter(function(serie) {
            return serie.selected;
          });
        };
        Chart2.prototype.setTitle = function(titleOptions, subtitleOptions, redraw) {
          this.applyDescription("title", titleOptions);
          this.applyDescription("subtitle", subtitleOptions);
          this.applyDescription("caption", void 0);
          this.layOutTitles(redraw);
        };
        Chart2.prototype.applyDescription = function(name, explicitOptions) {
          var chart = this;
          var style = name === "title" ? {
            color: palette.neutralColor80,
            fontSize: this.options.isStock ? "16px" : "18px"
            // #2944
          } : {
            color: palette.neutralColor60
          };
          var options = this.options[name] = merge$1a(
            // Default styles
            !this.styledMode && { style },
            this.options[name],
            explicitOptions
          );
          var elem = this[name];
          if (elem && explicitOptions) {
            this[name] = elem = elem.destroy();
          }
          if (options && !elem) {
            elem = this.renderer.text(options.text, 0, 0, options.useHTML).attr({
              align: options.align,
              "class": "highcharts-" + name,
              zIndex: options.zIndex || 4
            }).add();
            elem.update = function(updateOptions) {
              var fn = {
                title: "setTitle",
                subtitle: "setSubtitle",
                caption: "setCaption"
              }[name];
              chart[fn](updateOptions);
            };
            if (!this.styledMode) {
              elem.css(options.style);
            }
            this[name] = elem;
          }
        };
        Chart2.prototype.layOutTitles = function(redraw) {
          var titleOffset = [0, 0, 0], renderer = this.renderer, spacingBox = this.spacingBox;
          ["title", "subtitle", "caption"].forEach(function(key) {
            var title = this[key], titleOptions = this.options[key], verticalAlign = titleOptions.verticalAlign || "top", offset2 = key === "title" ? verticalAlign === "top" ? -3 : 0 : (
              // Floating subtitle (#6574)
              verticalAlign === "top" ? titleOffset[0] + 2 : 0
            );
            var titleSize, height;
            if (title) {
              if (!this.styledMode) {
                titleSize = titleOptions.style && titleOptions.style.fontSize;
              }
              titleSize = renderer.fontMetrics(titleSize, title).b;
              title.css({
                width: (titleOptions.width || spacingBox.width + (titleOptions.widthAdjust || 0)) + "px"
              });
              height = Math.round(title.getBBox(titleOptions.useHTML).height);
              title.align(extend$1h({
                y: verticalAlign === "bottom" ? titleSize : offset2 + titleSize,
                height
              }, titleOptions), false, "spacingBox");
              if (!titleOptions.floating) {
                if (verticalAlign === "top") {
                  titleOffset[0] = Math.ceil(titleOffset[0] + height);
                } else if (verticalAlign === "bottom") {
                  titleOffset[2] = Math.ceil(titleOffset[2] + height);
                }
              }
            }
          }, this);
          if (titleOffset[0] && (this.options.title.verticalAlign || "top") === "top") {
            titleOffset[0] += this.options.title.margin;
          }
          if (titleOffset[2] && this.options.caption.verticalAlign === "bottom") {
            titleOffset[2] += this.options.caption.margin;
          }
          var requiresDirtyBox = !this.titleOffset || this.titleOffset.join(",") !== titleOffset.join(",");
          this.titleOffset = titleOffset;
          fireEvent$s(this, "afterLayOutTitles");
          if (!this.isDirtyBox && requiresDirtyBox) {
            this.isDirtyBox = this.isDirtyLegend = requiresDirtyBox;
            if (this.hasRendered && pick$1h(redraw, true) && this.isDirtyBox) {
              this.redraw();
            }
          }
        };
        Chart2.prototype.getChartSize = function() {
          var chart = this, optionsChart = chart.options.chart, widthOption = optionsChart.width, heightOption = optionsChart.height, renderTo = chart.renderTo;
          if (!defined$H(widthOption)) {
            chart.containerWidth = getStyle(renderTo, "width");
          }
          if (!defined$H(heightOption)) {
            chart.containerHeight = getStyle(renderTo, "height");
          }
          chart.chartWidth = Math.max(
            // #1393
            0,
            widthOption || chart.containerWidth || 600
            // #1460
          );
          chart.chartHeight = Math.max(0, relativeLength$7(heightOption, chart.chartWidth) || (chart.containerHeight > 1 ? chart.containerHeight : 400));
        };
        Chart2.prototype.temporaryDisplay = function(revert) {
          var node = this.renderTo, tempStyle;
          if (!revert) {
            while (node && node.style) {
              if (!doc$g.body.contains(node) && !node.parentNode) {
                node.hcOrigDetached = true;
                doc$g.body.appendChild(node);
              }
              if (getStyle(node, "display", false) === "none" || node.hcOricDetached) {
                node.hcOrigStyle = {
                  display: node.style.display,
                  height: node.style.height,
                  overflow: node.style.overflow
                };
                tempStyle = {
                  display: "block",
                  overflow: "hidden"
                };
                if (node !== this.renderTo) {
                  tempStyle.height = 0;
                }
                css$5(node, tempStyle);
                if (!node.offsetWidth) {
                  node.style.setProperty("display", "block", "important");
                }
              }
              node = node.parentNode;
              if (node === doc$g.body) {
                break;
              }
            }
          } else {
            while (node && node.style) {
              if (node.hcOrigStyle) {
                css$5(node, node.hcOrigStyle);
                delete node.hcOrigStyle;
              }
              if (node.hcOrigDetached) {
                doc$g.body.removeChild(node);
                node.hcOrigDetached = false;
              }
              node = node.parentNode;
            }
          }
        };
        Chart2.prototype.setClassName = function(className) {
          this.container.className = "highcharts-container " + (className || "");
        };
        Chart2.prototype.getContainer = function() {
          var chart = this, options = chart.options, optionsChart = options.chart, indexAttrName = "data-highcharts-chart", containerId = uniqueKey$4();
          var containerStyle, renderTo = chart.renderTo;
          if (!renderTo) {
            chart.renderTo = renderTo = optionsChart.renderTo;
          }
          if (isString$5(renderTo)) {
            chart.renderTo = renderTo = doc$g.getElementById(renderTo);
          }
          if (!renderTo) {
            error$5(13, true, chart);
          }
          var oldChartIndex = pInt$4(attr$1(renderTo, indexAttrName));
          if (isNumber$B(oldChartIndex) && charts$1[oldChartIndex] && charts$1[oldChartIndex].hasRendered) {
            charts$1[oldChartIndex].destroy();
          }
          attr$1(renderTo, indexAttrName, chart.index);
          renderTo.innerHTML = "";
          if (!optionsChart.skipClone && !renderTo.offsetWidth) {
            chart.temporaryDisplay();
          }
          chart.getChartSize();
          var chartWidth = chart.chartWidth;
          var chartHeight = chart.chartHeight;
          css$5(renderTo, { overflow: "hidden" });
          if (!chart.styledMode) {
            containerStyle = extend$1h({
              position: "relative",
              // needed for context menu (avoidscrollbars) and content
              // overflow in IE
              overflow: "hidden",
              width: chartWidth + "px",
              height: chartHeight + "px",
              textAlign: "left",
              lineHeight: "normal",
              zIndex: 0,
              "-webkit-tap-highlight-color": "rgba(0,0,0,0)",
              userSelect: "none",
              "touch-action": "manipulation",
              outline: "none"
            }, optionsChart.style || {});
          }
          var container = createElement$5("div", {
            id: containerId
          }, containerStyle, renderTo);
          chart.container = container;
          chart._cursor = container.style.cursor;
          var Renderer2 = optionsChart.renderer || !svg$3 ? RendererRegistry$1.getRendererType(optionsChart.renderer) : SVGRenderer;
          chart.renderer = new Renderer2(container, chartWidth, chartHeight, void 0, optionsChart.forExport, options.exporting && options.exporting.allowHTML, chart.styledMode);
          setAnimation$3(void 0, chart);
          chart.setClassName(optionsChart.className);
          if (!chart.styledMode) {
            chart.renderer.setStyle(optionsChart.style);
          } else {
            for (var key in options.defs) {
              this.renderer.definition(options.defs[key]);
            }
          }
          chart.renderer.chartIndex = chart.index;
          fireEvent$s(this, "afterGetContainer");
        };
        Chart2.prototype.getMargins = function(skipAxes) {
          var _a3 = this, spacing = _a3.spacing, margin = _a3.margin, titleOffset = _a3.titleOffset;
          this.resetMargins();
          if (titleOffset[0] && !defined$H(margin[0])) {
            this.plotTop = Math.max(this.plotTop, titleOffset[0] + spacing[0]);
          }
          if (titleOffset[2] && !defined$H(margin[2])) {
            this.marginBottom = Math.max(this.marginBottom, titleOffset[2] + spacing[2]);
          }
          if (this.legend && this.legend.display) {
            this.legend.adjustMargins(margin, spacing);
          }
          fireEvent$s(this, "getMargins");
          if (!skipAxes) {
            this.getAxisMargins();
          }
        };
        Chart2.prototype.getAxisMargins = function() {
          var chart = this, axisOffset = chart.axisOffset = [0, 0, 0, 0], colorAxis = chart.colorAxis, margin = chart.margin, getOffset = function(axes) {
            axes.forEach(function(axis) {
              if (axis.visible) {
                axis.getOffset();
              }
            });
          };
          if (chart.hasCartesianSeries) {
            getOffset(chart.axes);
          } else if (colorAxis && colorAxis.length) {
            getOffset(colorAxis);
          }
          marginNames.forEach(function(m2, side) {
            if (!defined$H(margin[side])) {
              chart[m2] += axisOffset[side];
            }
          });
          chart.setChartSize();
        };
        Chart2.prototype.reflow = function(e2) {
          var chart = this, optionsChart = chart.options.chart, renderTo = chart.renderTo, hasUserSize = defined$H(optionsChart.width) && defined$H(optionsChart.height), width = optionsChart.width || getStyle(renderTo, "width"), height = optionsChart.height || getStyle(renderTo, "height"), target = e2 ? e2.target : win$8;
          delete chart.pointer.chartPosition;
          if (!hasUserSize && !chart.isPrinting && width && height && (target === win$8 || target === doc$g)) {
            if (width !== chart.containerWidth || height !== chart.containerHeight) {
              Utilities.clearTimeout(chart.reflowTimeout);
              chart.reflowTimeout = syncTimeout$3(function() {
                if (chart.container) {
                  chart.setSize(void 0, void 0, false);
                }
              }, e2 ? 100 : 0);
            }
            chart.containerWidth = width;
            chart.containerHeight = height;
          }
        };
        Chart2.prototype.setReflow = function(reflow) {
          var chart = this;
          if (reflow !== false && !this.unbindReflow) {
            this.unbindReflow = addEvent$T(win$8, "resize", function(e2) {
              if (chart.options) {
                chart.reflow(e2);
              }
            });
            addEvent$T(this, "destroy", this.unbindReflow);
          } else if (reflow === false && this.unbindReflow) {
            this.unbindReflow = this.unbindReflow();
          }
        };
        Chart2.prototype.setSize = function(width, height, animation) {
          var chart = this, renderer = chart.renderer;
          chart.isResizing += 1;
          setAnimation$3(animation, chart);
          var globalAnimation = renderer.globalAnimation;
          chart.oldChartHeight = chart.chartHeight;
          chart.oldChartWidth = chart.chartWidth;
          if (typeof width !== "undefined") {
            chart.options.chart.width = width;
          }
          if (typeof height !== "undefined") {
            chart.options.chart.height = height;
          }
          chart.getChartSize();
          if (!chart.styledMode) {
            (globalAnimation ? animate : css$5)(chart.container, {
              width: chart.chartWidth + "px",
              height: chart.chartHeight + "px"
            }, globalAnimation);
          }
          chart.setChartSize(true);
          renderer.setSize(chart.chartWidth, chart.chartHeight, globalAnimation);
          chart.axes.forEach(function(axis) {
            axis.isDirty = true;
            axis.setScale();
          });
          chart.isDirtyLegend = true;
          chart.isDirtyBox = true;
          chart.layOutTitles();
          chart.getMargins();
          chart.redraw(globalAnimation);
          chart.oldChartHeight = null;
          fireEvent$s(chart, "resize");
          syncTimeout$3(function() {
            if (chart) {
              fireEvent$s(chart, "endResize", null, function() {
                chart.isResizing -= 1;
              });
            }
          }, animObject$7(globalAnimation).duration);
        };
        Chart2.prototype.setChartSize = function(skipAxes) {
          var chart = this, inverted = chart.inverted, renderer = chart.renderer, chartWidth = chart.chartWidth, chartHeight = chart.chartHeight, optionsChart = chart.options.chart, spacing = chart.spacing, clipOffset = chart.clipOffset;
          var plotLeft, plotTop, plotWidth, plotHeight;
          chart.plotLeft = plotLeft = Math.round(chart.plotLeft);
          chart.plotTop = plotTop = Math.round(chart.plotTop);
          chart.plotWidth = plotWidth = Math.max(0, Math.round(chartWidth - plotLeft - chart.marginRight));
          chart.plotHeight = plotHeight = Math.max(0, Math.round(chartHeight - plotTop - chart.marginBottom));
          chart.plotSizeX = inverted ? plotHeight : plotWidth;
          chart.plotSizeY = inverted ? plotWidth : plotHeight;
          chart.plotBorderWidth = optionsChart.plotBorderWidth || 0;
          chart.spacingBox = renderer.spacingBox = {
            x: spacing[3],
            y: spacing[0],
            width: chartWidth - spacing[3] - spacing[1],
            height: chartHeight - spacing[0] - spacing[2]
          };
          chart.plotBox = renderer.plotBox = {
            x: plotLeft,
            y: plotTop,
            width: plotWidth,
            height: plotHeight
          };
          var plotBorderWidth = 2 * Math.floor(chart.plotBorderWidth / 2), clipX = Math.ceil(Math.max(plotBorderWidth, clipOffset[3]) / 2), clipY = Math.ceil(Math.max(plotBorderWidth, clipOffset[0]) / 2);
          chart.clipBox = {
            x: clipX,
            y: clipY,
            width: Math.floor(chart.plotSizeX - Math.max(plotBorderWidth, clipOffset[1]) / 2 - clipX),
            height: Math.max(0, Math.floor(chart.plotSizeY - Math.max(plotBorderWidth, clipOffset[2]) / 2 - clipY))
          };
          if (!skipAxes) {
            chart.axes.forEach(function(axis) {
              axis.setAxisSize();
              axis.setAxisTranslation();
            });
            renderer.alignElements();
          }
          fireEvent$s(chart, "afterSetChartSize", { skipAxes });
        };
        Chart2.prototype.resetMargins = function() {
          fireEvent$s(this, "resetMargins");
          var chart = this, chartOptions = chart.options.chart;
          ["margin", "spacing"].forEach(function splashArrays(target) {
            var value = chartOptions[target], values = isObject$9(value) ? value : [value, value, value, value];
            [
              "Top",
              "Right",
              "Bottom",
              "Left"
            ].forEach(function(sideName, side) {
              chart[target][side] = pick$1h(chartOptions[target + sideName], values[side]);
            });
          });
          marginNames.forEach(function(m2, side) {
            chart[m2] = pick$1h(chart.margin[side], chart.spacing[side]);
          });
          chart.axisOffset = [0, 0, 0, 0];
          chart.clipOffset = [0, 0, 0, 0];
        };
        Chart2.prototype.drawChartBox = function() {
          var chart = this, optionsChart = chart.options.chart, renderer = chart.renderer, chartWidth = chart.chartWidth, chartHeight = chart.chartHeight, styledMode = chart.styledMode, plotBGImage = chart.plotBGImage, chartBackgroundColor = optionsChart.backgroundColor, plotBackgroundColor = optionsChart.plotBackgroundColor, plotBackgroundImage = optionsChart.plotBackgroundImage, plotLeft = chart.plotLeft, plotTop = chart.plotTop, plotWidth = chart.plotWidth, plotHeight = chart.plotHeight, plotBox = chart.plotBox, clipRect = chart.clipRect, clipBox = chart.clipBox;
          var chartBackground = chart.chartBackground, plotBackground = chart.plotBackground, plotBorder = chart.plotBorder, chartBorderWidth, mgn, bgAttr, verb = "animate";
          if (!chartBackground) {
            chart.chartBackground = chartBackground = renderer.rect().addClass("highcharts-background").add();
            verb = "attr";
          }
          if (!styledMode) {
            chartBorderWidth = optionsChart.borderWidth || 0;
            mgn = chartBorderWidth + (optionsChart.shadow ? 8 : 0);
            bgAttr = {
              fill: chartBackgroundColor || "none"
            };
            if (chartBorderWidth || chartBackground["stroke-width"]) {
              bgAttr.stroke = optionsChart.borderColor;
              bgAttr["stroke-width"] = chartBorderWidth;
            }
            chartBackground.attr(bgAttr).shadow(optionsChart.shadow);
          } else {
            chartBorderWidth = mgn = chartBackground.strokeWidth();
          }
          chartBackground[verb]({
            x: mgn / 2,
            y: mgn / 2,
            width: chartWidth - mgn - chartBorderWidth % 2,
            height: chartHeight - mgn - chartBorderWidth % 2,
            r: optionsChart.borderRadius
          });
          verb = "animate";
          if (!plotBackground) {
            verb = "attr";
            chart.plotBackground = plotBackground = renderer.rect().addClass("highcharts-plot-background").add();
          }
          plotBackground[verb](plotBox);
          if (!styledMode) {
            plotBackground.attr({
              fill: plotBackgroundColor || "none"
            }).shadow(optionsChart.plotShadow);
            if (plotBackgroundImage) {
              if (!plotBGImage) {
                chart.plotBGImage = renderer.image(plotBackgroundImage, plotLeft, plotTop, plotWidth, plotHeight).add();
              } else {
                if (plotBackgroundImage !== plotBGImage.attr("href")) {
                  plotBGImage.attr("href", plotBackgroundImage);
                }
                plotBGImage.animate(plotBox);
              }
            }
          }
          if (!clipRect) {
            chart.clipRect = renderer.clipRect(clipBox);
          } else {
            clipRect.animate({
              width: clipBox.width,
              height: clipBox.height
            });
          }
          verb = "animate";
          if (!plotBorder) {
            verb = "attr";
            chart.plotBorder = plotBorder = renderer.rect().addClass("highcharts-plot-border").attr({
              zIndex: 1
              // Above the grid
            }).add();
          }
          if (!styledMode) {
            plotBorder.attr({
              stroke: optionsChart.plotBorderColor,
              "stroke-width": optionsChart.plotBorderWidth || 0,
              fill: "none"
            });
          }
          plotBorder[verb](plotBorder.crisp({
            x: plotLeft,
            y: plotTop,
            width: plotWidth,
            height: plotHeight
          }, -plotBorder.strokeWidth()));
          chart.isDirtyBox = false;
          fireEvent$s(this, "afterDrawChartBox");
        };
        Chart2.prototype.propFromSeries = function() {
          var chart = this, optionsChart = chart.options.chart, seriesOptions = chart.options.series;
          var i2, klass, value;
          ["inverted", "angular", "polar"].forEach(function(key) {
            klass = seriesTypes$7[optionsChart.type || optionsChart.defaultSeriesType];
            value = // It is set in the options:
            optionsChart[key] || // The default series class:
            klass && klass.prototype[key];
            i2 = seriesOptions && seriesOptions.length;
            while (!value && i2--) {
              klass = seriesTypes$7[seriesOptions[i2].type];
              if (klass && klass.prototype[key]) {
                value = true;
              }
            }
            chart[key] = value;
          });
        };
        Chart2.prototype.linkSeries = function() {
          var chart = this, chartSeries = chart.series;
          chartSeries.forEach(function(series) {
            series.linkedSeries.length = 0;
          });
          chartSeries.forEach(function(series) {
            var linkedTo = series.options.linkedTo;
            if (isString$5(linkedTo)) {
              if (linkedTo === ":previous") {
                linkedTo = chart.series[series.index - 1];
              } else {
                linkedTo = chart.get(linkedTo);
              }
              if (linkedTo && linkedTo.linkedParent !== series) {
                linkedTo.linkedSeries.push(series);
                series.linkedParent = linkedTo;
                if (linkedTo.enabledDataSorting) {
                  series.setDataSortingOptions();
                }
                series.visible = pick$1h(series.options.visible, linkedTo.options.visible, series.visible);
              }
            }
          });
          fireEvent$s(this, "afterLinkSeries");
        };
        Chart2.prototype.renderSeries = function() {
          this.series.forEach(function(serie) {
            serie.translate();
            serie.render();
          });
        };
        Chart2.prototype.renderLabels = function() {
          var chart = this, labels = chart.options.labels;
          if (labels.items) {
            labels.items.forEach(function(label) {
              var style = extend$1h(labels.style, label.style), x = pInt$4(style.left) + chart.plotLeft, y = pInt$4(style.top) + chart.plotTop + 12;
              delete style.left;
              delete style.top;
              chart.renderer.text(label.html, x, y).attr({ zIndex: 2 }).css(style).add();
            });
          }
        };
        Chart2.prototype.render = function() {
          var chart = this, axes = chart.axes, colorAxis = chart.colorAxis, renderer = chart.renderer, options = chart.options, renderAxes = function(axes2) {
            axes2.forEach(function(axis) {
              if (axis.visible) {
                axis.render();
              }
            });
          };
          var correction = 0;
          chart.setTitle();
          chart.legend = new Legend(chart, options.legend);
          if (chart.getStacks) {
            chart.getStacks();
          }
          chart.getMargins(true);
          chart.setChartSize();
          var tempWidth = chart.plotWidth;
          axes.some(function(axis) {
            if (axis.horiz && axis.visible && axis.options.labels.enabled && axis.series.length) {
              correction = 21;
              return true;
            }
          });
          chart.plotHeight = Math.max(chart.plotHeight - correction, 0);
          var tempHeight = chart.plotHeight;
          axes.forEach(function(axis) {
            axis.setScale();
          });
          chart.getAxisMargins();
          var redoHorizontal = tempWidth / chart.plotWidth > 1.1;
          var redoVertical = tempHeight / chart.plotHeight > 1.05;
          if (redoHorizontal || redoVertical) {
            axes.forEach(function(axis) {
              if (axis.horiz && redoHorizontal || !axis.horiz && redoVertical) {
                axis.setTickInterval(true);
              }
            });
            chart.getMargins();
          }
          chart.drawChartBox();
          if (chart.hasCartesianSeries) {
            renderAxes(axes);
          } else if (colorAxis && colorAxis.length) {
            renderAxes(colorAxis);
          }
          if (!chart.seriesGroup) {
            chart.seriesGroup = renderer.g("series-group").attr({ zIndex: 3 }).add();
          }
          chart.renderSeries();
          chart.renderLabels();
          chart.addCredits();
          if (chart.setResponsive) {
            chart.setResponsive();
          }
          chart.hasRendered = true;
        };
        Chart2.prototype.addCredits = function(credits) {
          var chart = this, creds = merge$1a(true, this.options.credits, credits);
          if (creds.enabled && !this.credits) {
            this.credits = this.renderer.text(creds.text + (this.mapCredits || ""), 0, 0).addClass("highcharts-credits").on("click", function() {
              if (creds.href) {
                win$8.location.href = creds.href;
              }
            }).attr({
              align: creds.position.align,
              zIndex: 8
            });
            if (!chart.styledMode) {
              this.credits.css(creds.style);
            }
            this.credits.add().align(creds.position);
            this.credits.update = function(options) {
              chart.credits = chart.credits.destroy();
              chart.addCredits(options);
            };
          }
        };
        Chart2.prototype.destroy = function() {
          var chart = this, axes = chart.axes, series = chart.series, container = chart.container, parentNode = container && container.parentNode;
          var i2;
          fireEvent$s(chart, "destroy");
          if (chart.renderer.forExport) {
            erase$3(charts$1, chart);
          } else {
            charts$1[chart.index] = void 0;
          }
          H.chartCount--;
          chart.renderTo.removeAttribute("data-highcharts-chart");
          removeEvent$6(chart);
          i2 = axes.length;
          while (i2--) {
            axes[i2] = axes[i2].destroy();
          }
          if (this.scroller && this.scroller.destroy) {
            this.scroller.destroy();
          }
          i2 = series.length;
          while (i2--) {
            series[i2] = series[i2].destroy();
          }
          [
            "title",
            "subtitle",
            "chartBackground",
            "plotBackground",
            "plotBGImage",
            "plotBorder",
            "seriesGroup",
            "clipRect",
            "credits",
            "pointer",
            "rangeSelector",
            "legend",
            "resetZoomButton",
            "tooltip",
            "renderer"
          ].forEach(function(name) {
            var prop = chart[name];
            if (prop && prop.destroy) {
              chart[name] = prop.destroy();
            }
          });
          if (container) {
            container.innerHTML = "";
            removeEvent$6(container);
            if (parentNode) {
              discardElement$3(container);
            }
          }
          objectEach$n(chart, function(val, key) {
            delete chart[key];
          });
        };
        Chart2.prototype.firstRender = function() {
          var chart = this, options = chart.options;
          if (chart.isReadyToRender && !chart.isReadyToRender()) {
            return;
          }
          chart.getContainer();
          chart.resetMargins();
          chart.setChartSize();
          chart.propFromSeries();
          chart.getAxes();
          (isArray$g(options.series) ? options.series : []).forEach(
            // #9680
            function(serieOptions) {
              chart.initSeries(serieOptions);
            }
          );
          chart.linkSeries();
          chart.setSeriesData();
          fireEvent$s(chart, "beforeRender");
          if (Pointer) {
            if (MSPointer.isRequired()) {
              chart.pointer = new MSPointer(chart, options);
            } else {
              chart.pointer = new Pointer(chart, options);
            }
          }
          chart.render();
          chart.pointer.getChartPosition();
          if (!chart.renderer.imgCount && !chart.hasLoaded) {
            chart.onload();
          }
          chart.temporaryDisplay(true);
        };
        Chart2.prototype.onload = function() {
          this.callbacks.concat([this.callback]).forEach(function(fn) {
            if (fn && typeof this.index !== "undefined") {
              fn.apply(this, [this]);
            }
          }, this);
          fireEvent$s(this, "load");
          fireEvent$s(this, "render");
          if (defined$H(this.index)) {
            this.setReflow(this.options.chart.reflow);
          }
          this.hasLoaded = true;
        };
        Chart2.prototype.addSeries = function(options, redraw, animation) {
          var chart = this;
          var series;
          if (options) {
            redraw = pick$1h(redraw, true);
            fireEvent$s(chart, "addSeries", { options }, function() {
              series = chart.initSeries(options);
              chart.isDirtyLegend = true;
              chart.linkSeries();
              if (series.enabledDataSorting) {
                series.setData(options.data, false);
              }
              fireEvent$s(chart, "afterAddSeries", { series });
              if (redraw) {
                chart.redraw(animation);
              }
            });
          }
          return series;
        };
        Chart2.prototype.addAxis = function(options, isX, redraw, animation) {
          return this.createAxis(isX ? "xAxis" : "yAxis", { axis: options, redraw, animation });
        };
        Chart2.prototype.addColorAxis = function(options, redraw, animation) {
          return this.createAxis("colorAxis", { axis: options, redraw, animation });
        };
        Chart2.prototype.createAxis = function(type, options) {
          var axis = new Axis(this, merge$1a(options.axis, {
            index: this[type].length,
            isX: type === "xAxis"
          }));
          if (pick$1h(options.redraw, true)) {
            this.redraw(options.animation);
          }
          return axis;
        };
        Chart2.prototype.showLoading = function(str) {
          var chart = this, options = chart.options, loadingOptions = options.loading, setLoadingSize = function() {
            if (loadingDiv) {
              css$5(loadingDiv, {
                left: chart.plotLeft + "px",
                top: chart.plotTop + "px",
                width: chart.plotWidth + "px",
                height: chart.plotHeight + "px"
              });
            }
          };
          var loadingDiv = chart.loadingDiv, loadingSpan = chart.loadingSpan;
          if (!loadingDiv) {
            chart.loadingDiv = loadingDiv = createElement$5("div", {
              className: "highcharts-loading highcharts-loading-hidden"
            }, null, chart.container);
          }
          if (!loadingSpan) {
            chart.loadingSpan = loadingSpan = createElement$5("span", { className: "highcharts-loading-inner" }, null, loadingDiv);
            addEvent$T(chart, "redraw", setLoadingSize);
          }
          loadingDiv.className = "highcharts-loading";
          AST.setElementHTML(loadingSpan, pick$1h(str, options.lang.loading, ""));
          if (!chart.styledMode) {
            css$5(loadingDiv, extend$1h(loadingOptions.style, {
              zIndex: 10
            }));
            css$5(loadingSpan, loadingOptions.labelStyle);
            if (!chart.loadingShown) {
              css$5(loadingDiv, {
                opacity: 0,
                display: ""
              });
              animate(loadingDiv, {
                opacity: loadingOptions.style.opacity || 0.5
              }, {
                duration: loadingOptions.showDuration || 0
              });
            }
          }
          chart.loadingShown = true;
          setLoadingSize();
        };
        Chart2.prototype.hideLoading = function() {
          var options = this.options, loadingDiv = this.loadingDiv;
          if (loadingDiv) {
            loadingDiv.className = "highcharts-loading highcharts-loading-hidden";
            if (!this.styledMode) {
              animate(loadingDiv, {
                opacity: 0
              }, {
                duration: options.loading.hideDuration || 100,
                complete: function() {
                  css$5(loadingDiv, { display: "none" });
                }
              });
            }
          }
          this.loadingShown = false;
        };
        Chart2.prototype.update = function(options, redraw, oneToOne, animation) {
          var chart = this, adders = {
            credits: "addCredits",
            title: "setTitle",
            subtitle: "setSubtitle",
            caption: "setCaption"
          }, isResponsiveOptions = options.isResponsiveOptions, itemsForRemoval = [];
          var updateAllAxes, updateAllSeries, runSetSize;
          fireEvent$s(chart, "update", { options });
          if (!isResponsiveOptions) {
            chart.setResponsive(false, true);
          }
          options = cleanRecursively$1(options, chart.options);
          chart.userOptions = merge$1a(chart.userOptions, options);
          var optionsChart = options.chart;
          if (optionsChart) {
            merge$1a(true, chart.options.chart, optionsChart);
            if ("className" in optionsChart) {
              chart.setClassName(optionsChart.className);
            }
            if ("reflow" in optionsChart) {
              chart.setReflow(optionsChart.reflow);
            }
            if ("inverted" in optionsChart || "polar" in optionsChart || "type" in optionsChart) {
              chart.propFromSeries();
              updateAllAxes = true;
            }
            if ("alignTicks" in optionsChart) {
              updateAllAxes = true;
            }
            if ("events" in optionsChart) {
              registerEventOptions$1(this, optionsChart);
            }
            objectEach$n(optionsChart, function(val, key) {
              if (chart.propsRequireUpdateSeries.indexOf("chart." + key) !== -1) {
                updateAllSeries = true;
              }
              if (chart.propsRequireDirtyBox.indexOf(key) !== -1) {
                chart.isDirtyBox = true;
              }
              if (chart.propsRequireReflow.indexOf(key) !== -1) {
                if (isResponsiveOptions) {
                  chart.isDirtyBox = true;
                } else {
                  runSetSize = true;
                }
              }
            });
            if (!chart.styledMode && optionsChart.style) {
              chart.renderer.setStyle(chart.options.chart.style || {});
            }
          }
          if (!chart.styledMode && options.colors) {
            this.options.colors = options.colors;
          }
          if (options.time) {
            if (this.time === defaultTime) {
              this.time = new Time(options.time);
            }
            merge$1a(true, chart.options.time, options.time);
          }
          objectEach$n(options, function(val, key) {
            if (chart[key] && typeof chart[key].update === "function") {
              chart[key].update(val, false);
            } else if (typeof chart[adders[key]] === "function") {
              chart[adders[key]](val);
            } else if (key !== "colors" && chart.collectionsWithUpdate.indexOf(key) === -1) {
              merge$1a(true, chart.options[key], options[key]);
            }
            if (key !== "chart" && chart.propsRequireUpdateSeries.indexOf(key) !== -1) {
              updateAllSeries = true;
            }
          });
          this.collectionsWithUpdate.forEach(function(coll) {
            var indexMap;
            if (options[coll]) {
              indexMap = [];
              chart[coll].forEach(function(s2, i2) {
                if (!s2.options.isInternal) {
                  indexMap.push(pick$1h(s2.options.index, i2));
                }
              });
              splat$d(options[coll]).forEach(function(newOptions, i2) {
                var hasId = defined$H(newOptions.id);
                var item2;
                if (hasId) {
                  item2 = chart.get(newOptions.id);
                }
                if (!item2 && chart[coll]) {
                  item2 = chart[coll][indexMap ? indexMap[i2] : i2];
                  if (item2 && hasId && defined$H(item2.options.id)) {
                    item2 = void 0;
                  }
                }
                if (item2 && item2.coll === coll) {
                  item2.update(newOptions, false);
                  if (oneToOne) {
                    item2.touched = true;
                  }
                }
                if (!item2 && oneToOne && chart.collectionsWithInit[coll]) {
                  chart.collectionsWithInit[coll][0].apply(
                    chart,
                    // [newOptions, ...extraArguments, redraw=false]
                    [
                      newOptions
                    ].concat(
                      // Not all initializers require extra args
                      chart.collectionsWithInit[coll][1] || []
                    ).concat([
                      false
                    ])
                  ).touched = true;
                }
              });
              if (oneToOne) {
                chart[coll].forEach(function(item2) {
                  if (!item2.touched && !item2.options.isInternal) {
                    itemsForRemoval.push(item2);
                  } else {
                    delete item2.touched;
                  }
                });
              }
            }
          });
          itemsForRemoval.forEach(function(item2) {
            if (item2.chart && item2.remove) {
              item2.remove(false);
            }
          });
          if (updateAllAxes) {
            chart.axes.forEach(function(axis) {
              axis.update({}, false);
            });
          }
          if (updateAllSeries) {
            chart.getSeriesOrderByLinks().forEach(function(series) {
              if (series.chart) {
                series.update({}, false);
              }
            }, this);
          }
          var newWidth = optionsChart && optionsChart.width;
          var newHeight = optionsChart && (isString$5(optionsChart.height) ? relativeLength$7(optionsChart.height, newWidth || chart.chartWidth) : optionsChart.height);
          if (
            // In this case, run chart.setSize with newWidth and newHeight which
            // are undefined, only for reflowing chart elements because margin
            // or spacing has been set (#8190)
            runSetSize || // In this case, the size is actually set
            isNumber$B(newWidth) && newWidth !== chart.chartWidth || isNumber$B(newHeight) && newHeight !== chart.chartHeight
          ) {
            chart.setSize(newWidth, newHeight, animation);
          } else if (pick$1h(redraw, true)) {
            chart.redraw(animation);
          }
          fireEvent$s(chart, "afterUpdate", {
            options,
            redraw,
            animation
          });
        };
        Chart2.prototype.setSubtitle = function(options, redraw) {
          this.applyDescription("subtitle", options);
          this.layOutTitles(redraw);
        };
        Chart2.prototype.setCaption = function(options, redraw) {
          this.applyDescription("caption", options);
          this.layOutTitles(redraw);
        };
        Chart2.prototype.showResetZoom = function() {
          var chart = this, lang2 = defaultOptions$b.lang, btnOptions = chart.options.chart.resetZoomButton, theme2 = btnOptions.theme, states = theme2.states, alignTo = btnOptions.relativeTo === "chart" || btnOptions.relativeTo === "spacingBox" ? null : "scrollablePlotBox";
          function zoomOut() {
            chart.zoomOut();
          }
          fireEvent$s(this, "beforeShowResetZoom", null, function() {
            chart.resetZoomButton = chart.renderer.button(lang2.resetZoom, null, null, zoomOut, theme2, states && states.hover).attr({
              align: btnOptions.position.align,
              title: lang2.resetZoomTitle
            }).addClass("highcharts-reset-zoom").add().align(btnOptions.position, false, alignTo);
          });
          fireEvent$s(this, "afterShowResetZoom");
        };
        Chart2.prototype.zoomOut = function() {
          fireEvent$s(this, "selection", { resetSelection: true }, this.zoom);
        };
        Chart2.prototype.zoom = function(event) {
          var chart = this, pointer = chart.pointer, mouseDownPos = chart.inverted ? pointer.mouseDownX : pointer.mouseDownY;
          var displayButton = false, hasZoomed;
          if (!event || event.resetSelection) {
            chart.axes.forEach(function(axis) {
              hasZoomed = axis.zoom();
            });
            pointer.initiated = false;
          } else {
            event.xAxis.concat(event.yAxis).forEach(function(axisData) {
              var axis = axisData.axis, axisStartPos = chart.inverted ? axis.left : axis.top, axisEndPos = chart.inverted ? axisStartPos + axis.width : axisStartPos + axis.height, isXAxis = axis.isXAxis;
              var isWithinPane = false;
              if (!isXAxis && mouseDownPos >= axisStartPos && mouseDownPos <= axisEndPos || isXAxis || !defined$H(mouseDownPos)) {
                isWithinPane = true;
              }
              if (pointer[isXAxis ? "zoomX" : "zoomY"] && isWithinPane) {
                hasZoomed = axis.zoom(axisData.min, axisData.max);
                if (axis.displayBtn) {
                  displayButton = true;
                }
              }
            });
          }
          var resetZoomButton = chart.resetZoomButton;
          if (displayButton && !resetZoomButton) {
            chart.showResetZoom();
          } else if (!displayButton && isObject$9(resetZoomButton)) {
            chart.resetZoomButton = resetZoomButton.destroy();
          }
          if (hasZoomed) {
            chart.redraw(pick$1h(chart.options.chart.animation, event && event.animation, chart.pointCount < 100));
          }
        };
        Chart2.prototype.pan = function(e2, panning) {
          var chart = this, hoverPoints = chart.hoverPoints, panningOptions = typeof panning === "object" ? panning : {
            enabled: panning,
            type: "x"
          }, chartOptions = chart.options.chart, hasMapNavigation = chart.options.mapNavigation && chart.options.mapNavigation.enabled;
          if (chartOptions && chartOptions.panning) {
            chartOptions.panning = panningOptions;
          }
          var type = panningOptions.type;
          var doRedraw;
          fireEvent$s(this, "pan", { originalEvent: e2 }, function() {
            if (hoverPoints) {
              hoverPoints.forEach(function(point) {
                point.setState();
              });
            }
            var axes = chart.xAxis;
            if (type === "xy") {
              axes = axes.concat(chart.yAxis);
            } else if (type === "y") {
              axes = chart.yAxis;
            }
            var nextMousePos = {};
            axes.forEach(function(axis) {
              if (!axis.options.panningEnabled || axis.options.isInternal) {
                return;
              }
              var horiz = axis.horiz, mousePos = e2[horiz ? "chartX" : "chartY"], mouseDown = horiz ? "mouseDownX" : "mouseDownY", startPos = chart[mouseDown], halfPointRange = axis.minPointOffset || 0, pointRangeDirection = axis.reversed && !chart.inverted || !axis.reversed && chart.inverted ? -1 : 1, extremes = axis.getExtremes(), panMin = axis.toValue(startPos - mousePos, true) + halfPointRange * pointRangeDirection, panMax = axis.toValue(startPos + axis.len - mousePos, true) - (halfPointRange * pointRangeDirection || axis.isXAxis && axis.pointRangePadding || 0), flipped = panMax < panMin, hasVerticalPanning = axis.hasVerticalPanning();
              var newMin = flipped ? panMax : panMin, newMax = flipped ? panMin : panMax, panningState = axis.panningState, spill;
              if (hasVerticalPanning && !axis.isXAxis && (!panningState || panningState.isDirty)) {
                axis.series.forEach(function(series) {
                  var processedData = series.getProcessedData(true), dataExtremes = series.getExtremes(processedData.yData, true);
                  if (!panningState) {
                    panningState = {
                      startMin: Number.MAX_VALUE,
                      startMax: -Number.MAX_VALUE
                    };
                  }
                  if (isNumber$B(dataExtremes.dataMin) && isNumber$B(dataExtremes.dataMax)) {
                    panningState.startMin = Math.min(pick$1h(series.options.threshold, Infinity), dataExtremes.dataMin, panningState.startMin);
                    panningState.startMax = Math.max(pick$1h(series.options.threshold, -Infinity), dataExtremes.dataMax, panningState.startMax);
                  }
                });
              }
              var paddedMin = Math.min(pick$1h(panningState && panningState.startMin, extremes.dataMin), halfPointRange ? extremes.min : axis.toValue(axis.toPixels(extremes.min) - axis.minPixelPadding));
              var paddedMax = Math.max(pick$1h(panningState && panningState.startMax, extremes.dataMax), halfPointRange ? extremes.max : axis.toValue(axis.toPixels(extremes.max) + axis.minPixelPadding));
              axis.panningState = panningState;
              if (!axis.isOrdinal) {
                spill = paddedMin - newMin;
                if (spill > 0) {
                  newMax += spill;
                  newMin = paddedMin;
                }
                spill = newMax - paddedMax;
                if (spill > 0) {
                  newMax = paddedMax;
                  newMin -= spill;
                }
                if (axis.series.length && newMin !== extremes.min && newMax !== extremes.max && newMin >= paddedMin && newMax <= paddedMax) {
                  axis.setExtremes(newMin, newMax, false, false, { trigger: "pan" });
                  if (!chart.resetZoomButton && !hasMapNavigation && // Show reset zoom button only when both newMin and
                  // newMax values are between padded axis range.
                  newMin !== paddedMin && newMax !== paddedMax && type.match("y")) {
                    chart.showResetZoom();
                    axis.displayBtn = false;
                  }
                  doRedraw = true;
                }
                nextMousePos[mouseDown] = mousePos;
              }
            });
            objectEach$n(nextMousePos, function(pos, down) {
              chart[down] = pos;
            });
            if (doRedraw) {
              chart.redraw(false);
            }
            css$5(chart.container, { cursor: "move" });
          });
        };
        return Chart2;
      }()
    );
    extend$1h(Chart$1.prototype, {
      // Hook for adding callbacks in modules
      callbacks: [],
      /**
       * These collections (arrays) implement `Chart.addSomethig` method used in
       * chart.update() to create new object in the collection. Equivalent for
       * deleting is resolved by simple `Somethig.remove()`.
       *
       * Note: We need to define these references after initializers are bound to
       * chart's prototype.
       */
      collectionsWithInit: {
        // collectionName: [ initializingMethod, [extraArguments] ]
        xAxis: [Chart$1.prototype.addAxis, [true]],
        yAxis: [Chart$1.prototype.addAxis, [false]],
        series: [Chart$1.prototype.addSeries]
      },
      /**
       * These collections (arrays) implement update() methods with support for
       * one-to-one option.
       */
      collectionsWithUpdate: [
        "xAxis",
        "yAxis",
        "series"
      ],
      /**
       * These properties cause isDirtyBox to be set to true when updating. Can be
       * extended from plugins.
       */
      propsRequireDirtyBox: [
        "backgroundColor",
        "borderColor",
        "borderWidth",
        "borderRadius",
        "plotBackgroundColor",
        "plotBackgroundImage",
        "plotBorderColor",
        "plotBorderWidth",
        "plotShadow",
        "shadow"
      ],
      /**
       * These properties require a full reflow of chart elements, best
       * implemented through running `Chart.setSize` internally (#8190).
       * @type {Array}
       */
      propsRequireReflow: [
        "margin",
        "marginTop",
        "marginRight",
        "marginBottom",
        "marginLeft",
        "spacing",
        "spacingTop",
        "spacingRight",
        "spacingBottom",
        "spacingLeft"
      ],
      /**
       * These properties cause all series to be updated when updating. Can be
       * extended from plugins.
       */
      propsRequireUpdateSeries: [
        "chart.inverted",
        "chart.polar",
        "chart.ignoreHiddenSeries",
        "chart.type",
        "colors",
        "plotOptions",
        "time",
        "tooltip"
      ]
    });
    var merge$19 = Utilities.merge, pick$1g = Utilities.pick;
    var LegendSymbol;
    (function(LegendSymbol2) {
      function drawLineMarker(legend) {
        var options = this.options, symbolWidth = legend.symbolWidth, symbolHeight = legend.symbolHeight, generalRadius = symbolHeight / 2, renderer = this.chart.renderer, legendItemGroup = this.legendGroup, verticalCenter = legend.baseline - Math.round(legend.fontMetrics.b * 0.3);
        var attr2 = {}, legendSymbol, markerOptions = options.marker;
        if (!this.chart.styledMode) {
          attr2 = {
            "stroke-width": options.lineWidth || 0
          };
          if (options.dashStyle) {
            attr2.dashstyle = options.dashStyle;
          }
        }
        this.legendLine = renderer.path([
          ["M", 0, verticalCenter],
          ["L", symbolWidth, verticalCenter]
        ]).addClass("highcharts-graph").attr(attr2).add(legendItemGroup);
        if (markerOptions && markerOptions.enabled !== false && symbolWidth) {
          var radius = Math.min(pick$1g(markerOptions.radius, generalRadius), generalRadius);
          if (this.symbol.indexOf("url") === 0) {
            markerOptions = merge$19(markerOptions, {
              width: symbolHeight,
              height: symbolHeight
            });
            radius = 0;
          }
          this.legendSymbol = legendSymbol = renderer.symbol(this.symbol, symbolWidth / 2 - radius, verticalCenter - radius, 2 * radius, 2 * radius, markerOptions).addClass("highcharts-point").add(legendItemGroup);
          legendSymbol.isMarker = true;
        }
      }
      LegendSymbol2.drawLineMarker = drawLineMarker;
      function drawRectangle(legend, item2) {
        var options = legend.options, symbolHeight = legend.symbolHeight, square = options.squareSymbol, symbolWidth = square ? symbolHeight : legend.symbolWidth;
        item2.legendSymbol = this.chart.renderer.rect(
          square ? (legend.symbolWidth - symbolHeight) / 2 : 0,
          legend.baseline - symbolHeight + 1,
          // #3988
          symbolWidth,
          symbolHeight,
          pick$1g(legend.options.symbolRadius, symbolHeight / 2)
        ).addClass("highcharts-point").attr({
          zIndex: 3
        }).add(item2.legendGroup);
      }
      LegendSymbol2.drawRectangle = drawRectangle;
    })(LegendSymbol || (LegendSymbol = {}));
    const LegendSymbol$1 = LegendSymbol;
    var seriesDefaults = {
      // base series options
      /**
       * The SVG value used for the `stroke-linecap` and `stroke-linejoin`
       * of a line graph. Round means that lines are rounded in the ends and
       * bends.
       *
       * @type       {Highcharts.SeriesLinecapValue}
       * @default    round
       * @since      3.0.7
       * @apioption  plotOptions.line.linecap
       */
      /**
       * Pixel width of the graph line.
       *
       * @see In styled mode, the line stroke-width can be set with the
       *      `.highcharts-graph` class name.
       *
       * @sample {highcharts} highcharts/plotoptions/series-linewidth-general/
       *         On all series
       * @sample {highcharts} highcharts/plotoptions/series-linewidth-specific/
       *         On one single series
       *
       * @product highcharts highstock
       *
       * @private
       */
      lineWidth: 2,
      /**
       * For some series, there is a limit that shuts down initial animation
       * by default when the total number of points in the chart is too high.
       * For example, for a column chart and its derivatives, animation does
       * not run if there is more than 250 points totally. To disable this
       * cap, set `animationLimit` to `Infinity`.
       *
       * @type      {number}
       * @apioption plotOptions.series.animationLimit
       */
      /**
       * Allow this series' points to be selected by clicking on the graphic
       * (columns, point markers, pie slices, map areas etc).
       *
       * The selected points can be handled by point select and unselect
       * events, or collectively by the [getSelectedPoints
       * ](/class-reference/Highcharts.Chart#getSelectedPoints) function.
       *
       * And alternative way of selecting points is through dragging.
       *
       * @sample {highcharts} highcharts/plotoptions/series-allowpointselect-line/
       *         Line
       * @sample {highcharts} highcharts/plotoptions/series-allowpointselect-column/
       *         Column
       * @sample {highcharts} highcharts/plotoptions/series-allowpointselect-pie/
       *         Pie
       * @sample {highcharts} highcharts/chart/events-selection-points/
       *         Select a range of points through a drag selection
       * @sample {highmaps} maps/plotoptions/series-allowpointselect/
       *         Map area
       * @sample {highmaps} maps/plotoptions/mapbubble-allowpointselect/
       *         Map bubble
       *
       * @since 1.2.0
       *
       * @private
       */
      allowPointSelect: false,
      /**
       * When true, each point or column edge is rounded to its nearest pixel
       * in order to render sharp on screen. In some cases, when there are a
       * lot of densely packed columns, this leads to visible difference
       * in column widths or distance between columns. In these cases,
       * setting `crisp` to `false` may look better, even though each column
       * is rendered blurry.
       *
       * @sample {highcharts} highcharts/plotoptions/column-crisp-false/
       *         Crisp is false
       *
       * @since   5.0.10
       * @product highcharts highstock gantt
       *
       * @private
       */
      crisp: true,
      /**
       * If true, a checkbox is displayed next to the legend item to allow
       * selecting the series. The state of the checkbox is determined by
       * the `selected` option.
       *
       * @productdesc {highmaps}
       * Note that if a `colorAxis` is defined, the color axis is represented
       * in the legend, not the series.
       *
       * @sample {highcharts} highcharts/plotoptions/series-showcheckbox-true/
       *         Show select box
       *
       * @since 1.2.0
       *
       * @private
       */
      showCheckbox: false,
      /**
       * Enable or disable the initial animation when a series is displayed.
       * The animation can also be set as a configuration object. Please
       * note that this option only applies to the initial animation of the
       * series itself. For other animations, see [chart.animation](
       * #chart.animation) and the animation parameter under the API methods.
       * The following properties are supported:
       *
       * - `defer`: The animation delay time in milliseconds.
       *
       * - `duration`: The duration of the animation in milliseconds.
       *
       * - `easing`: Can be a string reference to an easing function set on
       *   the `Math` object or a function. See the _Custom easing function_
       *   demo below.
       *
       * Due to poor performance, animation is disabled in old IE browsers
       * for several chart types.
       *
       * @sample {highcharts} highcharts/plotoptions/series-animation-disabled/
       *         Animation disabled
       * @sample {highcharts} highcharts/plotoptions/series-animation-slower/
       *         Slower animation
       * @sample {highcharts} highcharts/plotoptions/series-animation-easing/
       *         Custom easing function
       * @sample {highstock} stock/plotoptions/animation-slower/
       *         Slower animation
       * @sample {highstock} stock/plotoptions/animation-easing/
       *         Custom easing function
       * @sample {highmaps} maps/plotoptions/series-animation-true/
       *         Animation enabled on map series
       * @sample {highmaps} maps/plotoptions/mapbubble-animation-false/
       *         Disabled on mapbubble series
       *
       * @type    {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @default {highcharts} true
       * @default {highstock} true
       * @default {highmaps} false
       *
       * @private
       */
      animation: {
        /** @internal */
        duration: 1e3
      },
      /**
       * @default   0
       * @type      {number}
       * @since     8.2.0
       * @apioption plotOptions.series.animation.defer
       */
      /**
       * An additional class name to apply to the series' graphical elements.
       * This option does not replace default class names of the graphical
       * element.
       *
       * @type      {string}
       * @since     5.0.0
       * @apioption plotOptions.series.className
       */
      /**
       * Disable this option to allow series rendering in the whole plotting
       * area.
       *
       * **Note:** Clipping should be always enabled when
       * [chart.zoomType](#chart.zoomType) is set
       *
       * @sample {highcharts} highcharts/plotoptions/series-clip/
       *         Disabled clipping
       *
       * @default   true
       * @type      {boolean}
       * @since     3.0.0
       * @apioption plotOptions.series.clip
       */
      /**
       * The main color of the series. In line type series it applies to the
       * line and the point markers unless otherwise specified. In bar type
       * series it applies to the bars unless a color is specified per point.
       * The default value is pulled from the `options.colors` array.
       *
       * In styled mode, the color can be defined by the
       * [colorIndex](#plotOptions.series.colorIndex) option. Also, the series
       * color can be set with the `.highcharts-series`,
       * `.highcharts-color-{n}`, `.highcharts-{type}-series` or
       * `.highcharts-series-{n}` class, or individual classes given by the
       * `className` option.
       *
       * @productdesc {highmaps}
       * In maps, the series color is rarely used, as most choropleth maps use
       * the color to denote the value of each point. The series color can
       * however be used in a map with multiple series holding categorized
       * data.
       *
       * @sample {highcharts} highcharts/plotoptions/series-color-general/
       *         General plot option
       * @sample {highcharts} highcharts/plotoptions/series-color-specific/
       *         One specific series
       * @sample {highcharts} highcharts/plotoptions/series-color-area/
       *         Area color
       * @sample {highcharts} highcharts/series/infographic/
       *         Pattern fill
       * @sample {highmaps} maps/demo/category-map/
       *         Category map by multiple series
       *
       * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @apioption plotOptions.series.color
       */
      /**
       * Styled mode only. A specific color index to use for the series, so
       * its graphic representations are given the class name
       * `highcharts-color-{n}`.
       *
       * @type      {number}
       * @since     5.0.0
       * @apioption plotOptions.series.colorIndex
       */
      /**
       * Whether to connect a graph line across null points, or render a gap
       * between the two points on either side of the null.
       *
       * @sample {highcharts} highcharts/plotoptions/series-connectnulls-false/
       *         False by default
       * @sample {highcharts} highcharts/plotoptions/series-connectnulls-true/
       *         True
       *
       * @type      {boolean}
       * @default   false
       * @product   highcharts highstock
       * @apioption plotOptions.series.connectNulls
       */
      /**
       * You can set the cursor to "pointer" if you have click events attached
       * to the series, to signal to the user that the points and lines can
       * be clicked.
       *
       * In styled mode, the series cursor can be set with the same classes
       * as listed under [series.color](#plotOptions.series.color).
       *
       * @sample {highcharts} highcharts/plotoptions/series-cursor-line/
       *         On line graph
       * @sample {highcharts} highcharts/plotoptions/series-cursor-column/
       *         On columns
       * @sample {highcharts} highcharts/plotoptions/series-cursor-scatter/
       *         On scatter markers
       * @sample {highstock} stock/plotoptions/cursor/
       *         Pointer on a line graph
       * @sample {highmaps} maps/plotoptions/series-allowpointselect/
       *         Map area
       * @sample {highmaps} maps/plotoptions/mapbubble-allowpointselect/
       *         Map bubble
       *
       * @type      {string|Highcharts.CursorValue}
       * @apioption plotOptions.series.cursor
       */
      /**
       * A reserved subspace to store options and values for customized
       * functionality. Here you can add additional data for your own event
       * callbacks and formatter callbacks.
       *
       * @sample {highcharts} highcharts/point/custom/
       *         Point and series with custom data
       *
       * @type      {Highcharts.Dictionary<*>}
       * @apioption plotOptions.series.custom
       */
      /**
       * Name of the dash style to use for the graph, or for some series types
       * the outline of each shape.
       *
       * In styled mode, the
       * [stroke dash-array](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/css/series-dashstyle/)
       * can be set with the same classes as listed under
       * [series.color](#plotOptions.series.color).
       *
       * @sample {highcharts} highcharts/plotoptions/series-dashstyle-all/
       *         Possible values demonstrated
       * @sample {highcharts} highcharts/plotoptions/series-dashstyle/
       *         Chart suitable for printing in black and white
       * @sample {highstock} highcharts/plotoptions/series-dashstyle-all/
       *         Possible values demonstrated
       * @sample {highmaps} highcharts/plotoptions/series-dashstyle-all/
       *         Possible values demonstrated
       * @sample {highmaps} maps/plotoptions/series-dashstyle/
       *         Dotted borders on a map
       *
       * @type      {Highcharts.DashStyleValue}
       * @default   Solid
       * @since     2.1
       * @apioption plotOptions.series.dashStyle
       */
      /**
       * A description of the series to add to the screen reader information
       * about the series.
       *
       * @type      {string}
       * @since     5.0.0
       * @requires  modules/accessibility
       * @apioption plotOptions.series.description
       */
      /**
       * Options for the series data sorting.
       *
       * @type      {Highcharts.DataSortingOptionsObject}
       * @since     8.0.0
       * @product   highcharts highstock
       * @apioption plotOptions.series.dataSorting
       */
      /**
       * Enable or disable data sorting for the series. Use [xAxis.reversed](
       * #xAxis.reversed) to change the sorting order.
       *
       * @sample {highcharts} highcharts/datasorting/animation/
       *         Data sorting in scatter-3d
       * @sample {highcharts} highcharts/datasorting/labels-animation/
       *         Axis labels animation
       * @sample {highcharts} highcharts/datasorting/dependent-sorting/
       *         Dependent series sorting
       * @sample {highcharts} highcharts/datasorting/independent-sorting/
       *         Independent series sorting
       *
       * @type      {boolean}
       * @since     8.0.0
       * @apioption plotOptions.series.dataSorting.enabled
       */
      /**
       * Whether to allow matching points by name in an update. If this option
       * is disabled, points will be matched by order.
       *
       * @sample {highcharts} highcharts/datasorting/match-by-name/
       *         Enabled match by name
       *
       * @type      {boolean}
       * @since     8.0.0
       * @apioption plotOptions.series.dataSorting.matchByName
       */
      /**
       * Determines what data value should be used to sort by.
       *
       * @sample {highcharts} highcharts/datasorting/sort-key/
       *         Sort key as `z` value
       *
       * @type      {string}
       * @since     8.0.0
       * @default   y
       * @apioption plotOptions.series.dataSorting.sortKey
       */
      /**
       * Enable or disable the mouse tracking for a specific series. This
       * includes point tooltips and click events on graphs and points. For
       * large datasets it improves performance.
       *
       * @sample {highcharts} highcharts/plotoptions/series-enablemousetracking-false/
       *         No mouse tracking
       * @sample {highmaps} maps/plotoptions/series-enablemousetracking-false/
       *         No mouse tracking
       *
       * @type      {boolean}
       * @default   true
       * @apioption plotOptions.series.enableMouseTracking
       */
      /**
       * Whether to use the Y extremes of the total chart width or only the
       * zoomed area when zooming in on parts of the X axis. By default, the
       * Y axis adjusts to the min and max of the visible data. Cartesian
       * series only.
       *
       * @type      {boolean}
       * @default   false
       * @since     4.1.6
       * @product   highcharts highstock gantt
       * @apioption plotOptions.series.getExtremesFromAll
       */
      /**
       * An array specifying which option maps to which key in the data point
       * array. This makes it convenient to work with unstructured data arrays
       * from different sources.
       *
       * @see [series.data](#series.line.data)
       *
       * @sample {highcharts|highstock} highcharts/series/data-keys/
       *         An extended data array with keys
       * @sample {highcharts|highstock} highcharts/series/data-nested-keys/
       *         Nested keys used to access object properties
       *
       * @type      {Array<string>}
       * @since     4.1.6
       * @apioption plotOptions.series.keys
       */
      /**
       * The line cap used for line ends and line joins on the graph.
       *
       * @type       {Highcharts.SeriesLinecapValue}
       * @default    round
       * @product    highcharts highstock
       * @apioption  plotOptions.series.linecap
       */
      /**
       * The [id](#series.id) of another series to link to. Additionally,
       * the value can be ":previous" to link to the previous series. When
       * two series are linked, only the first one appears in the legend.
       * Toggling the visibility of this also toggles the linked series.
       *
       * If master series uses data sorting and linked series does not have
       * its own sorting definition, the linked series will be sorted in the
       * same order as the master one.
       *
       * @sample {highcharts|highstock} highcharts/demo/arearange-line/
       *         Linked series
       *
       * @type      {string}
       * @since     3.0
       * @product   highcharts highstock gantt
       * @apioption plotOptions.series.linkedTo
       */
      /**
       * Options for the corresponding navigator series if `showInNavigator`
       * is `true` for this series. Available options are the same as any
       * series, documented at [plotOptions](#plotOptions.series) and
       * [series](#series).
       *
       * These options are merged with options in [navigator.series](
       * #navigator.series), and will take precedence if the same option is
       * defined both places.
       *
       * @see [navigator.series](#navigator.series)
       *
       * @type      {Highcharts.PlotSeriesOptions}
       * @since     5.0.0
       * @product   highstock
       * @apioption plotOptions.series.navigatorOptions
       */
      /**
       * The color for the parts of the graph or points that are below the
       * [threshold](#plotOptions.series.threshold). Note that `zones` takes
       * precedence over the negative color. Using `negativeColor` is
       * equivalent to applying a zone with value of 0.
       *
       * @see In styled mode, a negative color is applied by setting this option
       *      to `true` combined with the `.highcharts-negative` class name.
       *
       * @sample {highcharts} highcharts/plotoptions/series-negative-color/
       *         Spline, area and column
       * @sample {highcharts} highcharts/plotoptions/arearange-negativecolor/
       *         Arearange
       * @sample {highcharts} highcharts/css/series-negative-color/
       *         Styled mode
       * @sample {highstock} highcharts/plotoptions/series-negative-color/
       *         Spline, area and column
       * @sample {highstock} highcharts/plotoptions/arearange-negativecolor/
       *         Arearange
       * @sample {highmaps} highcharts/plotoptions/series-negative-color/
       *         Spline, area and column
       * @sample {highmaps} highcharts/plotoptions/arearange-negativecolor/
       *         Arearange
       *
       * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @since     3.0
       * @apioption plotOptions.series.negativeColor
       */
      /**
       * Same as
       * [accessibility.series.descriptionFormatter](#accessibility.series.descriptionFormatter),
       * but for an individual series. Overrides the chart wide configuration.
       *
       * @type      {Function}
       * @since     5.0.12
       * @apioption plotOptions.series.pointDescriptionFormatter
       */
      /**
       * If no x values are given for the points in a series, `pointInterval`
       * defines the interval of the x values. For example, if a series
       * contains one value every decade starting from year 0, set
       * `pointInterval` to `10`. In true `datetime` axes, the `pointInterval`
       * is set in milliseconds.
       *
       * It can be also be combined with `pointIntervalUnit` to draw irregular
       * time intervals.
       *
       * If combined with `relativeXValue`, an x value can be set on each
       * point, and the `pointInterval` is added x times to the `pointStart`
       * setting.
       *
       * Please note that this options applies to the _series data_, not the
       * interval of the axis ticks, which is independent.
       *
       * @sample {highcharts} highcharts/plotoptions/series-pointstart-datetime/
       *         Datetime X axis
       * @sample {highcharts} highcharts/plotoptions/series-relativexvalue/
       *         Relative x value
       * @sample {highstock} stock/plotoptions/pointinterval-pointstart/
       *         Using pointStart and pointInterval
       * @sample {highstock} stock/plotoptions/relativexvalue/
       *         Relative x value
       *
       * @type      {number}
       * @default   1
       * @product   highcharts highstock gantt
       * @apioption plotOptions.series.pointInterval
       */
      /**
       * On datetime series, this allows for setting the
       * [pointInterval](#plotOptions.series.pointInterval) to irregular time
       * units, `day`, `month` and `year`. A day is usually the same as 24
       * hours, but `pointIntervalUnit` also takes the DST crossover into
       * consideration when dealing with local time. Combine this option with
       * `pointInterval` to draw weeks, quarters, 6 months, 10 years etc.
       *
       * Please note that this options applies to the _series data_, not the
       * interval of the axis ticks, which is independent.
       *
       * @sample {highcharts} highcharts/plotoptions/series-pointintervalunit/
       *         One point a month
       * @sample {highstock} highcharts/plotoptions/series-pointintervalunit/
       *         One point a month
       *
       * @type       {string}
       * @since      4.1.0
       * @product    highcharts highstock gantt
       * @validvalue ["day", "month", "year"]
       * @apioption  plotOptions.series.pointIntervalUnit
       */
      /**
       * Possible values: `"on"`, `"between"`, `number`.
       *
       * In a column chart, when pointPlacement is `"on"`, the point will not
       * create any padding of the X axis. In a polar column chart this means
       * that the first column points directly north. If the pointPlacement is
       * `"between"`, the columns will be laid out between ticks. This is
       * useful for example for visualising an amount between two points in
       * time or in a certain sector of a polar chart.
       *
       * Since Highcharts 3.0.2, the point placement can also be numeric,
       * where 0 is on the axis value, -0.5 is between this value and the
       * previous, and 0.5 is between this value and the next. Unlike the
       * textual options, numeric point placement options won't affect axis
       * padding.
       *
       * Note that pointPlacement needs a [pointRange](
       * #plotOptions.series.pointRange) to work. For column series this is
       * computed, but for line-type series it needs to be set.
       *
       * For the `xrange` series type and gantt charts, if the Y axis is a
       * category axis, the `pointPlacement` applies to the Y axis rather than
       * the (typically datetime) X axis.
       *
       * Defaults to `undefined` in cartesian charts, `"between"` in polar
       * charts.
       *
       * @see [xAxis.tickmarkPlacement](#xAxis.tickmarkPlacement)
       *
       * @sample {highcharts|highstock} highcharts/plotoptions/series-pointplacement-between/
       *         Between in a column chart
       * @sample {highcharts|highstock} highcharts/plotoptions/series-pointplacement-numeric/
       *         Numeric placement for custom layout
       * @sample {highcharts|highstock} maps/plotoptions/heatmap-pointplacement/
       *         Placement in heatmap
       *
       * @type      {string|number}
       * @since     2.3.0
       * @product   highcharts highstock gantt
       * @apioption plotOptions.series.pointPlacement
       */
      /**
       * If no x values are given for the points in a series, pointStart
       * defines on what value to start. For example, if a series contains one
       * yearly value starting from 1945, set pointStart to 1945.
       *
       * If combined with `relativeXValue`, an x value can be set on each
       * point. The x value from the point options is multiplied by
       * `pointInterval` and added to `pointStart` to produce a modified x
       * value.
       *
       * @sample {highcharts} highcharts/plotoptions/series-pointstart-linear/
       *         Linear
       * @sample {highcharts} highcharts/plotoptions/series-pointstart-datetime/
       *         Datetime
       * @sample {highcharts} highcharts/plotoptions/series-relativexvalue/
       *         Relative x value
       * @sample {highstock} stock/plotoptions/pointinterval-pointstart/
       *         Using pointStart and pointInterval
       * @sample {highstock} stock/plotoptions/relativexvalue/
       *         Relative x value
       *
       * @type      {number}
       * @default   0
       * @product   highcharts highstock gantt
       * @apioption plotOptions.series.pointStart
       */
      /**
       * When true, X values in the data set are relative to the current
       * `pointStart`, `pointInterval` and `pointIntervalUnit` settings. This
       * allows compression of the data for datasets with irregular X values.
       *
       * The real X values are computed on the formula `f(x) = ax + b`, where
       * `a` is the `pointInterval` (optionally with a time unit given by
       * `pointIntervalUnit`), and `b` is the `pointStart`.
       *
       * @sample {highcharts} highcharts/plotoptions/series-relativexvalue/
       *         Relative X value
       * @sample {highstock} stock/plotoptions/relativexvalue/
       *         Relative X value
       *
       * @type      {boolean}
       * @default   false
       * @product   highcharts highstock
       * @apioption plotOptions.series.relativeXValue
       */
      /**
       * Whether to select the series initially. If `showCheckbox` is true,
       * the checkbox next to the series name in the legend will be checked
       * for a selected series.
       *
       * @sample {highcharts} highcharts/plotoptions/series-selected/
       *         One out of two series selected
       *
       * @type      {boolean}
       * @default   false
       * @since     1.2.0
       * @apioption plotOptions.series.selected
       */
      /**
       * Whether to apply a drop shadow to the graph line. Since 2.3 the
       * shadow can be an object configuration containing `color`, `offsetX`,
       * `offsetY`, `opacity` and `width`.
       *
       * @sample {highcharts} highcharts/plotoptions/series-shadow/
       *         Shadow enabled
       *
       * @type      {boolean|Highcharts.ShadowOptionsObject}
       * @default   false
       * @apioption plotOptions.series.shadow
       */
      /**
       * Whether to display this particular series or series type in the
       * legend. Standalone series are shown in legend by default, and linked
       * series are not. Since v7.2.0 it is possible to show series that use
       * colorAxis by setting this option to `true`.
       *
       * @sample {highcharts} highcharts/plotoptions/series-showinlegend/
       *         One series in the legend, one hidden
       *
       * @type      {boolean}
       * @apioption plotOptions.series.showInLegend
       */
      /**
       * Whether or not to show the series in the navigator. Takes precedence
       * over [navigator.baseSeries](#navigator.baseSeries) if defined.
       *
       * @type      {boolean}
       * @since     5.0.0
       * @product   highstock
       * @apioption plotOptions.series.showInNavigator
       */
      /**
       * If set to `true`, the accessibility module will skip past the points
       * in this series for keyboard navigation.
       *
       * @type      {boolean}
       * @since     5.0.12
       * @apioption plotOptions.series.skipKeyboardNavigation
       */
      /**
       * Whether to stack the values of each series on top of each other.
       * Possible values are `undefined` to disable, `"normal"` to stack by
       * value or `"percent"`.
       *
       * When stacking is enabled, data must be sorted
       * in ascending X order.
       *
       * Some stacking options are related to specific series types. In the
       * streamgraph series type, the stacking option is set to `"stream"`.
       * The second one is `"overlap"`, which only applies to waterfall
       * series.
       *
       * @see [yAxis.reversedStacks](#yAxis.reversedStacks)
       *
       * @sample {highcharts} highcharts/plotoptions/series-stacking-line/
       *         Line
       * @sample {highcharts} highcharts/plotoptions/series-stacking-column/
       *         Column
       * @sample {highcharts} highcharts/plotoptions/series-stacking-bar/
       *         Bar
       * @sample {highcharts} highcharts/plotoptions/series-stacking-area/
       *         Area
       * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-line/
       *         Line
       * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-column/
       *         Column
       * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-bar/
       *         Bar
       * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-area/
       *         Area
       * @sample {highcharts} highcharts/plotoptions/series-waterfall-with-normal-stacking
       *         Waterfall with normal stacking
       * @sample {highcharts} highcharts/plotoptions/series-waterfall-with-overlap-stacking
       *         Waterfall with overlap stacking
       * @sample {highstock} stock/plotoptions/stacking/
       *         Area
       *
       * @type       {string}
       * @product    highcharts highstock
       * @validvalue ["normal", "overlap", "percent", "stream"]
       * @apioption  plotOptions.series.stacking
       */
      /**
       * Whether to apply steps to the line. Possible values are `left`,
       * `center` and `right`.
       *
       * @sample {highcharts} highcharts/plotoptions/line-step/
       *         Different step line options
       * @sample {highcharts} highcharts/plotoptions/area-step/
       *         Stepped, stacked area
       * @sample {highstock} stock/plotoptions/line-step/
       *         Step line
       *
       * @type       {string}
       * @since      1.2.5
       * @product    highcharts highstock
       * @validvalue ["left", "center", "right"]
       * @apioption  plotOptions.series.step
       */
      /**
       * The threshold, also called zero level or base level. For line type
       * series this is only used in conjunction with
       * [negativeColor](#plotOptions.series.negativeColor).
       *
       * @see [softThreshold](#plotOptions.series.softThreshold).
       *
       * @type      {number|null}
       * @default   0
       * @since     3.0
       * @product   highcharts highstock
       * @apioption plotOptions.series.threshold
       */
      /**
       * Set the initial visibility of the series.
       *
       * @sample {highcharts} highcharts/plotoptions/series-visible/
       *         Two series, one hidden and one visible
       * @sample {highstock} stock/plotoptions/series-visibility/
       *         Hidden series
       *
       * @type      {boolean}
       * @default   true
       * @apioption plotOptions.series.visible
       */
      /**
       * Defines the Axis on which the zones are applied.
       *
       * @see [zones](#plotOptions.series.zones)
       *
       * @sample {highcharts} highcharts/series/color-zones-zoneaxis-x/
       *         Zones on the X-Axis
       * @sample {highstock} highcharts/series/color-zones-zoneaxis-x/
       *         Zones on the X-Axis
       *
       * @type      {string}
       * @default   y
       * @since     4.1.0
       * @product   highcharts highstock
       * @apioption plotOptions.series.zoneAxis
       */
      /**
       * General event handlers for the series items. These event hooks can
       * also be attached to the series at run time using the
       * `Highcharts.addEvent` function.
       *
       * @declare Highcharts.SeriesEventsOptionsObject
       *
       * @private
       */
      events: {},
      /**
       * Fires after the series has finished its initial animation, or in case
       * animation is disabled, immediately as the series is displayed.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-afteranimate/
       *         Show label after animate
       * @sample {highstock} highcharts/plotoptions/series-events-afteranimate/
       *         Show label after animate
       *
       * @type      {Highcharts.SeriesAfterAnimateCallbackFunction}
       * @since     4.0
       * @product   highcharts highstock gantt
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.afterAnimate
       */
      /**
       * Fires when the checkbox next to the series' name in the legend is
       * clicked. One parameter, `event`, is passed to the function. The state
       * of the checkbox is found by `event.checked`. The checked item is
       * found by `event.item`. Return `false` to prevent the default action
       * which is to toggle the select state of the series.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-checkboxclick/
       *         Alert checkbox status
       *
       * @type      {Highcharts.SeriesCheckboxClickCallbackFunction}
       * @since     1.2.0
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.checkboxClick
       */
      /**
       * Fires when the series is clicked. One parameter, `event`, is passed
       * to the function, containing common event information. Additionally,
       * `event.point` holds a pointer to the nearest point on the graph.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-click/
       *         Alert click info
       * @sample {highstock} stock/plotoptions/series-events-click/
       *         Alert click info
       * @sample {highmaps} maps/plotoptions/series-events-click/
       *         Display click info in subtitle
       *
       * @type      {Highcharts.SeriesClickCallbackFunction}
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.click
       */
      /**
       * Fires when the series is hidden after chart generation time, either
       * by clicking the legend item or by calling `.hide()`.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-hide/
       *         Alert when the series is hidden by clicking the legend item
       *
       * @type      {Highcharts.SeriesHideCallbackFunction}
       * @since     1.2.0
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.hide
       */
      /**
       * Fires when the legend item belonging to the series is clicked. One
       * parameter, `event`, is passed to the function. The default action
       * is to toggle the visibility of the series. This can be prevented
       * by returning `false` or calling `event.preventDefault()`.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-legenditemclick/
       *         Confirm hiding and showing
       *
       * @type      {Highcharts.SeriesLegendItemClickCallbackFunction}
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.legendItemClick
       */
      /**
       * Fires when the mouse leaves the graph. One parameter, `event`, is
       * passed to the function, containing common event information. If the
       * [stickyTracking](#plotOptions.series) option is true, `mouseOut`
       * doesn't happen before the mouse enters another graph or leaves the
       * plot area.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-sticky/
       *         With sticky tracking by default
       * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-no-sticky/
       *         Without sticky tracking
       *
       * @type      {Highcharts.SeriesMouseOutCallbackFunction}
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.mouseOut
       */
      /**
       * Fires when the mouse enters the graph. One parameter, `event`, is
       * passed to the function, containing common event information.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-sticky/
       *         With sticky tracking by default
       * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-no-sticky/
       *         Without sticky tracking
       *
       * @type      {Highcharts.SeriesMouseOverCallbackFunction}
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.mouseOver
       */
      /**
       * Fires when the series is shown after chart generation time, either
       * by clicking the legend item or by calling `.show()`.
       *
       * @sample {highcharts} highcharts/plotoptions/series-events-show/
       *         Alert when the series is shown by clicking the legend item.
       *
       * @type      {Highcharts.SeriesShowCallbackFunction}
       * @since     1.2.0
       * @context   Highcharts.Series
       * @apioption plotOptions.series.events.show
       */
      /**
       * Options for the point markers of line-like series. Properties like
       * `fillColor`, `lineColor` and `lineWidth` define the visual appearance
       * of the markers. Other series types, like column series, don't have
       * markers, but have visual options on the series level instead.
       *
       * In styled mode, the markers can be styled with the
       * `.highcharts-point`, `.highcharts-point-hover` and
       * `.highcharts-point-select` class names.
       *
       * @declare Highcharts.PointMarkerOptionsObject
       *
       * @private
       */
      marker: {
        /**
         * Enable or disable the point marker. If `undefined`, the markers
         * are hidden when the data is dense, and shown for more widespread
         * data points.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-enabled/
         *         Disabled markers
         * @sample {highcharts} highcharts/plotoptions/series-marker-enabled-false/
         *         Disabled in normal state but enabled on hover
         * @sample {highstock} stock/plotoptions/series-marker/
         *         Enabled markers
         *
         * @type      {boolean}
         * @default   {highcharts} undefined
         * @default   {highstock} false
         * @apioption plotOptions.series.marker.enabled
         */
        /**
         * The threshold for how dense the point markers should be before
         * they are hidden, given that `enabled` is not defined. The number
         * indicates the horizontal distance between the two closest points
         * in the series, as multiples of the `marker.radius`. In other
         * words, the default value of 2 means points are hidden if
         * overlapping horizontally.
         *
         * @sample highcharts/plotoptions/series-marker-enabledthreshold
         *         A higher threshold
         *
         * @since 6.0.5
         */
        enabledThreshold: 2,
        /**
         * The fill color of the point marker. When `undefined`, the series'
         * or point's color is used.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-fillcolor/
         *         White fill
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @apioption plotOptions.series.marker.fillColor
         */
        /**
         * Image markers only. Set the image width explicitly. When using
         * this option, a `width` must also be set.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-width-height/
         *         Fixed width and height
         * @sample {highstock} highcharts/plotoptions/series-marker-width-height/
         *         Fixed width and height
         *
         * @type      {number}
         * @since     4.0.4
         * @apioption plotOptions.series.marker.height
         */
        /**
         * The color of the point marker's outline. When `undefined`, the
         * series' or point's color is used.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-fillcolor/
         *         Inherit from series color (undefined)
         *
         * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         */
        lineColor: palette.backgroundColor,
        /**
         * The width of the point marker's outline.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-fillcolor/
         *         2px blue marker
         */
        lineWidth: 0,
        /**
         * The radius of the point marker.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-radius/
         *         Bigger markers
         *
         * @default {highstock} 2
         * @default {highcharts} 4
         *
         */
        radius: 4,
        /**
         * A predefined shape or symbol for the marker. When undefined, the
         * symbol is pulled from options.symbols. Other possible values are
         * `'circle'`, `'square'`,`'diamond'`, `'triangle'` and
         * `'triangle-down'`.
         *
         * Additionally, the URL to a graphic can be given on this form:
         * `'url(graphic.png)'`. Note that for the image to be applied to
         * exported charts, its URL needs to be accessible by the export
         * server.
         *
         * Custom callbacks for symbol path generation can also be added to
         * `Highcharts.SVGRenderer.prototype.symbols`. The callback is then
         * used by its method name, as shown in the demo.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-symbol/
         *         Predefined, graphic and custom markers
         * @sample {highstock} highcharts/plotoptions/series-marker-symbol/
         *         Predefined, graphic and custom markers
         *
         * @type      {string}
         * @apioption plotOptions.series.marker.symbol
         */
        /**
         * Image markers only. Set the image width explicitly. When using
         * this option, a `height` must also be set.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-width-height/
         *         Fixed width and height
         * @sample {highstock} highcharts/plotoptions/series-marker-width-height/
         *         Fixed width and height
         *
         * @type      {number}
         * @since     4.0.4
         * @apioption plotOptions.series.marker.width
         */
        /**
         * States for a single point marker.
         *
         * @declare Highcharts.PointStatesOptionsObject
         */
        states: {
          /**
           * The normal state of a single point marker. Currently only
           * used for setting animation when returning to normal state
           * from hover.
           *
           * @declare Highcharts.PointStatesNormalOptionsObject
           */
          normal: {
            /**
             * Animation when returning to normal state after hovering.
             *
             * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
             */
            animation: true
          },
          /**
           * The hover state for a single point marker.
           *
           * @declare Highcharts.PointStatesHoverOptionsObject
           */
          hover: {
            /**
             * Animation when hovering over the marker.
             *
             * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
             */
            animation: {
              /** @internal */
              duration: 50
            },
            /**
             * Enable or disable the point marker.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-enabled/
             *         Disabled hover state
             */
            enabled: true,
            /**
             * The fill color of the marker in hover state. When
             * `undefined`, the series' or point's fillColor for normal
             * state is used.
             *
             * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
             * @apioption plotOptions.series.marker.states.hover.fillColor
             */
            /**
             * The color of the point marker's outline. When
             * `undefined`, the series' or point's lineColor for normal
             * state is used.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-linecolor/
             *         White fill color, black line color
             *
             * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
             * @apioption plotOptions.series.marker.states.hover.lineColor
             */
            /**
             * The width of the point marker's outline. When
             * `undefined`, the series' or point's lineWidth for normal
             * state is used.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-linewidth/
             *         3px line width
             *
             * @type      {number}
             * @apioption plotOptions.series.marker.states.hover.lineWidth
             */
            /**
             * The radius of the point marker. In hover state, it
             * defaults to the normal state's radius + 2 as per the
             * [radiusPlus](#plotOptions.series.marker.states.hover.radiusPlus)
             * option.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-radius/
             *         10px radius
             *
             * @type      {number}
             * @apioption plotOptions.series.marker.states.hover.radius
             */
            /**
             * The number of pixels to increase the radius of the
             * hovered point.
             *
             * @sample {highcharts} highcharts/plotoptions/series-states-hover-linewidthplus/
             *         5 pixels greater radius on hover
             * @sample {highstock} highcharts/plotoptions/series-states-hover-linewidthplus/
             *         5 pixels greater radius on hover
             *
             * @since 4.0.3
             */
            radiusPlus: 2,
            /**
             * The additional line width for a hovered point.
             *
             * @sample {highcharts} highcharts/plotoptions/series-states-hover-linewidthplus/
             *         2 pixels wider on hover
             * @sample {highstock} highcharts/plotoptions/series-states-hover-linewidthplus/
             *         2 pixels wider on hover
             *
             * @since 4.0.3
             */
            lineWidthPlus: 1
          },
          /**
           * The appearance of the point marker when selected. In order to
           * allow a point to be selected, set the
           * `series.allowPointSelect` option to true.
           *
           * @declare Highcharts.PointStatesSelectOptionsObject
           */
          select: {
            /**
             * Enable or disable visible feedback for selection.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-enabled/
             *         Disabled select state
             *
             * @type      {boolean}
             * @default   true
             * @apioption plotOptions.series.marker.states.select.enabled
             */
            /**
             * The radius of the point marker. In hover state, it
             * defaults to the normal state's radius + 2.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-radius/
             *         10px radius for selected points
             *
             * @type      {number}
             * @apioption plotOptions.series.marker.states.select.radius
             */
            /**
             * The fill color of the point marker.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-fillcolor/
             *         Solid red discs for selected points
             *
             * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
             */
            fillColor: palette.neutralColor20,
            /**
             * The color of the point marker's outline. When
             * `undefined`, the series' or point's color is used.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-linecolor/
             *         Red line color for selected points
             *
             * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
             */
            lineColor: palette.neutralColor100,
            /**
             * The width of the point marker's outline.
             *
             * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-linewidth/
             *         3px line width for selected points
             */
            lineWidth: 2
          }
        }
      },
      /**
       * Properties for each single point.
       *
       * @declare Highcharts.PlotSeriesPointOptions
       *
       * @private
       */
      point: {
        /**
         * Fires when a point is clicked. One parameter, `event`, is passed
         * to the function, containing common event information.
         *
         * If the `series.allowPointSelect` option is true, the default
         * action for the point's click event is to toggle the point's
         * select state. Returning `false` cancels this action.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-click/
         *         Click marker to alert values
         * @sample {highcharts} highcharts/plotoptions/series-point-events-click-column/
         *         Click column
         * @sample {highcharts} highcharts/plotoptions/series-point-events-click-url/
         *         Go to URL
         * @sample {highmaps} maps/plotoptions/series-point-events-click/
         *         Click marker to display values
         * @sample {highmaps} maps/plotoptions/series-point-events-click-url/
         *         Go to URL
         *
         * @type      {Highcharts.PointClickCallbackFunction}
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.click
         */
        /**
         * Fires when the mouse leaves the area close to the point. One
         * parameter, `event`, is passed to the function, containing common
         * event information.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
         *         Show values in the chart's corner on mouse over
         *
         * @type      {Highcharts.PointMouseOutCallbackFunction}
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.mouseOut
         */
        /**
         * Fires when the mouse enters the area close to the point. One
         * parameter, `event`, is passed to the function, containing common
         * event information.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
         *         Show values in the chart's corner on mouse over
         *
         * @type      {Highcharts.PointMouseOverCallbackFunction}
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.mouseOver
         */
        /**
         * Fires when the point is removed using the `.remove()` method. One
         * parameter, `event`, is passed to the function. Returning `false`
         * cancels the operation.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-remove/
         *         Remove point and confirm
         *
         * @type      {Highcharts.PointRemoveCallbackFunction}
         * @since     1.2.0
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.remove
         */
        /**
         * Fires when the point is selected either programmatically or
         * following a click on the point. One parameter, `event`, is passed
         * to the function. Returning `false` cancels the operation.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-select/
         *         Report the last selected point
         * @sample {highmaps} maps/plotoptions/series-allowpointselect/
         *         Report select and unselect
         *
         * @type      {Highcharts.PointSelectCallbackFunction}
         * @since     1.2.0
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.select
         */
        /**
         * Fires when the point is unselected either programmatically or
         * following a click on the point. One parameter, `event`, is passed
         * to the function.
         *  Returning `false` cancels the operation.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-unselect/
         *         Report the last unselected point
         * @sample {highmaps} maps/plotoptions/series-allowpointselect/
         *         Report select and unselect
         *
         * @type      {Highcharts.PointUnselectCallbackFunction}
         * @since     1.2.0
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.unselect
         */
        /**
         * Fires when the point is updated programmatically through the
         * `.update()` method. One parameter, `event`, is passed to the
         * function. The new point options can be accessed through
         * `event.options`. Returning `false` cancels the operation.
         *
         * @sample {highcharts} highcharts/plotoptions/series-point-events-update/
         *         Confirm point updating
         *
         * @type      {Highcharts.PointUpdateCallbackFunction}
         * @since     1.2.0
         * @context   Highcharts.Point
         * @apioption plotOptions.series.point.events.update
         */
        /**
         * Events for each single point.
         *
         * @declare Highcharts.PointEventsOptionsObject
         */
        events: {}
      },
      /**
       * Options for the series data labels, appearing next to each data
       * point.
       *
       * Since v6.2.0, multiple data labels can be applied to each single
       * point by defining them as an array of configs.
       *
       * In styled mode, the data labels can be styled with the
       * `.highcharts-data-label-box` and `.highcharts-data-label` class names
       * ([see example](https://www.highcharts.com/samples/highcharts/css/series-datalabels)).
       *
       * @sample {highcharts} highcharts/plotoptions/series-datalabels-enabled
       *         Data labels enabled
       * @sample {highcharts} highcharts/plotoptions/series-datalabels-multiple
       *         Multiple data labels on a bar series
       * @sample {highcharts} highcharts/css/series-datalabels
       *         Style mode example
       *
       * @type    {*|Array<*>}
       * @product highcharts highstock highmaps gantt
       *
       * @private
       */
      dataLabels: {
        /**
         * Enable or disable the initial animation when a series is
         * displayed for the `dataLabels`. The animation can also be set as
         * a configuration object. Please note that this option only
         * applies to the initial animation.
         * For other animations, see [chart.animation](#chart.animation)
         * and the animation parameter under the API methods.
         * The following properties are supported:
         *
         * - `defer`: The animation delay time in milliseconds.
         *
         * @sample {highcharts} highcharts/plotoptions/animation-defer/
         *          Animation defer settings
         *
         * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
         * @since     8.2.0
         * @apioption plotOptions.series.dataLabels.animation
         */
        animation: {},
        /**
         * The animation delay time in milliseconds.
         * Set to `0` renders dataLabel immediately.
         * As `undefined` inherits defer time from the [series.animation.defer](#plotOptions.series.animation.defer).
         *
         * @type      {number}
         * @since     8.2.0
         * @apioption plotOptions.series.dataLabels.animation.defer
         */
        /**
         * The alignment of the data label compared to the point. If
         * `right`, the right side of the label should be touching the
         * point. For points with an extent, like columns, the alignments
         * also dictates how to align it inside the box, as given with the
         * [inside](#plotOptions.column.dataLabels.inside)
         * option. Can be one of `left`, `center` or `right`.
         *
         * @sample {highcharts} highcharts/plotoptions/series-datalabels-align-left/
         *         Left aligned
         * @sample {highcharts} highcharts/plotoptions/bar-datalabels-align-inside-bar/
         *         Data labels inside the bar
         *
         * @type {Highcharts.AlignValue|null}
         */
        align: "center",
        /**
         * Whether to allow data labels to overlap. To make the labels less
         * sensitive for overlapping, the
         * [dataLabels.padding](#plotOptions.series.dataLabels.padding)
         * can be set to 0.
         *
         * @sample {highcharts} highcharts/plotoptions/series-datalabels-allowoverlap-false/
         *         Don't allow overlap
         *
         * @type      {boolean}
         * @default   false
         * @since     4.1.0
         * @apioption plotOptions.series.dataLabels.allowOverlap
         */
        /**
         * The background color or gradient for the data label.
         *
         * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
         *         Data labels box options
         * @sample {highmaps} maps/plotoptions/series-datalabels-box/
         *         Data labels box options
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @since     2.2.1
         * @apioption plotOptions.series.dataLabels.backgroundColor
         */
        /**
         * The border color for the data label. Defaults to `undefined`.
         *
         * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
         *         Data labels box options
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @since     2.2.1
         * @apioption plotOptions.series.dataLabels.borderColor
         */
        /**
         * The border radius in pixels for the data label.
         *
         * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
         *         Data labels box options
         * @sample {highmaps} maps/plotoptions/series-datalabels-box/
         *         Data labels box options
         *
         * @type      {number}
         * @default   0
         * @since     2.2.1
         * @apioption plotOptions.series.dataLabels.borderRadius
         */
        /**
         * The border width in pixels for the data label.
         *
         * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
         *         Data labels box options
         *
         * @type      {number}
         * @default   0
         * @since     2.2.1
         * @apioption plotOptions.series.dataLabels.borderWidth
         */
        /**
         * A class name for the data label. Particularly in styled mode,
         * this can be used to give each series' or point's data label
         * unique styling. In addition to this option, a default color class
         * name is added so that we can give the labels a contrast text
         * shadow.
         *
         * @sample {highcharts} highcharts/css/data-label-contrast/
         *         Co