/**
 * Copyright (C) 2020 Vaadin Ltd
 *
 * This program is available under Commercial Vaadin Developer License
 * 4.0 (CVDLv4).
 *
 *
 * For the full License, see <https://vaadin.com/license/cvdl-4.0>.
 */
package com.vaadin.mpr.core.client;

import com.google.gwt.dom.client.Element;
import com.vaadin.client.ApplicationConnection;
import com.vaadin.client.communication.MessageSender;

import elemental.json.JsonObject;

/**
 * Message sender class that delegates any Legacy Vaadin communication through
 * the Flow messaging mechanism.
 */
public class MprMessageSender extends MessageSender {

    private ApplicationConnection connection;

    @Override
    public void setConnection(ApplicationConnection connection) {
        super.setConnection(connection);
        this.connection = connection;
    }

    @Override
    public void send(JsonObject payload) {
        sendPayload(connection.getUIConnector().getWidget().getElement()
                .getParentElement(), payload);
    }

    private native void sendPayload(Element element, JsonObject payload)
    /*-{
        element.$server.setRequest(payload);
    }-*/;

    @Override
    public String getCommunicationMethodName() {
        return "Flow";
    }
}
