/**
 * Copyright (C) 2018 Vaadin Ltd
 *
 * This program is available under Commercial Vaadin Add-On License 3.0
 * (CVALv3).
 *
 * See the file licensing.txt distributed with this software for more
 * information about licensing.
 *
 * You should have received a copy of the license along with this program.
 * If not, see <http://vaadin.com/license/cval-3>.
 */
package com.vaadin.mpr.core.client;

import com.google.gwt.dom.client.Element;
import com.vaadin.client.ApplicationConnection;
import com.vaadin.client.communication.MessageSender;

import elemental.json.JsonObject;

/**
 * Message sender class that delegates any Legacy Vaadin communication through
 * the Flow messaging mechanism.
 */
public class MprMessageSender extends MessageSender {

    private ApplicationConnection connection;

    @Override
    public void setConnection(ApplicationConnection connection) {
        super.setConnection(connection);
        this.connection = connection;
    }

    @Override
    public void send(JsonObject payload) {
        sendPayload(connection.getUIConnector().getWidget().getElement()
                .getParentElement(), payload);
    }

    private native void sendPayload(Element element, JsonObject payload)
    /*-{
        element.$server.setRequest(payload);
    }-*/;

    @Override
    public String getCommunicationMethodName() {
        return "Flow";
    }
}
