/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone.nodes;

import com.vaadin.hilla.parser.core.AbstractNode;
import com.vaadin.hilla.parser.models.AnnotatedModel;
import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public final class CompositeTypeSignatureNode
extends AbstractNode<List<SignatureModel>, Schema<?>>
implements TypedNode {
    private final List<AnnotationInfoModel> annotations;

    private CompositeTypeSignatureNode(@NonNull List<SignatureModel> source, @NonNull Schema<?> target, List<AnnotationInfoModel> annotations) {
        super(source, target);
        this.annotations = annotations;
    }

    private CompositeTypeSignatureNode(@NonNull List<SignatureModel> source, @NonNull Schema<?> target) {
        this(source, target, CompositeTypeSignatureNode.extractAnnotations(source));
    }

    public static @NonNull CompositeTypeSignatureNode of(@NonNull List<SignatureModel> source) {
        return new CompositeTypeSignatureNode(source, new Schema());
    }

    @Override
    public List<AnnotationInfoModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    public SignatureModel getType() {
        return (SignatureModel)((List)this.getSource()).get(0);
    }

    @Override
    public TypedNode processType(@NonNull UnaryOperator<SignatureModel> typeProcessor) {
        List<SignatureModel> processedTypes = ((List)this.getSource()).stream().map(typeProcessor).collect(Collectors.toList());
        if (processedTypes.equals(this.getSource())) {
            return this;
        }
        return new CompositeTypeSignatureNode(processedTypes, (Schema)this.getTarget(), this.annotations);
    }

    private static List<AnnotationInfoModel> extractAnnotations(List<SignatureModel> source) {
        return source.stream().map(AnnotatedModel::getAnnotations).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }
}

