/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypeSignatureNode;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonValuePlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    private final Map<Class<?>, Optional<Class<?>>> jsonValues = new HashMap();

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    @Nonnull
    public Node<?, ?> resolve(@Nonnull Node<?, ?> node, @Nonnull NodePath<?> parentPath) {
        TypeSignatureNode typeSignatureNode;
        Object object;
        if (node instanceof TypeSignatureNode && (object = (typeSignatureNode = (TypeSignatureNode)node).getSource()) instanceof ClassRefSignatureModel) {
            ClassRefSignatureModel classRefSignatureModel = (ClassRefSignatureModel)object;
            Class cls = (Class)classRefSignatureModel.getClassInfo().get();
            Optional<TypeSignatureNode> valueNode = this.getValueType(cls).map(SignatureModel::of).map(TypeSignatureNode::of);
            return (Node)valueNode.orElse(typeSignatureNode);
        }
        return node;
    }

    private Optional<Class<?>> getValueType(Class<?> cls) {
        return this.jsonValues.computeIfAbsent(cls, this::findValueType);
    }

    private Optional<Class<?>> findValueType(Class<?> cls) {
        Optional<Class<?>> jsonValue = Arrays.stream(cls.getMethods()).filter(method -> method.isAnnotationPresent(JsonValue.class)).map(Method::getReturnType).findAny();
        Optional<Executable> jsonCreator = Stream.concat(Arrays.stream(cls.getMethods()), Arrays.stream(cls.getConstructors())).filter(executable -> executable.isAnnotationPresent(JsonCreator.class)).findAny();
        if (jsonValue.isPresent() ^ jsonCreator.isPresent()) {
            throw new MalformedValueTypeException("Class " + cls.getName() + " has only one of @JsonValue and @JsonCreator. Hilla only supports classes with both annotations.");
        }
        return jsonValue;
    }

    public static class MalformedValueTypeException
    extends RuntimeException {
        public MalformedValueTypeException(String message) {
            super(message);
        }
    }
}

