/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.RootNode;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.FieldInfoModel;
import com.vaadin.hilla.parser.models.NamedModel;
import com.vaadin.hilla.parser.models.SpecializedModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.nodes.EntityNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class EntityPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public void enter(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof EntityNode) {
            EntityNode entityNode = (EntityNode)nodePath.getNode();
            ClassInfoModel cls = (ClassInfoModel)entityNode.getSource();
            ObjectSchema schema = cls.isEnum() ? this.enumSchema(cls) : new ObjectSchema();
            entityNode.setTarget(schema);
            List<String> generics = ((ClassInfoModel)entityNode.getSource()).getTypeParameters().stream().filter(tp -> tp.getBounds().stream().filter(Objects::nonNull).noneMatch(Predicate.not(SpecializedModel::isNativeObject))).map(NamedModel::getName).toList();
            if (!generics.isEmpty()) {
                schema.addExtension("x-type-parameters", generics);
            }
        }
    }

    public void exit(NodePath<?> nodePath) {
        if (nodePath.getNode() instanceof EntityNode && nodePath.getParentPath().getNode() instanceof RootNode) {
            Schema schema = (Schema)nodePath.getNode().getTarget();
            ClassInfoModel cls = (ClassInfoModel)nodePath.getNode().getSource();
            OpenAPI openApi = (OpenAPI)nodePath.getParentPath().getNode().getTarget();
            EntityPlugin.attachSchemaWithNameToOpenApi(schema, cls.getName(), openApi);
        }
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        if (!(nodeDependencies.getNode() instanceof TypedNode)) {
            return nodeDependencies;
        }
        TypedNode typedNode = (TypedNode)nodeDependencies.getNode();
        if (!(typedNode.getType() instanceof ClassRefSignatureModel)) {
            return nodeDependencies;
        }
        ClassRefSignatureModel ref = (ClassRefSignatureModel)typedNode.getType();
        if (ref.isJDKClass() || ref.isDate() || ref.isIterable()) {
            return nodeDependencies;
        }
        return nodeDependencies.appendRelatedNodes(Stream.of(EntityNode.of(ref.getClassInfo())));
    }

    public static void attachSchemaWithNameToOpenApi(Schema<?> schema, String name, OpenAPI openApi) {
        Components components = openApi.getComponents();
        if (components == null) {
            components = new Components();
            openApi.setComponents(components);
        }
        components.addSchemas(name, schema);
    }

    private Schema<?> enumSchema(ClassInfoModel entity) {
        StringSchema schema = new StringSchema();
        schema.setEnum(entity.getFields().stream().filter(FieldInfoModel::isPublic).map(NamedModel::getName).collect(Collectors.toList()));
        return schema;
    }
}

