/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.devmode.hotswapagent;

import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.ReflectionCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="HillaPlugin", description="HotSwapAgent plugin for Hilla", testedVersions={"2.3"}, expectedVersions={"2.3"})
public class HillaPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(HillaPlugin.class);
    private final String hotSwapperClass = "com.vaadin.hilla.Hotswapper";
    private boolean hotswapperClassAvailable = false;
    @Init
    ClassLoader appClassLoader;
    @Init
    Scheduler scheduler;

    @OnClassLoadEvent(classNameRegexp="com.vaadin.hilla.EndpointController")
    public static void registerPlugin(CtClass ctClass) throws NotFoundException, CannotCompileException {
        Object src = PluginManagerInvoker.buildInitializePlugin(HillaPlugin.class);
        src = (String)src + PluginManagerInvoker.buildCallPluginMethod(HillaPlugin.class, (String)"init", (String[])new String[]{"this", "java.lang.Object"});
        ctClass.getConstructors()[0].insertAfter((String)src);
    }

    public void init(Object endpointController) {
        try {
            Class.forName("com.vaadin.hilla.Hotswapper").getMethod("markInUse", new Class[0]).invoke(null, new Object[0]);
            this.hotswapperClassAvailable = true;
            LOGGER.info("Plugin {} initialized", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.info("Plugin {} initialized but will not be used as {} is not found", new Object[]{this.getClass(), "com.vaadin.hilla.Hotswapper"});
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classRedefined(CtClass ctClass) {
        if (!this.hotswapperClassAvailable) {
            return;
        }
        Object[] params = new Object[]{true, new String[]{ctClass.getName()}};
        this.scheduler.scheduleCommand((Command)new ReflectionCommand((Object)this, "com.vaadin.hilla.Hotswapper", "onHotswap", null, params));
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.DEFINE})
    public void classChanged(CtClass ctClass) {
        if (!this.hotswapperClassAvailable) {
            return;
        }
        Object[] params = new Object[]{false, new String[]{ctClass.getName()}};
        this.scheduler.scheduleCommand((Command)new ReflectionCommand((Object)this, "com.vaadin.hilla.Hotswapper", "onHotswap", null, params));
    }
}

