/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleProxy
extends Thread {
    private final ThreadGroup proxyThreads;
    private final Queue<Socket> sockets = new ConcurrentLinkedQueue<Socket>();
    private final ServerSocket serverSocket;
    private final String remoteHost;
    private final int remotePort;

    public SimpleProxy(int localPort, String remoteHost, int remotePort) throws IOException {
        super(new ThreadGroup("proxy " + localPort), "server");
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.proxyThreads = this.getThreadGroup();
        this.serverSocket = new ServerSocket(localPort, 100, InetAddress.getByName("0.0.0.0"));
        this.setDaemon(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.isInterrupted() && !this.serverSocket.isClosed()) {
                try {
                    Socket proxySocket = this.serverSocket.accept();
                    this.sockets.add(proxySocket);
                    Socket remoteSocket = new Socket(this.remoteHost, this.remotePort);
                    this.sockets.add(remoteSocket);
                    new CopySocket(this, this.proxyThreads, proxySocket, remoteSocket).start();
                    new CopySocket(this, this.proxyThreads, remoteSocket, proxySocket).start();
                }
                catch (SocketException e) {
                    if (this.serverSocket.isClosed()) continue;
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            this.disconnect();
        }
    }

    public void disconnect() {
        this.proxyThreads.interrupt();
        for (Socket socket : this.sockets) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class CopySocket
    extends Thread {
        private final InputStream inputStream;
        private final OutputStream outputStream;

        private CopySocket(SimpleProxy simpleProxy, ThreadGroup proxyThreads, Socket srcSocket, Socket dstSocket) throws IOException {
            super(proxyThreads, "proxy worker");
            this.setDaemon(true);
            this.inputStream = srcSocket.getInputStream();
            this.outputStream = dstSocket.getOutputStream();
        }

        @Override
        public void run() {
            try {
                int b;
                while ((b = this.inputStream.read()) >= 0) {
                    this.outputStream.write(b);
                }
            }
            catch (SocketException b) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

