/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil.net;

import com.vaadin.flow.testutil.net.EphemeralPortRangeDetector;
import com.vaadin.flow.testutil.net.FixedIANAPortRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.slf4j.LoggerFactory;

public class LinuxEphemeralPortRangeDetector
implements EphemeralPortRangeDetector {
    private final int firstEphemeralPort;
    private final int lastEphemeralPort;

    public static LinuxEphemeralPortRangeDetector getInstance() {
        File file = new File("/proc/sys/net/ipv4/ip_local_port_range");
        if (file.exists() && file.canRead()) {
            LinuxEphemeralPortRangeDetector linuxEphemeralPortRangeDetector;
            block9: {
                BufferedReader inputFil = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());
                try {
                    linuxEphemeralPortRangeDetector = new LinuxEphemeralPortRangeDetector(inputFil);
                    if (inputFil == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputFil != null) {
                            try {
                                ((Reader)inputFil).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                ((Reader)inputFil).close();
            }
            return linuxEphemeralPortRangeDetector;
        }
        return new LinuxEphemeralPortRangeDetector(new StringReader("49152 65535"));
    }

    LinuxEphemeralPortRangeDetector(Reader inputFil) {
        FixedIANAPortRange defaultRange = new FixedIANAPortRange();
        int lowPort = defaultRange.getLowestEphemeralPort();
        int highPort = defaultRange.getHighestEphemeralPort();
        try (BufferedReader in = new BufferedReader(inputFil);){
            String[] split = in.readLine().split("\\s+", 3);
            lowPort = Integer.parseInt(split[0]);
            highPort = Integer.parseInt(split[1]);
        }
        catch (IOException | NullPointerException ignore) {
            LoggerFactory.getLogger((String)"PortRangeDetector").trace("Failed to read input", (Throwable)ignore);
        }
        this.firstEphemeralPort = lowPort;
        this.lastEphemeralPort = highPort;
    }

    @Override
    public int getLowestEphemeralPort() {
        return this.firstEphemeralPort;
    }

    @Override
    public int getHighestEphemeralPort() {
        return this.lastEphemeralPort;
    }
}

