/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.experimental;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.UnknownFeatureException;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlags
implements Serializable {
    public static final String PROPERTIES_FILENAME = "vaadin-featureflags.properties";
    public static final Feature EXAMPLE = new Feature("Example feature. Will be removed once the first real feature flag is added", "exampleFeatureFlag", "https://github.com/vaadin/flow/pull/12004", false);
    public static final Feature VITE = new Feature("Use Vite for faster front-end builds", "viteForFrontendBuild", "https://github.com/vaadin/platform/issues/2448", true);
    private List<Feature> features = new ArrayList<Feature>();
    File propertiesFolder = null;
    private final Lookup lookup;
    private ApplicationConfiguration configuration;

    public FeatureFlags(Lookup lookup) {
        this.lookup = lookup;
        this.features.add(new Feature(EXAMPLE));
        this.features.add(new Feature(VITE));
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureFlags get(VaadinContext context) {
        FeatureFlagsWrapper attribute;
        assert (context != null);
        VaadinContext vaadinContext = context;
        synchronized (vaadinContext) {
            attribute = context.getAttribute(FeatureFlagsWrapper.class);
            if (attribute == null) {
                FeatureFlags featureFlags = new FeatureFlags(context.getAttribute(Lookup.class));
                featureFlags.configuration = ApplicationConfiguration.get(context);
                featureFlags.loadProperties();
                attribute = new FeatureFlagsWrapper(featureFlags);
                context.setAttribute(attribute);
            }
        }
        return attribute.getFeatureFlags();
    }

    public void setPropertiesLocation(File propertiesFolder) {
        this.propertiesFolder = propertiesFolder;
        this.loadProperties();
    }

    void loadProperties() {
        URL applicationResource;
        ResourceProvider resourceProvider = this.lookup.lookup(ResourceProvider.class);
        if (resourceProvider != null && (applicationResource = resourceProvider.getApplicationResource(PROPERTIES_FILENAME)) != null) {
            this.getLogger().debug("Properties loaded from classpath.");
            try (InputStream propertiesStream = applicationResource.openStream();){
                this.loadProperties(propertiesStream);
                return;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read properties file from classpath", e);
            }
        }
        File featureFlagFile = this.getFeatureFlagFile();
        if (featureFlagFile == null || !featureFlagFile.exists()) {
            for (Feature f : this.features) {
                f.setEnabled(false);
            }
            return;
        }
        try (FileInputStream propertiesStream = new FileInputStream(featureFlagFile);){
            this.getLogger().debug("Loading properties from file '{}'", (Object)featureFlagFile);
            this.loadProperties(propertiesStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read properties file from filesystem", e);
        }
    }

    void loadProperties(InputStream propertiesStream) {
        try {
            Properties props = new Properties();
            if (propertiesStream != null) {
                props.load(propertiesStream);
            }
            for (Feature f : this.features) {
                boolean enabled = "true".equals(props.getProperty(this.getPropertyName(f.getId()), "false"));
                f.setEnabled(enabled);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to read feature flags", (Throwable)e);
        }
    }

    private void saveProperties() {
        File featureFlagFile = this.getFeatureFlagFile();
        if (featureFlagFile == null) {
            throw new IllegalStateException("Unable to determine feature flag file location");
        }
        StringBuilder properties = new StringBuilder();
        for (Feature feature : this.features) {
            if (!feature.isEnabled()) continue;
            properties.append("# ").append(feature.getTitle()).append("\n");
            properties.append(this.getPropertyName(feature.getId())).append("=true\n");
        }
        if (!featureFlagFile.getParentFile().exists()) {
            featureFlagFile.getParentFile().mkdirs();
        }
        try {
            FileUtils.write((File)featureFlagFile, (CharSequence)properties.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to store feature flags", (Throwable)e);
        }
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public boolean isEnabled(Feature feature) {
        return this.getFeature(feature.getId()).orElseThrow(() -> new UnknownFeatureException(feature.getTitle())).isEnabled();
    }

    public boolean isEnabled(String featureId) {
        return this.getFeature(featureId).map(Feature::isEnabled).orElse(false);
    }

    private Optional<Feature> getFeature(String featureId) {
        return this.features.stream().filter(feature -> feature.getId().equals(featureId)).findFirst();
    }

    private String getPropertyName(String featureId) {
        return "com.vaadin.experimental." + featureId;
    }

    public void setEnabled(String featureId, boolean enabled) {
        if (!this.isDevelopmentMode()) {
            throw new IllegalStateException("Feature flags can only be toggled when in development mode");
        }
        Optional<Feature> maybeFeature = this.getFeature(featureId);
        if (!maybeFeature.isPresent()) {
            throw new IllegalArgumentException("Unknown feature " + featureId);
        }
        Feature feature = maybeFeature.get();
        if (feature.isEnabled() == enabled) {
            return;
        }
        maybeFeature.get().setEnabled(enabled);
        this.saveProperties();
        this.getLogger().info("Set feature {} to {}", (Object)featureId, (Object)enabled);
    }

    private File getFeatureFlagFile() {
        if (this.propertiesFolder == null) {
            if (this.configuration == null) {
                return null;
            }
            this.propertiesFolder = this.configuration.getJavaResourceFolder();
        }
        return new File(this.propertiesFolder, PROPERTIES_FILENAME);
    }

    private boolean isDevelopmentMode() {
        return this.configuration != null && !this.configuration.isProductionMode();
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FeatureFlags.class);
    }

    protected static class FeatureFlagsWrapper
    implements Serializable {
        private final FeatureFlags featureFlags;

        public FeatureFlagsWrapper(FeatureFlags featureFlags) {
            this.featureFlags = featureFlags;
        }

        public FeatureFlags getFeatureFlags() {
            return this.featureFlags;
        }
    }
}

