/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.BrowserWindowResizeEvent;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.History;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.function.Function;

public class Page
implements Serializable {
    private ResizeEventReceiver resizeReceiver;
    private final UI ui;
    private final History history;

    public Page(UI ui) {
        this.ui = ui;
        this.history = new History(ui);
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Cannot set a null page title.");
        }
        this.ui.getInternals().setTitle(title);
    }

    public void addStyleSheet(String url) {
        this.addStyleSheet(url, LoadMode.EAGER);
    }

    public void addStyleSheet(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.STYLESHEET, url, loadMode));
    }

    public void addJavaScript(String url) {
        this.addJavaScript(url, LoadMode.EAGER);
    }

    public void addJavaScript(String url, LoadMode loadMode) {
        this.addDependency(new Dependency(Dependency.Type.JAVASCRIPT, url, loadMode));
    }

    public void addJsModule(String url) {
        if (!UrlUtil.isExternal(url) && !url.startsWith("/")) {
            throw new IllegalArgumentException("url argument must contains either a protocol (eg. starts with \"http://\" or \"//\"), or starts with \"/\".");
        }
        this.addDependency(new Dependency(Dependency.Type.JS_MODULE, url, LoadMode.EAGER));
    }

    public void addDynamicImport(String expression) {
        this.addDependency(new Dependency(Dependency.Type.DYNAMIC_IMPORT, expression));
    }

    @Deprecated
    public ExecutionCanceler executeJavaScript(String expression, Serializable ... parameters) {
        return this.executeJs(expression, parameters);
    }

    public PendingJavaScriptResult executeJs(String expression, Serializable ... parameters) {
        UIInternals.JavaScriptInvocation invocation = new UIInternals.JavaScriptInvocation(expression, parameters);
        PendingJavaScriptInvocation execution = new PendingJavaScriptInvocation(this.ui.getInternals().getStateTree().getRootNode(), invocation);
        this.ui.getInternals().addJavaScriptInvocation(execution);
        return execution;
    }

    public History getHistory() {
        return this.history;
    }

    public void reload() {
        this.executeJs("window.location.reload();", new Serializable[0]);
    }

    public Registration addBrowserWindowResizeListener(BrowserWindowResizeListener resizeListener) {
        Objects.requireNonNull(resizeListener);
        if (this.resizeReceiver == null) {
            this.resizeReceiver = new ResizeEventReceiver();
            this.ui.getElement().appendVirtualChild(this.resizeReceiver.getElement());
        }
        if (this.resizeReceiver.windowResizeListenersSize == 0) {
            this.executeJs(LazyJsLoader.WINDOW_LISTENER_JS, this.resizeReceiver);
        }
        return this.resizeReceiver.addListener(resizeListener);
    }

    public void open(String url) {
        this.open(url, "_blank");
    }

    public void open(String url, String windowName) {
        this.executeJs("if ($1 == '_self') this.stopApplication(); window.open($0, $1)", new Serializable[]{url, windowName});
    }

    public void setLocation(String uri) {
        this.open(uri, "_self");
    }

    public void setLocation(URI uri) {
        this.setLocation(uri.toString());
    }

    private void addDependency(Dependency dependency) {
        assert (dependency != null);
        this.ui.getInternals().getDependencyList().add(dependency);
    }

    public void retrieveExtendedClientDetails(ExtendedClientDetailsReceiver receiver) {
        ExtendedClientDetails cachedDetails = this.ui.getInternals().getExtendedClientDetails();
        if (cachedDetails != null) {
            receiver.receiveDetails(cachedDetails);
            return;
        }
        String js = "return Vaadin.Flow.getBrowserDetailsParameters();";
        SerializableConsumer resultHandler = json -> {
            this.handleExtendedClientDetailsResponse((JsonValue)json);
            receiver.receiveDetails(this.ui.getInternals().getExtendedClientDetails());
        };
        SerializableConsumer errorHandler = err -> {
            throw new RuntimeException("Unable to retrieve extended client details. JS error is '" + err + "'");
        };
        this.executeJs("return Vaadin.Flow.getBrowserDetailsParameters();", new Serializable[0]).then(resultHandler, errorHandler);
    }

    private void handleExtendedClientDetailsResponse(JsonValue json) {
        ExtendedClientDetails cachedDetails = this.ui.getInternals().getExtendedClientDetails();
        if (cachedDetails != null) {
            return;
        }
        if (!(json instanceof JsonObject)) {
            throw new RuntimeException("Expected a JSON object");
        }
        JsonObject jsonObj = (JsonObject)json;
        Function<String, String> getStringElseNull = key -> {
            JsonValue jsValue = jsonObj.get(key);
            if (jsValue != null && JsonType.STRING.equals((Object)jsValue.getType())) {
                return jsValue.asString();
            }
            return null;
        };
        this.ui.getInternals().setExtendedClientDetails(new ExtendedClientDetails(getStringElseNull.apply("v-sw"), getStringElseNull.apply("v-sh"), getStringElseNull.apply("v-ww"), getStringElseNull.apply("v-wh"), getStringElseNull.apply("v-bw"), getStringElseNull.apply("v-bh"), getStringElseNull.apply("v-tzo"), getStringElseNull.apply("v-rtzo"), getStringElseNull.apply("v-dstd"), getStringElseNull.apply("v-dston"), getStringElseNull.apply("v-tzid"), getStringElseNull.apply("v-curdate"), getStringElseNull.apply("v-td"), getStringElseNull.apply("v-pr"), getStringElseNull.apply("v-wn"), getStringElseNull.apply("v-np")));
    }

    public void fetchCurrentURL(SerializableConsumer<URL> callback) {
        Objects.requireNonNull(callback, "Url consumer callback should not be null.");
        String js = "return window.location.href";
        this.executeJs("return window.location.href", new Serializable[0]).then(String.class, urlString -> {
            try {
                callback.accept(new URL((String)urlString));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Error while encoding the URL from client", e);
            }
        });
    }

    @FunctionalInterface
    public static interface ExtendedClientDetailsReceiver
    extends Serializable {
        public void receiveDetails(ExtendedClientDetails var1);
    }

    private static class LazyJsLoader
    implements Serializable {
        private static final String JS_FILE_NAME = "windowResizeListener.js";
        private static final String WINDOW_LISTENER_JS = LazyJsLoader.readJS();

        private LazyJsLoader() {
        }

        /*
         * Exception decompiling
         */
        private static String readJS() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @FunctionalInterface
    @Deprecated
    public static interface ExecutionCanceler
    extends Serializable {
        public boolean cancelExecution();
    }

    private static class ResizeEvent
    extends ComponentEvent<ResizeEventReceiver> {
        private final BrowserWindowResizeEvent apiEvent;

        private ResizeEvent(ResizeEventReceiver source, int width, int height) {
            super(source, true);
            this.apiEvent = new BrowserWindowResizeEvent(source.getUI().get().getPage(), width, height);
        }

        private BrowserWindowResizeEvent getApiEvent() {
            return this.apiEvent;
        }
    }

    @Tag(value="div")
    private static class ResizeEventReceiver
    extends Component {
        private int windowResizeListenersSize;

        private ResizeEventReceiver() {
        }

        @ClientCallable
        private void windowResized(int width, int height) {
            if (this.windowResizeListenersSize != 0) {
                this.fireEvent(new ResizeEvent(this, width, height));
            }
        }

        private Registration addListener(BrowserWindowResizeListener listener) {
            ++this.windowResizeListenersSize;
            Registration registration = this.addListener(ResizeEvent.class, event -> listener.browserWindowResized(((ResizeEvent)event).getApiEvent()));
            Registration combined = Registration.combine(this::listenerIsUnregistered, registration);
            return Registration.once(combined::remove);
        }

        private void listenerIsUnregistered() {
            --this.windowResizeListenersSize;
            if (this.windowResizeListenersSize == 0) {
                this.getUI().get().getPage().executeJs("$0.resizeRemove()", this);
            }
        }
    }
}

