/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class TaskGenerateIndexTs
extends AbstractTaskClientGenerator {
    private final File frontendDirectory;
    private File generatedImports;
    private final File outputDirectory;

    TaskGenerateIndexTs(File frontendDirectory, File generatedImports, File outputDirectory) {
        this.frontendDirectory = frontendDirectory;
        this.generatedImports = generatedImports;
        this.outputDirectory = outputDirectory;
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.outputDirectory, "index.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        File indexTs = new File(this.frontendDirectory, "index.ts");
        File indexJs = new File(this.frontendDirectory, "index.js");
        this.compareActualIndexTsOrJsWithIndexTempalate(indexTs, indexJs);
        return !indexTs.exists() && !indexJs.exists();
    }

    @Override
    protected String getFileContent() throws IOException {
        String indexTemplate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("index.ts"), (Charset)StandardCharsets.UTF_8);
        String relativizedImport = TaskGenerateIndexTs.ensureValidRelativePath(FrontendUtils.getUnixRelativePath(this.outputDirectory.toPath(), this.generatedImports.toPath()));
        relativizedImport = relativizedImport.replaceFirst("^./", "../" + this.outputDirectory.getName() + "/").replaceFirst("\\.(ts|js)$", "");
        return indexTemplate.replace("[to-be-generated-by-flow]", relativizedImport);
    }

    static String ensureValidRelativePath(String relativePath) {
        if (!relativePath.startsWith(".")) {
            relativePath = "./" + relativePath;
        }
        return relativePath;
    }

    private void compareActualIndexTsOrJsWithIndexTempalate(File indexTs, File indexJs) {
        if (indexTs.exists() || indexJs.exists()) {
            File indexFileExist = indexTs.exists() ? indexTs : indexJs;
            String indexContent = null;
            String indexTemplate = null;
            try {
                indexContent = IOUtils.toString((URI)indexFileExist.toURI(), (Charset)StandardCharsets.UTF_8);
                indexTemplate = this.getFileContent();
            }
            catch (IOException e) {
                this.log().warn("Failed to read file content", (Throwable)e);
            }
            if (indexContent != null && !indexContent.equals(indexTemplate)) {
                UsageStatistics.markAsUsed("routing/client", Version.getFullVersion());
            }
        }
    }
}

