/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.Optional;

public class EventRpcHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "event";
    }

    @Override
    public Optional<Runnable> handleNode(StateNode node, JsonObject invocationJson) {
        assert (invocationJson.hasKey("event"));
        String eventType = invocationJson.getString("event");
        JsonObject eventData = invocationJson.getObject("data");
        if (eventData == null) {
            eventData = Json.createObject();
        }
        DomEvent event = new DomEvent(Element.get(node), eventType, eventData);
        node.getFeature(ElementListenerMap.class).fireEvent(event);
        return Optional.empty();
    }
}

