/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ApplicationClassLoaderAccess;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.VaadinContextInitializer;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletConfig;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VaadinServlet
extends HttpServlet {
    private VaadinServletService servletService;
    private StaticFileHandler staticFileHandler;
    private volatile boolean isServletInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        CurrentInstance.clearAll();
        try {
            VaadinServletContext vaadinServletContext = null;
            if (this.getServletConfig() == null) {
                this.isServletInitialized = true;
                super.init(servletConfig);
                vaadinServletContext = this.initializeContext();
            }
            if (this.getServletConfig() != servletConfig) {
                throw new IllegalArgumentException("Servlet config instance may not differ from the instance which has been used for the initial method call");
            }
            if (vaadinServletContext == null) {
                vaadinServletContext = new VaadinServletContext(this.getServletConfig().getServletContext());
            }
            if (this.servletService != null || vaadinServletContext.getAttribute(Lookup.class) == null) {
                return;
            }
            try {
                this.servletService = this.createServletService();
            }
            catch (ServiceException e) {
                throw new ServletException("Could not initialize VaadinServlet", (Throwable)e);
            }
            this.servletService.setCurrentInstances(null, null);
            this.staticFileHandler = this.createStaticFileHandler(this.servletService);
            this.servletInitialized();
        }
        finally {
            CurrentInstance.clearAll();
        }
    }

    public ServletConfig getServletConfig() {
        if (this.isServletInitialized) {
            return super.getServletConfig();
        }
        return null;
    }

    protected StaticFileHandler createStaticFileHandler(VaadinService vaadinService) {
        Lookup lookup = vaadinService.getContext().getAttribute(Lookup.class);
        return lookup.lookup(StaticFileHandlerFactory.class).createHandler(vaadinService);
    }

    protected void servletInitialized() throws ServletException {
    }

    public static VaadinServlet getCurrent() {
        VaadinService vaadinService = CurrentInstance.get(VaadinService.class);
        if (vaadinService instanceof VaadinServletService) {
            VaadinServletService vss = (VaadinServletService)vaadinService;
            return vss.getServlet();
        }
        return null;
    }

    protected DeploymentConfiguration createDeploymentConfiguration() throws ServletException {
        return this.createDeploymentConfiguration(new DeploymentConfigurationFactory().createInitParameters(((Object)((Object)this)).getClass(), new VaadinServletConfig(this.getServletConfig())));
    }

    protected DeploymentConfiguration createDeploymentConfiguration(Properties initParameters) {
        VaadinServletContext context = new VaadinServletContext(this.getServletContext());
        return new DefaultDeploymentConfiguration(ApplicationConfiguration.get(context), ((Object)((Object)this)).getClass(), initParameters);
    }

    protected VaadinServletService createServletService() throws ServletException, ServiceException {
        return this.createServletService(this.createDeploymentConfiguration());
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        VaadinServletService service = new VaadinServletService(this, deploymentConfiguration);
        service.init();
        return service;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.handleContextOrServletRootWithoutSlash(request, response)) {
            return;
        }
        if (this.serveStaticOrWebJarRequest(request, response)) {
            return;
        }
        CurrentInstance.clearAll();
        VaadinServletRequest vaadinRequest = this.createVaadinRequest(request);
        VaadinServletResponse vaadinResponse = this.createVaadinResponse(response);
        if (!this.ensureCookiesEnabled(vaadinRequest, vaadinResponse)) {
            return;
        }
        try {
            this.getService().handleRequest(vaadinRequest, vaadinResponse);
        }
        catch (ServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean serveStaticOrWebJarRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        if (handler != null && handler.isDevModeRequest(request) && handler.serveDevModeRequest(request, response)) {
            return true;
        }
        if (this.staticFileHandler.isStaticResourceRequest(request)) {
            this.staticFileHandler.serveStaticResource(request, response);
            return true;
        }
        return false;
    }

    protected boolean handleContextOrServletRootWithoutSlash(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String location = request.getRequestURI();
        String lastPathParameter = VaadinServlet.getLastPathParameter(location);
        location = location.substring(0, location.length() - lastPathParameter.length());
        if ((request.getPathInfo() == null || "/".equals(request.getPathInfo())) && !location.endsWith("/")) {
            location = location + "/" + lastPathParameter;
            String queryString = request.getQueryString();
            if (queryString != null) {
                queryString = queryString.replaceAll("[\\r\\n]", "");
                location = location + '?' + queryString;
            }
            response.sendRedirect(location);
            return true;
        }
        return false;
    }

    protected static String getLastPathParameter(String uri) {
        int lastPathStart = uri.lastIndexOf(47);
        if (lastPathStart == -1) {
            return "";
        }
        int semicolonPos = uri.indexOf(59, lastPathStart);
        if (semicolonPos < 0) {
            return "";
        }
        String semicolonString = uri.substring(semicolonPos);
        return semicolonString;
    }

    private VaadinServletResponse createVaadinResponse(HttpServletResponse response) {
        return new VaadinServletResponse(response, this.getService());
    }

    protected VaadinServletRequest createVaadinRequest(HttpServletRequest request) {
        return new VaadinServletRequest(request, this.getService());
    }

    public VaadinServletService getService() {
        return this.servletService;
    }

    private boolean ensureCookiesEnabled(VaadinServletRequest request, VaadinServletResponse response) throws IOException {
        if (HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL) && request.getRequestedSessionId() == null) {
            SystemMessages systemMessages = this.getService().getSystemMessages(HandlerHelper.findLocale(null, request), request);
            this.getService().writeUncachedStringResponse(response, "application/json; charset=UTF-8", VaadinService.createCriticalNotificationJSON(systemMessages.getCookiesDisabledCaption(), systemMessages.getCookiesDisabledMessage(), null, systemMessages.getCookiesDisabledURL()));
            return false;
        }
        return true;
    }

    static URL getApplicationUrl(HttpServletRequest request) throws MalformedURLException {
        URL reqURL = new URL((request.isSecure() ? "https://" : "http://") + request.getServerName() + (request.isSecure() && request.getServerPort() == 443 || !request.isSecure() && request.getServerPort() == 80 ? "" : ":" + request.getServerPort()) + request.getRequestURI());
        String servletPath = request.getAttribute("javax.servlet.include.servlet_path") != null ? request.getAttribute("javax.servlet.include.context_path").toString() + request.getAttribute("javax.servlet.include.servlet_path") : request.getContextPath() + request.getServletPath();
        if (servletPath.length() == 0 || servletPath.charAt(servletPath.length() - 1) != '/') {
            servletPath = servletPath + "/";
        }
        URL u = new URL(reqURL, servletPath);
        return u;
    }

    public void destroy() {
        super.destroy();
        this.isServletInitialized = false;
        if (this.getService() != null) {
            this.getService().destroy();
        }
    }

    private VaadinServletContext initializeContext() {
        ServletContext servletContext = this.getServletConfig().getServletContext();
        VaadinServletContext vaadinServletContext = new VaadinServletContext(servletContext);
        ApplicationClassLoaderAccess access = () -> servletContext.getClassLoader();
        vaadinServletContext.getAttribute(ApplicationClassLoaderAccess.class, () -> access);
        VaadinContextInitializer initializer = vaadinServletContext.getAttribute(VaadinContextInitializer.class);
        if (initializer != null) {
            initializer.initialize(vaadinServletContext);
        }
        return vaadinServletContext;
    }
}

