/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.internal.ReflectTools;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

@FunctionalInterface
public interface WebComponentExporterFactory<C extends Component>
extends Serializable {
    public WebComponentExporter<C> create();

    public static class DefaultWebComponentExporterFactory<C extends Component>
    implements WebComponentExporterFactory<C> {
        private final Class<? extends WebComponentExporter<C>> exporterClass;

        public DefaultWebComponentExporterFactory(Class<? extends WebComponentExporter<C>> exporterClass) {
            Objects.requireNonNull(exporterClass, "Parameter 'exporterClass' cannot be null!");
            this.exporterClass = exporterClass;
        }

        @Override
        public WebComponentExporter<C> create() {
            try {
                return ReflectTools.createInstance(this.exporterClass);
            }
            catch (Throwable t) {
                Throwable cause2;
                if (t.getCause() != null && t.getCause().getClass().equals(InvocationTargetException.class) && (cause2 = t.getCause().getCause()) != null && cause2.getClass().equals(WebComponentExporter.NullTagException.class)) {
                    throw new IllegalArgumentException(String.format("Unable to construct '%s'! Did '%s' give null value to super(String) constructor?", WebComponentConfiguration.class.getSimpleName(), this.exporterClass.getCanonicalName()), t);
                }
                throw new RuntimeException("Couldn't create a new instance of class " + this.exporterClass + " because of " + t.getClass().getSimpleName() + ": " + t.getMessage(), t);
            }
        }
    }
}

