/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.internal.DefaultRouteResolver;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.InternalRedirectHandler;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class Router
implements Serializable {
    private RouteResolver routeResolver;
    private final RouteRegistry registry;

    public Router(RouteRegistry registry) {
        assert (registry != null);
        this.registry = registry;
        this.routeResolver = new DefaultRouteResolver();
    }

    public void initializeUI(UI ui, VaadinRequest initRequest) {
        Location location = this.getLocationForRequest(initRequest.getPathInfo(), initRequest.getParameterMap());
        this.initializeUI(ui, location);
    }

    public void initializeUI(UI ui, Location location) {
        ui.getPage().getHistory().setHistoryStateChangeHandler(e -> this.navigate(ui, e.getLocation(), e.getTrigger(), e.getState().orElse(null)));
        int statusCode = this.navigate(ui, location, NavigationTrigger.PAGE_LOAD);
        VaadinResponse response = VaadinService.getCurrentResponse();
        if (response != null) {
            response.setStatus(statusCode);
        }
    }

    private Location getLocationForRequest(String pathInfo, Map<String, String[]> parameterMap) {
        String path;
        if (pathInfo == null) {
            path = "";
        } else {
            assert (pathInfo.startsWith("/"));
            path = pathInfo.substring(1);
        }
        QueryParameters queryParameters = QueryParameters.full(parameterMap);
        try {
            return new Location(path, queryParameters);
        }
        catch (IllegalArgumentException iae) {
            LoggerFactory.getLogger((String)Router.class.getName()).warn("Exception when parsing location path {}", (Object)path, (Object)iae);
            int index = path.indexOf(63);
            String encodedPath = path;
            if (index >= 0) {
                encodedPath = path.substring(0, index);
            }
            try {
                encodedPath = path.startsWith("/") ? URLEncoder.encode(path.substring(1), StandardCharsets.UTF_8.name()) : URLEncoder.encode(path, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LoggerFactory.getLogger((String)Router.class.getName()).warn("Exception when encoding path {}", (Object)path, (Object)e);
            }
            return new Location(encodedPath);
        }
    }

    public Optional<NavigationState> resolveNavigationTarget(String pathInfo, Map<String, String[]> parameterMap) {
        Location location = this.getLocationForRequest(pathInfo, parameterMap);
        return this.resolveNavigationTarget(location);
    }

    public Optional<NavigationState> resolveNavigationTarget(Location location) {
        NavigationState resolve = null;
        try {
            resolve = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        }
        catch (NotFoundException nfe) {
            LoggerFactory.getLogger((String)Router.class.getName()).warn("Failed to resolve navigation target for path: {}", (Object)location.getPath(), (Object)nfe);
        }
        return Optional.ofNullable(resolve);
    }

    public Optional<NavigationState> resolveRouteNotFoundNavigationTarget() {
        Optional<ErrorTargetEntry> errorTargetEntry = this.getErrorNavigationTarget(new NotFoundException());
        NavigationState result = null;
        if (errorTargetEntry.isPresent()) {
            result = new NavigationStateBuilder(this).withTarget(errorTargetEntry.get().getNavigationTarget()).build();
        }
        return Optional.ofNullable(result);
    }

    public int navigate(UI ui, Location location, NavigationTrigger trigger) {
        return this.navigate(ui, location, trigger, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int navigate(UI ui, Location location, NavigationTrigger trigger, JsonValue state) {
        assert (ui != null);
        assert (location != null);
        assert (trigger != null);
        ui.getSession().checkHasLock();
        if (this.handleNavigationForLocation(ui, location)) {
            try {
                int n = this.handleNavigation(ui, location, trigger, state);
                return n;
            }
            catch (Exception exception) {
                int n = this.handleExceptionNavigation(ui, location, exception, trigger, state);
                return n;
            }
            finally {
                ui.getInternals().clearLastHandledNavigation();
            }
        }
        return 304;
    }

    private boolean handleNavigationForLocation(UI ui, Location location) {
        if (ui.getInternals().hasLastHandledLocation()) {
            return !location.getPathWithQueryParameters().equals(ui.getInternals().getLastHandledLocation().getPathWithQueryParameters());
        }
        return true;
    }

    private int handleNavigation(UI ui, Location location, NavigationTrigger trigger, JsonValue state) {
        NavigationState newState = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        if (newState != null) {
            NavigationEvent navigationEvent = new NavigationEvent(this, location, ui, trigger, state, false);
            NavigationStateRenderer handler = new NavigationStateRenderer(newState);
            return handler.handle(navigationEvent);
        }
        if (!location.getPath().isEmpty()) {
            Location slashToggledLocation = location.toggleTrailingSlash();
            NavigationState slashToggledState = this.getRouteResolver().resolve(new ResolveRequest(this, slashToggledLocation));
            if (slashToggledState != null) {
                NavigationEvent navigationEvent = new NavigationEvent(this, slashToggledLocation, ui, trigger, state, false);
                InternalRedirectHandler handler = new InternalRedirectHandler(slashToggledLocation);
                return handler.handle(navigationEvent);
            }
        }
        throw new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
    }

    private int handleExceptionNavigation(UI ui, Location location, Exception exception, NavigationTrigger trigger, JsonValue state) {
        Optional<ErrorTargetEntry> maybeLookupResult = this.getErrorNavigationTarget(exception);
        if (maybeLookupResult.isPresent()) {
            ErrorTargetEntry lookupResult = maybeLookupResult.get();
            ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
            ErrorStateRenderer handler = new ErrorStateRenderer(new NavigationStateBuilder(this).withTarget(lookupResult.getNavigationTarget()).build());
            ErrorNavigationEvent navigationEvent = new ErrorNavigationEvent(this, location, ui, trigger, errorParameter, state);
            return handler.handle(navigationEvent);
        }
        throw new RuntimeException(exception);
    }

    private RouteResolver getRouteResolver() {
        return this.routeResolver;
    }

    public RouteRegistry getRegistry() {
        if (VaadinSession.getCurrent() != null) {
            return SessionRouteRegistry.getSessionRegistry(VaadinSession.getCurrent());
        }
        return this.registry;
    }

    public Optional<ErrorTargetEntry> getErrorNavigationTarget(Exception exception) {
        if (this.registry instanceof ApplicationRouteRegistry) {
            return ((ApplicationRouteRegistry)this.registry).getErrorNavigationTarget(exception);
        }
        return Optional.empty();
    }
}

