/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PathUtil
implements Serializable {
    public static List<String> getSegmentsList(String path) {
        String[] segments = (path = PathUtil.trimPath(path)).split("/");
        if (segments.length == 1 && segments[0].isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(segments));
    }

    public static String getPath(List<String> segments) {
        return PathUtil.trimPath(segments == null || segments.isEmpty() ? "" : String.join((CharSequence)"/", segments));
    }

    public static String getPath(String basePath, List<String> segments) {
        basePath = PathUtil.trimPath(basePath);
        return PathUtil.trimPath(basePath + (segments == null || segments.isEmpty() ? "" : "/" + String.join((CharSequence)"/", segments)));
    }

    public static String trimPath(String path) {
        if (path == null) {
            return "";
        }
        if ((path = path.trim()).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

