/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.HighlightAction;
import com.vaadin.flow.router.HighlightActions;
import com.vaadin.flow.router.HighlightCondition;
import com.vaadin.flow.router.HighlightConditions;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.server.VaadinService;
import java.util.Objects;
import java.util.Optional;

@Tag(value="a")
public class RouterLink
extends Component
implements HasText,
HasComponents,
HasStyle,
AfterNavigationObserver,
Focusable<RouterLink> {
    private static final PropertyDescriptor<String, String> HREF = PropertyDescriptors.attributeWithDefault("href", "", false);
    private HighlightCondition<RouterLink> highlightCondition = HighlightConditions.locationPrefix();
    private HighlightAction<RouterLink> highlightAction = HighlightActions.toggleAttribute("highlight");
    private QueryParameters queryParameters;

    public RouterLink() {
        this.getElement().setAttribute("router-link", "");
    }

    public RouterLink(String text, Class<? extends Component> navigationTarget) {
        this(text, navigationTarget, RouteParameters.empty());
    }

    public <T, C extends Component> RouterLink(String text, Class<? extends C> navigationTarget, T parameter) {
        this(text, navigationTarget, HasUrlParameterFormat.getParameters(parameter));
    }

    public RouterLink(String text, Class<? extends Component> navigationTarget, RouteParameters parameters) {
        this();
        this.setText(text);
        this.setRoute(this.getRouter(), navigationTarget, parameters);
    }

    public RouterLink(Router router, String text, Class<? extends Component> navigationTarget) {
        this(router, text, navigationTarget, RouteParameters.empty());
    }

    public <T, C extends Component> RouterLink(Router router, String text, Class<? extends C> navigationTarget, T parameter) {
        this(router, text, navigationTarget, HasUrlParameterFormat.getParameters(parameter));
    }

    public RouterLink(Router router, String text, Class<? extends Component> navigationTarget, RouteParameters parameters) {
        this();
        this.setText(text);
        this.setRoute(router, navigationTarget, parameters);
    }

    public void setRoute(Router router, Class<? extends Component> navigationTarget) {
        this.setRoute(router, navigationTarget, RouteParameters.empty());
    }

    public <T, C extends Component> void setRoute(Router router, Class<? extends C> navigationTarget, T parameter) {
        this.setRoute(router, navigationTarget, HasUrlParameterFormat.getParameters(parameter));
    }

    public void setRoute(Router router, Class<? extends Component> navigationTarget, RouteParameters parameters) {
        this.validateRouter(router);
        try {
            String url = RouteConfiguration.forRegistry(router.getRegistry()).getUrl(navigationTarget, parameters);
            this.updateHref(url);
        }
        catch (NotFoundException exception) {
            throw new IllegalArgumentException("Cannot set route for non registered " + navigationTarget, exception);
        }
    }

    public void setRoute(Class<? extends Component> navigationTarget) {
        this.setRoute(this.getRouter(), navigationTarget);
    }

    public <T, C extends Component> void setRoute(Class<? extends C> navigationTarget, T parameter) {
        this.setRoute(this.getRouter(), navigationTarget, parameter);
    }

    public void setRoute(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        this.setRoute(this.getRouter(), navigationTarget, parameters);
    }

    private void validateRouter(Router router) {
        if (router == null) {
            throw new IllegalArgumentException("Router must not be null");
        }
    }

    public String getHref() {
        return HREF.get(this);
    }

    public Optional<QueryParameters> getQueryParameters() {
        return Optional.ofNullable(this.queryParameters);
    }

    public void setQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        this.updateHref(this.getHref());
    }

    private void updateHref(String url) {
        int startOfQuery = url.indexOf(63);
        if (startOfQuery >= 0) {
            url = url.substring(0, startOfQuery);
        }
        if (this.queryParameters != null) {
            url = url + '?' + this.queryParameters.getQueryString();
        }
        HREF.set(this, url);
    }

    private Router getRouter() {
        Router router = null;
        if (this.getElement().getNode().isAttached()) {
            StateTree tree = (StateTree)this.getElement().getNode().getOwner();
            router = tree.getUI().getInternals().getRouter();
        }
        if (router == null) {
            router = VaadinService.getCurrent().getRouter();
        }
        if (router == null) {
            throw new IllegalStateException("Implicit router instance is not available. Use overloaded method with explicit router parameter.");
        }
        return router;
    }

    public HighlightCondition<RouterLink> getHighlightCondition() {
        return this.highlightCondition;
    }

    public void setHighlightCondition(HighlightCondition<RouterLink> highlightCondition) {
        Objects.requireNonNull(highlightCondition, "HighlightCondition may not be null");
        this.highlightCondition = highlightCondition;
    }

    public HighlightAction<RouterLink> getHighlightAction() {
        return this.highlightAction;
    }

    public void setHighlightAction(HighlightAction<RouterLink> highlightAction) {
        Objects.requireNonNull(this.highlightCondition, "HighlightAction may not be null");
        this.highlightAction.highlight(this, false);
        this.highlightAction = highlightAction;
    }

    @Override
    public void afterNavigation(AfterNavigationEvent event) {
        this.getHighlightAction().highlight(this, this.getHighlightCondition().shouldHighlight(this, event));
    }
}

