/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.ServletDeployer;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={Route.class, UIInitListener.class, VaadinServiceInitListener.class, WebComponentExporter.class, WebComponentExporterFactory.class, NpmPackage.class, NpmPackage.Container.class, JsModule.class, JsModule.Container.class, CssImport.class, CssImport.Container.class, JavaScript.class, JavaScript.Container.class, Theme.class, NoTheme.class, HasErrorParameter.class})
@WebListener
public class DevModeInitializer
implements ClassLoaderAwareServletContainerInitializer,
Serializable,
ServletContextListener {
    private static final Pattern JAR_FILE_REGEX = Pattern.compile(".*file:(.+\\.jar).*");
    private static final Pattern ZIP_PROTOCOL_JAR_FILE_REGEX = Pattern.compile("(.+\\.jar).*");
    private static final Pattern VFS_FILE_REGEX = Pattern.compile("(vfs:/.+\\.jar).*");
    private static final Pattern VFS_DIRECTORY_REGEX = Pattern.compile("vfs:/.+");
    private static final Pattern DIR_REGEX_FRONTEND_DEFAULT = Pattern.compile("^(?:file:0)?(.+)META-INF/frontend/?$");
    private static final Pattern DIR_REGEX_COMPATIBILITY_FRONTEND_DEFAULT = Pattern.compile("^(?:file:)?(.+)META-INF/resources/frontend/?$");
    private static final String DEV_MODE_HANDLER_ALREADY_STARTED_ATTRIBUTE = "dev-mode-handler-already-started-attribute";

    @Override
    public void process(Set<Class<?>> classes, ServletContext context) throws ServletException {
        Collection registrations = context.getServletRegistrations().values();
        ServletRegistration vaadinServletRegistration = null;
        for (ServletRegistration registration : registrations) {
            try {
                if (registration.getClassName() == null || !this.isVaadinServletSubClass(registration.getClassName())) continue;
                vaadinServletRegistration = registration;
                break;
            }
            catch (ClassNotFoundException e) {
                throw new ServletException(String.format("Servlet class name (%s) can't be found!", registration.getClassName()), (Throwable)e);
            }
        }
        DeploymentConfiguration config = vaadinServletRegistration != null ? ServletDeployer.StubServletConfig.createDeploymentConfiguration(context, vaadinServletRegistration, VaadinServlet.class) : ServletDeployer.StubServletConfig.createDeploymentConfiguration(context, VaadinServlet.class);
        DevModeInitializer.initDevModeHandler(classes, context, config);
        this.setDevModeStarted(context);
    }

    private boolean isVaadinServletSubClass(String className) throws ClassNotFoundException {
        return VaadinServlet.class.isAssignableFrom(Class.forName(className));
    }

    private void setDevModeStarted(ServletContext context) {
        context.setAttribute(DEV_MODE_HANDLER_ALREADY_STARTED_ATTRIBUTE, (Object)true);
    }

    public static void initDevModeHandler(Set<Class<?>> classes, ServletContext context, DeploymentConfiguration config) throws ServletException {
        if (config.isProductionMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because PRODUCTION MODE is set.");
            return;
        }
        if (!config.enableDevServer()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because dev server shouldn't be enabled.");
            return;
        }
        String baseDir = config.getStringProperty("project.basedir", null);
        if (baseDir == null) {
            baseDir = DevModeInitializer.getBaseDirectoryFallback();
        }
        String generatedDir = System.getProperty("vaadin.frontend.generated.folder", "target/frontend/");
        String frontendFolder = config.getStringProperty("vaadin.frontend.frontend.folder", System.getProperty("vaadin.frontend.frontend.folder", "./frontend/"));
        File flowResourcesFolder = new File(baseDir, "target/flow-frontend");
        NodeTasks.Builder builder = new NodeTasks.Builder(new DevModeClassFinder(classes), new File(baseDir), new File(generatedDir), new File(frontendFolder));
        DevModeInitializer.log().info("Starting dev-mode updaters in {} folder.", (Object)builder.npmFolder);
        if (!builder.generatedFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)builder.generatedFolder);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create directory '%s'", builder.generatedFolder), e);
            }
        }
        File generatedPackages = new File(builder.generatedFolder, "package.json");
        if (!new File(builder.npmFolder, "webpack.generated.js").exists()) {
            builder.withWebpack(builder.npmFolder, "webpack.config.js", "webpack.generated.js");
        }
        builder.useV14Bootstrap(config.useV14Bootstrap());
        if (!config.useV14Bootstrap()) {
            String connectJavaSourceFolder = config.getStringProperty("connect.javaSourceFolder", Paths.get(baseDir, "src/main/java").toString());
            String connectApplicationProperties = config.getStringProperty("connect.applicationProperties", Paths.get(baseDir, "src/main/resources/application.properties").toString());
            String connectOpenApiJsonFile = config.getStringProperty("connect.openApiFile", Paths.get(baseDir, "target/generated-resources/openapi.json").toString());
            String connectTsFolder = config.getStringProperty("connect.generated", Paths.get(baseDir, "./frontend/generated/").toString());
            builder.withConnectJavaSourceFolder(new File(connectJavaSourceFolder)).withConnectApplicationProperties(new File(connectApplicationProperties)).withConnectGeneratedOpenApiJson(new File(connectOpenApiJsonFile)).withConnectClientTsApiFolder(new File(connectTsFolder));
        }
        if (!new File(builder.npmFolder, "package.json").exists() || !generatedPackages.exists()) {
            builder.createMissingPackageJson(true);
        }
        Set<File> frontendLocations = DevModeInitializer.getFrontendLocationsFromClassloader(DevModeInitializer.class.getClassLoader());
        boolean useByteCodeScanner = config.getBooleanProperty("devmode.optimizeBundle", Boolean.parseBoolean(System.getProperty("devmode.optimizeBundle", Boolean.FALSE.toString())));
        boolean enablePnpm = config.isPnpmEnabled();
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        VaadinServletContext vaadinContext = new VaadinServletContext(context);
        JsonObject tokenFileData = Json.createObject();
        NodeTasks tasks = builder.enablePackagesUpdate(true).useByteCodeScanner(useByteCodeScanner).withFlowResourcesFolder(flowResourcesFolder).copyResources(frontendLocations).copyLocalResources(new File(baseDir, "src/main/resources/META-INF/resources/frontend")).enableImportsUpdate(true).runNpmInstall(true).populateTokenFileData(tokenFileData).withEmbeddableWebComponents(true).enablePnpm(enablePnpm).withHomeNodeExecRequired(useHomeNodeExec).build();
        CompletableFuture<Void> runNodeTasks = CompletableFuture.runAsync(() -> {
            try {
                tasks.execute();
                FallbackChunk chunk = FrontendUtils.readFallbackChunk(tokenFileData);
                if (chunk != null) {
                    vaadinContext.setAttribute(chunk);
                }
            }
            catch (ExecutionFailedException exception) {
                DevModeInitializer.log().debug("Could not initialize dev mode handler. One of the node tasks failed", (Throwable)exception);
                throw new CompletionException(exception);
            }
        });
        DevModeHandler.start(config, builder.npmFolder, runNodeTasks);
    }

    public static boolean isDevModeAlreadyStarted(ServletContext servletContext) {
        assert (servletContext != null);
        return servletContext.getAttribute(DEV_MODE_HANDLER_ALREADY_STARTED_ATTRIBUTE) != null;
    }

    private static Logger log() {
        return LoggerFactory.getLogger(DevModeInitializer.class);
    }

    public void contextInitialized(ServletContextEvent ctx) {
    }

    public void contextDestroyed(ServletContextEvent ctx) {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        if (handler != null && !handler.reuseDevServer()) {
            handler.stop();
        }
    }

    private static String getBaseDirectoryFallback() {
        String baseDirCandidate = System.getProperty("user.dir", ".");
        Path path = Paths.get(baseDirCandidate, new String[0]);
        if (path.toFile().isDirectory() && (path.resolve("pom.xml").toFile().exists() || path.resolve("build.gradle").toFile().exists())) {
            return path.toString();
        }
        throw new IllegalStateException(String.format("Failed to determine project directory for dev mode. Directory '%s' does not look like a Maven or Gradle project. Ensure that you have run the prepare-frontend Maven goal, which generates 'flow-build-info.json', prior to deploying your application", path.toString()));
    }

    static Set<File> getFrontendLocationsFromClassloader(ClassLoader classLoader) throws ServletException {
        HashSet<File> frontendFiles = new HashSet<File>();
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromClassloader(classLoader, "META-INF/frontend"));
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromClassloader(classLoader, "META-INF/resources/frontend"));
        return frontendFiles;
    }

    private static Set<File> getFrontendLocationsFromClassloader(ClassLoader classLoader, String resourcesFolder) throws ServletException {
        HashSet<File> frontendFiles = new HashSet<File>();
        try {
            Enumeration<URL> en = classLoader.getResources(resourcesFolder);
            if (en == null) {
                return frontendFiles;
            }
            HashSet<String> vfsJars = new HashSet<String>();
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                String urlString = url.toString();
                String path = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.name());
                Matcher jarMatcher = JAR_FILE_REGEX.matcher(path);
                Matcher zipProtocolJarMatcher = ZIP_PROTOCOL_JAR_FILE_REGEX.matcher(path);
                Matcher dirMatcher = DIR_REGEX_FRONTEND_DEFAULT.matcher(path);
                Matcher dirCompatibilityMatcher = DIR_REGEX_COMPATIBILITY_FRONTEND_DEFAULT.matcher(path);
                Matcher jarVfsMatcher = VFS_FILE_REGEX.matcher(urlString);
                Matcher dirVfsMatcher = VFS_DIRECTORY_REGEX.matcher(urlString);
                if (jarVfsMatcher.find()) {
                    String vfsJar = jarVfsMatcher.group(1);
                    if (!vfsJars.add(vfsJar)) continue;
                    frontendFiles.add(DevModeInitializer.getPhysicalFileOfJBossVfsJar(new URL(vfsJar)));
                    continue;
                }
                if (dirVfsMatcher.find()) {
                    URL vfsDirUrl = new URL(urlString.substring(0, urlString.lastIndexOf(resourcesFolder)));
                    frontendFiles.add(DevModeInitializer.getPhysicalFileOfJBossVfsDirectory(vfsDirUrl));
                    continue;
                }
                if (jarMatcher.find()) {
                    frontendFiles.add(new File(jarMatcher.group(1)));
                    continue;
                }
                if ("zip".equalsIgnoreCase(url.getProtocol()) && zipProtocolJarMatcher.find()) {
                    frontendFiles.add(new File(zipProtocolJarMatcher.group(1)));
                    continue;
                }
                if (dirMatcher.find()) {
                    frontendFiles.add(new File(dirMatcher.group(1)));
                    continue;
                }
                if (dirCompatibilityMatcher.find()) {
                    frontendFiles.add(new File(dirCompatibilityMatcher.group(1)));
                    continue;
                }
                DevModeInitializer.log().warn("Resource {} not visited because does not meet supported formats.", (Object)url.getPath());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return frontendFiles;
    }

    private static File getPhysicalFileOfJBossVfsDirectory(URL url) throws IOException, ServletException {
        try {
            Object virtualFile = url.openConnection().getContent();
            Class<?> virtualFileClass = virtualFile.getClass();
            Method getChildrenRecursivelyMethod = virtualFileClass.getMethod("getChildrenRecursively", new Class[0]);
            Method getPhysicalFileMethod = virtualFileClass.getMethod("getPhysicalFile", new Class[0]);
            List virtualFiles = (List)getChildrenRecursivelyMethod.invoke(virtualFile, new Object[0]);
            File rootDirectory = (File)getPhysicalFileMethod.invoke(virtualFile, new Object[0]);
            for (Object child : virtualFiles) {
                getPhysicalFileMethod.invoke(child, new Object[0]);
            }
            return rootDirectory;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new ServletException("Failed to invoke JBoss VFS API.", (Throwable)exc);
        }
    }

    private static File getPhysicalFileOfJBossVfsJar(URL url) throws IOException, ServletException {
        try {
            Object jarVirtualFile = url.openConnection().getContent();
            String vfsJarPath = url.toString();
            String fileNamePrefix = vfsJarPath.substring(vfsJarPath.lastIndexOf(47) + 1, vfsJarPath.lastIndexOf(".jar"));
            Path tempJar = Files.createTempFile(fileNamePrefix, ".jar", new FileAttribute[0]);
            DevModeInitializer.generateJarFromJBossVfsFolder(jarVirtualFile, tempJar);
            File tempJarFile = tempJar.toFile();
            tempJarFile.deleteOnExit();
            return tempJarFile;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new ServletException("Failed to invoke JBoss VFS API.", (Throwable)exc);
        }
    }

    private static void generateJarFromJBossVfsFolder(Object jarVirtualFile, Path tempJar) throws IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> virtualFileClass = jarVirtualFile.getClass();
        Method getChildrenRecursivelyMethod = virtualFileClass.getMethod("getChildrenRecursively", new Class[0]);
        Method openStreamMethod = virtualFileClass.getMethod("openStream", new Class[0]);
        Method isFileMethod = virtualFileClass.getMethod("isFile", new Class[0]);
        Method getPathNameRelativeToMethod = virtualFileClass.getMethod("getPathNameRelativeTo", virtualFileClass);
        List jarVirtualChildren = (List)getChildrenRecursivelyMethod.invoke(jarVirtualFile, new Object[0]);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempJar, new OpenOption[0]));){
            for (Object child : jarVirtualChildren) {
                if (!((Boolean)isFileMethod.invoke(child, new Object[0])).booleanValue()) continue;
                String relativePath = (String)getPathNameRelativeToMethod.invoke(child, jarVirtualFile);
                InputStream inputStream = (InputStream)openStreamMethod.invoke(child, new Object[0]);
                ZipEntry zipEntry = new ZipEntry(relativePath);
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
        }
    }

    static class DevModeClassFinder
    extends ClassFinder.DefaultClassFinder {
        private static final Set<String> APPLICABLE_CLASS_NAMES = Collections.unmodifiableSet(DevModeClassFinder.calculateApplicableClassNames());

        public DevModeClassFinder(Set<Class<?>> classes) {
            super(classes);
        }

        @Override
        public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
            this.ensureImplementation(annotation);
            return super.getAnnotatedClasses(annotation);
        }

        @Override
        public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
            this.ensureImplementation(type);
            return super.getSubTypesOf(type);
        }

        private void ensureImplementation(Class<?> clazz) {
            if (!APPLICABLE_CLASS_NAMES.contains(clazz.getName())) {
                throw new IllegalArgumentException("Unexpected class name " + clazz + ". Implementation error: the class finder instance is not aware of this class. Fix @HandlesTypes annotation value for " + DevModeInitializer.class.getName());
            }
        }

        private static Set<String> calculateApplicableClassNames() {
            HandlesTypes handlesTypes = DevModeInitializer.class.getAnnotation(HandlesTypes.class);
            return Stream.of(handlesTypes.value()).map(Class::getName).collect(Collectors.toSet());
        }
    }
}

