/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Inline;
import com.vaadin.flow.component.page.LoadingIndicatorConfiguration;
import com.vaadin.flow.component.page.TargetElement;
import com.vaadin.flow.server.BootstrapUtils;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.WebBrowser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;

public class AppShellSettings
implements Serializable {
    private final List<InlineElement> inlines = new ArrayList<InlineElement>();
    private final transient Map<Inline.Position, List<Element>> elements = new EnumMap<Inline.Position, List<Element>>(Inline.Position.class);

    public VaadinRequest getRequest() {
        return VaadinRequest.getCurrent();
    }

    public Optional<UI> getUi() {
        return Optional.ofNullable(UI.getCurrent());
    }

    public Optional<WebBrowser> getBrowser() {
        return this.getUi().map(ui -> ui.getSession().getBrowser());
    }

    public void setViewport(String viewport) {
        this.addMetaTag(Inline.Position.APPEND, "viewport", viewport);
    }

    public void setBodySize(String width, String height) {
        this.addInline(TargetElement.HEAD, Inline.Position.APPEND, Inline.Wrapping.STYLESHEET, null, "body,#outlet{width:" + width + ";height:" + height + ";}");
    }

    public void setPageTitle(String title) {
        ListIterator<Element> iter = this.getHeadElements(Inline.Position.APPEND).listIterator();
        while (iter.hasNext()) {
            if (!"title".equals(iter.next().normalName())) continue;
            iter.remove();
        }
        iter.add(AppShellSettings.createElement("title", title, new String[0]));
    }

    public void addInlineFromFile(String file, Inline.Wrapping type) {
        this.addInlineFromFile(Inline.Position.APPEND, file, type);
    }

    public void addInlineFromFile(Inline.Position position, String file, Inline.Wrapping type) {
        this.addInlineFromFile(TargetElement.HEAD, position, file, type);
    }

    public void addInlineFromFile(TargetElement target, Inline.Position position, String file, Inline.Wrapping type) {
        this.addInline(target, position, type, file, null);
    }

    public void addInlineWithContents(String contents, Inline.Wrapping type) {
        this.addInlineWithContents(Inline.Position.APPEND, contents, type);
    }

    public void addInlineWithContents(Inline.Position position, String contents, Inline.Wrapping type) {
        this.addInlineWithContents(TargetElement.HEAD, position, contents, type);
    }

    public void addInlineWithContents(TargetElement target, Inline.Position position, String contents, Inline.Wrapping type) {
        this.addInline(target, position, type, null, contents);
    }

    void addInline(Inline inline) {
        this.inlines.add(new InlineElement(inline));
    }

    private void addInline(TargetElement target, Inline.Position position, Inline.Wrapping type, String file, String content) {
        this.inlines.add(new InlineElement(target, position, type, file, content));
    }

    public void addLink(String href) {
        this.addLink(Inline.Position.APPEND, href);
    }

    public void addLink(Inline.Position position, String href) {
        this.addLink(position, href, new HashMap<String, String>());
    }

    public void addLink(String href, Map<String, String> attributes) {
        this.addLink(Inline.Position.APPEND, href, attributes);
    }

    public void addLink(Inline.Position position, String href, Map<String, String> attributes) {
        Element link = AppShellSettings.createElement("link", null, "href", href);
        attributes.forEach((arg_0, arg_1) -> ((Element)link).attr(arg_0, arg_1));
        this.getHeadElements(position).add(link);
    }

    public void addLink(String rel, String href) {
        this.addLink(Inline.Position.APPEND, rel, href);
    }

    public void addLink(Inline.Position position, String rel, String href) {
        this.getHeadElements(position).add(AppShellSettings.createElement("link", null, "href", href, "rel", rel));
    }

    public void addFavIcon(String rel, String href, String sizes) {
        this.addFavIcon(Inline.Position.APPEND, rel, href, sizes);
    }

    public void addFavIcon(Inline.Position position, String rel, String href, String sizes) {
        this.getHeadElements(position).add(AppShellSettings.createElement("link", null, "href", href, "rel", rel, "sizes", sizes));
    }

    public void addMetaTag(String name, String content) {
        this.addMetaTag(Inline.Position.APPEND, name, content);
    }

    public void addMetaTag(Inline.Position position, String name, String content) {
        Element meta = AppShellSettings.createElement("meta", null, "name", name, "content", content);
        this.getHeadElements(position).add(meta);
    }

    public Optional<LoadingIndicatorConfiguration> getLoadingIndicatorConfiguration() {
        return this.getUi().map(UI::getLoadingIndicatorConfiguration);
    }

    public Optional<ReconnectDialogConfiguration> getReconnectDialogConfiguration() {
        return this.getUi().map(UI::getReconnectDialogConfiguration);
    }

    public Optional<PushConfiguration> getPushConfiguration() {
        return this.getUi().map(UI::getPushConfiguration);
    }

    List<Element> getHeadElements(Inline.Position position) {
        return this.elements.computeIfAbsent(position, key -> new ArrayList());
    }

    List<Element> getInlineElements(VaadinRequest request, TargetElement target, Inline.Position position) {
        return this.inlines.stream().filter(inline -> ((InlineElement)inline).target == target && ((InlineElement)inline).position == position).map(inline -> ((InlineElement)inline).element(request)).collect(Collectors.toList());
    }

    private static Element createElement(String tag, String content, String ... attrs) {
        Element elm = new Element(Tag.valueOf((String)tag), "");
        if (content != null && !content.isEmpty()) {
            elm.appendChild((Node)new DataNode(content));
        }
        for (int i = 0; i < attrs.length - 1; i += 2) {
            elm.attr(attrs[i], attrs[i + 1]);
        }
        return elm;
    }

    private static final class InlineElement
    implements Serializable {
        private Inline.Position position;
        private Inline.Wrapping type;
        private TargetElement target;
        private String content;
        private String file;

        private InlineElement(TargetElement target, Inline.Position position, Inline.Wrapping type, String file, String content) {
            this.target = target;
            this.position = position;
            this.content = content;
            this.file = file;
            this.type = type;
        }

        private InlineElement(Inline ann) {
            this(ann.target(), ann.position(), ann.wrapping(), ann.value(), null);
        }

        private Element element(VaadinRequest request) {
            if (this.content == null) {
                this.content = BootstrapUtils.getDependencyContents(request, this.file);
            }
            if (this.type == Inline.Wrapping.AUTOMATIC && this.file != null) {
                if (this.file.toLowerCase().endsWith(".css")) {
                    this.type = Inline.Wrapping.STYLESHEET;
                } else if (this.file.toLowerCase().endsWith(".js")) {
                    this.type = Inline.Wrapping.JAVASCRIPT;
                }
            }
            if (this.type == Inline.Wrapping.STYLESHEET) {
                return AppShellSettings.createElement("style", this.content, new String[]{"type", "text/css"});
            }
            if (this.type == Inline.Wrapping.JAVASCRIPT) {
                return AppShellSettings.createElement("script", this.content, new String[]{"type", "text/javascript"});
            }
            return Jsoup.parse((String)this.content, (String)"", (Parser)Parser.xmlParser());
        }
    }
}

