/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.RouteRegistry;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class DefaultRouteResolver
implements RouteResolver {
    @Override
    public NavigationState resolve(ResolveRequest request) {
        RouteRegistry registry = request.getRouter().getRegistry();
        PathDetails path = this.findPathString(registry, request.getLocation().getSegments());
        if (path == null) {
            return null;
        }
        NavigationStateBuilder builder = new NavigationStateBuilder(request.getRouter());
        try {
            Class<? extends Component> navigationTarget = !path.segments.isEmpty() ? this.getNavigationTargetWithParameter(registry, path.path, path.segments) : this.getNavigationTarget(registry, path.path);
            if (HasUrlParameter.class.isAssignableFrom(navigationTarget)) {
                List<String> pathParameters = this.getPathParameters(request.getLocation().getPath(), path.path);
                if (!ParameterDeserializer.verifyParameters(navigationTarget, pathParameters)) {
                    return null;
                }
                builder.withTarget(navigationTarget, pathParameters);
            } else {
                builder.withTarget(navigationTarget);
            }
            builder.withPath(path.path);
        }
        catch (NotFoundException nfe) {
            String message = "Exception while navigation to path " + path;
            LoggerFactory.getLogger((String)this.getClass().getName()).warn(message, (Throwable)nfe);
            throw nfe;
        }
        return builder.build();
    }

    private PathDetails findPathString(RouteRegistry registry, List<String> pathSegments) {
        if (pathSegments.isEmpty()) {
            return null;
        }
        ArrayDeque<PathDetails> paths = new ArrayDeque<PathDetails>();
        StringBuilder pathBuilder = new StringBuilder(pathSegments.get(0));
        if (!"".equals(pathSegments.get(0))) {
            paths.push(new PathDetails("", pathSegments));
        }
        for (int i = 0; i < pathSegments.size(); ++i) {
            if (i != 0) {
                pathBuilder.append("/").append(pathSegments.get(i));
            }
            paths.push(new PathDetails(pathBuilder.toString(), pathSegments.subList(i + 1, pathSegments.size())));
        }
        while (!paths.isEmpty()) {
            PathDetails pathDetails = (PathDetails)paths.pop();
            Optional<Class<? extends Component>> target = registry.getNavigationTarget(pathDetails.path, pathDetails.segments);
            if (!target.isPresent()) continue;
            return pathDetails;
        }
        return null;
    }

    private Class<? extends Component> getNavigationTarget(RouteRegistry registry, String path) throws NotFoundException {
        return registry.getNavigationTarget(path).orElseThrow(() -> new NotFoundException(String.format("No navigation target found for path '%s'.", path)));
    }

    private Class<? extends Component> getNavigationTargetWithParameter(RouteRegistry registry, String path, List<String> segments) throws NotFoundException {
        return registry.getNavigationTarget(path, segments).orElseThrow(() -> new NotFoundException(String.format("No navigation target found for path '%s'.", path)));
    }

    private List<String> getPathParameters(String completePath, String routePath) {
        assert (completePath != null);
        assert (routePath != null);
        String parameterPart = completePath.replaceFirst(routePath, "");
        if (parameterPart.startsWith("/")) {
            parameterPart = parameterPart.substring(1, parameterPart.length());
        }
        if (parameterPart.endsWith("/")) {
            parameterPart = parameterPart.substring(0, parameterPart.length() - 1);
        }
        if (parameterPart.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(parameterPart.split("/"));
    }

    private static class PathDetails
    implements Serializable {
        private final String path;
        private final List<String> segments;

        public PathDetails(String path, List<String> segments) {
            this.path = path;
            this.segments = segments;
        }
    }
}

