/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.connect.generator.VaadinConnectClientGenerator;
import com.vaadin.flow.server.connect.generator.VaadinConnectTsGenerator;
import com.vaadin.flow.server.frontend.AbstractTaskConnectGenerator;
import java.io.File;
import java.util.Objects;

public class TaskGenerateConnect
extends AbstractTaskConnectGenerator {
    private final File outputFolder;
    private final File openApi;
    private final File connectClientFile;

    TaskGenerateConnect(File applicationProperties, File openApi, File outputFolder) {
        super(applicationProperties);
        Objects.requireNonNull(openApi, "Connect OpenAPI file should not be null.");
        Objects.requireNonNull(outputFolder, "Connect output folder should not be null.");
        this.openApi = openApi;
        this.outputFolder = outputFolder;
        this.connectClientFile = new File(outputFolder, "connect-client.default.ts");
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (VaadinConnectTsGenerator.launch(this.openApi, this.outputFolder)) {
            new VaadinConnectClientGenerator(this.readApplicationProperties()).generateVaadinConnectClientFile(this.connectClientFile.toPath());
        }
    }
}

