/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public final class BundleUtils {
    private static volatile ObjectNode cachedStatsJson = null;

    private BundleUtils() {
    }

    public static Set<String> loadBundleImports() {
        ObjectNode statsJson = BundleUtils.loadStatsJson();
        if (!statsJson.has("bundleImports")) {
            return null;
        }
        HashSet<String> bundledImports = new HashSet<String>();
        JsonNode bundleImports = statsJson.get("bundleImports");
        for (int i = 0; i < bundleImports.size(); ++i) {
            String jsImport = bundleImports.get(i).textValue();
            bundledImports.add(jsImport);
            bundledImports.add(jsImport.replace("/theme/lumo/", "/src/"));
            bundledImports.add(jsImport.replace("/theme/material/", "/src/"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/theme/(lumo|material)/", "./src/"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/", "./"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/generated/jar-resources/", ""));
            bundledImports.add(jsImport.replaceFirst("^Frontend/", "./"));
            bundledImports.add(jsImport.replaceFirst("^Frontend/", ""));
        }
        return Collections.unmodifiableSet(bundledImports);
    }

    static ObjectNode loadStatsJson() {
        ObjectNode cached = cachedStatsJson;
        if (cached != null) {
            return cached;
        }
        try (InputStream stats = BundleUtils.class.getClassLoader().getResourceAsStream("META-INF/VAADIN/config/stats.json");){
            if (stats == null) {
                cached = JacksonUtils.createObjectNode();
            } else {
                try {
                    cached = JacksonUtils.readTree(StringUtil.toUTF8String(stats));
                }
                catch (IOException e) {
                    BundleUtils.getLogger().warn("Unable to parse META-INF/VAADIN/config/stats.json", (Throwable)e);
                    cached = JacksonUtils.createObjectNode();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        cachedStatsJson = cached;
        return cached;
    }

    public static String getChunkId(Class<? extends Component> componentClass) {
        return BundleUtils.getChunkId(componentClass.getName());
    }

    public static String getChunkId(String className) {
        return StringUtil.getHash(className, StandardCharsets.UTF_8);
    }

    public static String getChunkHash(List<String> chunkLines) {
        ArrayList<String> sortedChunkLines = new ArrayList<String>(chunkLines);
        Collections.sort(sortedChunkLines);
        return StringUtil.getHash(String.join((CharSequence)";", sortedChunkLines), StandardCharsets.UTF_8);
    }

    public static boolean isPreCompiledProductionBundle() {
        ObjectNode stats = BundleUtils.loadStatsJson();
        return stats.has("pre-compiled");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleUtils.class);
    }

    public static void copyPackageLockFromBundle(Options options) {
        try {
            if (FrontendUtils.isPlatformMajorVersionUpdated(options.getClassFinder(), options.getNodeModulesFolder(), options.getNpmFolder(), options.getBuildDirectory())) {
                BundleUtils.getLogger().info("Platform version updated. Skipping bundle lock file copy.");
                return;
            }
        }
        catch (IOException ioe) {
            BundleUtils.getLogger().debug("Failed to validate platform version change.", (Throwable)ioe);
        }
        String lockFile = options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        File packageLock = new File(options.getNpmFolder(), lockFile);
        if (packageLock.exists()) {
            return;
        }
        try {
            BundleUtils.copyAppropriatePackageLock(options, packageLock);
        }
        catch (IOException ioe) {
            BundleUtils.getLogger().error("Failed to copy existing `" + lockFile + "` to use", (Throwable)ioe);
        }
    }

    private static void copyAppropriatePackageLock(Options options, File packageLock) throws IOException {
        File devPackageLock;
        String packageLockFile;
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        String string = packageLockFile = options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        if (devBundleFolder.exists() && (devPackageLock = new File(devBundleFolder, packageLockFile)).exists()) {
            Files.copy(devPackageLock.toPath(), packageLock.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        boolean hillaUsed = FrontendUtils.isHillaUsed(options.getFrontendDirectory(), options.getClassFinder());
        URL resource = null;
        if (hillaUsed) {
            resource = options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-" + packageLockFile);
        }
        if (resource == null) {
            if (hillaUsed) {
                BundleUtils.getLogger().debug("The '{}' template for hybrid application could not be found in dev-bundle JAR. Fallback to standard template.", (Object)packageLockFile);
            }
            resource = options.getClassFinder().getResource("vaadin-dev-bundle/" + packageLockFile);
        }
        if (resource != null) {
            String filecontents = FileIOUtils.urlToString(resource);
            Files.writeString(packageLock.toPath(), (CharSequence)filecontents, new OpenOption[0]);
        } else {
            BundleUtils.getLogger().debug("The '{}' file cannot be created because the dev-bundle JAR does not contain a suitable template.", (Object)packageLockFile);
        }
    }
}

