/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CustomElements
implements Serializable {
    private final Map<String, Set<Class<? extends Component>>> elements = new HashMap<String, Set<Class<? extends Component>>>();

    CustomElements() {
    }

    private static Optional<String> validateComponentClasses(String tagName, Set<Class<? extends Component>> componentClasses) {
        if (componentClasses.size() > 1) {
            return Optional.of(String.format("Several components are declared with the same @Tag(\"%s\") annotation: %s. Only components that form a hierarchy are allowed to have the same @Tag annotation. Otherwise it's not possible to do mapping between a tag name and a template class in order to instantiate the template when it's defined inside another template", tagName, componentClasses));
        }
        if (componentClasses.size() < 1) {
            return Optional.of(String.format("Had received tag with name '%s' and no corresponding classes", tagName));
        }
        return Optional.empty();
    }

    private static Class<? extends Component> getComponentClass(Map.Entry<String, Set<Class<? extends Component>>> entry) {
        Set<Class<? extends Component>> componentClasses = entry.getValue();
        CustomElements.validateComponentClasses(entry.getKey(), componentClasses).ifPresent(exceptionMessage -> {
            throw new IllegalStateException((String)exceptionMessage);
        });
        return componentClasses.iterator().next();
    }

    Map<String, Class<? extends Component>> computeTagToElementRelation() {
        return this.elements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, CustomElements::getComponentClass));
    }

    void addElement(String elementName, Class<? extends Component> newClass) {
        this.elements.put(elementName, this.elements.computeIfAbsent(elementName, key -> Collections.singleton(newClass)).stream().map(oldClass -> CustomElements.extractNonRelatedClasses(oldClass, newClass)).flatMap(Function.identity()).collect(Collectors.toSet()));
    }

    private static Stream<Class<? extends Component>> extractNonRelatedClasses(Class<? extends Component> class1, Class<? extends Component> class2) {
        if (class1.isAssignableFrom(class2)) {
            return Stream.of(class1);
        }
        if (class2.isAssignableFrom(class1)) {
            return Stream.of(class2);
        }
        return Stream.of(class1, class2);
    }
}

