/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.theme.Theme;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;

public class ThemeUtils {
    private static final Pattern THEME_GENERATED_FILE_PATTERN = Pattern.compile("theme-([\\s\\S]+?)\\.generated\\.js");

    private ThemeUtils() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ThemeUtils.class);
    }

    public static Optional<String> getThemeName(VaadinContext context) {
        ApplicationConfiguration config = ApplicationConfiguration.get(context);
        if (config.isProductionMode()) {
            return ThemeUtils.getThemeAnnotation(context).map(Theme::value);
        }
        File frontendFolder = config.getFrontendFolder();
        File themeJs = frontendFolder.isAbsolute() ? Paths.get(frontendFolder.getPath(), "generated/", "theme.js").toFile() : Paths.get(config.getProjectFolder().getPath(), frontendFolder.getPath(), "generated/", "theme.js").toFile();
        if (!themeJs.exists()) {
            return Optional.empty();
        }
        try {
            String themeJsContent = Files.readString(themeJs.toPath(), StandardCharsets.UTF_8);
            Matcher matcher = THEME_GENERATED_FILE_PATTERN.matcher(themeJsContent);
            if (matcher.find()) {
                return Optional.of(matcher.group(1));
            }
            throw new IllegalStateException("Couldn't extract theme name from theme imports file 'theme.js'");
        }
        catch (IOException e) {
            ThemeUtils.getLogger().error("Couldn't read theme generated file to get the theme name", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<Theme> getThemeAnnotation(VaadinContext context) {
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        Class<? extends AppShellConfigurator> shell = registry.getShell();
        if (shell == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(shell.getAnnotation(Theme.class));
    }

    public static Optional<JsonNode> getThemeJson(String themeName, AbstractConfiguration config) {
        String content = null;
        try {
            if (config.isProductionMode()) {
                URL themeJsonUrl = ThemeUtils.getThemeResourceFromPrecompiledProductionBundle(Paths.get("themes", themeName, "theme.json").toString());
                if (themeJsonUrl != null) {
                    content = FileIOUtils.urlToString(themeJsonUrl);
                }
            } else {
                File frontendFolder = FrontendUtils.getProjectFrontendDir(config);
                File themeFolder = ThemeUtils.getThemeFolder(frontendFolder, themeName);
                File themeJsonFile = new File(themeFolder, "theme.json");
                if (themeJsonFile.exists()) {
                    content = Files.readString(themeJsonFile.toPath(), StandardCharsets.UTF_8);
                }
            }
        }
        catch (IOException e) {
            ThemeUtils.getLogger().error("Unable to read theme.json file of theme=" + themeName, (Throwable)e);
        }
        return content != null ? Optional.of(JacksonUtils.readTree(content)) : Optional.empty();
    }

    public static URL getThemeResourceFromPrecompiledProductionBundle(String themeAssetPath) {
        URL resourceUrl = ThemeUtils.class.getClassLoader().getResource(FrontendUtils.getUnixPath(Paths.get("META-INF/VAADIN/webapp/", "VAADIN/static/", themeAssetPath)));
        if (resourceUrl == null) {
            resourceUrl = ThemeUtils.class.getClassLoader().getResource("META-INF/resources/" + themeAssetPath);
        }
        return resourceUrl;
    }

    public static Optional<JsonNode> getThemeJson(String themeName, File frontendFolder) {
        File themeFolder = ThemeUtils.getThemeFolder(frontendFolder, themeName);
        File themeJsonFile = new File(themeFolder, "theme.json");
        if (themeJsonFile.exists()) {
            try {
                String content = Files.readString(themeJsonFile.toPath(), StandardCharsets.UTF_8);
                return Optional.of(JacksonUtils.readTree(content));
            }
            catch (IOException e) {
                ThemeUtils.getLogger().error("Unable to read theme json from " + String.valueOf(themeJsonFile), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getParentThemeName(JsonNode themeJson) {
        if (themeJson != null && themeJson.has("parent")) {
            String parentThemeName = themeJson.get("parent").textValue();
            return Optional.of(parentThemeName);
        }
        return Optional.empty();
    }

    public static List<String> getActiveThemes(VaadinContext context) {
        Optional<String> applicationTheme = ThemeUtils.getThemeName(context);
        if (!applicationTheme.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<String> themes = new ArrayList<String>();
        ApplicationConfiguration config = ApplicationConfiguration.get(context);
        ThemeUtils.findActiveThemes(applicationTheme.get(), themes, config);
        Collections.reverse(themes);
        return themes;
    }

    public static File getThemeFolder(File frontendFolder, String themeName) throws IllegalArgumentException {
        File packagedThemesFolder = new File(FrontendUtils.getJarResourcesFolder(frontendFolder), "themes");
        File projectThemesFolder = new File(frontendFolder, "themes");
        File themeInProject = new File(projectThemesFolder, themeName);
        if (themeInProject.exists()) {
            return themeInProject;
        }
        File themeFromJar = new File(packagedThemesFolder, themeName);
        if (themeFromJar.exists()) {
            return themeFromJar;
        }
        throw new IllegalArgumentException("The theme folder for the '" + themeName + "' theme was not found. It should be either in " + String.valueOf(themeInProject) + " or in " + String.valueOf(themeFromJar));
    }

    private static void findActiveThemes(String themeName, List<String> themes, AbstractConfiguration config) {
        Optional<String> parentTheme;
        themes.add(themeName);
        Optional<JsonNode> themeJson = ThemeUtils.getThemeJson(themeName, config);
        if (themeJson.isPresent() && (parentTheme = ThemeUtils.getParentThemeName(themeJson.get())).isPresent()) {
            ThemeUtils.findActiveThemes(parentTheme.get(), themes, config);
        }
    }

    public static String getThemeFilePath(String themeName, String fileName) {
        return "VAADIN/themes/" + themeName + "/" + fileName;
    }
}

