/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class TaskGenerateTailwindCss
extends AbstractTaskClientGenerator {
    private static final String RELATIVE_SOURCE_PATH_MARKER = "#relativeSourcePath#";
    private String relativeSourcePath;
    private File tailwindCss;

    TaskGenerateTailwindCss(Options options) {
        this.tailwindCss = new File(options.getFrontendGeneratedFolder(), "tailwind.css");
        this.relativeSourcePath = options.getFrontendGeneratedFolder().toPath().relativize(options.getNpmFolder().toPath().resolve("src")).toString();
        this.relativeSourcePath = this.relativeSourcePath.replace(File.separator, "/");
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream indexStream = this.getClass().getResourceAsStream("tailwind.css");){
            String template = StringUtil.toUTF8String(indexStream);
            String string = template = template.replace(RELATIVE_SOURCE_PATH_MARKER, this.relativeSourcePath);
            return string;
        }
    }

    @Override
    protected File getGeneratedFile() {
        return this.tailwindCss;
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

