/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinSession;

public enum SessionLockCheckStrategy {
    ASSERT{

        @Override
        public void checkHasLock(VaadinSession session, String message) {
            assert (session.hasLock()) : message;
        }
    }
    ,
    LOG{

        @Override
        public void checkHasLock(VaadinSession session, String message) {
            if (!session.hasLock()) {
                session.getLogger().warn(message, (Throwable)new IllegalStateException(message));
            }
        }
    }
    ,
    THROW{

        @Override
        public void checkHasLock(VaadinSession session, String message) {
            if (!session.hasLock()) {
                throw new IllegalStateException(message);
            }
        }
    };


    public abstract void checkHasLock(VaadinSession var1, String var2);
}

