/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.LocaleUtil;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import com.vaadin.flow.internal.springcsrf.SpringCsrfTokenUtil;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.DevToolsToken;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class IndexHtmlRequestHandler
extends JavaScriptBootstrapHandler {
    private static final String SCRIPT = "script";
    private static final String SCRIPT_INITIAL = "initial";
    public static final String LIVE_RELOAD_PORT_ATTR = "livereload.port";

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        IndexHtmlResponse indexHtmlResponse;
        if (this.writeErrorCodeIfRequestLocationIsInvalid(request, response)) {
            return true;
        }
        DeploymentConfiguration config = session.getConfiguration();
        VaadinService service = request.getService();
        Document indexDocument = config.isProductionMode() ? IndexHtmlRequestHandler.getCachedIndexHtmlDocument(service) : IndexHtmlRequestHandler.getIndexHtmlDocument(service);
        IndexHtmlRequestHandler.prependBaseHref(request, indexDocument);
        Element htmlElement = (Element)indexDocument.getElementsByTag("html").get(0);
        if (!htmlElement.hasAttr("lang")) {
            Locale locale = LocaleUtil.getLocale(LocaleUtil::getI18NProvider);
            htmlElement.attr("lang", locale.getLanguage());
        }
        this.initializeFeatureFlags(indexDocument, request);
        ObjectNode initialJson = JacksonUtils.createObjectNode();
        if (service.getBootstrapInitialPredicate().includeInitialUidl(request)) {
            this.includeInitialUidl(initialJson, session, request, response);
            UI ui = UI.getCurrent();
            Element flowContainerElement = new Element(ui.getInternals().getContainerTag());
            flowContainerElement.attr("id", ui.getInternals().getAppId());
            Elements outlet = indexDocument.body().select("#outlet");
            if (!outlet.isEmpty()) {
                outlet.first().appendChild((Node)flowContainerElement);
            } else {
                indexDocument.body().appendChild((Node)flowContainerElement);
            }
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument, ui);
        } else {
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument);
        }
        this.addInitialFlow(initialJson, indexDocument, request);
        this.configureErrorDialogStyles(indexDocument);
        this.configureHiddenElementStyles(indexDocument);
        this.addStyleTagReferences(indexDocument, config.isProductionMode());
        response.setContentType("text/html; charset=utf-8");
        VaadinContext context = session.getService().getContext();
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        if (!config.isProductionMode()) {
            UsageStatisticsExporter.exportUsageStatisticsToDocument(indexDocument);
        }
        IndexHtmlRequestHandler.setupPwa(indexDocument, session.getService());
        registry.modifyIndexHtml(indexDocument, request);
        this.storeAppShellTitleToUI(indexDocument);
        this.redirectToOldBrowserPageWhenNeeded(indexDocument);
        if (!config.isProductionMode()) {
            IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.developmentMode = true;\n");
        }
        IndexHtmlRequestHandler.addDevBundleTheme(indexDocument, context);
        this.applyThemeVariant(indexDocument, context);
        if (config.isDevToolsEnabled()) {
            this.addDevTools(indexDocument, config, session, request);
            this.catchErrorsInDevMode(indexDocument);
            IndexHtmlRequestHandler.addLicenseChecker(indexDocument);
        } else if (!config.isProductionMode()) {
            IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.devToolsPlugins = {\n    push: function(plugin) {\n        window.console.debug(\"Vaadin Dev Tools disabled. Plugin cannot be registered.\", plugin);\n    }\n};\n");
        }
        service.modifyIndexHtmlResponse(indexHtmlResponse);
        IndexHtmlRequestHandler.addCommercialBanner(service.getDeploymentConfiguration(), indexDocument);
        try {
            response.getOutputStream().write(indexDocument.html().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            IndexHtmlRequestHandler.getLogger().error("Error writing 'index.html' to response", (Throwable)e);
            return false;
        }
        return true;
    }

    private void initializeFeatureFlags(Document indexDocument, VaadinRequest request) {
        String script = IndexHtmlRequestHandler.featureFlagsInitializer(request);
        Element scriptElement = indexDocument.head().prependElement(SCRIPT);
        scriptElement.attr(SCRIPT_INITIAL, "");
        scriptElement.appendChild((Node)new DataNode(script));
    }

    static String featureFlagsInitializer(VaadinRequest request) {
        return FeatureFlags.get(request.getService().getContext()).getFeatures().stream().filter(Feature::isEnabled).map(feature -> String.format("activator(\"%s\");", feature.getId())).collect(Collectors.joining("\n", "window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.featureFlagsUpdaters = window.Vaadin.featureFlagsUpdaters || [];\nwindow.Vaadin.featureFlagsUpdaters.push((activator) => {\n", "});"));
    }

    private static void addDevBundleTheme(Document document, VaadinContext context) {
        ApplicationConfiguration config = ApplicationConfiguration.get(context);
        if (config.getMode() == Mode.DEVELOPMENT_BUNDLE || config.getMode() == Mode.PRODUCTION_PRECOMPILED_BUNDLE) {
            try {
                BootstrapHandler.getStylesheetTags(context, "styles.css").forEach(link -> document.head().appendChild((Node)link));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create a tag for 'styles.css' in the document", e);
            }
        }
    }

    private void applyThemeVariant(Document indexDocument, VaadinContext context) {
        ThemeUtils.getThemeAnnotation(context).ifPresent(theme -> {
            String variant = theme.variant();
            if (!variant.isEmpty()) {
                indexDocument.head().parent().attr("theme", variant);
            }
        });
    }

    private void addStyleTagReferences(Document indexDocument, boolean productionMode) {
        Elements links;
        int insertLocation = -1;
        if (productionMode && !(links = indexDocument.head().getElementsByTag("link")).isEmpty()) {
            insertLocation = indexDocument.head().childNodes().indexOf(links.first());
        }
        Comment cssImportComment = new Comment("CSSImport end");
        Comment stylesheetComment = new Comment("Stylesheet end");
        indexDocument.head().insertChildren(insertLocation, new Node[]{cssImportComment, stylesheetComment});
    }

    private void redirectToOldBrowserPageWhenNeeded(Document indexDocument) {
        IndexHtmlRequestHandler.addScript(indexDocument, "if (!('CSSLayerBlockRule' in window)) {\n    window.location.search='v-r=oldbrowser';\n}\n");
    }

    private void catchErrorsInDevMode(Document indexDocument) {
        IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {};window.Vaadin.ConsoleErrors = window.Vaadin.ConsoleErrors || [];const browserConsoleError = window.console.error.bind(window.console);console.error = (...args) => {    browserConsoleError(...args);    window.Vaadin.ConsoleErrors.push(args);};window.onerror = (message, source, lineno, colno, error) => {const location=source+':'+lineno+':'+colno;window.Vaadin.ConsoleErrors.push([message, '('+location+')']);};window.addEventListener('unhandledrejection', e => {    window.Vaadin.ConsoleErrors.push([e.reason]);});");
    }

    public static void addLicenseChecker(Document indexDocument) {
        IndexHtmlRequestHandler.addScript(indexDocument, "window.Vaadin = window.Vaadin || {};window.Vaadin.VaadinLicenseChecker = {  maybeCheck: (productInfo) => {  }};window.Vaadin.devTools = window.Vaadin.devTools || {};window.Vaadin.devTools.createdCvdlElements = window.Vaadin.devTools.createdCvdlElements || [];window.Vaadin.originalCustomElementDefineFn = window.Vaadin.originalCustomElementDefineFn || window.customElements.define;window.customElements.define = function (tagName, constructor, ...args) {const { cvdlName, version } = constructor;if (cvdlName && version) {  const { connectedCallback } = constructor.prototype;  constructor.prototype.connectedCallback = function () {    window.Vaadin.devTools.createdCvdlElements.push(this);    if (connectedCallback) {      connectedCallback.call(this);    }  }}window.Vaadin.originalCustomElementDefineFn.call(this, tagName, constructor, ...args);};");
    }

    private static void addScript(Document indexDocument, String script) {
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.appendChild((Node)new DataNode(script));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private static void addScriptSrc(Document indexDocument, String scriptUrl) {
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.attr("src", scriptUrl);
        indexDocument.head().appendChild((Node)elm);
    }

    private void storeAppShellTitleToUI(Document indexDocument) {
        Element elm;
        if (UI.getCurrent() != null && (elm = indexDocument.head().selectFirst("title")) != null) {
            String appShellTitle = elm.text().isEmpty() ? elm.data() : elm.text();
            UI.getCurrent().getInternals().setAppShellTitle(appShellTitle);
        }
    }

    private void addDevTools(Document indexDocument, DeploymentConfiguration config, VaadinSession session, VaadinRequest request) {
        VaadinServletContext vaadinServletContext;
        String customPort;
        VaadinService service = session.getService();
        Optional<BrowserLiveReload> liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(service);
        Optional<BrowserLiveReload.Backend> maybeBackend = liveReload.map(BrowserLiveReload::getBackend);
        Integer liveReloadPort = null;
        VaadinContext context = service.getContext();
        if (context instanceof VaadinServletContext && (customPort = (String)(vaadinServletContext = (VaadinServletContext)context).getContext().getAttribute(LIVE_RELOAD_PORT_ATTR)) != null) {
            liveReloadPort = Integer.parseInt(customPort);
        }
        ObjectNode devToolsConf = JacksonUtils.createObjectNode();
        devToolsConf.put("enable", config.isDevModeLiveReloadEnabled());
        devToolsConf.put("url", BootstrapHandlerHelper.getPushURL(session, request));
        devToolsConf.put("contextRelativePath", service.getContextRootRelativePath(request));
        maybeBackend.ifPresent(backend -> devToolsConf.put("backend", backend.toString()));
        if (liveReloadPort != null) {
            devToolsConf.put("liveReloadPort", liveReloadPort);
        }
        if (IndexHtmlRequestHandler.isAllowedDevToolsHost(config, request)) {
            devToolsConf.put("token", DevToolsToken.getToken());
        }
        IndexHtmlRequestHandler.addScript(indexDocument, String.format("window.Vaadin.devToolsPlugins = [];\nwindow.Vaadin.devToolsConf = %s;\n", devToolsConf));
        indexDocument.body().appendChild((Node)new Element("vaadin-dev-tools"));
        String pushUrl = BootstrapHandlerHelper.getServiceUrl(request) + "/VAADIN/static/push/vaadinPush.js";
        IndexHtmlRequestHandler.addScriptSrc(indexDocument, pushUrl);
    }

    static boolean isAllowedDevToolsHost(AbstractConfiguration configuration, VaadinRequest request) {
        String hostsAllowed;
        String remoteAddress = request.getRemoteAddr();
        String hostsAllowedFromCfg = configuration.getStringProperty("devmode.hostsAllowed", null);
        String string = hostsAllowed = hostsAllowedFromCfg != null && !hostsAllowedFromCfg.isBlank() ? hostsAllowedFromCfg : null;
        if (!IndexHtmlRequestHandler.isAllowedDevToolsHost(remoteAddress, hostsAllowed, true)) {
            return false;
        }
        String remoteHeaderIp = configuration.getStringProperty("devmode.remoteAddressHeader", null);
        if (remoteHeaderIp != null) {
            return IndexHtmlRequestHandler.isAllowedDevToolsHost(request.getHeader(remoteHeaderIp), hostsAllowed, false);
        }
        Enumeration<String> allForwardedForHeaders = request.getHeaders("X-Forwarded-For");
        if (allForwardedForHeaders != null && allForwardedForHeaders.hasMoreElements()) {
            String forwardedFor = String.join((CharSequence)",", Collections.list(allForwardedForHeaders));
            if (forwardedFor.contains(",")) {
                String[] hops = forwardedFor.split(",");
                if (hops.length > 0) {
                    return Stream.of(hops).map(String::trim).allMatch(ip -> IndexHtmlRequestHandler.isAllowedDevToolsHost(ip, hostsAllowed, false));
                }
                return false;
            }
            return IndexHtmlRequestHandler.isAllowedDevToolsHost(forwardedFor.trim(), hostsAllowed, false);
        }
        return true;
    }

    private static boolean isAllowedDevToolsHost(String remoteAddress, String hostsAllowed, boolean allowLocal) {
        if (remoteAddress == null || remoteAddress.isBlank() || hostsAllowed == null && !allowLocal) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(remoteAddress);
            if (inetAddress.isLoopbackAddress()) {
                return allowLocal;
            }
        }
        catch (Exception e) {
            IndexHtmlRequestHandler.getLogger().debug("Unable to resolve remote address: '{}', so we are preventing the web socket connection", (Object)remoteAddress, (Object)e);
            return false;
        }
        if (hostsAllowed != null) {
            String[] allowedHosts;
            for (String allowedHost : allowedHosts = hostsAllowed.split(",")) {
                if (!FileIOUtils.wildcardMatch(remoteAddress, allowedHost.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private void addInitialFlow(ObjectNode initialJson, Document indexDocument, VaadinRequest request) {
        SpringCsrfTokenUtil.addTokenAsMetaTagsToHeadIfPresentInRequest(indexDocument.head(), request);
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.appendChild((Node)new DataNode("window.Vaadin = window.Vaadin || {};window.Vaadin.TypeScript= " + initialJson.toString() + ";"));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void includeInitialUidl(ObjectNode initialJson, VaadinSession session, VaadinRequest request, VaadinResponse response) {
        ObjectNode initial = this.getInitialJson(request, response, session);
        initialJson.set(SCRIPT_INITIAL, (JsonNode)initial);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return this.isRequestForHtml(request) && !BootstrapHandler.isFrameworkInternalRequest(request) && !BootstrapHandler.isVaadinStaticFileRequest(request) && request.getService().getBootstrapUrlPredicate().isValidUrl(request);
    }

    @Override
    protected void initializeUIWithRouter(BootstrapHandler.BootstrapContext context, UI ui) {
        if (context.getService().getBootstrapInitialPredicate().includeInitialUidl(context.getRequest())) {
            ui.getInternals().getRouter().initializeUI(ui, context.getRoute());
        }
    }

    private void configureErrorDialogStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupErrorDialogs(styles);
    }

    private void configureHiddenElementStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupHiddenElement(styles);
    }

    private static void prependBaseHref(VaadinRequest request, Document indexDocument) {
        Elements base = indexDocument.head().getElementsByTag("base");
        String baseHref = IndexHtmlRequestHandler.getServiceUrl(request);
        if (base.isEmpty()) {
            indexDocument.head().prependElement("base").attr("href", baseHref);
        } else {
            base.first().attr("href", baseHref);
        }
    }

    private static Document getCachedIndexHtmlDocument(VaadinService service) {
        return service.getContext().getAttribute(IndexHtmlHolder.class, () -> new IndexHtmlHolder(service)).getDocument();
    }

    private static Document getIndexHtmlDocument(VaadinService service) throws IOException {
        String index;
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        try {
            index = FrontendUtils.getIndexHtmlContent(service);
        }
        catch (IOException e) {
            if (config.getMode() == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD) {
                throw new IOException("Unable to fetch index.html from the frontend development server, check the server logs that it is running");
            }
            throw new IOException("Unable to find index.html. It should be available on the classpath");
        }
        if (index == null) {
            if (config.isProductionMode()) {
                throw new IOException("Unable to find index.html. It should be available on the classpath when running in production mode");
            }
            throw new IOException("Unable to find index.html. It should be available in the frontend folder when running in development mode");
        }
        Document indexHtmlDocument = Jsoup.parse((String)index);
        Mode mode = config.getMode();
        if (!mode.isProduction() && mode == Mode.DEVELOPMENT_BUNDLE) {
            IndexHtmlRequestHandler.addGeneratedIndexContent(indexHtmlDocument, IndexHtmlRequestHandler.getStatsJson(config));
        }
        IndexHtmlRequestHandler.modifyIndexHtmlForVite(indexHtmlDocument);
        return indexHtmlDocument;
    }

    protected static void addGeneratedIndexContent(Document targetDocument, ObjectNode statsJson) {
        ArrayNode indexHtmlGeneratedRows = (ArrayNode)statsJson.get("indexHtmlGenerated");
        ArrayList<String> toAdd = new ArrayList<String>(JacksonUtils.stream(indexHtmlGeneratedRows).map(JsonNode::asText).toList());
        for (String row : toAdd) {
            targetDocument.head().append(row);
        }
    }

    private static void modifyIndexHtmlForVite(Document indexHtmlDocument) {
        indexHtmlDocument.head().prepend("<script type='text/javascript'>window.JSCompiler_renameProperty = function(a) { return a;}</script>");
    }

    static void addCommercialBanner(DeploymentConfiguration config, Document indexDocument) {
        System.clearProperty("vaadin.commercialBanner.enable");
        if (config.isProductionMode() && config.getBooleanProperty("commercialBanner.enable", false)) {
            Element elm = new Element(SCRIPT);
            elm.attr(SCRIPT_INITIAL, "");
            elm.attr("type", "module");
            elm.appendChild((Node)new DataNode("const root = document.body.attachShadow({ mode: 'closed' })\nroot.innerHTML = '<slot></slot><vaadin-commercial-banner></vaadin-commercial-banner>'\n"));
            indexDocument.head().insertChildren(0, new Node[]{elm});
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IndexHtmlRequestHandler.class);
    }

    static final class IndexHtmlHolder
    implements Serializable {
        private final transient Document indexHtmlDocument;

        private IndexHtmlHolder(VaadinService service) {
            try {
                this.indexHtmlDocument = IndexHtmlRequestHandler.getIndexHtmlDocument(service);
                this.indexHtmlDocument.outputSettings().prettyPrint(false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Document getDocument() {
            return this.indexHtmlDocument.clone();
        }
    }
}

