/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dependency;

import com.vaadin.flow.hotswap.HotswapResourceEvent;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleSheetHotswapper
implements VaadinHotswapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(StyleSheetHotswapper.class);

    @Override
    public void onResourcesChange(HotswapResourceEvent event) {
        if (event.anyMatches(".*\\.css")) {
            LOGGER.debug("Triggering browser live reload because of CSS resources changes");
            VaadinService vaadinService = event.getVaadinService();
            File buildResourcesFolder = vaadinService.getDeploymentConfiguration().getOutputResourceFolder();
            List<String> publicStaticResourcesPaths = Stream.of("META-INF/resources", "resources", "static", "public").map(path -> new File(buildResourcesFolder, (String)path)).filter(File::exists).map(staticResourceFolder -> FrontendUtils.getUnixPath(staticResourceFolder.toPath())).toList();
            event.getChangedResources().stream().filter(uri -> !new File(uri.getPath()).isDirectory()).forEach(resource -> {
                String resourcePath = resource.getPath();
                for (String staticResourcesPath : publicStaticResourcesPaths) {
                    if (!resourcePath.startsWith(staticResourcesPath)) continue;
                    String path = resourcePath.replace(staticResourcesPath, "");
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    event.updateClientResource("context://" + path, null);
                }
            });
        }
    }
}

