/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.communication.TransferUtil;
import com.vaadin.flow.server.streams.InMemoryUploadCallback;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferProgressAwareHandler;
import com.vaadin.flow.server.streams.UploadEvent;
import com.vaadin.flow.server.streams.UploadHandler;
import com.vaadin.flow.server.streams.UploadMetadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class InMemoryUploadHandler
extends TransferProgressAwareHandler<UploadEvent, InMemoryUploadHandler>
implements UploadHandler {
    private final InMemoryUploadCallback successCallback;

    public InMemoryUploadHandler(InMemoryUploadCallback successCallback) {
        this.successCallback = successCallback;
    }

    @Override
    public void handleUploadRequest(UploadEvent event) throws IOException {
        byte[] data;
        this.setTransferUI(event.getUI());
        try (InputStream inputStream = event.getInputStream();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(event), this.getListeners());
            data = outputStream.toByteArray();
        }
        catch (IOException e) {
            this.notifyError(event, e);
            throw e;
        }
        event.getUI().access(() -> {
            try {
                this.successCallback.complete(new UploadMetadata(event.getFileName(), event.getContentType(), event.getFileSize()), data);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error in memory upload callback", e);
            }
        });
    }

    @Override
    protected TransferContext getTransferContext(UploadEvent transferEvent) {
        return new TransferContext(transferEvent.getRequest(), transferEvent.getResponse(), transferEvent.getSession(), transferEvent.getFileName(), transferEvent.getOwningElement(), transferEvent.getFileSize());
    }
}

